/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.audit;

import com.mapr.audit.ExpandAuditLogCluster;
import org.apache.log4j.Logger;

public class ExpandAuditLogs {
    private static final Logger LOG = Logger.getLogger(ExpandAuditLogs.class);

    private static void printUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append("usage: expandaudit\n");
        builder.append("            [-volumename volume name]\n");
        builder.append("            [-volumeid volume ids. Either volume name");
        builder.append(" or id must be specified]\n");
        builder.append("            -o output directory\n");
        builder.append("            [-d Specify for deleted volumes only]\n");
        builder.append("            [-cluster cluster name]\n");
        builder.append("            [-t number of threads used for parallel");
        builder.append(" expansion across cluster nodes. default 10]\n");
        builder.append("For deleted volumes, user specified volume name will be used during expansion\n");
        System.out.println(builder.toString());
        LOG.info((Object)builder.toString());
    }

    static void LogErrorAndExit(String string) {
        LOG.error((Object)string);
        System.out.println(string);
        ExpandAuditLogs.printUsage();
        System.exit(1);
    }

    static void LogInfo(String string) {
        LOG.info((Object)string);
        System.out.println(string);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            ExpandAuditLogs.printUsage();
            System.exit(1);
        }
        String outputDir = "";
        String inputDir = "/var/mapr/local/";
        int volId = 0;
        String volName = "";
        String cluster = "";
        boolean vollistCheck = true;
        boolean expandToolLogs = false;
        int numThreads = 10;
        boolean deleted = false;
        boolean verbose = false;
        boolean printDiagnostics = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-d")) {
                deleted = true;
                continue;
            }
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-o")) {
                if (i != args.length - 1) {
                    outputDir = args[i + 1];
                    ++i;
                    continue;
                }
                ExpandAuditLogs.LogErrorAndExit("-o option requires an output directory where expanded audit logs stored");
                continue;
            }
            if (args[i].equals("-diagnose")) {
                printDiagnostics = true;
                continue;
            }
            if (args[i].equals("-volumeid")) {
                if (i != args.length - 1) {
                    try {
                        volId = Integer.parseInt(args[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException e) {
                        ExpandAuditLogs.LogErrorAndExit("Invalid value for -volumeid option = " + args[i + 1]);
                    }
                    continue;
                }
                ExpandAuditLogs.LogErrorAndExit("-volumeid option requires a volume Id");
                continue;
            }
            if (args[i].equals("-volumename")) {
                if (i != args.length - 1) {
                    volName = args[i + 1];
                    ++i;
                    continue;
                }
                ExpandAuditLogs.LogErrorAndExit("-volumename option requires a volume name");
                continue;
            }
            if (args[i].equals("-i")) {
                if (i != args.length - 1) {
                    inputDir = args[i + 1];
                    ++i;
                    continue;
                }
                ExpandAuditLogs.LogErrorAndExit("-i option requires an input directory for cluster audit logs location");
                continue;
            }
            if (args[i].equals("-cluster")) {
                if (i != args.length - 1) {
                    cluster = args[i + 1];
                    ++i;
                    continue;
                }
                ExpandAuditLogs.LogErrorAndExit("-cluster option requires cluster name");
                continue;
            }
            if (args[i].equals("-t")) {
                if (i != args.length - 1) {
                    try {
                        numThreads = Integer.parseInt(args[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException e) {
                        ExpandAuditLogs.LogErrorAndExit("Invalid value for -t option = " + args[i + 1]);
                    }
                    if (numThreads > 0) continue;
                    ExpandAuditLogs.LogErrorAndExit("Invalid number of threads for -t option = " + numThreads);
                    continue;
                }
                ExpandAuditLogs.LogErrorAndExit("-t option requires to specify number of threads in thread pool");
                continue;
            }
            if (args[i].equals("-vl")) {
                vollistCheck = false;
                continue;
            }
            if (args[i].equals("-expandtoollogs")) {
                expandToolLogs = true;
                continue;
            }
            ExpandAuditLogs.LogErrorAndExit("Unexpected arg = " + args[i]);
        }
        if (volId == 0 && volName.length() == 0) {
            ExpandAuditLogs.LogErrorAndExit("Atleast one of the args - volume id or name must be specified");
        }
        if (!deleted && volId != 0 && volName.length() != 0) {
            ExpandAuditLogs.LogErrorAndExit("Only one of the args - volume id or name must be specified");
        }
        if (outputDir.length() == 0) {
            ExpandAuditLogs.LogErrorAndExit("output directory must be specified");
        }
        ExpandAuditLogCluster expandAuditLogCluster = new ExpandAuditLogCluster();
        try {
            expandAuditLogCluster.initialize(outputDir, inputDir, volId, volName, vollistCheck, cluster, numThreads, deleted, verbose, expandToolLogs, printDiagnostics);
            expandAuditLogCluster.Phase1Expand();
            ExpandAuditLogs.LogInfo("Phase1 Audit Log Expansion Done. Starting Phase2");
            expandAuditLogCluster.Phase2Expand();
            expandAuditLogCluster.ShutDown();
            ExpandAuditLogs.LogInfo("Phase2 Audit Log Expansion Done. Exiting");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

