/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.VolumeCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.proto.Security;
import java.util.Map;
import org.apache.log4j.Logger;

public class VolumeDumpFileCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(VolumeDumpFileCommands.class);
    public static final String VOLUME_PARAM_NAME = "name";
    public static final String DUMP_FILE_NAME = "dumpfile";
    public static final String START_VOLUME_POINT_NAME = "s";
    public static final String END_VOLUME_POINT_NAME = "e";
    public static final String DUMP_FILE_ON_STDOUT = "o";
    public static final String DUMP_FILE_FROM_STDIN = "i";
    public static final String CREATE_NEW_VOLUME = "n";
    Security.CredentialsMsg srcCreds;
    Security.CredentialsMsg dstCreds;
    public static final String createDumpUsage = "volume dump create [-s startvolumepoint name] [-e endvolumepoint name] [-o (for dumpfile on stdout)]  -name volumename -dumpfile dumpfilename (ignored if -o specified) [-cluster clustername]";
    public static final String restoreDumpUsage = "volume dump restore [-i (read dumpfile from stdin)] [-n (create new volume if volume doesn't exist)] -name volumename -dumpfile dumpfile (ignored if -i specified)[-cluster clustername]";
    public static final CLICommand createDumpCommand = new CLICommand("create", "", VolumeDumpFileCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"s", (Object)new TextInputParameter("s", "start volumepoint name", false, null)).put((Object)"e", (Object)new TextInputParameter("e", "end volumepoint name", false, null)).put((Object)"o", (Object)new TextInputParameter("o", "(generate dumpfile on stdout)", false, null)).put((Object)"dumpfile", (Object)new TextInputParameter("dumpfile", "dumpfilename (not needed if -o is used)", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "volumename", true, null)).build(), null).setShortUsage("volume dump create [-s startvolumepoint name] [-e endvolumepoint name] [-o (for dumpfile on stdout)]  -name volumename -dumpfile dumpfilename (ignored if -o specified) [-cluster clustername]");
    public static final CLICommand restoreDumpCommand = new CLICommand("restore", "", VolumeDumpFileCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"i", (Object)new TextInputParameter("i", "(read dumpfile from stdin)", false, null)).put((Object)"n", (Object)new TextInputParameter("n", "(create new volume if it doesn't exist)", false, null)).put((Object)"dumpfile", (Object)new TextInputParameter("dumpfile", "dumpfilename (not needed if -i is used)", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "volumename", true, null)).build(), null).setShortUsage("volume dump restore [-i (read dumpfile from stdin)] [-n (create new volume if volume doesn't exist)] -name volumename -dumpfile dumpfile (ignored if -i specified)[-cluster clustername]");
    public static CLICommand[] dumpCommandsArray = new CLICommand[]{createDumpCommand, restoreDumpCommand};
    public static CLICommand dumpCommands = new CLICommand("dump", "dump", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, dumpCommandsArray).setShortUsage("dump [create|restore]");

    public VolumeDumpFileCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ExecuteRealCommand" + this.cliCommand.getCommandName()));
        }
        this.init();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create2")) {
            try {
                return this.createDump();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Create dump Exception ", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("restore")) {
            try {
                return this.restoreDump();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Restore dump Exception", (Throwable)e);
            }
        }
        return null;
    }

    private CommandOutput createDump() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(VOLUME_PARAM_NAME, 0);
        String dumpDir = this.getParamTextValue(DUMP_FILE_NAME, 0);
        LOG.info((Object)("Creating dumpfile for volume " + volumeName + " in dump directory " + dumpDir));
        Security.CredentialsMsg.Builder srccreds = Security.CredentialsMsg.newBuilder();
        srccreds.setUid(0);
        srccreds.addGids(0);
        Security.CredentialsMsg.Builder destcreds = Security.CredentialsMsg.newBuilder();
        destcreds.setUid(0);
        destcreds.addGids(0);
        return output;
    }

    private CommandOutput restoreDump() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(VOLUME_PARAM_NAME, 0);
        String dumpDir = this.getParamTextValue(DUMP_FILE_NAME, 0);
        System.out.println("Restore volume " + volumeName + " from dumpfile in directory " + dumpDir);
        return output;
    }

    void init() throws CLIProcessingException {
        this.srcCreds = this.getUserCredentials();
        this.dstCreds = this.getUserCredentials();
    }
}

