/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BitSetBytesHelperUtils;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.fsrpcutils.FSRpcUtils;
import com.mapr.baseutils.fsrpcutils.GetMsgStatus;
import com.mapr.baseutils.s3serverutils.S3ServerRpcCommonUtils;
import com.mapr.baseutils.utils.ACL;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.baseutils.utils.GetStringsForAuditOps;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.AclCommands;
import com.mapr.cli.FileFilterCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.OffloadRuleCommands;
import com.mapr.cli.SnapshotCommands;
import com.mapr.cli.TierCommands;
import com.mapr.cli.VolumeContainerCommands;
import com.mapr.cli.VolumeDumpFileCommands;
import com.mapr.cli.VolumeLinkCommands;
import com.mapr.cli.VolumeMirrorCommands;
import com.mapr.cli.bulk.TaskCompletionService;
import com.mapr.cli.bulk.VolumeRemoveTask;
import com.mapr.cli.bulk.VolumeUnMountTask;
import com.mapr.cli.common.AuthManager;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.PluggableAlarmUtil;
import com.mapr.cli.common.VolumeField;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.PermissionsManager;
import com.mapr.fs.cldb.VolumeUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldbs3server.store.S3ServerGetMsgStatus;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.CLDBS3ServerProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.PolicyServerProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class VolumeCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(VolumeCommands.class);
    private static final int MB = 0x100000;
    private static final int NUM_VOLUMES_PER_RPC = 512;
    static PermissionsManager procPermsManager = PermissionsManager.getInstance();
    private static final int VOLUME_OP_DELAY = 2;
    private static final int VOLUME_OP_ATTEMPTS = 60;
    public static final String RW_VOLUME_PARAM_OP_NODELAY = "nodelay";
    public static final String RW_VOLUME_PARAM_NAME = "name";
    public static final String RW_VOLUME_PARAM_NEW_NAME = "newname";
    public static final String RW_VOLUME_PARAM_TENANT_USER = "tenantuser";
    public static final String RW_VOLUME_PARAM_MOUNTDIR = "path";
    public static final String RW_VOLUME_PARAM_MOUNT = "mount";
    public static final String RW_VOLUME_PARAM_CREATE_PARENT = "createparent";
    public static final String RW_VOLUME_PARAM_REPLICATION = "replication";
    public static final String RW_VOLUME_PARAM_MIN_REPLICATION = "minreplication";
    public static final String RW_VOLUME_PARAM_DCREPLTYPE = "replicationtype";
    public static final String RW_VOLUME_PARAM_NAMESPACE_REPLICATION = "nsreplication";
    public static final String RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION = "nsminreplication";
    public static final String RW_VOLUME_ENFORCE_MIN_REPLICATION = "enforceminreplicationforio";
    public static final String RW_VOLUME_PARAM_READONLY = "readonly";
    public static final String RW_VOLUME_PARAM_MIRRORTHROTTLE = "mirrorthrottle";
    public static final String RW_VOLUME_PARAM_LOCALVOLUMEHOST = "localvolumehost";
    public static final String RW_VOLUME_PARAM_LOCALVOLUMEPORT = "localvolumeport";
    public static final String RW_VOLUME_PARAM_SHUFFLEVOLUME = "shufflevolume";
    public static final String RW_VOLUME_PARAM_FORCE = "force";
    public static final String RW_VOLUME_PARAM_AETYPE = "aetype";
    public static final String RW_VOLUME_PARAM_AE = "ae";
    public static final String RW_VOLUME_PARAM_QUOTA = "quota";
    public static final String RW_VOLUME_PARAM_ADVISORY_QUOTA = "advisoryquota";
    public static final String RW_VOLUME_PARAM_TOPOLOGY = "topology";
    public static final String RW_VOLUME_PARAM_TIERING = "tieringenable";
    public static final String RW_VOLUME_PARAM_AUTO_CREATE_EC_TIER = "ecenable";
    public static final String RW_VOLUME_PARAM_TIER_NAME = "tiername";
    public static final String RW_VOLUME_PARAM_TIER_ENCRYPTION = "tierencryption";
    public static final String RW_VOLUME_PARAM_TIER_KEY = "tierkey";
    public static final String RW_VOLUME_PARAM_OFFLOAD_SCHEDULEID = "offloadschedule";
    public static final String RW_VOLUME_PARAM_COMPACTION_SCHEDULEID = "compactionschedule";
    public static final String RW_VOLUME_PARAM_COMPACTION_OVERHEAD = "compactionoverheadthreshold";
    public static final String RW_VOLUME_PARAM_TIERING_RULE = "tieringrule";
    public static final String RW_VOLUME_PARAM_RECALL_EXPIRY_TIME = "recallexpirytime";
    public static final String RW_VOLUME_PARAM_TOTAL_DATA = "totaldata";
    public static final String RW_VOLUME_PARAM_TOTAL_PURGED = "totalpurged";
    public static final String RW_VOLUME_PARAM_TOTAL_RECALLED = "totalrecall";
    public static final String RW_VOLUME_PARAM_ECSCHEME = "ecscheme";
    public static final String RW_VOLUME_PARAM_ECTOPOLOGY = "ectopology";
    public static final String RW_VOLUME_PARAM_ECLABEL = "eclabel";
    public static final String RW_VOLUME_PARAM_HONORRACKRELIABILITY = "honorrackreliability";
    public static final String MIRROR_VOLUME = "type";
    public static final String MIRROR_VOLUME_SRC_VOLUMENAME = "source";
    public static final String RW_VOLUME_ROOT_DIR_PERM = "rootdirperms";
    public static final String RW_VOLUME_ROOT_DIR_USER = "rootdiruser";
    public static final String RW_VOLUME_ROOT_DIR_GROUP = "rootdirgroup";
    public static final String RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC = "rereplicationtimeoutsec";
    public static final String RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC = "criticalrereplicationtimeoutsec";
    public static final String RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD = "maxinodesalarmthreshold";
    public static final String RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD = "maxnssizembalarmthreshold";
    public static final String RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH = "dbrepllagsecalarmthresh";
    public static final String RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH = "dbindexlagsecalarmthresh";
    public static final String RW_FIX_CREATOR_ID = "fixcreatorid";
    public static final String RW_VOLUME_PARAM_CONTAINER_ALLOCATION_FACTOR = "containerallocationfactor";
    public static final String RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL = "atimeUpdateInterval";
    public static final String RW_VOLUME_PARAM_S3_DELETE_BUCKET = "deletes3bucket";
    public static final String EC_STRIPE_DEPTH_MB = "ecstripedepthmb";
    public static final String EC_CONTAINER_SIZE_MB = "eccontainersizemb";
    public static final String AUTO_OFFLOAD_THRESHOLD_GB = "autooffloadthresholdgb";
    public static final String PRESERVE_VOLUME = "preserve";
    public static final String CHECKIN_TIME_MIN = "commitTime";
    public static final String RETENTION_PERIOD_DAYS = "retain";
    public static final String ADD_VOLUME_NOTE = "addNote";
    public static final String RESOLVE_VOLUME_NOTE = "resolveNote";
    public static final String NOTE_COMMENT = "comment";
    public static final String USERPERM_PARAM_NAME = "user";
    public static final String GROUPPERM_PARAM_NAME = "group";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String SORT_PARAM_NAME = "sort";
    public static final String SORTBY_PARAM_NAME = "sortby";
    public static final String SORTING_ORDER_PARAM_NAME = "sortorder";
    public static final String ASCENDING_SORTING_ORDER_PARAM_NAME = "asc";
    public static final String DESCENDING_SORTING_ORDER_PARAM_NAME = "desc";
    public static final String SORT_DIRECTION_PARAM_NAME = "dir";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String ALARMEDVOLUMES_PARAM_NAME = "alarmedvolumes";
    public static final String RW_VOLUME_NODES = "nodes";
    public static final String VOLUME_LIMIT_SPREAD = "limitspread";
    public static final String ALLOW_GRANT = "allowgrant";
    public static final String INHERIT_SOURCE = "inherit";
    public static final String ALLOW_INHERIT = "allowinherit";
    public static final String SKIP_INHERIT = "skipinherit";
    public static final String VOLUME_SCHEDULE = "schedule";
    public static final String VOLUME_MIRROR_SCHEDULE = "mirrorschedule";
    public static final String MULTI_ARG_SEP = ",";
    public static final String REPL_TYPE_STAR = "low_latency";
    public static final String REPL_TYPE_CASCADE = "high_throughput";
    public static final String REPL_TYPE_UNKNOWN = "unknown";
    private final int VOLUME_ON_FILESERVER_TIMEOUT_SEC = 60;
    private static int MAX_VOLUMEFIELDINFO = 0;
    public static final String VOL_READACE_PARAM = "readAce";
    public static final String VOL_WRITEACE_PARAM = "writeAce";
    public static final String AUDIT_VOLUME = "isauditvolume";
    public static final String VOLUME_AUDIT_ENABLED = "enabled";
    public static final String VOLUME_FORCE_AUDIT_ENABLE = "forceenable";
    public static final String AUDIT_ENABLED = "auditenabled";
    public static final String FORCE_AUDIT_ENABLE = "forceauditenable";
    public static final String AUDIT_COALESCE_INTERVAL = "coalesce";
    public static final String FSAUDIT_OPS = "dataauditops";
    public static final String DISABLE_DATA_AUDIT_OPS_PARAM = "disabledataauditops";
    public static final String WIRE_SECURITY_ENABLED = "wiresecurityenabled";
    public static final String SKIP_WIRE_SECURITY_FOR_INTERNAL_OP = "skipwiresecurityfortierinternalops";
    private static final String NUM_ACTIVE_CG_CONTAINERS = "numactivecgcontainers";
    private static final String DATA_LABEL = "label";
    public static final String NAMESPACE_LABEL = "nslabel";
    public static final String PBS_SECURITY_POLICY = "securitypolicy";
    public static final String ROOT_DIR_SECURITY_POLICY = "rootdirsecuritypolicy";
    public static final String PBS_ENFORCEMENT_MODE = "enforcementmode";
    public static final String FILTER_EXTENSION = "filefilter";
    public static final String Allow_S3_BUCKETS = "allows3buckets";
    public static final String Allow_S3_WORM_BUCKETS = "allows3wormbuckets";
    public static final String NAME_CONTAINER_DATA_THRESHOLD = "namecontainerdatathreshold";
    public static final String METRICS_ENABLED = "metricsenabled";
    public static final String DARE_ENABLED = "dare";
    public static final String ALL_VOLUMES_PARAM_NAME = "allvolumes";
    public static final String ALLOW_READ_FOR_EXECUTE = "allowreadforexecute";
    public static final String OBJ_STORE_ACCOUNT_ID = "objectstoreaccountid";
    public static final String S3_ACCOUNTS_ROOT = "s3accountsroot";
    public static final String volumeRemoveUsage = "volume remove -name volumeName [-cluster clustername -force <true|false> -filter <filters>]";
    public static final String volumeMoveUsage = "volume move -name volumeName[-cluster clustername] [-ectopology ecTopology] [-eclabel <label name>][-topology topology] [-label <label name>][-nslabel <label name>]";
    public static final String volumeRenameUsage = "volume rename -name volumeNmae -newname newVolName [-cluster clustername]";
    public static final String volumeUpgradeformatUsage = "volume upgradeformat -name volumeNames";
    public static final String dataAceUsageString = "-readAceaceexpression-writeAceaceexpression";
    public static final Map<String, Common.VolumeActions> volumeAceParameterMap = new ImmutableMap.Builder().put((Object)"readAce", (Object)Common.VolumeActions.VOLUME_READ).put((Object)"writeAce", (Object)Common.VolumeActions.VOLUME_WRITE).build();
    public static final String clearDareUsage = "volume cleardare [-cluster cluster_name ] [-name comma seperated volume names ] [-allvolumes]";
    public static final String volumeModifyUsage = "volume modify -name volumeName [-replication <repl> -minreplication <minrepl> -readonly <false|true> -nsreplication <repl> -nsminreplication <minrepl> -enforceminreplicationforio <true|false>-cluster clustername -mirrorthrottle <false|true> -user <space separated list of username:permission,permission,.. to be set or username:none to remove acl for username>-group <space separated list of groupname:permission,permission,.. to be set or username:none to remove acl for groupname>-readAceaceexpression-writeAceaceexpression-source <sourcevol@sourcecluster>-aetype <0(user)|1(group)> -ae <name>-maxinodesalarmthreshold <val> -dbrepllagsecalarmthresh <val>]-dbindexlagsecalarmthresh <val>]-quota <val> -advisoryquota <val> -maxnssizembalarmthreshold <val>-limitspread <true|false> -type type of volume: rw or mirror]-allowgrant <true|false> [-auditenabled <true|false> ][-forceauditenable <true|false> ][-coalesce <val in mins> ][-wiresecurityenabled <true|false> ][-skipwiresecurityfortierinternalops <true|false> ][-rereplicationtimeoutsec <val in sec> ][-criticalrereplicationtimeoutsec <val in sec> ][-metricsenabled <true|false> ][-namecontainerdatathreshold<+ve in MB, default:0>][-ecscheme<ec scheme>][-honorrackreliability <true|false> ][-numactivecgcontainers<num_containers_to_be_assigned>][-atimeUpdateInterval<atime update interval in days, default: 0>][-allowreadforexecute Enable reads for files with execute permission. <true|false> ][-securitypolicy<comma separated security policy tags>[-enforcementmode<PolicyAceAndDataAce|PolicyAceOnly|DataAceOnly|PolicyAceAuditAndDataAce default:PolicyAceAndDataAce>[-filefilter<file filter>";
    public static final String volumeListUsage = "volume list [-filter <filters>][-cluster clustername]";
    public static final String volumeInfoUsage = "volume info -volumename volName";
    public static final String ecTierUsage = "[-tiername <ectier>  [-ectopology [topo>] [-ecscheme <ecscheme>] ";
    public static final String volumeCreateUsage = "volume create -name volumeName [-path mountDir -mount <true|false> -createparent <false|true> -replication <repl> -minreplication <minrepl> -readonly <false|true> -nsreplication <repl> -nsminreplication <minrepl> -enforceminreplicationforio <true|false>-cluster clustername -localvolumehost fileserverhost -mirrorthrottle <false|true> -localvolumeport fileserverport -user <space separated list of user:permissions,perimssions,.. to be set>-group <space separated list of group:permissions,permissions,.. to be set>-readAceaceexpression-writeAceaceexpression-aetype <0(user)|1(group)> -ae aename-quota <quotaval> -advisoryquota <val> -maxinodesalarmthreshold <val> -maxnssizembalarmthreshold <val> -dbrepllagsecalarmthresh <val> -dbindexlagsecalarmthresh <val> -type type of volume: normal(0) or mirror(1) -source <srcvolume@srccluster> -limitspread <true|false> -rootdirperms 0777][-allowgrant <true|false> ][-inherit <existing volume name> ][-allowinherit <true|false> ][-skipinherit property not to inherit ][-auditenabled <true|false> ][-forceauditenable <true|false> ][-coalesce <val in mins> ][-wiresecurityenabled <true|false> ][-skipwiresecurityfortierinternalops <true|false> ][-metricsenabled <true|false> ][-dare Enable Data at rest encryption for volume. <true|false> ][-containerallocationfactor<+ve integer, default:0>[-namecontainerdatathreshold<+ve in MB, default:0>[-tiername <ectier>  [-ectopology [topo>] [-ecscheme <ecscheme>] [-honorrackreliability <true|false> ][-numactivecgcontainers<num_containers_to_be_assigned>][-labelstorage class on which the volume data should reside[-nslabelstorage class on which the volume's name container should reside[-atimeUpdateInterval<atime update interval in days, default: 0>][-allowreadforexecute Enable reads for files with execute permission. <true|false> ][-securitypolicy<comma separated security policy tags>[-rootdirsecuritypolicy <comma separated security policy tags> ][-enforcementmode<PolicyAceAndDataAce|PolicyAceOnly|DataAceOnly|PolicyAceAuditAndDataAce default:PolicyAceAndDataAce>[-filefilter<file filter>[-allows3buckets<true|false>[-allows3wormbuckets<true|false>";
    public static final String volumeAuditUsage = "volume audit -name volumeName [-enabled <true|false> ] [-coalesce in mins][-enabledataaudit <list of data audit operations>[-disabledataaudit <list of data audit operations>";
    public static final String volumeUnMountUsage = "volume unmount -name volumeName [-cluster clustername]";
    public static final String volumeShowMountsUsage = "volume showmounts -name volumeName [-cluster clustername]";
    public static final String volumeMountUsage = "volume mount -name volumeName -path mountDir [-createparent <false|true> -cluster clustername]";
    public static final String volumeFixMntPathUsage = "volume fixmountpath -name volumeName [-cluster clustername]";
    public static final String volumeBalanceUsage = "volume balancecontainers -name volumeName [-cancel true|false]";
    public static final String volumeBalancingInfoUsage = "volume balancinginfo [-name volumeName]";
    public static final String volumeFixPromotedVolume = "volume fixpromotedvolume -name volumeName [-cluster clustername]";
    public static Map<VolumeField, FieldInfo> fieldTable;
    public static ImmutableMap.Builder<VolumeField, FieldInfo> fieldTableBuilder;
    public static Map<String, BaseInputParameter> baseParams;
    public static Map<String, BaseInputParameter> aclParams;
    public static final CLICommand volumeAuditCommand;
    public static final CLICommand volumeUnMountCommand;
    public static final CLICommand volumeShowMountsCommand;
    public static final CLICommand volumeMountCommand;
    public static final CLICommand volumeCreateCommand;
    static String supportedSortKeys;
    static Map<String, CLDBProto.ListSortKey> nameToEnumMap;
    public static final CLICommand[] volumeCommands;
    UnixUserGroupHelper uInfo;
    int maxVolumeReplicationFactor;
    private List<CLDBProto.VolumeInfo> listedVolumes = Lists.newArrayList();
    private AuthManager authManager = AuthManager.getInstance();

    static ImmutableMap<String, BaseInputParameter> getBalanceContainersCmdMap() {
        return new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)"cancel", (Object)new BooleanInputParameter("cancel", "<true|false>", false, Boolean.valueOf(false))).build();
    }

    static ImmutableMap<String, BaseInputParameter> getBalancingInfoCmdMap() {
        return new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", false, null)).build();
    }

    void init() throws CLIProcessingException {
        this.uInfo = new UnixUserGroupHelper();
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while initializing RPC " + e));
            throw new CLIProcessingException("Exception in Rpc.initialize " + e);
        }
        fieldTable = PluggableAlarmUtil.appendVolumeMap(this.getUserCredentials(), fieldTableBuilder);
        MAX_VOLUMEFIELDINFO = PluggableAlarmUtil.getMaxNumNodes(this.getUserCredentials(), MAX_VOLUMEFIELDINFO);
        this.maxVolumeReplicationFactor = Common.MapRClusterDefaults.getDefaultInstance().getMaxVolumeReplication();
    }

    private byte[] StringToHex(String s) {
        int length = s.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            data[i / 2] = (byte)((Integer.parseInt(s.substring(i, i + 1), 16) << 4) + Integer.parseInt(s.substring(i + 1, i + 2), 16));
            LOG.error((Object)("str " + s.charAt(i) + s.charAt(i + 1) + " byte " + data[i / 2]));
        }
        return data;
    }

    private boolean sleepAndCheckMountedDir(MapRFileSystem fs, String cluster, String dir) {
        Object fullDir = dir;
        if (cluster != null && !dir.startsWith("maprfs://")) {
            fullDir = "maprfs://" + cluster + ":" + dir;
        }
        Path fullPath = new Path((String)fullDir);
        for (int nAttempts = 0; nAttempts < 60; ++nAttempts) {
            try {
                FileStatus fStatus = fs.getFileStatus(fullPath);
                if (fStatus != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private List<String> getUserGroupsNames(List<String> perms) {
        ArrayList permissions = new ArrayList();
        ArrayList<String> userGroups = new ArrayList<String>();
        for (String perm : perms) {
            Collections.addAll(permissions, perm.split(" "));
        }
        for (String perm : permissions) {
            List<String> userPerm = Arrays.asList(perm.split(AclCommands.ALLOW_MASK_SEP));
            userGroups.add(userPerm.get(0));
        }
        return userGroups;
    }

    private Common.ContainerReplType getContainerReplType(String type) {
        if (type.equalsIgnoreCase(REPL_TYPE_STAR)) {
            return Common.ContainerReplType.STAR;
        }
        if (type.equalsIgnoreCase(REPL_TYPE_CASCADE)) {
            return Common.ContainerReplType.CASCADE;
        }
        return Common.ContainerReplType.INVALID;
    }

    private String getContainerReplTypeString(Common.ContainerReplType type) {
        if (type == Common.ContainerReplType.STAR) {
            return REPL_TYPE_STAR;
        }
        if (type == Common.ContainerReplType.CASCADE) {
            return REPL_TYPE_CASCADE;
        }
        return REPL_TYPE_UNKNOWN;
    }

    public VolumeCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            try {
                if (!this.getParamTextValue(FILTER_PARAM_NAME, 0).equals("none")) {
                    return this.removeFilteredVolumes();
                }
                return this.volumeRemove();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("move")) {
            try {
                return this.moveVolume();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("audit")) {
            try {
                return this.volumeModify();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rename")) {
            try {
                return this.volumeRename();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("upgradeformat")) {
            try {
                return this.volumeUpgradeformat();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            try {
                String sortbyStr;
                CLDBProto.ListSortKey sortKey;
                CommandOutput output = new CommandOutput();
                CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
                output.setOutput(out);
                if (!super.validateInput()) {
                    return output;
                }
                if (this.isParamPresent(ALARMEDVOLUMES_PARAM_NAME) && this.getAlarmedVolumesParamValue() && this.isParamPresent(RW_VOLUME_NODES) && !this.getParamTextValue(RW_VOLUME_NODES, 0).isEmpty()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot use both -alarmedvolumes and -nodes parameters."));
                    return output;
                }
                if (this.isParamPresent(SORTBY_PARAM_NAME) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0)).toLowerCase())) == null) {
                    LOG.error((Object)("failed to list sorted volumes, " + sortbyStr + " is not a valid keyword to sort volumes."));
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
                    return output;
                }
                if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                    if (!this.isParamPresent(SORTBY_PARAM_NAME)) {
                        String msg = "Invalid use of sortorder. Must be used with sortby";
                        LOG.error((Object)msg);
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                        return output;
                    }
                    String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                    if (!sortOrder.equalsIgnoreCase(ASCENDING_SORTING_ORDER_PARAM_NAME) && !sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                        String msg = "Invalid value for sortorder. Valid values are asc and desc";
                        LOG.error((Object)msg);
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                        return output;
                    }
                }
                this.list(out);
                return output;
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("info")) {
            try {
                return this.volumeInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("modify")) {
            try {
                return this.volumeModify();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("cleardare")) {
            try {
                return this.updateDare();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.volumeCreate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("unmount")) {
            try {
                return this.volumeUnMount();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(RW_VOLUME_PARAM_MOUNT)) {
            try {
                return this.volumeMount();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("showmounts")) {
            try {
                return this.volumeShowMounts();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("fixmountpath")) {
            try {
                return this.volumeFixMountPath();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("balancecontainers")) {
            try {
                return this.sendVolumeBalanceRequest();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("balancinginfo")) {
            try {
                return this.sendVolumeBalancingInfoRequest();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("fixpromotedvolume")) {
            try {
                return this.volumeFixPromotedVolume();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("Volume command failed".getBytes());
    }

    private CommandOutput sendVolumeBalanceRequest() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String volumeName = this.getRwVolumeName();
        if (volumeName == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing volume name in volume balance request"));
            return output;
        }
        boolean cancelVolumeBalancing = false;
        if (this.isParamPresent("cancel")) {
            cancelVolumeBalancing = this.getParamBooleanValue("cancel", 0);
        }
        CLDBProto.VolumeBalanceRequest request = CLDBProto.VolumeBalanceRequest.newBuilder().setVolumeName(volumeName).setCancelRequest(cancelVolumeBalancing).build();
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeBalanceProc.getNumber(), (MessageLite)request, CLDBProto.VolumeBalanceResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeBalanceProc.getNumber(), (MessageLite)request, CLDBProto.VolumeBalanceResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response to volume balance request...check cldb logs"));
                return output;
            }
            CLDBProto.VolumeBalanceResponse resp = CLDBProto.VolumeBalanceResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                this.formatVolumeBalanceRequestMessage(volumeName, out, cancelVolumeBalancing);
            } else if (resp.hasMessage()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getMessage()));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException: ", (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Volume Balance: Operation failed: " + e;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
        }
        return output;
    }

    private void formatVolumeBalanceRequestMessage(String volumeName, CommandOutput.OutputHierarchy out, boolean cancelVolumeBalancing) {
        if (cancelVolumeBalancing) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Submitted request to cancel balancing of volume " + volumeName));
        } else {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Submitted request to balance volume " + volumeName));
        }
    }

    private CommandOutput sendVolumeBalancingInfoRequest() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.VolumeBalanceRequest.Builder requestBuilder = CLDBProto.VolumeBalanceRequest.newBuilder().setOp(CLDBProto.VolumeBalanceOp.BALANCING_INFO_REQUEST);
        String volumeName = this.getRwVolumeName();
        if (volumeName != null) {
            requestBuilder.setVolumeName(volumeName);
        }
        byte[] data = null;
        try {
            LOG.info((Object)"Sending volume balancing info request");
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeBalanceProc.getNumber(), (MessageLite)requestBuilder.build(), CLDBProto.VolumeBalanceResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeBalanceProc.getNumber(), (MessageLite)requestBuilder.build(), CLDBProto.VolumeBalanceResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response to volume balancinginfo request...check cldb logs"));
                return output;
            }
            CLDBProto.VolumeBalanceResponse resp = CLDBProto.VolumeBalanceResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                this.formatBalancingInfo(resp, out);
            } else if (resp.hasMessage()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "return code: " + resp.getStatus() + " " + resp.getMessage()));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException: ", (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Request for volume Balancing info failed: " + e.getMessage();
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
        }
        return output;
    }

    private CommandOutput.OutputHierarchy formatBalancingInfo(CLDBProto.VolumeBalanceResponse resp, CommandOutput.OutputHierarchy out) {
        LOG.info((Object)"Formatting volume balancing info");
        if (!resp.hasBalancingView()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(74, "Missing volume balancing info in the response"));
            return out;
        }
        CLDBProto.VolumeBalancingView balancingInfo = resp.getBalancingView();
        if (!balancingInfo.hasVolumeName()) {
            CommandOutput.OutputHierarchy.OutputNode volumeIds = new CommandOutput.OutputHierarchy.OutputNode("Volume(s) Being Balanced");
            for (Integer volumeId : balancingInfo.getVolumesBeingBalancedList()) {
                volumeIds.addChild(new CommandOutput.OutputHierarchy.OutputNode("volumeId", (Object)volumeId));
            }
            out.addNode(volumeIds);
            return out;
        }
        return this.formatVolumeBalancingInfo(balancingInfo, out);
    }

    private CommandOutput.OutputHierarchy formatVolumeBalancingInfo(CLDBProto.VolumeBalancingView balancingInfo, CommandOutput.OutputHierarchy out) {
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("volumeName", (Object)balancingInfo.getVolumeName()));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("isBalancingInProgress", (Object)balancingInfo.getIsBalancingInProgress()));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("numContainers", balancingInfo.getNumContainers()));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("volumeSize", balancingInfo.getVolumeSize()));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("topoCapacity", balancingInfo.getTopoCapacity()));
        for (CLDBProto.SPBalancingInfo spInfo : balancingInfo.getSpInfoList()) {
            out.addNode(this.formatSpBalancingInfo(spInfo));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatSpBalancingInfo(CLDBProto.SPBalancingInfo spInfo) {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode("spInfo");
        node.addNode(new CommandOutput.OutputHierarchy.OutputNode("spId", (Object)spInfo.getSpId()));
        node.addNode(new CommandOutput.OutputHierarchy.OutputNode("capacity", spInfo.getCapacity()));
        node.addNode(new CommandOutput.OutputHierarchy.OutputNode("usedSize", spInfo.getUsedSize()));
        node.addNode(new CommandOutput.OutputHierarchy.OutputNode("desiredSize", spInfo.getDesiredSize()));
        node.addNode(new CommandOutput.OutputHierarchy.OutputNode("isUnderweight", (Object)spInfo.getIsUnderweight()));
        node.addNode(new CommandOutput.OutputHierarchy.OutputNode("isOverweight", (Object)spInfo.getIsOverweight()));
        if (spInfo.hasLabel()) {
            node.addNode(new CommandOutput.OutputHierarchy.OutputNode(DATA_LABEL, (Object)spInfo.getLabel()));
        }
        return node;
    }

    public boolean validateInput() throws IllegalArgumentException {
        if (this.cliCommand.getCommandName().equals("remove")) {
            return this.input.getAllParameters().size() > 1 && super.validateInput();
        }
        return super.validateInput();
    }

    CommandOutput volumeMount() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = this.getRwVolumeName();
        ArrayList<String> volumeNames = new ArrayList<String>();
        ArrayList<String> mountedVolumePaths = new ArrayList<String>();
        if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(rwVolumeName);
        } else if (rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem(this.getUserLoginId());
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        for (String volName : volumeNames) {
            int status;
            CLDBProto.VolumeProperties volProps;
            if (volName.equals(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName())) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot mount root volume " + volName + " " + Errno.toString((int)22)));
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to mount volume " + volName));
            }
            String rwVolumeMountDir = null;
            if (this.isParamPresent(RW_VOLUME_PARAM_MOUNTDIR)) {
                rwVolumeMountDir = this.getParamTextValue(RW_VOLUME_PARAM_MOUNTDIR, 0).replaceAll("\\/+$", "");
            }
            if ((volProps = this.volumePropetiesLookup(volName)) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + volName + ", " + Errno.toString((int)2)));
                LOG.error((Object)("VolumeMount : Could not find volume properties for " + volName));
                continue;
            }
            if (volProps.getMounted()) {
                LOG.warn((Object)("VolumeMount : Volume already mounted at " + volProps.getMountDir()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, volName + " " + Errno.toString((int)22) + " already mounted"));
                continue;
            }
            if (rwVolumeMountDir == null) {
                rwVolumeMountDir = volProps.getMountDir();
            }
            if (!MapRCliUtil.parentDirExists(fs, cluster, rwVolumeMountDir)) {
                if (this.getParamBooleanValue(RW_VOLUME_PARAM_CREATE_PARENT, 0)) {
                    if (!MapRCliUtil.createParentDir(fs, cluster, rwVolumeMountDir)) {
                        LOG.error((Object)("Volume Mount: Volume " + volName + ", failed to mount, could not create parent directory for mount dir " + rwVolumeMountDir));
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + volName + ", could not create parent directory for mount dir " + rwVolumeMountDir));
                        continue;
                    }
                } else {
                    LOG.error((Object)("Volume Mount: Volume " + volName + " parent of mount dir " + rwVolumeMountDir + " does not exist"));
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + volName + ", parent of mount dir " + rwVolumeMountDir + " does not exist, " + Errno.toString((int)2)));
                    continue;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Mounting volume " + volName + " at " + rwVolumeMountDir));
            }
            if ((status = fs.mountVolume(cluster, volName, rwVolumeMountDir, this.getUserLoginId())) == 0) {
                mountedVolumePaths.add(rwVolumeMountDir);
                continue;
            }
            if (status == 10019) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Failed to mount volume " + rwVolumeName + ", snapshot restore operation is in progress"));
                LOG.error((Object)("Unable to mount volume " + volName + " at " + rwVolumeMountDir + ", snapshot restore operation is in progress"));
                continue;
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Failed to mount volume " + rwVolumeName + ", " + Errno.toString((int)status)));
            LOG.error((Object)("Unable to mount volume " + volName + " at " + rwVolumeMountDir));
        }
        if (!mountedVolumePaths.isEmpty() && !this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
            for (String dir : mountedVolumePaths) {
                if (this.sleepAndCheckMountedDir(fs, cluster, dir)) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume mount for " + dir + " failed, Could not get status of mount path"));
            }
        }
        return output;
    }

    CommandOutput volumeShowMounts() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(RW_VOLUME_PARAM_NAME, 0);
        byte[] data = null;
        CLDBProto.VolumeShowMountsRequest volShowMountsReq = CLDBProto.VolumeShowMountsRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
        try {
            CommandOutput.OutputHierarchy.OutputNode cOut;
            CLDBProto.VolumeShowMountsResponse resp;
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeShowMountsProc.getNumber(), (MessageLite)volShowMountsReq, CLDBProto.VolumeShowMountsResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeShowMountsProc.getNumber(), (MessageLite)volShowMountsReq, CLDBProto.VolumeShowMountsResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. volumeShowMounts response null for volume " + volumeName));
                LOG.error((Object)("VolumeShowMounts response null for volume " + volumeName));
            }
            if ((resp = CLDBProto.VolumeShowMountsResponse.parseFrom((byte[])data)).getStatus() == 0) {
                cOut = new CommandOutput.OutputHierarchy.OutputNode();
                CommandOutput.OutputHierarchy.OutputNode mountedVolumes = new CommandOutput.OutputHierarchy.OutputNode("MountedVolumes");
                cOut.addChild(mountedVolumes);
                for (String volName : resp.getVolumesList()) {
                    mountedVolumes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Name", (Object)volName));
                }
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume ShowMounts: " + Errno.toString((int)resp.getStatus())));
                LOG.error((Object)("ShowMounts of volume failed, " + Errno.toString((int)resp.getStatus())));
                return output;
            }
            out.addNode(cOut);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume showMounts:  Operation failed"));
            LOG.error((Object)("Exception during volume show Mounts" + e));
            return output;
        }
        return output;
    }

    CommandOutput volumeUnMount() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> volumeNames = new ArrayList<String>();
        String rwVolumeName = this.getRwVolumeName();
        if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(rwVolumeName);
        } else if (rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        }
        boolean forceUnMount = false;
        if (this.isParamPresent(RW_VOLUME_PARAM_FORCE)) {
            forceUnMount = this.getParamBooleanValue(RW_VOLUME_PARAM_FORCE, 0);
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        boolean unmountedOne = false;
        for (String volName : volumeNames) {
            CLDBProto.TierRelationships tr;
            CLDBProto.VolumeProperties volProps = this.volumePropetiesLookup(volName, false);
            if (volProps == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Cannot find volume properties for " + volName + " " + Errno.toString((int)2)));
                LOG.error((Object)("VolumeUnmount : Could not find volume properties for " + volName));
                continue;
            }
            if (volProps.hasTierRelationships() && (tr = volProps.getTierRelationships()).hasBackendVolumeType() && tr.hasFrontendVolumeId()) {
                LOG.warn((Object)("VolumeUnmount : Volume " + volName + " is backend volume. Invalid to unmount."));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume " + volName + " is backend volume. Invalid to unmount backend volume. " + Errno.toString((int)22)));
                continue;
            }
            if (!volProps.getMounted()) {
                LOG.warn((Object)("VolumeUnmount : Volume " + volName + " already unmounted"));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume " + volName + " already unmounted, " + Errno.toString((int)22)));
                continue;
            }
            boolean rootVolUnMount = false;
            if (volProps.getVolumeName().equals(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName())) {
                rootVolUnMount = true;
                forceUnMount = true;
            }
            String rwVolumeMountDir = volProps.getMountDir();
            Common.FidMsg parentFid = volProps.getParentFid();
            int status = 0;
            if (!rootVolUnMount) {
                status = fs.unmountVolume(cluster, volName, rwVolumeMountDir, this.getUserLoginId(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
            }
            if (rootVolUnMount || status != 0 && forceUnMount) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ForceUnmount volume " + volName));
                }
                byte[] data = null;
                CLDBProto.VolumeUnMountRequest volUnMount = CLDBProto.VolumeUnMountRequest.newBuilder().setVolumeName(volName).setCreds(this.getUserCredentials()).setForce(true).build();
                try {
                    CLDBProto.VolumeUnMountResponse resp;
                    data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUnMountProc.getNumber(), (MessageLite)volUnMount, CLDBProto.VolumeUnMountResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUnMountProc.getNumber(), (MessageLite)volUnMount, CLDBProto.VolumeUnMountResponse.class);
                    if (data == null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. Force volumeUnmount response null for volume " + volName));
                        LOG.error((Object)("Force volumeUnmount response null for volume " + volName));
                    }
                    if ((resp = CLDBProto.VolumeUnMountResponse.parseFrom((byte[])data)).getStatus() == 0) {
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info((Object)("Force unmount volume " + volName));
                        continue;
                    }
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume UnMount: " + Errno.toString((int)resp.getStatus())));
                    LOG.error((Object)("Forceunmount of volume failed, " + Errno.toString((int)resp.getStatus())));
                    continue;
                }
                catch (MaprSecurityException e) {
                    throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                }
                catch (Exception e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume unMount:  Operation failed"));
                    LOG.error((Object)("Exception during volume force unmount " + e));
                    continue;
                }
            }
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Failed to unmount volume " + Errno.toString((int)status)));
                LOG.error((Object)("Volume unmount " + rwVolumeMountDir + " failed, " + Errno.toString((int)status)));
                continue;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Volume unmount " + rwVolumeMountDir + " successful"));
            }
            unmountedOne = true;
        }
        if (unmountedOne && !this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return output;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput volumeCreate() throws CLIProcessingException, IOException {
        String label;
        Iterator fsOperations;
        boolean autoCreateECTier;
        int minRepl;
        String policies;
        int mode;
        String rootDirPerms;
        CLDBProto.VolumeLookupResponse lookupResp;
        List<Security.AclEntry> elements;
        List perms;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = this.getRwVolumeName();
        if (rwVolumeName == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing volume name in the command to create volume").setField(RW_VOLUME_PARAM_NAME));
        }
        if (VolumeUtils.isViolatingVolNamingRules((String)rwVolumeName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Volume create failed. Can not use 'mapr.internal' as prefix in volume name, " + Errno.toString((int)1)));
            return output;
        }
        boolean rootVolume = rwVolumeName.equals(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName());
        boolean permsPresent = false;
        Common.VolumeType volumeType = Common.VolumeType.VTRwConvertible;
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
        if (this.isParamPresent(USERPERM_PARAM_NAME)) {
            permsPresent = true;
            perms = this.input.getParameterByName(USERPERM_PARAM_NAME).getParamValues();
            List<String> userNames = this.getUserGroupsNames(perms);
            for (String userName : userNames) {
                if (this.checkEntityExists(false, userName)) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - user " + userName + " not found").setField(USERPERM_PARAM_NAME));
                return output;
            }
            elements = AclCommands.actionsToAcls(perms, this.uInfo, CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, true, out);
            if (elements == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - invalid list of user permissions - " + perms).setField(USERPERM_PARAM_NAME));
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (this.isParamPresent(GROUPPERM_PARAM_NAME)) {
            permsPresent = true;
            perms = this.input.getParameterByName(GROUPPERM_PARAM_NAME).getParamValues();
            List<String> groupNames = this.getUserGroupsNames(perms);
            for (String groupName : groupNames) {
                if (this.checkEntityExists(true, groupName)) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - group " + groupName + " not found").setField(USERPERM_PARAM_NAME));
                return output;
            }
            elements = AclCommands.actionsToAcls(perms, this.uInfo, CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, false, out);
            if (elements == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - invalid list of group permissions - " + perms).setField(GROUPPERM_PARAM_NAME));
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (rootVolume) {
            return this.buildRootVolumeCreationRequest(aclBuilder, out);
        }
        String rwVolumeMountDir = null;
        if (this.isParamPresent(RW_VOLUME_PARAM_MOUNTDIR)) {
            rwVolumeMountDir = this.getParamTextValue(RW_VOLUME_PARAM_MOUNTDIR, 0).replaceAll("\\/+$", "");
        }
        boolean mount = true;
        if (this.isParamPresent(RW_VOLUME_PARAM_MOUNT)) {
            mount = this.getParamBooleanValue(RW_VOLUME_PARAM_MOUNT, 0);
        }
        if (!VolumeUtils.isValidVolumeName((String)rwVolumeName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Volume Name " + rwVolumeName + ", Allowed characters " + VolumeUtils.getValidName()).setField(RW_VOLUME_PARAM_NEW_NAME));
            return output;
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((lookupResp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), rwVolumeName, null, this.isServerCall)) != null && lookupResp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "Volume name " + rwVolumeName + ", already in use.").setField(RW_VOLUME_PARAM_NEW_NAME).setPropagateErrorSupport(true));
            return output;
        }
        if (this.isParamPresent(PBS_SECURITY_POLICY) && this.isParamPresent(RW_VOLUME_PARAM_TENANT_USER)) {
            LOG.error((Object)"tagging of tenant volume is not supported");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "tagging of tenant volume is not supported"));
            return output;
        }
        CLDBProto.VolumeCreateRequest.Builder volumeCreate = CLDBProto.VolumeCreateRequest.newBuilder();
        CLDBProto.VolumeProperties.Builder volProps = CLDBProto.VolumeProperties.newBuilder().setVolumeName(rwVolumeName);
        if (permsPresent) {
            volProps.setAcl(aclBuilder);
        }
        CLDBProto.ReplicationPolicy.Builder replPolicy = null;
        if (this.isParamPresent(RW_VOLUME_PARAM_TENANT_USER)) {
            String tenantUser = this.getParamTextValue(RW_VOLUME_PARAM_TENANT_USER, 0);
            if (tenantUser.length() <= 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid tenant user"));
                return output;
            }
            volumeCreate.setTenantUser(tenantUser);
        }
        if (this.isParamPresent(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC)) {
            int timeout = this.getParamIntValue(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, 0);
            volProps.setReReplicationTimeOutSec(timeout);
        }
        if (this.isParamPresent(RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC)) {
            int timeout = this.getParamIntValue(RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, 0);
            volProps.setCriticalReReplicationTimeOutSec(timeout);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_READONLY)) {
            boolean readOnly = this.getParamBooleanValue(RW_VOLUME_PARAM_READONLY, 0);
            volProps.setReadOnly(readOnly);
        }
        boolean allowInherit = true;
        if (this.isParamPresent(ALLOW_INHERIT)) {
            allowInherit = this.getParamBooleanValue(ALLOW_INHERIT, 0);
        }
        if (this.isParamPresent(INHERIT_SOURCE) && allowInherit) {
            String src = this.getParamTextValue(INHERIT_SOURCE, 0);
            volumeCreate.setInheritPropsSource(src);
        }
        if (this.isParamPresent(ALLOW_GRANT)) {
            boolean val = this.getParamBooleanValue(ALLOW_GRANT, 0);
            volProps.setAllowGrant(val);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_LOCALVOLUMEHOST)) {
            Common.IPAddress fileServer;
            CLDBProto.FileServerInfo fsInfo;
            String fsHost = this.getParamTextValue(RW_VOLUME_PARAM_LOCALVOLUMEHOST, 0);
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(fsHost));
            int localFSPort = 0;
            Common.IPAddress.Builder ipAddressBuilder = Common.IPAddress.newBuilder();
            ipAddressBuilder.setHostname(fsHost);
            if (this.isParamPresent(RW_VOLUME_PARAM_LOCALVOLUMEPORT)) {
                localFSPort = this.getParamIntValue(RW_VOLUME_PARAM_LOCALVOLUMEPORT, 0);
                ipAddressBuilder.setPort(localFSPort);
            }
            if (!ips.isEmpty()) {
                ipAddressBuilder.setHost(Util.ipToInt((String)ips.get(0)));
            }
            if ((fsInfo = NodesCommonUtils.getFileServerInfo(fileServer = ipAddressBuilder.build(), this.getUserCredentials(), cluster)) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "FileServer " + fsHost + ":" + localFSPort + " has not registered with CLDB"));
                return output;
            }
            if (fsInfo.getLastHeartbeatSec() > 60) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "FileServer " + fsHost + ":" + localFSPort + " has not heartbeated with CLDB for " + fsInfo.getLastHeartbeatSec()));
                return output;
            }
            if (replPolicy == null) {
                replPolicy = CLDBProto.ReplicationPolicy.newBuilder();
            }
            replPolicy.setNumReplicas(1);
            replPolicy.setGuaranteedMinReplicas(1);
            volProps.setLocalVolume(true);
            volumeCreate.setLocalFileServer(fileServer);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_SHUFFLEVOLUME)) {
            boolean shuffleVol = this.getParamBooleanValue(RW_VOLUME_PARAM_SHUFFLEVOLUME, 0);
            volProps.setShuffleVolume(shuffleVol);
        }
        volProps.setOwnerId((int)super.getUserId());
        if (this.isParamPresent(RW_VOLUME_PARAM_AE) || this.isParamPresent(RW_VOLUME_PARAM_AETYPE) || this.isParamPresent(OBJ_STORE_ACCOUNT_ID)) {
            if (this.isParamPresent(OBJ_STORE_ACCOUNT_ID) && (this.isParamPresent(RW_VOLUME_PARAM_AETYPE) || this.isParamPresent(RW_VOLUME_PARAM_AE))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "aetype or ae cant be specifies with objectstoreaccountid"));
                return output;
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_AETYPE) && !this.isParamPresent(RW_VOLUME_PARAM_AE)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Please specify both aetype and ae while creating volume " + rwVolumeName));
                return output;
            }
            CLDBProto.AeKey.Builder keyBuilder = CLDBProto.AeKey.newBuilder();
            int status = this.populateAeKey(keyBuilder, out);
            if (status != 0) {
                LOG.error((Object)"Volume create with invalid AE ");
                return output;
            }
            volProps.setVolumeAe(keyBuilder);
        }
        long quotaInMB = 0L;
        if (this.isParamPresent(RW_VOLUME_PARAM_QUOTA)) {
            String quota = this.getParamTextValue(RW_VOLUME_PARAM_QUOTA, 0);
            quotaInMB = MapRCliUtil.quotaStringToMB(quota);
            if (quotaInMB == -1L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create with invalid quota " + quota + ", Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)").setField(RW_VOLUME_PARAM_QUOTA));
                return output;
            }
            volProps.setVolumeQuotaSizeMB(quotaInMB);
        }
        if (this.isParamPresent(RW_VOLUME_ROOT_DIR_PERM)) {
            rootDirPerms = this.getParamTextValue(RW_VOLUME_ROOT_DIR_PERM, 0);
        } else {
            try {
                MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
                rootDirPerms = String.format("%04o", MapRClientImpl.getModeBits((FsPermission)FsPermission.getDefault(), (Configuration)fs.getConf()));
            }
            catch (IllegalArgumentException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error parsing \"dfs.umaskmode\" property from core-site.xml."));
                return output;
            }
        }
        try {
            mode = Integer.parseInt(rootDirPerms, 8);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("VolumeCreate: Volumename : " + rwVolumeName + " Invalid rootdirperms specified. Should be valid octal string"));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Create for " + rwVolumeName + " failed, Invalid rootdirperms specified. Should be valid octal string").setField(RW_VOLUME_ROOT_DIR_PERM));
            return output;
        }
        if ((mode & 0xFFFFF000) != 0) {
            LOG.error((Object)("VolumeCreate: Volumename : " + rwVolumeName + " Invalid rootdirperms specified. Should be a subset of 07777"));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Create for " + rwVolumeName + " failed, Invalid rootdirperms specified. Should be a subset of 07777").setField(RW_VOLUME_ROOT_DIR_PERM));
            return output;
        }
        volProps.setRootDirPerms(mode);
        if (this.isParamPresent(RW_VOLUME_ROOT_DIR_USER) || this.isParamPresent(RW_VOLUME_ROOT_DIR_PERM)) {
            UnixUserGroupHelper uInfo = new UnixUserGroupHelper();
            if (this.isParamPresent(RW_VOLUME_ROOT_DIR_USER)) {
                String userName = this.getParamTextValue(RW_VOLUME_ROOT_DIR_USER, 0);
                int uid = uInfo.getUserId(userName);
                volProps.setRootDirUser(uid);
            }
            if (this.isParamPresent(RW_VOLUME_ROOT_DIR_GROUP)) {
                String groupName = this.getParamTextValue(RW_VOLUME_ROOT_DIR_GROUP, 0);
                int gid = uInfo.getGroupId(groupName);
                volProps.setRootDirGroup(gid);
            }
        }
        if (this.isParamPresent(ROOT_DIR_SECURITY_POLICY) && !(policies = this.getParamTextValue(ROOT_DIR_SECURITY_POLICY, 0)).equals("")) {
            try {
                Common.VolumeAces.Builder rootDirPolicyInfoB = Common.VolumeAces.newBuilder();
                ArrayList<Integer> polIds = new ArrayList<Integer>();
                rootDirPolicyInfoB.setCompositePolicyId(this.getCompositeId(policies, polIds, out));
                rootDirPolicyInfoB.addAllPolicyIds(polIds);
                volumeCreate.setRootDirPolicyInfo(rootDirPolicyInfoB.build());
            }
            catch (Exception e) {
                return output;
            }
        }
        long advisoryQuotaInMB = 0L;
        if (this.isParamPresent(RW_VOLUME_PARAM_ADVISORY_QUOTA)) {
            String quota = this.getParamTextValue(RW_VOLUME_PARAM_ADVISORY_QUOTA, 0);
            advisoryQuotaInMB = MapRCliUtil.quotaStringToMB(quota);
            if (advisoryQuotaInMB == -1L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + "with invalid advisory quota " + quota + ", Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)").setField(RW_VOLUME_PARAM_ADVISORY_QUOTA));
                return output;
            }
            volProps.setVolumeQuotaAdvisorySizeMB(advisoryQuotaInMB);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_ADVISORY_QUOTA) && this.isParamPresent(RW_VOLUME_PARAM_QUOTA) && quotaInMB > 0L && advisoryQuotaInMB > quotaInMB) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " with invalid advisory quota greater than volume quota").setField(RW_VOLUME_PARAM_ADVISORY_QUOTA));
            return output;
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_DCREPLTYPE)) {
            if (this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION) && !this.isParamPresent(RW_VOLUME_PARAM_REPLICATION)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume create of " + rwVolumeName + " insufficient arguments. Please specify replication along with minreplication"));
                return output;
            }
            if (replPolicy == null) {
                replPolicy = CLDBProto.ReplicationPolicy.newBuilder();
            }
            int repl = 0;
            if (this.isParamPresent(RW_VOLUME_PARAM_REPLICATION)) {
                repl = this.getParamIntValue(RW_VOLUME_PARAM_REPLICATION, 0);
                if (repl <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid replication " + repl));
                    return output;
                }
                if (repl > this.maxVolumeReplicationFactor) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume create of " + rwVolumeName + " failed. The maximum value allowed for the replication factor is " + this.maxVolumeReplicationFactor + " while the requested value is " + repl));
                    return output;
                }
                replPolicy.setNumReplicas(repl);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION)) {
                minRepl = this.getParamIntValue(RW_VOLUME_PARAM_MIN_REPLICATION, 0);
                if (minRepl <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid minreplication " + repl));
                    return output;
                }
                if (repl > 0 && minRepl > repl) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, minreplication " + repl + " greater than replicaton"));
                    return output;
                }
                replPolicy.setGuaranteedMinReplicas(minRepl);
            } else if (repl == 1) {
                replPolicy.setGuaranteedMinReplicas(repl);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_DCREPLTYPE)) {
                String stype = this.getParamTextValue(RW_VOLUME_PARAM_DCREPLTYPE, 0);
                Common.ContainerReplType rtype = this.getContainerReplType(stype);
                if (rtype == Common.ContainerReplType.INVALID) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid replicationtype " + stype));
                    return output;
                }
                replPolicy.setDataContainerReplType(rtype);
            }
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
            if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION) && !this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume create of " + rwVolumeName + " insufficient arguments. Please specify namespace replication along with namespace minreplication"));
                return output;
            }
            int repl = 0;
            if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION)) {
                repl = this.getParamIntValue(RW_VOLUME_PARAM_NAMESPACE_REPLICATION, 0);
                if (repl <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid namespace replication " + repl));
                    return output;
                }
                if (repl > this.maxVolumeReplicationFactor) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume create of " + rwVolumeName + " failed. The maximum value allowed for the namespace replication factor is " + this.maxVolumeReplicationFactor + " while the requested value is " + repl));
                    return output;
                }
                volProps.setNumNamespaceReplicas(repl);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
                minRepl = this.getParamIntValue(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, 0);
                if (minRepl <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, due to invalid namespace minreplication " + repl));
                    return output;
                }
                if (minRepl > repl) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create of " + rwVolumeName + " failed, namespace minreplication " + minRepl + " can not be more than namespace replicaton " + repl));
                    return output;
                }
                volProps.setGuaranteedMinNamespaceReplicas(minRepl);
            }
        }
        if (this.isParamPresent(RW_VOLUME_ENFORCE_MIN_REPLICATION)) {
            boolean strongMinRepl = this.getParamBooleanValue(RW_VOLUME_ENFORCE_MIN_REPLICATION, 0);
            volProps.setEnforceMinReplication(strongMinRepl);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_CONTAINER_ALLOCATION_FACTOR)) {
            int containerAllocationFactor = this.getParamIntValue(RW_VOLUME_PARAM_CONTAINER_ALLOCATION_FACTOR, 0);
            volProps.setContainerAllocationFactor(containerAllocationFactor);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_MIRRORTHROTTLE)) {
            boolean mirrorThrottle = this.getParamBooleanValue(RW_VOLUME_PARAM_MIRRORTHROTTLE, 0);
            volProps.setMirrorThrottle(mirrorThrottle);
        }
        if (this.isParamPresent(VOLUME_LIMIT_SPREAD)) {
            boolean limitSpread = this.getParamBooleanValue(VOLUME_LIMIT_SPREAD, 0);
            volProps.setLimitVolumeSpread(limitSpread);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_TOPOLOGY)) {
            String topology = this.getParamTextValue(RW_VOLUME_PARAM_TOPOLOGY, 0);
            if (!topology.startsWith("/")) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid topology(rackpath) specified" + topology + ". It should start with \"/\"").setField(RW_VOLUME_PARAM_TOPOLOGY).setFieldValue(topology));
                return output;
            }
            CLDBProto.VolumeTopology topo = CLDBProto.VolumeTopology.newBuilder().setTopologyRestricted(topology).build();
            volProps.setTopology(topo);
        }
        if (this.isParamPresent(VOLUME_SCHEDULE)) {
            int scheduleId = this.getParamIntValue(VOLUME_SCHEDULE, 0);
            volProps.setSchedulingPolicyId(scheduleId);
        }
        if (this.isParamPresent(VOLUME_MIRROR_SCHEDULE)) {
            int scheduleId = this.getParamIntValue(VOLUME_MIRROR_SCHEDULE, 0);
            volProps.setMirrorSchedulingPolicyId(scheduleId);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD)) {
            long maxInodes = this.getParamLongValue(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, 0);
            volProps.setMaxInodesAlarmThreshold(maxInodes);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD)) {
            long maxSize = this.getParamLongValue(RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD, 0);
            volProps.setMaxNsSizeMbAlarmThreshold(maxSize);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH)) {
            int thresh = this.getParamIntValue(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, 0);
            volProps.setDbReplLagSecAlarmThresh(thresh);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH)) {
            int thresh = this.getParamIntValue(RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH, 0);
            volProps.setDbIndexLagSecAlarmThresh(thresh);
        }
        boolean tieringEnable = this.isParamPresent(RW_VOLUME_PARAM_TIERING) ? this.getParamBooleanValue(RW_VOLUME_PARAM_TIERING, 0) : false;
        boolean bl = autoCreateECTier = this.isParamPresent(RW_VOLUME_PARAM_AUTO_CREATE_EC_TIER) ? this.getParamBooleanValue(RW_VOLUME_PARAM_AUTO_CREATE_EC_TIER, 0) : false;
        if (autoCreateECTier && this.isParamPresent(RW_VOLUME_PARAM_TIER_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tiername and ecenable can not be used together"));
            return output;
        }
        if (autoCreateECTier) {
            tieringEnable = true;
        }
        if (this.isParamPresent(MIRROR_VOLUME)) {
            int mirrorFlag = 3;
            String mirrorType = this.getParamTextValue(MIRROR_VOLUME, 0);
            if (!(mirrorType.equalsIgnoreCase("rw1dot0") || mirrorType.equalsIgnoreCase("rw") || mirrorType.equalsIgnoreCase("mirror") || mirrorType.equalsIgnoreCase("0") || mirrorType.equalsIgnoreCase("1"))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type " + mirrorType + " specified. Please specify rw/mirror").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                return output;
            }
            if (mirrorType.equalsIgnoreCase("rw1dot0")) {
                mirrorFlag = 0;
            }
            if (mirrorType.equalsIgnoreCase("mirror") || mirrorType.equalsIgnoreCase("1")) {
                mirrorFlag = 2;
            }
            if (mirrorFlag == 1 || mirrorFlag == 2) {
                boolean isDestClusterSecure;
                boolean isSourceClusterSecure;
                boolean isAuditVolume;
                if (this.isParamPresent(AUDIT_VOLUME) && (isAuditVolume = this.getParamBooleanValue(AUDIT_VOLUME, 0))) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Mirror volume cannot be audit volume").setField(AUDIT_VOLUME));
                    return output;
                }
                volProps.setReadOnly(true);
                LOG.info((Object)("Setting readonly to true for Mirror Volume " + volProps.getVolumeName()));
                if (!this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source volume name is not specified.").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                String srcVolumeFullName = this.getParamTextValue(MIRROR_VOLUME_SRC_VOLUMENAME, 0);
                int index = srcVolumeFullName.indexOf(64);
                if (index == -1 || index == 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source volume name is not specified in format srcvolume@srccluster").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                String srcVolumeName = srcVolumeFullName.substring(0, index);
                String srcClusterName = srcVolumeFullName.substring(index + 1, srcVolumeFullName.length());
                if (srcClusterName == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source volume name " + srcVolumeName + " is not specified in format srcvolume@srccluster").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(srcClusterName)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid cluster name " + srcClusterName).setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                String destClusterName = null;
                destClusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
                if (rwVolumeName.equalsIgnoreCase(srcVolumeName) && destClusterName.equalsIgnoreCase(srcClusterName)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specified source " + srcVolumeFullName + " is same as destination").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                    return output;
                }
                if (!destClusterName.equalsIgnoreCase(srcClusterName) && (isSourceClusterSecure = JNISecurity.IsSecurityEnabled((String)srcClusterName)) ^ (isDestClusterSecure = JNISecurity.IsSecurityEnabled((String)destClusterName))) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "In cross cluster mirroring, both clusters must be either secure or unsecure. Other combination is not allowed."));
                    return output;
                }
                CLDBProto.MirrorInfo.Builder mirror = CLDBProto.MirrorInfo.newBuilder().setSrcVolumeName(srcVolumeName).setSrcClusterName(srcClusterName);
                CLDBProto.MirrorInfo destMirrorInfo = mirror.build();
                volProps.setIsMirrorVol(true);
                volProps.setMirrorInfo(destMirrorInfo);
                CLDBProto.VolumeLookupResponse resp = VolumeCommands.volumeLookup(srcClusterName, this.getUserCredentials(), srcVolumeName, null, this.isServerCall);
                if (resp.hasStatus() && resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume " + srcVolumeName + "does not exist in cluster " + srcClusterName));
                    return output;
                }
                CLDBProto.VolumeProperties vProps = resp.getVolInfo().getVolProperties();
                boolean srcTiering = false;
                if (vProps.hasIsTierOffloadEnable()) {
                    srcTiering = vProps.getIsTierOffloadEnable();
                }
                if (srcTiering != tieringEnable) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tieringenable property of mirror volume should be same as source volume"));
                    return output;
                }
                int srcMirrorType = 0;
                if (vProps.hasVolumetype()) {
                    srcMirrorType = vProps.getVolumetype().getNumber();
                }
                mirrorFlag = srcMirrorType == 0 || srcMirrorType == 1 ? 1 : 2;
                if (!this.isParamPresent(RW_VOLUME_PARAM_TENANT_USER) && resp.getVolInfo().hasTenantUser()) {
                    volumeCreate.setTenantUser(resp.getVolInfo().getTenantUser());
                }
            } else if (this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source cannot be specified for rw volume"));
                return output;
            }
            volumeType = Common.VolumeType.values()[mirrorFlag];
            volProps.setVolumetype(Common.VolumeType.values()[mirrorFlag]);
        } else if (this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source cannot be specified for rw volume"));
            return output;
        }
        if (this.isParamPresent(AUDIT_VOLUME)) {
            boolean isAuditVolume = this.getParamBooleanValue(AUDIT_VOLUME, 0);
            volProps.setIsAuditVolume(isAuditVolume);
        }
        if (this.isParamPresent(AUDIT_ENABLED)) {
            boolean audited = this.getParamBooleanValue(AUDIT_ENABLED, 0);
            volProps.setAudited(audited);
        }
        if (this.isParamPresent(FORCE_AUDIT_ENABLE)) {
            boolean audited = this.getParamBooleanValue(FORCE_AUDIT_ENABLE, 0);
            volProps.setForceAudit(audited);
        }
        if (this.isParamPresent(AUDIT_COALESCE_INTERVAL)) {
            int coalesceInterval = this.getParamIntValue(AUDIT_COALESCE_INTERVAL, 0);
            if (coalesceInterval < 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Coalesce interval cannot be negative"));
                return output;
            }
            if (coalesceInterval != volProps.getCoalesceInterval()) {
                volProps.setCoalesceInterval(coalesceInterval);
            }
        }
        ArrayList<Common.FSAuditOperations> fsAuditEnableOperations = new ArrayList<Common.FSAuditOperations>();
        ArrayList<Common.FSAuditOperations> fsAuditDisableOperations = new ArrayList<Common.FSAuditOperations>();
        if (this.isParamPresent(FSAUDIT_OPS) && !VolumeCommands.validateAndAddFsOperations(fsAuditEnableOperations, fsAuditDisableOperations, (String)((Object)(fsOperations = this.getParamTextValue(FSAUDIT_OPS, 0))), true)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid dataauditops text specified, text = " + (String)((Object)fsOperations)));
            return output;
        }
        if (fsAuditEnableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditEnableOperations.size() > 1) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying +all,  cannot enable any other operation"));
            return output;
        }
        if (fsAuditDisableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditDisableOperations.size() > 1) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying -all,  cannot disable any other operation"));
            return output;
        }
        if (fsAuditEnableOperations.size() > 0 && fsAuditDisableOperations.size() > 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot mix enable and disable dataaudit ops"));
            return output;
        }
        volumeCreate.addAllFsAuditEnableOperations(fsAuditEnableOperations);
        volumeCreate.addAllFsAuditDisableOperations(fsAuditDisableOperations);
        for (Common.FSAuditOperations op : fsAuditEnableOperations) {
            LOG.info((Object)("Enable Op = " + op.toString()));
        }
        for (Common.FSAuditOperations op : fsAuditDisableOperations) {
            LOG.info((Object)("Disable Op = " + op.toString()));
        }
        if (this.isParamPresent(METRICS_ENABLED)) {
            boolean metricsEnabled = this.getParamBooleanValue(METRICS_ENABLED, 0);
            volProps.setMetricsEnabled(metricsEnabled);
        }
        if (this.isParamPresent(DARE_ENABLED)) {
            boolean dareEnabled = this.getParamBooleanValue(DARE_ENABLED, 0);
            volProps.setDareEnabled(dareEnabled);
        }
        if (this.isParamPresent(WIRE_SECURITY_ENABLED)) {
            boolean wireSecurityEnabled = this.getParamBooleanValue(WIRE_SECURITY_ENABLED, 0);
            volProps.setWireSecurityEnabled(wireSecurityEnabled);
        }
        if (this.isParamPresent(NAME_CONTAINER_DATA_THRESHOLD)) {
            Long ncDataThreshold = this.getParamLongValue(NAME_CONTAINER_DATA_THRESHOLD, 0);
            volProps.setNameContainerDataThreshold(ncDataThreshold * 0x100000L);
        }
        if (this.isParamPresent(ALLOW_READ_FOR_EXECUTE)) {
            boolean allowReadForExecute = this.getParamBooleanValue(ALLOW_READ_FOR_EXECUTE, 0);
            volProps.setAllowReadForExecute(allowReadForExecute);
        }
        if (this.isParamPresent(FILTER_EXTENSION)) {
            CLDBProto.FileFilterLookupResponse resp;
            String filter = this.getParamTextValue(FILTER_EXTENSION, 0);
            try {
                resp = FileFilterCommands.filterLookupByName(cluster, this.getUserCredentials(), filter);
            }
            catch (Exception e) {
                LOG.error((Object)"Error creating Volume, exception while looking for fileFilter");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error creating Volume, , exception while looking for fileFilter"));
                return output;
            }
            if (resp.getStatus() != 0) {
                LOG.error((Object)"Error creating Volume, fileFilter not found");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error creating Volume, fileFilter not found"));
                return output;
            }
            volProps.clearFileFilterIds();
            volProps.addFileFilterIds(resp.getProperties().getFilterId());
        }
        if (rwVolumeMountDir != null) {
            volProps.setMountDir(rwVolumeMountDir);
        }
        if (replPolicy != null) {
            volProps.setReplicationPolicy(replPolicy);
        }
        Common.VolumeAces volumeAces = null;
        try {
            volumeAces = this.buildVolumeAcesProtobuf(volumeAceParameterMap, out);
        }
        catch (IOException e) {
            return output;
        }
        if (volumeAces != null) {
            volumeCreate.setVolumeAces(volumeAces);
        }
        try {
            CLDBProto.VolumeProperties skipInheritProps = this.getSkipInheritProps();
            if (skipInheritProps != null) {
                volumeCreate.setSkipInheritProps(skipInheritProps);
            }
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Error creating Volume. " + e.getMessage()));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error creating Volume. " + e.getMessage()));
            return output;
        }
        boolean isTierNameSet = this.isParamPresent(RW_VOLUME_PARAM_TIER_NAME);
        boolean isOffloadScheduleSet = this.isParamPresent(RW_VOLUME_PARAM_OFFLOAD_SCHEDULEID);
        boolean isTieringRuleSet = this.isParamPresent(RW_VOLUME_PARAM_TIERING_RULE);
        boolean isTierEncryptionSet = this.isParamPresent(RW_VOLUME_PARAM_TIER_ENCRYPTION);
        boolean isTierKeySet = this.isParamPresent(RW_VOLUME_PARAM_TIER_KEY);
        boolean isRecallExpirySet = this.isParamPresent(RW_VOLUME_PARAM_RECALL_EXPIRY_TIME);
        boolean isCompactionScheduleSet = this.isParamPresent(RW_VOLUME_PARAM_COMPACTION_SCHEDULEID);
        boolean isCompactionOverheadSet = this.isParamPresent(RW_VOLUME_PARAM_COMPACTION_OVERHEAD);
        boolean isSkipWSForInternalOpsSet = this.isParamPresent(SKIP_WIRE_SECURITY_FOR_INTERNAL_OP);
        boolean tierEncryption = true;
        String tierName = null;
        String tieringRule = null;
        String tierKey = null;
        int tieringScheduleId = -1;
        int recallExpiryTime = -1;
        int compactionScheduleId = -1;
        int compactionOverhead = -1;
        boolean compactionOverheadSupplied = false;
        if (isTierNameSet) {
            tierName = this.getParamTextValue(RW_VOLUME_PARAM_TIER_NAME, 0);
        }
        if (isOffloadScheduleSet) {
            tieringScheduleId = this.getParamIntValue(RW_VOLUME_PARAM_OFFLOAD_SCHEDULEID, 0);
        }
        if (isRecallExpirySet) {
            recallExpiryTime = this.getParamIntValue(RW_VOLUME_PARAM_RECALL_EXPIRY_TIME, 0);
        }
        if (isTieringRuleSet) {
            tieringRule = this.getParamTextValue(RW_VOLUME_PARAM_TIERING_RULE, 0);
        }
        if (isTierKeySet) {
            tierKey = this.getParamTextValue(RW_VOLUME_PARAM_TIER_KEY, 0);
        }
        if (isTierEncryptionSet) {
            tierEncryption = this.getParamBooleanValue(RW_VOLUME_PARAM_TIER_ENCRYPTION, 0);
        }
        if (isCompactionScheduleSet) {
            compactionScheduleId = this.getParamIntValue(RW_VOLUME_PARAM_COMPACTION_SCHEDULEID, 0);
        }
        if (isCompactionOverheadSet) {
            compactionOverhead = this.getParamIntValue(RW_VOLUME_PARAM_COMPACTION_OVERHEAD, 0);
            compactionOverheadSupplied = true;
            if (compactionOverhead < 0 || compactionOverhead > 100) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Overhead threshold is a percentage, it should be less than or equal to 100"));
                return output;
            }
        }
        if (tieringEnable) {
            int createTierStatus;
            if (rwVolumeName.length() > VolumeUtils.validTierVolumeNameLength()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Tier Volume Name " + rwVolumeName + ", Exceeds allowed length of " + VolumeUtils.validTierVolumeNameLength() + " characters").setField(RW_VOLUME_PARAM_NEW_NAME));
                return output;
            }
            if (!autoCreateECTier && !isTierNameSet && (isOffloadScheduleSet || isTieringRuleSet || isTierEncryptionSet || isTierKeySet || isRecallExpirySet || isCompactionScheduleSet || isCompactionOverheadSet || isSkipWSForInternalOpsSet)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier name should be specified for setting tier related parameters"));
                return output;
            }
            if (!isTierNameSet && !autoCreateECTier && (this.isParamPresent(RW_VOLUME_PARAM_ECSCHEME) || this.isParamPresent(EC_STRIPE_DEPTH_MB) || this.isParamPresent(RW_VOLUME_PARAM_ECLABEL) || this.isParamPresent(RW_VOLUME_PARAM_ECTOPOLOGY) || this.isParamPresent(RW_VOLUME_PARAM_HONORRACKRELIABILITY))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ecscheme/ecstripedepthmb/ectopology/eclabel/honorrackreliability can be set along with ec tiername only"));
                return output;
            }
            CLDBProto.VolumeTieringProperties.Builder volTierProps = CLDBProto.VolumeTieringProperties.newBuilder();
            if (volumeType == Common.VolumeType.VTRW || volumeType == Common.VolumeType.VTMirror) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tiering cannot be enabled for " + volumeType + " type of volume"));
                return output;
            }
            if (!tierEncryption && tierKey != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Parameter tierkey is applicable only when tier encryption is enabled"));
                return output;
            }
            if (autoCreateECTier && (createTierStatus = this.CreateECTier(tierName = TierCommands.generateTierNameForAutoCreate(rwVolumeName), cluster)) != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(createTierStatus, "tier create failed, look into cldb/maprcli logs or retry it"));
                return output;
            }
            if (tierName != null) {
                CLDBProto.TierLookupResponse tierResp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName);
                if (tierResp != null && tierResp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier " + tierName + " does not exist"));
                    return output;
                }
                if (!tierResp.hasTierProperties()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing properties for Tier " + tierName));
                    return output;
                }
                CLDBProto.TierProperties tierProps = tierResp.getTierProperties();
                volTierProps.setTierId(tierProps.getTierId());
                if (isSkipWSForInternalOpsSet) {
                    if (tierProps.getTierType() != CLDBProto.TierType.EC_TIER && !volProps.getIsMirrorVol()) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Param: skipwiresecurityfortierinternalops is only applicable to EC volume or Mirror Tiered volume"));
                        return output;
                    }
                    boolean skipInternalOpsWS = this.getParamBooleanValue(SKIP_WIRE_SECURITY_FOR_INTERNAL_OP, 0);
                    volProps.setSkipWireSecurityForTierInternalOps(skipInternalOpsWS);
                }
                if (tierProps.getTierType() == CLDBProto.TierType.EC_TIER) {
                    if (isTierEncryptionSet || isTierKeySet) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tierencryption or tierkey is not applicable for creating ec volumes"));
                        return output;
                    }
                    tierEncryption = false;
                    CLDBProto.ECVolumeProperties.Builder ecVolProps = CLDBProto.ECVolumeProperties.newBuilder();
                    String ecScheme = null;
                    if (this.isParamPresent(RW_VOLUME_PARAM_ECSCHEME)) {
                        ecScheme = this.getParamTextValue(RW_VOLUME_PARAM_ECSCHEME, 0);
                        int[] vRet = MapRCliUtil.parseEcScheme(ecScheme, out);
                        if (vRet == null) return output;
                        if (vRet.length < 2) {
                            return output;
                        }
                        volProps.setNumECDataColumns(vRet[0]);
                        volProps.setNumECParityColumns(vRet[1]);
                        if (vRet.length == 3 && vRet[2] != 0) {
                            volProps.setNumECLocalParityColumns(vRet[2]);
                        }
                    }
                    if (this.isParamPresent(EC_STRIPE_DEPTH_MB)) {
                        int ecStripeDepthMB = this.getParamIntValue(EC_STRIPE_DEPTH_MB, 0);
                        ecVolProps.setEcStripeDepthMB(ecStripeDepthMB);
                        volProps.setEcStripeDepthMB(ecStripeDepthMB);
                    }
                    if (this.isParamPresent(EC_CONTAINER_SIZE_MB)) {
                        int ecContainerSizeMB = this.getParamIntValue(EC_CONTAINER_SIZE_MB, 0);
                        volProps.setEcContainerSizeMB(ecContainerSizeMB);
                    }
                    if (this.isParamPresent(NUM_ACTIVE_CG_CONTAINERS)) {
                        int numActiveCgContainers = this.getParamIntValue(NUM_ACTIVE_CG_CONTAINERS, 0);
                        if (numActiveCgContainers < 1 || numActiveCgContainers > 100) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Num Active CG containers should be between 1 and 100"));
                            return output;
                        }
                        volProps.setNumActiveCgContainers(numActiveCgContainers);
                    }
                    if (this.isParamPresent(RW_VOLUME_PARAM_ECTOPOLOGY)) {
                        String ecTopo = this.getParamTextValue(RW_VOLUME_PARAM_ECTOPOLOGY, 0);
                        if (!ecTopo.startsWith("/")) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ecTopology specified" + ecTopo + ". It should start with \"/\"").setField(RW_VOLUME_PARAM_TOPOLOGY).setFieldValue(ecTopo));
                            return output;
                        }
                        ecVolProps.setEcTopology(ecTopo);
                    }
                    if (this.isParamPresent(RW_VOLUME_PARAM_HONORRACKRELIABILITY)) {
                        boolean honorRackReliability = this.getParamBooleanValue(RW_VOLUME_PARAM_HONORRACKRELIABILITY, 0);
                        volProps.setHonorRackReliability(honorRackReliability);
                    }
                    if (this.isParamPresent(RW_VOLUME_PARAM_ECLABEL)) {
                        String ecLabel = this.getParamTextValue(RW_VOLUME_PARAM_ECLABEL, 0);
                        if (ecLabel == null || ecLabel.isEmpty()) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing/Invalid value for eclabel parameter"));
                            return output;
                        }
                        ecVolProps.setEcLabel(ecLabel);
                    }
                    volTierProps.setEcVolProps(ecVolProps.build());
                }
            }
            if (tieringScheduleId != -1) {
                volTierProps.setScheduleId(tieringScheduleId);
            }
            if (recallExpiryTime > 0) {
                volTierProps.setRecallExpiryTime((long)(recallExpiryTime * 24 * 60 * 60));
            } else if (volTierProps != null) {
                volTierProps.setRecallExpiryTime(86400L);
            }
            CLDBProto.CompactionProperties.Builder compactionBuilder = CLDBProto.CompactionProperties.newBuilder();
            if (compactionScheduleId != -1) {
                compactionBuilder.setScheduleId(compactionScheduleId);
            }
            if (compactionOverheadSupplied) {
                compactionBuilder.setOverheadPercentage(compactionOverhead);
            }
            volTierProps.setCompactionProps(compactionBuilder.build());
            if (tieringRule != null) {
                CLDBProto.OffloadRuleLookupResponse tierRuleResp = OffloadRuleCommands.ruleLookup(cluster, this.getUserCredentials(), tieringRule);
                if (tierRuleResp != null && tierRuleResp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tiering rule " + tieringRule + " does not exist"));
                    return output;
                }
                if (tierRuleResp.hasRuleProps()) {
                    volTierProps.setRuleId(tierRuleResp.getRuleProps().getRuleId());
                }
            }
            if (tierKey != null) {
                if (tierKey.length() != 32) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tierKey should be 32 character HEX string"));
                    return output;
                }
                try {
                    byte[] data = this.StringToHex(tierKey);
                    Security.Key key = Security.Key.newBuilder().setKey(ByteString.copyFrom((byte[])data)).build();
                    volumeCreate.setTierKey(key);
                }
                catch (NumberFormatException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid hex string"));
                    return output;
                }
                catch (Exception e) {
                    throw new CLIProcessingException("Exception", (Throwable)e);
                }
            }
            volProps.setIsTierOffloadEnable(true);
            if (volTierProps != null) {
                if (isTierNameSet) {
                    volTierProps.setTierEncryption(tierEncryption);
                }
                volProps.setTierProps(volTierProps.build());
            }
        } else if (tierName != null || tieringScheduleId != -1 || tieringRule != null || tierKey != null || this.isParamPresent(RW_VOLUME_PARAM_TIER_ENCRYPTION) || recallExpiryTime > 0 || isCompactionScheduleSet || isCompactionOverheadSet || isSkipWSForInternalOpsSet) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Parameters tiername tieringschedule, tieringrule, tierkey, recallExpiry, tierencryption, compactionschedule , compactionoverheadthreshold and skipwiresecurityfortierinternalops are applicable only when tiering is enabled"));
            return output;
        }
        if (!VolumeUtils.isValidVolumeNameLength((String)rwVolumeName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Volume Name " + rwVolumeName + ", Exceeds allowed length of " + VolumeUtils.validVolumeNameLength() + " characters").setField(RW_VOLUME_PARAM_NEW_NAME));
            return output;
        }
        if (this.isParamPresent(AUTO_OFFLOAD_THRESHOLD_GB)) {
            if (!tieringEnable) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "autooffloadthresholdgb can be provided only when tiering is enabled"));
                return output;
            }
            volProps.setAutoOffloadThresholdGB(Integer.valueOf(this.getParamIntValue(AUTO_OFFLOAD_THRESHOLD_GB, 0)).intValue());
        }
        if (this.isParamPresent(DATA_LABEL)) {
            label = this.getParamTextValue(DATA_LABEL, 0);
            if (label == null || label.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing/Invalid value for label parameter"));
                return output;
            }
            volProps.setLabel(label);
        }
        if (this.isParamPresent(NAMESPACE_LABEL)) {
            label = this.getParamTextValue(NAMESPACE_LABEL, 0);
            if (label == null || label.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing/Invalid value for nslabel parameter"));
                return output;
            }
            volProps.setNameCntrLabel(label);
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL)) {
            int atimeVal;
            String atimeUpdateInterval = this.getParamTextValue(RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL, 0);
            StringBuilder SB = new StringBuilder(atimeUpdateInterval);
            int ch = SB.charAt(SB.length() - 1);
            try {
                if (ch != 100 && ch != 104 && ch != 109 && ch != 115) {
                    atimeVal = Integer.parseInt(SB.substring(0, SB.length()));
                    ch = 100;
                } else {
                    atimeVal = Integer.parseInt(SB.substring(0, SB.length() - 1));
                }
            }
            catch (Exception ex) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, this.cliCommand.getUsageFromParametersOfCommandsTree()));
                return output;
            }
            if (atimeVal < 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, this.cliCommand.getUsageFromParametersOfCommandsTree()));
                return output;
            }
            switch (ch) {
                case 100: {
                    atimeVal *= 86400;
                    break;
                }
                case 104: {
                    atimeVal *= 3600;
                    break;
                }
                case 109: {
                    atimeVal *= 60;
                    break;
                }
            }
            volProps.setAtimeUpdateIntervalSecs(atimeVal);
        }
        if (this.isParamPresent(Allow_S3_BUCKETS) && this.getParamBooleanValue(Allow_S3_BUCKETS, 0)) {
            if (!tieringEnable) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "option allows3buckets not allowed on non-tiering enabled volumes"));
                return output;
            }
            volProps.setAllowS3Bucket(true);
            if (this.isParamPresent(S3_ACCOUNTS_ROOT) && this.getParamBooleanValue(S3_ACCOUNTS_ROOT, 0)) {
                volProps.setIsS3AccountsRoot(true);
            }
        }
        if (this.isParamPresent(Allow_S3_WORM_BUCKETS) && this.getParamBooleanValue(Allow_S3_WORM_BUCKETS, 0)) {
            if (!tieringEnable || !this.getParamBooleanValue(Allow_S3_WORM_BUCKETS, 0)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "option allows3wormbuckets not allowed on non-tiering or non-s3 bucket enabled volumes"));
                return output;
            }
            volProps.setAllowS3WormBucket(true);
        }
        volumeCreate.setVolProperties(volProps.build());
        volumeCreate.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            MapRFileSystem fs = MapRCliUtil.getMapRFileSystem(this.getUserLoginId());
            if (rwVolumeMountDir != null) {
                if (!MapRCliUtil.parentDirExists(fs, cluster, rwVolumeMountDir)) {
                    if (!this.getParamBooleanValue(RW_VOLUME_PARAM_CREATE_PARENT, 0)) {
                        LOG.error((Object)("Volume Mount: Volume " + rwVolumeName + " parent of mount dir " + rwVolumeMountDir + " does not exist"));
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + rwVolumeName + ", parent of mount dir " + rwVolumeMountDir + " does not exist, " + Errno.toString((int)2)));
                        return output;
                    }
                    if (!MapRCliUtil.createParentDir(fs, cluster, rwVolumeMountDir)) {
                        LOG.error((Object)("Volume Mount: Volume " + rwVolumeName + ", failed to mount, could not create parent directory for mount dir " + rwVolumeMountDir));
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + rwVolumeName + ", could not create parent directory for mount dir " + rwVolumeMountDir));
                        return output;
                    }
                }
                if (allowInherit) {
                    int parentCid = MapRCliUtil.getParentCid(fs, cluster, rwVolumeMountDir);
                    if (parentCid == 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Name " + rwVolumeName + ", could not get parent volume cid for mountpath " + rwVolumeMountDir).setField(RW_VOLUME_PARAM_MOUNTDIR));
                        return output;
                    }
                    volumeCreate.setParentNamespaceCID(parentCid);
                }
            }
            if ((data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCreateProc.getNumber(), (MessageLite)volumeCreate.build(), CLDBProto.VolumeCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCreateProc.getNumber(), (MessageLite)volumeCreate.build(), CLDBProto.VolumeCreateResponse.class)) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.VolumeCreateResponse resp = CLDBProto.VolumeCreateResponse.parseFrom((byte[])data);
            boolean isTenantVol = resp.hasVolProperties() && resp.getVolProperties().hasTenantCreds();
            int mountStatus = -1;
            if (resp.getStatus() == 0) {
                String msg;
                out.addMessage("Successfully created volume: '" + rwVolumeName + "'");
                if (resp.hasErrMsg() && (msg = resp.getErrMsg()) != null && !msg.trim().isEmpty()) {
                    out.addWarning(msg);
                }
            } else if (autoCreateECTier) {
                LOG.info((Object)("rollbackECEnable of tier:" + tierName + " for volume:" + rwVolumeName));
                this.rollbackECEnable(tierName, cluster);
            }
            if (resp.getStatus() == 0 && rwVolumeMountDir != null && mount) {
                mountStatus = fs.mountVolume(cluster, rwVolumeName, rwVolumeMountDir, this.getUserLoginId());
                if (mountStatus != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume mount for " + rwVolumeMountDir + " failed, " + Errno.toString((int)mountStatus)).setField(RW_VOLUME_PARAM_NAME).setFieldValue(rwVolumeName));
                    return output;
                }
                if (!this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0) && !this.sleepAndCheckMountedDir(fs, cluster, rwVolumeMountDir)) {
                    if (isTenantVol) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Could not get status of mount path for tenant volume: " + rwVolumeMountDir).setField(RW_VOLUME_PARAM_NAME).setFieldValue(rwVolumeName));
                        return output;
                    }
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create for " + rwVolumeMountDir + " failed, Could not get status of mount path").setField(RW_VOLUME_PARAM_NAME).setFieldValue(rwVolumeName));
                    return output;
                }
            }
            if (resp.getStatus() == 0) {
                return output;
            }
            CommandOutput.OutputHierarchy.OutputError procssobj = new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg());
            if (resp.getStatus() == 2) {
                procssobj.setField(RW_VOLUME_PARAM_NAME);
                procssobj.setFieldValue(rwVolumeName);
            } else if (resp.getStatus() != 10011) {
                procssobj.setPropagateErrorSupport(true);
                procssobj.setField(RW_VOLUME_PARAM_NAME);
                procssobj.setFieldValue(rwVolumeName);
            }
            out.addError(procssobj);
            return output;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private int populateAeKey(CLDBProto.AeKey.Builder keyBuilder, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (this.isParamPresent(OBJ_STORE_ACCOUNT_ID)) {
            int accountId = this.getParamIntValue(OBJ_STORE_ACCOUNT_ID, 0);
            keyBuilder.setObjectStoreAccountId(accountId);
        } else {
            boolean type;
            String name = this.getParamTextValue(RW_VOLUME_PARAM_AE, 0);
            boolean bl = type = this.isParamPresent(RW_VOLUME_PARAM_AETYPE) ? this.getParamBooleanValue(RW_VOLUME_PARAM_AETYPE, 0) : false;
            if (!this.checkEntityExists(type, name)) {
                Object msg = " does not exist.";
                msg = type ? ". Group " + name + (String)msg : ". User " + name + (String)msg;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid AE specified while trying to create Volume " + this.getRwVolumeName() + (String)msg));
            }
            keyBuilder.setName(name);
            keyBuilder.setType(type);
        }
        return 0;
    }

    private CommandOutput buildRootVolumeCreationRequest(Security.AccessControlList.Builder aclBuilder, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            CLDBProto.VolumeProperties volProps = CLDBProto.VolumeProperties.newBuilder().setVolumeName(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName()).setMounted(true).setMountDir(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootPath()).setAcl(aclBuilder.build()).build();
            CLDBProto.VolumeCreateRequest.Builder volumeCreate = CLDBProto.VolumeCreateRequest.newBuilder().setVolProperties(volProps).setCreds(this.getUserCredentials());
            byte[] data = null;
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCreateProc.getNumber(), (MessageLite)volumeCreate.build(), CLDBProto.VolumeCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCreateProc.getNumber(), (MessageLite)volumeCreate.build(), CLDBProto.VolumeCreateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return this.output;
            }
            CLDBProto.VolumeCreateResponse resp = CLDBProto.VolumeCreateResponse.parseFrom((byte[])data);
            LOG.info((Object)resp.getErrMsg());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            return this.output;
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to CLDB");
        }
    }

    static boolean validateAndAddFsOperations(List<Common.FSAuditOperations> fsAuditEnableOperations, List<Common.FSAuditOperations> fsAuditDisableOperations, String fsOperations, boolean hasPrefix) {
        if (fsOperations == null) {
            return false;
        }
        if (fsOperations.isEmpty() || fsOperations.isBlank()) {
            fsAuditDisableOperations.add(Common.FSAuditOperations.AuditAll);
            return true;
        }
        if (fsOperations.charAt(0) == '-') {
            if (fsOperations.length() <= 1) {
                return false;
            }
            fsOperations = fsOperations.substring(1, fsOperations.length());
        }
        fsOperations = fsOperations.toLowerCase();
        String[] tokens = fsOperations.split("[,]");
        for (int i = 0; i < tokens.length; ++i) {
            List<Common.FSAuditOperations> list = null;
            String next = tokens[i];
            if (next.length() == 0) {
                return false;
            }
            String op = null;
            if (hasPrefix) {
                char first = next.charAt(0);
                if (first == '+') {
                    list = fsAuditEnableOperations;
                    op = next.substring(1, next.length());
                } else if (first == '-') {
                    list = fsAuditDisableOperations;
                    op = next.substring(1, next.length());
                } else {
                    list = fsAuditEnableOperations;
                    op = next;
                }
            } else {
                list = fsAuditDisableOperations;
                op = next;
            }
            if (op.length() == 0) {
                return false;
            }
            if (op.equals("all")) {
                list.add(Common.FSAuditOperations.AuditAll);
                continue;
            }
            if (op.equals("getattr")) {
                list.add(Common.FSAuditOperations.AuditGetattr);
                continue;
            }
            if (op.equals("setattr")) {
                list.add(Common.FSAuditOperations.AuditSetattr);
                list.add(Common.FSAuditOperations.AuditChown);
                list.add(Common.FSAuditOperations.AuditChperm);
                list.add(Common.FSAuditOperations.AuditChgrp);
                continue;
            }
            if (op.equals("chown")) {
                list.add(Common.FSAuditOperations.AuditChown);
                continue;
            }
            if (op.equals("chperm")) {
                list.add(Common.FSAuditOperations.AuditChperm);
                continue;
            }
            if (op.equals("chgrp")) {
                list.add(Common.FSAuditOperations.AuditChgrp);
                continue;
            }
            if (op.equals("getxattr")) {
                list.add(Common.FSAuditOperations.AuditGetxattr);
                continue;
            }
            if (op.equals("listxattr")) {
                list.add(Common.FSAuditOperations.AuditListxattr);
                continue;
            }
            if (op.equals("setxattr")) {
                list.add(Common.FSAuditOperations.AuditSetxattr);
                continue;
            }
            if (op.equals("removexattr")) {
                list.add(Common.FSAuditOperations.AuditRemovexattr);
                continue;
            }
            if (op.equals("getperm")) {
                list.add(Common.FSAuditOperations.AuditGetperm);
                continue;
            }
            if (op.equals("read")) {
                list.add(Common.FSAuditOperations.AuditRead);
                continue;
            }
            if (op.equals("write")) {
                list.add(Common.FSAuditOperations.AuditWrite);
                continue;
            }
            if (op.equals("create")) {
                list.add(Common.FSAuditOperations.AuditCreate);
                continue;
            }
            if (op.equals("mkdir")) {
                list.add(Common.FSAuditOperations.AuditMkdir);
                continue;
            }
            if (op.equals("delete")) {
                list.add(Common.FSAuditOperations.AuditDelete);
                continue;
            }
            if (op.equals("rmdir")) {
                list.add(Common.FSAuditOperations.AuditRmdir);
                continue;
            }
            if (op.equals("readdir")) {
                list.add(Common.FSAuditOperations.AuditReaddir);
                continue;
            }
            if (op.equals("createsym")) {
                list.add(Common.FSAuditOperations.AuditCreatesym);
                continue;
            }
            if (op.equals("lookup")) {
                list.add(Common.FSAuditOperations.AuditLookup);
                continue;
            }
            if (op.equals("rename")) {
                list.add(Common.FSAuditOperations.AuditRename);
                continue;
            }
            if (op.equals("createdev")) {
                list.add(Common.FSAuditOperations.AuditCreatedev);
                continue;
            }
            if (op.equals("truncate")) {
                list.add(Common.FSAuditOperations.AuditTruncate);
                continue;
            }
            if (op.equals("getpathforfid")) {
                list.add(Common.FSAuditOperations.AuditGetpathforfid);
                continue;
            }
            if (op.equals("filescan")) {
                list.add(Common.FSAuditOperations.AuditCdScan);
                continue;
            }
            if (op.equals("fileoffload")) {
                list.add(Common.FSAuditOperations.AuditFileOffload);
                continue;
            }
            if (op.equals("filerecall")) {
                list.add(Common.FSAuditOperations.AuditFileRecall);
                continue;
            }
            if (op.equals("filetierjobstatus")) {
                list.add(Common.FSAuditOperations.AuditFileTierJobStatus);
                continue;
            }
            if (op.equals("filetierjobabort")) {
                list.add(Common.FSAuditOperations.AuditFileTierJobAbort);
                continue;
            }
            if (op.equals("filetieroffloadevent")) {
                list.add(Common.FSAuditOperations.AuditFileTierOffloadEvent);
                continue;
            }
            if (op.equals("filetierrecallevent")) {
                list.add(Common.FSAuditOperations.AuditFileTierRecallEvent);
                continue;
            }
            if (op.equals("tablecfcreate")) {
                list.add(Common.FSAuditOperations.AuditDbCfcreate);
                continue;
            }
            if (op.equals("tablecfdelete")) {
                list.add(Common.FSAuditOperations.AuditDbCfdelete);
                continue;
            }
            if (op.equals("tablecfmodify")) {
                list.add(Common.FSAuditOperations.AuditDbCfmodify);
                continue;
            }
            if (op.equals("tablecfscan")) {
                list.add(Common.FSAuditOperations.AuditDbCfscan);
                continue;
            }
            if (op.equals("tableget")) {
                list.add(Common.FSAuditOperations.AuditDbGet);
                continue;
            }
            if (op.equals("tableput")) {
                list.add(Common.FSAuditOperations.AuditDbPut);
                continue;
            }
            if (op.equals("tablescan")) {
                list.add(Common.FSAuditOperations.AuditDbScan);
                continue;
            }
            if (op.equals("tablecreate")) {
                list.add(Common.FSAuditOperations.AuditDbTablecreate);
                continue;
            }
            if (op.equals("tablemodify")) {
                list.add(Common.FSAuditOperations.AuditDbTablemodify);
                continue;
            }
            if (op.equals("tableinfo")) {
                list.add(Common.FSAuditOperations.AuditDbTableinfo);
                continue;
            }
            if (op.equals("hardlink")) {
                list.add(Common.FSAuditOperations.AuditHardLink);
                continue;
            }
            return false;
        }
        return true;
    }

    CommandOutput volumeRename() throws CLIProcessingException {
        int status;
        String cluster;
        MapRFileSystem fs;
        boolean wasMounted;
        String newVolumeName;
        CLDBProto.VolumeProperties volProps;
        String volumeName;
        CommandOutput.OutputHierarchy out;
        CommandOutput output;
        block29: {
            output = new CommandOutput();
            out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            volumeName = this.getRwVolumeName();
            volProps = this.volumePropetiesLookup(volumeName);
            if (volProps == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume rename failed, could not fetch properties for volume " + volumeName + ", " + Errno.toString((int)2)));
                LOG.error((Object)("VolumeRename : Could not find volume properties for " + volumeName));
                return output;
            }
            if (VolumeUtils.isViolatingVolNamingRules((String)volumeName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Volume rename failed for volume : " + volumeName + ", " + Errno.toString((int)1)));
                return output;
            }
            newVolumeName = this.getParamTextValue(RW_VOLUME_PARAM_NEW_NAME, 0);
            if (VolumeUtils.isViolatingVolNamingRules((String)newVolumeName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Volume rename failed. Can not use 'mapr.internal' as prefix in new volume name, " + Errno.toString((int)1)));
                return output;
            }
            if (volProps.hasTierProps() && newVolumeName.length() > VolumeUtils.validTierVolumeNameLength()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Tier Volume Name " + newVolumeName + ", Exceeds allowed length").setField(RW_VOLUME_PARAM_NEW_NAME));
                return output;
            }
            if (volumeName.equals(newVolumeName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume rename failed, Volume " + newVolumeName + " same as old volume name"));
                LOG.error((Object)("VolumeRename : Volume " + newVolumeName + " same as old volume name"));
                return output;
            }
            if (!VolumeUtils.isValidVolumeNameLength((String)newVolumeName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Volume Name " + newVolumeName + ", Exceeds allowed length of " + VolumeUtils.validVolumeNameLength() + " characters").setField(RW_VOLUME_PARAM_NEW_NAME));
                return output;
            }
            if (!VolumeUtils.isValidVolumeName((String)newVolumeName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Volume Name  Allowed characters " + VolumeUtils.getValidName()).setField(RW_VOLUME_PARAM_NEW_NAME));
                return output;
            }
            CLDBProto.VolumeProperties newVolProps = this.volumePropetiesLookup(newVolumeName);
            if (newVolProps != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume rename failed, Volume " + newVolumeName + " already exists "));
                LOG.error((Object)("VolumeRename : Volume " + newVolumeName + " already exists"));
                return output;
            }
            wasMounted = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to rename volume " + volumeName + " to new name " + newVolumeName));
            }
            CLDBProto.VolumeRenameRequest volumeRename = CLDBProto.VolumeRenameRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).setNewVolumeName(newVolumeName).build();
            fs = MapRCliUtil.getMapRFileSystem();
            cluster = null;
            if (this.isParamPresent("cluster")) {
                cluster = this.getParamTextValue("cluster", 0);
            }
            if (volProps.getMounted()) {
                wasMounted = true;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Volume " + volumeName + " is mounted at " + volProps.getMountDir() + ". Trying to unmount before renaming"));
                }
                String volumeMountDir = volProps.getMountDir();
                Common.FidMsg parentFid = volProps.getParentFid();
                status = fs.unmountVolume(cluster, volumeName, volumeMountDir, this.getUserLoginId(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
                if (status != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Volume Unmount before rename failed : " + Errno.toString((int)status)));
                    LOG.error((Object)("Volume unmount " + volumeName + " before rename failed, " + Errno.toString((int)status)));
                    return output;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Volume unmount " + volumeName + " successful before rename"));
                }
                if (!this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Renaming volume " + volumeName + " to new name " + newVolumeName));
            }
            byte[] data = null;
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeRenameProc.getNumber(), (MessageLite)volumeRename, CLDBProto.VolumeRenameResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeRenameProc.getNumber(), (MessageLite)volumeRename, CLDBProto.VolumeRenameResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumeRenameResponse resp = CLDBProto.VolumeRenameResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Renamed volume " + volumeName + " to new name " + newVolumeName));
                    }
                    break block29;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume Rename: " + Errno.toString((int)resp.getStatus())));
                LOG.error((Object)("Rename of volume failed, " + Errno.toString((int)resp.getStatus())));
                return output;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume Rename:  Operation failed"));
                LOG.error((Object)("Exception during volume rename " + e));
                return output;
            }
        }
        if (wasMounted) {
            String volumeMountDir;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Volume " + newVolumeName + ". Trying to mount after renaming from " + volumeName));
            }
            if ((status = fs.mountVolume(cluster, newVolumeName, volumeMountDir = volProps.getMountDir(), this.getUserLoginId())) != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Volume mount after rename failed : " + Errno.toString((int)status)));
                LOG.error((Object)("Volume mount " + newVolumeName + " after rename failed, " + Errno.toString((int)status)));
                return output;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Volume Mount " + volumeName + " successful after rename"));
            }
            if (!this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0) && !this.sleepAndCheckMountedDir(fs, cluster, volumeMountDir)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume rename for " + volumeMountDir + " failed, Could not get status of mount path").setField(RW_VOLUME_PARAM_NAME).setFieldValue(newVolumeName));
                return output;
            }
        }
        return output;
    }

    CommandOutput volumeUpgradeformat() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = this.getRwVolumeName();
        ArrayList<String> volumeNames = new ArrayList<String>();
        if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(rwVolumeName);
        } else if (rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        }
        for (String volumeName : volumeNames) {
            CLDBProto.VolumeProperties volProps = this.volumePropetiesLookup(volumeName);
            if (volProps == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume upgradeformat failed, could not fetch properties for volume " + volumeName + ", " + Errno.toString((int)2)));
                LOG.error((Object)("VolumeUpgradeformat : Could not find volume properties for " + volumeName));
                continue;
            }
            if (volProps.getVolumetype() != Common.VolumeType.VTRW) {
                if (volProps.getVolumetype() == Common.VolumeType.VTMirror || volProps.getVolumetype() == Common.VolumeType.VTRwConvertibleMirror) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume upgradeformat failed: " + volumeName + " mirror volumes can not be upgraded to new format. " + Errno.toString((int)22)));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume upgradeformat failed: " + volumeName + " is already in new type. " + Errno.toString((int)22)));
                }
                LOG.error((Object)("VolumeUpgradeformat : Can not upgrade the format of volume " + volumeName));
                continue;
            }
            CLDBProto.VolumePromoteRequest volumePromote = CLDBProto.VolumePromoteRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Promoting volume " + volumeName));
            }
            byte[] data = null;
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumePromoteProc.getNumber(), (MessageLite)volumePromote, CLDBProto.VolumePromoteResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumePromoteProc.getNumber(), (MessageLite)volumePromote, CLDBProto.VolumePromoteResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumePromoteResponse resp = CLDBProto.VolumePromoteResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("Upgraded volume " + volumeName + " to new format"));
                    continue;
                }
                if (resp.hasErrMsg()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume upgradeformat failed, for volume " + volumeName + ", " + resp.getErrMsg()));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume Upgradeformat: " + Errno.toString((int)resp.getStatus())));
                }
                LOG.error((Object)("Upgrade of volume to new format failed, " + Errno.toString((int)resp.getStatus())));
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume Upgradeformat:  Operation failed"));
                LOG.error((Object)("Exception during volume upgradeformat " + e));
            }
        }
        return output;
    }

    CommandOutput removeFilteredVolumes() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        boolean forceRemove = false;
        if (this.isParamPresent(RW_VOLUME_PARAM_FORCE)) {
            forceRemove = this.getParamBooleanValue(RW_VOLUME_PARAM_FORCE, 0);
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        this.list(new CommandOutput.OutputHierarchy());
        if (this.listedVolumes.size() > 0) {
            ArrayList tasks = Lists.newArrayList();
            for (CLDBProto.VolumeInfo volume : this.listedVolumes) {
                CLDBProto.VolumeProperties volProps = volume.getVolProperties();
                VolumeRemoveTask removeTask = new VolumeRemoveTask(volProps, forceRemove, this.getUserCredentials(), cluster);
                if (volProps.getMounted()) {
                    removeTask.setDependencies(new VolumeUnMountTask(volProps, cluster, this.getUserLoginId()));
                }
                tasks.add(removeTask);
            }
            TaskCompletionService service = TaskCompletionService.getInstance();
            service.submitTasks(tasks);
            service.fetchResults();
            this.listedVolumes.clear();
        }
        output.setOutput(out);
        return output;
    }

    CommandOutput volumeRemove() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = this.getRwVolumeName();
        ArrayList<String> volumeNames = new ArrayList<String>();
        if (rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        } else {
            volumeNames.add(rwVolumeName);
        }
        boolean forceRemove = false;
        if (this.isParamPresent(RW_VOLUME_PARAM_FORCE)) {
            forceRemove = this.getParamBooleanValue(RW_VOLUME_PARAM_FORCE, 0);
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        boolean unmountedOne = false;
        for (String volumeName : volumeNames) {
            int status;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to remove volume " + volumeName));
            }
            CLDBProto.VolumeRemoveRequest volumeRemove = CLDBProto.VolumeRemoveRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).setForceRemove(forceRemove).build();
            CLDBProto.VolumeProperties volProps = this.volumePropetiesLookup(volumeName, false);
            if (volProps == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume Remove: " + Errno.toString((int)2)));
                LOG.error((Object)("VolumeRemove : Could not find volume properties for " + volumeName));
                continue;
            }
            if (VolumeUtils.isViolatingVolNamingRules((String)volumeName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Volume remove failed for volume : " + volumeName + ", " + Errno.toString((int)1)));
                continue;
            }
            if (volProps.getAllowS3Bucket() && !this.canRemoveS3AccountVol(volProps, out)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "Volume Remove: " + Errno.toString((int)95) + " Volume remove failed"));
                continue;
            }
            if (volProps.getNumSnapshots() > 0 && !forceRemove) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(39, "Volume Remove: " + Errno.toString((int)39) + " Volume has " + volProps.getNumSnapshots() + " Snapshots. Please use -force option to remove Volume and Snapshots"));
                LOG.error((Object)("VolumeRemove: Volume has " + volProps.getNumSnapshots() + "snapshot(s) Use -force option to remove snapshots and volume"));
                continue;
            }
            String tierName = null;
            boolean canDeleteAutoEcTier = false;
            if (volProps.getMounted()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Volume " + volumeName + " is mounted at " + volProps.getMountDir() + ". Trying to unmount before removing"));
                }
                String volumeMountDir = volProps.getMountDir();
                Common.FidMsg parentFid = volProps.getParentFid();
                status = fs.unmountVolume(cluster, volumeName, volumeMountDir, this.getUserLoginId(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
                if (status != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Volume UnMount: " + Errno.toString((int)status)));
                    LOG.error((Object)("Volume unmount " + volumeName + " before remove failed, " + Errno.toString((int)status)));
                    continue;
                }
                unmountedOne = true;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Volume unmount " + volumeName + " successful before remove"));
                }
            }
            if (volProps.getIsTierOffloadEnable() && volProps.hasTierRelationships() && volProps.getTierRelationships().hasBackendEcVolumeId()) {
                int tierId = volProps.getTierProps().getTierId();
                CLDBProto.TierLookupResponse tierResp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierId);
                if (tierResp == null || tierResp.getStatus() != 0) continue;
                tierName = tierResp.getTierProperties().getTierName();
                boolean bl = canDeleteAutoEcTier = tierName.startsWith(CLDBProto.DefaultECConstants.getDefaultInstance().getAutoEcTierPrefix()) && tierResp.getNumVols() == 1;
                if (canDeleteAutoEcTier) {
                    status = this.volumeUnmountByName(tierResp.getTierProperties().getMetaVolumeName());
                    LOG.info((Object)("Volume tier : " + tierName + " meta volume unmount: " + status));
                    if (status != 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Volume tier : " + tierName + " meta volume unmount: " + Errno.toString((int)status)));
                        continue;
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing volume " + volumeName));
            }
            byte[] data = null;
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeRemoveProc.getNumber(), (MessageLite)volumeRemove, CLDBProto.VolumeRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeRemoveProc.getNumber(), (MessageLite)volumeRemove, CLDBProto.VolumeRemoveResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumeRemoveResponse resp = CLDBProto.VolumeRemoveResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Removed volume " + volumeName));
                    }
                    if (!canDeleteAutoEcTier) continue;
                    try {
                        CLDBProto.TierRemoveResponse tierRemoveResp = TierCommands.deleteTierFromCLDB(tierName, this.getUserCredentials(), cluster);
                        if (tierRemoveResp.getStatus() == 0) continue;
                        LOG.info((Object)("auto ec tier " + tierName + " remove failed : " + tierRemoveResp.getStatus()));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Exception in auto ec tier remove " + e));
                    }
                    continue;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume Remove: " + Errno.toString((int)resp.getStatus())));
                LOG.error((Object)("Remove volume failed, " + Errno.toString((int)resp.getStatus())));
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume Remove:  Operation failed"));
                LOG.error((Object)("Exception during volume remove " + e));
            }
        }
        if (unmountedOne && !this.getParamBooleanValue(RW_VOLUME_PARAM_OP_NODELAY, 0)) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        output.setOutput(out);
        return output;
    }

    private int volumeUnmountByName(String volumeName) throws CLIProcessingException {
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        return VolumeCommands.volumeUnmountByName(volumeName, cluster, this.getUserLoginId(), this.getUserCredentials(), this.isServerCall);
    }

    public static int volumeUnmountByName(String volumeName, String cluster, String userId, Security.CredentialsMsg creds, boolean isServerCall) throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse volResp = VolumeCommands.volumeLookup(cluster, creds, volumeName, null, isServerCall);
        if (volResp.hasStatus() && volResp.getStatus() != 0) {
            LOG.info((Object)("Volume " + volumeName + " already removed"));
            LOG.error((Object)("volumeUnmountByName : Could not fetch volumeProps for " + volumeName));
            return 2;
        }
        CLDBProto.VolumeProperties volProps = volResp.getVolInfo().getVolProperties();
        if (volProps == null) {
            LOG.error((Object)("volumeUnmountByName : Could not fetch volumeProps for " + volumeName));
            return 2;
        }
        if (!volProps.getMounted()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("volumeUnmountByName : Volume " + volumeName + "not mounted"));
            }
            return 0;
        }
        if (!volProps.getMounted()) {
            LOG.info((Object)("volumeUnmountByName : Trying to unmount volume " + volumeName));
        }
        String volumeMountDir = volProps.getMountDir();
        Common.FidMsg parentFid = volProps.getParentFid();
        return MapRCliUtil.getMapRFileSystem().unmountVolume(cluster, volumeName, volumeMountDir, userId, parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
    }

    private CommandOutput moveVolume() throws CLIProcessingException {
        String ecTopology;
        String ecLabel;
        String ncLabel;
        String dataLabel;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String volumeName = this.getRwVolumeName();
        boolean updateVolumeProperties = false;
        String topology = this.getValue(RW_VOLUME_PARAM_TOPOLOGY);
        if (topology != null) {
            if (topology.equals("") || !topology.startsWith("/")) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid topology specified"));
                return output;
            }
            updateVolumeProperties = true;
        }
        if ((dataLabel = this.getValue(DATA_LABEL)) != null) {
            if (dataLabel.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid argument for volume label"));
                return output;
            }
            updateVolumeProperties = true;
        }
        if ((ncLabel = this.getValue(NAMESPACE_LABEL)) != null) {
            if (ncLabel.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid argument for volume label"));
                return output;
            }
            updateVolumeProperties = true;
        }
        if ((ecLabel = this.getValue(RW_VOLUME_PARAM_ECLABEL)) != null) {
            if (ecLabel.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid argument for volume eclabel"));
                return output;
            }
            updateVolumeProperties = true;
        }
        if ((ecTopology = this.getValue(RW_VOLUME_PARAM_ECTOPOLOGY)) != null && (ecTopology.equals("") || !ecTopology.startsWith("/"))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ectopology specified"));
            return output;
        }
        if (!updateVolumeProperties && ecTopology == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "none of the valid arguments specified"));
            return output;
        }
        String cluster = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
        CLDBProto.VolumeProperties volProps = this.validateVolumeMoveRequest(volumeName, cluster, ecTopology, ecLabel, out);
        if (volProps == null) {
            return output;
        }
        if (updateVolumeProperties) {
            this.updateVolumeProperties(volumeName, topology, dataLabel, ncLabel, cluster, out);
        }
        if (ecTopology != null || ecLabel != null) {
            int backendVolId = volProps.getTierRelationships().getBackendEcVolumeId();
            this.updateEcVolumeProperties(backendVolId, ecTopology, ecLabel, cluster, out);
        }
        return output;
    }

    private String getValue(String param) throws CLIProcessingException {
        return this.isParamPresent(param) ? this.getParamTextValue(param, 0) : null;
    }

    private CLDBProto.VolumeProperties validateVolumeMoveRequest(String volumeName, String cluster, String ecTopology, String ecLabel, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse volLookupResp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), volumeName, "", this.isServerCall);
        if (volLookupResp == null || volLookupResp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Volume could not found"));
            return null;
        }
        CLDBProto.VolumeProperties volProps = volLookupResp.getVolInfo().getVolProperties();
        if (!(ecTopology == null && ecLabel == null || volProps.hasTierRelationships() && volProps.getTierRelationships().hasBackendEcVolumeId())) {
            if (ecTopology != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ectopology can not be specified with non supported EC volumes"));
            } else if (ecLabel != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "eclabel can not be specified with non supported EC volumes"));
            }
            return null;
        }
        return volProps;
    }

    public void updateEcVolumeProperties(int volumeId, String topology, String label, String cluster, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.VolumeMoveRequest.Builder volumeMoveRequest = CLDBProto.VolumeMoveRequest.newBuilder().setCreds(this.getUserCredentials()).setVolumeId(volumeId);
        if (topology != null) {
            CLDBProto.VolumeTopology newTopology = CLDBProto.VolumeTopology.newBuilder().setTopologyRestricted(topology).build();
            volumeMoveRequest.setNewTopology(newTopology);
        }
        if (label != null) {
            volumeMoveRequest.setNewLabel(label);
        }
        byte[] data = null;
        try {
            CLDBProto.VolumeMoveResponse resp;
            data = cluster == null ? CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMoveProc.getNumber(), (MessageLite)volumeMoveRequest.build(), CLDBProto.VolumeMoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMoveProc.getNumber(), (MessageLite)volumeMoveRequest.build(), CLDBProto.VolumeMoveResponse.class);
            if (data == null) {
                String errorMsg = "Unable to update ectopology...Got null response from CLDB. Check CLDB logs";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, errorMsg));
            }
            if ((resp = CLDBProto.VolumeMoveResponse.parseFrom((byte[])data)).getStatus() == 0) {
                out.addMessage("Updated volume " + volumeId + " with " + (String)(topology != null ? "ectopology to " + topology : "") + (String)(label != null ? " eclabel to " + label : ""));
            } else {
                String errorMsg = "Unable to update ectopology/ecLabel " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            String errorMsg = "Exception while updating ectopology/eclabel " + e.getMessage();
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, errorMsg));
        }
    }

    private void updateVolumeProperties(String volumeName, String topology, String dataLabel, String ncLabel, String cluster, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.VolumeMoveResponse resp = VolumeCommands.sendVolumeMoveRequest(volumeName, topology, dataLabel, ncLabel, cluster, this.getUserCredentials());
        if (resp == null) {
            String errorMsg = "Unable to update topology/label...Got null response from CLDB";
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, errorMsg));
            return;
        }
        if (resp.getStatus() == 0) {
            out.addMessage("Updated topology/label of volume " + volumeName);
        } else {
            String errorMsg = "Unable to update topology/label..." + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
        }
    }

    public static CLDBProto.VolumeMoveResponse sendVolumeMoveRequest(String volumeName, String topology, String dataLabel, String ncLabel, String cluster, Security.CredentialsMsg creds) throws CLIProcessingException {
        CLDBProto.VolumeMoveRequest.Builder volumeMoveReq = CLDBProto.VolumeMoveRequest.newBuilder().setCreds(creds).setVolumeName(volumeName);
        if (topology != null) {
            CLDBProto.VolumeTopology newTopology = CLDBProto.VolumeTopology.newBuilder().setTopologyRestricted(topology).build();
            volumeMoveReq.setNewTopology(newTopology);
        }
        if (dataLabel != null) {
            volumeMoveReq.setNewLabel(dataLabel);
        }
        if (ncLabel != null) {
            volumeMoveReq.setNewNamespaceLabel(ncLabel);
        }
        byte[] data = null;
        try {
            data = cluster == null ? CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMoveProc.getNumber(), (MessageLite)volumeMoveReq.build(), CLDBProto.VolumeMoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMoveProc.getNumber(), (MessageLite)volumeMoveReq.build(), CLDBProto.VolumeMoveResponse.class);
            if (data == null) {
                return null;
            }
            return CLDBProto.VolumeMoveResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while updating topology/label", (Throwable)e);
            return null;
        }
    }

    public static CLDBProto.VolumeLookupResponse volumeLookup(String cluster, Security.CredentialsMsg creds, String name, String path, boolean isServerCall) throws CLIProcessingException {
        byte[] data = null;
        CLDBProto.VolumeLookupRequest volumeInfo = null;
        volumeInfo = name != null ? CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(name).setCreds(creds).build() : CLDBProto.VolumeLookupRequest.newBuilder().setMountDir(path).setCreds(creds).build();
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)volumeInfo, CLDBProto.VolumeLookupResponse.class, VolumeCommands.getKeyType((String)cluster, (boolean)isServerCall)) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)volumeInfo, CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException...", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing volume Lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    private CommandOutput volumeInfo() throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse resp;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = null;
        String rwMountDir = null;
        if (this.isParamPresent(RW_VOLUME_PARAM_NAME)) {
            rwVolumeName = this.getRwVolumeName();
        }
        if (this.isParamPresent(RW_VOLUME_PARAM_MOUNTDIR)) {
            rwMountDir = this.getParamTextValue(RW_VOLUME_PARAM_MOUNTDIR, 0);
        }
        if (rwVolumeName == null && rwMountDir == null) {
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Volume info arguments missing. Pass either volumename or mountdir"));
            return output;
        }
        if (rwVolumeName != null && rwMountDir != null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Volume info has both volumename and mountdir. Pass only one"));
            return output;
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((resp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), rwVolumeName, rwMountDir, this.isServerCall)).getStatus() != 0) {
            String name = rwVolumeName != null ? rwVolumeName : rwMountDir;
            String msg = resp.getStatus() == 2 ? "No such volume" : Errno.toString((int)resp.getStatus());
            String errorDescription = "Volume lookup of " + name + " failed, " + msg;
            CommandOutput.OutputHierarchy.OutputError errorNode = new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorDescription);
            errorNode.setPropagateErrorSupport(true).setField(RW_VOLUME_PARAM_NAME).setFieldValue(name);
            out.addError(errorNode);
            return output;
        }
        String opParam = this.getOutputParamValue();
        boolean terse = opParam.equals("terse");
        BitSet columns = this.getColumns();
        this.addVolumeInfo(resp.getVolInfo(), terse, columns, out);
        return output;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.VolumeListRequest.Builder newReqBuilder = null;
        if (prevReq != null) {
            newReqBuilder = CLDBProto.VolumeListRequest.newBuilder((CLDBProto.VolumeListRequest)((CLDBProto.VolumeListRequest)prevReq));
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.VolumeListResponse)prevResp).getVolumesCount();
            int origStart = this.getStartParamValue();
            int origLimit = this.getLimitParamValue();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 512));
        } else {
            newReqBuilder = this.getVolumeListRequestBuilder();
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getStartParamValue(), this.getLimitParamValue(), ((CLDBProto.VolumeListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.VolumeListResponse)prevResp).getVolumesCount());
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.VolumeListResponse resp = (CLDBProto.VolumeListResponse)response;
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        for (CLDBProto.VolumeInfo v : resp.getVolumesList()) {
            this.addVolumeInfo(v, terse, columns, out);
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
        this.listedVolumes.addAll(resp.getVolumesList());
    }

    @Override
    public MessageLite sendRequest(MessageLite req) throws CLIProcessingException {
        byte[] data;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeListProc.getNumber(), req, CLDBProto.VolumeListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeListProc.getNumber(), req, CLDBProto.VolumeListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data != null) {
            return this.getVolumeListResponse(data);
        }
        LOG.error((Object)"RPC Request to list volumes failed. No data returned");
        return null;
    }

    private CLDBProto.VolumeListRequest.Builder getVolumeListRequestBuilder() throws CLIProcessingException {
        List<CLIProto.Filter> filters = this.getFilters(fieldTable, FILTER_PARAM_NAME);
        BitSet columns = this.getColumns();
        ByteString bString = ByteString.copyFrom((byte[])BitSetBytesHelperUtils.toByteArray((BitSet)columns));
        long columnsOld = BitSetBytesHelperUtils.convert((BitSet)columns);
        boolean alarmedVolumes = this.getAlarmedVolumesParamValue();
        CLDBProto.VolumeListRequest.Builder req = CLDBProto.VolumeListRequest.newBuilder();
        if (this.isParamPresent(RW_VOLUME_NODES)) {
            String nodesString = this.getParamTextValue(RW_VOLUME_NODES, 0);
            ArrayList<String> nodes = new ArrayList<String>();
            if (nodesString.contains(MULTI_ARG_SEP)) {
                nodes.addAll(Arrays.asList(nodesString.split(MULTI_ARG_SEP)));
            } else {
                nodes.add(nodesString);
            }
            for (String node : nodes) {
                List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(node));
                if (ips.isEmpty()) {
                    LOG.error((Object)("Can not get valid IP address out of provided name: " + node));
                    throw new CLIProcessingException("Invalid Node specified. Could not resolve IP for node : " + node);
                }
                String ipAddress = ips.get(0);
                if (ipAddress == null) continue;
                try {
                    int ip = Util.ipToInt((String)ipAddress);
                    req.addNodeIps(ip);
                }
                catch (NumberFormatException e) {
                    throw new CLIProcessingException("Invalid Node specified. Could not resolve IP for node : " + node);
                }
            }
        }
        if (this.isParamPresent(SORTBY_PARAM_NAME)) {
            String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
            CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
            req.setSortKey(sortKey);
            if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                boolean order = false;
                if (sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                    order = true;
                }
                req.setSortDescending(order);
            }
        }
        CLIProto.Limiter limiter = this.getNextLimiter(this.getStartParamValue(), 0, this.getStartParamValue(), this.getLimitParamValue(), 512);
        return req.setCreds(this.getUserCredentials()).addAllFilter(filters).setColumns(columnsOld).setColumnsAdd(bString).setAlarmedvolumes(alarmedVolumes).setLimiter(limiter);
    }

    private boolean getAlarmedVolumesParamValue() throws CLIProcessingException {
        return this.isParamPresent(ALARMEDVOLUMES_PARAM_NAME) ? this.getParamBooleanValue(ALARMEDVOLUMES_PARAM_NAME, 0) : false;
    }

    private BitSet getColumns() throws CLIProcessingException {
        BitSet columns = new BitSet();
        columns.set(0, MAX_VOLUMEFIELDINFO + 1);
        String columnsString = this.getColumnsParamValue();
        if (columnsString != null && !columnsString.equals("all")) {
            columns = FilterUtil.getColumns(fieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    private CLDBProto.VolumeListResponse getVolumeListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.VolumeListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into VolumeListResponse proto object.", (Throwable)ipbe);
        }
    }

    private void addVolumeInfo(CLDBProto.VolumeInfo volInfo, boolean terse, BitSet columns, CommandOutput.OutputHierarchy out) {
        CommandOutput.OutputHierarchy.OutputNode volumeInfo = new CommandOutput.OutputHierarchy.OutputNode();
        ArrayList<String> messages = new ArrayList<String>();
        this.formatVolumeInfo(volInfo, terse, columns, volumeInfo, messages);
        out.addNode(volumeInfo);
        for (String msg : messages) {
            out.addMessage(msg);
        }
    }

    private static CommandOutput.OutputHierarchy.OutputNode formatNoteState(CLDBProto.NoteStateInfo nsInfo, int version) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Uid", nsInfo.getUid()));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Date", (Object)nsInfo.getDate()));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Comment", (Object)nsInfo.getComment()));
        return out;
    }

    private static CommandOutput.OutputHierarchy.OutputNode formatNote(CLDBProto.Note note, int version) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("NoteState", (Object)note.getState()));
        if (note.hasAdded()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("NoteAdded", (Object)VolumeCommands.formatNoteState(note.getAdded(), version)));
        }
        if (note.hasResolved()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("NoteResolved", (Object)VolumeCommands.formatNoteState(note.getResolved(), version)));
        }
        return out;
    }

    private static CommandOutput.OutputHierarchy formatNoteEntryList(List<CLDBProto.NoteEntry> noteEntryList, int version) {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        for (CLDBProto.NoteEntry ne : noteEntryList) {
            CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Notename", (Object)ne.getNoteName()));
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Note", (Object)VolumeCommands.formatNote(ne.getNote(), version)));
            oh.addNode(out);
        }
        return oh;
    }

    private CommandOutput.OutputHierarchy.OutputNode getSnapshotRestoreOutputNode(CLDBProto.SnapshotRestoreStatusInfo sInfo, boolean terse) {
        CommandOutput.OutputHierarchy.OutputNode snapRestNode = new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.snapshotRestore)).getName(terse));
        snapRestNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapshotname", (Object)sInfo.getSnapshotName()));
        snapRestNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapshotid", sInfo.getSnapshotId()));
        snapRestNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("inprogress", (Object)sInfo.getInProgress()));
        snapRestNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("seqnum", sInfo.getSnapshotRestoreEpoch()));
        if (sInfo.getInProgress()) {
            snapRestNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numcontainerstotal", sInfo.getNumContainersTotal()));
            snapRestNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numcontainersinprogress", sInfo.getNumContainersInProgress()));
        }
        return snapRestNode;
    }

    private Common.VolumeAces getFilledVolAce(Common.VolumeAces volAce) {
        ByteString readExpr = ByteString.copyFromUtf8((String)"p");
        ByteString writeExpr = ByteString.copyFromUtf8((String)"p");
        if (volAce != null) {
            for (Common.VolumeAceEntry aceEntry : volAce.getAcesList()) {
                if (aceEntry.getAccessType() == Common.VolumeActions.VOLUME_READ) {
                    readExpr = aceEntry.getExpr();
                    continue;
                }
                if (aceEntry.getAccessType() != Common.VolumeActions.VOLUME_WRITE) continue;
                writeExpr = aceEntry.getExpr();
            }
        }
        Common.VolumeAceEntry readAceEnt = Common.VolumeAceEntry.newBuilder().setAccessType(Common.VolumeActions.VOLUME_READ).setExpr(readExpr).build();
        Common.VolumeAceEntry writeAceEnt = Common.VolumeAceEntry.newBuilder().setAccessType(Common.VolumeActions.VOLUME_WRITE).setExpr(writeExpr).build();
        return Common.VolumeAces.newBuilder().addAces(readAceEnt).addAces(writeAceEnt).build();
    }

    private void formatVolumeInfo(CLDBProto.VolumeInfo volInfo, boolean terse, BitSet columns, CommandOutput.OutputHierarchy.OutputNode outputNode, ArrayList<String> messages) {
        CLDBProto.TierRelationships tierR;
        String rp;
        CLDBProto.VolumeProperties props = volInfo.getVolProperties();
        List<Common.PluggableAlarm> pluggableAlarms = null;
        int version = this.getVersion();
        CLDBProto.FileFilterLookupResponse flresp = null;
        String cluster = null;
        try {
            if (this.isParamPresent("cluster")) {
                cluster = this.getParamTextValue("cluster", 0);
            }
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Error getting clustername" + e.getMessage()));
        }
        try {
            pluggableAlarms = PluggableAlarmUtil.getVolumeAlarms(this.getUserCredentials(), 0, 50);
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Error getting alarms. Alarm message might be incomplete: " + e.getMessage()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.noteEntries.getNumber())) {
            CommandOutput.OutputHierarchy oh = VolumeCommands.formatNoteEntryList(volInfo.getNotesList(), version);
            for (Object a : oh.getOutputNodes()) {
                outputNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.noteEntries)).getName(terse), a));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.acl.getNumber())) {
            String format = terse ? "terse" : "short";
            CommandOutput.OutputHierarchy volAcl = AclCommands.formatAcl(props.getAcl(), CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, format, this.uInfo, null, null);
            for (CommandOutput.OutputHierarchy.OutputError e : volAcl.getOutputErrors()) {
                LOG.info((Object)("Error in volume output:" + e.toString()));
            }
            for (CommandOutput.OutputHierarchy.OutputNode a : volAcl.getOutputNodes()) {
                LOG.info((Object)("Output Node:" + a.toJSONString()));
                outputNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.acl)).getName(terse), (Object)a));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.owner.getNumber())) {
            int ownerId = props.getOwnerId();
            Object ownerName = null;
            try {
                ownerName = this.uInfo.getUsername(ownerId);
            }
            catch (SecurityException se) {
                ownerName = "Uid " + ownerId;
            }
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.owner)).getName(terse), ownerName));
        }
        if (props.hasVolumeAe() && (columns.get(CLDBProto.VolumeInfoFields.aeName.getNumber()) || columns.get(CLDBProto.VolumeInfoFields.aeType.getNumber()))) {
            CLDBProto.AeKey key = props.getVolumeAe();
            if (key.hasObjectStoreAccountId()) {
                if (volInfo.hasAeProperty() && volInfo.getAeProperty().hasObjStoreProperties()) {
                    outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.aeName)).getName(terse), (Object)volInfo.getAeProperty().getObjStoreProperties().getAccountName()));
                }
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.objectStoreAccountId)).getName(terse), key.getObjectStoreAccountId()));
            } else {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.aeName)).getName(terse), (Object)key.getName()));
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.aeType)).getName(terse), key.getType(), version, true));
            }
        }
        if (volInfo.hasTenantUser() && columns.get(CLDBProto.VolumeInfoFields.tenantUser.getNumber())) {
            String tenantUser = volInfo.getTenantUser();
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tenantUser)).getName(terse), (Object)tenantUser));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.numReplicas.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numReplicas)).getName(terse), props.getReplicationPolicy().getNumReplicas(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.minReplicas.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.minReplicas)).getName(terse), props.getReplicationPolicy().getGuaranteedMinReplicas(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.AtimeUpdateInterval.getNumber())) {
            StringBuilder SB = new StringBuilder();
            if (props.hasAtimeUpdateIntervalSecs() && props.getAtimeUpdateIntervalSecs() > 0) {
                if (props.getAtimeUpdateIntervalSecs() < 86400) {
                    SB.append(props.getAtimeUpdateIntervalSecs());
                    SB.append("secs");
                } else {
                    SB.append(props.getAtimeUpdateIntervalSecs() / 86400);
                }
            } else {
                SB.append(0);
            }
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.AtimeUpdateInterval)).getName(terse), (Object)SB.toString(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.atimeTrackingStartTime.getNumber()) && props.hasAtimeTrackingStartTimeSecs()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss 'GMT'Z");
            dateFormat.setTimeZone(TimeZone.getDefault());
            String timeStamp = dateFormat.format(new Date(props.getAtimeTrackingStartTimeSecs() * 1000L));
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.atimeTrackingStartTime)).getName(terse), (Object)timeStamp, version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.namespaceContainerNumReplicas.getNumber()) && props.hasNumNamespaceReplicas()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.namespaceContainerNumReplicas)).getName(terse), props.getNumNamespaceReplicas(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.namespaceContainerMinReplicas.getNumber()) && props.hasGuaranteedMinNamespaceReplicas()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.namespaceContainerMinReplicas)).getName(terse), props.getGuaranteedMinNamespaceReplicas(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.enforceMinReplication.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.enforceMinReplication)).getName(terse), props.getEnforceMinReplication(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.containerAllocationFactor.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.containerAllocationFactor)).getName(terse), props.getContainerAllocationFactor(), version));
        }
        if (props.hasAllowGrant() && columns.get(CLDBProto.VolumeInfoFields.allowGrant.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.allowGrant)).getName(terse), props.getAllowGrant(), version, false));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.reReplicationTimeOutSec.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.reReplicationTimeOutSec)).getName(terse), props.getReReplicationTimeOutSec(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.criticalReReplicationTimeOutSec.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.criticalReReplicationTimeOutSec)).getName(terse), props.getCriticalReReplicationTimeOutSec(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.dataContainerRepltype.getNumber())) {
            Common.ContainerReplType type = Common.ContainerReplType.CASCADE;
            if (props.getReplicationPolicy().hasDataContainerReplType()) {
                type = props.getReplicationPolicy().getDataContainerReplType();
            }
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dataContainerRepltype)).getName(terse), (Object)this.getContainerReplTypeString(type)));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.filterList.getNumber()) && props.getFileFilterIdsCount() > 0) {
            try {
                flresp = FileFilterCommands.filterLookupById(cluster, this.getUserCredentials(), props.getFileFilterIds(0));
                if (flresp.getStatus() == 0) {
                    outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.filterList)).getName(terse), (Object)flresp.getProperties().getFilterName()));
                }
            }
            catch (Exception type) {
                // empty catch block
            }
        }
        boolean localVolumeReplOne = false;
        String topo = props.getTopology().getTopologyRestricted();
        if (props.getLocalVolume() && props.getReplicationPolicy().getNumReplicas() == 1) {
            localVolumeReplOne = true;
            if (props.hasLocalTopology()) {
                topo = props.getLocalTopology().getTopologyRestricted();
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.rackPath.getNumber())) {
            rp = topo.equals("") ? "/" : topo;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.rackPath)).getName(terse), (Object)rp));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.localPath.getNumber()) && props.hasLocalTopology() && !localVolumeReplOne) {
            rp = props.getLocalTopology().getTopologyRestricted().equals("") ? "/" : props.getLocalTopology().getTopologyRestricted();
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.localPath)).getName(terse), (Object)rp));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mirrorThrottle.getNumber()) && props.hasMirrorThrottle()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorThrottle)).getName(terse), props.getMirrorThrottle(), version, true));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeAccessTime.getNumber())) {
            Date date = volInfo.hasAtime() ? new Date(volInfo.getAtime()) : null;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeAccessTime)).getName(terse), date, version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.readOnly.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.readOnly)).getName(terse), props.getReadOnly(), version, true));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mountDir.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mountDir)).getName(terse), (Object)props.getMountDir()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeName.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeName)).getName(terse), (Object)props.getVolumeName()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mounted.getNumber())) {
            Integer m = props.getMounted() ? 1 : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mounted)).getName(terse), (Object)m));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.quota.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.quota)).getName(terse), props.getVolumeQuotaSizeMB(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.advisoryquota.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.advisoryquota)).getName(terse), props.getVolumeQuotaAdvisorySizeMB(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.snapshotcount.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.snapshotcount)).getName(terse), props.getNumSnapshots()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.logicalUsed.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.logicalUsed)).getName(terse), volInfo.getVolQuota().getVolumeLogicalUsedSizeMB(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.replicatedLogicalUsed.getNumber())) {
            long replicatedLogicalUsed = volInfo.getVolQuota().getVolumeLogicalUsedSizeMB() * (long)props.getReplicationPolicy().getNumReplicas();
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.replicatedLogicalUsed)).getName(terse), replicatedLogicalUsed, version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.used)).getName(terse), volInfo.getVolQuota().getVolumeUsedSizeMB(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.snapshotUsed.getNumber())) {
            long snapSize = volInfo.getVolumeSnapshotsOwnedSizeMB();
            if ((snapSize -= volInfo.getVolQuota().getVolumeSharedSizeMB()) < 0L) {
                snapSize = 0L;
            }
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.snapshotUsed)).getName(terse), snapSize, version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber()) && volInfo.getVolQuota().hasNumFile()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numFile)).getName(terse), volInfo.getVolQuota().getNumFile(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber()) && volInfo.getVolQuota().hasNumDir()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numDir)).getName(terse), volInfo.getVolQuota().getNumDir(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber()) && volInfo.getVolQuota().hasNumFidMap()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numFidMap)).getName(terse), volInfo.getVolQuota().getNumFidMap(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber()) && volInfo.getVolQuota().hasNumTable()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numTable)).getName(terse), volInfo.getVolQuota().getNumTable(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber()) && volInfo.getVolQuota().hasNumS3Bucket()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numS3Bucket)).getName(terse), volInfo.getVolQuota().getNumS3Bucket(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.totalUsed.getNumber())) {
            long snapSize = volInfo.getVolumeSnapshotsOwnedSizeMB();
            if (snapSize < volInfo.getVolQuota().getVolumeSharedSizeMB()) {
                snapSize = volInfo.getVolQuota().getVolumeSharedSizeMB();
            }
            LOG.debug((Object)("volumeUsedSizeMB:" + volInfo.getVolQuota().getVolumeUsedSizeMB() + ", snapshotOwnedSizeMB:" + volInfo.getVolumeSnapshotsOwnedSizeMB() + ", volumeSharedSizeMB:" + volInfo.getVolQuota().getVolumeSharedSizeMB() + ", volumeOwnedSizeMB:" + volInfo.getVolQuota().getVolumeOwnedSizeMB()));
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.totalUsed)).getName(terse), snapSize + volInfo.getVolQuota().getVolumeOwnedSizeMB(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.replicatedTotalUsed.getNumber())) {
            long snapSize = volInfo.getVolumeSnapshotsOwnedSizeMB();
            long ownSize = volInfo.getVolQuota().getVolumeOwnedSizeMB();
            if (snapSize < 0L) {
                snapSize = 0L;
            }
            long replicatedTotalUsed = (snapSize + ownSize) * (long)props.getReplicationPolicy().getNumReplicas();
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.replicatedTotalUsed)).getName(terse), replicatedTotalUsed, version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.schedule.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.schedule)).getName(terse), volInfo.getVolProperties().getSchedulingPolicyId(), version));
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.scheduleName)).getName(terse), (Object)volInfo.getVolProperties().getSchedulingPolicyName()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mirrorSchedule.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorSchedule)).getName(terse), volInfo.getVolProperties().getMirrorSchedulingPolicyId(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeType.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeType)).getName(terse), props.getIsMirrorVol(), version, true));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.mirrorType.getNumber())) {
            int mtype;
            int n = mtype = props.getIsMirrorVol() ? 1 : 0;
            if (props.hasVolumetype() && props.getVolumetype().getNumber() != 0) {
                mtype = props.getVolumetype().getNumber();
            }
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorType)).getName(terse), mtype));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.CreatorContainerId.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.CreatorContainerId)).getName(terse), props.getCreatorContainerId()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.CreatorVolumeUuid.getNumber())) {
            StringBuilder creatorVolUuid = new StringBuilder();
            if (props.hasCreatorVolumeUuid()) {
                creatorVolUuid.append(props.getCreatorVolumeUuid().getId640());
                creatorVolUuid.append(":");
                creatorVolUuid.append(props.getCreatorVolumeUuid().getId641());
            }
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.CreatorVolumeUuid)).getName(terse), (Object)creatorVolUuid.toString()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeId.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeId)).getName(terse), volInfo.getVolumeId()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.listReplicas.getNumber())) {
            if (volInfo.getVolumeReplicationList().size() > 0) {
                for (CLDBProto.VolumeReplicationInfo vrInfo : volInfo.getVolumeReplicationList()) {
                    outputNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.listReplicas)).getName(terse), vrInfo.getPercent()));
                }
            } else if (props.getVolumeName() != null && props.getVolumeName().length() != 0) {
                outputNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.listReplicas)).getName(terse), (Object)("Information is not yet available for volume '" + props.getVolumeName() + "'. Please try again.")));
            } else {
                outputNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.listReplicas)).getName(terse), (Object)"Information is not yet available for volume. Please try again."));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.nameContainerSize.getNumber()) && volInfo.getRootContainerSizeMB() >= 0L) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.nameContainerSize)).getName(terse), volInfo.getRootContainerSizeMB()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.nameContainerId.getNumber()) && volInfo.hasRootContainer()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.nameContainerId)).getName(terse), volInfo.getRootContainer().getContainerId()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.nameContainerDataThreshold.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.nameContainerDataThreshold)).getName(terse), props.getNameContainerDataThreshold() / 0x100000L));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.needsGfsck.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.needsGfsck)).getName(terse), props.getNeedsGfsck(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold)).getName(terse), props.getMaxInodesAlarmThreshold(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.maxnssizembalarmthreshold.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.maxnssizembalarmthreshold)).getName(terse), props.getMaxNsSizeMbAlarmThreshold(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.dbReplLagSecAlarmThresh.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dbReplLagSecAlarmThresh)).getName(terse), props.getDbReplLagSecAlarmThresh(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.dbIndexLagSecAlarmThresh.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dbIndexLagSecAlarmThresh)).getName(terse), props.getDbIndexLagSecAlarmThresh(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.limitSpread.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.limitSpread)).getName(terse), props.getLimitVolumeSpread(), version, false));
        }
        if (volInfo.hasPartlyOutOfTopology() && columns.get(CLDBProto.VolumeInfoFields.partlyOutOfTopology.getNumber())) {
            Integer poot = volInfo.getPartlyOutOfTopology() ? 1 : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.partlyOutOfTopology)).getName(terse), (Object)poot));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.wireSecurityEnabled.getNumber())) {
            Integer wireSecurityEnabled = props.hasWireSecurityEnabled() ? (props.getWireSecurityEnabled() ? 1 : 0) : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.wireSecurityEnabled)).getName(terse), (Object)wireSecurityEnabled));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.skipWireSecurityForTierInternalOps.getNumber())) {
            Integer skipWireSecurityForTierInternalOps = props.hasSkipWireSecurityForTierInternalOps() ? (props.getSkipWireSecurityForTierInternalOps() ? 1 : 0) : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.skipWireSecurityForTierInternalOps)).getName(terse), (Object)skipWireSecurityForTierInternalOps));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.isAuditVolume.getNumber())) {
            Integer isAudited = props.getIsAuditVolume() ? 1 : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.isAuditVolume)).getName(terse), (Object)isAudited));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.audited.getNumber())) {
            Integer auditEnabled = props.getAudited() ? 1 : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.audited)).getName(terse), (Object)auditEnabled));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.forceAudit.getNumber())) {
            Integer forceAuditEnabled = props.hasForceAudit() ? (props.getForceAudit() ? 1 : 0) : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.forceAudit)).getName(terse), (Object)forceAuditEnabled));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.coalesceInterval.getNumber())) {
            Integer coalesceInterval = props.getCoalesceInterval();
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.coalesceInterval)).getName(terse), (Object)coalesceInterval));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.fsAuditEnabledOperations.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.fsAuditEnabledOperations)).getName(terse), (Object)GetStringsForAuditOps.getEnabledOps((long)props.getFsAuditDisabledOperations())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.fsAuditDisabledOperations.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.fsAuditDisabledOperations)).getName(terse), (Object)GetStringsForAuditOps.getDisabledOps((long)props.getFsAuditDisabledOperations())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.numActiveCgContainers.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numActiveCgContainers)).getName(terse), props.getNumActiveCgContainers()));
        }
        if (props.hasMirrorInfo()) {
            CLDBProto.MirrorInfo mirrorInfo = props.getMirrorInfo();
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorSrcVolume.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcVolume)).getName(terse), (Object)mirrorInfo.getSrcVolumeName()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorSrcVolumeId.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcVolumeId)).getName(terse), mirrorInfo.getSrcVolumeId()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorSrcClusterName.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcClusterName)).getName(terse), (Object)mirrorInfo.getSrcClusterName()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeName.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeName)).getName(terse), (Object)mirrorInfo.getDataGeneratorSrcVolumeName()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeId.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeId)).getName(terse), mirrorInfo.getDataGeneratorSrcVolumeId()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcClusterName.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcClusterName)).getName(terse), (Object)mirrorInfo.getDataGeneratorSrcClusterName()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.lastSuccessfulMirrorTime.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.lastSuccessfulMirrorTime)).getName(terse), mirrorInfo.getLastSuccessfulMirrorTime()));
            }
            if (props.hasMirrorSchedulingPolicyId()) {
                this.populateExpectedMirrorStartTime(props, terse, columns, outputNode);
            }
            if (columns.get(CLDBProto.VolumeInfoFields.dataSizeToMirror.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dataSizeToMirror)).getName(terse), mirrorInfo.getDataSizeToMirror()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.dataSizeMirrored.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dataSizeMirrored)).getName(terse), mirrorInfo.getDataSizeMirrored()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorPercentComplete.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorPercentComplete)).getName(terse), mirrorInfo.getPercentComplete()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorId.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorId)).getName(terse), mirrorInfo.getMirrorId()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.nextMirrorId.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.nextMirrorId)).getName(terse), mirrorInfo.getNextMirrorId()));
            }
            int mirrorStatus = 0;
            mirrorStatus = mirrorInfo.getMirrorStatus() == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_COMPLETE || mirrorInfo.getMirrorStatus() == CLDBProto.MirrorInfo.MirrorStatus.STATE_CONVERT_COMPLETE ? 0 : (mirrorInfo.getMirrorStatus() == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_FAILED ? 2 : 1);
            if (columns.get(CLDBProto.VolumeInfoFields.mirrorStatus.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorStatus)).getName(terse), mirrorStatus));
            }
            if (mirrorStatus == 2 && columns.get(CLDBProto.VolumeInfoFields.mirrorErrorCode.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mirrorErrorCode)).getName(terse), mirrorInfo.getErrorCode()));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.numContainers.getNumber()) && props.hasNumContainers()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numContainers)).getName(terse), props.getNumContainers(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.numMetaContainers.getNumber()) && volInfo.hasNumMetaContainers()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numMetaContainers)).getName(terse), volInfo.getNumMetaContainers(), version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.volumeAces.getNumber())) {
            CommandOutput.OutputHierarchy.OutputNode volumeAcesNode = new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeAces)).getName(terse));
            Common.VolumeAces volAces = volInfo.getVolumeAces();
            try {
                Common.VolumeAces volAce = null;
                if (volInfo.hasVolumeAces()) {
                    volAce = volInfo.getVolumeAces();
                }
                volAce = this.getFilledVolAce(volAce);
                for (Common.VolumeAceEntry aceEntry : volAce.getAcesList()) {
                    if (aceEntry.getAccessType() == Common.VolumeActions.VOLUME_READ) {
                        volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(VOL_READACE_PARAM, (Object)AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
                        continue;
                    }
                    if (aceEntry.getAccessType() == Common.VolumeActions.VOLUME_WRITE) {
                        volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(VOL_WRITEACE_PARAM, (Object)AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
                        continue;
                    }
                    Assert.assertNotNull(null);
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to parse volume aces");
            }
            outputNode.addChild(volumeAcesNode);
            if (volAces.getPolicyNamesCount() > 0) {
                Object policiesInCSF = "";
                int i = 0;
                for (String policyName : volAces.getPolicyNamesList()) {
                    policiesInCSF = i != 0 ? (String)policiesInCSF + MULTI_ARG_SEP + policyName : policyName;
                    ++i;
                }
                CommandOutput.OutputHierarchy.OutputNode securityPolicyNode = new CommandOutput.OutputHierarchy.OutputNode(PBS_SECURITY_POLICY, policiesInCSF);
                outputNode.addChild(securityPolicyNode);
            }
            String enforcementMode = Util.getVolumeEnforcementModeName((boolean)volAces.getEnforcePolicies(), (boolean)volAces.getEnforceAces(), (boolean)volAces.getEnableAuditOnlyPolicyCheck());
            CommandOutput.OutputHierarchy.OutputNode enforcementModeNode = new CommandOutput.OutputHierarchy.OutputNode(PBS_ENFORCEMENT_MODE, (Object)enforcementMode);
            outputNode.addChild(enforcementModeNode);
        }
        if (volInfo.hasSnapRestoreStatusInfo() && columns.get(CLDBProto.VolumeInfoFields.snapshotRestore.getNumber())) {
            CommandOutput.OutputHierarchy.OutputNode snapRestNode = this.getSnapshotRestoreOutputNode(volInfo.getSnapRestoreStatusInfo(), terse);
            outputNode.addChild(snapRestNode);
        }
        if (columns.get(CLDBProto.VolumeInfoFields.fixCreatorId.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.fixCreatorId)).getName(terse), props.getUseActualCreatorId(), version, false));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.replTypeConversionInProgress.getNumber())) {
            Integer inProgress = props.getReplTypeConversionInProgress() ? 1 : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.replTypeConversionInProgress)).getName(terse), (Object)inProgress, version));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.createTime.getNumber()) && props.hasCreateTime()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.createTime)).getName(terse), props.getCreateTime()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.metricsEnabled.getNumber())) {
            Integer metricsEnabled = props.getMetricsEnabled() ? 1 : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.metricsEnabled)).getName(terse), (Object)metricsEnabled));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.dareEnabled.getNumber())) {
            Integer dareEnabled = props.getDareEnabled() ? 1 : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dareEnabled)).getName(terse), (Object)dareEnabled));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.allowReadForExecute.getNumber())) {
            Integer allowReadForExecute = props.getAllowReadForExecute() ? 1 : 0;
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.allowReadForExecute)).getName(terse), (Object)allowReadForExecute));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.dataContainerLabel.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dataContainerLabel)).getName(terse), (Object)(props.hasLabel() ? props.getLabel() : "default")));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.nameContainerLabel.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.nameContainerLabel)).getName(terse), (Object)(props.hasNameCntrLabel() ? props.getNameCntrLabel() : "default")));
        }
        boolean isTierEnable = false;
        if (props.hasIsTierOffloadEnable()) {
            isTierEnable = props.getIsTierOffloadEnable();
        }
        if (isTierEnable) {
            if (columns.get(CLDBProto.VolumeInfoFields.totalLocal.getNumber())) {
                long tierLocal = volInfo.getVolQuota().getVolumeDataSizeMB() - volInfo.getVolQuota().getVolumePurgedSizeMB();
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.totalLocal)).getName(terse), (Object)Long.toString(tierLocal >= 0L ? tierLocal : 0L)));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.totalPurged.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.totalPurged)).getName(terse), (Object)Long.toString(volInfo.getVolQuota().getVolumePurgedSizeMB())));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.totalRecall.getNumber())) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.totalRecall)).getName(terse), (Object)Long.toString(volInfo.getVolQuota().getVolumeRecalledSizeMB())));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.isTierEnable.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.isTierEnable)).getName(terse), (Object)Boolean.toString(isTierEnable)));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.backendVolumeType.getNumber()) && props.hasTierRelationships() && props.getTierRelationships().hasBackendVolumeType()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.backendVolumeType)).getName(terse), props.getTierRelationships().getBackendVolumeType().getNumber()));
        }
        if (isTierEnable) {
            if (columns.get(CLDBProto.VolumeInfoFields.autoOffloadThresholdGB.getNumber()) && props.hasAutoOffloadThresholdGB()) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.autoOffloadThresholdGB)).getName(terse), (Object)Integer.toString(props.getAutoOffloadThresholdGB())));
            }
            this.addVolumeTierProperties(volInfo, props, outputNode, terse, columns);
            if (props.hasTierRelationships() && props.getTierRelationships().hasBackendEcVolumeId()) {
                this.addEcBackendVolInfo(props, outputNode, terse, columns);
            }
            if (props.hasTierRelationships() && props.getTierRelationships().hasBackendCacheVolumeId()) {
                this.addCacheVolInfo(props, outputNode, terse, columns);
            }
        } else if (props.hasTierRelationships() && (tierR = props.getTierRelationships()).hasBackendVolumeType() && tierR.getBackendVolumeType() == CLDBProto.TierRelationships.BackendVolumeType.EC_STORE && columns.get(CLDBProto.VolumeInfoFields.honorRackReliability.getNumber())) {
            boolean honorRackReliability = props.getHonorRackReliability();
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.honorRackReliability)).getName(terse), (Object)honorRackReliability));
        }
        if (!volInfo.getDataRobustnessPercentageList().isEmpty()) {
            for (Integer percentage : volInfo.getDataRobustnessPercentageList()) {
                CommandOutput.OutputHierarchy.OutputNode value = new CommandOutput.OutputHierarchy.OutputNode("dataRobustness", (Object)percentage);
                outputNode.addChild(value);
            }
        }
        this.addAlarmsInfo(volInfo, columns, terse, pluggableAlarms, outputNode);
    }

    private void populateExpectedMirrorStartTime(CLDBProto.VolumeProperties volProps, boolean terse, BitSet columns, CommandOutput.OutputHierarchy.OutputNode outputNode) {
        LocalDateTime expectedMirrorStartTime;
        CLDBProto.Policy policy;
        if (!volProps.hasMirrorSchedulingPolicyId() || volProps.getMirrorSchedulingPolicyId() == 0) {
            return;
        }
        long mirrorScheduleId = volProps.getMirrorSchedulingPolicyId();
        try {
            policy = this.getSchedule(mirrorScheduleId);
            if (policy == null) {
                LOG.error((Object)"schedule with given ID doesn't exist");
                return;
            }
        }
        catch (MaprSecurityException e) {
            return;
        }
        catch (Exception e) {
            LOG.error((Object)("RPC Request to fetch schedule failed. " + e.getMessage()));
            return;
        }
        long lastMirrorStartTime = volProps.getMirrorInfo().getLastMirrorStartTime();
        try {
            expectedMirrorStartTime = this.getExpectedMirrorStartTime(policy);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception encountered: " + e.getMessage()));
            return;
        }
        boolean expectedMirrorStarted = true;
        LocalDateTime lastMirrorDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(lastMirrorStartTime), ZoneId.systemDefault());
        if (lastMirrorDateTime.isBefore(expectedMirrorStartTime)) {
            expectedMirrorStarted = false;
        }
        if (columns.get(CLDBProto.VolumeInfoFields.expectedMirrorStartTime.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.expectedMirrorStartTime)).getName(terse), (Object)expectedMirrorStartTime));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.expectedMirrorStartTime.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.expectedMirrorStarted)).getName(terse), (Object)expectedMirrorStarted));
        }
    }

    private CLDBProto.Policy getSchedule(long mirrorScheduleId) throws MaprSecurityException, Exception {
        CLDBProto.SchedulePolicyProcRequest.Builder scheduleRequestBuilder = CLDBProto.SchedulePolicyProcRequest.newBuilder();
        scheduleRequestBuilder.setPolicyOp(CLDBProto.SchedulePolicyProcRequest.SchedulePolicyOP.LIST);
        CLDBProto.Policy.Builder policyBuilder = CLDBProto.Policy.newBuilder();
        scheduleRequestBuilder.setPolicy(policyBuilder.build());
        byte[] data = null;
        scheduleRequestBuilder.setCreds(this.getUserCredentials());
        data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class);
        if (data == null) {
            throw new Exception("No data returned.");
        }
        CLDBProto.SchedulePolicyProcResponse resp = CLDBProto.SchedulePolicyProcResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 1) {
            throw new Exception("Not enough privileges to view the list of schedules.");
        }
        for (CLDBProto.Policy p : resp.getPoliciesList()) {
            if ((long)p.getPolicyId() != mirrorScheduleId) continue;
            return p;
        }
        return null;
    }

    private LocalDateTime getExpectedMirrorStartTime(CLDBProto.Policy policy) throws Exception {
        LocalDateTime expectedMirrorStartTime = LocalDateTime.MIN;
        LocalDateTime nowDateTime = LocalDateTime.now();
        List rules = policy.getPolicyRulesList();
        for (CLDBProto.PolicyRule rule : rules) {
            LocalDateTime derived = this.deriveLastExpectedTime(rule, nowDateTime);
            if (!expectedMirrorStartTime.isBefore(derived) || !derived.isBefore(nowDateTime) && !derived.isEqual(nowDateTime)) continue;
            expectedMirrorStartTime = derived;
        }
        return expectedMirrorStartTime;
    }

    private LocalDateTime deriveLastExpectedTime(CLDBProto.PolicyRule rule, LocalDateTime nowDateTime) throws IllegalArgumentException, Exception {
        long lastExpectedTime = 0L;
        Object date = null;
        LocalDate expectedDate = null;
        LocalTime expectedTime = null;
        int hours = 0;
        int minutes = 0;
        if (rule.hasDate()) {
            expectedDate = this.parseDate(rule.getDate(), nowDateTime);
        }
        if (expectedDate == null) {
            expectedDate = LocalDate.now();
        }
        if (rule.hasTime()) {
            hours = rule.getTime();
        } else {
            switch (rule.getFrequency()) {
                case yearly: 
                case monthly: 
                case weekly: {
                    hours = 0;
                    break;
                }
                default: {
                    hours = nowDateTime.getHour();
                }
            }
        }
        if (rule.hasMinutes()) {
            minutes = rule.getMinutes();
        } else if (!rule.hasTime()) {
            minutes = nowDateTime.getMinute();
        }
        expectedTime = LocalTime.of(hours, minutes);
        LocalDateTime expectedDateTime = LocalDateTime.of(expectedDate, expectedTime);
        switch (rule.getFrequency()) {
            case once: {
                break;
            }
            case yearly: {
                if (!nowDateTime.toLocalDate().isBefore(expectedDateTime.toLocalDate())) break;
                expectedDateTime = expectedDateTime.minusYears(1L);
                break;
            }
            case monthly: {
                if (!nowDateTime.isBefore(expectedDateTime)) break;
                expectedDateTime = expectedDateTime.minusMonths(1L);
                break;
            }
            case weekly: {
                if (!nowDateTime.isBefore(expectedDateTime)) break;
                expectedDateTime = expectedDateTime.minusWeeks(1L);
                break;
            }
            case daily: {
                if (!nowDateTime.toLocalTime().isBefore(expectedDateTime.toLocalTime())) break;
                expectedDateTime = expectedDateTime.minusDays(1L);
                break;
            }
            case hourly: {
                if (!nowDateTime.toLocalDate().isEqual(expectedDateTime.toLocalDate())) break;
                expectedDateTime = expectedDateTime.withMinute(0);
                break;
            }
            case semihourly: {
                minutes = expectedDateTime.getMinute();
                expectedDateTime = expectedDateTime.minusMinutes(minutes % 30);
                break;
            }
            case quarterhourly: {
                minutes = expectedDateTime.getMinute();
                expectedDateTime = expectedDateTime.minusMinutes(minutes % 15);
                break;
            }
            case minute: {
                expectedDateTime = expectedDateTime.minusMinutes(1L);
                break;
            }
            case fiveminutes: {
                minutes = expectedDateTime.getMinute();
                expectedDateTime = expectedDateTime.minusMinutes(minutes % 5);
                break;
            }
            case tenminutes: {
                minutes = expectedDateTime.getMinute();
                expectedDateTime = expectedDateTime.minusMinutes(minutes % 10);
                break;
            }
            case twentyminutes: {
                minutes = expectedDateTime.getMinute();
                expectedDateTime = expectedDateTime.minusMinutes(minutes % 20);
                break;
            }
            case twentyfiveminutes: {
                minutes = expectedDateTime.getMinute();
                expectedDateTime = expectedDateTime.minusMinutes(minutes % 25);
                break;
            }
            case fortyfiveminutes: {
                minutes = expectedDateTime.getMinute();
                expectedDateTime = expectedDateTime.minusMinutes(minutes % 45);
                break;
            }
            default: {
                throw new Exception("Unknown policy rule frequency");
            }
        }
        return expectedDateTime;
    }

    private LocalDate parseDate(String date, LocalDateTime nowDateTime) throws Exception {
        if (date == null || date.equals("")) {
            return null;
        }
        String[] dateTokens = date.split("/");
        LocalDate dateToday = nowDateTime.toLocalDate();
        int year = dateToday.getYear();
        if (dateTokens.length > 1 && dateTokens.length <= 3) {
            if (dateTokens.length == 3) {
                return LocalDate.of(Integer.parseInt(dateTokens[2]), Integer.parseInt(dateTokens[0]), Integer.parseInt(dateTokens[1]));
            }
            return LocalDate.of(year, Integer.parseInt(dateTokens[1]), Integer.parseInt(dateTokens[0]));
        }
        int month = dateToday.getMonth().getValue();
        try {
            int day = Integer.valueOf(date);
            return LocalDate.of(year, month, day);
        }
        catch (NumberFormatException e) {
            DayOfWeek dayOfWeek = DayOfWeek.of(WeekDays.valueOf(date).getDayOfTheWeek());
            return LocalDate.now().with(TemporalAdjusters.previousOrSame(dayOfWeek));
        }
    }

    private void addAlarmsInfo(CLDBProto.VolumeInfo volInfo, BitSet columns, boolean terse, List<Common.PluggableAlarm> pluggableAlarms, CommandOutput.OutputHierarchy.OutputNode outputNode) {
        ArrayList<CommandOutput.OutputHierarchy.OutputNode> alarmNameOp = new ArrayList<CommandOutput.OutputHierarchy.OutputNode>(volInfo.getVolumeAlarmsCount());
        block0: for (Common.AlarmMsg vAlarm : volInfo.getVolumeAlarmsList()) {
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_SNAPSHOT_FAILURE) {
                if (!columns.get(CLDBProto.VolumeInfoFields.SnapshotFailureAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.SnapshotFailureAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_MIRROR_FAILURE) {
                if (!columns.get(CLDBProto.VolumeInfoFields.MirrorFailureAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.MirrorFailureAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_DATA_UNAVAILABLE) {
                if (!columns.get(CLDBProto.VolumeInfoFields.DataUnavailableAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.DataUnavailableAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_DATA_UNDER_REPLICATED) {
                if (!columns.get(CLDBProto.VolumeInfoFields.DataUnderReplicatedAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.DataUnderReplicatedAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_ADVISORY_QUOTA_EXCEEDED) {
                if (!columns.get(CLDBProto.VolumeInfoFields.AdvisoryQuotaExceededAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.AdvisoryQuotaExceededAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_QUOTA_EXCEEDED) {
                if (!columns.get(CLDBProto.VolumeInfoFields.QuotaExceededAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.QuotaExceededAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_NO_NODES_IN_TOPOLOGY) {
                if (!columns.get(CLDBProto.VolumeInfoFields.NoNodesInTopologyAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.NoNodesInTopologyAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_TOPOLOGY_ALMOST_FULL) {
                if (!columns.get(CLDBProto.VolumeInfoFields.AlmostFullTopologyAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.AlmostFullTopologyAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_TOPOLOGY_FULL) {
                if (!columns.get(CLDBProto.VolumeInfoFields.FullTopologyAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.FullTopologyAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_INODES_EXCEEDED) {
                if (!columns.get(CLDBProto.VolumeInfoFields.InodesExceededAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.InodesExceededAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_BECOME_MASTER_STUCK) {
                if (!columns.get(CLDBProto.VolumeInfoFields.BecomeMasterStuckAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.BecomeMasterStuckAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_DATA_CONTAINERS_NONLOCAL) {
                if (!columns.get(CLDBProto.VolumeInfoFields.ContainersNonLocalAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.ContainersNonLocalAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_CANNOT_MIRROR) {
                if (!columns.get(CLDBProto.VolumeInfoFields.CannotMirrorAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.CannotMirrorAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_OFFLOAD_RECALL_FAILURE) {
                if (!columns.get(CLDBProto.VolumeInfoFields.OffloadRecallFailureAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.OffloadRecallFailureAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_COMPACTION_FAILURE) {
                if (!columns.get(CLDBProto.VolumeInfoFields.CompactionFailureAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.CompactionFailureAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_DEGRADED_EC_STRIPES) {
                if (!columns.get(CLDBProto.VolumeInfoFields.DegradedEcStripesAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.DegradedEcStripesAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_CRITICALLY_DEGRADED_EC_STRIPES) {
                if (!columns.get(CLDBProto.VolumeInfoFields.CriticallyDegradedEcStripesAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.CriticallyDegradedEcStripesAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_EC_DATA_UNAVAILABLE) {
                if (!columns.get(CLDBProto.VolumeInfoFields.EcDataUnavailableAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.EcDataUnavailableAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (vAlarm.getAlarmId() == Common.AlarmId.VOLUME_ALARM_SNAPRESTORE_MAXRETRIES_EXCEEDED) {
                if (!columns.get(CLDBProto.VolumeInfoFields.SnaprestoreMaxretriesExceededAlarm.getNumber())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.SnaprestoreMaxretriesExceededAlarm)).getName(terse), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                alarmNameOp.add(new CommandOutput.OutputHierarchy.OutputNode(vAlarm.getAlarmId().name(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            for (Common.PluggableAlarm pluggableAlarm : pluggableAlarms) {
                if (!vAlarm.getAlarmName().equals(pluggableAlarm.getName())) continue;
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(terse ? pluggableAlarm.getTerse() : pluggableAlarm.getDisplayName(), vAlarm.getAlarmState() ? vAlarm.getAlarmTimeStamp() : 0L));
                continue block0;
            }
        }
        for (CommandOutput.OutputHierarchy.OutputNode on : alarmNameOp) {
            outputNode.addChild(on);
        }
    }

    public void addVolumeTierProperties(CLDBProto.VolumeInfo volInfo, CLDBProto.VolumeProperties volProps, CommandOutput.OutputHierarchy.OutputNode volumeInfo, boolean terse, BitSet columns) {
        CLDBProto.VolumeTieringProperties tierProps = volProps.getTierProps();
        if (tierProps.hasTierId() && columns.get(CLDBProto.VolumeInfoFields.tierId.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierId)).getName(terse), (Object)Integer.toString(tierProps.getTierId())));
        }
        if (tierProps.hasRuleId() && columns.get(CLDBProto.VolumeInfoFields.tierRuleId.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierRuleId)).getName(terse), (Object)Integer.toString(tierProps.getRuleId())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierScheduleId.getNumber())) {
            if (tierProps.hasScheduleId()) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierScheduleId)).getName(terse), (Object)Integer.toString(tierProps.getScheduleId())));
            } else {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierScheduleId)).getName(terse), (Object)"0"));
            }
        }
        if (tierProps.hasTierEncryption() && columns.get(CLDBProto.VolumeInfoFields.isTierEncryptionEnable.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.isTierEncryptionEnable)).getName(terse), (Object)Boolean.toString(tierProps.getTierEncryption())));
        }
        if (tierProps.hasRecallExpiryTime() && columns.get(CLDBProto.VolumeInfoFields.tierRecallExpiryTime.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierRecallExpiryTime)).getName(terse), (Object)Integer.toString((int)(tierProps.getRecallExpiryTime() / 86400L))));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.compactionScheduleId.getNumber())) {
            if (tierProps.getCompactionProps().hasScheduleId()) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.compactionScheduleId)).getName(terse), (Object)Integer.toString(tierProps.getCompactionProps().getScheduleId())));
            } else {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.compactionScheduleId)).getName(terse), (Object)"0"));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.compactionOverhead.getNumber())) {
            if (tierProps.getCompactionProps().hasOverheadPercentage()) {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.compactionOverhead)).getName(terse), (Object)Integer.toString(tierProps.getCompactionProps().getOverheadPercentage())));
            } else {
                volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.compactionOverhead)).getName(terse), (Object)"None"));
            }
        }
        if (columns.get(CLDBProto.VolumeInfoFields.honorRackReliability.getNumber())) {
            boolean honorRackReliability = volProps.getHonorRackReliability();
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.honorRackReliability)).getName(terse), (Object)honorRackReliability));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierJobType.getNumber()) && volInfo.hasTierJobType()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierJobType)).getName(terse), (Object)VolumeUtils.getTierVolumeOp((CLDBProto.VolumeTierOp)volInfo.getTierJobType())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierJobState.getNumber()) && volInfo.hasTierJobState()) {
            String tierJobState = VolumeUtils.getTierJobStatus((CLDBProto.OffloadTaskState)volInfo.getTierJobState(), (int)(volInfo.hasTierJobStatusCode() ? volInfo.getTierJobStatusCode() : 0), (int)(volInfo.hasTierJobNRetry() ? volInfo.getTierJobNRetry() : 0), (volInfo.hasAbortInternalInProgress() && volInfo.getAbortInternalInProgress() ? 1 : 0) != 0);
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierJobState)).getName(terse), (Object)tierJobState));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierJobStartTime.getNumber()) && volInfo.hasTierJobStartTime()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
            dateFormat.setTimeZone(TimeZone.getDefault());
            String startTime = dateFormat.format(new Date(volInfo.getTierJobStartTime()));
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierJobStartTime)).getName(terse), (Object)startTime));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierJobEndTime.getNumber()) && volInfo.hasTierJobEndTime()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
            dateFormat.setTimeZone(TimeZone.getDefault());
            String endTime = dateFormat.format(new Date(volInfo.getTierJobEndTime()));
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierJobEndTime)).getName(terse), (Object)endTime));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierJobProgress.getNumber()) && volInfo.hasTierJobProgress()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierJobProgress)).getName(terse), (Object)Long.toString(volInfo.getTierJobProgress())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierJobTotalTierSizeMB.getNumber()) && volInfo.hasTierJobTotalTierSizeMB()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierJobTotalTierSizeMB)).getName(terse), (Object)this.toMBSizeStr(volInfo.getTierJobTotalTierSizeMB())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierOffloadAvgThroughputMBPS.getNumber()) && volInfo.hasTierOffloadAvgThroughputMBPS()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierOffloadAvgThroughputMBPS)).getName(terse), (Object)this.toMBSizeStr(volInfo.getTierOffloadAvgThroughputMBPS())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierRecallAvgThroughputMBPS.getNumber()) && volInfo.hasTierRecallAvgThroughputMBPS()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierRecallAvgThroughputMBPS)).getName(terse), (Object)this.toMBSizeStr(volInfo.getTierRecallAvgThroughputMBPS())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.gatewayIps.getNumber())) {
            String gateway = "NA";
            if (volInfo.getGatewayIpsCount() > 0) {
                gateway = VolumeUtils.printIPAddresses((List)volInfo.getGatewayIpsList());
            }
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.gatewayIps)).getName(terse), (Object)gateway));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierName.getNumber()) && volInfo.hasTierName()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierName)).getName(terse), (Object)volInfo.getTierName()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.tierType.getNumber()) && volInfo.hasTierType()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.tierType)).getName(terse), (Object)this.toTierTypeString(volInfo.getTierType())));
        }
    }

    private String toTierTypeString(CLDBProto.TierType tierType) {
        if (tierType == CLDBProto.TierType.COLD_TIER) {
            return "cold";
        }
        if (tierType == CLDBProto.TierType.EC_TIER) {
            return "ectier";
        }
        return tierType.toString();
    }

    private String toMBSizeStr(long sizeinBytes) {
        if (sizeinBytes == 0L) {
            return "0";
        }
        DecimalFormat df = new DecimalFormat(".###");
        return df.format((double)sizeinBytes / 1048576.0);
    }

    public void addCacheVolInfo(CLDBProto.VolumeProperties volProps, CommandOutput.OutputHierarchy.OutputNode volumeInfo, boolean terse, BitSet columns) {
        int cacheVolId = volProps.getTierRelationships().getBackendCacheVolumeId();
        CLDBProto.VolumeInfo cacheVolInfo = this.VolumeLookupById(cacheVolId);
        if (cacheVolInfo == null) {
            return;
        }
        CLDBProto.VolumeProperties cacheVolProps = cacheVolInfo.getVolProperties();
        if (cacheVolProps == null) {
            return;
        }
        if (columns.get(CLDBProto.VolumeInfoFields.cvTotalUsed.getNumber())) {
            long snapSize = cacheVolInfo.getVolumeSnapshotsOwnedSizeMB();
            long ownSize = cacheVolInfo.getVolQuota().getVolumeOwnedSizeMB();
            if (snapSize < 0L) {
                snapSize = 0L;
            }
            long totalUsed = snapSize + ownSize;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.cvTotalUsed)).getName(terse), totalUsed));
        }
    }

    public void addEcBackendVolInfo(CLDBProto.VolumeProperties volProps, CommandOutput.OutputHierarchy.OutputNode volumeInfo, boolean terse, BitSet columns) {
        int backendVolId = volProps.getTierRelationships().getBackendEcVolumeId();
        CLDBProto.VolumeInfo backendVolInfo = this.VolumeLookupById(backendVolId);
        if (backendVolInfo == null) {
            return;
        }
        CLDBProto.VolumeProperties backendVolProps = backendVolInfo.getVolProperties();
        if (backendVolProps == null) {
            return;
        }
        if (columns.get(CLDBProto.VolumeInfoFields.ecScheme.getNumber()) && backendVolProps.hasNumECDataColumns() && backendVolProps.hasNumECParityColumns()) {
            int ngp = backendVolProps.getNumECParityColumns();
            Object lpString = "";
            if (backendVolProps.hasNumECLocalParityColumns() && backendVolProps.getNumECLocalParityColumns() != 0) {
                lpString = "+" + backendVolProps.getNumECLocalParityColumns();
                ngp -= backendVolProps.getNumECLocalParityColumns();
            }
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.ecScheme)).getName(terse), (Object)new String(backendVolProps.getNumECDataColumns() + "+" + ngp + (String)lpString)));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.ecStripeDepthMB.getNumber()) && backendVolProps.hasEcStripeDepthMB()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.ecStripeDepthMB)).getName(terse), (Object)Integer.toString(backendVolProps.getEcStripeDepthMB())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.ecContainerSizeMB.getNumber()) && backendVolProps.hasEcContainerSizeMB()) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.ecContainerSizeMB)).getName(terse), (Object)Integer.toString(backendVolProps.getEcContainerSizeMB())));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.ecBackendVolumeName.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.ecBackendVolumeName)).getName(terse), (Object)backendVolProps.getVolumeName()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.ecTopology.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.ecTopology)).getName(terse), (Object)backendVolProps.getTopology().getTopologyRestricted()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.ecLabel.getNumber())) {
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.ecLabel)).getName(terse), (Object)backendVolProps.getLabel()));
        }
        if (columns.get(CLDBProto.VolumeInfoFields.ecTotalUsed.getNumber())) {
            long snapSize = backendVolInfo.getVolumeSnapshotsOwnedSizeMB();
            long ownSize = backendVolInfo.getVolQuota().getVolumeOwnedSizeMB();
            if (snapSize < 0L) {
                snapSize = 0L;
            }
            long totalUsed = snapSize + ownSize;
            volumeInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.ecTotalUsed)).getName(terse), totalUsed));
        }
    }

    public CLDBProto.VolumeInfo VolumeLookupById(int volumeId) {
        CLDBProto.VolumeLookupRequest volLookupReq = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeId(volumeId).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)volLookupReq, CLDBProto.VolumeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)volLookupReq, CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                return null;
            }
            CLDBProto.VolumeLookupResponse volLookupResp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
            return volLookupResp.getStatus() == 0 ? volLookupResp.getVolInfo() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    String GetVolumeNameFromVolAndClusterName(String fullName) {
        int index = fullName.indexOf(64);
        if (index == -1 || index == 0) {
            return null;
        }
        return fullName.substring(0, index);
    }

    String GetClusterNameFromVolAndClusterName(String fullName) {
        int index = fullName.indexOf(64);
        if (index == -1 || index == 0) {
            return null;
        }
        return fullName.substring(index + 1, fullName.length());
    }

    String CldbIPFromClusterName(String ClusterName) {
        int index = ClusterName.indexOf(58);
        if (index == -1 || index == 0) {
            return null;
        }
        return ClusterName.substring(0, index);
    }

    int CldbPortFromClusterName(String ClusterName) {
        int index = ClusterName.indexOf(58);
        if (index == -1 || index == 0) {
            return 0;
        }
        try {
            int cldbPort = Integer.parseInt(ClusterName.substring(index + 1, ClusterName.length()));
            return cldbPort;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    boolean IsItConvertibleVolume(Common.VolumeType type) {
        return type != Common.VolumeType.VTRW && type != Common.VolumeType.VTMirror;
    }

    int UpdateMirrorSourceVolumeName(String destVolumeName, CLDBProto.VolumeProperties.Builder volProps, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.MirrorInfo.MirrorStatus mStatus;
        boolean isDestClusterSecure;
        boolean isSourceClusterSecure;
        String srcVolumeFullName = this.getParamTextValue(MIRROR_VOLUME_SRC_VOLUMENAME, 0);
        String srcVolumeName = this.GetVolumeNameFromVolAndClusterName(srcVolumeFullName);
        String srcClusterName = this.GetClusterNameFromVolAndClusterName(srcVolumeFullName);
        if (srcVolumeName == null || srcClusterName == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Source volume name " + srcVolumeName + " is not specified in format srcvolume@srccluster").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
            return 22;
        }
        if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(srcClusterName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid cluster name " + srcClusterName).setField(MIRROR_VOLUME_SRC_VOLUMENAME));
            return 22;
        }
        String destClusterName = null;
        destClusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (destVolumeName.equalsIgnoreCase(srcVolumeName) && destClusterName.equalsIgnoreCase(srcClusterName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specified source " + srcVolumeFullName + " is same as destination").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
            return 22;
        }
        if (!destClusterName.equalsIgnoreCase(srcClusterName) && (isSourceClusterSecure = JNISecurity.IsSecurityEnabled((String)srcClusterName)) ^ (isDestClusterSecure = JNISecurity.IsSecurityEnabled((String)destClusterName))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "In cross cluster mirroring, both clusters must be either secure or unsecure. Other combination is not allowed."));
            return 22;
        }
        CLDBProto.VolumeLookupRequest.Builder srcVolumeLookupReq = CLDBProto.VolumeLookupRequest.newBuilder();
        CLDBProto.VolumeLookupResponse srcVolumeLookupResp = null;
        srcVolumeLookupReq.setVolumeName(srcVolumeName);
        srcVolumeLookupReq.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(srcClusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)srcVolumeLookupReq.build(), CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            srcVolumeLookupResp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + srcClusterName, (Throwable)e);
        }
        if (!srcVolumeLookupResp.hasStatus() || srcVolumeLookupResp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Source volume " + srcVolumeName + " doesn't exist in cluster " + srcClusterName).setField(MIRROR_VOLUME_SRC_VOLUMENAME));
            return 10003;
        }
        CLDBProto.VolumeLookupRequest.Builder destVolumeLookupReq = CLDBProto.VolumeLookupRequest.newBuilder();
        CLDBProto.VolumeLookupResponse destVolumeLookupResp = null;
        destVolumeLookupReq.setVolumeName(destVolumeName);
        destVolumeLookupReq.setCreds(this.getUserCredentials());
        data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)destVolumeLookupReq.build(), CLDBProto.VolumeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)destVolumeLookupReq.build(), CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(70, "Exception while communicating with CLDB for volume " + destVolumeName));
                return 70;
            }
            destVolumeLookupResp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
            if (!destVolumeLookupResp.hasStatus() || destVolumeLookupResp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(destVolumeLookupResp.getStatus(), "volume " + destVolumeName + " doesn't exist "));
                return destVolumeLookupResp.getStatus();
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(70, "Exception while communicating with CLDB for volume " + destVolumeName));
            return 70;
        }
        boolean isDestMirrorVol = destVolumeLookupResp.getVolInfo().getVolProperties().getIsMirrorVol();
        if (!this.isParamPresent(MIRROR_VOLUME) && !isDestMirrorVol) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot update the 'source' property of Volume '" + destVolumeName + "' because it is not a mirror volume"));
            return 22;
        }
        CLDBProto.MirrorInfo destVolMirrorInfo = null;
        if (isDestMirrorVol && (mStatus = (destVolMirrorInfo = destVolumeLookupResp.getVolInfo().getVolProperties().getMirrorInfo()).getMirrorStatus()) != CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_COMPLETE && mStatus != CLDBProto.MirrorInfo.MirrorStatus.STATE_CONVERT_COMPLETE && mStatus != CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_FAILED) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(115, "Cannot update the 'source' property of Volume '" + destVolumeName + "' because mirroring is in progress on the volume"));
            return 115;
        }
        CLDBProto.VolumeProperties srcVolProp = srcVolumeLookupResp.getVolInfo().getVolProperties();
        CLDBProto.VolumeProperties destVolProp = destVolumeLookupResp.getVolInfo().getVolProperties();
        if (!this.canPerformVolumeAction(srcClusterName, srcVolumeName, srcVolProp, SecurityCommandHelper.VOLUME_DUMP_MASK, this.getUserCredentials(), out) && !this.canPerformVolumeAction(destClusterName, destVolumeName, destVolProp, SecurityCommandHelper.VOLUME_RESTORE_MASK, this.getUserCredentials(), out)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "User doesn't have permissions to update source mirror of " + destVolumeName + " to " + srcVolumeFullName));
            return 1;
        }
        if (srcVolProp.hasCreatorVolumeUuid() && destVolProp.hasCreatorVolumeUuid()) {
            Common.GuidMsg srcVolGuid = srcVolProp.getCreatorVolumeUuid();
            Common.GuidMsg destVolGuid = destVolProp.getCreatorVolumeUuid();
            if (srcVolGuid.getId640() != destVolGuid.getId640() || srcVolGuid.getId641() != destVolGuid.getId641()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not update the 'source' property of Volume '" + destVolumeName + "' because new source volume creator volumeuuid didn't match'"));
                return 22;
            }
        } else {
            int srcDataGeneratorVolumeId = 0;
            boolean hasVolumeUUID = false;
            long srcDataGeneratorVolumeUUID = 0L;
            long destDataGeneratorVolumeUUID = 0L;
            String srcDataGeneratorVolumeName = null;
            String srcDataGeneratorClusterName = null;
            if (srcVolProp.getIsMirrorVol()) {
                srcDataGeneratorVolumeId = srcVolProp.getMirrorInfo().getDataGeneratorSrcVolumeId();
                srcDataGeneratorClusterName = srcVolProp.getMirrorInfo().getDataGeneratorSrcClusterName();
                srcDataGeneratorVolumeName = srcVolProp.getMirrorInfo().getDataGeneratorSrcVolumeName();
                if (srcVolProp.getMirrorInfo().hasDataGeneratorSrcVolumeUUID()) {
                    hasVolumeUUID = true;
                    srcDataGeneratorVolumeUUID = srcVolProp.getMirrorInfo().getDataGeneratorSrcVolumeUUID();
                }
            } else {
                srcDataGeneratorVolumeId = srcVolProp.getVolumeId();
                srcDataGeneratorClusterName = srcClusterName;
                srcDataGeneratorVolumeName = srcVolumeName;
                if (srcVolProp.hasVolumeUUID()) {
                    hasVolumeUUID = true;
                    srcDataGeneratorVolumeUUID = srcVolProp.getVolumeUUID();
                }
            }
            boolean volumeUUIDMatched = true;
            if (hasVolumeUUID && isDestMirrorVol && destVolMirrorInfo.hasDataGeneratorSrcVolumeUUID() && srcDataGeneratorVolumeUUID != (destDataGeneratorVolumeUUID = destVolMirrorInfo.getDataGeneratorSrcVolumeUUID())) {
                volumeUUIDMatched = false;
            }
            if (isDestMirrorVol && (destVolMirrorInfo.getDataGeneratorSrcVolumeId() != srcDataGeneratorVolumeId || destVolMirrorInfo.getDataGeneratorSrcClusterName().compareTo(srcDataGeneratorClusterName) != 0 || !volumeUUIDMatched)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not update the 'source' property of Volume '" + destVolumeName + "' because new source volume '" + srcVolumeName + "' contains data originated  on volume " + srcDataGeneratorVolumeName + "(" + srcDataGeneratorVolumeId + ")@" + srcDataGeneratorClusterName + " volumeUUID " + srcDataGeneratorVolumeUUID + " and the volume '" + destVolumeName + "' contains data originated from " + destVolMirrorInfo.getDataGeneratorSrcVolumeName() + "(" + destVolMirrorInfo.getDataGeneratorSrcVolumeId() + ")@" + destVolMirrorInfo.getDataGeneratorSrcClusterName() + " volumeUUID " + destDataGeneratorVolumeUUID));
                return 22;
            }
        }
        boolean srcTiering = false;
        boolean destTiering = false;
        if (srcVolProp.hasIsTierOffloadEnable()) {
            srcTiering = srcVolProp.getIsTierOffloadEnable();
        }
        if (destVolProp.hasIsTierOffloadEnable()) {
            destTiering = destVolProp.getIsTierOffloadEnable();
        }
        if (srcTiering != destTiering) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tieringenable property of mirror volume should be same as source volume"));
            return 22;
        }
        if (srcVolProp.hasVolumetype() && destVolProp.hasVolumetype() && this.IsItConvertibleVolume(srcVolProp.getVolumetype()) != this.IsItConvertibleVolume(destVolProp.getVolumetype())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not update the 'source' property of Volume '" + destVolumeName + "' because new source volume type is not compatible."));
            return 22;
        }
        CLDBProto.MirrorInfo.Builder mirror = CLDBProto.MirrorInfo.newBuilder();
        mirror.setSrcVolumeId(srcVolumeLookupResp.getVolInfo().getVolumeId()).setSrcVolumeName(srcVolumeName).setSrcClusterName(srcClusterName);
        volProps.setMirrorInfo(mirror.build());
        return 0;
    }

    private boolean canPerformVolumeAction(String clusterName, String volumeName, CLDBProto.VolumeProperties volProps, int actionMask, Security.CredentialsMsg creds, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (clusterName == null) {
            clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        }
        return this.authManager.canPerformVolumeAction(clusterName, volumeName, volProps, actionMask, creds, out);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput volumeModify() throws CLIProcessingException, IOException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String name = this.getRwVolumeName();
        ArrayList<String> rwVolumeNames = new ArrayList<String>();
        if (name.contains(MULTI_ARG_SEP)) {
            rwVolumeNames.addAll(Arrays.asList(name.split(MULTI_ARG_SEP)));
        } else {
            rwVolumeNames.add(name);
        }
        Iterator iterator = rwVolumeNames.iterator();
        while (iterator.hasNext()) {
            boolean isTierParamsSet;
            String policies;
            String cluster;
            CLDBProto.VolumeProperties savedVolProps;
            CLDBProto.VolumeProperties.Builder volProps;
            CLDBProto.VolumeUpdateRequest.Builder volumeUpdate;
            String rwVolumeName;
            block194: {
                List<Security.AclEntry> elements;
                boolean failed;
                List perms;
                String fsOperations;
                int timeout;
                int scheduleId;
                rwVolumeName = (String)iterator.next();
                volumeUpdate = CLDBProto.VolumeUpdateRequest.newBuilder();
                volProps = CLDBProto.VolumeProperties.newBuilder().setVolumeName(rwVolumeName);
                savedVolProps = this.volumePropetiesLookup(rwVolumeName);
                if (savedVolProps == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString((int)2) + " Volume not found"));
                    LOG.error((Object)("Volume  " + rwVolumeName + " Volume not found"));
                    continue;
                }
                if (this.isParamPresent(PBS_SECURITY_POLICY) && savedVolProps.hasTenantCreds()) {
                    LOG.error((Object)"tagging of tenant volume is not supported");
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "tagging of tenant volume is not supported"));
                    continue;
                }
                if (this.isParamPresent(VOLUME_SCHEDULE)) {
                    scheduleId = this.getParamIntValue(VOLUME_SCHEDULE, 0);
                    volProps.setSchedulingPolicyId(scheduleId);
                }
                if (this.isParamPresent(VOLUME_MIRROR_SCHEDULE)) {
                    scheduleId = this.getParamIntValue(VOLUME_MIRROR_SCHEDULE, 0);
                    volProps.setMirrorSchedulingPolicyId(scheduleId);
                }
                if (this.isParamPresent(VOLUME_LIMIT_SPREAD)) {
                    boolean limitSpread = this.getParamBooleanValue(VOLUME_LIMIT_SPREAD, 0);
                    volProps.setLimitVolumeSpread(limitSpread);
                }
                if (this.isParamPresent(ALLOW_GRANT)) {
                    boolean grant = this.getParamBooleanValue(ALLOW_GRANT, 0);
                    volProps.setAllowGrant(grant);
                }
                if (this.isParamPresent(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC)) {
                    timeout = this.getParamIntValue(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, 0);
                    volProps.setReReplicationTimeOutSec(timeout);
                }
                if (this.isParamPresent(RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC)) {
                    timeout = this.getParamIntValue(RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, 0);
                    volProps.setCriticalReReplicationTimeOutSec(timeout);
                }
                if (this.isParamPresent(RW_FIX_CREATOR_ID)) {
                    boolean val = this.getParamBooleanValue(RW_FIX_CREATOR_ID, 0);
                    if (!val) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + " Invalid value for fixcreatorid"));
                        continue;
                    }
                    volProps.setUseActualCreatorId(true);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_DCREPLTYPE)) {
                    CLDBProto.ReplicationPolicy.Builder replPolicy;
                    block192: {
                        replPolicy = CLDBProto.ReplicationPolicy.newBuilder();
                        int repl = savedVolProps.getReplicationPolicy().getNumReplicas();
                        if (this.isParamPresent(RW_VOLUME_PARAM_REPLICATION)) {
                            repl = this.getParamIntValue(RW_VOLUME_PARAM_REPLICATION, 0);
                            if (repl > 0) {
                                replPolicy.setNumReplicas(repl);
                                if (repl > this.maxVolumeReplicationFactor) {
                                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume modify of " + rwVolumeName + " failed. The maximum value allowed for the replication factor is " + this.maxVolumeReplicationFactor + " while the requested value is " + repl));
                                    LOG.error((Object)("Requested replication factor too large for volume modify " + repl));
                                    return output;
                                }
                            } else {
                                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString((int)22) + " Invalid replication"));
                                LOG.error((Object)("Invalid replication for Volume modify " + repl));
                                continue;
                            }
                        }
                        if (this.isParamPresent(RW_VOLUME_PARAM_MIN_REPLICATION)) {
                            int minRepl = this.getParamIntValue(RW_VOLUME_PARAM_MIN_REPLICATION, 0);
                            if (minRepl > 0) {
                                if (repl > 0 && minRepl > repl) {
                                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString((int)22) + " Min replication greater than replication"));
                                    LOG.error((Object)("Volume modify with minreplication " + repl + "greater than replicaton"));
                                    continue;
                                }
                                replPolicy.setGuaranteedMinReplicas(minRepl);
                                break block192;
                            } else {
                                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString((int)22) + " Invalid min replication"));
                                LOG.error((Object)("Volume modify with invalid minreplication " + repl));
                                continue;
                            }
                        }
                        if (savedVolProps.getReplicationPolicy().getGuaranteedMinReplicas() > repl) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "VolumeModify: VolumeName: " + rwVolumeName + ". Replication is less than min replication of " + savedVolProps.getReplicationPolicy().getGuaranteedMinReplicas() + ". Please specify both replication and minreplication"));
                            continue;
                        }
                    }
                    if (this.isParamPresent(RW_VOLUME_PARAM_DCREPLTYPE)) {
                        String stype = this.getParamTextValue(RW_VOLUME_PARAM_DCREPLTYPE, 0);
                        Common.ContainerReplType rtype = this.getContainerReplType(stype);
                        if (rtype == Common.ContainerReplType.INVALID) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modification of " + rwVolumeName + " failed, due to invalid replicationtype " + stype));
                            continue;
                        }
                        replPolicy.setDataContainerReplType(rtype);
                    }
                    volProps.setReplicationPolicy(replPolicy.build());
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION) || this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
                    int repl = 0;
                    if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_REPLICATION)) {
                        repl = this.getParamIntValue(RW_VOLUME_PARAM_NAMESPACE_REPLICATION, 0);
                        if (repl <= 0) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + ", " + Errno.toString((int)22) + " Invalid namespace replication"));
                            LOG.error((Object)("Invalid namespace replication for Volume modify " + repl));
                            continue;
                        }
                        if (repl > this.maxVolumeReplicationFactor) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume modify of " + rwVolumeName + " failed. The maximum value allowed for the namespace replication factor is " + this.maxVolumeReplicationFactor + " while the requested value is " + repl));
                            LOG.error((Object)("Requested namespace replication factor too large for volume modify " + repl));
                            return output;
                        }
                        volProps.setNumNamespaceReplicas(repl);
                    } else {
                        repl = savedVolProps.getNumNamespaceReplicas();
                    }
                    if (this.isParamPresent(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION)) {
                        int minRepl = this.getParamIntValue(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, 0);
                        if (minRepl <= 0) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + ", " + Errno.toString((int)22) + " Invalid namespace min replication"));
                            LOG.error((Object)("Volume modify with invalid namespace minreplication " + repl));
                            return output;
                        }
                        if (minRepl > repl) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + ", " + Errno.toString((int)22) + " Min namespace replication greater than replication"));
                            LOG.error((Object)("Volume modify with namespace minreplication " + repl + "greater than replicaton"));
                            continue;
                        }
                        volProps.setGuaranteedMinNamespaceReplicas(minRepl);
                    } else if (savedVolProps.getGuaranteedMinNamespaceReplicas() > repl) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "VolumeModify: VolumeName: " + rwVolumeName + ". namespace Replication is less than namespace min replication of " + savedVolProps.getGuaranteedMinNamespaceReplicas() + ". Please specify both namespace replication and namespace minreplication"));
                        continue;
                    }
                }
                if (this.isParamPresent(RW_VOLUME_ENFORCE_MIN_REPLICATION)) {
                    boolean strongMinRepl = this.getParamBooleanValue(RW_VOLUME_ENFORCE_MIN_REPLICATION, 0);
                    volProps.setEnforceMinReplication(strongMinRepl);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_CONTAINER_ALLOCATION_FACTOR)) {
                    int containerAllocationFactor = this.getParamIntValue(RW_VOLUME_PARAM_CONTAINER_ALLOCATION_FACTOR, 0);
                    volProps.setContainerAllocationFactor(containerAllocationFactor);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_READONLY)) {
                    boolean readOnly = this.getParamBooleanValue(RW_VOLUME_PARAM_READONLY, 0);
                    volProps.setReadOnly(readOnly);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_MIRRORTHROTTLE)) {
                    boolean mirrorThrottle = this.getParamBooleanValue(RW_VOLUME_PARAM_MIRRORTHROTTLE, 0);
                    volProps.setMirrorThrottle(mirrorThrottle);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_AE) || this.isParamPresent(RW_VOLUME_PARAM_AETYPE) || this.isParamPresent(OBJ_STORE_ACCOUNT_ID)) {
                    if (this.isParamPresent(OBJ_STORE_ACCOUNT_ID) && (this.isParamPresent(RW_VOLUME_PARAM_AETYPE) || this.isParamPresent(RW_VOLUME_PARAM_AE))) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "aetype or ae cant be specifies with objectstoreaccountid"));
                        return output;
                    }
                    if (this.isParamPresent(RW_VOLUME_PARAM_AETYPE) && !this.isParamPresent(RW_VOLUME_PARAM_AE)) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Please specify both aetype and ae while modifying AE for volume " + rwVolumeName));
                        continue;
                    }
                    CLDBProto.AeKey.Builder keyBuilder = CLDBProto.AeKey.newBuilder();
                    int status = this.populateAeKey(keyBuilder, out);
                    if (status != 0) {
                        LOG.error((Object)"Volume Modify with invalid AE ");
                        return output;
                    }
                    volProps.setVolumeAe(keyBuilder);
                }
                long quotaMB = savedVolProps.getVolumeQuotaSizeMB();
                if (this.isParamPresent(RW_VOLUME_PARAM_QUOTA)) {
                    String quotaString = this.getParamTextValue(RW_VOLUME_PARAM_QUOTA, 0);
                    quotaMB = MapRCliUtil.quotaStringToMB(quotaString);
                    if (quotaMB < 0L) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString((int)22) + " Invalid quota size. Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)"));
                        LOG.error((Object)("Invalid quota during Volume modify " + quotaString));
                        continue;
                    }
                    volProps.setVolumeQuotaSizeMB(quotaMB);
                }
                long advisoryQuotaMB = savedVolProps.getVolumeQuotaAdvisorySizeMB();
                if (this.isParamPresent(RW_VOLUME_PARAM_ADVISORY_QUOTA)) {
                    String quotaString = this.getParamTextValue(RW_VOLUME_PARAM_ADVISORY_QUOTA, 0);
                    advisoryQuotaMB = MapRCliUtil.quotaStringToMB(quotaString);
                    if (advisoryQuotaMB == -1L) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString((int)22) + " Invalid advisory quota size. Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)"));
                        LOG.error((Object)("Invalid advisory quota during Volume modify " + quotaString));
                        continue;
                    }
                    volProps.setVolumeQuotaAdvisorySizeMB(advisoryQuotaMB);
                }
                if ((this.isParamPresent(RW_VOLUME_PARAM_ADVISORY_QUOTA) || this.isParamPresent(RW_VOLUME_PARAM_QUOTA)) && quotaMB > 0L && advisoryQuotaMB > quotaMB) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify of " + rwVolumeName + " with advisory quota greater than volume quota").setField(RW_VOLUME_PARAM_ADVISORY_QUOTA));
                    return output;
                }
                if (this.isParamPresent(ADD_VOLUME_NOTE) && this.isParamPresent(RESOLVE_VOLUME_NOTE)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify: Volumename " + rwVolumeName + " failed. Only one of addNotes or resolveNote can be specified at a time."));
                    return output;
                }
                if (this.isParamPresent(ADD_VOLUME_NOTE) || this.isParamPresent(RESOLVE_VOLUME_NOTE)) {
                    StringBuilder msg = new StringBuilder();
                    CLDBProto.NoteOperation noteOper = this.getNoteOperation(msg);
                    if (noteOper == null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify: Volumename " + rwVolumeName + " failed. " + msg.toString()));
                        return output;
                    }
                    volumeUpdate.setNoteOp(noteOper);
                }
                if (this.isParamPresent(PRESERVE_VOLUME)) {
                    if (savedVolProps.hasIsWorm() && savedVolProps.getIsWorm()) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify: Volumename " + rwVolumeName + " already a worm volume."));
                        return output;
                    }
                    boolean preserve = this.getParamBooleanValue(PRESERVE_VOLUME, 0);
                    CLDBProto.WormSettings.Builder wsb = CLDBProto.WormSettings.newBuilder();
                    if (preserve) {
                        if (this.isParamPresent(CHECKIN_TIME_MIN)) {
                            int checkin = this.getParamIntValue(CHECKIN_TIME_MIN, 0);
                            wsb.setCommitTimeMinutes(checkin);
                        }
                        if (this.isParamPresent(RETENTION_PERIOD_DAYS)) {
                            int retain = this.getParamIntValue(RETENTION_PERIOD_DAYS, 0);
                            wsb.setRetentionPeriodDays(retain);
                        }
                    }
                    volProps.setIsWorm(true);
                    volProps.setWormConfig(wsb.build());
                }
                if (this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
                    int err = this.UpdateMirrorSourceVolumeName(rwVolumeName, volProps, out);
                    if (err != 0) {
                        LOG.error((Object)("Failed to update the mirror source volume inforation  for volume " + rwVolumeName + " input source volume name " + this.getParamTextValue(MIRROR_VOLUME_SRC_VOLUMENAME, 0)));
                        continue;
                    }
                    volumeUpdate.setMirrorOp(CLDBProto.VolumeUpdateRequest.MirrorOp.MIRROR_SRC_UPDATE);
                }
                if (this.isParamPresent(WIRE_SECURITY_ENABLED)) {
                    boolean wireSecurityEnabled = this.getParamBooleanValue(WIRE_SECURITY_ENABLED, 0);
                    volProps.setWireSecurityEnabled(wireSecurityEnabled);
                }
                if (this.isParamPresent(NAME_CONTAINER_DATA_THRESHOLD)) {
                    Long ncDataThreshold = this.getParamLongValue(NAME_CONTAINER_DATA_THRESHOLD, 0);
                    volProps.setNameContainerDataThreshold(ncDataThreshold * 0x100000L);
                }
                if (this.isParamPresent(ALLOW_READ_FOR_EXECUTE)) {
                    boolean allowReadForExecute = this.getParamBooleanValue(ALLOW_READ_FOR_EXECUTE, 0);
                    volProps.setAllowReadForExecute(allowReadForExecute);
                }
                if (this.cliCommand.getCommandName().equalsIgnoreCase("audit")) {
                    if (this.isParamPresent(VOLUME_AUDIT_ENABLED)) {
                        boolean audited = this.getParamBooleanValue(VOLUME_AUDIT_ENABLED, 0);
                        volProps.setAudited(audited);
                    }
                    if (this.isParamPresent(VOLUME_FORCE_AUDIT_ENABLE)) {
                        boolean audited = this.getParamBooleanValue(VOLUME_FORCE_AUDIT_ENABLE, 0);
                        volProps.setForceAudit(audited);
                    }
                } else {
                    if (this.isParamPresent(AUDIT_ENABLED)) {
                        boolean audited = this.getParamBooleanValue(AUDIT_ENABLED, 0);
                        volProps.setAudited(audited);
                    }
                    if (this.isParamPresent(FORCE_AUDIT_ENABLE)) {
                        boolean audited = this.getParamBooleanValue(FORCE_AUDIT_ENABLE, 0);
                        volProps.setForceAudit(audited);
                    }
                }
                if (this.isParamPresent(AUDIT_COALESCE_INTERVAL)) {
                    int coalesceInterval = this.getParamIntValue(AUDIT_COALESCE_INTERVAL, 0);
                    if (coalesceInterval < 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Coalesce interval cannot be negative"));
                        return output;
                    }
                    volProps.setCoalesceInterval(coalesceInterval);
                }
                ArrayList<Common.FSAuditOperations> fsAuditEnableOperations = new ArrayList<Common.FSAuditOperations>();
                ArrayList<Common.FSAuditOperations> fsAuditDisableOperations = new ArrayList<Common.FSAuditOperations>();
                if (this.isParamPresent(DISABLE_DATA_AUDIT_OPS_PARAM) && this.isParamPresent(FSAUDIT_OPS)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "either of dataauditops or disabledataauditops can be used, but not both."));
                    return output;
                }
                if (this.isParamPresent(DISABLE_DATA_AUDIT_OPS_PARAM)) {
                    String fsOperations2 = this.getParamTextValue(DISABLE_DATA_AUDIT_OPS_PARAM, 0);
                    volumeUpdate.setReplaceDisabledAuditOps(true);
                    if (fsOperations2.equals("")) {
                        fsAuditEnableOperations.add(Common.FSAuditOperations.AuditAll);
                    } else if (!VolumeCommands.validateAndAddFsOperations(fsAuditEnableOperations, fsAuditDisableOperations, fsOperations2, false)) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid disabledataauditops text specified, text = " + fsOperations2));
                        return output;
                    }
                } else if (this.isParamPresent(FSAUDIT_OPS) && !VolumeCommands.validateAndAddFsOperations(fsAuditEnableOperations, fsAuditDisableOperations, fsOperations = this.getParamTextValue(FSAUDIT_OPS, 0), true)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid dataauditops text specified, text = " + fsOperations));
                    return output;
                }
                if (fsAuditEnableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditEnableOperations.size() > 1) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying +all,  cannot enable any other operation"));
                    return output;
                }
                if (fsAuditDisableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditDisableOperations.size() > 1) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying -all,  cannot disable any other operation"));
                    return output;
                }
                for (int i = 0; i < fsAuditEnableOperations.size(); ++i) {
                    if (!fsAuditDisableOperations.contains(fsAuditEnableOperations.get(i))) continue;
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot specify an audit operation both for enable and disable"));
                    return output;
                }
                for (Common.FSAuditOperations op : fsAuditEnableOperations) {
                    LOG.info((Object)("Enable Op = " + op.toString()));
                }
                for (Common.FSAuditOperations op : fsAuditDisableOperations) {
                    LOG.info((Object)("Disable Op = " + op.toString()));
                }
                volumeUpdate.addAllFsAuditEnableOperations(fsAuditEnableOperations);
                volumeUpdate.addAllFsAuditDisableOperations(fsAuditDisableOperations);
                if (this.isParamPresent(METRICS_ENABLED)) {
                    boolean metricsEnabled = this.getParamBooleanValue(METRICS_ENABLED, 0);
                    volProps.setMetricsEnabled(metricsEnabled);
                }
                boolean permsPresent = false;
                Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
                if (this.isParamPresent(USERPERM_PARAM_NAME)) {
                    permsPresent = true;
                    perms = this.input.getParameterByName(USERPERM_PARAM_NAME).getParamValues();
                    List<String> userNames = this.getUserGroupsNames(perms);
                    failed = false;
                    for (String string : userNames) {
                        if (this.checkEntityExists(false, string)) continue;
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify for volume " + rwVolumeName + " failed - user " + string + " not found").setField(USERPERM_PARAM_NAME));
                        failed = true;
                    }
                    if (failed) continue;
                    elements = AclCommands.actionsToAcls(perms, this.uInfo, CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, true, out);
                    if (elements == null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify failed - invalid list of user permissions - " + perms).setField(USERPERM_PARAM_NAME));
                        continue;
                    }
                    if (!this.isParamPresent(GROUPPERM_PARAM_NAME) && savedVolProps.getAcl().getAclCount() > 0) {
                        for (Security.AclEntry ae : savedVolProps.getAcl().getAclList()) {
                            if (!ae.hasPrincipal() || ACL.isUid((int)ae.getPrincipal().getPrincId())) continue;
                            elements.add(ae);
                        }
                    }
                    aclBuilder.addAllAcl(elements);
                }
                if (this.isParamPresent(GROUPPERM_PARAM_NAME)) {
                    permsPresent = true;
                    perms = this.input.getParameterByName(GROUPPERM_PARAM_NAME).getParamValues();
                    List<String> groupNames = this.getUserGroupsNames(perms);
                    failed = false;
                    for (String string : groupNames) {
                        if (this.checkEntityExists(true, string)) continue;
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume modify for volume " + rwVolumeName + " failed - group " + string + " not found").setField(USERPERM_PARAM_NAME));
                        failed = true;
                    }
                    if (failed) continue;
                    elements = AclCommands.actionsToAcls(perms, this.uInfo, CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME, false, out);
                    if (elements == null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume create failed - invalid list of group permissions - " + perms).setField(GROUPPERM_PARAM_NAME));
                        continue;
                    }
                    if (!this.isParamPresent(USERPERM_PARAM_NAME) && savedVolProps.getAcl().getAclCount() > 0) {
                        for (Security.AclEntry ae : savedVolProps.getAcl().getAclList()) {
                            if (!ae.hasPrincipal() || !ACL.isUid((int)ae.getPrincipal().getPrincId())) continue;
                            elements.add(ae);
                        }
                    }
                    aclBuilder.addAllAcl(elements);
                }
                if (permsPresent) {
                    volProps.setAcl(aclBuilder);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD)) {
                    long maxInodes = this.getParamLongValue(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, 0);
                    volProps.setMaxInodesAlarmThreshold(maxInodes);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD)) {
                    long maxInodes = this.getParamLongValue(RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD, 0);
                    volProps.setMaxNsSizeMbAlarmThreshold(maxInodes);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH)) {
                    int thresh = this.getParamIntValue(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, 0);
                    volProps.setDbReplLagSecAlarmThresh(thresh);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH)) {
                    int thresh = this.getParamIntValue(RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH, 0);
                    volProps.setDbIndexLagSecAlarmThresh(thresh);
                }
                cluster = null;
                try {
                    if (this.isParamPresent("cluster")) {
                        cluster = this.getParamTextValue("cluster", 0);
                    }
                    if (!this.isParamPresent(FILTER_EXTENSION)) break block194;
                    String filter = this.getParamTextValue(FILTER_EXTENSION, 0);
                    if (filter.equals("")) {
                        volumeUpdate.addFileFilterNames("");
                    } else {
                        CLDBProto.FileFilterLookupResponse resp = FileFilterCommands.filterLookupByName(cluster, this.getUserCredentials(), filter);
                        if (resp.getStatus() != 0) {
                            LOG.error((Object)"Error modifying Volume, fileFilter not found");
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error modifying Volume, fileFilter not found"));
                            return output;
                        }
                        volumeUpdate.addFileFilterNames(resp.getProperties().getFilterName());
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error modifying Volume, exception while fetching fileFilter");
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error modifying Volume, exception while fetching fileFilter"));
                    return output;
                }
            }
            boolean failed = this.volumeChangeMirrorMode(rwVolumeName, savedVolProps, out);
            if (failed) continue;
            Common.VolumeAces volumeAces = null;
            try {
                volumeAces = this.buildVolumeAcesProtobuf(volumeAceParameterMap, out);
            }
            catch (IOException e) {
                return output;
            }
            if (this.isParamPresent(PBS_SECURITY_POLICY) && (policies = this.getParamTextValue(PBS_SECURITY_POLICY, 0)).equals("")) {
                Common.VolumeAces.Builder builder = volumeAces != null ? Common.VolumeAces.newBuilder((Common.VolumeAces)volumeAces) : Common.VolumeAces.newBuilder();
                volumeAces = builder.clearPolicyIds().addPolicyIds(0).build();
            }
            if (volumeAces != null) {
                volumeUpdate.setVolumeAces(volumeAces);
            }
            boolean isTierNameSet = this.isParamPresent(RW_VOLUME_PARAM_TIER_NAME);
            boolean bl = this.isParamPresent(RW_VOLUME_PARAM_TIER_ENCRYPTION);
            boolean isTierKeySet = this.isParamPresent(RW_VOLUME_PARAM_TIER_KEY);
            if (isTierNameSet && savedVolProps.hasTierProps() && savedVolProps.getTierProps().hasTierId()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier name can be set only once"));
                return output;
            }
            if ((bl || isTierKeySet) && savedVolProps.hasTierProps() && savedVolProps.getTierProps().hasTierEncryption()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier encryption can be set only once"));
                return output;
            }
            boolean tieringEnable = savedVolProps.hasIsTierOffloadEnable() ? savedVolProps.getIsTierOffloadEnable() : false;
            boolean autoCreateECTier = this.isParamPresent(RW_VOLUME_PARAM_AUTO_CREATE_EC_TIER) ? this.getParamBooleanValue(RW_VOLUME_PARAM_AUTO_CREATE_EC_TIER, 0) : false;
            boolean isSkipWSForInternalOpsSet = this.isParamPresent(SKIP_WIRE_SECURITY_FOR_INTERNAL_OP);
            boolean isOffloadScheduleSet = this.isParamPresent(RW_VOLUME_PARAM_OFFLOAD_SCHEDULEID);
            boolean isTieringRuleSet = this.isParamPresent(RW_VOLUME_PARAM_TIERING_RULE);
            boolean isCompactionScheduleSet = this.isParamPresent(RW_VOLUME_PARAM_COMPACTION_SCHEDULEID);
            boolean isCompactionOverheadSet = this.isParamPresent(RW_VOLUME_PARAM_COMPACTION_OVERHEAD);
            boolean isCompactionParamSet = isCompactionScheduleSet || isCompactionOverheadSet;
            boolean isRecallExpirySet = this.isParamPresent(RW_VOLUME_PARAM_RECALL_EXPIRY_TIME);
            boolean isHrrSet = this.isParamPresent(RW_VOLUME_PARAM_HONORRACKRELIABILITY);
            boolean bl2 = isTierParamsSet = isTierNameSet || isOffloadScheduleSet || isTieringRuleSet || bl || isTierKeySet || isRecallExpirySet || isCompactionParamSet || autoCreateECTier || isSkipWSForInternalOpsSet;
            if (!(savedVolProps.hasIsTierOffloadEnable() && savedVolProps.getIsTierOffloadEnable() || !isTierParamsSet)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier related parameters can be modified only when tiering is enabled"));
                return output;
            }
            if (!tieringEnable && autoCreateECTier) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ecenable can be used for tiering enabled volumes only"));
                return output;
            }
            if (autoCreateECTier && savedVolProps.hasTierProps() && savedVolProps.getTierProps().hasTierId()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ecenable can not be used to modify volumes which has already tier associated"));
                return output;
            }
            if (autoCreateECTier && isTierNameSet) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tiernameand ecenable can not be used together"));
                return output;
            }
            if (!isTierNameSet && !autoCreateECTier && savedVolProps.hasTierProps() && !savedVolProps.getTierProps().hasTierId() && (isOffloadScheduleSet || isTieringRuleSet || bl || isTierKeySet || isRecallExpirySet || isCompactionParamSet || isSkipWSForInternalOpsSet)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier name should be set for setting tier related parameters"));
                return output;
            }
            boolean tierEncryption = true;
            String tierName = null;
            String tieringRule = null;
            String tierKey = null;
            int tieringScheduleId = -1;
            int compactionScheduleId = 0;
            int compactionOverhead = 0;
            int recallExpiryTime = -1;
            if (isTierNameSet) {
                tierName = this.getParamTextValue(RW_VOLUME_PARAM_TIER_NAME, 0);
            }
            if (isOffloadScheduleSet) {
                tieringScheduleId = this.getParamIntValue(RW_VOLUME_PARAM_OFFLOAD_SCHEDULEID, 0);
            }
            if (isRecallExpirySet) {
                recallExpiryTime = this.getParamIntValue(RW_VOLUME_PARAM_RECALL_EXPIRY_TIME, 0);
            } else if (isTierNameSet) {
                recallExpiryTime = 1;
            }
            if (isCompactionScheduleSet) {
                if (!tieringEnable) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "compactionschedule can be modified only when tiering is enabled"));
                    return output;
                }
                compactionScheduleId = this.getParamIntValue(RW_VOLUME_PARAM_COMPACTION_SCHEDULEID, 0);
            }
            if (isCompactionOverheadSet) {
                if (!tieringEnable) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "compactionoverheadthreshold can be modified only when tiering is enabled"));
                    return output;
                }
                compactionOverhead = this.getParamIntValue(RW_VOLUME_PARAM_COMPACTION_OVERHEAD, 0);
            }
            if (isTieringRuleSet) {
                tieringRule = this.getParamTextValue(RW_VOLUME_PARAM_TIERING_RULE, 0);
            }
            if (isTierKeySet) {
                tierKey = this.getParamTextValue(RW_VOLUME_PARAM_TIER_KEY, 0);
            }
            if (bl) {
                tierEncryption = this.getParamBooleanValue(RW_VOLUME_PARAM_TIER_ENCRYPTION, 0);
            }
            CLDBProto.TierProperties tierProps = null;
            CLDBProto.VolumeTieringProperties.Builder volTierProps = null;
            if (isTierParamsSet || isHrrSet) {
                int createTierStatus;
                if (this.isParamPresent("cluster")) {
                    cluster = this.getParamTextValue("cluster", 0);
                }
                volTierProps = CLDBProto.VolumeTieringProperties.newBuilder();
                if (!(tierEncryption || savedVolProps.hasTierProps() || savedVolProps.getTierProps().getTierEncryption() || tierKey == null)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Parameter tierkey is applicable only when tier encryption is enabled"));
                    return output;
                }
                if (autoCreateECTier && (createTierStatus = this.CreateECTier(tierName = TierCommands.generateTierNameForAutoCreate(rwVolumeName), cluster)) != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(createTierStatus, "tier create failed, look into cldb/maprcli logs or retry it"));
                    return output;
                }
                if (tierName != null) {
                    CLDBProto.TierLookupResponse tierResp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName);
                    if (tierResp != null && tierResp.getStatus() != 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier " + tierName + " does not exist"));
                        return output;
                    }
                    if (tierResp.hasTierProperties()) {
                        tierProps = tierResp.getTierProperties();
                        volTierProps.setTierId(tierProps.getTierId());
                    }
                }
                if (tieringScheduleId != -1) {
                    volTierProps.setScheduleId(tieringScheduleId);
                }
                if (recallExpiryTime > 0) {
                    volTierProps.setRecallExpiryTime((long)(recallExpiryTime * 24 * 60 * 60));
                }
                if (isCompactionParamSet) {
                    CLDBProto.CompactionProperties.Builder compactionBuilder = CLDBProto.CompactionProperties.newBuilder();
                    if (isCompactionScheduleSet) {
                        compactionBuilder.setScheduleId(compactionScheduleId);
                    }
                    if (isCompactionOverheadSet) {
                        if (compactionOverhead < 0 || compactionOverhead > 100) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Overhead threshold is a percentage, it should be less than or equal to 100"));
                            return output;
                        }
                        compactionBuilder.setOverheadPercentage(compactionOverhead);
                    }
                    volTierProps.setCompactionProps(compactionBuilder.build());
                }
                if (tieringRule != null) {
                    CLDBProto.OffloadRuleLookupResponse tierRuleResp = OffloadRuleCommands.ruleLookup(cluster, this.getUserCredentials(), tieringRule);
                    if (tierRuleResp != null && tierRuleResp.getStatus() != 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tiering rule " + tieringRule + " does not exist"));
                        return output;
                    }
                    if (tierRuleResp.hasRuleProps()) {
                        volTierProps.setRuleId(tierRuleResp.getRuleProps().getRuleId());
                    }
                }
                if (tierKey != null) {
                    if (tierKey.length() != 32) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tierKey should be 32 character HEX string"));
                        return output;
                    }
                    try {
                        byte[] data = this.StringToHex(tierKey);
                        Security.Key key = Security.Key.newBuilder().setKey(ByteString.copyFrom((byte[])data)).build();
                        volumeUpdate.setTierKey(key);
                    }
                    catch (NumberFormatException e) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid hex string"));
                        return output;
                    }
                    catch (Exception e) {
                        throw new CLIProcessingException("Exception", (Throwable)e);
                    }
                }
                if (bl || isTierNameSet) {
                    volTierProps.setTierEncryption(tierEncryption);
                }
                if (isSkipWSForInternalOpsSet || isHrrSet) {
                    boolean isECVolume;
                    if (tierProps == null) {
                        if (!savedVolProps.hasTierProps() || !savedVolProps.getTierProps().hasTierId()) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier Id for volume is not present"));
                            return output;
                        }
                        int tierId = savedVolProps.getTierProps().getTierId();
                        CLDBProto.TierLookupResponse tierResp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierId);
                        if (tierResp != null && tierResp.getStatus() != 0 || !tierResp.hasTierProperties()) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier properties for tier: " + tierId + " couldn't be looked up"));
                            return output;
                        }
                        tierProps = tierResp.getTierProperties();
                    }
                    boolean bl3 = isECVolume = tierProps != null && tierProps.getTierType() == CLDBProto.TierType.EC_TIER;
                    if (isSkipWSForInternalOpsSet) {
                        if (!isECVolume && !savedVolProps.getIsMirrorVol()) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Param: skipwiresecurityfortierinternalops is only applicable to EC volume or Mirror Tiered volume"));
                            return output;
                        }
                        boolean skipInternalOpsWS = this.getParamBooleanValue(SKIP_WIRE_SECURITY_FOR_INTERNAL_OP, 0);
                        volProps.setSkipWireSecurityForTierInternalOps(skipInternalOpsWS);
                    }
                    if (isHrrSet) {
                        if (!isECVolume) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Param: honorrackreliability is only applicable to EC volumes."));
                            return output;
                        }
                        boolean honorRackReliability = this.getParamBooleanValue(RW_VOLUME_PARAM_HONORRACKRELIABILITY, 0);
                        volProps.setHonorRackReliability(honorRackReliability);
                    }
                }
                volProps.setTierProps(volTierProps.build());
            }
            if (!isTierNameSet && !autoCreateECTier && (this.isParamPresent(RW_VOLUME_PARAM_ECSCHEME) || this.isParamPresent(EC_STRIPE_DEPTH_MB) || this.isParamPresent(RW_VOLUME_PARAM_ECTOPOLOGY))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ecscheme/ecstripedepthmb/ectopology can be set along with ec tiername only"));
                return output;
            }
            if (tierProps != null && tierProps.getTierType() == CLDBProto.TierType.EC_TIER) {
                if (bl || isTierKeySet) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tierencryption or tierkey is not applicable for creating ec volumes"));
                    return output;
                }
                tierEncryption = false;
                CLDBProto.ECVolumeProperties.Builder ecVolProps = CLDBProto.ECVolumeProperties.newBuilder();
                if (this.isParamPresent(EC_STRIPE_DEPTH_MB)) {
                    int ecStripeDepthMB = this.getParamIntValue(EC_STRIPE_DEPTH_MB, 0);
                    ecVolProps.setEcStripeDepthMB(ecStripeDepthMB);
                    volProps.setEcStripeDepthMB(ecStripeDepthMB);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_ECTOPOLOGY)) {
                    String ecTopology = this.getParamTextValue(RW_VOLUME_PARAM_ECTOPOLOGY, 0);
                    if (!ecTopology.startsWith("/")) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ecTopology specified" + ecTopology + ". It should start with \"/\"").setField(RW_VOLUME_PARAM_TOPOLOGY).setFieldValue(ecTopology));
                        return output;
                    }
                    ecVolProps.setEcTopology(ecTopology);
                }
                if (this.isParamPresent(RW_VOLUME_PARAM_ECSCHEME)) {
                    int np;
                    String ecScheme = this.getParamTextValue(RW_VOLUME_PARAM_ECSCHEME, 0);
                    if (!ecScheme.contains("+")) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ecScheme is not in m + k format"));
                        return output;
                    }
                    String[] v = ecScheme.replaceAll("\\s+", "").split("\\+");
                    int nd = Integer.valueOf(v[0]);
                    int ngp = Integer.valueOf(v[1]);
                    int nlp = 0;
                    if (v.length > 2) {
                        nlp = Integer.valueOf(v[2]);
                    }
                    if (nd < (np = ngp + nlp)) {
                        if (nlp != 0) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ecScheme " + nd + "+" + ngp + "+" + nlp + ", Number of DataFragments have to be more than or equal to number of Total ParityFragments"));
                            return output;
                        }
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ecScheme " + nd + "+" + ngp + ", Number of DataFragments have to be more than or equal to number of Total ParityFragments"));
                        return output;
                    }
                    if (nd <= 0 || ngp <= 0 || nlp < 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ecScheme " + nd + "+" + ngp + "+" + nlp + ", Number of DataFragments and ParityFragments can not accept negative values"));
                        return output;
                    }
                    if (nlp == 1) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ecScheme " + nd + "+" + ngp + "+" + nlp + ", Number of Local ParityFragments can not be 1"));
                        return output;
                    }
                    if (nlp > 1 && nd % nlp != 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ecScheme " + nd + "+" + ngp + "+" + nlp + ", Number of DataFragments have to be divisible by Local ParityFragments"));
                        return output;
                    }
                    volProps.setNumECDataColumns(nd);
                    volProps.setNumECParityColumns(np);
                    if (nlp != 0) {
                        volProps.setNumECLocalParityColumns(nlp);
                    }
                }
                volTierProps.setEcVolProps(ecVolProps.build());
                volTierProps.setTierEncryption(tierEncryption);
                volProps.setTierProps(volTierProps.build());
            }
            if (this.isParamPresent(NUM_ACTIVE_CG_CONTAINERS)) {
                int numActiveCgContainers;
                if (!savedVolProps.hasTierRelationships() || !savedVolProps.getTierRelationships().hasBackendEcVolumeId()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "num_active_cg_containers argument can be set only on EC frontend volumes"));
                }
                if ((numActiveCgContainers = this.getParamIntValue(NUM_ACTIVE_CG_CONTAINERS, 0)) < 1 || numActiveCgContainers > 100) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Num Active CG containers should be between 1 and 100"));
                    return output;
                }
                volProps.setNumActiveCgContainers(numActiveCgContainers);
            }
            if (this.isParamPresent(RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL)) {
                int atimeVal;
                String atimeUpdateInterval = this.getParamTextValue(RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL, 0);
                StringBuilder SB = new StringBuilder(atimeUpdateInterval);
                int ch = SB.charAt(SB.length() - 1);
                try {
                    if (ch != 100 && ch != 104 && ch != 109 && ch != 115) {
                        atimeVal = Integer.parseInt(SB.substring(0, SB.length()));
                        ch = 100;
                    } else {
                        atimeVal = Integer.parseInt(SB.substring(0, SB.length() - 1));
                    }
                }
                catch (Exception ex) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, this.cliCommand.getUsageFromParametersOfCommandsTree()));
                    return output;
                }
                if (atimeVal < 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, this.cliCommand.getUsageFromParametersOfCommandsTree()));
                    return output;
                }
                switch (ch) {
                    case 100: {
                        atimeVal *= 86400;
                        break;
                    }
                    case 104: {
                        atimeVal *= 3600;
                        break;
                    }
                    case 109: {
                        atimeVal *= 60;
                        break;
                    }
                }
                volProps.setAtimeUpdateIntervalSecs(atimeVal);
            }
            if (this.isParamPresent(AUTO_OFFLOAD_THRESHOLD_GB)) {
                if (!tieringEnable) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "autooffloadthresholdgb can be modified only when tiering is enabled"));
                    return output;
                }
                volProps.setAutoOffloadThresholdGB(Integer.valueOf(this.getParamIntValue(AUTO_OFFLOAD_THRESHOLD_GB, 0)).intValue());
            }
            volumeUpdate.setVolProperties(volProps.build());
            volumeUpdate.setCreds(this.getUserCredentials());
            byte[] data = null;
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), (MessageLite)volumeUpdate.build(), CLDBProto.VolumeUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), (MessageLite)volumeUpdate.build(), CLDBProto.VolumeUpdateResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.VolumeUpdateResponse resp = CLDBProto.VolumeUpdateResponse.parseFrom((byte[])data);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)resp.getErrMsg());
                }
                if (resp.getStatus() == 0) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                if (!autoCreateECTier) continue;
                LOG.debug((Object)("rollbackECEnable of tier:" + tierName + " for volume:" + rwVolumeName));
                this.rollbackECEnable(tierName, cluster);
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume Modify:  VolumeName: " + rwVolumeName + Errno.toString((int)10003) + " Volume modify failed"));
                LOG.error((Object)"Exception during Volume modify ", (Throwable)e);
            }
        }
        return output;
    }

    private CommandOutput updateDare() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.VolumeDareClearRequest.Builder dareUpReq = CLDBProto.VolumeDareClearRequest.newBuilder().setCreds(this.getUserCredentials());
        if (this.isParamPresent(ALL_VOLUMES_PARAM_NAME)) {
            dareUpReq.setUpdateAll(true);
        }
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeDareClearProc.getNumber(), (MessageLite)dareUpReq.build(), CLDBProto.VolumeDareClearResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeDareClearProc.getNumber(), (MessageLite)dareUpReq.build(), CLDBProto.VolumeDareClearResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.VolumeDareClearResponse resp = CLDBProto.VolumeDareClearResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                LOG.error((Object)resp.getErrMsg());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to update volume dare."));
            LOG.error((Object)"Exception during Volume dare update ", (Throwable)e);
        }
        return output;
    }

    private CLDBProto.NoteOperation getNoteOperation(StringBuilder msg) throws CLIProcessingException {
        CLDBProto.NoteOperation.Builder noBuilder = CLDBProto.NoteOperation.newBuilder();
        if (this.isParamPresent(ADD_VOLUME_NOTE)) {
            noBuilder.setOper(CLDBProto.NoteOperationEnum.NOTE_OP_ADD).setNoteName(this.getParamTextValue(ADD_VOLUME_NOTE, 0));
        } else if (this.isParamPresent(RESOLVE_VOLUME_NOTE)) {
            noBuilder.setOper(CLDBProto.NoteOperationEnum.NOTE_OP_RESOLVE).setNoteName(this.getParamTextValue(RESOLVE_VOLUME_NOTE, 0));
        } else {
            msg.append("invalid operation for volumenote.");
            return null;
        }
        if (!this.isParamPresent(NOTE_COMMENT)) {
            msg.append("Volumenote cannot be modified without comments.");
            return null;
        }
        return noBuilder.setComment(this.getParamTextValue(NOTE_COMMENT, 0)).build();
    }

    private CLDBProto.VolumeProperties volumePropetiesLookup(String volumeName) throws CLIProcessingException {
        return this.volumePropetiesLookup(volumeName, true);
    }

    private CLDBProto.VolumeProperties volumePropetiesLookup(String volumeName, boolean needsRootCid) throws CLIProcessingException {
        byte[] data = null;
        CLDBProto.VolumeLookupRequest req = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(volumeName).setNeedsRootCid(needsRootCid).setCreds(this.getUserCredentials()).build();
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                LOG.error((Object)("volumePropetiesLookup RPC to CLDB failed for volume " + volumeName));
                return null;
            }
            CLDBProto.VolumeLookupResponse resp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                return resp.getVolInfo().getVolProperties();
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception during volumePropetiesLookup RPC to CLDB " + e));
            return null;
        }
        return null;
    }

    private CommandOutput volumeFixMountPath() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> volumeNames = new ArrayList<String>();
        String rwVolumeName = this.getRwVolumeName();
        if (!rwVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(rwVolumeName);
        } else {
            volumeNames.addAll(Arrays.asList(rwVolumeName.split(MULTI_ARG_SEP)));
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        Common.MapRClusterDefaults mapRClusterDefaults = Common.MapRClusterDefaults.getDefaultInstance();
        for (String volName : volumeNames) {
            Object msg;
            String msg2;
            Object msg3;
            CLDBProto.VolumeProperties volProps = this.volumePropetiesLookup(volName);
            if (volProps == null) {
                msg3 = "could not find volume properties for " + volName;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, (String)msg3));
                continue;
            }
            if (!volProps.getMounted()) {
                msg3 = String.format("volume: %s not mounted", volName);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, (String)msg3));
                continue;
            }
            String rwVolumeMountDir = volProps.getMountDir();
            Common.FidMsg parentFid = volProps.getParentFid();
            if (mapRClusterDefaults.getClusterRootName().equals(volName)) {
                String msg4 = String.format("volume %s found mounted at: %s (no change required)", rwVolumeName, rwVolumeMountDir);
                out.addMessage(msg4);
                LOG.info((Object)msg4);
                continue;
            }
            int index = rwVolumeMountDir.lastIndexOf(47);
            if (index == -1) {
                String msg5 = "Could not determine mount filename in dir: " + rwVolumeMountDir;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg5));
                LOG.error((Object)msg5);
            }
            String mntName = rwVolumeMountDir.substring(index);
            Object newPath = fs.getMountPath(cluster, this.getUserLoginId(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
            if (newPath == null) {
                msg2 = String.format("could not find mountPath for volume %s (fs.getMountPath() returned null)", volName);
                LOG.error((Object)msg2);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg2));
                continue;
            }
            LOG.debug((Object)("Volume fixmountpath: getNewMountPath returned: " + (String)newPath));
            newPath = (String)newPath + mntName;
            if (((String)newPath).equals(rwVolumeMountDir)) {
                msg2 = String.format("volume %s found mounted at: %s (no change required)", rwVolumeName, rwVolumeMountDir);
                out.addMessage(msg2);
                LOG.info((Object)msg2);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("volume fixmountpath" + volName));
            }
            byte[] data = null;
            CLDBProto.VolumeProperties newVolProps = CLDBProto.VolumeProperties.newBuilder().setVolumeName(volName).setMountDir((String)newPath).build();
            CLDBProto.VolumeUpdateRequest volReq = CLDBProto.VolumeUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setVolProperties(newVolProps).build();
            try {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeUpdateProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeUpdateResponse.class);
                if (data == null) {
                    String msg6 = "volume fixmountpath response null for volume " + volName;
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg6));
                    LOG.error((Object)msg6);
                    continue;
                }
                CLDBProto.VolumeUnMountResponse resp = CLDBProto.VolumeUnMountResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    msg = String.format("volume: %s, corrected mountpath to: %s (old=%s)", volName, newPath, rwVolumeMountDir);
                    out.addMessage((String)msg);
                    LOG.info(msg);
                    continue;
                }
                msg = "Volume fixmountpath: " + Errno.toString((int)resp.getStatus());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), (String)msg));
                LOG.error(msg);
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                msg = "Volume fixmountpath: Operation failed: " + e;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, (String)msg));
                LOG.error(msg);
            }
        }
        return output;
    }

    boolean checkEntityExists(boolean type, String name) {
        String cmd = null;
        if (name.equals("allusers")) {
            return true;
        }
        cmd = !type ? "getent passwd " + name : "getent group " + name;
        try {
            String result = new TextCommandOutput(this.executeSimpleSHHCommand(6000L, cmd)).toString();
            return result != null && !result.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getRwVolumeName() throws CLIProcessingException {
        return this.isParamPresent(RW_VOLUME_PARAM_NAME) ? this.getParamTextValue(RW_VOLUME_PARAM_NAME, 0) : null;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    private String getColumnsParamValue() throws CLIProcessingException {
        return this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
    }

    private int getLimitParamValue() throws CLIProcessingException {
        return this.isParamPresent(LIMIT_PARAM_NAME) ? this.getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
    }

    private int getStartParamValue() throws CLIProcessingException {
        return this.isParamPresent(START_PARAM_NAME) ? this.getParamIntValue(START_PARAM_NAME, 0) : 0;
    }

    private boolean volumeChangeMirrorMode(String rwVolumeName, CLDBProto.VolumeProperties oldVolProps, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        boolean failed = false;
        if (this.isParamPresent(MIRROR_VOLUME)) {
            boolean convertToMirror;
            int volTargettype = 3;
            String mirrorType = this.getParamTextValue(MIRROR_VOLUME, 0);
            if (!(mirrorType.equalsIgnoreCase("rw") || mirrorType.equalsIgnoreCase("mirror") || mirrorType.equalsIgnoreCase("0") || mirrorType.equalsIgnoreCase("1"))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type " + mirrorType + " specified. Please specify rw/mirror").setField(MIRROR_VOLUME_SRC_VOLUMENAME));
                return true;
            }
            boolean isVolumeMirror = oldVolProps.getIsMirrorVol();
            int oldVolType = 0;
            if (oldVolProps.hasVolumetype()) {
                oldVolType = oldVolProps.getVolumetype().getNumber();
            }
            if (oldVolType == 0 || oldVolType == 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " is a standard volume"));
                return true;
            }
            boolean bl = convertToMirror = mirrorType.equalsIgnoreCase("mirror") || mirrorType.equalsIgnoreCase("1");
            if (isVolumeMirror && convertToMirror) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " is already a mirror volume"));
                return true;
            }
            if (!isVolumeMirror && !convertToMirror) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " is already a rw volume"));
                return true;
            }
            if (convertToMirror && oldVolProps.getMirrorInfo().getSrcVolumeId() == 0 && !this.isParamPresent(MIRROR_VOLUME_SRC_VOLUMENAME)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " does not have source volume. Please specify the source volume"));
                return true;
            }
            if (convertToMirror && oldVolProps.getIsAuditVolume()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, rwVolumeName + " is an audit volume. Cannot convert to mirror volume"));
                return true;
            }
            if (convertToMirror) {
                volTargettype = 2;
            }
            boolean ismirror = volTargettype == 1 || volTargettype == 2;
            CLDBProto.VolumeChangeMirrorModeRequest.Builder volumeCmmr = CLDBProto.VolumeChangeMirrorModeRequest.newBuilder();
            volumeCmmr.setVolumeName(rwVolumeName);
            volumeCmmr.setMirrorMode(ismirror);
            volumeCmmr.setCreds(this.getUserCredentials());
            byte[] data = null;
            try {
                CLDBProto.VolumeChangeMirrorModeResponse resp;
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeChangeMirrorModeProc.getNumber(), (MessageLite)volumeCmmr.build(), CLDBProto.VolumeChangeMirrorModeResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeChangeMirrorModeProc.getNumber(), (MessageLite)volumeCmmr.build(), CLDBProto.VolumeChangeMirrorModeResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Volume mode change: Couldn't connect to the CLDB service"));
                    failed = true;
                }
                if ((resp = CLDBProto.VolumeChangeMirrorModeResponse.parseFrom((byte[])data)).getStatus() == 0) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Volume mode changed for " + rwVolumeName));
                    }
                } else if (resp.getStatus() == 115) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Cannot convert volume " + rwVolumeName + " as mirror op is in progress"));
                    LOG.error((Object)("Cannot convert volume " + rwVolumeName + " as mirror op is in progress"));
                    failed = true;
                } else {
                    if (resp.hasErrorMsg()) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrorMsg()));
                        LOG.error((Object)("Volume mode change failed, " + resp.getErrorMsg()));
                    } else {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Volume mode change:  VolumeName: " + rwVolumeName + " " + Errno.toString((int)resp.getStatus())));
                        LOG.error((Object)("Volume mode change failed, " + Errno.toString((int)resp.getStatus())));
                    }
                    failed = true;
                }
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Volume mode change:  VolumeName: " + rwVolumeName + Errno.toString((int)10003) + " Volume mode change failed"));
                LOG.error((Object)"Exception during Volume mode change ", (Throwable)e);
                failed = true;
            }
        }
        return failed;
    }

    private Common.VolumeAces buildVolumeAcesProtobuf(Map<String, Common.VolumeActions> volumeAceParameterMap, CommandOutput.OutputHierarchy out) throws IOException, CLIProcessingException {
        String policies;
        Common.VolumeAces.Builder acesBuilder = Common.VolumeAces.newBuilder();
        boolean anyValidAccessControlPresent = false;
        try {
            for (String param : volumeAceParameterMap.keySet()) {
                if (!this.isParamPresent(param)) continue;
                String arg = this.getParamTextValue(param, 0);
                acesBuilder.addAces(Common.VolumeAceEntry.newBuilder().setAccessType(volumeAceParameterMap.get(param)).setExpr(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)arg))).build());
                anyValidAccessControlPresent = true;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to parse volume ace arguments");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error Parsing Volume Aces: " + e.getMessage()));
            throw e;
        }
        if (this.isParamPresent(PBS_SECURITY_POLICY) && !(policies = this.getParamTextValue(PBS_SECURITY_POLICY, 0)).equals("")) {
            ArrayList<Integer> polIds = new ArrayList<Integer>();
            acesBuilder.setCompositePolicyId(this.getCompositeId(policies, polIds, out));
            acesBuilder.addAllPolicyIds(polIds);
            anyValidAccessControlPresent = true;
        }
        if (this.isParamPresent(PBS_ENFORCEMENT_MODE)) {
            String enforcementMode = this.getParamTextValue(PBS_ENFORCEMENT_MODE, 0);
            boolean enforceAces = true;
            boolean enforcePolicies = true;
            boolean auditOnlyPolicyCheck = false;
            if (enforcementMode.equalsIgnoreCase("PolicyAceAndDataAce")) {
                enforceAces = true;
                enforcePolicies = true;
            } else if (enforcementMode.equalsIgnoreCase("PolicyAceOnly")) {
                enforceAces = false;
                enforcePolicies = true;
            } else if (enforcementMode.equalsIgnoreCase("DataAceOnly")) {
                enforceAces = true;
                enforcePolicies = false;
            } else if (enforcementMode.equalsIgnoreCase("PolicyAceAuditAndDataAce")) {
                enforceAces = true;
                enforcePolicies = false;
                auditOnlyPolicyCheck = true;
            } else {
                LOG.error((Object)("Invalid volume enforcement mode: " + enforcementMode));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid volume enforcement mode: " + enforcementMode));
                throw new IOException();
            }
            acesBuilder.setEnforceAces(enforceAces);
            acesBuilder.setEnforcePolicies(enforcePolicies);
            acesBuilder.setEnableAuditOnlyPolicyCheck(auditOnlyPolicyCheck);
            anyValidAccessControlPresent = true;
        }
        return anyValidAccessControlPresent ? acesBuilder.build() : null;
    }

    int getCompositeId(String policies, List<Integer> outPolicyIds, CommandOutput.OutputHierarchy out) throws IOException, CLIProcessingException {
        if (policies == null || policies.isEmpty() || policies.equals("")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Policy Param"));
            throw new IOException();
        }
        HashSet<String> policySet = new HashSet<String>();
        String filterRegexp = MULTI_ARG_SEP;
        Scanner s = new Scanner(policies.trim()).useDelimiter(filterRegexp);
        while (s.hasNext()) {
            String policyName = s.next().trim();
            if (policySet.contains(policyName)) {
                LOG.error((Object)("Duplicate Security policy name: " + policyName));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Duplicate Security policy name: " + policyName));
                throw new IOException();
            }
            policySet.add(policyName);
        }
        if (policySet.isEmpty()) {
            LOG.error((Object)"No valid secuirty policy name in input");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No valid secuirty policy name in input"));
            throw new IOException();
        }
        if (policySet.size() > 16) {
            LOG.error((Object)"Maximum 16 security tags allowed");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Maximum 16 security policy tags allowed"));
            throw new IOException();
        }
        StringBuilder errMsgSB = new StringBuilder();
        List polIds = null;
        int compositeId = 0;
        PolicyServerProto.GetCompositePolicyIdResponse resp = this.getCompositeId(new ArrayList<String>(policySet), errMsgSB);
        if (resp == null || resp.getStatus() != 0) {
            String errMsg = errMsgSB.length() == 0 ? "Error while fetching composite id, check if policy server is up and running" : errMsgSB.toString();
            LOG.error((Object)errMsg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
            throw new IOException();
        }
        Common.CompositePolicyInfo cIdInfo = resp.getRetCompositePolicyInfo(0);
        polIds = cIdInfo.getPolicyIdsCount() > 0 ? cIdInfo.getPolicyIdsList() : null;
        int n = compositeId = cIdInfo.hasCompositePolicyId() ? cIdInfo.getCompositePolicyId() : 0;
        if (compositeId == 0 || polIds == null) {
            String errMsg = errMsgSB.length() == 0 ? "Invalid Composite ID either policy server is down or non-taggable security policy" : errMsgSB.toString();
            LOG.error((Object)errMsg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
            throw new IOException();
        }
        if (outPolicyIds != null && polIds != null) {
            outPolicyIds.addAll(polIds);
        }
        return compositeId;
    }

    private CLDBProto.VolumeProperties getSkipInheritProps() throws CLIProcessingException {
        if (!this.isParamPresent(SKIP_INHERIT)) {
            return null;
        }
        CLDBProto.VolumeProperties.Builder volProps = CLDBProto.VolumeProperties.newBuilder();
        String props = this.getParamTextValue(SKIP_INHERIT, 0);
        ArrayList<String> propnames = new ArrayList<String>();
        if (props.contains(MULTI_ARG_SEP)) {
            propnames.addAll(Arrays.asList(props.split(MULTI_ARG_SEP)));
        } else {
            propnames.add(props);
        }
        for (String prop : propnames) {
            if (prop.length() == 0) continue;
            if (prop.equals(VOLUME_SCHEDULE)) {
                int dummyScheduleId = 1;
                volProps.setSchedulingPolicyId(dummyScheduleId);
                continue;
            }
            if (prop.equals(RW_VOLUME_PARAM_TIER_NAME)) {
                volProps.setTierProps(CLDBProto.VolumeTieringProperties.getDefaultInstance());
                continue;
            }
            throw new CLIProcessingException(prop + " not handled to skip inheritance.");
        }
        return volProps.build();
    }

    private int CreateECTier(String tierName, String cluster) throws CLIProcessingException {
        CLDBProto.TierLookupResponse tierLookupResp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName);
        if (tierLookupResp == null) {
            return 10009;
        }
        if (tierLookupResp.getStatus() != 0) {
            CLDBProto.TierCreateResponse tierCreateResp = TierCommands.EcTierCreate(cluster, this.getUserCredentials(), this.getUserLoginId(), tierName);
            if (tierCreateResp == null) {
                return 10009;
            }
            if (tierCreateResp.hasStatus() && tierCreateResp.getStatus() != 0) {
                LOG.info((Object)("autoCreateECTier: tier creation failed with name: " + tierName + " as part of volume create/modify"));
            } else {
                LOG.info((Object)("autoCreateECTier: tier created with name: " + tierName + " as part of volume create/modify"));
            }
            return tierCreateResp.getStatus();
        }
        return tierLookupResp.getStatus();
    }

    private int rollbackECEnable(String tierName, String cluster) throws CLIProcessingException {
        int status = TierCommands.tierRemove(tierName, cluster, this.getUserLoginId(), this.getUserCredentials(), this.isServerCall);
        if (status != 0 && status != 2) {
            LOG.error((Object)("Error in rollbackECEnable for tier:" + tierName + ", errCode:" + status));
        }
        return status;
    }

    private PolicyServerProto.GetCompositePolicyIdResponse getCompositeId(List<String> polList, StringBuilder errMsgSB) throws IOException, CLIProcessingException {
        PolicyServerProto.GetCompositePolicyIdRequest.Builder reqB = PolicyServerProto.GetCompositePolicyIdRequest.newBuilder();
        reqB.setCreds(this.getUserCredentials());
        reqB.addCompositePolicyInfos(Common.CompositePolicyInfo.newBuilder().addAllPolicyNames(polList).build());
        reqB.setShouldCreate(true);
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.PolicyServerProgramId.getNumber(), PolicyServerProto.SecurityPolicyProc.GetCompositePolicyIdProc.getNumber(), (MessageLite)reqB.build(), PolicyServerProto.GetCompositePolicyIdResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.PolicyServerProgramId.getNumber(), PolicyServerProto.SecurityPolicyProc.GetCompositePolicyIdProc.getNumber(), (MessageLite)reqB.build(), PolicyServerProto.GetCompositePolicyIdResponse.class);
        }
        catch (Exception e) {
            LOG.error((Object)"SendRequest Exception: ", (Throwable)e);
        }
        if (data != null) {
            PolicyServerProto.GetCompositePolicyIdResponse resp = PolicyServerProto.GetCompositePolicyIdResponse.parseFrom(data);
            if (resp.getStatus() == 0) {
                return resp;
            }
            if (resp.getErrMsg() != null && !resp.getErrMsg().isEmpty()) {
                errMsgSB.append(resp.getErrMsg());
            }
        }
        return null;
    }

    private boolean canRemoveS3AccountVol(CLDBProto.VolumeProperties volProps, CommandOutput.OutputHierarchy out) {
        if (!this.isVolumeRemovePermitted(volProps.getVolumeName())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "Volume Remove: " + Errno.toString((int)95) + " isVolumeRemovePermitted failed, Does not have sufficient permissions for volume remove"));
            return false;
        }
        int accountId = 0;
        if (!volProps.getIsMirrorVol()) {
            if (!volProps.hasVolumeAe()) {
                return true;
            }
            CLDBProto.AeKey aeKey = volProps.getVolumeAe();
            if (!aeKey.hasObjectStoreAccountId()) {
                return true;
            }
            if (!aeKey.hasObjectStoreAccountId() || aeKey.getObjectStoreAccountId() < 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "Volume Remove: " + Errno.toString((int)95) + " Invalid object store account id for volume " + volProps.getVolumeId()));
                return false;
            }
            accountId = aeKey.getObjectStoreAccountId();
            if (volProps.getIsS3AccountsRoot() && !this.isObjectStoreAccountUnderDeletion(accountId)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "Volume Remove: " + Errno.toString((int)95) + " Volume is marked as S3 Accounts root volume and has a valid AE."));
                return false;
            }
        }
        if (!this.isVolDeleteMarkerAdded(volProps)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "Volume Remove: " + Errno.toString((int)95) + " Cannot add volume delete marker"));
            return false;
        }
        if (!volProps.getIsMirrorVol() && !this.purgeExistingBuckets(accountId, volProps.getVolumeId())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(95, "Volume Remove: " + Errno.toString((int)95) + " Cannot purge s3 buckets for the volume"));
            return false;
        }
        return true;
    }

    private boolean isVolDeleteMarkerAdded(CLDBProto.VolumeProperties volProps) {
        String clusterName = null;
        try {
            clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
            FSRpcUtils rpcUtils = new FSRpcUtils(clusterName, this.getUserCredentials(), 8, Security.ServerKeyType.ServerKey, 0);
            int cid = volProps.getRootContainerId();
            boolean deleteS3Bucket = false;
            if (this.isParamPresent(RW_VOLUME_PARAM_S3_DELETE_BUCKET)) {
                deleteS3Bucket = this.getParamBooleanValue(RW_VOLUME_PARAM_S3_DELETE_BUCKET, 0);
            }
            Fileserver.VolDeleteMarkerAddRequest.Builder req = Fileserver.VolDeleteMarkerAddRequest.newBuilder().setVolId(volProps.getVolumeId()).setForce(deleteS3Bucket).setCreds(this.getUserCredentials());
            S3ServerGetMsgStatus getMsgStatus = new S3ServerGetMsgStatus(S3ServerGetMsgStatus.MsgType.volDeleteMarker);
            int status = rpcUtils.SendRequestToCid(cid, true, Common.MapRProgramId.FileServerProgramId.getNumber(), Fileserver.FSProg.VolDeleteMarkerAddProc.getNumber(), (MessageLite)req.build(), (GetMsgStatus)getMsgStatus);
            if (status != 0) {
                LOG.error((Object)("VolDeleteMarkerAddProc: Failed with " + status));
                return false;
            }
            Fileserver.VolDeleteMarkerAddResponse resp = (Fileserver.VolDeleteMarkerAddResponse)getMsgStatus.GetMsg();
            if (resp.getStatus() != 0) {
                LOG.error((Object)("VolDeleteMarkerAddProc: Failed with " + resp.getStatus()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("VolDeleteMarkerAddProc: Failed with " + e.toString()));
            return false;
        }
    }

    private boolean purgeExistingBuckets(int accountId, int volId) {
        CLDBS3ServerProto.S3PurgeBucketOfVolRequest.Builder req = CLDBS3ServerProto.S3PurgeBucketOfVolRequest.newBuilder().setAccountId(accountId).setVolId(volId).setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbS3ServerProgramId.getNumber(), CLDBS3ServerProto.S3ServerProg.S3PurgeBucketOfVolProc.getNumber(), (MessageLite)req.build(), CLDBS3ServerProto.S3PurgeBucketOfVolResponse.class);
            if (data == null) {
                LOG.error((Object)"Null response to S3PurgeBucketOfVolRequest");
                return false;
            }
            CLDBS3ServerProto.S3PurgeBucketOfVolResponse resp = CLDBS3ServerProto.S3PurgeBucketOfVolResponse.parseFrom((byte[])data);
            return resp.getStatus() == 0;
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while sending S3PurgeBucketOfVolProc to CLDB " + e.toString()));
            return false;
        }
    }

    private boolean isObjectStoreAccountUnderDeletion(int accountId) {
        try {
            CLDBS3ServerProto.S3AccountInfoRequest req = CLDBS3ServerProto.S3AccountInfoRequest.newBuilder().setAccountId(accountId).setCreds(this.getUserCredentials()).build();
            byte[] replyData = this.isParamPresent("cluster") ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(this.getParamTextValue("cluster", 0), CLDBS3ServerProto.S3ServerProg.S3AccountInfoProc.getNumber(), (MessageLite)req, CLDBS3ServerProto.S3AccountInfoResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3AccountInfoProc.getNumber(), (MessageLite)req, CLDBS3ServerProto.S3AccountInfoResponse.class);
            if (replyData == null) {
                LOG.error((Object)"No reply from CldbS3Server for Account Lookup of this volume");
                return false;
            }
            CLDBS3ServerProto.S3AccountInfoResponse response = CLDBS3ServerProto.S3AccountInfoResponse.parseFrom((byte[])replyData);
            return response.getStatus() == 2;
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
            return false;
        }
    }

    private boolean isVolumeRemovePermitted(String volName) {
        try {
            ArrayList<String> userList = new ArrayList<String>();
            userList.add(this.getUserLoginId());
            CLDBProto.PermEntity qe = CLDBProto.PermEntity.newBuilder().setType(CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME).setName(volName).build();
            CLDBProto.PermissionsQueryRequest queryReq = CLDBProto.PermissionsQueryRequest.newBuilder().setCreds(this.getUserCredentials()).addAllUserNames(userList).addEntities(qe).build();
            byte[] data = null;
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.UserPermissionsQueryProc.getNumber(), (MessageLite)queryReq, CLDBProto.PermissionsQueryResponse.class);
            if (data == null) {
                LOG.error((Object)"UserPermissionsQuery failed with null data");
                return false;
            }
            CLDBProto.PermissionsQueryResponse queryResp = CLDBProto.PermissionsQueryResponse.parseFrom((byte[])data);
            if (queryResp.getStatus() != 0) {
                LOG.error((Object)("UserPermissionsQueryProc failed with " + queryResp.getStatus()));
                return false;
            }
            CLDBProto.VolumeProperties volProp = ((CLDBProto.PermRespEntity)queryResp.getPermEntityList().get(0)).getVolProp();
            CLDBProto.ClusterConfiguration clusterConfig = queryResp.getConfig();
            boolean rejectRoot = clusterConfig.getRejectRoot();
            boolean squashRoot = clusterConfig.getSquashRoot();
            int clusterOwnerUid = clusterConfig.getClusterOwnerUid();
            CLDBProto.ClusterProperties props = clusterConfig.getProps();
            procPermsManager.initializeInstance(null, clusterOwnerUid, rejectRoot, squashRoot, props);
            List permList = procPermsManager.getUserPermissions(this.getUserCredentials(), volProp);
            for (PermissionsManager.ActionPermission perm : permList) {
                if (perm.action != CLDBProto.UserActions.VolumeRemove.name() || !perm.allow) continue;
                return true;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("isVolumeRemovePermitted exception occurred " + e));
            return false;
        }
    }

    private CommandOutput volumeFixPromotedVolume() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        try {
            byte[] data = null;
            CLDBProto.VolumeFixPromotedRequest.Builder reqB = CLDBProto.VolumeFixPromotedRequest.newBuilder();
            String volName = this.getRwVolumeName();
            if (volName == null) {
                String msg = "volume fixPromotedVolume recived null for volume name";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
                LOG.error((Object)msg);
                return output;
            }
            reqB.setVolumeName(volName);
            CLDBProto.VolumeFixPromotedRequest req = reqB.build();
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeFixPromotedProc.getNumber(), (MessageLite)req, CLDBProto.VolumeFixPromotedResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeFixPromotedProc.getNumber(), (MessageLite)req, CLDBProto.VolumeFixPromotedResponse.class);
            if (data == null) {
                String msg = "volume fixPromotedVolume response null for volume " + volName;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
                LOG.error((Object)msg);
                return output;
            }
            CLDBProto.VolumeFixPromotedResponse resp = CLDBProto.VolumeFixPromotedResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                String msg = String.format("fixPromotedVolume for volume: %s, completed succesfully", volName);
                out.addMessage(msg);
                LOG.info((Object)msg);
            } else {
                String msg = "Volume fixPromotedVolume: " + Errno.toString((int)resp.getStatus());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
                LOG.error((Object)msg);
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Volume fixPromotedVolume: Operation failed: " + e;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
            LOG.error((Object)msg);
        }
        return output;
    }

    static {
        fieldTableBuilder = new ImmutableMap.Builder().put((Object)new VolumeField(CLDBProto.VolumeInfoFields.owner), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.owner.getNumber(), "on", "creator", String.class, CLDBProto.ListSortKey.VolumeOwner)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.dataContainerRepltype), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.dataContainerRepltype.getNumber(), "dcr", RW_VOLUME_PARAM_DCREPLTYPE, String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numReplicas.getNumber(), "drf", "numreplicas", Integer.class, CLDBProto.ListSortKey.VolumeNumReplicas)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.minReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.minReplicas.getNumber(), "mrf", "minreplicas", Integer.class, CLDBProto.ListSortKey.VolumeMinReplicas)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.rackPath), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.rackPath.getNumber(), "rp", "rackpath", String.class, CLDBProto.ListSortKey.VolumeRackPath)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.localPath), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.localPath.getNumber(), "lp", "localpath", String.class, CLDBProto.ListSortKey.VolumeLocalPath)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.readOnly), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.readOnly.getNumber(), "ro", RW_VOLUME_PARAM_READONLY, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mountDir), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mountDir.getNumber(), "p", "mountdir", String.class, CLDBProto.ListSortKey.VolumeMountDir)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.volumeName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.volumeName.getNumber(), "n", "volumename", String.class, CLDBProto.ListSortKey.VolumeName)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mounted), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mounted.getNumber(), "mt", "mounted", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.quota), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.quota.getNumber(), "qta", RW_VOLUME_PARAM_QUOTA, Long.class, CLDBProto.ListSortKey.VolumeQuota)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.used), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.used.getNumber(), "dsu", "used", Long.class, CLDBProto.ListSortKey.VolumeUsed)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.logicalUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.logicalUsed.getNumber(), "dlu", "logicalUsed", Long.class, CLDBProto.ListSortKey.VolumeLogicalUsed)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.advisoryquota), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.advisoryquota.getNumber(), "aqt", RW_VOLUME_PARAM_ADVISORY_QUOTA, Long.class, CLDBProto.ListSortKey.VolumeQuotaAdvisory)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.aeName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.aeName.getNumber(), "aen", "aename", String.class, CLDBProto.ListSortKey.VolumeAeName)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.aeType), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.aeType.getNumber(), "aet", RW_VOLUME_PARAM_AETYPE, Integer.class, CLDBProto.ListSortKey.VolumeAeType)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.schedule), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.schedule.getNumber(), "sid", "scheduleid", Integer.class, CLDBProto.ListSortKey.VolumeSchedule)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorSchedule), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorSchedule.getNumber(), "msid", "mirrorscheduleid", Integer.class, CLDBProto.ListSortKey.VolumeMirrorSchedule)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.volumeType), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.volumeType.getNumber(), "t", "volumetype", Integer.class, CLDBProto.ListSortKey.VolumeType)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorType), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorType.getNumber(), "mrt", "mirrortype", Integer.class, CLDBProto.ListSortKey.VolumeMirrorType)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.CreatorContainerId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.CreatorContainerId.getNumber(), "ccid", "creatorcontainerid", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.CreatorVolumeUuid), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.CreatorVolumeUuid.getNumber(), "cvid", "creatorvolumeuuid", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcVolume), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorSrcVolume.getNumber(), "src", "mirrorSrcVolume", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorStatus), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorStatus.getNumber(), "mst", "mirrorstatus", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.lastSuccessfulMirrorTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.lastSuccessfulMirrorTime.getNumber(), "lmt", "lastSuccessfulMirrorTime", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorPercentComplete), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorPercentComplete.getNumber(), "mpc", "mirror-percent-complete", Integer.class, CLDBProto.ListSortKey.VolumeMirrorPercentComplete)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.dataSizeToMirror), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.dataSizeToMirror.getNumber(), "dstm", "data-size-to-mirror-mb", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.dataSizeMirrored), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.dataSizeMirrored.getNumber(), "dsm", "data-size-mirrored-mb", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorErrorCode), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorErrorCode.getNumber(), "mer", "mirror errorcode", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.snapshotcount), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.snapshotcount.getNumber(), "sc", "snapshotcount", Integer.class, CLDBProto.ListSortKey.VolumeSnapshotcount)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.volumeId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.volumeId.getNumber(), "id", "volumeid", Integer.class, CLDBProto.ListSortKey.VolumeId)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.snapshotUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.snapshotUsed.getNumber(), "ssu", "snapshotused", Long.class, CLDBProto.ListSortKey.VolumeSnapshotUsed)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.totalUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.totalUsed.getNumber(), "tsu", "totalused", Long.class, CLDBProto.ListSortKey.VolumeTotalUsed)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.listReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.listReplicas.getNumber(), "arf", "actualreplication", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.scheduleName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.scheduleName.getNumber(), "sn", "schedulename", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.SnapshotFailureAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.SnapshotFailureAlarm.getNumber(), "sfa", "SnapshotFailureAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.MirrorFailureAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.MirrorFailureAlarm.getNumber(), "mfa", "MirrorFailureAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.DataUnderReplicatedAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.DataUnderReplicatedAlarm.getNumber(), "rfa", "DataUnderReplicatedAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.DataUnavailableAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.DataUnavailableAlarm.getNumber(), "dua", "DataUnavailableAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.AdvisoryQuotaExceededAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.AdvisoryQuotaExceededAlarm.getNumber(), "aqa", "AdvisoryQuotaExceededAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.QuotaExceededAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.QuotaExceededAlarm.getNumber(), "qa", "QuotaExceededAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.NoNodesInTopologyAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.NoNodesInTopologyAlarm.getNumber(), "nna", "NoNodesInTopologyAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.AlmostFullTopologyAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.AlmostFullTopologyAlarm.getNumber(), "afta", "AlmostFullTopologyAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.FullTopologyAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.FullTopologyAlarm.getNumber(), "fta", "FullTopologyAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.InodesExceededAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.InodesExceededAlarm.getNumber(), "ia", "InodesExceededAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.ContainersNonLocalAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.ContainersNonLocalAlarm.getNumber(), "cnla", "ContainersNonLocalAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.CannotMirrorAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.CannotMirrorAlarm.getNumber(), "cma", "CannotMirrorAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.OffloadRecallFailureAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.OffloadRecallFailureAlarm.getNumber(), "ora", "OffloadRecallFailureAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.CompactionFailureAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.CompactionFailureAlarm.getNumber(), "cfa", "CompactionFailureAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.DegradedEcStripesAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.DegradedEcStripesAlarm.getNumber(), "dea", "DegradedEcStripesAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.CriticallyDegradedEcStripesAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.CriticallyDegradedEcStripesAlarm.getNumber(), "cea", "CriticallyDegradedEcStripesAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.EcDataUnavailableAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.EcDataUnavailableAlarm.getNumber(), "eua", "EcDataUnavailableAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.SnaprestoreMaxretriesExceededAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.SnaprestoreMaxretriesExceededAlarm.getNumber(), "sra", "SnaprestoreMaxretriesExceededAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.acl), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.acl.getNumber(), "acl", "acl", CommandOutput.OutputHierarchy.OutputNode.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcClusterName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorSrcClusterName.getNumber(), "msc", "mirrorSrcCluster", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorSrcVolumeId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorSrcVolumeId.getNumber(), "msi", "mirrorSrcVolumeId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeName.getNumber(), "mds", "mirrorDataSrcVolume", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcVolumeId.getNumber(), "mdi", "mirrorDataSrcVolumeId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcClusterName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorDataGeneratorSrcClusterName.getNumber(), "mdc", "mirrorDataSrcCluster", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorId.getNumber(), "mid", "mirrorId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.nextMirrorId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.nextMirrorId.getNumber(), "nmid", "nextMirrorId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.nameContainerSize), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.nameContainerSize.getNumber(), "ncsmb", "nameContainerSizeMB", Long.class, CLDBProto.ListSortKey.VolumeNameContainerSize)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.nameContainerId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.nameContainerId.getNumber(), "ncid", "nameContainerId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.needsGfsck), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.needsGfsck.getNumber(), "nfsck", "needsGfsck", Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold.getNumber(), "miath", RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.maxnssizembalarmthreshold), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.maxnssizembalarmthreshold.getNumber(), "mnsszath", RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD, Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.dbReplLagSecAlarmThresh), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.dbReplLagSecAlarmThresh.getNumber(), "dlsat", RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.dbIndexLagSecAlarmThresh), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.dbIndexLagSecAlarmThresh.getNumber(), "dilsat", RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.partlyOutOfTopology), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.partlyOutOfTopology.getNumber(), "poot", "partlyOutOfTopology", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.isAuditVolume), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.isAuditVolume.getNumber(), "av", "auditVolume", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.audited), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.audited.getNumber(), "ea", "audited", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.forceAudit), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.forceAudit.getNumber(), "fa", "forceAudit", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.coalesceInterval), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.coalesceInterval.getNumber(), "ci", "coalesceInterval", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.fsAuditEnabledOperations), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.fsAuditEnabledOperations.getNumber(), "edao", "enableddataauditoperations", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.fsAuditDisabledOperations), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.fsAuditDisabledOperations.getNumber(), "ddao", "disableddataauditoperations", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numContainers), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numContainers.getNumber(), "nc", "numcontainers", Integer.class, CLDBProto.ListSortKey.VolumeContainerCount)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numMetaContainers), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numMetaContainers.getNumber(), "mc", "nummetacontainers", Integer.class, CLDBProto.ListSortKey.VolumeContainerCount)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.volumeAces), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.volumeAces.getNumber(), "vace", "volumeAces", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.mirrorThrottle), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.mirrorThrottle.getNumber(), "dt", RW_VOLUME_PARAM_MIRRORTHROTTLE, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.volumeAccessTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.volumeAccessTime.getNumber(), "va", "accesstime", Long.class, CLDBProto.ListSortKey.VolumeAccessTime)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.limitSpread), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.limitSpread.getNumber(), "ls", VOLUME_LIMIT_SPREAD, Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.namespaceContainerNumReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.namespaceContainerNumReplicas.getNumber(), "nsnr", "nsNumReplicas", Integer.class, CLDBProto.ListSortKey.VolumeNamespaceContainerNumReplicas)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.namespaceContainerMinReplicas), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.namespaceContainerMinReplicas.getNumber(), "nsmr", "nsMinReplicas", Integer.class, CLDBProto.ListSortKey.VolumeNamespaceContainerMinReplicas)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.enforceMinReplication), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.enforceMinReplication.getNumber(), "esmr", "enforceMinReplicationForIO", Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.allowGrant), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.allowGrant.getNumber(), "ag", "allowGrant", Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.reReplicationTimeOutSec), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.reReplicationTimeOutSec.getNumber(), "rto", "reReplTimeOutSec", Integer.class, CLDBProto.ListSortKey.VolumeReReplicationTimeOutSec)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.criticalReReplicationTimeOutSec), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.criticalReReplicationTimeOutSec.getNumber(), "crto", "criticalReReplTimeOutSec", Integer.class, CLDBProto.ListSortKey.VolumeCriticalReReplicationTimeOutSec)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.fixCreatorId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.fixCreatorId.getNumber(), "fcid", "fixCreatorId", Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.noteEntries), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.noteEntries.getNumber(), "vn", "volumeNote", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.isWorm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.isWorm.getNumber(), "iw", "isWorm", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.wormConfig), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.wormConfig.getNumber(), "worm", "wormSettings", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.commitMinutes), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.commitMinutes.getNumber(), "cm", "commitMinutes", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.retentionDays), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.retentionDays.getNumber(), "rd", "retentionDays", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.hasNotes), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.hasNotes.getNumber(), "hn", "hasNotes", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.unresolvedNotes), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.unresolvedNotes.getNumber(), "un", "unresolvedNotes", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.replTypeConversionInProgress), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.replTypeConversionInProgress.getNumber(), "rtip", "ReplTypeConversionInProgress", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.wireSecurityEnabled), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.wireSecurityEnabled.getNumber(), "ws", "wireSecurity", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.skipWireSecurityForTierInternalOps), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.skipWireSecurityForTierInternalOps.getNumber(), "swsfti", "skipWireSecuityForTierInternalOps", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.metricsEnabled), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.metricsEnabled.getNumber(), "me", "metricsEnabled", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tenantUser), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tenantUser.getNumber(), "tu", "tenantUser", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.createTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.createTime.getNumber(), "ct", "creationTime", Long.class, CLDBProto.ListSortKey.VolumeCreateTime)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.BecomeMasterStuckAlarm), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.BecomeMasterStuckAlarm.getNumber(), "bps", "BecomePrimaryStuckAlarm", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.containerAllocationFactor), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.containerAllocationFactor.getNumber(), "caf", "containerAllocationFactor", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.nameContainerDataThreshold), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.nameContainerDataThreshold.getNumber(), "ncdt", "nameContainerDataThresholdMB", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.dareEnabled), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.dareEnabled.getNumber(), "de", "dareEnabled", Integer.class, CLDBProto.ListSortKey.VolumeDareEnabled)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.isTierEnable), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.isTierEnable.getNumber(), "tenb", "tierenable", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.isTierEncryptionEnable), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.isTierEncryptionEnable.getNumber(), "tenc", RW_VOLUME_PARAM_TIER_ENCRYPTION, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierId.getNumber(), "tid", "tierid", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierRuleId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierRuleId.getNumber(), "rid", "tierruleid", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierScheduleId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierScheduleId.getNumber(), "tsid", "tieroffloadscheduleid", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.totalLocal), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.totalLocal.getNumber(), "tloc", "tierlocal", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.totalPurged), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.totalPurged.getNumber(), "tpur", "tierpurged", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.totalRecall), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.totalRecall.getNumber(), "trec", "tierrecall", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.ecScheme), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.ecScheme.getNumber(), "ecs", RW_VOLUME_PARAM_ECSCHEME, String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.ecBackendVolumeName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.ecBackendVolumeName.getNumber(), "ecstore", "ecstorevolume", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.ecTopology), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.ecTopology.getNumber(), "ectopo", RW_VOLUME_PARAM_ECTOPOLOGY, String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.ecLabel), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.ecLabel.getNumber(), "eclab", RW_VOLUME_PARAM_ECLABEL, String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierRecallExpiryTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierRecallExpiryTime.getNumber(), "ret", "tierrecallexpirytime", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.compactionScheduleId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.compactionScheduleId.getNumber(), "tcsid", "tiercompactionscheduleid", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.compactionOverhead), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.compactionOverhead.getNumber(), "tcovr", "tiercompactionoverheadthresh", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.ecStripeDepthMB), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.ecStripeDepthMB.getNumber(), EC_STRIPE_DEPTH_MB, EC_STRIPE_DEPTH_MB, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.ecContainerSizeMB), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.ecContainerSizeMB.getNumber(), "eccontrsize", EC_CONTAINER_SIZE_MB, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.autoOffloadThresholdGB), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.autoOffloadThresholdGB.getNumber(), "ecaotsize", AUTO_OFFLOAD_THRESHOLD_GB, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.replicatedLogicalUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.replicatedLogicalUsed.getNumber(), "replused", "replicatedlogicalused", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.replicatedTotalUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.replicatedTotalUsed.getNumber(), "replusedtotal", "replicatedtotalused", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.ecTotalUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.ecTotalUsed.getNumber(), "ecused", "ectotalused", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierJobType), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierJobType.getNumber(), "tjtype", "tierjobtype", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierJobState), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierJobState.getNumber(), "tjstatus", "tierjobstate", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierJobStartTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierJobStartTime.getNumber(), "tjstime", "tierjobstarttime", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierJobEndTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierJobEndTime.getNumber(), "tjetime", "tierjobendtime", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierJobTotalTierSizeMB), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierJobTotalTierSizeMB.getNumber(), "tjosize", "tierjobtotaloffloadsize", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierOffloadAvgThroughputMBPS), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierOffloadAvgThroughputMBPS.getNumber(), "tjospeed", "tierjoboffloadavgthroughputmbps", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierJobProgress), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierJobProgress.getNumber(), "tjprog", "tierjobprogress", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierRecallAvgThroughputMBPS), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierRecallAvgThroughputMBPS.getNumber(), "tjrspeed", "tierjobrecallavgthroughputmbps", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.cvTotalUsed), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.cvTotalUsed.getNumber(), "cvused", "cvtotalused", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.gatewayIps), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.gatewayIps.getNumber(), "gwips", "gateway", Long.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.backendVolumeType), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.backendVolumeType.getNumber(), "bet", "backendvolumetype", Integer.class, CLDBProto.ListSortKey.BackendVolumeType)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierType), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierType.getNumber(), "ttype", "tiertype", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.tierName), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.tierName.getNumber(), "tname", RW_VOLUME_PARAM_TIER_NAME, String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numActiveCgContainers), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numActiveCgContainers.getNumber(), "numactivecgcntrs", NUM_ACTIVE_CG_CONTAINERS, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.AtimeUpdateInterval), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.AtimeUpdateInterval.getNumber(), "atimeinterval", RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL, Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.allowReadForExecute), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.allowReadForExecute.getNumber(), "re", "allowReadForExecute", Integer.class, CLDBProto.ListSortKey.VolumeAllowReadForExecute)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.dataContainerLabel), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.dataContainerLabel.getNumber(), "l", DATA_LABEL, String.class, CLDBProto.ListSortKey.VolumeDataCntrLabel)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.nameContainerLabel), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.nameContainerLabel.getNumber(), "nsl", NAMESPACE_LABEL, String.class, CLDBProto.ListSortKey.VolumeNameCntrLabel)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.snapshotRestore), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.snapshotRestore.getNumber(), "sr", "snapshotRestore", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.atimeTrackingStartTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.atimeTrackingStartTime.getNumber(), "atst", "atimeTrackingStartTime", String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.filterList), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.filterList.getNumber(), "fl", FILTER_EXTENSION, String.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.expectedMirrorStartTime), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.expectedMirrorStartTime.getNumber(), "emst", "expectedMirrorStartTime", LocalDateTime.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.expectedMirrorStarted), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.expectedMirrorStarted.getNumber(), "ems", "expectedMirrorStarted", Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numEcDataColumns), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numEcDataColumns.getNumber(), "ecdc", "numEcDataColumns", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numEcParityColumns), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numEcParityColumns.getNumber(), "ecpc", "numEcParityColumns", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numEcLocalParityColumns), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numEcLocalParityColumns.getNumber(), "eclpc", "numEcLocalParityColumns", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.objectStoreAccountId), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.objectStoreAccountId.getNumber(), "s3aId", "objectStoreAccountId", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numFile), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numFile.getNumber(), "nf", "numFile", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numDir), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numDir.getNumber(), "nd", "numDir", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numFidMap), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numFidMap.getNumber(), "nfm", "numFidMap", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numTable), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numTable.getNumber(), "nt", "numTable", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.numS3Bucket), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.numS3Bucket.getNumber(), "ns3b", "numS3Bucket", Integer.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.objectStoreVolume), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.objectStoreVolume.getNumber(), "osv", "objectStoreVolumes", Boolean.class)).put((Object)new VolumeField(CLDBProto.VolumeInfoFields.honorRackReliability), (Object)new FieldInfo(CLDBProto.VolumeInfoFields.honorRackReliability.getNumber(), "honorrack", "honorRackReliability", Boolean.class));
        CLDBProto.VolumeInfoFields[] values = CLDBProto.VolumeInfoFields.values();
        int max = 0;
        CLDBProto.VolumeInfoFields[] volumeInfoFieldsArray = values;
        int n = volumeInfoFieldsArray.length;
        for (int i = 0; i < n; ++i) {
            CLDBProto.VolumeInfoFields value = volumeInfoFieldsArray[i];
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_VOLUMEFIELDINFO = max;
        baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
        aclParams = new ImmutableMap.Builder().put((Object)USERPERM_PARAM_NAME, (Object)new TextInputParameter(USERPERM_PARAM_NAME, "space separated list of user:permissions,perimssions,.. to be set", false, null)).put((Object)GROUPPERM_PARAM_NAME, (Object)new TextInputParameter(GROUPPERM_PARAM_NAME, "space separated list of user:permissions,perimssions,.. to be set", false, null)).build();
        volumeAuditCommand = new CLICommand("audit", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)VOLUME_AUDIT_ENABLED, (Object)new BooleanInputParameter(VOLUME_AUDIT_ENABLED, "<true|false>", false, null)).put((Object)VOLUME_FORCE_AUDIT_ENABLE, (Object)new BooleanInputParameter(VOLUME_FORCE_AUDIT_ENABLE, "<true|false>", false, null)).put((Object)AUDIT_COALESCE_INTERVAL, (Object)new IntegerInputParameter(AUDIT_COALESCE_INTERVAL, "interval in mins", false, null)).put((Object)FSAUDIT_OPS, (Object)new TextInputParameter(FSAUDIT_OPS, "data audit operations", false, null)).build(), null).setShortUsage(volumeAuditUsage);
        volumeUnMountCommand = new CLICommand("unmount", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, RW_VOLUME_PARAM_NAME, true, null)).put((Object)RW_VOLUME_PARAM_FORCE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_FORCE, RW_VOLUME_PARAM_FORCE, false, (Object)0)).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).build(), null).setShortUsage(volumeUnMountUsage);
        volumeShowMountsCommand = new CLICommand("showmounts", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, RW_VOLUME_PARAM_NAME, true, null)).build(), null).setShortUsage(volumeShowMountsUsage);
        volumeMountCommand = new CLICommand(RW_VOLUME_PARAM_MOUNT, "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, RW_VOLUME_PARAM_NAME, true, null)).put((Object)RW_VOLUME_PARAM_MOUNTDIR, (Object)new TextInputParameter(RW_VOLUME_PARAM_MOUNTDIR, RW_VOLUME_PARAM_MOUNTDIR, false, null)).put((Object)RW_VOLUME_PARAM_CREATE_PARENT, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_CREATE_PARENT, RW_VOLUME_PARAM_CREATE_PARENT, false, Boolean.valueOf(false))).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).build(), null).setShortUsage(volumeMountUsage);
        volumeCreateCommand = new CLICommand("create", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)RW_VOLUME_PARAM_MOUNTDIR, (Object)new TextInputParameter(RW_VOLUME_PARAM_MOUNTDIR, "mountdir", false, null)).put((Object)RW_VOLUME_PARAM_TENANT_USER, (Object)new TextInputParameter(RW_VOLUME_PARAM_TENANT_USER, "tenantUser", false, null)).put((Object)RW_VOLUME_PARAM_CREATE_PARENT, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_CREATE_PARENT, RW_VOLUME_PARAM_CREATE_PARENT, false, Boolean.valueOf(false))).put((Object)RW_VOLUME_PARAM_MOUNT, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_MOUNT, RW_VOLUME_PARAM_MOUNT, false, Boolean.valueOf(true))).put((Object)RW_VOLUME_ROOT_DIR_PERM, (Object)new TextInputParameter(RW_VOLUME_ROOT_DIR_PERM, RW_VOLUME_ROOT_DIR_PERM, false, null)).put((Object)RW_VOLUME_ROOT_DIR_USER, (Object)new TextInputParameter(RW_VOLUME_ROOT_DIR_USER, RW_VOLUME_ROOT_DIR_USER, false, null)).put((Object)RW_VOLUME_ROOT_DIR_GROUP, (Object)new TextInputParameter(RW_VOLUME_ROOT_DIR_GROUP, RW_VOLUME_ROOT_DIR_GROUP, false, null)).put((Object)RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, (Object)new IntegerInputParameter(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, false, null)).put((Object)RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, (Object)new IntegerInputParameter(RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, false, null)).put((Object)RW_VOLUME_PARAM_LOCALVOLUMEHOST, (Object)new TextInputParameter(RW_VOLUME_PARAM_LOCALVOLUMEHOST, RW_VOLUME_PARAM_LOCALVOLUMEHOST, false, null)).put((Object)RW_VOLUME_PARAM_LOCALVOLUMEPORT, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_LOCALVOLUMEPORT, RW_VOLUME_PARAM_LOCALVOLUMEPORT, false, null)).put((Object)RW_VOLUME_PARAM_SHUFFLEVOLUME, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_SHUFFLEVOLUME, RW_VOLUME_PARAM_SHUFFLEVOLUME, false, (Object)0).setInvisible(true)).put((Object)RW_VOLUME_PARAM_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_REPLICATION, RW_VOLUME_PARAM_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_MIN_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_MIN_REPLICATION, RW_VOLUME_PARAM_MIN_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_NAMESPACE_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_NAMESPACE_REPLICATION, RW_VOLUME_PARAM_NAMESPACE_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, false, null)).put((Object)RW_VOLUME_ENFORCE_MIN_REPLICATION, (Object)new BooleanInputParameter(RW_VOLUME_ENFORCE_MIN_REPLICATION, "stall io when replication falls below min replication, default:false", false, null)).put((Object)RW_VOLUME_PARAM_DCREPLTYPE, (Object)new TextInputParameter(RW_VOLUME_PARAM_DCREPLTYPE, "low_latency or high_throughput. default: high_throughput", false, null)).putAll(aclParams).put((Object)RW_VOLUME_PARAM_AETYPE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_AETYPE, "0(user) or 1(group) default: 0", false, null)).put((Object)RW_VOLUME_PARAM_AE, (Object)new TextInputParameter(RW_VOLUME_PARAM_AE, RW_VOLUME_PARAM_AE, false, null)).put((Object)RW_VOLUME_PARAM_QUOTA, (Object)new TextInputParameter(RW_VOLUME_PARAM_QUOTA, RW_VOLUME_PARAM_QUOTA, false, null)).put((Object)RW_VOLUME_PARAM_ADVISORY_QUOTA, (Object)new TextInputParameter(RW_VOLUME_PARAM_ADVISORY_QUOTA, RW_VOLUME_PARAM_ADVISORY_QUOTA, false, null)).put((Object)RW_VOLUME_PARAM_TOPOLOGY, (Object)new TextInputParameter(RW_VOLUME_PARAM_TOPOLOGY, RW_VOLUME_PARAM_TOPOLOGY, false, null)).put((Object)RW_VOLUME_PARAM_READONLY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_READONLY, RW_VOLUME_PARAM_READONLY, false, null)).put((Object)RW_VOLUME_PARAM_MIRRORTHROTTLE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_MIRRORTHROTTLE, RW_VOLUME_PARAM_MIRRORTHROTTLE, false, null)).put((Object)MIRROR_VOLUME, (Object)new TextInputParameter(MIRROR_VOLUME, "type of volume: rw or mirror", false, null)).put((Object)MIRROR_VOLUME_SRC_VOLUMENAME, (Object)new TextInputParameter(MIRROR_VOLUME_SRC_VOLUMENAME, MIRROR_VOLUME_SRC_VOLUMENAME, false, null)).put((Object)VOLUME_SCHEDULE, (Object)new IntegerInputParameter(VOLUME_SCHEDULE, "schedule ID", false, null)).put((Object)VOLUME_MIRROR_SCHEDULE, (Object)new IntegerInputParameter(VOLUME_MIRROR_SCHEDULE, "mirror schedule ID", false, null)).put((Object)VOLUME_LIMIT_SPREAD, (Object)new BooleanInputParameter(VOLUME_LIMIT_SPREAD, VOLUME_LIMIT_SPREAD, false, null).setInvisible(true)).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).put((Object)RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, (Object)new LongInputParameter(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, false, null)).put((Object)RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD, (Object)new LongInputParameter(RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD, RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD, false, null)).put((Object)RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, false, null)).put((Object)RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH, RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH, false, null)).put((Object)AUDIT_ENABLED, (Object)new BooleanInputParameter(AUDIT_ENABLED, "<true|false>", false, null)).put((Object)FORCE_AUDIT_ENABLE, (Object)new BooleanInputParameter(FORCE_AUDIT_ENABLE, "<true|false>", false, null)).put((Object)AUDIT_COALESCE_INTERVAL, (Object)new IntegerInputParameter(AUDIT_COALESCE_INTERVAL, "interval in mins", false, null)).put((Object)AUDIT_VOLUME, (Object)new BooleanInputParameter(AUDIT_VOLUME, AUDIT_VOLUME, false, null).setInvisible(true)).put((Object)FSAUDIT_OPS, (Object)new TextInputParameter(FSAUDIT_OPS, "data audit operations", false, null)).put((Object)WIRE_SECURITY_ENABLED, (Object)new BooleanInputParameter(WIRE_SECURITY_ENABLED, "<true|false>", false, null)).put((Object)SKIP_WIRE_SECURITY_FOR_INTERNAL_OP, (Object)new BooleanInputParameter(SKIP_WIRE_SECURITY_FOR_INTERNAL_OP, "Skip Wire level security for backend volumes <true|false>", false, null)).put((Object)ALLOW_GRANT, (Object)new BooleanInputParameter(ALLOW_GRANT, ALLOW_GRANT, false, null)).put((Object)INHERIT_SOURCE, (Object)new TextInputParameter(INHERIT_SOURCE, "volume to copy properties from: defaults to parent volume", false, null)).put((Object)ALLOW_INHERIT, (Object)new BooleanInputParameter(ALLOW_INHERIT, ALLOW_INHERIT, false, null)).put((Object)SKIP_INHERIT, (Object)new TextInputParameter(SKIP_INHERIT, "volume properties not to inherit", false, null)).put((Object)VOL_READACE_PARAM, (Object)new TextInputParameter(VOL_READACE_PARAM, "<Acess Control Expression>", false, null)).put((Object)VOL_WRITEACE_PARAM, (Object)new TextInputParameter(VOL_WRITEACE_PARAM, "<Acess Control Expression>", false, null)).put((Object)METRICS_ENABLED, (Object)new BooleanInputParameter(METRICS_ENABLED, "<true|false>", false, null)).put((Object)RW_VOLUME_PARAM_CONTAINER_ALLOCATION_FACTOR, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_CONTAINER_ALLOCATION_FACTOR, "<+ve integer, default:0>", false, null)).put((Object)NAME_CONTAINER_DATA_THRESHOLD, (Object)new LongInputParameter(NAME_CONTAINER_DATA_THRESHOLD, "name container data size in MB", false, null)).put((Object)DARE_ENABLED, (Object)new BooleanInputParameter(DARE_ENABLED, "Enable Data at rest encryption for volume. <true|false>", false, null)).put((Object)RW_VOLUME_PARAM_TIERING, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_TIERING, "<true|false>", false, null)).put((Object)RW_VOLUME_PARAM_AUTO_CREATE_EC_TIER, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_AUTO_CREATE_EC_TIER, "<true|false>", false, null)).put((Object)RW_VOLUME_PARAM_TIER_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_TIER_NAME, "tier name", false, null)).put((Object)RW_VOLUME_PARAM_TIERING_RULE, (Object)new TextInputParameter(RW_VOLUME_PARAM_TIERING_RULE, "tiering rule", false, null)).put((Object)RW_VOLUME_PARAM_OFFLOAD_SCHEDULEID, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_OFFLOAD_SCHEDULEID, "tiering schedule ID", false, null)).put((Object)RW_VOLUME_PARAM_TIER_KEY, (Object)new TextInputParameter(RW_VOLUME_PARAM_TIER_KEY, "tier encryption key", false, null)).put((Object)RW_VOLUME_PARAM_TIER_ENCRYPTION, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_TIER_ENCRYPTION, "<true|false>", false, null)).put((Object)RW_VOLUME_PARAM_RECALL_EXPIRY_TIME, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_RECALL_EXPIRY_TIME, "recallExpiryTime in days", false, null, new Integer(1), Integer.valueOf(7500))).put((Object)RW_VOLUME_PARAM_ECSCHEME, (Object)new TextInputParameter(RW_VOLUME_PARAM_ECSCHEME, "ec scheme", false, null)).put((Object)RW_VOLUME_PARAM_ECTOPOLOGY, (Object)new TextInputParameter(RW_VOLUME_PARAM_ECTOPOLOGY, "ec volume topology", false, null)).put((Object)RW_VOLUME_PARAM_HONORRACKRELIABILITY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_HONORRACKRELIABILITY, "ec rack reliability", false, null)).put((Object)RW_VOLUME_PARAM_ECLABEL, (Object)new TextInputParameter(RW_VOLUME_PARAM_ECLABEL, "ec volume label", false, null)).put((Object)EC_STRIPE_DEPTH_MB, (Object)new IntegerInputParameter(EC_STRIPE_DEPTH_MB, "<stripe depth in MB, multiple of 4, min:4, max:256>", false, null).setInvisible(true)).put((Object)EC_CONTAINER_SIZE_MB, (Object)new IntegerInputParameter(EC_CONTAINER_SIZE_MB, "<containers size in MB, min:256, max:64*1024>", false, null).setInvisible(true)).put((Object)AUTO_OFFLOAD_THRESHOLD_GB, (Object)new IntegerInputParameter(AUTO_OFFLOAD_THRESHOLD_GB, "<ec auto offload size threshold in GB>", false, null)).put((Object)RW_VOLUME_PARAM_COMPACTION_SCHEDULEID, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_COMPACTION_SCHEDULEID, "compaction schedule Id", false, null)).put((Object)RW_VOLUME_PARAM_COMPACTION_OVERHEAD, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_COMPACTION_OVERHEAD, "compaction overhead", false, null)).put((Object)NUM_ACTIVE_CG_CONTAINERS, (Object)new IntegerInputParameter(NUM_ACTIVE_CG_CONTAINERS, "<num active cg containers>", false, null)).put((Object)DATA_LABEL, (Object)new TextInputParameter(DATA_LABEL, "<data label>", false, null)).put((Object)NAMESPACE_LABEL, (Object)new TextInputParameter(NAMESPACE_LABEL, "<name cntr label>", false, null)).put((Object)RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL, (Object)new TextInputParameter(RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL, "<atime update interval in days, default: 0>", false, null)).put((Object)ALLOW_READ_FOR_EXECUTE, (Object)new BooleanInputParameter(ALLOW_READ_FOR_EXECUTE, "Enable reads for files with execute permission. <true|false>", false, null)).put((Object)PBS_SECURITY_POLICY, (Object)new TextInputParameter(PBS_SECURITY_POLICY, "comma separated security policies", false, null)).put((Object)ROOT_DIR_SECURITY_POLICY, (Object)new TextInputParameter(ROOT_DIR_SECURITY_POLICY, "comma separated security policies", false, null)).put((Object)PBS_ENFORCEMENT_MODE, (Object)new TextInputParameter(PBS_ENFORCEMENT_MODE, "<PolicyAceAndDataAce|PolicyAceOnly|DataAceOnly|PolicyAceAuditAndDataAce>", false, null)).put((Object)FILTER_EXTENSION, (Object)new TextInputParameter(FILTER_EXTENSION, "<file filter>", false, null)).put((Object)Allow_S3_BUCKETS, (Object)new BooleanInputParameter(Allow_S3_BUCKETS, "Enable volume for bucket create. <true|false>", false, null)).put((Object)Allow_S3_WORM_BUCKETS, (Object)new BooleanInputParameter(Allow_S3_WORM_BUCKETS, "Enable volume for worm bucket create. <true|false>", false, null)).put((Object)OBJ_STORE_ACCOUNT_ID, (Object)new IntegerInputParameter(OBJ_STORE_ACCOUNT_ID, "accountId of objectStore account", false, null).setInvisible(true)).put((Object)S3_ACCOUNTS_ROOT, (Object)new BooleanInputParameter(S3_ACCOUNTS_ROOT, "root volume of account", false, null).setInvisible(true)).build(), null).setShortUsage(volumeCreateUsage);
        nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.ListSortKey key : CLDBProto.ListSortKey.values()) {
            if (!key.name().startsWith("Volume")) continue;
            nameToEnumMap.put(key.name().toLowerCase(), key);
            if (sb.length() == 0) {
                sb.append(key.name().toLowerCase());
                continue;
            }
            sb.append("|" + key.name().toLowerCase());
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        for (FieldInfo fInfo : fieldTableBuilder.build().values()) {
            CLDBProto.ListSortKey sKey = fInfo.getListSortKey();
            if (sKey == null) continue;
            nameToEnumMap.put(fInfo.getShortName().toLowerCase(), sKey);
            nameToEnumMap.put(fInfo.getLongName().toLowerCase(), sKey);
        }
        volumeCommands = new CLICommand[]{new CLICommand("remove", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", false, null)).put((Object)RW_VOLUME_PARAM_FORCE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_FORCE, RW_VOLUME_PARAM_FORCE, false, (Object)0)).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).put((Object)FILTER_PARAM_NAME, (Object)new FilterInputParameter(FILTER_PARAM_NAME, "remove volumes that match the filter", false, "none")).put((Object)RW_VOLUME_PARAM_S3_DELETE_BUCKET, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_S3_DELETE_BUCKET, RW_VOLUME_PARAM_S3_DELETE_BUCKET, false, (Object)0).setInvisible(true)).build(), null).setShortUsage(volumeRemoveUsage), new CLICommand("move", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName>", true, null)).put((Object)RW_VOLUME_PARAM_TOPOLOGY, (Object)new TextInputParameter(RW_VOLUME_PARAM_TOPOLOGY, RW_VOLUME_PARAM_TOPOLOGY, false, null)).put((Object)RW_VOLUME_PARAM_ECTOPOLOGY, (Object)new TextInputParameter(RW_VOLUME_PARAM_ECTOPOLOGY, "topology for ec-store volume", false, null)).put((Object)RW_VOLUME_PARAM_ECLABEL, (Object)new TextInputParameter(RW_VOLUME_PARAM_ECLABEL, "new label for ec-store volume", false, null)).put((Object)DATA_LABEL, (Object)new TextInputParameter(DATA_LABEL, "new label for volume data", false, null)).put((Object)NAMESPACE_LABEL, (Object)new TextInputParameter(NAMESPACE_LABEL, "new label for volume name container", false, null)).build(), null).setShortUsage(volumeMoveUsage), new CLICommand("rename", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)RW_VOLUME_PARAM_NEW_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NEW_NAME, "newVolumeName", true, null)).put((Object)RW_VOLUME_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_OP_NODELAY, RW_VOLUME_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).build(), null).setShortUsage(volumeRenameUsage), new CLICommand("upgradeformat", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeNames", true, null)).build(), null).setShortUsage(volumeUpgradeformatUsage), new CLICommand("cleardare", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALL_VOLUMES_PARAM_NAME, (Object)new NoValueInputParameter(ALL_VOLUMES_PARAM_NAME, "clear dare for all volumes", true, false)).build(), null).setUsageInVisible(true).setShortUsage(clearDareUsage), new CLICommand("modify", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).put((Object)MIRROR_VOLUME_SRC_VOLUMENAME, (Object)new TextInputParameter(MIRROR_VOLUME_SRC_VOLUMENAME, MIRROR_VOLUME_SRC_VOLUMENAME, false, null)).put((Object)RW_VOLUME_PARAM_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_REPLICATION, RW_VOLUME_PARAM_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_MIN_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_MIN_REPLICATION, RW_VOLUME_PARAM_MIN_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_NAMESPACE_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_NAMESPACE_REPLICATION, RW_VOLUME_PARAM_NAMESPACE_REPLICATION, false, null)).put((Object)RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, RW_VOLUME_PARAM_NAMESPACE_MIN_REPLICATION, false, null)).put((Object)RW_VOLUME_ENFORCE_MIN_REPLICATION, (Object)new BooleanInputParameter(RW_VOLUME_ENFORCE_MIN_REPLICATION, "enforceminreplicationforio: stall io when replication falls below min replication, default:false", false, null)).put((Object)RW_VOLUME_PARAM_CONTAINER_ALLOCATION_FACTOR, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_CONTAINER_ALLOCATION_FACTOR, "<+ve integer, default:0>", false, null)).putAll(aclParams).put((Object)RW_VOLUME_PARAM_AETYPE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_AETYPE, RW_VOLUME_PARAM_AETYPE, false, null)).put((Object)RW_VOLUME_PARAM_AE, (Object)new TextInputParameter(RW_VOLUME_PARAM_AE, RW_VOLUME_PARAM_AE, false, null)).put((Object)RW_VOLUME_PARAM_QUOTA, (Object)new TextInputParameter(RW_VOLUME_PARAM_QUOTA, RW_VOLUME_PARAM_QUOTA, false, null)).put((Object)RW_VOLUME_PARAM_ADVISORY_QUOTA, (Object)new TextInputParameter(RW_VOLUME_PARAM_ADVISORY_QUOTA, RW_VOLUME_PARAM_ADVISORY_QUOTA, false, null)).put((Object)RW_VOLUME_PARAM_READONLY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_READONLY, RW_VOLUME_PARAM_READONLY, false, null)).put((Object)RW_VOLUME_PARAM_MIRRORTHROTTLE, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_MIRRORTHROTTLE, RW_VOLUME_PARAM_MIRRORTHROTTLE, false, null)).put((Object)VOLUME_SCHEDULE, (Object)new IntegerInputParameter(VOLUME_SCHEDULE, "schedule ID", false, null)).put((Object)VOLUME_MIRROR_SCHEDULE, (Object)new IntegerInputParameter(VOLUME_MIRROR_SCHEDULE, "mirror schedule ID", false, null)).put((Object)RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, (Object)new LongInputParameter(RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, RW_VOLUME_PARAM_MAXINODES_ALARM_THRESHOLD, false, null)).put((Object)RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD, (Object)new LongInputParameter(RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD, RW_VOLUME_PARAM_MAXNSSIZEMB_ALARM_THRESHOLD, false, null)).put((Object)RW_VOLUME_PARAM_DCREPLTYPE, (Object)new TextInputParameter(RW_VOLUME_PARAM_DCREPLTYPE, "<low_latency | high_throughput>", false, null).setInvisible(true)).put((Object)RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, RW_VOLUME_PARAM_DBREPL_LAG_SEC_ALARM_THRESH, false, null)).put((Object)RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH, RW_VOLUME_PARAM_DBINDEX_LAG_SEC_ALARM_THRESH, false, null)).put((Object)MIRROR_VOLUME, (Object)new TextInputParameter(MIRROR_VOLUME, "type of volume: rw or mirror", false, null)).put((Object)VOLUME_LIMIT_SPREAD, (Object)new BooleanInputParameter(VOLUME_LIMIT_SPREAD, VOLUME_LIMIT_SPREAD, false, null).setInvisible(true)).put((Object)AUDIT_ENABLED, (Object)new BooleanInputParameter(AUDIT_ENABLED, "<true|false>", false, null)).put((Object)FORCE_AUDIT_ENABLE, (Object)new BooleanInputParameter(FORCE_AUDIT_ENABLE, "<true|false>", false, null)).put((Object)AUDIT_COALESCE_INTERVAL, (Object)new IntegerInputParameter(AUDIT_COALESCE_INTERVAL, "interval in mins", false, null)).put((Object)FSAUDIT_OPS, (Object)new TextInputParameter(FSAUDIT_OPS, "data audit operations", false, null)).put((Object)DISABLE_DATA_AUDIT_OPS_PARAM, (Object)new TextInputParameter(DISABLE_DATA_AUDIT_OPS_PARAM, "disable data audit operations", false, null)).put((Object)WIRE_SECURITY_ENABLED, (Object)new BooleanInputParameter(WIRE_SECURITY_ENABLED, "<true|false>", false, null)).put((Object)SKIP_WIRE_SECURITY_FOR_INTERNAL_OP, (Object)new BooleanInputParameter(SKIP_WIRE_SECURITY_FOR_INTERNAL_OP, "Skip Wire level security for backend volumes <true|false>", false, null)).put((Object)ALLOW_GRANT, (Object)new BooleanInputParameter(ALLOW_GRANT, "let child volume inherit volume properties <true|false>", false, null)).put((Object)RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, (Object)new IntegerInputParameter(RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, RW_VOLUME_RE_REPLICATION_TIMEOUT_SEC, false, null)).put((Object)RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, (Object)new IntegerInputParameter(RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, RW_VOLUME_CRITICAL_RE_REPLICATION_TIMEOUT_SEC, false, null)).put((Object)RW_FIX_CREATOR_ID, (Object)new BooleanInputParameter(RW_FIX_CREATOR_ID, RW_FIX_CREATOR_ID, false, null).setInvisible(true)).put((Object)VOL_READACE_PARAM, (Object)new TextInputParameter(VOL_READACE_PARAM, "<Acess Control Expression>", false, null)).put((Object)VOL_WRITEACE_PARAM, (Object)new TextInputParameter(VOL_WRITEACE_PARAM, "<Acess Control Expression>", false, null)).put((Object)METRICS_ENABLED, (Object)new BooleanInputParameter(METRICS_ENABLED, "<true|false>", false, null)).put((Object)NAME_CONTAINER_DATA_THRESHOLD, (Object)new LongInputParameter(NAME_CONTAINER_DATA_THRESHOLD, "name container data size in MB", false, null)).put((Object)RW_VOLUME_PARAM_TIER_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_TIER_NAME, "tier name", false, null)).put((Object)RW_VOLUME_PARAM_AUTO_CREATE_EC_TIER, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_AUTO_CREATE_EC_TIER, "<true|false>", false, null)).put((Object)RW_VOLUME_PARAM_TIERING_RULE, (Object)new TextInputParameter(RW_VOLUME_PARAM_TIERING_RULE, "tiering rule", false, null)).put((Object)RW_VOLUME_PARAM_OFFLOAD_SCHEDULEID, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_OFFLOAD_SCHEDULEID, "tiering schedule ID", false, null)).put((Object)RW_VOLUME_PARAM_TIER_KEY, (Object)new TextInputParameter(RW_VOLUME_PARAM_TIER_KEY, "tier encryption key", false, null)).put((Object)RW_VOLUME_PARAM_TIER_ENCRYPTION, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_TIER_ENCRYPTION, "<true|false>", false, null)).put((Object)RW_VOLUME_PARAM_RECALL_EXPIRY_TIME, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_RECALL_EXPIRY_TIME, "recallExpiryTime in days", false, null, new Integer(1), Integer.valueOf(7500))).put((Object)RW_VOLUME_PARAM_COMPACTION_SCHEDULEID, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_COMPACTION_SCHEDULEID, "compaction schedule Id", false, null)).put((Object)RW_VOLUME_PARAM_COMPACTION_OVERHEAD, (Object)new IntegerInputParameter(RW_VOLUME_PARAM_COMPACTION_OVERHEAD, "compaction overhead", false, null)).put((Object)RW_VOLUME_PARAM_ECSCHEME, (Object)new TextInputParameter(RW_VOLUME_PARAM_ECSCHEME, "ec scheme", false, null)).put((Object)RW_VOLUME_PARAM_ECTOPOLOGY, (Object)new TextInputParameter(RW_VOLUME_PARAM_ECTOPOLOGY, "ec volume topology", false, null)).put((Object)RW_VOLUME_PARAM_HONORRACKRELIABILITY, (Object)new BooleanInputParameter(RW_VOLUME_PARAM_HONORRACKRELIABILITY, "ec rack reliability", false, null)).put((Object)AUTO_OFFLOAD_THRESHOLD_GB, (Object)new IntegerInputParameter(AUTO_OFFLOAD_THRESHOLD_GB, "<ec auto offload size threshold in GB>", false, null)).put((Object)NUM_ACTIVE_CG_CONTAINERS, (Object)new IntegerInputParameter(NUM_ACTIVE_CG_CONTAINERS, "<num containers to be assigned for a cg assign request>", false, null)).put((Object)RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL, (Object)new TextInputParameter(RW_VOLUME_PARAM_ATIME_UPDATE_INTERVAL, "<atime update interval in days, default: 0>", false, null)).put((Object)ALLOW_READ_FOR_EXECUTE, (Object)new BooleanInputParameter(ALLOW_READ_FOR_EXECUTE, "Enable reads for files with execute permission. <true|false>", false, null)).put((Object)PBS_SECURITY_POLICY, (Object)new TextInputParameter(PBS_SECURITY_POLICY, "comma separated security policies", false, null)).put((Object)PBS_ENFORCEMENT_MODE, (Object)new TextInputParameter(PBS_ENFORCEMENT_MODE, "<PolicyAceAndDataAce|PolicyAceOnly|DataAceOnly|PolicyAceAuditAndDataAce>", false, null)).put((Object)FILTER_EXTENSION, (Object)new TextInputParameter(FILTER_EXTENSION, "<file filter>", false, null)).put((Object)OBJ_STORE_ACCOUNT_ID, (Object)new IntegerInputParameter(OBJ_STORE_ACCOUNT_ID, "accountId of objectStore account", false, null).setInvisible(true)).build(), null).setShortUsage(volumeModifyUsage), new CLICommand("info", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).put((Object)RW_VOLUME_PARAM_MOUNTDIR, (Object)new TextInputParameter(RW_VOLUME_PARAM_MOUNTDIR, "mountdir", false, null)).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", false, null)).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "comma separated list of column names", false, "all")).build(), null).setShortUsage(volumeInfoUsage), new CLICommand("list", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SORT_PARAM_NAME, (Object)new TextInputParameter(SORT_PARAM_NAME, "none", false, "volumename").setInvisible(true)).put((Object)SORT_DIRECTION_PARAM_NAME, (Object)new TextInputParameter(SORT_DIRECTION_PARAM_NAME, "none", false, "ASC").setInvisible(true)).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)FILTER_PARAM_NAME, (Object)new FilterInputParameter(FILTER_PARAM_NAME, "none", false, "none")).put((Object)RW_VOLUME_NODES, (Object)new TextInputParameter(RW_VOLUME_NODES, RW_VOLUME_NODES, false, null)).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "comma separated list of column names", false, "all")).put((Object)ALARMEDVOLUMES_PARAM_NAME, (Object)new BooleanInputParameter(ALARMEDVOLUMES_PARAM_NAME, "alarmsonly", false, (Object)0)).put((Object)SORTBY_PARAM_NAME, (Object)new TextInputParameter(SORTBY_PARAM_NAME, supportedSortKeys + ", column names of supported fields.", false, null)).put((Object)SORTING_ORDER_PARAM_NAME, (Object)new TextInputParameter(SORTING_ORDER_PARAM_NAME, "<asc|desc>", false, null)).build(), null).setShortUsage(volumeListUsage), new CLICommand("fixmountpath", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).build(), null).setShortUsage(volumeFixMntPathUsage), VolumeLinkCommands.VolumeLinkCommands, SnapshotCommands.snapshotCommands, VolumeMirrorCommands.mirrorCommands, VolumeDumpFileCommands.dumpCommands, VolumeContainerCommands.containerCommands, new CLICommand("balancecontainers", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, VolumeCommands.getBalanceContainersCmdMap(), null).setShortUsage(volumeBalanceUsage), new CLICommand("balancinginfo", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, VolumeCommands.getBalancingInfoCmdMap(), null).setShortUsage(volumeBalancingInfoUsage), new CLICommand("fixpromotedvolume", "", VolumeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RW_VOLUME_PARAM_NAME, (Object)new TextInputParameter(RW_VOLUME_PARAM_NAME, "volumeName", true, null)).build(), null).setShortUsage(volumeFixPromotedVolume)};
    }

    private static enum WeekDays {
        mon(1, "MONDAY"),
        tue(2, "TUESDAY"),
        wed(3, "WEDNESDAY"),
        thu(4, "THURSDAY"),
        fri(5, "FRIDAY"),
        sat(6, "SATURDAY"),
        sun(7, "SUNDAY");

        private int dayOfTheWeek;
        private String dayDesc;

        private WeekDays(int dayOfTheWeek, String dayDesc) {
            this.dayOfTheWeek = dayOfTheWeek;
            this.dayDesc = dayDesc;
        }

        public int getDayOfTheWeek() {
            return this.dayOfTheWeek;
        }

        public String getDayDesc() {
            return this.dayDesc;
        }
    }

    class VolumeAclHelper {
        Integer bitPos;
        Integer bitMask;
        int fieldPos;
        CLDBProto.VolumeInfoFields fieldNum;

        VolumeAclHelper(int bitPos, CLDBProto.VolumeInfoFields fieldNum) {
            this.bitPos = new Integer(bitPos);
            this.fieldPos = fieldNum.getNumber();
            this.fieldNum = fieldNum;
        }

        Integer getBitPos() {
            return this.bitPos;
        }

        int getFieldPos() {
            return this.fieldPos;
        }

        CLDBProto.VolumeInfoFields getFieldNum() {
            return this.fieldNum;
        }
    }
}

