/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.mapr.cli.MapRCLIRegistry;
import com.mapr.cli.RemoveNodeTest;
import com.mapr.cli.ZookeeperServerSetup;
import com.mapr.cli.common.NodesCommonUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GetAllServicesTest {
    private static ZooKeeper s_zk;
    private static String zookeeperAddresses;
    private static final Logger LOG;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ZookeeperServerSetup.setUpZKServer();
        zookeeperAddresses = "localhost:6181";
        try {
            s_zk = new ZooKeeper(zookeeperAddresses, 30000, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        ZookeeperServerSetup.tearDownZKServer();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void getAllServicesNodesTest() throws Exception {
        s_zk.create("/services", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        s_zk.create("/services/tasktracker", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        s_zk.create("/services/jobtracker", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        s_zk.create("/services/nfs", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        s_zk.create("/services/cldb", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        s_zk.create("/services/tasktracker/10.10.10.11", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        s_zk.create("/services/tasktracker/10.10.10.12", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        s_zk.create("/services/tasktracker/10.10.10.13", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        s_zk.create("/services/tasktracker/10.10.10.14", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        s_zk.create("/services/jobtracker/10.10.10.11", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        s_zk.create("/services/jobtracker/10.10.10.12", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        s_zk.create("/services/cldb/10.10.10.13", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        s_zk.create("/services/cldb/10.10.10.14", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        s_zk.create("/services/nfs/10.10.10.12", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        s_zk.create("/services/nfs/10.10.10.13", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Map runningServices = NodesCommonUtils.findServicesRunningHierarchy((String)zookeeperAddresses);
        Assert.assertEquals((long)4L, (long)runningServices.size());
    }

    static {
        LOG = Logger.getLogger(RemoveNodeTest.class);
        MapRCLIRegistry.getInstance().register();
    }
}

