/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BitSetBytesHelperUtils;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.ServerCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.NodeField;
import com.mapr.cli.common.PluggableAlarmUtil;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class Heatmap
extends ListCommand
implements CLIInterface {
    public static final String VIEW_PARAM_NAME = "view";
    public static final String FILTER_PARAM_NAME = "filter";
    private static final int MAX_LIMIT = Integer.MAX_VALUE;
    private static final Logger LOG = Logger.getLogger(Heatmap.class);
    public static final CLICommand heatmapCmds = new CLICommand("heatmap", "", Heatmap.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"view", (Object)new TextInputParameter("view", "view [status|cpu|memory|diskspace|NODE_ALARM_SERVICE_CLDB_DOWN|NODE_ALARM_SERVICE_FILESERVER_DOWN|NODE_ALARM_SERVICE_JT_DOWN|NODE_ALARM_SERVICE_TT_DOWN|NODE_ALARM_SERVICE_HBMASTER_DOWN|NODE_ALARM_SERVICE_HBREGION_DOWN|NODE_ALARM_SERVICE_NFS_DOWN|NODE_ALARM_SERVICE_NFS4_DOWN|NODE_ALARM_SERVICE_WEBSERVER_DOWN|NODE_ALARM_SERVICE_HOSTSTATS_DOWN|NODE_ALARM_DEBUG_LOGGING|NODE_ALARM_DISK_FAILURE|NODE_ALARM_VERSION_MISMATCH|NODE_ALARM_TIME_SKEW|NODE_ALARM_ROOT_PARTITION_FULL|NODE_ALARM_OPT_MAPR_FULL|NODE_ALARM_CORE_PRESENT|NODE_ALARM_HIGH_MFS_MEMORY|NODE_ALARM_PAM_MISCONFIGURED|NODE_ALARM_TT_LOCALDIR_FULL|NODE_ALARM_NO_HEARTBEAT|NODE_ALARM_MAPRUSER_MISMATCH|NODE_ALARM_DUPLICATE_HOSTID|NODE_ALARM_METRICS_WRITE_PROBLEM|NODE_ALARM_TOO_MANY_CONTAINERS|NODE_ALARM_SERVICE_HUE_DOWN|NODE_ALARM_SERVICE_HTTPFS_DOWN|NODE_ALARM_SERVICE_BEESWAX_DOWN|NODE_ALARM_SERVICE_HIVEMETA_DOWN|NODE_ALARM_SERVICE_HS2_DOWN|NODE_ALARM_SERVICE_OOZIE_DOWN]", false, "status")).put((Object)"filter", (Object)new FilterInputParameter("filter", "none", false, "none")).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setShortUsage("heatmap -view [status|cpu|memory|diskspace|NODE_ALARM_SERVICE_CLDB_DOWN|NODE_ALARM_SERVICE_FILESERVER_DOWN|NODE_ALARM_SERVICE_JT_DOWN|NODE_ALARM_SERVICE_TT_DOWN|NODE_ALARM_SERVICE_HBMASTER_DOWN|NODE_ALARM_SERVICE_HBREGION_DOWN|NODE_ALARM_SERVICE_NFS_DOWN|NODE_ALARM_SERVICE_NFS4_DOWN|NODE_ALARM_SERVICE_WEBSERVER_DOWN|NODE_ALARM_SERVICE_HOSTSTATS_DOWN|NODE_ALARM_DEBUG_LOGGING|NODE_ALARM_DISK_FAILURE|NODE_ALARM_VERSION_MISMATCH|NODE_ALARM_TIME_SKEW|NODE_ALARM_ROOT_PARTITION_FULL|NODE_ALARM_OPT_MAPR_FULL|NODE_ALARM_CORE_PRESENT|NODE_ALARM_HIGH_MFS_MEMORY|NODE_ALARM_PAM_MISCONFIGURED|NODE_ALARM_TT_LOCALDIR_FULL|NODE_ALARM_NO_HEARTBEAT|NODE_ALARM_MAPRUSER_MISMATCH|NODE_ALARM_DUPLICATE_HOSTID|NODE_ALARM_METRICS_WRITE_PROBLEM|NODE_ALARM_TOO_MANY_CONTAINERS|NODE_ALARM_SERVICE_HUE_DOWN|NODE_ALARM_SERVICE_HTTPFS_DOWN|NODE_ALARM_SERVICE_BEESWAX_DOWN|NODE_ALARM_SERVICE_HIVEMETA_DOWN|NODE_ALARM_SERVICE_HS2_DOWN|NODE_ALARM_SERVICE_OOZIE_DOWN]");

    public Heatmap(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        CommandOutput.OutputHierarchy.OutputNode topNode = new CommandOutput.OutputHierarchy.OutputNode();
        out.addNode(topNode);
        ServerCommands.fieldTable = PluggableAlarmUtil.appendNodeMap(this.getUserCredentials(), ServerCommands.fieldTableBuilder);
        this.list(out);
        return output;
    }

    public CLDBProto.FileServerListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.FileServerListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.FileServerListRequest.newBuilder((CLDBProto.FileServerListRequest)((CLDBProto.FileServerListRequest)prevReq)) : this.getFileServerListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.FileServerListResponse)prevResp).getInfoCount();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, 0, Integer.MAX_VALUE, 100));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(0, Integer.MAX_VALUE, ((CLDBProto.FileServerListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.FileServerListResponse)prevResp).getInfoCount());
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.FileServerListResponse resp = (CLDBProto.FileServerListResponse)response;
        if (resp.getStatus() != 0) {
            LOG.error((Object)"RPC to view Heatmap failed");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            return;
        }
        TreeMap fileServerMap = new TreeMap();
        for (CLDBProto.FileServerInfo fs : resp.getInfoList()) {
            String rp;
            if (!fs.hasNetworkLocation() || (rp = fs.getNetworkLocation()).isEmpty()) continue;
            if (!fileServerMap.containsKey(rp = rp.substring(0, rp.lastIndexOf("/")))) {
                fileServerMap.put(rp, new ArrayList());
            }
            ((List)fileServerMap.get(rp)).add(fs);
        }
        CommandOutput.OutputHierarchy.OutputNode topNode = (CommandOutput.OutputHierarchy.OutputNode)out.getOutputNodes().get(0);
        if (!fileServerMap.isEmpty()) {
            for (Map.Entry fsInfoEntry : fileServerMap.entrySet()) {
                CommandOutput.OutputHierarchy.OutputNode rackNode = this.getChildNode(topNode, (String)fsInfoEntry.getKey());
                if (rackNode == null) {
                    rackNode = new CommandOutput.OutputHierarchy.OutputNode((String)fsInfoEntry.getKey());
                    topNode.addChild(rackNode);
                }
                for (CLDBProto.FileServerInfo fs : (List)fsInfoEntry.getValue()) {
                    int status = ServerCommands.formatNodeState(fs.getNodeState());
                    boolean hbStats = fs.hasHbStats();
                    switch (this.getView()) {
                        case VIEW_STATUS: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), status));
                            break;
                        }
                        case VIEW_CPU: {
                            int cpuUtil = !hbStats ? -1 : 100 - (int)fs.getHbStats().getCpuIdle();
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), cpuUtil));
                            break;
                        }
                        case VIEW_MEMORY: {
                            double memUtil = !hbStats ? -1.0 : 100.0 * (double)fs.getHbStats().getMemoryUsedMB() / (double)fs.getHbStats().getMemoryTotalMB();
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), (int)memUtil));
                            break;
                        }
                        case VIEW_DISKSPACE: {
                            double diskUtil = !hbStats ? -1.0 : 100.0 * (double)fs.getHbStats().getServerUsedSizeMB() / (double)fs.getHbStats().getServerCapacitySizeMB();
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), (int)diskUtil));
                            break;
                        }
                        case VIEW_DEBUG_LOGGING: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_DEBUG_LOGGING)));
                            break;
                        }
                        case VIEW_SERVICE_CLDB_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_CLDB_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_FILESERVER_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_FILESERVER_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_JT_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_JT_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_TT_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_TT_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_HBMASTER_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_HBMASTER_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_HBREGION_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_HBREGION_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_NFS_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_NFS_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_NFS4_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_NFS4_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_WEBSERVER_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_WEBSERVER_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_HOSTSTATS_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_HOSTSTATS_DOWN)));
                            break;
                        }
                        case VIEW_DISK_FAILURE: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), fs.getHbStats().getFaileddisks()));
                            break;
                        }
                        case VIEW_VERSION_MISMATCH: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_VERSION_MISMATCH)));
                            break;
                        }
                        case VIEW_TIME_SKEW: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_TIME_SKEW)));
                            break;
                        }
                        case VIEW_HB_PROCESSING_SLOW: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_HB_PROCESSING_SLOW)));
                            break;
                        }
                        case VIEW_ROOT_PARTITION_FULL: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_ROOT_PARTITION_FULL)));
                            break;
                        }
                        case VIEW_OPT_MAPR_FULL: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_OPT_MAPR_FULL)));
                            break;
                        }
                        case VIEW_CORE_PRESENT: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_CORE_PRESENT)));
                            break;
                        }
                        case VIEW_MFS_THROTTLING_RPCS: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_MFS_THROTTLING_RPCS)));
                            break;
                        }
                        case VIEW_HIGH_MFS_MEMORY: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_HIGH_MFS_MEMORY)));
                            break;
                        }
                        case VIEW_PAM_MISCONFIGURED: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_PAM_MISCONFIGURED)));
                            break;
                        }
                        case VIEW_TT_LOCALDIR_FULL: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_TT_LOCALDIR_FULL)));
                            break;
                        }
                        case VIEW_NO_HEARTBEAT: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_NO_HEARTBEAT)));
                            break;
                        }
                        case VIEW_UID_MISMATCH: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_MAPRUSER_MISMATCH)));
                            break;
                        }
                        case VIEW_DUPLICATE_HOSTID: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_DUPLICATE_HOSTID)));
                            break;
                        }
                        case VIEW_METRICS_WRITE_PROBLEM: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_METRICS_WRITE_PROBLEM)));
                            break;
                        }
                        case VIEW_TOO_MANY_CONTAINERS: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_TOO_MANY_CONTAINERS)));
                            break;
                        }
                        case VIEW_SERVICE_HUE_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_HUE_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_HTTPFS_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_HTTPFS_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_BEESWAX_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_BEESWAX_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_HIVEMETA_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_HIVEMETA_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_HS2_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_HS2_DOWN)));
                            break;
                        }
                        case VIEW_SERVICE_OOZIE_DOWN: {
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, Common.AlarmId.NODE_ALARM_SERVICE_OOZIE_DOWN)));
                            break;
                        }
                        case VIEW_PLUGGABLE_ALARM: {
                            Common.PluggableAlarm pluggableAlarm = PluggableAlarmUtil.getAlarmByName(this.getUserCredentials(), this.getParamTextValue(VIEW_PARAM_NAME, 0));
                            rackNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MapRCliUtil.getHostname(fs), this.getAlarmState(fs, pluggableAlarm.getName())));
                            break;
                        }
                    }
                }
            }
        }
    }

    public CLDBProto.FileServerListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.FileServerListRequest req = (CLDBProto.FileServerListRequest)request;
        byte[] replyData = null;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerListProc.getNumber(), (MessageLite)req, CLDBProto.FileServerListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerListProc.getNumber(), (MessageLite)req, CLDBProto.FileServerListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            return this.getFileServerListResponse(replyData);
        }
        LOG.error((Object)"RPC Request to list Nodes failed. No data returned");
        return null;
    }

    private CommandOutput.OutputHierarchy.OutputNode getChildNode(CommandOutput.OutputHierarchy.OutputNode parentNode, String child) {
        for (CommandOutput.OutputHierarchy.OutputNode node : parentNode.getChildren()) {
            if (!node.getName().equals(child)) continue;
            return node;
        }
        return null;
    }

    private CLDBProto.FileServerListResponse getFileServerListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.FileServerListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into FileServerListResponse proto object.", (Throwable)ipbe);
        }
    }

    private CLDBProto.FileServerListRequest.Builder getFileServerListRequestBuilder() throws CLIProcessingException {
        BitSet columns = this.getColumns();
        ByteString bString = ByteString.copyFrom((byte[])BitSetBytesHelperUtils.toByteArray((BitSet)columns));
        long columnsOld = BitSetBytesHelperUtils.convert((BitSet)columns);
        return CLDBProto.FileServerListRequest.newBuilder().setCreds(this.getUserCredentials()).addAllFilter(this.getFilters(ServerCommands.fieldTable, FILTER_PARAM_NAME)).setColumns(columnsOld).setColumnsAdd(bString).setLimiter(this.getNextLimiter(0, 0, 0, Integer.MAX_VALUE, 100));
    }

    private Views getView() throws CLIProcessingException {
        String name = this.getParamTextValue(VIEW_PARAM_NAME, 0);
        for (Views view : Views.values()) {
            if (!name.equalsIgnoreCase(view.getView())) continue;
            return view;
        }
        if (PluggableAlarmUtil.getAlarmByName(this.getUserCredentials(), name) != null) {
            return Views.VIEW_PLUGGABLE_ALARM;
        }
        throw new CLIProcessingException("No view found with name: " + name);
    }

    private BitSet getColumns() throws CLIProcessingException {
        String viewField = this.getParamTextValue(VIEW_PARAM_NAME, 0);
        Object nodeInfoField = null;
        if (viewField.equalsIgnoreCase("status")) {
            nodeInfoField = "";
        } else if (viewField.equalsIgnoreCase("cpu")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.CpuUtil)).getShortName();
        } else if (viewField.equalsIgnoreCase("memory")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.MemUsed)).getShortName() + "," + ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.MemTotal)).getShortName();
        } else if (viewField.equalsIgnoreCase("diskspace")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskUsed)).getShortName() + "," + ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskTotal)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_DEBUG_LOGGING")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.LogLevelAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_CLDB_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceCLDBDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_FILESERVER_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceFileserverDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_JT_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceJTDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_TT_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceTTDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_HBMASTER_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHBMasterDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_HBREGION_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHBRegionDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_NFS_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceNFSDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_NFS4_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceNFS4DownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_WEBSERVER_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceWebserverDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_HOSTSTATS_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHoststatsDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_DISK_FAILURE")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.FailedDisks)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_VERSION_MISMATCH")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.VersionMismatchAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_TIME_SKEW")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.TimeSkewAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_HB_PROCESSING_SLOW")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.HbProcessingSlow)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_ROOT_PARTITION_FULL")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeRootPartitionFull)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_OPT_MAPR_FULL")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeOptMapRFull)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_CORE_PRESENT")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeCorePresent)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_HIGH_MFS_MEMORY")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeHighMfsMemory)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_PAM_MISCONFIGURED")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodePamMisconfigured)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_TT_LOCALDIR_FULL")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeTTLocaldirFull)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_NO_HEARTBEAT")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeNoHeartbeat)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_MAPRUSER_MISMATCH")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeMaprUserMismatch)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_DUPLICATE_HOSTID")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeDuplicateHostId)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_METRICS_WRITE_PROBLEM")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeMetricsWriteProblemAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_TOO_MANY_CONTAINERS")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeTooManyContainersAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_HUE_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHueDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_HTTPFS_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHttpfsDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_BEESWAX_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceBeeswaxDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_HIVEMETA_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHiveMetaDownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_HS2_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHs2DownAlarm)).getShortName();
        } else if (viewField.equalsIgnoreCase("NODE_ALARM_SERVICE_OOZIE_DOWN")) {
            nodeInfoField = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceOozieDownAlarm)).getShortName();
        } else {
            Common.PluggableAlarm pluggableAlarm = PluggableAlarmUtil.getAlarmByName(this.getUserCredentials(), viewField);
            if (pluggableAlarm != null) {
                nodeInfoField = pluggableAlarm.getTerse();
            } else {
                throw new CLIProcessingException("Invalid view: " + viewField);
            }
        }
        String columnsString = ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.Hostname)).getShortName() + "," + ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.RackPath)).getShortName() + "," + ServerCommands.fieldTable.get(new NodeField(CLDBProto.NodeInfo.Status)).getShortName() + "," + (String)nodeInfoField;
        return FilterUtil.getColumns(ServerCommands.fieldTable, (String)columnsString.trim());
    }

    private int getAlarmState(CLDBProto.FileServerInfo fs, Common.AlarmId id) {
        return this.getAlarmState(fs, id.name());
    }

    private int getAlarmState(CLDBProto.FileServerInfo fs, String alarmName) {
        List alarms = fs.getFsAlarmsList();
        if (alarms.size() > 0) {
            for (Common.AlarmMsg alarm : alarms) {
                if (!alarm.getAlarmName().equalsIgnoreCase(alarmName)) continue;
                return alarm.getAlarmState() ? 1 : 0;
            }
            LOG.error((Object)("Could not find the alarm. AlarmId: " + alarmName + ". FileServerId : " + fs.getFileServerId()));
            return 0;
        }
        LOG.error((Object)("No alarms found. FileServerId : " + fs.getFileServerId()));
        return 0;
    }

    static enum Views {
        VIEW_STATUS("status"),
        VIEW_CPU("cpu"),
        VIEW_MEMORY("memory"),
        VIEW_DISKSPACE("diskspace"),
        VIEW_DEBUG_LOGGING("NODE_ALARM_DEBUG_LOGGING"),
        VIEW_SERVICE_CLDB_DOWN("NODE_ALARM_SERVICE_CLDB_DOWN"),
        VIEW_SERVICE_FILESERVER_DOWN("NODE_ALARM_SERVICE_FILESERVER_DOWN"),
        VIEW_SERVICE_JT_DOWN("NODE_ALARM_SERVICE_JT_DOWN"),
        VIEW_SERVICE_TT_DOWN("NODE_ALARM_SERVICE_TT_DOWN"),
        VIEW_SERVICE_HBMASTER_DOWN("NODE_ALARM_SERVICE_HBMASTER_DOWN"),
        VIEW_SERVICE_HBREGION_DOWN("NODE_ALARM_SERVICE_HBREGION_DOWN"),
        VIEW_SERVICE_NFS_DOWN("NODE_ALARM_SERVICE_NFS_DOWN"),
        VIEW_SERVICE_NFS4_DOWN("NODE_ALARM_SERVICE_NFS4_DOWN"),
        VIEW_SERVICE_WEBSERVER_DOWN("NODE_ALARM_SERVICE_WEBSERVER_DOWN"),
        VIEW_SERVICE_HOSTSTATS_DOWN("NODE_ALARM_SERVICE_HOSTSTATS_DOWN"),
        VIEW_DISK_FAILURE("NODE_ALARM_DISK_FAILURE"),
        VIEW_VERSION_MISMATCH("NODE_ALARM_VERSION_MISMATCH"),
        VIEW_TIME_SKEW("NODE_ALARM_TIME_SKEW"),
        VIEW_HB_PROCESSING_SLOW("NODE_ALARM_HB_PROCESSING_SLOW"),
        VIEW_ROOT_PARTITION_FULL("NODE_ALARM_ROOT_PARTITION_FULL"),
        VIEW_OPT_MAPR_FULL("NODE_ALARM_OPT_MAPR_FULL"),
        VIEW_CORE_PRESENT("NODE_ALARM_CORE_PRESENT"),
        VIEW_MFS_THROTTLING_RPCS("NODE_ALARM_MFS_THROTTLING_RPCS"),
        VIEW_HIGH_MFS_MEMORY("NODE_ALARM_HIGH_MFS_MEMORY"),
        VIEW_PAM_MISCONFIGURED("NODE_ALARM_PAM_MISCONFIGURED"),
        VIEW_TT_LOCALDIR_FULL("NODE_ALARM_TT_LOCALDIR_FULL"),
        VIEW_NO_HEARTBEAT("NODE_ALARM_NO_HEARTBEAT"),
        VIEW_UID_MISMATCH("NODE_ALARM_MAPRUSER_MISMATCH"),
        VIEW_DUPLICATE_HOSTID("NODE_ALARM_DUPLICATE_HOSTID"),
        VIEW_METRICS_WRITE_PROBLEM("NODE_ALARM_METRICS_WRITE_PROBLEM"),
        VIEW_TOO_MANY_CONTAINERS("NODE_ALARM_TOO_MANY_CONTAINERS"),
        VIEW_SERVICE_HUE_DOWN("NODE_ALARM_SERVICE_HUE_DOWN"),
        VIEW_SERVICE_HTTPFS_DOWN("NODE_ALARM_SERVICE_HTTPFS_DOWN"),
        VIEW_SERVICE_BEESWAX_DOWN("NODE_ALARM_SERVICE_BEESWAX_DOWN"),
        VIEW_SERVICE_HIVEMETA_DOWN("NODE_ALARM_SERVICE_HIVEMETA_DOWN"),
        VIEW_SERVICE_HS2_DOWN("NODE_ALARM_SERVICE_HS2_DOWN"),
        VIEW_SERVICE_OOZIE_DOWN("NODE_ALARM_SERVICE_OOZIE_DOWN"),
        VIEW_PLUGGABLE_ALARM("PLUGGABLE_ALARM");

        String view = null;

        private Views(String view) {
            this.view = view;
        }

        String getView() {
            return this.view;
        }
    }
}

