/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EntityCommands
extends ListCommand
implements CLIInterface {
    public static final String ENTITY_TYPE_PARAM_NAME = "type";
    public static final String ENTITY_NAME_PARAM_NAME = "name";
    public static final String ENTITIES_PARAM_NAME = "entities";
    public static final String ENTITY_EMAIL_PARAM_NAME = "email";
    public static final String ENTITY_QUOTA_PARAM_NAME = "quota";
    public static final String ENTITY_ADVISORY_QUOTA_PARAM_NAME = "advisoryquota";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String SORT_PARAM_NAME = "sort";
    public static final String SORT_DIRECTION_PARAM_NAME = "dir";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String ALARMEDENTITIES_PARAM_NAME = "alarmedentities";
    public static final String SORTBY_PARAM_NAME = "sortby";
    private static final int NUM_ENTITIES_PER_RPC = 100;
    Properties CLDBProperties = new Properties();
    String querysource;
    private static final Logger LOG = Logger.getLogger(EntityCommands.class);
    static final CLICommand listallCmd = new CLICommand("listall", "", EntityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"output", (Object)new TextInputParameter("output", "<terse|verbose>", false, "verbose")).build(), null).setShortUsage("entity listall -output <terse|verbose>");
    static String supportedSortKeys;
    static Map<String, CLDBProto.ListSortKey> nameToEnumMap;
    static final CLICommand listCmd;
    static final CLICommand infoCmd;
    static final CLICommand existsCmd;
    static final CLICommand removeCmd;
    static final CLICommand modifyCmd;
    public static final CLICommand entityCmds;
    public static Map<CLDBProto.AeInfoFields, FieldInfo> fieldTable;

    public EntityCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("listall")) {
            this.FetchAllEntities(out);
        } else if (cmd.equalsIgnoreCase("list")) {
            String sortbyStr;
            CLDBProto.ListSortKey sortKey;
            String cluster = null;
            if (this.isParamPresent("cluster")) {
                cluster = this.getParamTextValue("cluster", 0);
                if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                    return output;
                }
            }
            if (this.isParamPresent(SORTBY_PARAM_NAME) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0)).toLowerCase())) == null) {
                LOG.error((Object)("failed to set sortkey. " + sortbyStr + " is not a valid keyword to sort entities."));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
                return output;
            }
            MapRCliUtil.fetchCLDBParams(cluster, this.CLDBProperties, this.getUserCredentials());
            this.list(out);
        } else if (cmd.equalsIgnoreCase("info")) {
            String name = this.getParamTextValue(ENTITY_NAME_PARAM_NAME, 0);
            if (name == null || name.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Entity").setField(ENTITY_NAME_PARAM_NAME).setFieldValue(name));
                return output;
            }
            boolean type = this.getParamBooleanValue(ENTITY_TYPE_PARAM_NAME, 0);
            CLDBProto.AeKey key = CLDBProto.AeKey.newBuilder().setName(name).setType(type).build();
            CLDBProto.AeLookupRequest.Builder reqBuilder = CLDBProto.AeLookupRequest.newBuilder().addKeys(key);
            this.FetchEntities(out, reqBuilder);
        } else if (cmd.equalsIgnoreCase("exists")) {
            String name = this.getParamTextValue(ENTITY_NAME_PARAM_NAME, 0);
            if (name == null || name.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Entity").setField(ENTITY_NAME_PARAM_NAME).setFieldValue(name));
                return output;
            }
            boolean type = this.getParamBooleanValue(ENTITY_TYPE_PARAM_NAME, 0);
            if (this.checkEntityExists(type, name)) {
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode());
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Entity does not exist").setField(ENTITY_NAME_PARAM_NAME).setFieldValue(name));
            }
        } else if (cmd.equalsIgnoreCase("modify")) {
            this.ModifyEntity(out, cmd);
        } else if (cmd.equalsIgnoreCase("remove")) {
            this.RemoveEntity(out, cmd);
        }
        return output;
    }

    void FetchAllEntities(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return;
            }
        }
        MapRCliUtil.fetchCLDBParams(cluster, this.CLDBProperties, this.getUserCredentials());
        String[] db = new String[]{"passwd", "group"};
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase("terse");
        for (int i = 0; i < db.length; ++i) {
            try {
                String[] str;
                byte[] b = this.executeSimpleSHHCommand(6000L, "getent " + db[i]);
                if (b == null) continue;
                TextCommandOutput txt = new TextCommandOutput(b);
                for (String s : str = txt.toString().split("\n")) {
                    String[] info = s.split(":");
                    CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aetype).getName(terse), i));
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aename).getName(terse), (Object)info[0]));
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeid).getName(terse), (Object)Integer.valueOf(info[2])));
                    out.addNode(node);
                }
                continue;
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ERROR"));
                LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
            }
        }
    }

    void FetchEntities(CommandOutput.OutputHierarchy out, CLDBProto.AeLookupRequest.Builder reqBuilder) throws CLIProcessingException {
        reqBuilder.setCreds(this.getUserCredentials());
        int version = this.getVersion();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        MapRCliUtil.fetchCLDBParams(cluster, this.CLDBProperties, this.getUserCredentials());
        try {
            byte[] replyData = cluster != null && !cluster.isEmpty() ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AeLookupProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.AeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AeLookupProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.AeLookupResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase("terse");
            CLDBProto.AeLookupResponse resp = CLDBProto.AeLookupResponse.parseFrom((byte[])replyData);
            for (CLDBProto.AeProperties props : resp.getAePropertyList()) {
                CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
                boolean type = props.getAeKey().getType();
                String name = props.getAeKey().getName();
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aetype).getName(terse), type, version, true));
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aename).getName(terse), (Object)name));
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aevolumecount).getName(terse), props.getAeVolumeCount()));
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aequota).getName(terse), props.getQuotaSizeMB()));
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeadvisoryquota).getName(terse), props.getQuotaAdvisorySizeMB()));
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aediskusage).getName(terse), props.getUsedSizeMB()));
                if (props.hasEmail()) {
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeemail).getName(terse), (Object)props.getEmail()));
                } else {
                    String email = MapRCliUtil.fetchEmail(this.CLDBProperties, name, type);
                    if (email != null) {
                        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeemail).getName(terse), (Object)email));
                    }
                }
                try {
                    byte[] b = this.executeSimpleSHHCommand(6000L, "getent " + (type ? "group " : "passwd ") + name);
                    if (b != null) {
                        TextCommandOutput txt = new TextCommandOutput(b);
                        String[] info = txt.toString().split(":");
                        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeid).getName(terse), (Object)Integer.valueOf(info[2])));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not fetch entity uid/gid " + e.getLocalizedMessage()));
                }
                out.addNode(node);
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to fetch entity info"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    private void modify(CommandOutput.OutputHierarchy out, List<String> names, List<Boolean> types) throws CLIProcessingException {
        long quota;
        String quotaStr;
        boolean isModify = false;
        CLDBProto.AeProperties.Builder propsBuilder = CLDBProto.AeProperties.newBuilder();
        if (this.isParamPresent(ENTITY_EMAIL_PARAM_NAME)) {
            String email = this.getParamTextValue(ENTITY_EMAIL_PARAM_NAME, 0);
            if (email == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Email").setField(ENTITY_EMAIL_PARAM_NAME).setFieldValue(email));
            }
            if (!(email = email.trim()).isEmpty() && !MapRCliUtil.validateEmail(email)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Email").setField(ENTITY_EMAIL_PARAM_NAME).setFieldValue(email));
                return;
            }
            propsBuilder.setEmail(email);
            isModify = true;
        }
        if (this.isParamPresent(ENTITY_QUOTA_PARAM_NAME)) {
            quotaStr = this.getParamTextValue(ENTITY_QUOTA_PARAM_NAME, 0);
            quota = MapRCliUtil.quotaStringToMB(quotaStr);
            if (quota < 0L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Quota Value. Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)").setField(ENTITY_QUOTA_PARAM_NAME).setFieldValue(quotaStr));
                return;
            }
            propsBuilder.setQuotaSizeMB(quota);
            isModify = true;
        }
        if (this.isParamPresent(ENTITY_ADVISORY_QUOTA_PARAM_NAME)) {
            quotaStr = this.getParamTextValue(ENTITY_ADVISORY_QUOTA_PARAM_NAME, 0);
            quota = MapRCliUtil.quotaStringToMB(quotaStr);
            if (quota < 0L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Advisory Quota Value.Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)").setField(ENTITY_ADVISORY_QUOTA_PARAM_NAME).setFieldValue(quotaStr));
                return;
            }
            propsBuilder.setQuotaAdvisorySizeMB(quota);
            isModify = true;
        }
        if (!isModify) {
            return;
        }
        CLDBProto.AeProperties props = propsBuilder.build();
        CLDBProto.AeModifyRequest.Builder reqBuilder = CLDBProto.AeModifyRequest.newBuilder().setCreds(this.getUserCredentials());
        for (int i = 0; i < names.size(); ++i) {
            CLDBProto.AeKey key = CLDBProto.AeKey.newBuilder().setName(names.get(i)).setType(types.get(i).booleanValue()).build();
            CLDBProto.AeProperties newprops = CLDBProto.AeProperties.newBuilder((CLDBProto.AeProperties)props).setAeKey(key).build();
            reqBuilder.addAes(newprops);
        }
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AeModifyProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.AeModifyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AeModifyProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.AeModifyResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ERROR Contacting CLDB"));
                return;
            }
            int status = CLDBProto.AeModifyResponse.parseFrom((byte[])replyData).getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "ERROR Modifying Entity: " + Errno.toString((int)status)));
                return;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ERROR"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    void ModifyEntity(CommandOutput.OutputHierarchy out, String cmd) throws CLIProcessingException {
        if (this.isParamPresent(ENTITIES_PARAM_NAME)) {
            String names = this.getParamTextValue(ENTITIES_PARAM_NAME, 0);
            if (names == null || names.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Entities").setField(ENTITIES_PARAM_NAME).setFieldValue(names));
                return;
            }
            ArrayList<String> namesArray = new ArrayList<String>();
            ArrayList<Boolean> typesArray = new ArrayList<Boolean>();
            for (String str : names.split(",")) {
                if (str == null || str.isEmpty()) continue;
                if (str.contains(":")) {
                    String[] s = str.split(":");
                    if (s.length != 2 || s[0] == null || s[0].isEmpty() || s[1] == null || s[1].isEmpty()) continue;
                    if (s[0].equalsIgnoreCase("0")) {
                        typesArray.add(false);
                    } else {
                        if (!s[0].equalsIgnoreCase("1")) continue;
                        typesArray.add(true);
                    }
                    namesArray.add(s[1]);
                    continue;
                }
                namesArray.add(str);
                typesArray.add(false);
            }
            if (namesArray.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Entities, no single valid entity").setField(ENTITIES_PARAM_NAME).setFieldValue(names));
            } else {
                this.modify(out, namesArray, typesArray);
            }
        } else if (this.isParamPresent(ENTITY_NAME_PARAM_NAME)) {
            String name = this.getParamTextValue(ENTITY_NAME_PARAM_NAME, 0);
            if (name == null || name.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Entity").setField(ENTITY_NAME_PARAM_NAME).setFieldValue(name));
                return;
            }
            boolean type = this.getParamBooleanValue(ENTITY_TYPE_PARAM_NAME, 0);
            ArrayList<String> namesArray = new ArrayList<String>();
            ArrayList<Boolean> typesArray = new ArrayList<Boolean>();
            namesArray.add(name);
            typesArray.add(type);
            this.modify(out, namesArray, typesArray);
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Need either name or entities"));
        }
    }

    private void remove(CommandOutput.OutputHierarchy out, List<String> names, List<Boolean> types) throws CLIProcessingException {
        boolean isModify = false;
        CLDBProto.AeRemoveRequest.Builder reqBuilder = CLDBProto.AeRemoveRequest.newBuilder().setCreds(this.getUserCredentials());
        for (int i = 0; i < names.size(); ++i) {
            CLDBProto.AeKey key = CLDBProto.AeKey.newBuilder().setName(names.get(i)).setType(types.get(i).booleanValue()).build();
            reqBuilder.addAeKeys(key);
        }
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AeRemoveProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.AeRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AeRemoveProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.AeRemoveResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ERROR Contacting CLDB"));
                return;
            }
            int status = CLDBProto.AeRemoveResponse.parseFrom((byte[])replyData).getStatus();
            if (status != 0) {
                String msg = CLDBProto.AeRemoveResponse.parseFrom((byte[])replyData).getErrMsg();
                if (msg == null) {
                    msg = Errno.toString((int)status);
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "ERROR Removing Entity: " + msg));
                return;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ERROR"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    void RemoveEntity(CommandOutput.OutputHierarchy out, String cmd) throws CLIProcessingException {
        if (this.isParamPresent(ENTITIES_PARAM_NAME)) {
            String names = this.getParamTextValue(ENTITIES_PARAM_NAME, 0);
            if (names == null || names.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Entities").setField(ENTITIES_PARAM_NAME).setFieldValue(names));
                return;
            }
            ArrayList<String> namesArray = new ArrayList<String>();
            ArrayList<Boolean> typesArray = new ArrayList<Boolean>();
            for (String str : names.split(",")) {
                if (str == null || str.isEmpty()) continue;
                if (str.contains(":")) {
                    String[] s = str.split(":");
                    if (s.length != 2 || s[0] == null || s[0].isEmpty() || s[1] == null || s[1].isEmpty()) continue;
                    if (s[0].equalsIgnoreCase("0")) {
                        typesArray.add(false);
                    } else {
                        if (!s[0].equalsIgnoreCase("1")) continue;
                        typesArray.add(true);
                    }
                    namesArray.add(s[1]);
                    continue;
                }
                namesArray.add(str);
                typesArray.add(false);
            }
            if (namesArray.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Entities, no single valid entity").setField(ENTITIES_PARAM_NAME).setFieldValue(names));
            } else {
                this.remove(out, namesArray, typesArray);
            }
        } else if (this.isParamPresent(ENTITY_NAME_PARAM_NAME)) {
            String name = this.getParamTextValue(ENTITY_NAME_PARAM_NAME, 0);
            if (name == null || name.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Entity").setField(ENTITY_NAME_PARAM_NAME).setFieldValue(name));
                return;
            }
            if (!this.isParamPresent(ENTITY_TYPE_PARAM_NAME)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Entity type not provided for entity").setField(ENTITY_NAME_PARAM_NAME).setFieldValue(name));
                return;
            }
            boolean type = this.getParamBooleanValue(ENTITY_TYPE_PARAM_NAME, 0);
            ArrayList<String> namesArray = new ArrayList<String>();
            ArrayList<Boolean> typesArray = new ArrayList<Boolean>();
            namesArray.add(name);
            typesArray.add(type);
            this.remove(out, namesArray, typesArray);
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Need either name or entities"));
        }
    }

    boolean checkEntityExists(boolean type, String name) {
        String cmd = null;
        cmd = !type ? "getent passwd " + name : "getent group " + name;
        try {
            String result = new TextCommandOutput(this.executeSimpleSHHCommand(6000L, cmd)).toString();
            return result != null && !result.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private CLDBProto.AeLookupRequest.Builder getAeLookupRequestBuilder() throws CLIProcessingException {
        boolean alarmedAes;
        CLDBProto.AeLookupRequest.Builder reqBuilder = CLDBProto.AeLookupRequest.newBuilder();
        if (this.isParamPresent(ALARMEDENTITIES_PARAM_NAME) && (alarmedAes = this.getParamBooleanValue(ALARMEDENTITIES_PARAM_NAME, 0))) {
            reqBuilder.setAlarmedAes(true);
        }
        reqBuilder.addAllFilter(this.getFilters(fieldTable, FILTER_PARAM_NAME));
        reqBuilder.setCreds(this.getUserCredentials());
        reqBuilder.setLimiter(this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 100));
        if (this.isParamPresent(SORTBY_PARAM_NAME)) {
            String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
            CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
            if (sortKey != null) {
                reqBuilder.setSortKey(sortKey);
            } else {
                LOG.error((Object)("failed to set sortkey. " + sortbyStr + " is not a valid keyword to sort entities."));
            }
        }
        return reqBuilder;
    }

    public CLDBProto.AeLookupRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.AeLookupRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.AeLookupRequest.newBuilder((CLDBProto.AeLookupRequest)((CLDBProto.AeLookupRequest)prevReq)) : this.getAeLookupRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.AeLookupResponse)prevResp).getAePropertyCount();
            int origStart = this.getParamIntValue(START_PARAM_NAME, 0);
            int origLimit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), ((CLDBProto.AeLookupRequest)prevReq).getLimiter().getStart(), ((CLDBProto.AeLookupResponse)prevResp).getAePropertyCount());
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.AeLookupResponse resp = (CLDBProto.AeLookupResponse)response;
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase("terse");
        int version = this.getVersion();
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
        for (CLDBProto.AeProperties props : resp.getAePropertyList()) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            boolean type = props.getAeKey().getType();
            String name = props.getAeKey().getName();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aetype).getName(terse), type, version, true));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aename).getName(terse), (Object)name));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aevolumecount).getName(terse), props.getAeVolumeCount()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aequota).getName(terse), props.getQuotaSizeMB()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeadvisoryquota).getName(terse), props.getQuotaAdvisorySizeMB()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aediskusage).getName(terse), props.getUsedSizeMB()));
            if (props.hasEmail()) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeemail).getName(terse), (Object)props.getEmail()));
            } else {
                String email = MapRCliUtil.fetchEmail(this.CLDBProperties, name, type);
                if (email != null) {
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeemail).getName(terse), (Object)email));
                }
            }
            for (Common.AlarmMsg alarm : props.getAeAlarmsList()) {
                if (alarm.getAlarmId() == Common.AlarmId.AE_ALARM_AEQUOTA_EXCEEDED) {
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aequotaalarm).getName(terse), alarm.getAlarmTimeStamp(), version));
                    continue;
                }
                if (alarm.getAlarmId() != Common.AlarmId.AE_ALARM_AEADVISORY_QUOTA_EXCEEDED) continue;
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeadvisoryquotaalarm).getName(terse), alarm.getAlarmTimeStamp(), version));
            }
            try {
                byte[] b = this.executeSimpleSHHCommand(6000L, "getent " + (type ? "group " : "passwd ") + name);
                if (b != null) {
                    TextCommandOutput txt = new TextCommandOutput(b);
                    String[] info = txt.toString().split(":");
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.AeInfoFields.aeid).getName(terse), (Object)Integer.valueOf(info[2])));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Could not fetch entity uid/gid " + e.getLocalizedMessage()));
            }
            out.addNode(node);
        }
    }

    public CLDBProto.AeLookupResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.AeLookupRequest req = (CLDBProto.AeLookupRequest)request;
        byte[] replyData = null;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AeLookupProc.getNumber(), (MessageLite)req, CLDBProto.AeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AeLookupProc.getNumber(), (MessageLite)req, CLDBProto.AeLookupResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            return this.getAeLookupResponse(replyData);
        }
        LOG.error((Object)"RPC Request to list Nodes failed. No data returned");
        return null;
    }

    private CLDBProto.AeLookupResponse getAeLookupResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.AeLookupResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into FileServerListResponse proto object.", (Throwable)ipbe);
        }
    }

    static {
        nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.ListSortKey key : CLDBProto.ListSortKey.values()) {
            if (!key.name().startsWith("Entity")) continue;
            nameToEnumMap.put(key.name().toLowerCase(), key);
            if (sb.length() == 0) {
                sb.append(key.name().toLowerCase());
                continue;
            }
            sb.append("|" + key.name().toLowerCase());
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        listCmd = new CLICommand("list", "", EntityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "<terse|verbose>", false, "verbose")).put((Object)SORT_PARAM_NAME, (Object)new TextInputParameter(SORT_PARAM_NAME, "none", false, "n").setInvisible(true)).put((Object)SORT_DIRECTION_PARAM_NAME, (Object)new TextInputParameter(SORT_DIRECTION_PARAM_NAME, "none", false, "ASC").setInvisible(true)).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)FILTER_PARAM_NAME, (Object)new FilterInputParameter(FILTER_PARAM_NAME, "none", false, "none")).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "none", false, "none")).put((Object)ALARMEDENTITIES_PARAM_NAME, (Object)new BooleanInputParameter(ALARMEDENTITIES_PARAM_NAME, "true|false", false, Boolean.valueOf(false))).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)SORTBY_PARAM_NAME, (Object)new TextInputParameter(SORTBY_PARAM_NAME, supportedSortKeys, false, null)).build(), null).setShortUsage("entity list");
        infoCmd = new CLICommand("info", "", EntityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)ENTITY_TYPE_PARAM_NAME, (Object)new BooleanInputParameter(ENTITY_TYPE_PARAM_NAME, ENTITY_TYPE_PARAM_NAME, true, (Object)0)).put((Object)ENTITY_NAME_PARAM_NAME, (Object)new TextInputParameter(ENTITY_NAME_PARAM_NAME, ENTITY_NAME_PARAM_NAME, true, null)).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "<terse|verbose>", false, "verbose")).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setShortUsage("entity info -type <0=user|1=group> -name <entityname>");
        existsCmd = new CLICommand("exists", "", EntityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)ENTITY_TYPE_PARAM_NAME, (Object)new BooleanInputParameter(ENTITY_TYPE_PARAM_NAME, ENTITY_TYPE_PARAM_NAME, true, (Object)0)).put((Object)ENTITY_NAME_PARAM_NAME, (Object)new TextInputParameter(ENTITY_NAME_PARAM_NAME, "entityname", true, "")).build(), null).setUsageInVisible(true).setShortUsage("entity exists -name <name>");
        removeCmd = new CLICommand("remove", "", EntityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)ENTITY_NAME_PARAM_NAME, (Object)new TextInputParameter(ENTITY_NAME_PARAM_NAME, "entityname", false, null)).put((Object)ENTITY_TYPE_PARAM_NAME, (Object)new BooleanInputParameter(ENTITY_TYPE_PARAM_NAME, ENTITY_TYPE_PARAM_NAME, true, null)).put((Object)ENTITIES_PARAM_NAME, (Object)new TextInputParameter(ENTITIES_PARAM_NAME, "entities (0:<user1>,0:<user2>,1:<group1>,1:<group2>..)", false, null)).build(), null).setShortUsage("entity remove [-name <entityname> -type <entitytype>] [-entities ...]");
        modifyCmd = new CLICommand("modify", "", EntityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)ENTITY_TYPE_PARAM_NAME, (Object)new BooleanInputParameter(ENTITY_TYPE_PARAM_NAME, ENTITY_TYPE_PARAM_NAME, true, null)).put((Object)ENTITY_NAME_PARAM_NAME, (Object)new TextInputParameter(ENTITY_NAME_PARAM_NAME, "entityname", false, null)).put((Object)ENTITIES_PARAM_NAME, (Object)new TextInputParameter(ENTITIES_PARAM_NAME, "entities (0:<user1>,0:<user2>,1:<group1>,1:<group2>..)", false, null)).put((Object)ENTITY_EMAIL_PARAM_NAME, (Object)new TextInputParameter(ENTITY_EMAIL_PARAM_NAME, ENTITY_EMAIL_PARAM_NAME, false, null)).put((Object)ENTITY_QUOTA_PARAM_NAME, (Object)new TextInputParameter(ENTITY_QUOTA_PARAM_NAME, ENTITY_QUOTA_PARAM_NAME, false, null)).put((Object)ENTITY_ADVISORY_QUOTA_PARAM_NAME, (Object)new TextInputParameter(ENTITY_ADVISORY_QUOTA_PARAM_NAME, "advisory quota", false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setShortUsage("entity modify");
        entityCmds = new CLICommand("entity", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{listCmd, infoCmd, existsCmd, modifyCmd, removeCmd}).setShortUsage("entity [list|info|modify|remove]");
        fieldTable = new ImmutableMap.Builder().put((Object)CLDBProto.AeInfoFields.aequota, (Object)new FieldInfo(CLDBProto.AeInfoFields.aequota.getNumber(), "qta", "EntityQuota", Long.class)).put((Object)CLDBProto.AeInfoFields.aeadvisoryquota, (Object)new FieldInfo(CLDBProto.AeInfoFields.aeadvisoryquota.getNumber(), "aqt", "EntityAdvisoryquota", Long.class)).put((Object)CLDBProto.AeInfoFields.aename, (Object)new FieldInfo(CLDBProto.AeInfoFields.aename.getNumber(), "n", "EntityName", String.class)).put((Object)CLDBProto.AeInfoFields.aetype, (Object)new FieldInfo(CLDBProto.AeInfoFields.aetype.getNumber(), "t", "EntityType", Integer.class)).put((Object)CLDBProto.AeInfoFields.aevolumecount, (Object)new FieldInfo(CLDBProto.AeInfoFields.aevolumecount.getNumber(), "vct", "VolumeCount", Integer.class)).put((Object)CLDBProto.AeInfoFields.aediskusage, (Object)new FieldInfo(CLDBProto.AeInfoFields.aediskusage.getNumber(), "dsu", "DiskUsage", Long.class)).put((Object)CLDBProto.AeInfoFields.aeid, (Object)new FieldInfo(CLDBProto.AeInfoFields.aeid.getNumber(), "id", "EntityId", Integer.class)).put((Object)CLDBProto.AeInfoFields.aeemail, (Object)new FieldInfo(CLDBProto.AeInfoFields.aeemail.getNumber(), "em", "EntityEmail", String.class)).put((Object)CLDBProto.AeInfoFields.aequotaalarm, (Object)new FieldInfo(CLDBProto.AeInfoFields.aequotaalarm.getNumber(), "qe", "EntityQuotaExceededAlarm", String.class)).put((Object)CLDBProto.AeInfoFields.aeadvisoryquotaalarm, (Object)new FieldInfo(CLDBProto.AeInfoFields.aeadvisoryquotaalarm.getNumber(), "aqe", "EntityAdvisoryQuotaExceededAlarm", String.class)).build();
    }
}

