/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.BinaryString;
import com.mapr.cli.DbCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.marlin.RecentStreamsListManagers;
import com.mapr.cli.marlin.StreamsCommands;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DbUpstreamCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(DbUpstreamCommands.class);
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    private static final String PATH_PARAM_NAME = "path";
    private static final String UPSTREAM_PARAM_NAME = "upstream";
    private static final String PAUSED_PARAM_NAME = "paused";
    private static final CLICommand listCommand = new CLICommand("list", "usage: table upstream list -path <tablepath>", DbUpstreamCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("table upstream list -path <tablepath>");
    private static final CLICommand addCommand = new CLICommand("add", "usage: table upstream add -path <tablePath> -upstream <upstreamPath>", DbUpstreamCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"upstream", (Object)new TextInputParameter("upstream", "upstream table path", true, null)).build(), null).setShortUsage("table upstream add -path <tablePath> -upstream <upstreamPath>");
    private static final CLICommand removeCommand = new CLICommand("remove", "usage: table upstream remove -path <tablePath> -upstream <upstreamPath>", DbUpstreamCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"upstream", (Object)new TextInputParameter("upstream", "upstream table path", true, null)).build(), null).setShortUsage("table upstream remove -path <tablePath> -upstream <upstreamPath>");
    public static final CLICommand upstreamCommands = new CLICommand("upstream", "upstream [add|list|remove]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCommand, listCommand, removeCommand}).setShortUsage("table upstream [add|list|remove]");

    public DbUpstreamCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cname = this.cliCommand.getCommandName();
        if (cname.equalsIgnoreCase(addCommand.getCommandName())) {
            this.addUpstream(out);
        } else if (cname.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listUpstream(out);
        } else if (cname.equalsIgnoreCase(removeCommand.getCommandName())) {
            this.removeUpstream(out);
        }
        return output;
    }

    public String entityName() {
        return "table";
    }

    private String bytesToString(ByteString bstr) {
        return BinaryString.toStringBinary((byte[])bstr.toByteArray());
    }

    private ByteString stringToByteString(String raws) {
        byte[] bArr = BinaryString.toBytesBinary((String)raws);
        return ByteString.copyFrom((byte[])bArr);
    }

    protected void addUpstream(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String upstreamFullPath = DbCommands.getTransformedPath(this.getParamTextValue(UPSTREAM_PARAM_NAME, 0), this.getUserLoginId());
        try {
            DbUpstreamCommands.addUpStream(tablePath, upstreamFullPath, this.getUserLoginId());
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static void addUpStream(final String tablePath, final String upstreamFullPath, String user) throws CLIProcessingException, IOException {
        final Dbserver.TableUpstreamDesc.Builder upstreamBuilder = Dbserver.TableUpstreamDesc.newBuilder();
        boolean validatePeer = true;
        final RecentTablesListManager manager = StreamsCommands.isStream(tablePath) ? RecentStreamsListManagers.getRecentStreamsListManagerForUser(user) : RecentTablesListManagers.getRecentTablesListManagerForUser(user);
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws IOException, CLIProcessingException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                try {
                    Path upath = new Path(upstreamFullPath);
                    String clusterName = mfs.getClusterName(upath.toUri());
                    upstreamBuilder.setClusterName(clusterName);
                    String upstreamPath = mfs.getNameStr(upstreamFullPath);
                    upstreamBuilder.setTablePath(upstreamPath);
                    Path path = new Path(tablePath);
                    if (!mfs.isTable(path)) {
                        throw new CLIProcessingException("Table not found. Path: " + tablePath);
                    }
                    if (clusterName.equals(mfs.getClusterNameUnchecked(tablePath)) && upstreamPath.equals(mfs.getNameStr(tablePath))) {
                        throw new CLIProcessingException("upstream and current tables cannot be same");
                    }
                    TableProperties props = mfs.getTableProperties(path);
                    TableProperties uprops = mfs.getTableProperties(upath);
                    if (!mfs.isTable(upath)) {
                        throw new CLIProcessingException("Upstream not found. Path: " + upstreamPath);
                    }
                    if (props.getAttr().getIsMarlinTable() != uprops.getAttr().getIsMarlinTable()) {
                        String msg = tablePath + " is " + (props.getAttr().getIsMarlinTable() ? "" : " not ") + "a stream, but upstream " + upstreamPath + " is " + (uprops.getAttr().getIsMarlinTable() ? "" : "not ") + "a stream";
                        throw new CLIProcessingException(msg);
                    }
                    if (props.getAttr().getJson() != uprops.getAttr().getJson()) {
                        String msg = tablePath + " is " + (props.getAttr().getJson() ? "" : " not ") + "a json table, but upstream " + upstreamPath + " is " + (uprops.getAttr().getJson() ? "" : "not ") + "a json table";
                        throw new CLIProcessingException(msg);
                    }
                    if (uprops.getUuid() == null || uprops.getUuid().length == 0) {
                        throw new IOException("upstream table does not have a uuid");
                    }
                    upstreamBuilder.setTableUuid(ByteString.copyFrom((byte[])uprops.getUuid()));
                    upstreamBuilder.setUpstreamFid(uprops.getTableFid());
                    Dbserver.TableUpstreamDesc upstreamDesc = upstreamBuilder.build();
                    mfs.addTableUpstream(path, upstreamDesc);
                    manager.moveToTop(tablePath);
                }
                catch (IOException e) {
                    manager.deleteIfNotExist(tablePath, mfs);
                    throw new CLIProcessingException(e.getMessage());
                }
            }
        };
    }

    protected void listUpstream(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final RecentTablesListManager manager = this.getRecentListManager(this.getUserLoginId());
        final ArrayList rlist = new ArrayList();
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableUpstreamListResponse resp = mfs.listTableUpstreams(new Path(tablePath));
                        rlist.add(resp);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
            Dbserver.TableUpstreamListResponse listResp = (Dbserver.TableUpstreamListResponse)rlist.get(0);
            for (Dbserver.TableUpstreamDesc ud : listResp.getUpstreamsList()) {
                CommandOutput.OutputHierarchy.OutputNode upstreamNode = new CommandOutput.OutputHierarchy.OutputNode();
                upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)ud.getClusterName()));
                upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.entityName(), (Object)ud.getTablePath()));
                upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", ud.getIdx()));
                upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString((byte[])ud.getTableUuid().toByteArray())));
                out.addNode(upstreamNode);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    protected void removeUpstream(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String upstreamFullPath = DbCommands.getTransformedPath(this.getParamTextValue(UPSTREAM_PARAM_NAME, 0), this.getUserLoginId());
        final Dbserver.TableUpstreamDesc.Builder upstreamBuilder = Dbserver.TableUpstreamDesc.newBuilder();
        final RecentTablesListManager manager = this.getRecentListManager(this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        Path rpath = new Path(upstreamFullPath);
                        String clusterName = mfs.getClusterNameUnchecked(upstreamFullPath);
                        upstreamBuilder.setClusterName(clusterName);
                        String upstreamPath = mfs.getNameStr(upstreamFullPath);
                        upstreamBuilder.setTablePath(upstreamPath);
                        Dbserver.TableUpstreamDesc upstreamDesc = upstreamBuilder.build();
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        mfs.removeTableUpstream(new Path(tablePath), upstreamDesc);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    protected RecentTablesListManager getRecentListManager(String user) {
        return RecentTablesListManagers.getRecentTablesListManagerForUser(user);
    }
}

