/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.fsrpcutils.Utils;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class VirtualIPCommands
extends ListCommand {
    private static final Logger LOG = Logger.getLogger(VirtualIPCommands.class);
    private static final int NUM_VIRTUAL_IPS_PER_RPC = 50;
    private static final String Macs = "macs";
    private static final String NetMask = "netmask";
    private static final String Gateway = "gateway";
    private static final String VirtualIP = "virtualip";
    private static final String VirtualIPEnd = "virtualipend";
    private static final String toMac = "tomac";
    private static final String preferredMac = "preferredmac";
    private static final String serviceName = "service";
    private static final String Range = "range";
    private static final String NfsMacs = "nfsmacs";
    private static final String Limit = "limit";
    private static final String Start = "start";
    private static final String Columns = "columns";
    private static final String Output = "output";
    private static final String Filter = "filter";
    private static final String SORTBY_PARAM_NAME = "sortby";
    private static Pattern s_spaceSplitter = Pattern.compile("\\s+");
    public static Map<CLDBProto.NodeInfo, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)CLDBProto.NodeInfo.Ip, (Object)new FieldInfo(CLDBProto.NodeInfo.Ip.getNumber(), "ip", "ip", String.class)).put((Object)CLDBProto.NodeInfo.Hostname, (Object)new FieldInfo(CLDBProto.NodeInfo.Hostname.getNumber(), "hn", "hn", String.class)).put((Object)CLDBProto.NodeInfo.MacAddress, (Object)new FieldInfo(CLDBProto.NodeInfo.MacAddress.getNumber(), "mac", "mac", String.class)).put((Object)CLDBProto.NodeInfo.VirtualIp, (Object)new FieldInfo(CLDBProto.NodeInfo.VirtualIp.getNumber(), "vip", "vip", String.class)).put((Object)CLDBProto.NodeInfo.VirtualIpEnd, (Object)new FieldInfo(CLDBProto.NodeInfo.VirtualIpEnd.getNumber(), "vipe", "vipe", String.class)).build();
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    static String supportedSortKeys;
    static Map<String, CLDBProto.ListSortKey> nameToEnumMap;
    private static final CLICommand listCommand;
    private static final CLICommand addCommand;
    private static final CLICommand editCommand;
    private static final CLICommand moveCommand;
    private static final CLICommand removeCommand;
    public static final CLICommand virtualIpsCommand;

    public static String longToIp(long i) {
        return (i >> 24 & 0xFFL) + "." + (i >> 16 & 0xFFL) + "." + (i >> 8 & 0xFFL) + "." + (i & 0xFFL);
    }

    public VirtualIPCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.isParamPresent("cluster")) {
            String cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return output;
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("add")) {
            this.addVirtualIps(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            String sortbyStr;
            CLDBProto.ListSortKey sortKey;
            if (this.isParamPresent(SORTBY_PARAM_NAME) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0)).toLowerCase())) == null) {
                LOG.error((Object)("failed to set sortkey. " + sortbyStr + " is not a valid keyword to sort virtual IPs."));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
                return output;
            }
            this.list(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            this.removeVirtualIps(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("move")) {
            this.moveVirtualIps(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("edit")) {
            this.editVirtualIps(out);
        }
        return output;
    }

    private boolean isNetmaskValid(int netmask) {
        boolean valid;
        boolean bl = valid = netmask != 0 && (netmask == -1 || (netmask & 1) == 0);
        if (valid) {
            long x = ~netmask + 1;
            valid = x > 0L && (x & x - 1L) == 0L;
        }
        return valid;
    }

    private boolean isValidMacAddress(String mac) {
        if (mac.length() != 17 && mac.length() != 59) {
            return false;
        }
        for (int i = 2; i < mac.length(); i += 3) {
            if (mac.charAt(i) == ':') continue;
            return false;
        }
        return true;
    }

    private void addVirtualIps(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.AddVirtualIpResponse resp;
        String ip = this.getParamTextValue(VirtualIP, 0);
        String nMask = this.getParamTextValue(NetMask, 0);
        long netMask = Util.ipToLong((String)nMask);
        if (!this.isNetmaskValid((int)netMask)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Netmask invalid: " + nMask));
            LOG.error((Object)("Netmask invalid: " + nMask));
            return;
        }
        ProcessedInput.Parameter param = this.input.getParameterByName(Macs);
        List values = param != null ? param.getParamValues() : new ArrayList(0);
        CLDBProto.VirtualIPInfo.Builder req = CLDBProto.VirtualIPInfo.newBuilder();
        Common.InterfaceInfo.Builder ifb = Common.InterfaceInfo.newBuilder();
        long vIpStart = Util.ipToLong((String)ip);
        ifb.setNetmask(netMask);
        req.setNetmask(netMask);
        if (this.isParamPresent(Gateway)) {
            String gateway = this.getParamTextValue(Gateway, 0);
            ifb.setGateway(Util.ipToLong((String)gateway));
            req.setGateway(Util.ipToLong((String)gateway));
        }
        for (String macaddr : values) {
            String[] addrs;
            for (String addr : addrs = s_spaceSplitter.split(macaddr)) {
                Common.InterfaceInfo.Builder mb = Common.InterfaceInfo.newBuilder();
                mb.setMacaddress(addr.toLowerCase());
                req.addDevInfo(mb.build());
            }
        }
        if (this.isParamPresent(preferredMac)) {
            ProcessedInput.Parameter pmacs = this.input.getParameterByName(preferredMac);
            if (pmacs != null && pmacs.getParamValues().size() > 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "preferred mac address should be only one"));
                return;
            }
            String mac = this.getParamTextValue(preferredMac, 0);
            if (!this.isValidMacAddress(mac)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "preferred mac address should of format xx:xx:xx:xx:xx:xx or 20 octet address"));
                return;
            }
            Common.InterfaceInfo.Builder mb = Common.InterfaceInfo.newBuilder();
            mb.setMacaddress(mac.toLowerCase());
            req.addPreferredDevInfo(mb.build());
        }
        long vIpEnd = vIpStart;
        String vIpRangeEnd = "";
        if (this.isParamPresent(VirtualIPEnd)) {
            vIpRangeEnd = this.getParamTextValue(VirtualIPEnd, 0);
            if ((vIpRangeEnd = vIpRangeEnd.trim()).length() > 0) {
                if (!this.checkIPRange(ip, vIpRangeEnd)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "RangeEnd must be greater than the beginning of the range."));
                    return;
                }
                vIpEnd = Util.ipToLong((String)vIpRangeEnd);
            }
        }
        req.setVIpStart(vIpStart);
        req.setVIpEnd(vIpEnd);
        req.setVIpInfo(ifb.build());
        CLDBProto.ClientType serviceType = CLDBProto.ClientType.NFS_V3;
        if (this.isParamPresent(serviceName)) {
            if (!this.isParamPresent(preferredMac) && param == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "preferred mac or mac is needed with service option"));
                return;
            }
            String servName = this.getParamTextValue(serviceName, 0);
            if (servName.equalsIgnoreCase("nfs4")) {
                serviceType = CLDBProto.ClientType.NFS_V4;
            } else if (servName.equalsIgnoreCase("nfs3")) {
                serviceType = CLDBProto.ClientType.NFS_V3;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "serviceType should be one of nfs3 or nfs4"));
                return;
            }
        }
        req.setServiceType(serviceType);
        CLDBProto.AddVirtualIpRequest.Builder aBuilder = CLDBProto.AddVirtualIpRequest.newBuilder().setCreds(this.getUserCredentials());
        aBuilder.setVIpConfig(req.build());
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AddVirtualIpProc.getNumber(), (MessageLite)aBuilder.build(), CLDBProto.AddVirtualIpResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AddVirtualIpProc.getNumber(), (MessageLite)aBuilder.build(), CLDBProto.AddVirtualIpResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = CLDBProto.AddVirtualIpResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Add VirtualIP: " + Errno.toString((int)10003)));
            LOG.error((Object)"Exception during Add VirtualIP ", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            if (status == 17) {
                String msg = "Virtual IP " + ip + " is already added to the cluster. Please specify a different IP address.";
                if (!vIpRangeEnd.isEmpty() && !ip.equals(vIpRangeEnd)) {
                    msg = "One or more Virtual IPs in the range " + ip + " to " + vIpRangeEnd + " are already added to the cluster.  Please specify a different IP address range.";
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)status)));
            }
            return;
        }
        if (this.isParamPresent(preferredMac) && !resp.hasPreferredDevSupported()) {
            out.addMessage("Successfully added VIPs but could not set the preferredmac as CLDB is of older version. Upgrade CLDB to latest version and update the preferredmac using \"maprcli virtualip edit \" command");
        }
    }

    private void moveVirtualIps(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.MoveVirtualIpResponse resp;
        String vipStartStr = this.getParamTextValue(VirtualIP, 0);
        String mac = this.getParamTextValue(toMac, 0);
        String vipEndStr = vipStartStr;
        if (this.isParamPresent(VirtualIPEnd)) {
            vipEndStr = this.getParamTextValue(VirtualIPEnd, 0);
        }
        if (!this.checkIPRange(vipStartStr, vipEndStr)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "RangeEnd must be greater than the beginning of the range."));
            return;
        }
        if (!this.isValidMacAddress(mac)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "mac address should of format xx:xx:xx:xx:xx:xx or 20 octet address"));
            return;
        }
        long vIpStart = Util.ipToLong((String)vipStartStr);
        long vIpEnd = Util.ipToLong((String)vipEndStr);
        CLDBProto.MoveVirtualIpRequest.Builder req = CLDBProto.MoveVirtualIpRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        req.setVIpStart(vIpStart);
        req.setVIpEnd(vIpEnd);
        Common.InterfaceInfo.Builder mb = Common.InterfaceInfo.newBuilder();
        mb.setMacaddress(mac.toLowerCase());
        req.setPreferredDevInfo(mb.build());
        CLDBProto.ClientType serviceType = CLDBProto.ClientType.NFS_V3;
        if (this.isParamPresent(serviceName)) {
            String servName = this.getParamTextValue(serviceName, 0);
            if (servName.equalsIgnoreCase("nfs4")) {
                serviceType = CLDBProto.ClientType.NFS_V4;
            } else if (servName.equalsIgnoreCase("nfs3")) {
                serviceType = CLDBProto.ClientType.NFS_V3;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "serviceType should be one of nfs3 or nfs4"));
                return;
            }
        }
        req.setServiceType(serviceType);
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.MoveVirtualIpProc.getNumber(), (MessageLite)req.build(), CLDBProto.MoveVirtualIpResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.MoveVirtualIpProc.getNumber(), (MessageLite)req.build(), CLDBProto.MoveVirtualIpResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = CLDBProto.MoveVirtualIpResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Move VirtualIP: " + Errno.toString((int)10003)));
            LOG.error((Object)"Exception during Move VirtualIP ", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)status)));
        }
    }

    private void editVirtualIps(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.AddVirtualIpResponse resp;
        String ip = this.getParamTextValue(VirtualIP, 0);
        ProcessedInput.Parameter param = this.input.getParameterByName(Macs);
        List values = param != null ? param.getParamValues() : new ArrayList(0);
        CLDBProto.VirtualIPInfo.Builder req = CLDBProto.VirtualIPInfo.newBuilder();
        long vIpStart = Util.ipToLong((String)ip);
        if (this.isParamPresent(Gateway)) {
            String gateway = this.getParamTextValue(Gateway, 0);
            req.setGateway(Util.ipToLong((String)gateway));
        }
        String nm = this.getParamTextValue(NetMask, 0);
        long netmask = Util.ipToLong((String)nm);
        req.setNetmask(netmask);
        Common.InterfaceInfo.Builder ifb = Common.InterfaceInfo.newBuilder();
        ifb.setNetmask(netmask);
        req.setVIpInfo(ifb.build());
        for (String macaddr : values) {
            String[] addrs;
            for (String addr : addrs = s_spaceSplitter.split(macaddr)) {
                Common.InterfaceInfo.Builder mb = Common.InterfaceInfo.newBuilder();
                mb.setMacaddress(addr.toLowerCase());
                req.addDevInfo(mb.build());
            }
        }
        if (this.isParamPresent(preferredMac)) {
            ProcessedInput.Parameter pmacs = this.input.getParameterByName(preferredMac);
            if (pmacs != null && pmacs.getParamValues().size() > 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "preferred mac address should be only one"));
                return;
            }
            String mac = this.getParamTextValue(preferredMac, 0);
            if (mac.compareToIgnoreCase("") != 0 && !this.isValidMacAddress(mac)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "preferred mac address should of format xx:xx:xx:xx:xx:xx or \"\" to remove the preferred mac"));
                return;
            }
            Common.InterfaceInfo.Builder mb = Common.InterfaceInfo.newBuilder();
            mb.setMacaddress(mac.toLowerCase());
            req.addPreferredDevInfo(mb.build());
        }
        long vIpEnd = vIpStart;
        if (this.isParamPresent(VirtualIPEnd)) {
            String vIpRangeEnd = this.getParamTextValue(VirtualIPEnd, 0);
            if (!this.checkIPRange(ip, vIpRangeEnd)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "RangeEnd must be greater than the beginning of the range."));
                return;
            }
            vIpEnd = Util.ipToLong((String)vIpRangeEnd);
        }
        req.setVIpStart(vIpStart);
        req.setVIpEnd(vIpEnd);
        CLDBProto.ClientType serviceType = CLDBProto.ClientType.NFS_V3;
        if (this.isParamPresent(serviceName)) {
            if (!this.isParamPresent(preferredMac) && param == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "preferred mac or mac is needed with service option"));
                return;
            }
            String servName = this.getParamTextValue(serviceName, 0);
            if (servName.equalsIgnoreCase("nfs4")) {
                serviceType = CLDBProto.ClientType.NFS_V4;
            } else if (servName.equalsIgnoreCase("nfs3")) {
                serviceType = CLDBProto.ClientType.NFS_V3;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "serviceType should be one of nfs3 or nfs4"));
                return;
            }
        }
        req.setServiceType(serviceType);
        CLDBProto.AddVirtualIpRequest.Builder aBuilder = CLDBProto.AddVirtualIpRequest.newBuilder().setCreds(this.getUserCredentials());
        aBuilder.setVIpConfig(req.build());
        aBuilder.setModify(true);
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ModifyVirtualIpProc.getNumber(), (MessageLite)aBuilder.build(), CLDBProto.AddVirtualIpResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ModifyVirtualIpProc.getNumber(), (MessageLite)aBuilder.build(), CLDBProto.AddVirtualIpResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = CLDBProto.AddVirtualIpResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Edit VirtualIP: " + Errno.toString((int)10003)));
            LOG.error((Object)"Exception during Edit VirtualIP ", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)status)));
            return;
        }
        if (this.isParamPresent(preferredMac) && !resp.hasPreferredDevSupported()) {
            out.addMessage("Successfully edited VIPs but could not update the preferredmac as CLDB is of older version. Upgrade CLDB to latest version and try again");
        }
    }

    private boolean checkIPRange(String ip, String ipEnd) {
        String[] ip2;
        String[] ip1 = ip.split("\\.");
        if (ip1.length != (ip2 = ipEnd.split("\\.")).length && ip1.length != 4) {
            return false;
        }
        try {
            for (int i = 0; i < ip1.length; ++i) {
                int i2;
                int i1 = Integer.parseInt(ip1[i]);
                if (i1 < (i2 = Integer.parseInt(ip2[i]))) {
                    return true;
                }
                if (i1 <= i2) continue;
                return false;
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Ip's are not in proper format. Ip Start: " + ip + " Ip End: " + ipEnd));
            return false;
        }
        return true;
    }

    private static int formatStatus(String s) {
        if (s.equalsIgnoreCase("ACTIVE")) {
            return 0;
        }
        if (s.equalsIgnoreCase("DEAD") || s.equalsIgnoreCase("INACTIVE")) {
            return 4;
        }
        return 5;
    }

    private void listNfsServers(List<CLDBProto.VirtualIPInfo> list, CommandOutput.OutputHierarchy out) {
        for (CLDBProto.VirtualIPInfo vInfo : list) {
            int status = VirtualIPCommands.formatStatus(vInfo.getState());
            int nDevs = vInfo.getDevInfoCount();
            for (int j = 0; j < nDevs; ++j) {
                CommandOutput.OutputHierarchy.OutputNode row = new CommandOutput.OutputHierarchy.OutputNode();
                out.addNode(row);
                CommandOutput.OutputHierarchy.OutputNode a = new CommandOutput.OutputHierarchy.OutputNode("h", status);
                row.addChild(a);
                Common.InterfaceInfo ifInfo = vInfo.getDevInfo(j);
                a = new CommandOutput.OutputHierarchy.OutputNode("hn", (Object)ifInfo.getHostname());
                row.addChild(a);
                a = new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)VirtualIPCommands.longToIp(ifInfo.getIp()));
                row.addChild(a);
                a = new CommandOutput.OutputHierarchy.OutputNode("mac", (Object)ifInfo.getMacaddress());
                row.addChild(a);
            }
        }
    }

    private void listAssigments(List<CLDBProto.VirtualIPInfo> list, CommandOutput.OutputHierarchy out, boolean printAssignable) {
        for (CLDBProto.VirtualIPInfo vInfo : list) {
            Common.InterfaceInfo vIf = vInfo.getVIpInfo();
            CommandOutput.OutputHierarchy.OutputNode row = new CommandOutput.OutputHierarchy.OutputNode();
            CommandOutput.OutputHierarchy.OutputNode ip = new CommandOutput.OutputHierarchy.OutputNode("vip", (Object)VirtualIPCommands.longToIp(vIf.getIp()));
            row.addChild(ip);
            if (vInfo.hasAssignedDev()) {
                Common.InterfaceInfo ifInfo = vInfo.getAssignedDev();
                CommandOutput.OutputHierarchy.OutputNode a = new CommandOutput.OutputHierarchy.OutputNode("hn", (Object)ifInfo.getHostname());
                row.addChild(a);
                a = new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)VirtualIPCommands.longToIp(ifInfo.getIp()));
                row.addChild(a);
                a = new CommandOutput.OutputHierarchy.OutputNode("mac", (Object)ifInfo.getMacaddress());
                row.addChild(a);
            }
            if (vInfo.hasNetmask()) {
                CommandOutput.OutputHierarchy.OutputNode nm = new CommandOutput.OutputHierarchy.OutputNode("nm", (Object)VirtualIPCommands.longToIp(vInfo.getNetmask()));
                row.addChild(nm);
            }
            if (!printAssignable) {
                out.addNode(row);
                continue;
            }
            int num = vInfo.getDevInfoCount();
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < num; ++j) {
                Common.InterfaceInfo d = vInfo.getDevInfo(j);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(d.getMacaddress());
            }
            if (sb.length() > 0) {
                CommandOutput.OutputHierarchy.OutputNode o = new CommandOutput.OutputHierarchy.OutputNode("AssignableTo", (Object)sb.toString());
                row.addChild(o);
            }
            if (vInfo.getPreferredDevInfoCount() > 0) {
                CommandOutput.OutputHierarchy.OutputNode o = new CommandOutput.OutputHierarchy.OutputNode("PreferredMac", (Object)vInfo.getPreferredDevInfo(0).getMacaddress());
                row.addChild(o);
                o = new CommandOutput.OutputHierarchy.OutputNode("Preferredip", (Object)Utils.longToIp((long)vInfo.getPreferredDevInfo(0).getIp()));
                row.addChild(o);
                o = new CommandOutput.OutputHierarchy.OutputNode("Preferredhn", (Object)vInfo.getPreferredDevInfo(0).getHostname());
                row.addChild(o);
            }
            out.addNode(row);
        }
    }

    private void listConfig(List<CLDBProto.VirtualIPInfo> list, CommandOutput.OutputHierarchy out) {
        for (CLDBProto.VirtualIPInfo vInfo : list) {
            CommandOutput.OutputHierarchy.OutputNode subRow;
            int num;
            CommandOutput.OutputHierarchy.OutputNode row = new CommandOutput.OutputHierarchy.OutputNode();
            out.addNode(row);
            CommandOutput.OutputHierarchy.OutputNode ip = new CommandOutput.OutputHierarchy.OutputNode("vip", (Object)VirtualIPCommands.longToIp(vInfo.getVIpStart()));
            row.addChild(ip);
            if (vInfo.hasVIpEnd()) {
                ip = new CommandOutput.OutputHierarchy.OutputNode("vipe", (Object)VirtualIPCommands.longToIp(vInfo.getVIpEnd()));
                row.addChild(ip);
            }
            if (vInfo.hasNetmask()) {
                ip = new CommandOutput.OutputHierarchy.OutputNode("nm", (Object)VirtualIPCommands.longToIp(vInfo.getNetmask()));
                row.addChild(ip);
            }
            if (vInfo.hasGateway()) {
                ip = new CommandOutput.OutputHierarchy.OutputNode("gw", (Object)VirtualIPCommands.longToIp(vInfo.getGateway()));
                row.addChild(ip);
            }
            if ((num = vInfo.getDevInfoCount()) == 0) {
                CommandOutput.OutputHierarchy.OutputNode wRow = new CommandOutput.OutputHierarchy.OutputNode("assignables");
                subRow = new CommandOutput.OutputHierarchy.OutputNode("assignables");
                row.addChild(subRow);
                row.addChild(wRow);
            }
            for (int j = 0; j < num; ++j) {
                subRow = new CommandOutput.OutputHierarchy.OutputNode("assignables");
                row.addChild(subRow);
                Common.InterfaceInfo d = vInfo.getDevInfo(j);
                CommandOutput.OutputHierarchy.OutputNode o = new CommandOutput.OutputHierarchy.OutputNode("hn", (Object)d.getHostname());
                subRow.addChild(o);
                String ipstr = VirtualIPCommands.longToIp(d.getIp());
                o = new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)ipstr);
                subRow.addChild(o);
                o = new CommandOutput.OutputHierarchy.OutputNode("mac", (Object)d.getMacaddress());
                subRow.addChild(o);
                if (num != 1) continue;
                CommandOutput.OutputHierarchy.OutputNode wRow = new CommandOutput.OutputHierarchy.OutputNode("assignables");
                row.addChild(wRow);
            }
        }
    }

    private void removeVirtualIps(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.RemoveVirtualIpResponse resp;
        String start = this.getParamTextValue(VirtualIP, 0);
        long vIpStart = Util.ipToLong((String)start);
        CLDBProto.RemoveVirtualIpRequest.Builder aBuilder = CLDBProto.RemoveVirtualIpRequest.newBuilder().setCreds(this.getUserCredentials());
        aBuilder.setVIpStart(vIpStart);
        long vIpEnd = vIpStart;
        if (this.isParamPresent(VirtualIPEnd)) {
            String end = this.getParamTextValue(VirtualIPEnd, 0);
            if (!this.checkIPRange(start, end)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "RangeEnd must be greater than the beginning of the range."));
                return;
            }
            vIpEnd = Util.ipToLong((String)end);
        }
        aBuilder.setVIpEnd(vIpEnd);
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.RemoveVirtualIpProc.getNumber(), (MessageLite)aBuilder.build(), CLDBProto.RemoveVirtualIpResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.RemoveVirtualIpProc.getNumber(), (MessageLite)aBuilder.build(), CLDBProto.RemoveVirtualIpResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = CLDBProto.RemoveVirtualIpResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Remove VirtualIP: " + Errno.toString((int)10003)));
            LOG.error((Object)"Exception during Remove VirtualIP ", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)status)));
        }
    }

    public String getCommandUsage() {
        return "virtualip add|edit|remove|move|list";
    }

    private CLDBProto.ListVirtualIpRequest.ListType getListType() throws CLIProcessingException {
        int range = this.getParamIntValue(Range, 0);
        int nfsmacs = this.getParamIntValue(NfsMacs, 0);
        CLDBProto.ListVirtualIpRequest.ListType lType = range != 0 ? CLDBProto.ListVirtualIpRequest.ListType.RangeConfigured : (nfsmacs != 0 ? CLDBProto.ListVirtualIpRequest.ListType.NfsMacs : CLDBProto.ListVirtualIpRequest.ListType.Assignments);
        return lType;
    }

    private CLIProto.Limiter getLimiter() throws CLIProcessingException {
        return this.getNextLimiter(this.getParamIntValue(Start, 0), 0, this.getParamIntValue(Start, 0), this.getParamIntValue(Limit, 0), 50);
    }

    private CLDBProto.ListVirtualIpResponse getListVirtualIpResponse(byte[] data) throws CLIProcessingException {
        try {
            return CLDBProto.ListVirtualIpResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into ListVirtualIpResponse proto object.", (Throwable)ipbe);
        }
    }

    private int getRecordCount(CLDBProto.ListVirtualIpResponse resp) throws CLIProcessingException {
        int count = resp.getVIpInfosCount();
        CLDBProto.ListVirtualIpRequest.ListType lType = this.getListType();
        if (lType == CLDBProto.ListVirtualIpRequest.ListType.NfsMacs) {
            count = 0;
            for (CLDBProto.VirtualIPInfo info : resp.getVIpInfosList()) {
                count += info.getDevInfoCount();
            }
        }
        LOG.info((Object)("getRecordCount returned count: " + count));
        return count;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.ListVirtualIpRequest.Builder newReqBuilder = null;
        if (prevReq != null) {
            newReqBuilder = CLDBProto.ListVirtualIpRequest.newBuilder((CLDBProto.ListVirtualIpRequest)((CLDBProto.ListVirtualIpRequest)prevReq));
        } else {
            newReqBuilder = CLDBProto.ListVirtualIpRequest.newBuilder().setLimiter(this.getLimiter()).setListType(this.getListType()).addAllFilter(this.getFilters(fieldTable, Filter)).setCreds(this.getUserCredentials());
            if (this.isParamPresent(SORTBY_PARAM_NAME)) {
                String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
                CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
                if (sortKey != null) {
                    newReqBuilder.setSortKey(sortKey);
                } else {
                    LOG.error((Object)("failed to set sortkey. " + sortbyStr + " is not a valid keyword to sort virtual IPs."));
                }
            }
        }
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = this.getRecordCount((CLDBProto.ListVirtualIpResponse)prevResp);
            int origStart = this.getParamIntValue(Start, 0);
            int origLimit = this.getParamIntValue(Limit, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 50));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getParamIntValue(Start, 0), this.getParamIntValue(Limit, 0), ((CLDBProto.ListVirtualIpRequest)prevReq).getLimiter().getStart(), this.getRecordCount((CLDBProto.ListVirtualIpResponse)prevResp));
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.ListVirtualIpResponse resp = (CLDBProto.ListVirtualIpResponse)response;
        CLDBProto.ListVirtualIpRequest.ListType lType = this.getListType();
        if (lType == CLDBProto.ListVirtualIpRequest.ListType.RangeConfigured) {
            this.listConfig(resp.getVIpInfosList(), out);
        } else if (lType == CLDBProto.ListVirtualIpRequest.ListType.NfsMacs) {
            this.listNfsServers(resp.getVIpInfosList(), out);
        } else {
            this.listAssigments(resp.getVIpInfosList(), out, true);
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        } else {
            LOG.error((Object)"total field not populated in ListVirtualIpResponse");
        }
    }

    @Override
    public MessageLite sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.ListVirtualIpRequest req = (CLDBProto.ListVirtualIpRequest)request;
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ListVirtualIpProc.getNumber(), (MessageLite)req, CLDBProto.ListVirtualIpResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ListVirtualIpProc.getNumber(), (MessageLite)req, CLDBProto.ListVirtualIpResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data != null) {
            return this.getListVirtualIpResponse(data);
        }
        LOG.error((Object)"RPC Request to list virtual ips failed. No data returned");
        return null;
    }

    static {
        nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.ListSortKey key : CLDBProto.ListSortKey.values()) {
            if (!key.name().startsWith("Vip")) continue;
            nameToEnumMap.put(key.name().toLowerCase(), key);
            if (sb.length() == 0) {
                sb.append(key.name().toLowerCase());
                continue;
            }
            sb.append("|" + key.name().toLowerCase());
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        listCommand = new CLICommand("list", "usage: virtualip list -type [assignment|range|nfsmacs]-cluster clustername", VirtualIPCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)Range, (Object)new IntegerInputParameter(Range, Range, false, Integer.valueOf(0))).put((Object)NfsMacs, (Object)new IntegerInputParameter(NfsMacs, NfsMacs, false, Integer.valueOf(0))).put((Object)Limit, (Object)new IntegerInputParameter(Limit, Limit, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)Start, (Object)new IntegerInputParameter(Start, Start, false, Integer.valueOf(0))).put((Object)Columns, (Object)new TextInputParameter(Columns, Columns, false, "none")).put((Object)Output, (Object)new TextInputParameter(Output, Output, false, "terse")).put((Object)Filter, (Object)new FilterInputParameter(Filter, Filter, false, "none")).put((Object)SORTBY_PARAM_NAME, (Object)new TextInputParameter(SORTBY_PARAM_NAME, supportedSortKeys, false, null)).build(), null).setShortUsage("virtualip list -range range -nfsmacs nfsmacs -cluster clustername");
        addCommand = new CLICommand("add", "usage: virtualip add -virtualip vIP -virtualipend VirtualIpRangeEnd -netmask netmask -macs macaddress1 macaddress2 -preferredmac preferredmac .. -cluster clustername -service servicename", VirtualIPCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)Macs, (Object)new TextInputParameter(Macs, "macaddress", false, null)).put((Object)NetMask, (Object)new TextInputParameter(NetMask, NetMask, true, null)).put((Object)Gateway, (Object)new TextInputParameter(Gateway, Gateway, false, null)).put((Object)VirtualIP, (Object)new TextInputParameter(VirtualIP, VirtualIP, true, null)).put((Object)VirtualIPEnd, (Object)new TextInputParameter(VirtualIPEnd, "VirtualIpRangeEnd", false, null)).put((Object)preferredMac, (Object)new TextInputParameter(preferredMac, preferredMac, false, null)).put((Object)serviceName, (Object)new TextInputParameter(serviceName, "service to assign vips to. available options: nfs4, nfs3. default: nfs3. macs is mandatory with this option", false, null)).build(), null).setShortUsage("virtualip add -virtualip vIP -virtualipend VirtualIpRangeEnd -netmask netmask -macs macaddress1 -preferredmac macaddress.. -cluster clustername -service servicename");
        editCommand = new CLICommand("edit", "usage: virtualip edit -virtualip vIP -virtualipend VirtualIpRangeEnd -cluster clustername -service servicename", VirtualIPCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)VirtualIP, (Object)new TextInputParameter(VirtualIP, VirtualIP, true, null)).put((Object)VirtualIPEnd, (Object)new TextInputParameter(VirtualIPEnd, "VirtualIpRangeEnd", false, null)).put((Object)NetMask, (Object)new TextInputParameter(NetMask, NetMask, true, null)).put((Object)Macs, (Object)new TextInputParameter(Macs, "macaddress", false, null)).put((Object)preferredMac, (Object)new TextInputParameter(preferredMac, preferredMac, false, null)).put((Object)serviceName, (Object)new TextInputParameter(serviceName, "service to assign vips to. available options: nfs4, nfs3. default: nfs3. macs is mandatory with this option", false, null)).build(), null).setShortUsage("virtualip edit -virtualip vIP -virtualipend VirtualIpRangeEnd -cluster clustername -macs macaddress1 -preferredmac macaddress.. -service servicename");
        moveCommand = new CLICommand("move", "usage: virtualip move -virtualip vIP -virtualipend VirtualIpRangeEnd -cluster clustername -service servicename", VirtualIPCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)VirtualIP, (Object)new TextInputParameter(VirtualIP, VirtualIP, true, null)).put((Object)VirtualIPEnd, (Object)new TextInputParameter(VirtualIPEnd, "VirtualIpRangeEnd", false, null)).put((Object)toMac, (Object)new TextInputParameter(toMac, toMac, true, null)).put((Object)serviceName, (Object)new TextInputParameter(serviceName, "service to assign vips to. available options: nfs4, nfs3. default: nfs3. macs is mandatory with this option", false, null)).build(), null).setShortUsage("virtualip move -virtualip vIP -virtualipend VirtualIpRangeEnd -cluster clustername -service servicename");
        removeCommand = new CLICommand("remove", "usage: virtualip remove -virtualip vIP -virtualipend VirtualIpRangeEnd -cluster clustername", VirtualIPCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)VirtualIP, (Object)new TextInputParameter(VirtualIP, VirtualIP, true, null)).put((Object)VirtualIPEnd, (Object)new TextInputParameter(VirtualIPEnd, "VirtualIpRangeEnd", false, null)).build(), null).setShortUsage("virtualip remove -virtualip vIP -virtualipend VirtualIpRangeEnd -cluster clustername");
        virtualIpsCommand = new CLICommand(VirtualIP, "virtualip [add|remove|edit|move|list]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCommand, removeCommand, editCommand, moveCommand, listCommand}).setShortUsage("virtualip [add|remove|edit|move|list]");
    }
}

