/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.AclCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.proto.SnapshotDB;
import com.mapr.fs.cldb.table.TableUtils;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbreplicator;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Marlincommon;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FidCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String FID_COMMAND_FID_PARAM_NAME = "fid";
    private static final String FID_COMMAND_ALL_REPLICAS_PARAM_NAME = "allreplicas";
    private static final String FID_COMMAND_DIR_PARAM_NAME = "dirraw";
    private static final String FID_COMMAND_KVTYPE_PARAM_NAME = "kvtype";
    private static final String FID_COMMAND_HOST_PARAM_NAME = "host";
    private static final String FID_COMMAND_PORT_PARAM_NAME = "port";
    private static final String FID_COMMAND_TABLE_PARAM_NAME = "path";
    private static final String FID_COMMAND_CID_PARAM_NAME = "cid";
    private static final String FID_COMMAND_FTYPE_PARAM_NAME = "ftype";
    private static final String FID_COMMAND_DUMPFULLKEYS_PARAM_NAME = "dumpfullkeys";
    private static final String FID_COMMAND_KEYIDXVERSION_PARAM_NAME = "keyidxversion";
    private static final String FID_STARTKEY_PARAM_NAME = "startkey";
    private static final String FID_ENDKEY_PARAM_NAME = "endkey";
    private static final String FID_MAXKEYS_PARAM_NAME = "maxkeys";
    private static final String FID_COMMAND_FID_PARAM_DESC = "fid";
    private static final String FID_COMMAND_DIR_PARAM_DESC = "scan directory inode as kvstore";
    private static final String FID_COMMAND_KVTYPE_PARAM_DESC = "cldb kvtype: cinfo|csize|cmap|fsprop|spprop|vprop|sinfo|si2scid|sc2sid|policyinfo|compositeid|spmap|cgent|hashedstring|filefilterinfo";
    private static final String FID_COMMAND_HOST_PARAM_DESC = "IP/hostname";
    private static final String FID_COMMAND_PORT_PARAM_DESC = "port";
    private static final String FID_COMMAND_TABLE_PARAM_DESC = "table path";
    private static final String FID_COMMAND_CID_PARAM_DESC = "container id";
    private static final String FID_COMMAND_FTYPE_PARAM_DESC = "table|tabletmap|tablet|segmap|spillmap";
    private static final String FID_COMMAND_DUMPFULLKEYS_PARAM_DESC = "dump full keys <true|false>";
    private static final String FID_COMMAND_KEYIDXVERSION_PARAM_DESC = "key index version";
    private static final String FID_COMMAND_ALL_REPLICAS_PARAM_DESC = "<true|false> default:false";
    public static final String MULTI_ARG_SEP = ",";
    public static final String COLUMN_SEP = ":";
    private static final Logger LOG = Logger.getLogger(FidCommands.class);
    private static Pattern printableStringName = Pattern.compile("\\p{Print}+");
    static String statUsage = "stat -fid fid";
    static String dumpUsage = "dump -fid fid";
    static String deleteStripeletUsage = "deletestripelet -fid <fid>";
    private static final int DefaultGatewayPort = 7660;
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    static final CLICommand dump = new CLICommand("dump", "Usage : " + dumpUsage, FidCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).put((Object)"startkey", (Object)new TextInputParameter("startkey", "startkey", false, null)).put((Object)"endkey", (Object)new TextInputParameter("endkey", "endkey", false, null)).put((Object)"maxkeys", (Object)new IntegerInputParameter("maxkeys", "maxkeys", false, null)).put((Object)"kvtype", (Object)new TextInputParameter("kvtype", "cldb kvtype: cinfo|csize|cmap|fsprop|spprop|vprop|sinfo|si2scid|sc2sid|policyinfo|compositeid|spmap|cgent|hashedstring|filefilterinfo", false, null)).put((Object)"dirraw", (Object)new BooleanInputParameter("dirraw", "scan directory inode as kvstore", false, Boolean.valueOf(false))).build(), null).setShortUsage(dumpUsage);
    static final CLICommand blocks = new CLICommand("blocks", "Usage : " + dumpUsage, FidCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(dumpUsage);
    static final CLICommand deleteStripeletCmd = new CLICommand("deletestripelet", "usage : " + deleteStripeletUsage, FidCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(deleteStripeletUsage).setUsageInVisible(true);
    static final CLICommand stat = new CLICommand("stat", "usage : " + statUsage, FidCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).put((Object)"allreplicas", (Object)new BooleanInputParameter("allreplicas", "<true|false> default:false", false, null)).build(), null).setShortUsage(statUsage);
    String clusterName = null;
    private static final Map<Common.FSAccessType, String> fsAccessTypeMap = new ImmutableMap.Builder().put((Object)Common.FSAccessType.AceRead, (Object)new String("readfile")).put((Object)Common.FSAccessType.AceWrite, (Object)new String("writefile")).put((Object)Common.FSAccessType.AceExecute, (Object)new String("executefile")).put((Object)Common.FSAccessType.AceReadDir, (Object)new String("readdir")).put((Object)Common.FSAccessType.AceAddChild, (Object)new String("addchild")).put((Object)Common.FSAccessType.AceDeleteChild, (Object)new String("deletechild")).put((Object)Common.FSAccessType.AceLookupDir, (Object)new String("lookupdir")).build();

    public FidCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void init() throws CLIProcessingException {
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Failed to initalize RPC");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in Rpc.initialize " + e));
            throw new CLIProcessingException("Exception in Rpc.initialize ", (Throwable)e);
        }
    }

    public long getLong(byte[] b) {
        long number = 0L;
        for (int len = b.length; len > 0; --len) {
            number <<= 8;
            number += (long)(b[len - 1] & 0xFF);
        }
        return number;
    }

    public NameEnt getNameEnt(ByteString bs, int offset) {
        NameEnt ent = new NameEnt();
        ent.cid = this.getLong(bs.substring(offset, offset + 4).toByteArray());
        ent.cinum = this.getLong(bs.substring(offset + 4, offset + 8).toByteArray());
        ent.uniq = this.getLong(bs.substring(offset + 8, offset + 12).toByteArray());
        ent.nmlen = (int)this.getLong(bs.substring(offset + 12, offset + 14).toByteArray());
        ent.name = new String(bs.substring(offset + 16, offset + 15 + ent.nmlen).toByteArray());
        byte b = bs.byteAt(offset + 15);
        ent.ftype = b & 0x1F;
        return ent;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        if (!super.validateInput()) {
            return this.output;
        }
        this.clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase("dump")) {
                return this.dump();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("stat")) {
                return this.stat();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("deletestripelet")) {
                return this.deleteStripelet();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("blocks")) {
                return this.blocks();
            }
            return new TextCommandOutput("Fid unknown sub-command".getBytes());
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private CommandOutput getDumpFromFid(Common.FidMsg fid, boolean dirraw, KVFormatType kvtype, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        KVFormatType ftype = KVFormatType.INVALID;
        if (this.isParamPresent(FID_COMMAND_FTYPE_PARAM_NAME)) {
            String ftypestr = this.getParamTextValue(FID_COMMAND_FTYPE_PARAM_NAME, 0);
            if (ftypestr.equalsIgnoreCase("table")) {
                ftype = KVFormatType.TABLE;
            } else if (ftypestr.equalsIgnoreCase("tabletmap")) {
                ftype = KVFormatType.TABLET_MAP;
            } else if (ftypestr.equalsIgnoreCase("tablet")) {
                ftype = KVFormatType.TABLET;
            } else if (ftypestr.equalsIgnoreCase("segmap")) {
                ftype = KVFormatType.SEGMENT_MAP;
            } else if (ftypestr.equalsIgnoreCase("spillmap")) {
                ftype = KVFormatType.SPILL_MAP;
            } else if (ftypestr.equalsIgnoreCase("dir")) {
                ftype = KVFormatType.DIR;
            } else if (ftypestr.equalsIgnoreCase("defermap")) {
                ftype = KVFormatType.DEFER_MAP;
            }
            if (ftype == KVFormatType.INVALID) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ftype " + ftypestr));
                this.output.setOutput(out);
                return this.output;
            }
        } else {
            Fileserver.GetattrResponse resp;
            long dbinding = this.getBindingForContainer(fid.getCid());
            if (dbinding == -1L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
                return this.output;
            }
            Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                    return this.output;
                }
                resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString((int)resp.getStatus())));
                    return this.output;
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing stat command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return this.output;
            }
            Common.FileType itype = resp.getAttr().getType();
            Common.FileSubType subtype = resp.getAttr().getSubtype();
            if (itype == Common.FileType.FTDirectory) {
                ftype = KVFormatType.DIR;
            } else if (itype == Common.FileType.FTRegular) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot dump files of itype " + itype + " subtype " + subtype));
            } else if (itype == Common.FileType.FTKvstore) {
                ftype = subtype == Common.FileSubType.FSTKvTable ? KVFormatType.TABLE : (subtype == Common.FileSubType.FSTKvTabletMap ? KVFormatType.TABLET_MAP : (subtype == Common.FileSubType.FSTKvSchema ? KVFormatType.SCHEMA_INFO : (subtype == Common.FileSubType.FSTKvTablet ? KVFormatType.TABLET : (subtype == Common.FileSubType.FSTKvSegMap ? KVFormatType.SEGMENT_MAP : (subtype == Common.FileSubType.FSTKvSpillMap ? KVFormatType.SPILL_MAP : (subtype == Common.FileSubType.FSTKvIndexTable ? KVFormatType.INDEX_TABLE : (subtype == Common.FileSubType.FSTKvXattr ? KVFormatType.XATTR : (fid.getCinum() == 22 ? KVFormatType.DEFER_MAP : (kvtype != null ? kvtype : KVFormatType.GENERIC_KV)))))))));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot dump files of itype " + itype));
                return this.output;
            }
        }
        Fileserver.KvStoreKey kstart = this.getStartKey(ftype);
        Fileserver.KvStoreKey kend = this.getEndKey(ftype);
        int maxkeys = 0;
        boolean idxoffset = false;
        boolean idxsize = false;
        if (this.isParamPresent(FID_MAXKEYS_PARAM_NAME)) {
            maxkeys = this.getParamIntValue(FID_MAXKEYS_PARAM_NAME, 0);
        }
        if (ftype == KVFormatType.DIR && !dirraw) {
            this.dumpDir(fid, out);
        } else {
            this.dumpKeyValues(fid, ftype, kstart, kend, maxkeys, out);
        }
        return this.output;
    }

    Fileserver.KvStoreKey getStartKey(KVFormatType kvtype) throws CLIProcessingException {
        if (!this.isParamPresent(FID_STARTKEY_PARAM_NAME)) {
            return null;
        }
        String kstartstr = this.getParamTextValue(FID_STARTKEY_PARAM_NAME, 0);
        return this.getKvStoreKey(kvtype, kstartstr);
    }

    Fileserver.KvStoreKey getEndKey(KVFormatType kvtype) throws CLIProcessingException {
        if (!this.isParamPresent(FID_ENDKEY_PARAM_NAME)) {
            return null;
        }
        String endstr = this.getParamTextValue(FID_ENDKEY_PARAM_NAME, 0);
        return this.getKvStoreKey(kvtype, endstr);
    }

    Fileserver.KvStoreKey getKvStoreKey(KVFormatType kvtype, String keyStr) {
        Fileserver.KvStoreKey kstart = null;
        switch (kvtype) {
            case MFS_SNAP_ID2_CID: 
            case CLDB_CID_MAP: 
            case CLDB_CG_INFO: 
            case CLDB_SP_MAP: 
            case CLDB_FS_PROP: {
                kstart = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.LongKey).setLongKey(Long.parseLong(keyStr)).build();
                break;
            }
            case CLDB_VOLUME_NAME: {
                ByteString bstr = this.prepareVarKey(keyStr);
                if (bstr == null) {
                    return null;
                }
                kstart = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(bstr).build();
                break;
            }
            default: {
                kstart = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.UintKey).setIntKey(Integer.parseInt(keyStr)).build();
            }
        }
        return kstart;
    }

    private CommandOutput blocks() throws CLIProcessingException {
        long dbinding;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        long offset = 0L;
        String fidstr = this.getParamTextValue("fid", 0);
        Common.FidMsg fid = MapRCliUtil.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((dbinding = this.getBindingForContainer(fid.getCid())) == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        while (true) {
            LOG.error((Object)("Scan file clusters from offset " + offset));
            Fileserver.ScanFileClustersRequest req = Fileserver.ScanFileClustersRequest.newBuilder().setFid(fid).setForOffload(true).setOffset(offset).setCreds(this.getUserCredentials()).build();
            Fileserver.ScanFileClustersResponse resp = null;
            try {
                byte[] replyData = null;
                replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.FileClusterScanProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "FileClusterScanProc rpc failed"));
                    return output;
                }
                resp = Fileserver.ScanFileClustersResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "FileClusterScanProc failed, Error : " + Errno.toString((int)resp.getStatus())));
                    return output;
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing blocks command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return output;
            }
            long last = 0L;
            if (resp.getOwnedBlocksCount() == 0) break;
            for (Fileserver.OwnedBlocks blks : resp.getOwnedBlocksList()) {
                CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", blks.getOffset()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", blks.getLen()));
                out.addNode(dout);
                last = blks.getOffset() + (long)blks.getLen();
            }
            if (!resp.getHasMore()) break;
            offset = last + 65536L;
        }
        return output;
    }

    private CommandOutput dump() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fidstr = this.getParamTextValue("fid", 0);
        Common.FidMsg fid = MapRCliUtil.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        boolean dirraw = false;
        String kvtypeStr = null;
        KVFormatType kvtype = null;
        if (this.isParamPresent(FID_COMMAND_DIR_PARAM_NAME)) {
            dirraw = this.getParamBooleanValue(FID_COMMAND_DIR_PARAM_NAME, 0);
            kvtype = KVFormatType.GENERIC_KV;
        }
        if (this.isParamPresent(FID_COMMAND_KVTYPE_PARAM_NAME)) {
            kvtypeStr = this.getParamTextValue(FID_COMMAND_KVTYPE_PARAM_NAME, 0);
            if (kvtypeStr.equals("cinfo")) {
                kvtype = KVFormatType.CLDB_CONTAINER_INFO;
            } else if (kvtypeStr.equals("csize")) {
                kvtype = KVFormatType.CLDB_CONTAINER_SIZE_INFO;
            } else if (kvtypeStr.equals("cmap")) {
                kvtype = KVFormatType.CLDB_CID_MAP;
            } else if (kvtypeStr.equals("fsprop")) {
                kvtype = KVFormatType.CLDB_FS_PROP;
            } else if (kvtypeStr.equals("spprop")) {
                kvtype = KVFormatType.CLDB_SP_PROP;
            } else if (kvtypeStr.equals("sinfo")) {
                kvtype = KVFormatType.CLDB_SNAPSHOT_INFO;
            } else if (kvtypeStr.equals("vname")) {
                kvtype = KVFormatType.CLDB_VOLUME_NAME;
            } else if (kvtypeStr.equals("vprop")) {
                kvtype = KVFormatType.CLDB_VOLUME_PROP;
            } else if (kvtypeStr.equals("vaces")) {
                kvtype = KVFormatType.CLDB_VOLUME_ACES;
            } else if (kvtypeStr.equals("vquota")) {
                kvtype = KVFormatType.CLDB_VOLUME_QUOTA;
            } else if (kvtypeStr.equals("smap")) {
                kvtype = KVFormatType.MFS_SNAP_MAP;
            } else if (kvtypeStr.equals("si2scid")) {
                kvtype = KVFormatType.MFS_SNAP_ID2_CID;
            } else if (kvtypeStr.equals("sc2sid")) {
                kvtype = KVFormatType.MFS_SNAP_CID2_ID;
            } else if (kvtypeStr.equals("spmap")) {
                kvtype = KVFormatType.CLDB_SP_MAP;
            } else if (kvtypeStr.equals("policyinfo")) {
                kvtype = KVFormatType.POLICYSERVER_POLICY_INFO;
            } else if (kvtypeStr.equals("compositeid")) {
                kvtype = KVFormatType.POLICYSERVER_COMPOSITE_ID_INFO;
            } else if (kvtypeStr.equals("filefilterinfo")) {
                kvtype = KVFormatType.FILE_FILTER_INFO;
            } else if (kvtypeStr.equals("cgent")) {
                kvtype = KVFormatType.CLDB_CG_INFO;
            } else if (kvtypeStr.equals("hashedstring")) {
                kvtype = KVFormatType.HASHED_STRING;
            }
        }
        if (this.isParamPresent(FID_COMMAND_DIR_PARAM_NAME)) {
            dirraw = this.getParamBooleanValue(FID_COMMAND_DIR_PARAM_NAME, 0);
        }
        this.getDumpFromFid(fid, dirraw, kvtype, out);
        return output;
    }

    private CommandOutput stat() throws CLIProcessingException {
        CLDBProto.ContainerLookupResponse clresp;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int version = this.getVersion();
        String fidstr = this.getParamTextValue("fid", 0);
        Common.FidMsg fid = MapRCliUtil.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        boolean askAllReplicas = false;
        if (this.isParamPresent(FID_COMMAND_ALL_REPLICAS_PARAM_NAME)) {
            askAllReplicas = this.getParamBooleanValue(FID_COMMAND_ALL_REPLICAS_PARAM_NAME, 0);
        }
        if ((clresp = this.getContainerLookupResp(fid.getCid())) == null || clresp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).build();
        int numBindings = 1;
        if (askAllReplicas) {
            numBindings = clresp.getContainers(0).getAServersCount();
        }
        CLDBProto.ContainerInfo cInfo = clresp.getContainers(0);
        for (int i = 0; i < numBindings; ++i) {
            Common.Server server = cInfo.getAServers(i);
            long dbinding = Rpc.createBindingFor((int)server.getIps(0).getHost(), (int)server.getIps(0).getPort(), (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    LOG.error((Object)"Got null reply from RPC");
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                    return output;
                }
                Fileserver.GetattrResponse resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) {
                    CommandOutput.OutputHierarchy.OutputNode dout = this.formatOutputNode(resp, server);
                    if (fid.getCinum() == 23 && this.isNameContainer(fid.getCid())) {
                        if (resp.getAttr().getType() != Common.FileType.FTKvstore || !resp.getAttr().getCanCompress() && !resp.getAttr().getEnforcePolicy()) {
                            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("enforcementmode", (Object)"None"));
                        } else {
                            String enforcementMode = Util.getVolumeEnforcementModeName((boolean)resp.getAttr().getEnforcePolicy(), (boolean)resp.getAttr().getCanCompress(), (boolean)false);
                            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("enforcementmode", (Object)enforcementMode));
                        }
                    }
                    out.addNode(dout);
                    continue;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed for host " + Util.intToIp((int)server.getIps(0).getHost()) + COLUMN_SEP + server.getIps(0).getPort() + ", Error : " + Errno.toString((int)resp.getStatus())));
                continue;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing stat command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
            }
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatOutputNode(Fileserver.GetattrResponse resp, Common.Server server) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode(FID_COMMAND_HOST_PARAM_NAME, (Object)(Util.intToIp((int)server.getIps(0).getHost()) + COLUMN_SEP + server.getIps(0).getPort())));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)resp.getAttr().getType(), this.version.intValue()));
        String subtype = FidCommands.printableSubType(resp.getAttr().getType(), resp.getAttr().getSubtype());
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("subtype", (Object)subtype));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("parent", (Object)FidCommands.printableFid(resp.getAttr().getParent())));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("size", resp.getAttr().getSize()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nblocks", resp.getAttr().getNblocks()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("lblocks", resp.getAttr().getLBlocks()));
        String cs = "off";
        if (resp.getAttr().getCanCompress()) {
            cs = FidCommands.getCompressionType(Common.FileCompressionType.valueOf((int)resp.getAttr().getCompressorType()));
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("compression", (Object)cs));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteFlags", (Object)resp.getAttr().getDeleteFlags()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("atime", resp.getAttr().getAtime().getSec()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mtime", resp.getAttr().getMtime().getSec()));
        int mode = resp.getAttr().getMode();
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mode", (Object)Integer.toOctalString(mode)));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("uid", resp.getAttr().getUid()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("gid", resp.getAttr().getGid()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nlink", resp.getAttr().getNlink()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("xattrInum", resp.getAttr().getXattrInum()));
        if (resp.getAttr().hasVersion()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", resp.getAttr().getVersion()));
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("networkencryption", (Object)resp.getAttr().getWireSecurityEnabled()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("diskflush", (Object)resp.getAttr().getDiskFlushEnabled()));
        if (resp.getAttr().hasXattrs()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("xattrs", (Object)FidCommands.dumpInlineXAttrs(resp.getAttr().getXattrs())));
        }
        if (resp.getAttr().hasNBtreeLevels()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nlevels", resp.getAttr().getNBtreeLevels()));
        }
        if (resp.getAttr().hasCompositePolicyId()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("compositepolicyid", resp.getAttr().getCompositePolicyId()));
        }
        return dout;
    }

    private CommandOutput deleteStripelet() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int version = this.getVersion();
        String fidstr = this.getParamTextValue("fid", 0);
        Common.FidMsg fid = MapRCliUtil.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        long dbinding = this.getBindingForContainer(fid.getCid());
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        Fileserver.DeleteStripeletRequest req = Fileserver.DeleteStripeletRequest.newBuilder().addStripelets(Fileserver.StripeletInfo.newBuilder().setFid(fid).build()).setIsManualRepair(true).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.DeleteStripeletProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "DeleteStripelet rpc failed"));
                return output;
            }
            Fileserver.DeleteStripeletResponse resp = Fileserver.DeleteStripeletResponse.parseFrom((byte[])replyData);
            CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
            if (resp.getStatus() == 0) {
                LOG.info((Object)("manual deletestripelet done succesfully" + fidstr));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "DeletStripelet failed, Error : " + Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing deletestripelet command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput getHostNames() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int version = this.getVersion();
        String ipStr = this.getParamTextValue(FID_COMMAND_HOST_PARAM_NAME, 0);
        Common.IPAddress gatewayIp = this.buildIPFromString(ipStr);
        if (gatewayIp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid gateway host " + ipStr));
            output.setOutput(out);
            return output;
        }
        int gatewayPort = this.getParamIntValue("port", 0);
        long dbinding = this.getBindingForGateway(gatewayIp.getHost(), gatewayPort);
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Gateway connect failed"));
            return output;
        }
        Dbreplicator.GetHostNamesRequest req = Dbreplicator.GetHostNamesRequest.newBuilder().setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBReplicatorServerProgramId.getNumber(), (int)Dbreplicator.DBReplicatorProg.GetHostNamesProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "gethostnames rpc failed"));
                return output;
            }
            Dbreplicator.GetHostNamesResponse resp = Dbreplicator.GetHostNamesResponse.parseFrom((byte[])replyData);
            CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
            if (resp.getStatus() == 0) {
                for (String name : resp.getNamesList()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("HostNames", (Object)name));
                }
                out.addNode(dout);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetHostNames failed, Error : " + Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing getHostNames command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
        }
        output.setOutput(out);
        return output;
    }

    private boolean isNameContainer(int cid) throws CLIProcessingException {
        CLDBProto.ContainerLookupRequest creq = CLDBProto.ContainerLookupRequest.newBuilder().addContainerId(cid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)creq, CLDBProto.ContainerLookupResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                throw new CLIProcessingException("Couldn't connect to CLDB");
            }
            CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() == 0) {
                return resp.getContainers(0).getNameContainer();
            }
            LOG.error((Object)("Container lookup failed : Error " + Errno.toString((int)resp.getStatus())));
            throw new CLIProcessingException("Container lookup failed ");
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception Exception", (Throwable)e);
        }
    }

    private CLDBProto.ContainerLookupResponse getContainerLookupResp(int cid) throws CLIProcessingException {
        CLDBProto.ContainerLookupRequest creq = CLDBProto.ContainerLookupRequest.newBuilder().addContainerId(cid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)creq, CLDBProto.ContainerLookupResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                return null;
            }
            CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
            return resp;
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Container lookup failed");
            return null;
        }
    }

    private long getBindingForContainer(int cid) throws CLIProcessingException {
        CLDBProto.ContainerLookupResponse resp = this.getContainerLookupResp(cid);
        if (resp == null || resp.getStatus() != 0) {
            return -1L;
        }
        Common.Server server = resp.getContainers(0).getMServer();
        int dbHost = server.getIps(0).getHost();
        int dbPort = server.getIps(0).getPort();
        return Rpc.createBindingFor((int)dbHost, (int)dbPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    private ByteString binaryKeyToByteString(String raws) {
        byte[] bArr = BinaryString.toBytesBinary((String)raws);
        return ByteString.copyFrom((byte[])bArr);
    }

    private ByteString prepareVarKey(String raws) {
        return this.binaryKeyToByteString(raws);
    }

    private CommandOutput.OutputHierarchy.OutputNode formatDirEntry(MapRFileStatus d) {
        String childFid = d.getCid() + "." + d.getCinum() + "." + d.getUniq();
        String s = d.getPath().toString();
        int l = s.lastIndexOf(47);
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("name", (Object)s.substring(l + 1)));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)childFid));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isDir", (Object)d.isDir()));
        return dout;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatKeyMapEntry(Dbserver.KeyMapEntry ent) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        Object bs = null;
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("shared", ent.getSharedLen()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nonshared", ent.getNonsharedLen()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", ent.getValueLen()));
        if (ent.hasBlkOff()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("childblockoffset", ent.getBlkOff()));
        }
        if (ent.hasBlkSize()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("childblocksize", ent.getBlkSize()));
        }
        if (!ent.hasBlkOff() && !ent.hasBlkSize()) {
            try {
                Dbserver.SpillKeyEntry spillVal = ent.hasKvalue() ? ent.getKvalue() : Dbserver.SpillKeyEntry.parseFrom((ByteString)ent.getValue());
                if (spillVal.hasInlineValue()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlineValue", (Object)this.printableKey(spillVal.getInlineValue().toByteArray())));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlineValueSz", spillVal.getInlineValue().size()));
                }
                int cnt = spillVal.getValuesCount();
                for (int index = 0; index < cnt; ++index) {
                    CommandOutput.OutputHierarchy.OutputNode valueout = new CommandOutput.OutputHierarchy.OutputNode("familyData");
                    boolean addFamily = false;
                    Dbserver.SpillKeyEntry.FamilyValue fv = spillVal.getValues(index);
                    if (fv.hasId()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", fv.getId()));
                        addFamily = true;
                    }
                    if (fv.hasOffset()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", fv.getOffset()));
                        addFamily = true;
                    }
                    if (fv.hasLength()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", fv.getLength()));
                        addFamily = true;
                    }
                    if (fv.hasInlined()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlined", (Object)fv.getInlined()));
                        addFamily = true;
                    }
                    if (!addFamily) continue;
                    dout.addChild(valueout);
                }
            }
            catch (Throwable e) {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("error", (Object)"PARSE ERROR"));
            }
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(ent.getKey().toByteArray())));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", (Object)this.printableKey(ent.getValue().toByteArray())));
        return dout;
    }

    private void dumpIPAddress(String val, Common.IPAddress ip, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode ipOut = new CommandOutput.OutputHierarchy.OutputNode(val);
        out.addChild(ipOut);
        if (ip.hasHost()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)(Util.intToIp((int)ip.getHost()) + COLUMN_SEP + ip.getPort())));
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode(FID_COMMAND_HOST_PARAM_NAME, ip.getHost()));
        }
        if (ip.hasPort()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("port", ip.getPort()));
        }
        if (ip.hasSyncReplica()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("syncReplica", (Object)ip.getSyncReplica()));
        }
        if (ip.hasEpoch()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("epoc", ip.getEpoch()));
        }
        if (ip.hasHostname()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostname", (Object)ip.getHostname()));
        }
        if (ip.hasState()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("state", (Object)ip.getState()));
        }
        if (ip.hasResync()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("resync", (Object)ip.getResync()));
        }
        if (ip.hasVirtualIP()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("virtualip", ip.getVirtualIP()));
        }
    }

    private void dumpServer(String val, Common.Server s, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode sout = new CommandOutput.OutputHierarchy.OutputNode(val);
        out.addChild(sout);
        if (s.hasServerId()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("serverId", s.getServerId()));
        }
        if (s.hasSyncReplica()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("syncReplica", (Object)s.getSyncReplica()));
        }
        if (s.hasEpoch()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("epoch", s.getEpoch()));
        }
        if (s.hasState()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("state", (Object)s.getState()));
        }
        if (s.hasResync()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("resync", (Object)s.getResync()));
        }
        if (s.hasHostname()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostname", (Object)s.getHostname()));
        }
        if (s.hasFixedByFsck()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fixedByFsck", (Object)s.getFixedByFsck()));
        }
        if (s.hasChosenSp()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("chosensp", (Object)s.getChosenSp()));
        }
        if (s.hasTopology()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("topology", (Object)s.getTopology()));
        }
        if (s.hasDeleteAfterRepl()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteafterrepl", (Object)s.getDeleteAfterRepl()));
        }
        if (s.hasPliId()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("pliid", s.getPliId()));
        }
        if (s.hasSpInfo()) {
            Common.StoragePoolInfo sp = s.getSpInfo();
            CommandOutput.OutputHierarchy.OutputNode si = new CommandOutput.OutputHierarchy.OutputNode("spInfo: ");
            sout.addChild(si);
            if (sp.hasSpId()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("spId", (Object)sp.getSpId()));
            }
            if (sp.hasClusterUuid()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("clusterUuid H", sp.getClusterUuid().getId640()));
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("clusterUuid L", sp.getClusterUuid().getId641()));
            }
            if (sp.hasCapacitySizeMB()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("capacitysizemb", sp.getCapacitySizeMB()));
            }
            if (sp.hasUsedSizeMB()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("usedsizemb", sp.getUsedSizeMB()));
            }
            if (sp.hasAvailableSizeMB()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("availablesizemb", sp.getAvailableSizeMB()));
            }
            if (sp.hasOnlineCount()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("onlineCount", sp.getOnlineCount()));
            }
        }
        if (s.getSecondaryPortsCount() != 0) {
            int k = 0;
            Iterator iterator = s.getSecondaryPortsList().iterator();
            while (iterator.hasNext()) {
                int port = (Integer)iterator.next();
                sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("secPort" + k, port));
                ++k;
            }
        }
        if (s.getIpsCount() != 0) {
            int k = 0;
            for (Common.IPAddress ip : s.getIpsList()) {
                this.dumpIPAddress("ip" + k, ip, sout);
                ++k;
            }
        }
        if (s.hasCtime() && s.getCtime() != 0) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ctime ", s.getCtime()));
        }
    }

    private void dumpServers(String stypeStr, List<Common.Server> slist, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode ssOut = new CommandOutput.OutputHierarchy.OutputNode(stypeStr);
        out.addChild(ssOut);
        int i = 0;
        for (Common.Server s : slist) {
            this.dumpServer("Server" + i, s, ssOut);
        }
    }

    private void dumpContainerInfo(CLDBProto.ContainerInfo ci, CommandOutput.OutputHierarchy.OutputNode out) {
        if (ci.hasVolumeId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volid", ci.getVolumeId()));
        }
        if (ci.hasContainerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("cid ", ci.getContainerId()));
        }
        if (ci.hasVolumeId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId ", ci.getVolumeId()));
        }
        if (ci.hasSnapshotId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapId ", ci.getSnapshotId()));
        }
        if (ci.hasLatestEpoch()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("latestEpoch ", ci.getLatestEpoch()));
        }
        if (ci.hasRwContainerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("rwCid ", ci.getRwContainerId()));
        }
        if (ci.hasRwVolumeId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("rwVolId ", ci.getRwVolumeId()));
        }
        if (ci.hasNameContainer()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("isNameContainer ", (Object)ci.getNameContainer()));
        }
        if (ci.hasMirrorContainer()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("mirrorCid ", ci.getMirrorContainer()));
        }
        if (ci.hasType()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ReplType ", (Object)ci.getType()));
        }
        if (ci.hasLogicalSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("logicalSzMB ", ci.getLogicalSizeMB()));
        }
        if (ci.hasChainSeqNumber()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("chainSeqNumber ", ci.getChainSeqNumber()));
        }
        if (ci.hasOwnedSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ownedSzMB ", ci.getOwnedSizeMB()));
        }
        if (ci.hasSharedSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("sharedSzMB ", ci.getSharedSizeMB()));
        }
        if (ci.hasFixedByFsck()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("isFixedByFsck ", (Object)ci.getFixedByFsck()));
        }
        if (ci.hasMtime()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("mtime ", ci.getMtime()));
        }
        if (ci.hasChainSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("chainSzMB ", ci.getChainSizeMB()));
        }
        if (ci.hasHasForcedMaster()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("hasForcedMaster ", (Object)ci.getHasForcedMaster()));
        }
        if (ci.hasNumInumUsed()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numinumused ", ci.getNumInumUsed()));
        }
        if (ci.hasSalt()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("salt ", (Object)ci.getSalt()));
        }
        if (ci.hasCreatorContainerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("creatorCid ", ci.getCreatorContainerId()));
        }
        if (ci.hasCreatorVolumeUuid()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("creatorVolumeId H", ci.getCreatorVolumeUuid().getId640()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("creatorVolumeId L", ci.getCreatorVolumeUuid().getId641()));
        }
        if (ci.hasUseActualCreatorId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("useActualCreatorId ", (Object)ci.getUseActualCreatorId()));
        }
        if (ci.hasSnapshotsOwnedSize()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapOSize ", ci.getSnapshotsOwnedSize()));
        }
        if (ci.hasMServer()) {
            this.dumpServer("Master", ci.getMServer(), out);
        }
        if (ci.getAServersCount() != 0) {
            this.dumpServers("active: ", ci.getAServersList(), out);
        }
        if (ci.getIServersCount() != 0) {
            this.dumpServers("inactive: ", ci.getIServersList(), out);
        }
        if (ci.getUServersCount() != 0) {
            this.dumpServers("unused", ci.getUServersList(), out);
        }
        if (ci.getUnreachableServersCount() != 0) {
            this.dumpServers("unreachable", ci.getUnreachableServersList(), out);
        }
        if (ci.hasEcCgId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ecCgId ", ci.getEcCgId()));
        }
    }

    private void dumpContainerInfo(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.ContainerInfo ci = CLDBProto.ContainerInfo.parseFrom((ByteString)val);
            this.dumpContainerInfo(ci, out);
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
        }
    }

    private void dumpContainerSizeInfo(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.ContainerSizeInfo csi = CLDBProto.ContainerSizeInfo.parseFrom((ByteString)val);
            if (csi.hasContainerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerId", csi.getContainerId()));
            }
            if (csi.hasVolumeId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volumeId", csi.getVolumeId()));
            }
            if (csi.hasSnapshotId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapshotID", csi.getSnapshotId()));
            }
            if (csi.hasLogicalSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("logcialSizeMB", csi.getLogicalSizeMB()));
            }
            if (csi.hasOwnedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ownedSizeMB", csi.getOwnedSizeMB()));
            }
            if (csi.hasSharedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("sharedSizeMB", csi.getSharedSizeMB()));
            }
            if (csi.hasMtime()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("mtime", csi.getMtime()));
            }
            if (csi.hasChainSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("chainSizeMB", csi.getChainSizeMB()));
            }
            if (csi.hasNumInumUsed()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numInodeSize", csi.getNumInumUsed()));
            }
            if (csi.hasSnapshotsOwnedSize()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapOwned", csi.getSnapshotsOwnedSize()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FID_COMMAND_CID_PARAM_NAME, (Object)"UNKNOWN"));
        }
    }

    private void dumpCGInfo(CLDBProto.CgTableEntry cg, CommandOutput.OutputHierarchy.OutputNode out) {
        if (cg.hasContainerGroupId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CgId", cg.getContainerGroupId()));
        }
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.CgContainerInfo ci : cg.getContainersInfoList()) {
            sb.append(" ");
            sb.append(ci.getContainerId());
        }
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Containers", (Object)sb.toString()));
        if (cg.hasManager()) {
            this.dumpServer("manager", cg.getManager(), out);
        }
        if (cg.hasIsSealed()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("isSealed", (Object)cg.getIsSealed()));
        }
        if (cg.hasIsValid()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("isValid", (Object)cg.getIsValid()));
        }
        if (cg.hasNumStripes()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numStripes", cg.getNumStripes()));
        }
        if (cg.hasNumStripesInRebuild()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numStripesInRebuild", cg.getNumStripesInRebuild()));
        }
        if (cg.hasNumStripesToRecover()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumStripesToRecover", cg.getNumStripesToRecover()));
        }
        if (cg.hasState()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("State", (Object)cg.getState()));
        }
        if (cg.hasNumValidStripes()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numValidStripes", cg.getNumValidStripes()));
        }
        if (cg.getNumDegradedStripesList().size() > 0) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numDegradedStripes", cg.getNumDegradedStripesList().size()));
        }
    }

    private void dumpCGInfo(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.CgTableEntry cg = CLDBProto.CgTableEntry.parseFrom((ByteString)val);
            this.dumpCGInfo(cg, out);
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
        }
    }

    private void dumpSnapshotInfo(CLDBProto.SnapshotInfo si, CommandOutput.OutputHierarchy.OutputNode out) {
        if (si.hasSnapshotId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotId", si.getSnapshotId()));
        }
        if (si.hasRwVolumeId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RwVolid", si.getRwVolumeId()));
        }
        if (si.hasCostCentreId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CostCentreId", si.getCostCentreId()));
        }
        if (si.hasCreateTime()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CreateTime", si.getCreateTime()));
        }
        if (si.hasDeleteTime()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("DeleteTime", si.getDeleteTime()));
        }
        if (si.hasSnapshotName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotName", (Object)si.getSnapshotName()));
        }
        if (si.hasRootContainerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootContainerId", si.getRootContainerId()));
        }
        if (si.hasRwVolumeName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RwVolumeName", (Object)si.getRwVolumeName()));
        }
        if (si.hasIsMirrorSnapshot()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("IsMirrorSnapshot", (Object)si.getIsMirrorSnapshot()));
        }
        if (si.hasSnapshotInProgress()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotInProgress", (Object)si.getSnapshotInProgress()));
        }
        if (si.hasSnapshotOwnedSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotOwnedSizeMB", si.getSnapshotOwnedSizeMB()));
        }
        if (si.hasSnapshotSharedSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotSharedSizeMB", si.getSnapshotSharedSizeMB()));
        }
        if (si.hasMountDir()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MountDir", (Object)si.getMountDir()));
        }
        if (si.hasOwnerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("OwnerId", si.getOwnerId()));
        }
        if (si.hasDataSrcSnapCreateTimeMillis()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("DataSrcSnapCreateTimeMillis", si.getDataSrcSnapCreateTimeMillis()));
        }
        if (si.hasVerifier()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Verifier", si.getVerifier()));
        }
        if (si.hasSnapshotCumulativeReclaimSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotCumulativeReclaimSizeMB", si.getSnapshotCumulativeReclaimSizeMB()));
        }
        if (si.hasDeleteInProg()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("DeleteInProg", (Object)si.getDeleteInProg()));
        }
        if (si.hasRootCidGenerationId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootCidGenerationId", si.getRootCidGenerationId()));
        }
    }

    private void dumpSnapshotInfo(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.SnapshotInfo si = CLDBProto.SnapshotInfo.parseFrom((ByteString)val);
            this.dumpSnapshotInfo(si, out);
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapId", (Object)"UNKNOWN"));
        }
    }

    private void dumpVolumeProperties(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.VolumeProperties vp = CLDBProto.VolumeProperties.parseFrom((ByteString)val);
            if (vp.hasVolumeId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeId", vp.getVolumeId()));
            }
            if (vp.hasVolumeName()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeName", (Object)vp.getVolumeName()));
            }
            if (vp.hasRootContainerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootContainerId", vp.getRootContainerId()));
            }
            if (vp.hasMountDir()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MountDir", (Object)vp.getMountDir()));
            }
            if (vp.hasVolumeQuotaSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeQuotaSizeMB", vp.getVolumeQuotaSizeMB()));
            }
            if (vp.hasReadOnly()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ReadOnly", (Object)vp.getReadOnly()));
            }
            if (vp.hasMounted()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Mounted", (Object)vp.getMounted()));
            }
            if (vp.hasLocalVolume()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("LocalVolume", (Object)vp.getLocalVolume()));
            }
            if (vp.hasOwnerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("OwnerId", vp.getOwnerId()));
            }
            if (vp.hasIsMirrorVol()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("IsMirrorVol", (Object)vp.getIsMirrorVol()));
            }
            if (vp.hasSchedulingPolicyId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SchedulingPolicyId", vp.getSchedulingPolicyId()));
            }
            if (vp.hasVolumeQuotaAdvisorySizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeQuotaAdvisorySizeMB", vp.getVolumeQuotaAdvisorySizeMB()));
            }
            if (vp.hasSchedulingPolicyName()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SchedulingPolicyName", (Object)vp.getSchedulingPolicyName()));
            }
            if (vp.hasNumContainers()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumContainers", vp.getNumContainers()));
            }
            if (vp.hasNumSnapshots()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumSnapshots", vp.getNumSnapshots()));
            }
            if (vp.hasParentVolumeId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ParentVolumeId", vp.getParentVolumeId()));
            }
            if (vp.hasRootDirPerms()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootDirPerms", vp.getRootDirPerms()));
            }
            if (vp.hasRootDirUser()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootDirUser", vp.getRootDirUser()));
            }
            if (vp.hasRootDirGroup()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootDirGroup", vp.getRootDirGroup()));
            }
            if (vp.hasReReplicationTimeOutSec()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ReReplicationTimeOutSec", vp.getReReplicationTimeOutSec()));
            }
            if (vp.hasCriticalReReplicationTimeOutSec()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CriticalReReplicationTimeOutSec", vp.getCriticalReReplicationTimeOutSec()));
            }
            if (vp.hasInGfsck()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("InGfsck", (Object)vp.getInGfsck()));
            }
            if (vp.hasShuffleVolume()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ShuffleVolume", (Object)vp.getShuffleVolume()));
            }
            if (vp.hasVolumeUUID()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeUUID", vp.getVolumeUUID()));
            }
            if (vp.hasDeleteInProg()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("DeleteInProg", (Object)vp.getDeleteInProg()));
            }
            if (vp.hasNeedsGfsck()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NeedsGfsck", (Object)vp.getNeedsGfsck()));
            }
            if (vp.hasMaxInodesAlarmThreshold()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MaxInodesAlarmThreshold", vp.getMaxInodesAlarmThreshold()));
            }
            if (vp.hasMaxSizeSeenSoFar()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MaxSizeSeenSoFar", vp.getMaxSizeSeenSoFar()));
            }
            if (vp.hasNewAclFormat()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NewAclFormat", (Object)vp.getNewAclFormat()));
            }
            if (vp.hasVolumetype()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Volumetype", (Object)vp.getVolumetype()));
            }
            if (vp.hasCreatorContainerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CreatorContainerId", vp.getCreatorContainerId()));
            }
            if (vp.hasLimitVolumeSpread()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("LimitVolumeSpread", (Object)vp.getLimitVolumeSpread()));
            }
            if (vp.hasMirrorSchedulingPolicyId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MirrorSchedulingPolicyId", vp.getMirrorSchedulingPolicyId()));
            }
            if (vp.hasMirrorThrottle()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MirrorThrottle", (Object)vp.getMirrorThrottle()));
            }
            if (vp.hasNumNamespaceReplicas()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumNamespaceReplicas", vp.getNumNamespaceReplicas()));
            }
            if (vp.hasDareEnabled()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("DareEnabled", (Object)vp.getDareEnabled()));
            }
            if (vp.hasIsTierOffloadEnable()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("IsTierOffloadEnable", (Object)vp.getIsTierOffloadEnable()));
            }
            if (vp.hasNumECDataColumns()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumECDataColumns", vp.getNumECDataColumns()));
            }
            if (vp.hasNumECParityColumns()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumECParityColumns", vp.getNumECParityColumns()));
            }
            if (vp.hasEcStripeDepthMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("EcStripeDepthMB", vp.getEcStripeDepthMB()));
            }
            if (vp.hasEcContainerSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("EcContainerSizeMB", vp.getEcContainerSizeMB()));
            }
            if (vp.hasTierProps() && vp.getTierProps() != null) {
                CLDBProto.VolumeTieringProperties tp = vp.getTierProps();
                if (tp.hasTierId()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("TierId", tp.getTierId()));
                }
                if (tp.hasRuleId()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("TierRuleId", tp.getRuleId()));
                }
                if (tp.hasScheduleId()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("TierScheduleId", tp.getScheduleId()));
                }
                if (tp.hasTierEncryption()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("TierEncryption", (Object)tp.getTierEncryption()));
                }
                if (tp.hasRecallExpiryTime()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("TierRecallExpiryTime", tp.getRecallExpiryTime()));
                }
                if (tp.hasEcVolProps() && tp.getEcVolProps() != null) {
                    CLDBProto.ECVolumeProperties ep = tp.getEcVolProps();
                    if (ep.hasVolumeId()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ECVolumeId", ep.getVolumeId()));
                    }
                    if (ep.hasNumNamespaceReplicas()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ECNumNamespaceReplicas", ep.getNumNamespaceReplicas()));
                    }
                    if (ep.hasMinNamespaceReplicas()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ECMinNamespaceReplicas", ep.getMinNamespaceReplicas()));
                    }
                    if (ep.hasNumReplicas()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ECNumReplicas", ep.getNumReplicas()));
                    }
                    if (ep.hasMinReplicas()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ECMinReplicas", ep.getMinReplicas()));
                    }
                    if (ep.hasNumDataColumns()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ECNumDataColumns", ep.getNumDataColumns()));
                    }
                    if (ep.hasNumParityColumns()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ECNumParityColumns", ep.getNumParityColumns()));
                    }
                    if (ep.hasEcStripeDepthMB()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ECStripeDepth", ep.getEcStripeDepthMB()));
                    }
                }
                if (tp.hasCompactionProps() && tp.getCompactionProps() != null) {
                    CLDBProto.CompactionProperties cp = tp.getCompactionProps();
                    if (cp.hasScheduleId()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Compac-ScheduleId", cp.getScheduleId()));
                    }
                    if (cp.hasOverheadPercentage()) {
                        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Compac-OverheadPercentage", cp.getOverheadPercentage()));
                    }
                }
            }
            if (vp.hasTierRelationships() && vp.getTierRelationships() != null) {
                CLDBProto.TierRelationships tr = vp.getTierRelationships();
                if (tr.hasBackendVolumeType()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BackendVolumeType", (Object)tr.getBackendVolumeType()));
                }
                if (tr.hasFrontendVolumeId()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("FrontendVolumeId", tr.getFrontendVolumeId()));
                }
                if (tr.hasBackendCacheVolumeId()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BackendCacheVolumeId", tr.getBackendCacheVolumeId()));
                }
                if (tr.hasBackendEcVolumeId()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BackendEcVolumeId", tr.getBackendEcVolumeId()));
                }
            }
            if (vp.hasSkipWireSecurityForTierInternalOps()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("WLS for internal Ops for backend volume", (Object)vp.getSkipWireSecurityForTierInternalOps()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId", (Object)"UNKNOWN"));
        }
    }

    private void dumpVolumeQuota(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.VolumeQuotaInfo vq = CLDBProto.VolumeQuotaInfo.parseFrom((ByteString)val);
            if (vq.hasCostCenterId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CostCenterId", vq.getCostCenterId()));
            }
            if (vq.hasVolumeQuotaSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeQuotaSizeMB", vq.getVolumeQuotaSizeMB()));
            }
            if (vq.hasVolumeUsedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeUsedSizeMB", vq.getVolumeUsedSizeMB()));
            }
            if (vq.hasVolumeAdvisoryQuotaSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeAdvisoryQuotaSizeMB", vq.getVolumeAdvisoryQuotaSizeMB()));
            }
            if (vq.hasVolumeLogicalUsedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeLogicalUsedSizeMB", vq.getVolumeLogicalUsedSizeMB()));
            }
            if (vq.hasVolumeOwnedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeOwnedSizeMB", vq.getVolumeOwnedSizeMB()));
            }
            if (vq.hasVolumeSharedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeSharedSizeMB", vq.getVolumeSharedSizeMB()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId", (Object)"UNKNOWN"));
        }
    }

    private void dumpVolumeAces(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            Common.VolumeAces va = Common.VolumeAces.parseFrom((ByteString)val);
            if (va.getAcesCount() != 0) {
                int k = 0;
                for (Common.VolumeAceEntry vae : va.getAcesList()) {
                    CommandOutput.OutputHierarchy.OutputNode aeOut = new CommandOutput.OutputHierarchy.OutputNode("ace" + k);
                    out.addChild(aeOut);
                    if (vae.hasExpr()) {
                        aeOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("expr", (Object)vae.getExpr()));
                    }
                    if (vae.hasAccessType()) {
                        aeOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("accessType", (Object)vae.getAccessType()));
                    }
                    ++k;
                }
            }
            CommandOutput.OutputHierarchy.OutputNode pbsOut = new CommandOutput.OutputHierarchy.OutputNode("SecurityPolicyAccessControl");
            out.addChild(pbsOut);
            if (va.getPolicyIdsCount() > 0) {
                pbsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("PolicyIds", (Object)Arrays.toString(va.getPolicyIdsList().toArray())));
            }
            if (va.getPolicyNamesCount() > 0) {
                pbsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("PolicyNames", (Object)Arrays.toString(va.getPolicyNamesList().toArray())));
            }
            if (va.hasEnforceAces()) {
                pbsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("enforceAces", (Object)va.getEnforceAces()));
            }
            if (va.hasEnforcePolicies()) {
                pbsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("enforcePolicies", (Object)va.getEnforcePolicies()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId", (Object)"UNKNOWN"));
        }
    }

    private void dumpVolumeTableId(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.VolumeTableId vp = CLDBProto.VolumeTableId.parseFrom((ByteString)val);
            if (vp.hasVolumeId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeId", vp.getVolumeId()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId", (Object)"UNKNOWN"));
        }
    }

    private void dumpSnapIdToSnapcidMapEntry(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            SnapshotDB.SnapIdToSnapcidMapEntry sme = SnapshotDB.SnapIdToSnapcidMapEntry.parseFrom((ByteString)val);
            if (sme.hasBlockCount()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BlockCount", sme.getBlockCount()));
            }
            if (sme.hasGenerationId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("GenerationId", sme.getGenerationId()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapId", (Object)"UNKNOWN"));
        }
    }

    private void dumpSnapcidToSnapIdMapEntry(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            SnapshotDB.SnapcidToSnapIdMapEntry sme = SnapshotDB.SnapcidToSnapIdMapEntry.parseFrom((ByteString)val);
            if (sme.hasSnapshotId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotId", sme.getSnapshotId()));
            }
            if (sme.hasBlockCount()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BlockCount", sme.getBlockCount()));
            }
            if (sme.hasGenerationId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("GenerationId", sme.getGenerationId()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapId", (Object)"UNKNOWN"));
        }
    }

    private void dumpSPMap(byte[] bArr, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            Long[] parts = new Long[3];
            TableUtils.getSPContainerMapKeyParts((byte[])bArr, (Long[])parts);
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spIdx", parts[0].intValue()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId", parts[1].intValue()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FID_COMMAND_CID_PARAM_NAME, parts[2].intValue()));
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spIdx:volId:cid", (Object)"UNKNOWN"));
        }
    }

    private void dumpUint32(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        BigInteger bi = new BigInteger(val.toByteArray());
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("u32", Integer.reverseBytes(bi.intValue())));
    }

    private void dumpMfsNodeConfiguration(CLDBProto.MfsNodeConfiguration nc, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode ncOut = new CommandOutput.OutputHierarchy.OutputNode("MfsNodeConfig");
        out.addChild(ncOut);
        if (nc.hasNumCpus()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumCpus", nc.getNumCpus()));
        }
        if (nc.hasAvailableMemory()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("AvailableMemory", nc.getAvailableMemory()));
        }
        if (nc.hasNumSps()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumSps", nc.getNumSps()));
        }
        if (nc.hasNumInstances()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumInstances", nc.getNumInstances()));
        }
        if (nc.hasNumSSDSps()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumSSDSps", nc.getNumSSDSps()));
        }
    }

    private void dumpMfsInstancesInfo(CLDBProto.MfsInstancesInfo ii, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode iiOut = new CommandOutput.OutputHierarchy.OutputNode("MfsInstancesInfo");
        out.addChild(iiOut);
        if (ii.hasNumSpsPerInstance()) {
            iiOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumSpsPerInstance", ii.getNumSpsPerInstance()));
        }
        if (ii.hasNumInstances()) {
            iiOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumInstances", ii.getNumInstances()));
        }
        if (ii.hasNumReportedInstances()) {
            iiOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumReportedInstances", ii.getNumReportedInstances()));
        }
        if (ii.hasMemoryPerInstance()) {
            iiOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("MemoryPerInstance", ii.getMemoryPerInstance()));
        }
    }

    private void dumpFSProperties(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            int k;
            CLDBProto.FileServerProperties fsp = CLDBProto.FileServerProperties.parseFrom((ByteString)val);
            if (fsp.hasServerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("serverId", fsp.getServerId()));
            }
            if (fsp.hasTopology()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Topology", (Object)fsp.getTopology()));
            }
            if (fsp.hasHostname()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Hostname", (Object)fsp.getHostname()));
            }
            if (fsp.getIpsCount() != 0) {
                k = 0;
                for (Common.IPAddress ip : fsp.getIpsList()) {
                    this.dumpIPAddress("ip" + k, ip, out);
                    ++k;
                }
            }
            if (fsp.getSpIdsCount() != 0) {
                k = 0;
                for (String spid : fsp.getSpIdsList()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spid" + k, (Object)Util.expandSpId((String)spid)));
                    ++k;
                }
            }
            if (fsp.getSecondaryPortsCount() != 0) {
                k = 0;
                Iterator iterator = fsp.getSecondaryPortsList().iterator();
                while (iterator.hasNext()) {
                    int port = (Integer)iterator.next();
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("secPort" + k, port));
                    ++k;
                }
            }
            if (fsp.hasNodeConfiguration()) {
                this.dumpMfsNodeConfiguration(fsp.getNodeConfiguration(), out);
            }
            if (fsp.hasMfsInstancesInfo()) {
                this.dumpMfsInstancesInfo(fsp.getMfsInstancesInfo(), out);
            }
            if (fsp.hasBuildVersion()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BuildVersion", (Object)fsp.getBuildVersion()));
            }
            if (fsp.hasPatchVersion()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("PatchVersion", (Object)fsp.getPatchVersion()));
            }
            if (fsp.hasMarkMaintenanceTime()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MarkMaintenanceTime", fsp.getMarkMaintenanceTime()));
            }
            if (fsp.hasMarkMaintenanceTimeOutMin()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MarkMaintenanceTimeOutMin", fsp.getMarkMaintenanceTimeOutMin()));
            }
            if (fsp.hasBadServerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BadServerId", (Object)fsp.getBadServerId()));
            }
            if (fsp.hasBlockMovesOut()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BlockMovesOut", (Object)fsp.getBlockMovesOut()));
            }
            if (fsp.hasBlockMovesIn()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BlockMovesIn", (Object)fsp.getBlockMovesIn()));
            }
            if (fsp.hasMaxContainers()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MaxContainers", fsp.getMaxContainers()));
            }
            if (fsp.hasTopologyIncludesInstance()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("TopologyIncludesInstance", (Object)fsp.getTopologyIncludesInstance()));
            }
            if (fsp.hasPliId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("PliId", fsp.getPliId()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("fsid", (Object)"UNKNOWN"));
        }
    }

    private void dumpSPProperties(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.StoragePoolProperties spp = CLDBProto.StoragePoolProperties.parseFrom((ByteString)val);
            if (spp.hasSpid()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spid", (Object)Util.expandSpId((String)spp.getSpid())));
            }
            if (spp.hasServerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("serverId", spp.getServerId()));
            }
            if (spp.hasDeleteInProg()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteInProg", (Object)spp.getDeleteInProg()));
            }
            if (spp.hasRefillInProgress()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("refillInProgress", (Object)spp.getRefillInProgress()));
            }
            if (spp.hasLabelId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("labelId", spp.getLabelId()));
            }
            if (spp.hasSpCntrOnImprovedFanoutTable()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spCntrOnImprovedFanoutTable", (Object)spp.getSpCntrOnImprovedFanoutTable()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spid", (Object)"UNKNOWN"));
        }
    }

    private void dumpKvStoreKey(Fileserver.KvStoreKey ksk, CommandOutput.OutputHierarchy.OutputNode out) {
        if (ksk.hasIntKey()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", ksk.getIntKey()));
        } else if (ksk.hasLongKey()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", ksk.getLongKey()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("hexKey", (Object)Long.toHexString(ksk.getLongKey())));
        } else {
            ByteString bs = ksk.getVarKey();
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(bs.toByteArray())));
        }
    }

    private static CommandOutput.OutputHierarchy.OutputNode dumpFileACEs(ByteString xval) {
        CommandOutput.OutputHierarchy.OutputNode aceOut = new CommandOutput.OutputHierarchy.OutputNode("ace");
        try {
            Common.FileACEs face = Common.FileACEs.parseFrom((byte[])xval.toByteArray());
            if (face.hasNoInherit()) {
                aceOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("noInherit", (Object)face.getNoInherit()));
            }
            if (face.hasPreserveModeBits()) {
                aceOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("preserveModeBits", (Object)face.getPreserveModeBits()));
            }
            for (Common.FileACE a : face.getAcesList()) {
                aceOut.addChild(new CommandOutput.OutputHierarchy.OutputNode(fsAccessTypeMap.get(a.getAccessType()), (Object)AceHelper.toInfix((String)a.getBoolExp().toStringUtf8())));
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception processing dumpFileACEs InvalidProtocolBufferException");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception processing dumpFileACEs IOException");
        }
        return aceOut;
    }

    public static CommandOutput.OutputHierarchy.OutputNode dumpInlineXAttrs(ByteString xattrs) {
        CommandOutput.OutputHierarchy.OutputNode xout = new CommandOutput.OutputHierarchy.OutputNode("xattrs");
        try {
            Fileserver.InlineXAttrs ix = Fileserver.InlineXAttrs.parseFrom((byte[])xattrs.toByteArray());
            for (Fileserver.DiskXAttr dx : ix.getXattrsList()) {
                xout.addChild(new CommandOutput.OutputHierarchy.OutputNode(dx.getName(), (Object)dx.getXval().getValue().toStringUtf8()));
            }
            if (ix.getXattrsCount() == 1) {
                ByteString xval = ix.getXattrs(0).getXval().getValue();
                if (ix.getXattrs(0).getName().charAt(0) == 'A') {
                    CommandOutput.OutputHierarchy.OutputNode aceOut = FidCommands.dumpFileACEs(xval);
                    xout.addChild(aceOut);
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception processing dumpInlineXAttrs InvalidProtocolBufferException");
        }
        return xout;
    }

    private void dumpSecurityProperties(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            Common.SecurityPolicyProperties secPolProps = Common.SecurityPolicyProperties.parseFrom((ByteString)val);
            if (secPolProps.hasPolicyName()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("PolicyName", (Object)secPolProps.getPolicyName()));
            }
            if (secPolProps.hasPolicyVersion()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("PolicyVersion", secPolProps.getPolicyVersion()));
            }
            if (secPolProps.hasDescription()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Description", (Object)secPolProps.getDescription()));
            }
            if (secPolProps.hasCtime()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Ctime", secPolProps.getCtime()));
            }
            if (secPolProps.hasMtime()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Mtime", secPolProps.getMtime()));
            }
            if (secPolProps.hasWireSecurityEnabled()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("WireSecurityEnabled", (Object)secPolProps.getWireSecurityEnabled()));
            }
            if (secPolProps.hasAuditDataAccess()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("AuditDataAccess", (Object)secPolProps.getAuditDataAccess()));
            }
            if (secPolProps.hasFsAuditDisabledOperations()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("FsAuditDisabledOperations", secPolProps.getFsAuditDisabledOperations()));
            }
            if (secPolProps.hasFileAces() || secPolProps.getDbStreamAcesCount() > 0 || secPolProps.hasReadAces() || secPolProps.hasWriteAces()) {
                CommandOutput.OutputHierarchy.OutputNode securityPolicyAcesNode = new CommandOutput.OutputHierarchy.OutputNode("Aces");
                try {
                    String aceParam;
                    Common.FSAccessType accessType;
                    if (secPolProps.hasReadAces()) {
                        securityPolicyAcesNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("readace", (Object)AceHelper.toInfix((String)secPolProps.getReadAces().toStringUtf8())));
                    }
                    for (Common.FileACE aceEntry : secPolProps.getFileAces().getAcesList()) {
                        accessType = aceEntry.getAccessType();
                        aceParam = "";
                        if (accessType == Common.FSAccessType.AceRead) {
                            aceParam = "readfile";
                        } else if (accessType == Common.FSAccessType.AceWrite) {
                            aceParam = "writefile";
                        } else if (accessType == Common.FSAccessType.AceExecute) {
                            aceParam = "executefile";
                        } else if (accessType == Common.FSAccessType.AceReadDir) {
                            aceParam = "readdir";
                        } else if (accessType == Common.FSAccessType.AceAddChild) {
                            aceParam = "addchild";
                        } else if (accessType == Common.FSAccessType.AceDeleteChild) {
                            aceParam = "deletechild";
                        } else if (accessType == Common.FSAccessType.AceLookupDir) {
                            aceParam = "lookupdir";
                        }
                        if (aceParam.length() <= 0) continue;
                        securityPolicyAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(aceParam, (Object)AceHelper.toInfix((String)aceEntry.getBoolExp().toStringUtf8())));
                    }
                    for (Common.FileACE aceEntry : secPolProps.getDbStreamAcesList()) {
                        accessType = aceEntry.getAccessType();
                        aceParam = "";
                        if (accessType == Common.DBStreamAccessType.AceReadDB) {
                            aceParam = "readdb";
                        } else if (accessType == Common.DBStreamAccessType.AceWriteDB) {
                            aceParam = "writedb";
                        } else if (accessType == Common.DBStreamAccessType.AceTraverse) {
                            aceParam = "traversedb";
                        } else if (accessType == Common.DBStreamAccessType.AceProduce) {
                            aceParam = "produceace";
                        } else if (accessType == Common.DBStreamAccessType.AceConsume) {
                            aceParam = "consumeace";
                        } else if (accessType == Common.DBStreamAccessType.AceTopic) {
                            aceParam = "topicace";
                        }
                        if (aceParam.length() <= 0) continue;
                        securityPolicyAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(aceParam, (Object)AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
                    }
                    if (secPolProps.hasWriteAces()) {
                        securityPolicyAcesNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("writeace", (Object)AceHelper.toInfix((String)secPolProps.getWriteAces().toStringUtf8())));
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Unable to parse data access ACEs");
                }
                out.addChild(securityPolicyAcesNode);
            }
            if (secPolProps.hasAcl()) {
                Security.AccessControlList acl = secPolProps.getAcl();
                ArrayList<Integer> unknownUids = new ArrayList<Integer>();
                ArrayList<Integer> unknownGids = new ArrayList<Integer>();
                CommandOutput.OutputHierarchy outAcl = AclCommands.formatAcl(acl, CLDBProto.SecureObjectType.OBJECT_TYPE_SECURITYPOLICY, "short", new UnixUserGroupHelper(), unknownUids, unknownGids);
                for (CommandOutput.OutputHierarchy.OutputError e : outAcl.getOutputErrors()) {
                    LOG.info((Object)("Error in output:" + e.toString()));
                }
                for (CommandOutput.OutputHierarchy.OutputNode b : outAcl.getOutputNodes()) {
                    out.addNode(new CommandOutput.OutputHierarchy.OutputNode("acl", (Object)b));
                }
            }
            if (secPolProps.hasTaggingAllowed()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("TaggingAllowed", (Object)secPolProps.getTaggingAllowed()));
            }
            if (secPolProps.hasAccessControl()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("AccessControl", (Object)secPolProps.getAccessControl()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception processing dumpSecurityProperties: InvalidProtocolBufferException");
        }
    }

    private void dumpCompositeIdInfo(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            Common.CompositePolicyInfo cpInfo = Common.CompositePolicyInfo.parseFrom((ByteString)val);
            if (cpInfo.getPolicyIdsCount() > 0) {
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Policy Ids", (Object)cpInfo.getPolicyIdsList().toString()));
            }
            if (cpInfo.getPolicyNamesCount() > 0) {
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Policy Names", (Object)cpInfo.getPolicyNamesList().toString()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception processing dumpCompositePolicyInfo: InvalidProtocolBufferException");
        }
    }

    private void dumpHashedStringValue(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.HashedStringValue hashedVal = CLDBProto.HashedStringValue.parseFrom((ByteString)val);
            if (hashedVal.hasOriginalKey()) {
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("OriginalKey", (Object)hashedVal.getOriginalKey()));
            } else {
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("OriginalKey", (Object)""));
            }
            if (hashedVal.hasInt64Id()) {
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Int64Id", hashedVal.getInt64Id()));
            }
            if (hashedVal.hasInt32Id()) {
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Int32Id", hashedVal.getInt32Id()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception processing dumpHashedStringValue: InvalidProtocolBufferException");
        }
    }

    private void dumpFileFilterInfo(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            Common.FileFilterProperties fInfo = Common.FileFilterProperties.parseFrom((ByteString)val);
            if (fInfo.hasFilterName()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("FilterName", (Object)fInfo.getFilterName()));
            }
            if (fInfo.hasDescription()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Description", (Object)fInfo.getDescription()));
            }
            if (fInfo.getFileExtenstionCount() > 0) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("FileExtension", (Object)fInfo.getFileExtenstionList().toString()));
            }
            if (fInfo.hasFileExtensions()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("FileExtensions", (Object)fInfo.getFileExtensions()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception processing dumpCompositePolicyInfo: InvalidProtocolBufferException");
        }
    }

    private CommandOutput.OutputHierarchy.OutputNode formatKV(Common.FidMsg fid, KVFormatType type, Fileserver.KvMsg kv) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        String ks = null;
        ByteString bks = null;
        switch (type) {
            case XATTR: {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", kv.getVersion()));
            }
            case TABLE: 
            case INDEX_TABLE: 
            case SCHEMA_INFO: 
            case TABLET: 
            case SEGMENT_MAP: 
            case TABLET_MAP: 
            case DEFER_MAP: 
            case HASHED_STRING: {
                ByteString bs = kv.getKey().getVarKey();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(bs.toByteArray())));
                ks = bs.toStringUtf8();
                bks = bs;
                break;
            }
            case GENERIC_KV: {
                this.dumpKvStoreKey(kv.getKey(), dout);
                if (kv.getKey().hasVarKey()) {
                    ks = kv.getKey().getVarKey().toStringUtf8();
                }
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", kv.getVersion()));
                break;
            }
            case SPILL_MAP: {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", kv.getKey().getIntKey()));
                break;
            }
            case DIR: {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)Long.toHexString(kv.getKey().getLongKey())));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", kv.getVersion()));
                break;
            }
            case CLDB_CID_MAP: 
            case CLDB_CG_INFO: {
                long longKey = kv.getKey().getLongKey();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)Long.toHexString(longKey)));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("hKey", Util.getHigherIntFromLong((long)longKey)));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("lKey", Util.getLowerIntFromLong((long)longKey)));
                break;
            }
            case MFS_SNAP_ID2_CID: {
                long longKey = kv.getKey().getLongKey();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotId", Util.getHigherIntFromLong((long)longKey)));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("StartSnapCid", Util.getLowerIntFromLong((long)longKey)));
                break;
            }
            case CLDB_SP_MAP: {
                this.dumpSPMap(kv.getKey().getVarKey().toByteArray(), dout);
                break;
            }
            default: {
                this.dumpKvStoreKey(kv.getKey(), dout);
            }
        }
        CommandOutput.OutputHierarchy.OutputNode vout = new CommandOutput.OutputHierarchy.OutputNode();
        switch (type) {
            case TABLE: 
            case INDEX_TABLE: {
                if (ks.equals(Dbserver.DBInternalDefaults.getDefaultInstance().getTableKeyForStats())) {
                    try {
                        Dbserver.TableBasicStats stats = Dbserver.TableBasicStats.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Rows", stats.getNumRows()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Size", stats.getSize()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Tablets", stats.getNumTablets()));
                    }
                    catch (Throwable e) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Rows", (Object)"UNKNOWN"));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Size", (Object)"UNKNOWN"));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Tablets", (Object)"UNKNOWN"));
                    }
                    break;
                }
                try {
                    Common.FidMsg f = Common.FidMsg.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(f)));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
                }
                break;
            }
            case SCHEMA_INFO: {
                try {
                    Dbserver.DBInternalDefaults dbi = Dbserver.DBInternalDefaults.getDefaultInstance();
                    if (ks == null) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                        break;
                    }
                    if (ks.startsWith(dbi.getColFamilyIdPrefix())) {
                        Dbserver.SchemaFamily sf = Dbserver.SchemaFamily.parseFrom((ByteString)kv.getValue());
                        if (sf.hasName()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cfname", (Object)sf.getName()));
                            break;
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cfname", (Object)"NONE"));
                        break;
                    }
                    if (ks.equals(dbi.getAttr())) {
                        Dbserver.TableAttr attr = Dbserver.TableAttr.parseFrom((ByteString)kv.getValue());
                        if (attr.hasAutoSplit()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:autoSplit", (Object)attr.getAutoSplit()));
                        }
                        if (attr.hasBulkLoad()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:bulkLoad", (Object)attr.getBulkLoad()));
                        }
                        if (attr.hasDeleteTTL()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:deleteTTL", attr.getDeleteTTL()));
                        }
                        if (attr.hasSyncReplTimeoutMillis()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:syncReplTimeoutMillis", attr.getSyncReplTimeoutMillis()));
                        }
                        if (attr.hasRegionSizeMB()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:regionSizeMB", attr.getRegionSizeMB()));
                        }
                        if (attr.hasMaxValueSzInMemIndex()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:maxValueSzInMemIndex", attr.getMaxValueSzInMemIndex()));
                        }
                        if (attr.hasReclaimThreshPcntForPack()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:reclaimThreshPcntForPack", attr.getReclaimThreshPcntForPack()));
                        }
                        if (attr.hasIsMarlinTable()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:isMarlinTable", (Object)attr.getIsMarlinTable()));
                        }
                        if (attr.hasMarlinAttr()) {
                            Marlincommon.MarlinTableAttr mtAttr = attr.getMarlinAttr();
                            if (mtAttr.hasAutoCreateTopics()) {
                                vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("marlinAttr:autoCreateTopics", (Object)mtAttr.getAutoCreateTopics()));
                            }
                            if (mtAttr.hasDefaultNumFeedsPerTopic()) {
                                vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("marlinAttr:defaultNumFeedsPerTopic", mtAttr.getDefaultNumFeedsPerTopic()));
                            }
                        }
                        if (!attr.hasMetricsInterval()) break;
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:metricsInterval", (Object)attr.getMetricsInterval()));
                        break;
                    }
                    if (ks.startsWith(dbi.getReplIdxPrefix())) {
                        Dbserver.TableReplicaDesc rd = Dbserver.TableReplicaDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)rd.getClusterName()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("table", (Object)rd.getTablePath()));
                        byte[] uuid = rd.getTableUuid().toByteArray();
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString((byte[])uuid)));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("paused", (Object)rd.getIsPaused()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("synchronous", (Object)rd.getSynchronous()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", rd.getIdx()));
                        if (rd.getQualifiersCount() <= 0) break;
                        Object famList = "";
                        int idx = 0;
                        for (Dbserver.Qualifier qual : rd.getQualifiersList()) {
                            if (qual.getQualifiersCount() > 0) {
                                for (ByteString bstr : qual.getQualifiersList()) {
                                    famList = idx == 0 ? qual.getFamily() + COLUMN_SEP + bstr.toStringUtf8() : (String)famList + MULTI_ARG_SEP + qual.getFamily() + COLUMN_SEP + bstr.toStringUtf8();
                                    ++idx;
                                }
                                continue;
                            }
                            if (idx == 0) {
                                famList = String.valueOf(qual.getFamily());
                                ++idx;
                                continue;
                            }
                            famList = (String)famList + MULTI_ARG_SEP + qual.getFamily();
                            ++idx;
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("columnfamilies", famList));
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)this.bytesToString(kv.getValue())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case TABLET: {
                try {
                    Dbserver.DBInternalDefaults dbi = Dbserver.DBInternalDefaults.getDefaultInstance();
                    if (ks == null) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForPMap())) {
                        CommandOutput.OutputHierarchy.OutputNode buckets;
                        Dbserver.PartitionMapEntry p = Dbserver.PartitionMapEntry.parseFrom((ByteString)kv.getValue());
                        if (p.hasSegmapFid()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("segfid", (Object)FidCommands.printableFid(p.getSegmapFid())));
                        } else {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("segfid", (Object)"NONE"));
                        }
                        if (p.getBucketFidsList().size() > 0) {
                            buckets = new CommandOutput.OutputHierarchy.OutputNode("bucketfids");
                            vout.addChild(buckets);
                            for (Common.FidMsg f : p.getBucketFidsList()) {
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(f)));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isFrozen", (Object)p.getIsFrozen()));
                        if (p.getCidVNEntriesList().size() > 0) {
                            CommandOutput.OutputHierarchy.OutputNode cidVNs = new CommandOutput.OutputHierarchy.OutputNode("CidVNs");
                            vout.addChild(cidVNs);
                            for (Dbserver.CidVNEntry ce : p.getCidVNEntriesList()) {
                                cidVNs.addChild(new CommandOutput.OutputHierarchy.OutputNode("cid-minVN", (Object)(ce.getCid() + "-" + ce.getMinVN())));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inSplit", (Object)p.getInSplit()));
                        if (p.hasInImportBucket()) {
                            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inImportBucket", (Object)p.getInImportBucket()));
                        }
                        if (p.getBucketDescsList().size() > 0) {
                            buckets = new CommandOutput.OutputHierarchy.OutputNode("bucketdescs");
                            vout.addChild(buckets);
                            for (Dbserver.PartitionMapEntry.BucketDesc bd : p.getBucketDescsList()) {
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(bd.getFid())));
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("needsRepl", (Object)bd.getNeedsRepl()));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("useBucketDesc", (Object)p.getUseBucketDesc()));
                        if (p.hasLastFlushedBucketFid()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastFlushedBucketFid", (Object)FidCommands.printableFid(p.getLastFlushedBucketFid())));
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numLogicalBlocks", p.getUsage().getNumLogicalBlocks()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numPhysicalBlocks", p.getUsage().getNumPhysicalBlocks()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", p.getUsage().getNumRows()));
                        if (p.getUsage().hasNumRowsWithDelete()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRowsWithDelete", p.getUsage().getNumRowsWithDelete()));
                        }
                        if (p.getUsage().hasNumRemoteBlocks()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRemoteBlocks", p.getUsage().getNumRemoteBlocks()));
                        }
                        if (p.getUsage().hasNumSpills()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSpills", p.getUsage().getNumSpills()));
                        }
                        if (p.getUsage().hasNumSegments()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSegments", p.getUsage().getNumSegments()));
                        }
                        if (p.getUsage().hasTimeRange()) {
                            Dbserver.TimeRange ts = p.getUsage().getTimeRange();
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("minTimeStamp", ts.getMinTS()));
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxTimeStamp", ts.getMaxTS()));
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("marlinMaxSeq", p.getMarlinMaxSeq()));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForSplit())) {
                        Dbserver.SplitDesc sd = Dbserver.SplitDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(sd.getDstFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("moveRightHalf", (Object)sd.getMoveRightHalf()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("endGame", (Object)sd.getEndGame()));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForStartKey()) || ks.startsWith(dbi.getTabletKeyForEndKey())) break;
                    if (ks.startsWith(dbi.getTabletKeyForMerge())) {
                        Dbserver.MergeDesc md = Dbserver.MergeDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("peerFid", (Object)FidCommands.printableFid(md.getPeerFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isDest", (Object)md.getIsDest()));
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)this.bytesToString(kv.getValue())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case TABLET_MAP: {
                try {
                    Dbserver.TabletMapEntry t = Dbserver.TabletMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(t.getTabletFid())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
                }
                break;
            }
            case SEGMENT_MAP: {
                try {
                    Dbserver.SegmentMapEntry s = Dbserver.SegmentMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(s.getFid())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
                }
                break;
            }
            case SPILL_MAP: {
                try {
                    Dbserver.SpillMapEntry s = Dbserver.SpillMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(s.getFid())));
                    if (s.hasSmeSize()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("smeSize", s.getSmeSize()));
                    }
                    if (s.hasMinVN()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("minVN", s.getMinVN()));
                    }
                    if (s.hasMaxMarlinSeq()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxMarlinSeq", s.getMaxMarlinSeq()));
                    }
                    if (s.hasBackingBucketFid()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("backingBucketFid", (Object)FidCommands.printableFid(s.getBackingBucketFid())));
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyIdxOffset", s.getKeyIdxOffset()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyIdxLength", s.getKeyIdxLength()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ldbIdxLength", s.getLdbIdxLength()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("bloomBitsPerKey", s.getBloomBitsPerKey()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numLogicalBlocks", s.getUsage().getNumLogicalBlocks()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numPhysicalBlocks", s.getUsage().getNumPhysicalBlocks()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", s.getUsage().getNumRows()));
                    if (s.getUsage().hasNumRowsWithDelete()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRowsWithDelete", s.getUsage().getNumRowsWithDelete()));
                    }
                    CommandOutput.OutputHierarchy.OutputNode families = new CommandOutput.OutputHierarchy.OutputNode("families");
                    vout.addChild(families);
                    for (Dbserver.SpillMapEntry.FamilyEntry fe : s.getFamiliesList()) {
                        families.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", fe.getId()));
                        if (fe.hasOffset()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", fe.getOffset()));
                        }
                        if (fe.hasLength()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", fe.getLength()));
                        }
                        if (!fe.hasTimeRange()) continue;
                        Dbserver.TimeRange tr = fe.getTimeRange();
                        if (tr.hasMinTS()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("minTimeStamp", tr.getMinTS()));
                        }
                        if (!tr.hasMaxTS()) continue;
                        families.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxTimeStamp", tr.getMaxTS()));
                    }
                    break;
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyfid", (Object)"UNKNOWN"));
                    break;
                }
            }
            case DEFER_MAP: {
                try {
                    if (ks.startsWith("b")) {
                        Dbserver.ReplBucketDesc b = Dbserver.ReplBucketDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketFid", (Object)FidCommands.printableFid(b.getBucketFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("tableFid", (Object)FidCommands.printableFid(b.getTableFid())));
                        if (b.getSendAfterList().size() != 0) {
                            CommandOutput.OutputHierarchy.OutputNode sendAfter = new CommandOutput.OutputHierarchy.OutputNode("sendAfter");
                            vout.addChild(sendAfter);
                            for (Common.FidMsg f : b.getSendAfterList()) {
                                sendAfter.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(f)));
                            }
                        }
                        if (b.getSendBeforeList().size() != 0) {
                            CommandOutput.OutputHierarchy.OutputNode sendBefore = new CommandOutput.OutputHierarchy.OutputNode("sendBefore");
                            vout.addChild(sendBefore);
                            for (Common.FidMsg f : b.getSendBeforeList()) {
                                sendBefore.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(f)));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("flushed", (Object)b.getFlushed()));
                        CommandOutput.OutputHierarchy.OutputNode replicas = new CommandOutput.OutputHierarchy.OutputNode("replicas");
                        vout.addChild(replicas);
                        for (Dbserver.ReplBucketDesc.ReplicaInfo rs : b.getReplList()) {
                            replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicaIdx", rs.getReplicaIdx()));
                            if (rs.hasDoneTillOffset()) {
                                replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("doneTillOffset", rs.getDoneTillOffset()));
                            }
                            if (!rs.hasDone()) continue;
                            replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("done", (Object)rs.getDone()));
                        }
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case XATTR: {
                try {
                    ByteString xval;
                    Fileserver.XAttrValue x = Fileserver.XAttrValue.parseFrom((ByteString)kv.getValue());
                    if (x.hasInum()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inum", x.getInum()));
                    }
                    if (x.hasXattrNameLen()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("xattrNameLen", x.getXattrNameLen()));
                        xval = bks.substring(1 + x.getXattrNameLen() + 1);
                    } else {
                        xval = x.getValue();
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("xval", (Object)xval.toStringUtf8()));
                    if (ks.charAt(0) != 'A') break;
                    CommandOutput.OutputHierarchy.OutputNode aceOut = FidCommands.dumpFileACEs(xval);
                    vout.addChild(aceOut);
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("xattr", (Object)"UNKNOWN"));
                }
                break;
            }
            case DIR: {
                ByteString bs = kv.getValue();
                for (int offset = 0; offset < bs.size(); offset += 16) {
                    NameEnt ent = this.getNameEnt(bs, offset);
                    CommandOutput.OutputHierarchy.OutputNode entOut = new CommandOutput.OutputHierarchy.OutputNode("dirEntry");
                    long cid = ent.cid;
                    if (cid < 0L) {
                        cid = fid.getCid();
                    }
                    String fidStr = Long.toString(cid) + "." + Long.toString(ent.cinum) + "." + Long.toString(ent.uniq);
                    entOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)fidStr));
                    entOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", ent.ftype));
                    entOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("name", (Object)ent.name));
                    entOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("nameEnt", (Object)BinaryString.toStringHex((byte[])bs.toByteArray())));
                    vout.addChild(entOut);
                    offset += ent.nmlen;
                }
                break;
            }
            case CLDB_CG_INFO: {
                this.dumpCGInfo(kv.getValue(), vout);
                break;
            }
            case CLDB_CONTAINER_INFO: {
                this.dumpContainerInfo(kv.getValue(), vout);
                break;
            }
            case CLDB_CONTAINER_SIZE_INFO: {
                this.dumpContainerSizeInfo(kv.getValue(), vout);
                break;
            }
            case CLDB_SP_PROP: {
                this.dumpSPProperties(kv.getValue(), vout);
                break;
            }
            case CLDB_FS_PROP: {
                this.dumpFSProperties(kv.getValue(), vout);
                break;
            }
            case CLDB_SNAPSHOT_INFO: {
                this.dumpSnapshotInfo(kv.getValue(), vout);
                break;
            }
            case CLDB_VOLUME_PROP: {
                this.dumpVolumeProperties(kv.getValue(), vout);
                break;
            }
            case CLDB_VOLUME_QUOTA: {
                this.dumpVolumeQuota(kv.getValue(), vout);
                break;
            }
            case CLDB_VOLUME_ACES: {
                this.dumpVolumeAces(kv.getValue(), vout);
                break;
            }
            case CLDB_VOLUME_NAME: {
                this.dumpVolumeTableId(kv.getValue(), vout);
                break;
            }
            case MFS_SNAP_MAP: {
                this.dumpUint32(kv.getValue(), vout);
                break;
            }
            case MFS_SNAP_ID2_CID: {
                this.dumpSnapIdToSnapcidMapEntry(kv.getValue(), vout);
                break;
            }
            case MFS_SNAP_CID2_ID: {
                this.dumpSnapcidToSnapIdMapEntry(kv.getValue(), vout);
                break;
            }
            case CLDB_SP_MAP: {
                vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", (Object)"0"));
                break;
            }
            case POLICYSERVER_POLICY_INFO: {
                this.dumpSecurityProperties(kv.getValue(), vout);
                break;
            }
            case POLICYSERVER_COMPOSITE_ID_INFO: {
                this.dumpCompositeIdInfo(kv.getValue(), vout);
                break;
            }
            case FILE_FILTER_INFO: {
                this.dumpFileFilterInfo(kv.getValue(), vout);
                break;
            }
            case HASHED_STRING: {
                this.dumpHashedStringValue(kv.getValue(), vout);
                break;
            }
            default: {
                vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("valSize", kv.getValue().size()));
            }
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", (Object)vout));
        return dout;
    }

    private void dumpDir(Common.FidMsg fid, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MapRFileStatus[] dirents;
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            dirents = fs.scanDir(this.clusterName, "/.mapr::fid::" + FidCommands.printableFid(fid));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanDir failed"));
            return;
        }
        if (dirents == null) {
            return;
        }
        for (int i = 0; i < dirents.length; ++i) {
            out.addNode(this.formatDirEntry(dirents[i]));
        }
    }

    private void dumpRegKeyMap(Common.FidMsg fid, Integer idxoffset, Integer idxsize, boolean dumpFullKeys, int fmtVersion, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        long dbinding = this.getBindingForContainer(fid.getCid());
        Dbserver.KeyMapCookie cookie = null;
        LOG.info((Object)("Getting regular key-map with idxsize " + idxsize + " dumpFullKeys " + dumpFullKeys + " keyIdxVersion " + fmtVersion));
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return;
        }
        while (true) {
            Dbserver.TestScanResponse resp;
            Dbserver.TestScanRequest req = cookie == null ? Dbserver.TestScanRequest.newBuilder().setCmd(Dbserver.TestScanRequest.Cmd.KeyMapTable).setFid(fid).setOffset((long)idxoffset.intValue()).setSize(idxsize.intValue()).setCreds(this.getUserCredentials()).setDumpFullKeys(dumpFullKeys).setKeyIdxFmtVersion(fmtVersion).build() : Dbserver.TestScanRequest.newBuilder().setCmd(Dbserver.TestScanRequest.Cmd.KeyMapTable).setFid(fid).setOffset((long)idxoffset.intValue()).setSize(idxsize.intValue()).setCreds(this.getUserCredentials()).setKmapCookie(cookie).setDumpFullKeys(dumpFullKeys).setKeyIdxFmtVersion(fmtVersion).build();
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBServerProgramId.getNumber(), (int)Dbserver.DBProg.TestScanProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "testscan rpc failed"));
                    return;
                }
                resp = Dbserver.TestScanResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "TestScan failed, Error : " + Errno.toString((int)resp.getStatus())));
                    return;
                }
                for (Dbserver.KeyMapEntry kment : resp.getKmapentriesList()) {
                    out.addNode(this.formatKeyMapEntry(kment));
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing testscan command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return;
            }
            if (!resp.getHasMoreKeys()) break;
            LOG.info((Object)("Setting cookie as " + resp.getKmapCookie().getOffset()));
            cookie = resp.getKmapCookie();
        }
        LOG.info((Object)"Done with scan");
    }

    private void dumpKeyValues(Common.FidMsg fid, KVFormatType type, Fileserver.KvStoreKey start, Fileserver.KvStoreKey end, int maxkeys, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        byte[] byteArr;
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            byte[] kstart = null;
            if (start != null) {
                kstart = start.toByteArray();
            }
            byte[] kend = null;
            if (end != null) {
                kend = end.toByteArray();
            }
            byteArr = fs.scanKV(this.clusterName, "/.mapr::fid::" + FidCommands.printableFid(fid), kstart, kend, maxkeys);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanKV failed"));
            return;
        }
        if (byteArr == null) {
            return;
        }
        try {
            Fileserver.KvList kvlist = Fileserver.KvList.parseFrom((byte[])byteArr);
            for (Fileserver.KvMsg kvp : kvlist.getEntriesList()) {
                out.addNode(this.formatKV(fid, type, kvp));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "failed to parse key-value list"));
            return;
        }
    }

    public static String printableFid(Common.FidMsg f) {
        Object cidStr = f.getCid() == -1 ? "<parentCID>." : f.getCid() + ".";
        return (String)cidStr + f.getCinum() + "." + f.getUniq();
    }

    public static String printableSubType(Common.FileType type, Common.FileSubType subtype) {
        String stype = subtype.toString();
        if (type == Common.FileType.FTKvstore) {
            if (subtype == Common.FileSubType.FSTKvTable) {
                stype = "FSTKvTable";
            } else if (subtype == Common.FileSubType.FSTKvTabletMap) {
                stype = "FSTKvTabletMap";
            } else if (subtype == Common.FileSubType.FSTKvSchema) {
                stype = "FSTKvSchema";
            } else if (subtype == Common.FileSubType.FSTKvTablet) {
                stype = "FSTKvTablet";
            } else if (subtype == Common.FileSubType.FSTKvSegMap) {
                stype = "FSTKvSegMap";
            } else if (subtype == Common.FileSubType.FSTKvSpillMap) {
                stype = "FSTKvSpillMap";
            } else if (subtype == Common.FileSubType.FSTKvKeyMap) {
                stype = "FSTKvKeyMap";
            } else if (subtype == Common.FileSubType.FSTKvIndexTable) {
                stype = "FSTKvIndexTable";
            } else if (subtype == Common.FileSubType.FSTKvXattr) {
                stype = "FSTKvXattr";
            }
        } else if (type == Common.FileType.FTRegular) {
            if (subtype == Common.FileSubType.FSTRegBucket) {
                stype = "FSTRegBucket";
            } else if (subtype == Common.FileSubType.FSTRegSortedBucket) {
                stype = "FSTRegSortedBucket";
            } else if (subtype == Common.FileSubType.FSTRegCF) {
                stype = "FSTRegCF";
            } else if (subtype == Common.FileSubType.FSTRegSpill) {
                stype = "FSTRegSpill";
            }
        }
        return stype;
    }

    private String printableKey(byte[] bytes) {
        return BinaryString.toStringBinary((byte[])bytes);
    }

    private String bytesToString(ByteString bs) {
        return BinaryString.toStringBinary((byte[])bs.toByteArray());
    }

    private long getBindingForGateway(int gIp, int gPort) throws CLIProcessingException {
        if (gPort == 0) {
            gPort = 7660;
        }
        return Rpc.createBindingFor((int)gIp, (int)gPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    public static String getCompressionType(Common.FileCompressionType ct) {
        if (ct == Common.FileCompressionType.FCT_OFF) {
            return "off";
        }
        if (ct == Common.FileCompressionType.FCT_LZ4) {
            return "lz4";
        }
        if (ct == Common.FileCompressionType.FCT_LZF) {
            return "lzf";
        }
        if (ct == Common.FileCompressionType.FCT_ZLIB) {
            return "zlib";
        }
        return "unknown";
    }

    private Common.IPAddress buildIPFromString(String ipstr) {
        if (ipstr.equalsIgnoreCase("localhost") || ipstr.equalsIgnoreCase("127.0.0.1")) {
            ipstr = "127.0.0.1";
        } else {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(ipstr));
            if (ips.isEmpty()) {
                return null;
            }
            ipstr = ips.get(0);
        }
        int host = Util.ipToInt((String)ipstr);
        Common.IPAddress server = Common.IPAddress.newBuilder().setHost(host).build();
        return server;
    }

    public class NameEnt {
        Long cid;
        Long cinum;
        Long uniq;
        int ftype;
        String name;
        int nmlen;
    }

    public static enum KVFormatType {
        TABLE,
        INDEX_TABLE,
        TABLET_MAP,
        SCHEMA_INFO,
        TABLET,
        SEGMENT_MAP,
        SPILL_MAP,
        DEFER_MAP,
        GENERIC_KV,
        DIR,
        CLDB_CONTAINER_INFO,
        CLDB_CONTAINER_SIZE_INFO,
        CLDB_CID_MAP,
        CLDB_FS_PROP,
        CLDB_SP_PROP,
        CLDB_VOLUME_NAME,
        CLDB_VOLUME_PROP,
        CLDB_VOLUME_ACES,
        CLDB_VOLUME_QUOTA,
        CLDB_SNAPSHOT_INFO,
        CLDB_SP_MAP,
        CLDB_CG_INFO,
        MFS_SNAP_MAP,
        MFS_SNAP_ID2_CID,
        MFS_SNAP_CID2_ID,
        XATTR,
        POLICYSERVER_POLICY_INFO,
        POLICYSERVER_COMPOSITE_ID_INFO,
        FILE_FILTER_INFO,
        HASHED_STRING,
        INVALID;

    }
}

