/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityException;
import com.mapr.util.LDAPUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.log4j.Logger;

public class MapRCliUtil {
    private static ExecutorService es = Executors.newFixedThreadPool(10);
    public static final int JTTimeout = 6000;
    public static final String ParamEntityQuerySource = "mapr.entityquerysource";
    public static final String ParamDomainName = "mapr.domainname";
    public static final int CLDB_DEFAULT_PORT = 7222;
    public static final String CLUSTER_NAME_PARAM = "cluster";
    private static String systemhostname = MapRCliUtil.getHostname();
    private static final Logger LOG = Logger.getLogger(MapRCliUtil.class);
    private static YarnClient yarnClient = null;
    private static final Object yarnClientLock = new Object();
    public static final String MAPR_PATH_PREFIX = "/mapr/";
    public static final int MAPR_PATH_PREFIX_LENGTH = "/mapr/".length();

    public static String fetchEmail(Properties prop, String user, boolean type) {
        String querysource = prop.getProperty(ParamEntityQuerySource);
        if (querysource != null && querysource.equalsIgnoreCase("ldap")) {
            String ldapEmail;
            try {
                ldapEmail = LDAPUtil.getEmailAddress((Properties)prop, (String)user, (boolean)type);
            }
            catch (IOException e) {
                return null;
            }
            if (ldapEmail != null && !ldapEmail.isEmpty()) {
                return ldapEmail;
            }
        } else {
            String domainname = prop.getProperty(ParamDomainName);
            if (domainname != null && !domainname.isEmpty()) {
                return user + "@" + domainname;
            }
        }
        return null;
    }

    public static int fetchCLDBParams(String cluster, Properties CLDBProperties, Security.CredentialsMsg creds) throws CLIProcessingException {
        try {
            CLDBProto.CLDBConfigRequest req = CLDBProto.CLDBConfigRequest.newBuilder().setLoad(true).setCreds(creds).build();
            byte[] replyData = cluster != null && !cluster.isEmpty() ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CLDBConfigProc.getNumber(), (MessageLite)req, CLDBProto.CLDBConfigResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CLDBConfigProc.getNumber(), (MessageLite)req, CLDBProto.CLDBConfigResponse.class);
            if (replyData == null) {
                return -1;
            }
            CLDBProto.CLDBConfigResponse resp = CLDBProto.CLDBConfigResponse.parseFrom((byte[])replyData);
            int status = resp.getStatus();
            if (status != 0) {
                return status;
            }
            for (CLDBProto.CLDBConfigParams.CLDBConfigParam param : resp.getParams().getParamsList()) {
                CLDBProperties.setProperty(param.getKeys(), param.getValues());
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
            return -1;
        }
        return 0;
    }

    public static Common.FidMsg stringToFid(String s) {
        String[] temp = s.split("\\.");
        if (temp.length != 3) {
            return null;
        }
        int cid = Integer.parseInt(temp[0]);
        int cinum = Integer.parseInt(temp[1]);
        int uniq = Integer.parseInt(temp[2]);
        return Common.FidMsg.newBuilder().setCid(cid).setCinum(cinum).setUniq(uniq).build();
    }

    public static long quotaStringToMB(String quota) {
        long val = -1L;
        int mf = 1;
        if ((quota = quota.toUpperCase()).endsWith("M")) {
            quota = quota.substring(0, quota.length() - 1);
        } else if (quota.endsWith("MB")) {
            quota = quota.substring(0, quota.length() - 2);
        } else if (quota.endsWith("G")) {
            quota = quota.substring(0, quota.length() - 1);
            mf = 1024;
        } else if (quota.endsWith("GB")) {
            quota = quota.substring(0, quota.length() - 2);
            mf = 1024;
        } else if (quota.endsWith("T")) {
            quota = quota.substring(0, quota.length() - 1);
            mf = 0x100000;
        } else if (quota.endsWith("TB")) {
            quota = quota.substring(0, quota.length() - 2);
            mf = 0x100000;
        } else if (quota.endsWith("P")) {
            quota = quota.substring(0, quota.length() - 1);
            mf = 0x40000000;
        } else if (quota.endsWith("PB")) {
            quota = quota.substring(0, quota.length() - 2);
            mf = 0x40000000;
        }
        if (quota.matches("[0-9]+")) {
            val = (long)mf * Long.valueOf(quota);
        } else if (quota.matches("[0-9]*\\.[0-9]*") && !quota.equals(".")) {
            val = (long)((double)mf * Double.valueOf(quota));
        }
        return val;
    }

    public static int ipToInt(String addr) {
        if (addr.equals("localhost")) {
            addr = "127.0.0.1";
        }
        String[] addrArray = addr.split("\\.");
        long num = 0L;
        for (int i = 0; i < addrArray.length; ++i) {
            int power = 3 - i;
            num = (long)((double)num + (double)(Integer.parseInt(addrArray[i]) % 256) * Math.pow(256.0, power));
        }
        return (int)num;
    }

    public static boolean validateEmail(String email) {
        Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
        for (String testEmail : email.split(" ")) {
            Matcher m = p.matcher(email);
            if (m.matches()) continue;
            return false;
        }
        return true;
    }

    public static String getHostname(CLDBProto.FileServerInfo fs) {
        try {
            Common.IPAddress ip = (Common.IPAddress)fs.getAddressList().get(0);
            if (ip != null) {
                return ip.getHostname();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String getHostname() {
        String hostnameFile = MapRCliUtil.getMapRInstallDir() + "/hostname";
        try {
            FileReader fr = new FileReader(hostnameFile);
            if (fr == null) {
                return null;
            }
            BufferedReader b = new BufferedReader(fr);
            String strLine = b.readLine();
            if (strLine != null && !strLine.isEmpty() && !(strLine = strLine.trim()).isEmpty()) {
                return strLine;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static boolean isLocalAddr(String host) {
        if (host.equalsIgnoreCase("127.0.0.1")) {
            return true;
        }
        if (systemhostname != null && host.equalsIgnoreCase(systemhostname)) {
            return true;
        }
        try {
            String localhostname = InetAddress.getLocalHost().getHostName();
            if (host.equalsIgnoreCase(localhostname)) {
                return true;
            }
            InetAddress[] localaddrs = InetAddress.getAllByName(localhostname);
            for (InetAddress addr : InetAddress.getAllByName(host)) {
                for (InetAddress localaddr : localaddrs) {
                    if (!addr.equals(localaddr)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static String getMapRInstallDir() {
        String maprInstallDir = System.getProperty("mapr.home.dir");
        if (maprInstallDir == null && (maprInstallDir = System.getenv("MAPR_HOME")) == null) {
            maprInstallDir = "/opt/mapr";
        }
        return maprInstallDir;
    }

    public static MapRFileSystem getMapRFileSystem() throws CLIProcessingException {
        return MapRCliUtil.getMapRFileSystem(null);
    }

    public static MapRFileSystem getMapRFileSystem(String uname) throws CLIProcessingException {
        MapRFileSystem fs;
        Configuration c = new Configuration();
        c.set("fs.defaultFS", "maprfs:///");
        c.set("fs.mapr.disable.namecache", "true");
        try {
            fs = new MapRFileSystem(uname);
            URI uri = new URI(c.get("fs.defaultFS"));
            fs.initialize(uri, c);
            fs.forceLocalResolution(uri);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Failed to initialize MapRFileSystem " + e);
        }
        return fs;
    }

    public static boolean parentDirExists(MapRFileSystem fs, String clusterName, String path) throws CLIProcessingException {
        if (path.equalsIgnoreCase("/")) {
            return true;
        }
        if (!path.startsWith("/")) {
            return false;
        }
        Object parent = new File(path).getParent();
        if (parent == null) {
            return false;
        }
        boolean exists = false;
        try {
            if (clusterName != null) {
                parent = MAPR_PATH_PREFIX + clusterName + (String)parent;
            }
            exists = fs.exists(new Path((String)parent));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static int getParentCid(MapRFileSystem fs, String clusterName, String path) throws CLIProcessingException {
        if (!path.startsWith("/")) {
            LOG.error((Object)("getParentCid path has to be absolute path. Specified: " + path));
            return 0;
        }
        Object parent = new File(path).getParent();
        if (parent == null) {
            LOG.error((Object)("getParentCid parent could not be found. Path: " + path));
            return 0;
        }
        if (clusterName != null) {
            parent = MAPR_PATH_PREFIX + clusterName + (String)parent;
        }
        return fs.getCidFromPath(new Path((String)parent));
    }

    public static boolean createParentDir(MapRFileSystem fs, String clusterName, String path) throws CLIProcessingException {
        if (!path.startsWith("/")) {
            return false;
        }
        Object parent = new File(path).getParent();
        if (parent == null) {
            return false;
        }
        boolean ret = false;
        try {
            if (clusterName != null) {
                parent = MAPR_PATH_PREFIX + clusterName + (String)parent;
            }
            ret = fs.mkdirs(new Path((String)parent));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static byte[] sendRpc(MessageLite request, int procId, String cluster, Class<? extends MessageLite> responseClass) throws Exception {
        byte[] reply = null;
        CLDBRpcCommonUtils instance = CLDBRpcCommonUtils.getInstance();
        reply = cluster != null ? instance.sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), procId, request, responseClass) : instance.sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), procId, request, responseClass);
        return reply;
    }

    public static JobClient getJobClient(final String zkConnectString) {
        if (zkConnectString == null || zkConnectString.trim().isEmpty()) {
            return null;
        }
        Callable<JobClient> jtStatisCallable = new Callable<JobClient>(){

            @Override
            public JobClient call() throws Exception {
                InetSocketAddress addr = null;
                Common.ServiceData hostInfo = NodesCommonUtils.getServiceMasterData(zkConnectString, ServicesEnum.jobtracker.name());
                if (hostInfo != null && hostInfo.hasIsRunning() && hostInfo.getIsRunning() && hostInfo.hasHost() && hostInfo.hasPort()) {
                    try {
                        addr = new InetSocketAddress(hostInfo.getHost(), hostInfo.getPort());
                    }
                    catch (IllegalArgumentException ex) {
                        LOG.error((Object)("JT Info is not valid: " + hostInfo.getHost() + hostInfo.getPort()));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"getJobClient jt found");
                }
                if (addr == null) {
                    return null;
                }
                Configuration conf = new Configuration();
                conf.setInt("ipc.client.connect.max.retries", 2);
                JobClient jc = new JobClient(addr, conf);
                jc.setConf(conf);
                return jc;
            }
        };
        ArrayList<1> callableList = new ArrayList<1>();
        callableList.add(jtStatisCallable);
        try {
            JobClient jc = (JobClient)es.invokeAny(callableList, 6000L, TimeUnit.MILLISECONDS);
            return jc;
        }
        catch (InterruptedException e) {
            LOG.error((Object)"InterruptedException during JT Status thread execution");
            return null;
        }
        catch (ExecutionException e) {
            LOG.error((Object)"ExecutionException during JT Status thread execution", (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                LOG.fatal((Object)"OutOfMemory Error. Application needs to be restarted", (Throwable)e);
                System.exit(1);
            }
            return null;
        }
        catch (TimeoutException e) {
            LOG.error((Object)"TimeoutException during JT Status thread execution", (Throwable)e);
            return null;
        }
    }

    public static <T> T asyncInvoke(Callable<T> callable, String execContext) {
        return MapRCliUtil.asyncInvoke(callable, 6000, execContext);
    }

    public static <T> T asyncInvoke(Callable<T> callable, int timeout, String execContext) {
        ArrayList<Callable<T>> callableList = new ArrayList<Callable<T>>();
        callableList.add(callable);
        try {
            return es.invokeAny(callableList, timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("InterruptedException caught invoking Callable for " + execContext));
            return null;
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                LOG.fatal((Object)"OutOfMemory Error. Application needs to be restarted", (Throwable)e);
                System.exit(1);
            }
            LOG.error((Object)("Caught Execution Exception during " + execContext), (Throwable)e);
            return null;
        }
        catch (TimeoutException e) {
            LOG.error((Object)("TimeoutException caught during " + execContext), (Throwable)e);
            return null;
        }
    }

    public static YarnClient getYarnClient(final String zkConnectString) {
        if (zkConnectString == null || zkConnectString.trim().isEmpty()) {
            return null;
        }
        Callable<YarnClient> rmStatIsCallable = new Callable<YarnClient>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public YarnClient call() throws Exception {
                boolean rmHasMaster = false;
                Common.ServiceData hostInfo = NodesCommonUtils.getServiceMasterData(zkConnectString, "resourcemanager");
                if (hostInfo != null && hostInfo.hasIsRunning() && hostInfo.getIsRunning()) {
                    rmHasMaster = true;
                }
                if (LOG.isDebugEnabled() && rmHasMaster) {
                    LOG.debug((Object)"getYarnClient RM found");
                }
                Object object = yarnClientLock;
                synchronized (object) {
                    if (!rmHasMaster) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"No RM Master found. Returning yarnClient as null");
                        }
                        yarnClient = null;
                        return null;
                    }
                    if (yarnClient != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Returning CACHED yarnClient");
                        }
                        return yarnClient;
                    }
                }
                YarnConfiguration conf = new YarnConfiguration();
                YarnClient yc = YarnClient.createYarnClient();
                if (yc == null) {
                    return null;
                }
                yc.init((Configuration)conf);
                yc.start();
                Object object2 = yarnClientLock;
                synchronized (object2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Returning NEW yarnClient");
                    }
                    yarnClient = yc;
                    return yarnClient;
                }
            }
        };
        ArrayList<2> callableList = new ArrayList<2>();
        callableList.add(rmStatIsCallable);
        try {
            YarnClient yc = (YarnClient)es.invokeAny(callableList, 6000L, TimeUnit.MILLISECONDS);
            return yc;
        }
        catch (InterruptedException e) {
            LOG.error((Object)"InterruptedException during RM Status thread execution");
            return null;
        }
        catch (ExecutionException e) {
            LOG.error((Object)"ExecutionException during RM Status thread execution", (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                LOG.fatal((Object)"OutOfMemory Error. Application needs to be restarted", (Throwable)e);
                System.exit(1);
            }
            return null;
        }
        catch (TimeoutException e) {
            LOG.error((Object)"TimeoutException during RM Status thread execution", (Throwable)e);
            return null;
        }
    }

    public static String getRealRMWebAddress(String zkConnectString, Common.ServiceData masterServiceData) {
        if (zkConnectString == null || zkConnectString.trim().isEmpty()) {
            return null;
        }
        YarnConfiguration conf = new YarnConfiguration();
        if (HAUtil.isCustomRMHAEnabled((Configuration)conf)) {
            boolean isSecureCluster = JNISecurity.IsSecurityEnabled((String)CLDBRpcCommonUtils.getInstance().getCurrentClusterName());
            String portKeyName = isSecureCluster ? "WEBAPP_HTTPS_PORT" : "WEBAPP_PORT";
            String port = null;
            for (Common.ExtendedInfo extInfo : masterServiceData.getExtinfoList()) {
                if (!portKeyName.equals(extInfo.getKey())) continue;
                port = extInfo.getValue();
            }
            if (port != null) {
                return masterServiceData.getHost() + ":" + port;
            }
            return masterServiceData.getHost();
        }
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            String rmMasterId = NodesCommonUtils.getCurrentRMMasterID(zkConnectString);
            if (rmMasterId != null) {
                boolean isSecureCluster = JNISecurity.IsSecurityEnabled((String)CLDBRpcCommonUtils.getInstance().getCurrentClusterName());
                String baseYarnConf = isSecureCluster ? "yarn.resourcemanager.webapp.https.address" : "yarn.resourcemanager.webapp.address";
                String defaultAddress = isSecureCluster ? "0.0.0.0:8090" : "0.0.0.0:8088";
                return conf.get(baseYarnConf + "." + rmMasterId, defaultAddress);
            }
            return null;
        }
        return conf.get("yarn.resourcemanager.webapp.address", "0.0.0.0:8088");
    }

    public static String extractClusterNameFromFullyQualifiedPath(String fullyQualifiedPath) {
        String remainingPath;
        int index;
        if (fullyQualifiedPath.startsWith(MAPR_PATH_PREFIX) && (index = (remainingPath = fullyQualifiedPath.substring(MAPR_PATH_PREFIX_LENGTH)).indexOf("/")) != -1 && index != remainingPath.length() - 1) {
            return remainingPath.substring(0, index);
        }
        return null;
    }

    public static String getFidAsString(Common.FidMsg fid) {
        StringBuilder builder = new StringBuilder();
        builder.append(fid.getCid());
        builder.append(".");
        builder.append(fid.getCinum());
        builder.append(".");
        builder.append(fid.getUniq());
        return builder.toString();
    }
}

