/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BitSetBytesHelperUtils;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.policyserverutils.PolicyServerRpcCommonUtils;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.baseutils.utils.AceUtil;
import com.mapr.baseutils.utils.GetStringsForAuditOps;
import com.mapr.cli.AclCommands;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.PolicyServerProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityPolicyCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityPolicyCommands.class);
    private static final int NUM_SECURITY_POLICIES_PER_RPC = 100;
    private static int MAX_SECURITYPOLICYFIELDINFO = 0;
    private static int totalSecurityPolicies = 0;
    private static boolean dbAcesUpdated = false;
    private static boolean fileAcesUpdated = false;
    private boolean export = false;
    public static final String MULTI_ARG_SEP = ",";
    public static final String FILTER_PARAM = "filter";
    public static final String COLUMNS_PARAM = "columns";
    public static final String SORTBY_PARAM = "sortby";
    public static final String SORTING_ORDER_PARAM = "sortorder";
    public static final String ASCENDING_SORTING_ORDER_PARAM = "asc";
    public static final String DESCENDING_SORTING_ORDER_PARAM = "desc";
    public static final String OUTPUT_PARAM = "output";
    public static final String START_PARAM = "start";
    public static final String LIMIT_PARAM = "limit";
    public static final String SECURITY_POLICY_NAME_PARAM = "name";
    public static final String ALLOW_TAGGING_PARAM = "allowtagging";
    public static final String ACCESS_CONTROL_PARAM = "accesscontrol";
    public static final String DESCRIPTION_PARAM = "description";
    public static final String FILE_NAME_PARAM = "filename";
    public static final String SECURITY_EXPORT_POLICY_ID_PARAM = "id";
    public static final String SECURITY_EXPORT_POLICY_VERSION_PARAM = "version";
    public static final String SECURITY_EXPORT_POLICY_CTIME_PARAM = "ctime";
    public static final String SECURITY_EXPORT_POLICY_MTIME_PARAM = "mtime";
    public static final String EXPORT_DATA_AUDIT_OPS_VAL_PARAM = "dataauditopsval";
    UnixUserGroupHelper userInfo;
    public static final String AUDIT_ENABLED_PARAM = "auditenabled";
    public static final String WIRE_SECURITY_ENABLED = "wiresecurityenabled";
    public static final String DATA_AUDIT_OPS_PARAM = "dataauditops";
    public static final String DISABLE_DATA_AUDIT_OPS_PARAM = "disabledataauditops";
    public static final String ACE_READFILE_PARAM = "readfileace";
    public static final String ACE_WRITEFILE_PARAM = "writefileace";
    public static final String ACE_EXECUTEFILE_PARAM = "executefileace";
    public static final String ACE_READDIR_PARAM = "readdirace";
    public static final String ACE_ADDCHILD_PARAM = "addchildace";
    public static final String ACE_DELETECHILD_PARAM = "deletechildace";
    public static final String ACE_LOOKUPDIR_PARAM = "lookupdirace";
    public static final String ACE_READDB_PARAM = "readdbace";
    public static final String ACE_WRITEDB_PARAM = "writedbace";
    public static final String ACE_TRAVERSEDB_PARAM = "traversedbace";
    public static final String ACE_READ_PARAM = "readaces";
    public static final String ACE_WRITE_PARAM = "writeaces";
    public static final String EXPAND_ACES_PARAM = "expandaces";
    public static final String UID_PARAM_NAME = "user";
    public static final String GID_PARAM_NAME = "group";
    public static final String validCharRegEx = "[a-zA-Z0-9\\-_]*";
    public static final Pattern validNamePattern = Pattern.compile("[a-zA-Z0-9\\-_]*");
    public static final String validCharRegExWithSpace = "[a-zA-Z0-9\\-_\\s]*";
    public static final Pattern validDescPattern = Pattern.compile("[a-zA-Z0-9\\-_\\s]*");
    public static String securityPolicyAceParams = "[ -readfileace readfile ACE ] [ -writefileace writefile ACE ] [ -executefileace executefile ACE ] [ -readdirace readdir ACE ] [ -addchildace addchild ACE ] [ -deletechildace deletechild ACE ] [ -lookupdirace lookupdir ACE ] [ -readdbace readdb ACE ] [ -writedbace writedb ACE ] [ -traversedbace traversedb ACE ] [ -readaces read ACE ] [ -writeaces write ACE ] ";
    public static final String securityPolicyCreateUsage = "security policy create -name securityPolicyName [ -description description] [ -allowtagging true|false] [-accesscontrol Armed|Disarmed|Denied] [ -cluster clusterName] [ -auditenabled true|false ] [ -dataauditops audit-ops] [ -wiresecurityenabled true|false ] " + securityPolicyAceParams;
    static int SECURITY_POLICY_NAME_MAX_LEN = Common.MapRSharedConfigInfo.getDefaultInstance().getSecurityPolicyNameMaxLen();
    static int SECURITY_POLICY_DESCRIPTION_MAX_LEN = Common.MapRSharedConfigInfo.getDefaultInstance().getSecurityPolicyDescriptionMaxLen();
    public static final String securityPolicyModifyUsage = "security policy modify -name securityPolicyName [ -allowtagging true|false] [-accesscontrol Armed|Disarmed|Denied] [ -description description] [ -cluster clusterName] [ -auditenabled true|false ] [ -dataauditops audit-ops] [ -disabledataauditops audit-ops] [ -wiresecurityenabled true|false ] " + securityPolicyAceParams;
    public static final String securityPolicyInfoUsage = "security policy info [ -cluster clusterName] [ -expandaces true/false ] [ -output terse|verbose. Default: verbose ] [ -columns comma separated list of column names. Default: all ] ";
    private final String MAPR_SECURITY_POLICY_IMPORT = "mapr_policyimport";
    private static Map<PolicyServerProto.SecurityPolicyInfoFields, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)PolicyServerProto.SecurityPolicyInfoFields.policyName, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.policyName.getNumber(), "n", "policyname", String.class, CLDBProto.ListSortKey.SecurityPolicyName)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.policyId, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.policyId.getNumber(), "id", "policyid", Integer.class, CLDBProto.ListSortKey.SecurityPolicyId)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.description, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.description.getNumber(), "desc", "description", String.class)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.ctime, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.ctime.getNumber(), "ct", "ctime", Long.class, CLDBProto.ListSortKey.SecurityPolicyCtime)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.mtime, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.mtime.getNumber(), "mt", "mtime", Long.class, CLDBProto.ListSortKey.SecurityPolicyMtime)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.wireSecurityEnabled, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.wireSecurityEnabled.getNumber(), "ws", "wiresecurity", Integer.class, CLDBProto.ListSortKey.SecurityPolicyWireSecurityEnabled)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.auditDataAccess, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.auditDataAccess.getNumber(), "ea", "audited", Integer.class, CLDBProto.ListSortKey.SecurityPolicyAuditDataAccess)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.allowTagging, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.allowTagging.getNumber(), "at", "allowtagging", Integer.class, CLDBProto.ListSortKey.SecurityPolicyAllowTagging)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.accessControl, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.accessControl.getNumber(), "ac", "accesscontrol", String.class, CLDBProto.ListSortKey.SecurityPolicyAccessControl)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.auditEnableOperations, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.auditEnableOperations.getNumber(), "edao", "enableddataauditoperations", String.class)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.auditDisableOperations, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.auditDisableOperations.getNumber(), "ddao", "disableddataauditoperations", String.class)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.policyAces, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.policyAces.getNumber(), "ace", "aces", String.class)).put((Object)PolicyServerProto.SecurityPolicyInfoFields.policyAcl, (Object)new FieldInfo(PolicyServerProto.SecurityPolicyInfoFields.policyAcl.getNumber(), "acl", "acl", String.class)).build();
    static String supportedSortKeys;
    static Map<String, CLDBProto.ListSortKey> nameToEnumMap;
    public static String securityPolicyListUsage;
    static final CLICommand securityPolicyCreateCommand;
    static final CLICommand securityPolicyModifyCommand;
    static final CLICommand securityPolicyListCommand;
    static final CLICommand securityPolicyImportCommand;
    static final CLICommand securityPolicyExportCommand;
    static final CLICommand securityPolicyInfoCommand;
    public static CLICommand[] securityPolicyCommandsArray;
    public static CLICommand securityPolicyCommands;
    UnixUserGroupHelper uInfo = null;

    public SecurityPolicyCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void init() throws CLIProcessingException {
        this.uInfo = new UnixUserGroupHelper();
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            LOG.error("Exception while initializing RPC " + e);
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        LOG.debug("Processing::executeRealCommand");
        this.init();
        this.userInfo = new UnixUserGroupHelper();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            return this.securityPolicyList();
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.securityPolicyCreate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("modify")) {
            try {
                return this.securityPolicyModify();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("info")) {
            try {
                return this.securityPolicyInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("import")) {
            try {
                this.importSecurityPolicy();
            }
            catch (FileNotFoundException e) {
                return new TextCommandOutput("Invalid filename".getBytes());
            }
            catch (IOException e) {
                throw new CLIProcessingException("IOException", (Throwable)e);
            }
            catch (CLIProcessingException e) {
                throw new CLIProcessingException("CLIProcessingException", (Throwable)e);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Exception", (Throwable)e);
            }
            return new TextCommandOutput("".getBytes());
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("export")) {
            try {
                this.export = true;
                this.securityPolicyList();
            }
            catch (CLIProcessingException e) {
                throw new CLIProcessingException("CLIProcessingException", (Throwable)e);
            }
            catch (Exception e) {
                throw new CLIProcessingException("FileName Exception", (Throwable)e);
            }
            return new TextCommandOutput("".getBytes());
        }
        return new TextCommandOutput("Security policy command failed".getBytes());
    }

    private void importSecurityPolicy() throws Exception {
        String fileName = this.getParamTextValue(FILE_NAME_PARAM, 0).trim();
        Scanner fileScanner = new Scanner(new File(fileName));
        String cmdCreate = "maprcli security policy create";
        String cmdModify = "maprcli security policy modify";
        Object subcmd = "";
        String polName = "";
        int polId = 0;
        boolean aceOptSet = false;
        String singleKeyVal = "";
        Process p = null;
        String[] envp = new String[]{"mapr_policyimport=TRUE"};
        while (fileScanner.hasNext()) {
            int retChild;
            subcmd = "";
            Scanner lineScanner = new Scanner(fileScanner.nextLine());
            lineScanner.useDelimiter("\\{|\\}");
            while (lineScanner.hasNext()) {
                singleKeyVal = lineScanner.next();
                if (singleKeyVal.isEmpty()) continue;
                subcmd = (String)subcmd + " -" + singleKeyVal;
                String[] splitStr = singleKeyVal.split("\\s+");
                if (splitStr[0].equals(SECURITY_EXPORT_POLICY_ID_PARAM)) {
                    polId = Integer.parseInt(splitStr[1]);
                }
                if (!splitStr[0].equals(SECURITY_POLICY_NAME_PARAM)) continue;
                polName = splitStr[1];
            }
            if (((String)subcmd).isEmpty()) continue;
            PolicyServerProto.LookupSecurityPolicyResponse resp = SecurityPolicyCommands.securityPolicyLookupById(null, this.getUserCredentials(), polId);
            if (resp == null) {
                System.out.println("Error: Unable to reach PolicyServer");
                return;
            }
            if (resp.getStatus() == 2) {
                p = Runtime.getRuntime().exec(new String[]{"bash", "-c", cmdCreate + (String)subcmd}, envp);
                if (p != null) {
                    retChild = p.waitFor();
                    if (retChild == 0) {
                        System.out.println("Importing policy " + polName);
                    } else {
                        System.out.println("Error while Importing, policy " + polName);
                    }
                }
                LOG.info("Policy import successfull: " + cmdCreate + (String)subcmd);
                continue;
            }
            if (resp.getStatus() == 0) {
                if (!resp.getProperties(0).getPolicyName().equals(polName)) continue;
                p = Runtime.getRuntime().exec(new String[]{"bash", "-c", cmdModify + (String)subcmd}, envp);
                if (p != null) {
                    retChild = p.waitFor();
                    if (retChild == 0) {
                        System.out.println("Importing policy " + polName);
                    } else {
                        System.out.println("Error while Importing, policy " + polName);
                    }
                }
                LOG.info("Policy import successfull: " + cmdModify + (String)subcmd);
                continue;
            }
            System.out.println("Error: Importing Security Policy " + polName);
            return;
        }
    }

    private void exportSecPol(Common.SecurityPolicyProperties s) {
        String aceParam;
        Common.FSAccessType accessType;
        System.out.print("{");
        if (s.hasPolicyId()) {
            System.out.print("{id " + s.getPolicyId() + "}");
        }
        if (s.hasPolicyName()) {
            System.out.print("{name " + s.getPolicyName() + "}");
        }
        if (s.hasDescription()) {
            System.out.print("{description \"" + s.getDescription() + "\"}");
        }
        if (s.hasPolicyVersion()) {
            System.out.print("{version " + s.getPolicyVersion() + "}");
        }
        if (s.hasCtime()) {
            System.out.print("{ctime " + s.getCtime() + "}");
        }
        if (s.hasMtime()) {
            System.out.print("{mtime " + s.getMtime() + "}");
        }
        if (s.hasWireSecurityEnabled()) {
            System.out.print("{wiresecurityenabled " + s.getWireSecurityEnabled() + "}");
        }
        if (s.hasAuditDataAccess()) {
            System.out.print("{auditenabled " + s.getAuditDataAccess() + "}");
        }
        if (s.hasFsAuditDisabledOperations()) {
            System.out.print("{dataauditopsval " + s.getFsAuditDisabledOperations() + "}");
        }
        if (s.hasFileAces()) {
            for (Common.FileACE aceEntry : s.getFileAces().getAcesList()) {
                accessType = aceEntry.getAccessType();
                aceParam = "";
                if (accessType == Common.FSAccessType.AceRead) {
                    aceParam = ACE_READFILE_PARAM;
                } else if (accessType == Common.FSAccessType.AceWrite) {
                    aceParam = ACE_WRITEFILE_PARAM;
                } else if (accessType == Common.FSAccessType.AceExecute) {
                    aceParam = ACE_EXECUTEFILE_PARAM;
                } else if (accessType == Common.FSAccessType.AceReadDir) {
                    aceParam = ACE_READDIR_PARAM;
                } else if (accessType == Common.FSAccessType.AceAddChild) {
                    aceParam = ACE_ADDCHILD_PARAM;
                } else if (accessType == Common.FSAccessType.AceDeleteChild) {
                    aceParam = ACE_DELETECHILD_PARAM;
                } else if (accessType == Common.FSAccessType.AceLookupDir) {
                    aceParam = ACE_LOOKUPDIR_PARAM;
                }
                if (aceParam.length() > 0) {
                    try {
                        System.out.print("{" + aceParam + " '" + AceHelper.toInfix((String)aceEntry.getBoolExp().toStringUtf8()) + "'}");
                    }
                    catch (Exception e) {
                        System.out.println("Exception while parsing ACE's");
                    }
                    continue;
                }
                Assert.assertNotNull(null);
            }
        }
        if (s.getDbStreamAcesCount() > 0) {
            for (Common.FileACE aceEntry : s.getDbStreamAcesList()) {
                accessType = aceEntry.getAccessType();
                aceParam = "";
                if (accessType == Common.DBStreamAccessType.AceReadDB) {
                    aceParam = ACE_READDB_PARAM;
                } else if (accessType == Common.DBStreamAccessType.AceWriteDB) {
                    aceParam = ACE_WRITEDB_PARAM;
                } else if (accessType == Common.DBStreamAccessType.AceTraverse) {
                    aceParam = ACE_TRAVERSEDB_PARAM;
                }
                if (aceParam.length() > 0) {
                    try {
                        System.out.print("{" + aceParam + " '" + AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8()) + "'}");
                    }
                    catch (Exception e) {
                        System.out.println("Exception while parsing ACE's");
                    }
                    continue;
                }
                Assert.assertNotNull(null);
            }
        }
        try {
            if (s.hasReadAces()) {
                System.out.print("{readaces '" + AceHelper.toInfix((String)s.getReadAces().toStringUtf8()) + "'}");
            }
            if (s.hasWriteAces()) {
                System.out.print("{writeaces '" + AceHelper.toInfix((String)s.getWriteAces().toStringUtf8()) + "'}");
            }
        }
        catch (Exception e) {
            System.out.println("Exception while parsing ACE's");
        }
        CLDBProto.SecureObjectType objType = CLDBProto.SecureObjectType.OBJECT_TYPE_SECURITYPOLICY;
        if (s.hasAcl()) {
            Security.AccessControlList acl = s.getAcl();
            ArrayList<Integer> unknownUids = new ArrayList<Integer>();
            ArrayList<Integer> unknownGids = new ArrayList<Integer>();
            CommandOutput.OutputHierarchy outAcl = AclCommands.formatAcl(acl, objType, "short", this.userInfo, unknownUids, unknownGids);
            boolean isUser = false;
            boolean isGroup = false;
            Object userList = "";
            Object groupList = "";
            for (CommandOutput.OutputHierarchy.OutputNode b : outAcl.getOutputNodes()) {
                for (CommandOutput.OutputHierarchy.OutputNode c : b.getChildren()) {
                    String outNode = c.getValue().toString();
                    if (outNode.startsWith("User")) {
                        userList = (String)userList + " " + outNode.substring(5) + ":";
                        isUser = true;
                        continue;
                    }
                    if (outNode.startsWith("Group")) {
                        groupList = (String)groupList + " " + outNode.substring(6) + ":";
                        isGroup = true;
                        continue;
                    }
                    if (isUser) {
                        userList = (String)userList + outNode.substring(1, outNode.length() - 1).replaceAll("\\s", "");
                        isUser = false;
                        continue;
                    }
                    if (!isGroup) continue;
                    groupList = (String)groupList + outNode.substring(1, outNode.length() - 1).replaceAll("\\s", "");
                    isGroup = false;
                }
            }
            if (!((String)userList).isEmpty()) {
                System.out.print("{user" + (String)userList + "}");
            }
            if (!((String)groupList).isEmpty()) {
                System.out.print("{group" + (String)groupList + "}");
            }
        }
        if (s.hasTaggingAllowed()) {
            System.out.print("{allowtagging " + s.getTaggingAllowed() + "}");
        }
        if (s.hasAccessControl()) {
            System.out.print("{accesscontrol " + s.getAccessControl() + "}");
        }
        System.out.println("}");
    }

    public static PolicyServerProto.LookupSecurityPolicyResponse securityPolicyLookupById(String cluster, Security.CredentialsMsg creds, int securityPolicyId) throws CLIProcessingException, MaprSecurityException {
        return SecurityPolicyCommands.securityPolicyLookup(cluster, creds, null, securityPolicyId);
    }

    public static PolicyServerProto.LookupSecurityPolicyResponse securityPolicyLookupByName(String cluster, Security.CredentialsMsg creds, String securityPolicy) throws CLIProcessingException, MaprSecurityException {
        return SecurityPolicyCommands.securityPolicyLookup(cluster, creds, securityPolicy, 0);
    }

    public static PolicyServerProto.LookupSecurityPolicyResponse securityPolicyLookup(String cluster, Security.CredentialsMsg creds, String securityPolicy, int securityPolicyId) throws CLIProcessingException, MaprSecurityException {
        byte[] data = null;
        PolicyServerProto.LookupSecurityPolicyRequest.Builder securityPolicyInfoBuilder = PolicyServerProto.LookupSecurityPolicyRequest.newBuilder().setCreds(creds);
        if (securityPolicy != null) {
            if (securityPolicyId != 0) {
                LOG.error("Found both id and name in lookup request, aborting.");
                PolicyServerProto.LookupSecurityPolicyResponse.Builder resp = PolicyServerProto.LookupSecurityPolicyResponse.newBuilder();
                return resp.setStatus(22).build();
            }
            securityPolicyInfoBuilder.addPolicyNames(securityPolicy);
        }
        if (securityPolicyId != 0) {
            securityPolicyInfoBuilder.addPolicyIds(securityPolicyId);
        }
        PolicyServerProto.LookupSecurityPolicyRequest securityPolicyInfo = securityPolicyInfoBuilder.build();
        try {
            if (cluster != null) {
                LOG.info("securityPolicyLookup(): Sending request to cluster " + cluster);
                data = PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(cluster, PolicyServerProto.SecurityPolicyProc.LookupSecurityPolicyProc.getNumber(), (MessageLite)securityPolicyInfo, PolicyServerProto.LookupSecurityPolicyResponse.class);
            } else {
                LOG.info("securityPolicyLookup(): Sending request to current cluster");
                data = PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.LookupSecurityPolicyProc.getNumber(), (MessageLite)securityPolicyInfo, PolicyServerProto.LookupSecurityPolicyResponse.class);
            }
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return PolicyServerProto.LookupSecurityPolicyResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing security policy lookup to PolicyServer, " + e.getLocalizedMessage());
        }
    }

    CommandOutput securityPolicyCreate() throws Exception {
        List<Security.AclEntry> elements;
        List values;
        ProcessedInput.Parameter param;
        StringBuilder errmsg;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if (!this.isParamPresent(SECURITY_POLICY_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing security policy name in the command to create security policy").setField(SECURITY_POLICY_NAME_PARAM));
            return output;
        }
        String securityPolicyName = this.getParamTextValue(SECURITY_POLICY_NAME_PARAM, 0).trim();
        if (!this.isValidSecurityPolicyName(securityPolicyName, errmsg = new StringBuilder())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg.toString()));
            return output;
        }
        if ((this.isParamPresent(SECURITY_EXPORT_POLICY_ID_PARAM) || this.isParamPresent(SECURITY_EXPORT_POLICY_VERSION_PARAM) || this.isParamPresent(SECURITY_EXPORT_POLICY_CTIME_PARAM) || this.isParamPresent(SECURITY_EXPORT_POLICY_MTIME_PARAM) || this.isParamPresent(EXPORT_DATA_AUDIT_OPS_VAL_PARAM)) && System.getenv("mapr_policyimport") == null) {
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid option"));
            return output;
        }
        if (this.isParamPresent(ACE_READ_PARAM) && (this.isParamPresent(ACE_READFILE_PARAM) || this.isParamPresent(ACE_EXECUTEFILE_PARAM) || this.isParamPresent(ACE_READDIR_PARAM) || this.isParamPresent(ACE_LOOKUPDIR_PARAM) || this.isParamPresent(ACE_READDB_PARAM) || this.isParamPresent(ACE_TRAVERSEDB_PARAM))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The readaces option cannot be specified with any other read ACE options").setField(ACE_READ_PARAM));
            return output;
        }
        if (this.isParamPresent(ACE_WRITE_PARAM) && (this.isParamPresent(ACE_WRITEFILE_PARAM) || this.isParamPresent(ACE_ADDCHILD_PARAM) || this.isParamPresent(ACE_DELETECHILD_PARAM) || this.isParamPresent(ACE_WRITEDB_PARAM))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The writeaces option cannot be specified with any other write ACE options").setField(ACE_WRITE_PARAM));
            return output;
        }
        PolicyServerProto.SecurityPolicyCreateRequest.Builder securityPolicyCreate = PolicyServerProto.SecurityPolicyCreateRequest.newBuilder();
        Common.SecurityPolicyProperties.Builder spProps = Common.SecurityPolicyProperties.newBuilder().setPolicyName(securityPolicyName);
        PolicyServerProto.LookupSecurityPolicyResponse spLookupResp = SecurityPolicyCommands.securityPolicyLookupByName(cluster, this.getUserCredentials(), securityPolicyName);
        if (spLookupResp.hasStatus() && spLookupResp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "Security policy " + securityPolicyName + " already exists"));
            return output;
        }
        if (this.isParamPresent(SECURITY_EXPORT_POLICY_ID_PARAM)) {
            spProps.setPolicyId(this.getParamIntValue(SECURITY_EXPORT_POLICY_ID_PARAM, 0));
        }
        if (this.isParamPresent(SECURITY_EXPORT_POLICY_VERSION_PARAM)) {
            spProps.setPolicyVersion(this.getParamIntValue(SECURITY_EXPORT_POLICY_VERSION_PARAM, 0));
        }
        if (this.isParamPresent(SECURITY_EXPORT_POLICY_CTIME_PARAM)) {
            spProps.setCtime(this.getParamLongValue(SECURITY_EXPORT_POLICY_CTIME_PARAM, 0));
        }
        if (this.isParamPresent(SECURITY_EXPORT_POLICY_MTIME_PARAM)) {
            spProps.setMtime(this.getParamLongValue(SECURITY_EXPORT_POLICY_MTIME_PARAM, 0));
        }
        if (this.isParamPresent(DESCRIPTION_PARAM)) {
            String desc = this.getParamTextValue(DESCRIPTION_PARAM, 0).trim();
            if (!this.isValidSecurityPolicyDescription(desc, errmsg = new StringBuilder())) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg.toString()));
                return output;
            }
            spProps.setDescription(this.getParamTextValue(DESCRIPTION_PARAM, 0));
        }
        if (this.isParamPresent(ALLOW_TAGGING_PARAM)) {
            boolean allowTagging = this.getParamBooleanValue(ALLOW_TAGGING_PARAM, 0);
            spProps.setTaggingAllowed(allowTagging);
        }
        if (this.isParamPresent(ACCESS_CONTROL_PARAM)) {
            String accessControl = this.getParamTextValue(ACCESS_CONTROL_PARAM, 0);
            if (accessControl.equals("Armed")) {
                spProps.setAccessControl(Common.SecurityPolicyAccessControl.Armed);
            } else if (accessControl.equals("Disarmed")) {
                spProps.setAccessControl(Common.SecurityPolicyAccessControl.Disarmed);
            } else if (accessControl.equals("Denied")) {
                spProps.setAccessControl(Common.SecurityPolicyAccessControl.Denied);
            } else {
                out.addMessage(this.getCommandUsage());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid value for accesscontrol"));
                return output;
            }
        }
        if (this.isParamPresent(AUDIT_ENABLED_PARAM)) {
            boolean auditDataAccess = this.getParamBooleanValue(AUDIT_ENABLED_PARAM, 0);
            spProps.setAuditDataAccess(auditDataAccess);
        }
        if (this.isParamPresent(WIRE_SECURITY_ENABLED)) {
            boolean wireEncrypt = this.getParamBooleanValue(WIRE_SECURITY_ENABLED, 0);
            spProps.setWireSecurityEnabled(wireEncrypt);
        }
        ArrayList<Common.FSAuditOperations> fsAuditEnableOperations = new ArrayList<Common.FSAuditOperations>();
        ArrayList<Common.FSAuditOperations> fsAuditDisableOperations = new ArrayList<Common.FSAuditOperations>();
        if (this.isParamPresent(DATA_AUDIT_OPS_PARAM)) {
            String fsOperations = this.getParamTextValue(DATA_AUDIT_OPS_PARAM, 0);
            if (!VolumeCommands.validateAndAddFsOperations(fsAuditEnableOperations, fsAuditDisableOperations, fsOperations, true)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid dataauditops text specified, text = " + fsOperations));
                return output;
            }
        } else if (this.isParamPresent(EXPORT_DATA_AUDIT_OPS_VAL_PARAM)) {
            spProps.setFsAuditDisabledOperations(this.getParamLongValue(EXPORT_DATA_AUDIT_OPS_VAL_PARAM, 0));
        }
        if (fsAuditEnableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditEnableOperations.size() > 1) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying +all,  cannot enable any other operation"));
            return output;
        }
        if (fsAuditDisableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditDisableOperations.size() > 1) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying -all,  cannot disable any other operation"));
            return output;
        }
        if (fsAuditEnableOperations.size() > 0 && fsAuditDisableOperations.size() > 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot mix enable and disable dataaudit ops"));
            return output;
        }
        securityPolicyCreate.addAllFsAuditEnabledOperations(fsAuditEnableOperations);
        securityPolicyCreate.addAllFsAuditDisabledOperations(fsAuditDisableOperations);
        Common.FileACEs.Builder fileAcesBuilder = Common.FileACEs.newBuilder();
        ArrayList<Common.DBStreamAceEntry> dbAcesBuilder = new ArrayList<Common.DBStreamAceEntry>();
        if (this.buildAces(fileAcesBuilder, dbAcesBuilder, out) < 0) {
            return output;
        }
        if (fileAcesUpdated) {
            spProps.setFileAces(fileAcesBuilder);
        }
        if (dbAcesUpdated) {
            spProps.addAllDbStreamAces(dbAcesBuilder);
        }
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
        boolean principalPresent = false;
        CLDBProto.SecureObjectType objType = CLDBProto.SecureObjectType.OBJECT_TYPE_SECURITYPOLICY;
        if (this.isParamPresent(UID_PARAM_NAME)) {
            principalPresent = true;
            param = this.input.getParameterByName(UID_PARAM_NAME);
            values = param.getParamValues();
            elements = AclCommands.actionsToAcls(values, this.userInfo, objType, true, out);
            if (elements == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl set failed - invalid list of user permissions, valid permissions are: [r, a, fc]").setField(UID_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (this.isParamPresent(GID_PARAM_NAME)) {
            principalPresent = true;
            param = this.input.getParameterByName(GID_PARAM_NAME);
            values = param.getParamValues();
            elements = AclCommands.actionsToAcls(values, this.userInfo, objType, false, out);
            if (elements == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl set failed - invalid list of group permissions, valid permissions are: [r, a, fc]").setField(GID_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (principalPresent) {
            spProps.setAcl(aclBuilder);
        }
        byte[] data = null;
        Common.SecurityPolicyProperties newSpProp = AceUtil.compactSecurityPolicyAces((Common.SecurityPolicyProperties)spProps.build());
        securityPolicyCreate.setProperties(newSpProp);
        securityPolicyCreate.setCreds(this.getUserCredentials());
        data = this.isParamPresent("cluster") ? PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(this.getParamTextValue("cluster", 0), PolicyServerProto.SecurityPolicyProc.SecurityPolicyCreateProc.getNumber(), (MessageLite)securityPolicyCreate.build(), PolicyServerProto.SecurityPolicyCreateResponse.class) : PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.SecurityPolicyCreateProc.getNumber(), (MessageLite)securityPolicyCreate.build(), PolicyServerProto.SecurityPolicyCreateResponse.class);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the PolicyServer. Check if PolicyServer is up and running."));
            return output;
        }
        PolicyServerProto.SecurityPolicyCreateResponse resp = PolicyServerProto.SecurityPolicyCreateResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully created security policy '" + securityPolicyName + "'");
        } else {
            String errMsg = "Security policy create of " + securityPolicyName + " failed";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + ": " + resp.getErrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg).setField(SECURITY_POLICY_NAME_PARAM).setFieldValue(securityPolicyName));
        }
        return output;
    }

    CommandOutput securityPolicyModify() throws Exception {
        List<Security.AclEntry> elements;
        List values;
        ProcessedInput.Parameter param;
        ArrayList<Common.DBStreamAceEntry> dbAcesBuilder;
        String fsOperations;
        StringBuilder errmsg;
        String securityPolicyName = null;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if (!this.isParamPresent(SECURITY_POLICY_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing security policy name in the command to modify security policy").setField(SECURITY_POLICY_NAME_PARAM));
            return output;
        }
        securityPolicyName = this.getParamTextValue(SECURITY_POLICY_NAME_PARAM, 0);
        if (!this.isValidSecurityPolicyName(securityPolicyName, errmsg = new StringBuilder())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg.toString()));
            return output;
        }
        if ((this.isParamPresent(SECURITY_EXPORT_POLICY_ID_PARAM) || this.isParamPresent(SECURITY_EXPORT_POLICY_VERSION_PARAM) || this.isParamPresent(SECURITY_EXPORT_POLICY_CTIME_PARAM) || this.isParamPresent(SECURITY_EXPORT_POLICY_MTIME_PARAM) || this.isParamPresent(EXPORT_DATA_AUDIT_OPS_VAL_PARAM)) && System.getenv("mapr_policyimport") == null) {
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid option"));
            return output;
        }
        if (this.isParamPresent(ACE_READ_PARAM) && (this.isParamPresent(ACE_READFILE_PARAM) || this.isParamPresent(ACE_EXECUTEFILE_PARAM) || this.isParamPresent(ACE_READDIR_PARAM) || this.isParamPresent(ACE_LOOKUPDIR_PARAM) || this.isParamPresent(ACE_READDB_PARAM) || this.isParamPresent(ACE_TRAVERSEDB_PARAM))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The readaces option cannot be specified with any other read ACE options").setField(ACE_READ_PARAM));
            return output;
        }
        if (this.isParamPresent(ACE_WRITE_PARAM) && (this.isParamPresent(ACE_WRITEFILE_PARAM) || this.isParamPresent(ACE_ADDCHILD_PARAM) || this.isParamPresent(ACE_DELETECHILD_PARAM) || this.isParamPresent(ACE_WRITEDB_PARAM))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The writeaces option cannot be specified with any other write ACE options").setField(ACE_WRITE_PARAM));
            return output;
        }
        PolicyServerProto.SecurityPolicyUpdateRequest.Builder securityPolicyUpdate = PolicyServerProto.SecurityPolicyUpdateRequest.newBuilder();
        Common.SecurityPolicyProperties.Builder spProps = Common.SecurityPolicyProperties.newBuilder().setPolicyName(securityPolicyName);
        LOG.info("securityPolicyModify(): Verifying that " + securityPolicyName + " refers to an existing security policy");
        PolicyServerProto.LookupSecurityPolicyResponse spLookupResp = SecurityPolicyCommands.securityPolicyLookupByName(cluster, this.getUserCredentials(), securityPolicyName);
        if (spLookupResp.hasStatus() && spLookupResp.getStatus() != 0) {
            if (spLookupResp.getStatus() == 2) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Non-existent security policy"));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(spLookupResp.getStatus(), spLookupResp.getErrMsg()));
            }
            return output;
        }
        if (this.isParamPresent(SECURITY_EXPORT_POLICY_ID_PARAM)) {
            spProps.setPolicyId(this.getParamIntValue(SECURITY_EXPORT_POLICY_ID_PARAM, 0));
        }
        if (this.isParamPresent(SECURITY_EXPORT_POLICY_VERSION_PARAM)) {
            spProps.setPolicyVersion(this.getParamIntValue(SECURITY_EXPORT_POLICY_VERSION_PARAM, 0));
        }
        if (this.isParamPresent(SECURITY_EXPORT_POLICY_CTIME_PARAM)) {
            spProps.setCtime(this.getParamLongValue(SECURITY_EXPORT_POLICY_CTIME_PARAM, 0));
        }
        if (this.isParamPresent(SECURITY_EXPORT_POLICY_MTIME_PARAM)) {
            spProps.setMtime(this.getParamLongValue(SECURITY_EXPORT_POLICY_MTIME_PARAM, 0));
        }
        if (this.isParamPresent(ALLOW_TAGGING_PARAM)) {
            boolean allowTagging = this.getParamBooleanValue(ALLOW_TAGGING_PARAM, 0);
            spProps.setTaggingAllowed(allowTagging);
        }
        if (this.isParamPresent(ACCESS_CONTROL_PARAM)) {
            String accessControl = this.getParamTextValue(ACCESS_CONTROL_PARAM, 0);
            if (accessControl.equals("Armed")) {
                spProps.setAccessControl(Common.SecurityPolicyAccessControl.Armed);
            } else if (accessControl.equals("Disarmed")) {
                spProps.setAccessControl(Common.SecurityPolicyAccessControl.Disarmed);
            } else if (accessControl.equals("Denied")) {
                spProps.setAccessControl(Common.SecurityPolicyAccessControl.Denied);
            } else {
                out.addMessage(this.getCommandUsage());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid value for accesscontrol"));
                return output;
            }
        }
        if (this.isParamPresent(DESCRIPTION_PARAM)) {
            String description = this.getParamTextValue(DESCRIPTION_PARAM, 0).trim();
            if (!this.isValidSecurityPolicyDescription(description, errmsg = new StringBuilder())) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg.toString()));
                return output;
            }
            spProps.setDescription(description);
        }
        if (this.isParamPresent(AUDIT_ENABLED_PARAM)) {
            boolean auditDataAccess = this.getParamBooleanValue(AUDIT_ENABLED_PARAM, 0);
            spProps.setAuditDataAccess(auditDataAccess);
        }
        if (this.isParamPresent(WIRE_SECURITY_ENABLED)) {
            boolean wireEncrypt = this.getParamBooleanValue(WIRE_SECURITY_ENABLED, 0);
            spProps.setWireSecurityEnabled(wireEncrypt);
        }
        if (this.isParamPresent(DISABLE_DATA_AUDIT_OPS_PARAM) && this.isParamPresent(DATA_AUDIT_OPS_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "either of dataauditops or disabledataauditops can be used, but not both."));
            return output;
        }
        ArrayList<Common.FSAuditOperations> fsAuditEnableOperations = new ArrayList<Common.FSAuditOperations>();
        ArrayList<Common.FSAuditOperations> fsAuditDisableOperations = new ArrayList<Common.FSAuditOperations>();
        if (this.isParamPresent(DISABLE_DATA_AUDIT_OPS_PARAM)) {
            fsOperations = this.getParamTextValue(DISABLE_DATA_AUDIT_OPS_PARAM, 0);
            securityPolicyUpdate.setReplaceDisabledAuditOps(true);
            if (fsOperations.equals("")) {
                fsAuditEnableOperations.add(Common.FSAuditOperations.AuditAll);
            } else if (!VolumeCommands.validateAndAddFsOperations(fsAuditEnableOperations, fsAuditDisableOperations, fsOperations, false)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid disabledataauditops text specified, text = " + fsOperations));
                return output;
            }
        } else if (this.isParamPresent(DATA_AUDIT_OPS_PARAM)) {
            fsOperations = this.getParamTextValue(DATA_AUDIT_OPS_PARAM, 0);
            if (!VolumeCommands.validateAndAddFsOperations(fsAuditEnableOperations, fsAuditDisableOperations, fsOperations, true)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid dataauditops text specified, text = " + fsOperations));
                return output;
            }
            if (this.isParamPresent(EXPORT_DATA_AUDIT_OPS_VAL_PARAM)) {
                spProps.setFsAuditDisabledOperations(this.getParamLongValue(EXPORT_DATA_AUDIT_OPS_VAL_PARAM, 0));
            }
        }
        if (fsAuditEnableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditEnableOperations.size() > 1) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying +all,  cannot enable any other operation"));
            return output;
        }
        if (fsAuditDisableOperations.contains(Common.FSAuditOperations.AuditAll) && fsAuditDisableOperations.size() > 1) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "When specifying -all,  cannot disable any other operation"));
            return output;
        }
        for (int i = 0; i < fsAuditEnableOperations.size(); ++i) {
            if (!fsAuditDisableOperations.contains(fsAuditEnableOperations.get(i))) continue;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot specify an audit operation both for enable and disable"));
            return output;
        }
        if (fsAuditEnableOperations.size() > 0) {
            securityPolicyUpdate.addAllFsAuditEnabledOperations(fsAuditEnableOperations);
        }
        if (fsAuditDisableOperations.size() > 0) {
            securityPolicyUpdate.addAllFsAuditDisabledOperations(fsAuditDisableOperations);
        }
        for (Common.FSAuditOperations op : fsAuditEnableOperations) {
            LOG.debug("Enable Op = " + op.toString());
        }
        for (Common.FSAuditOperations op : fsAuditDisableOperations) {
            LOG.debug("Disable Op = " + op.toString());
        }
        Common.FileACEs.Builder fileAcesBuilder = Common.FileACEs.newBuilder();
        if (this.buildAces(fileAcesBuilder, dbAcesBuilder = new ArrayList<Common.DBStreamAceEntry>(), out) < 0) {
            return output;
        }
        if (fileAcesUpdated) {
            spProps.setFileAces(fileAcesBuilder);
        }
        if (dbAcesUpdated) {
            spProps.addAllDbStreamAces(dbAcesBuilder);
        }
        Security.AccessControlList.Builder aclBuilder = null;
        boolean principalPresent = false;
        CLDBProto.SecureObjectType objType = CLDBProto.SecureObjectType.OBJECT_TYPE_SECURITYPOLICY;
        if (this.isParamPresent(UID_PARAM_NAME)) {
            aclBuilder = Security.AccessControlList.newBuilder();
            principalPresent = true;
            param = this.input.getParameterByName(UID_PARAM_NAME);
            values = param.getParamValues();
            elements = AclCommands.actionsToAcls(values, this.userInfo, objType, true, out);
            if (elements == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl set failed - invalid list of user permissions, valid permissions are: [r, a, fc]").setField(UID_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (this.isParamPresent(GID_PARAM_NAME)) {
            if (!principalPresent) {
                aclBuilder = Security.AccessControlList.newBuilder();
                principalPresent = true;
            }
            if ((elements = AclCommands.actionsToAcls(values = (param = this.input.getParameterByName(GID_PARAM_NAME)).getParamValues(), this.userInfo, objType, false, out)) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl set failed - invalid list of group permissions, valid permissions are: [r, a, fc]").setField(GID_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (principalPresent) {
            spProps.setAcl(aclBuilder);
        }
        byte[] data = null;
        securityPolicyUpdate.setProperties(spProps.build());
        securityPolicyUpdate.setCreds(this.getUserCredentials());
        data = this.isParamPresent("cluster") ? PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(this.getParamTextValue("cluster", 0), PolicyServerProto.SecurityPolicyProc.SecurityPolicyUpdateProc.getNumber(), (MessageLite)securityPolicyUpdate.build(), PolicyServerProto.SecurityPolicyUpdateResponse.class) : PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.SecurityPolicyUpdateProc.getNumber(), (MessageLite)securityPolicyUpdate.build(), PolicyServerProto.SecurityPolicyUpdateResponse.class);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Cannot connect to the policy server"));
            return output;
        }
        PolicyServerProto.SecurityPolicyUpdateResponse resp = PolicyServerProto.SecurityPolicyUpdateResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully updated security policy '" + securityPolicyName + "'");
        } else {
            String errMsg = "Security policy update of " + securityPolicyName + " failed";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + ": " + resp.getErrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg).setField(SECURITY_POLICY_NAME_PARAM).setFieldValue(securityPolicyName));
        }
        return output;
    }

    CommandOutput securityPolicyInfo() throws Exception {
        String opParam;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(SECURITY_POLICY_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing security policy name in the command to create security policy").setField(SECURITY_POLICY_NAME_PARAM));
            return output;
        }
        String securityPolicyName = this.getParamTextValue(SECURITY_POLICY_NAME_PARAM, 0);
        if (securityPolicyName == null) {
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Security policy name argument missing."));
            return output;
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        String string = opParam = this.isParamPresent(OUTPUT_PARAM) ? this.getParamTextValue(OUTPUT_PARAM, 0) : "verbose";
        if (!opParam.equals("terse") && !opParam.equals("verbose")) {
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The output parameter must be either verbose or terse (default verbose). "));
            return output;
        }
        LOG.info("securityPolicyInfo: Looking up security policy name " + securityPolicyName);
        PolicyServerProto.LookupSecurityPolicyResponse resp = SecurityPolicyCommands.securityPolicyLookupByName(cluster, this.getUserCredentials(), securityPolicyName);
        if (resp.getStatus() == 0) {
            LOG.info("securityPolicyInfo: Lookup of security policy name " + securityPolicyName + " successful");
            boolean terse = opParam.equals("terse");
            BitSet columns = this.getColumns();
            CommandOutput.OutputHierarchy.OutputNode securityPolicyInfo = this.formatSecurityPolicyProperties(resp.getProperties(0), terse, columns);
            out.addNode(securityPolicyInfo);
        } else {
            LOG.info("securityPolicyInfo: Lookup of security policy name " + securityPolicyName + " failed, status=" + Errno.toString((int)resp.getStatus()));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Security policy lookup of " + securityPolicyName + " failed, " + (resp.getStatus() == 2 ? "No such security policy" : resp.getErrMsg())));
        }
        return output;
    }

    int buildAces(Common.FileACEs.Builder fileAcesBuilder, List<Common.DBStreamAceEntry> dbAcesBuilder, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String expr = "";
        if (this.isParamPresent(ACE_READ_PARAM)) {
            try {
                expr = this.getParamTextValue(ACE_READ_PARAM, 0);
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceRead).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceLookupDir).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceReadDir).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceExecute).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                dbAcesBuilder.add(Common.DBStreamAceEntry.newBuilder().setAccessType(Common.DBStreamAccessType.AceReadDB).setExpr(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                dbAcesBuilder.add(Common.DBStreamAceEntry.newBuilder().setAccessType(Common.DBStreamAccessType.AceTraverse).setExpr(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                dbAcesUpdated = true;
                fileAcesUpdated = true;
            }
            catch (IOException e) {
                LOG.error("Unable to parse security policy readaces arguments");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error parsing read security policy ACEs: " + e.getMessage()));
                return -1;
            }
        }
        if (this.isParamPresent(ACE_WRITE_PARAM)) {
            try {
                expr = this.getParamTextValue(ACE_WRITE_PARAM, 0);
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceWrite).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceAddChild).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceDeleteChild).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                dbAcesBuilder.add(Common.DBStreamAceEntry.newBuilder().setAccessType(Common.DBStreamAccessType.AceWriteDB).setExpr(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                dbAcesUpdated = true;
                fileAcesUpdated = true;
            }
            catch (IOException e) {
                LOG.error("Unable to parse security policy readaces arguments");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error parsing write security policy ACEs: " + e.getMessage()));
                return -1;
            }
        }
        try {
            if (this.isParamPresent(ACE_READFILE_PARAM)) {
                expr = this.getParamTextValue(ACE_READFILE_PARAM, 0);
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceRead).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesUpdated = true;
            }
            if (this.isParamPresent(ACE_WRITEFILE_PARAM)) {
                expr = this.getParamTextValue(ACE_WRITEFILE_PARAM, 0);
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceWrite).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesUpdated = true;
            }
            if (this.isParamPresent(ACE_EXECUTEFILE_PARAM)) {
                expr = this.getParamTextValue(ACE_EXECUTEFILE_PARAM, 0);
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceExecute).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesUpdated = true;
            }
            if (this.isParamPresent(ACE_READDIR_PARAM)) {
                expr = this.getParamTextValue(ACE_READDIR_PARAM, 0);
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceReadDir).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesUpdated = true;
            }
            if (this.isParamPresent(ACE_ADDCHILD_PARAM)) {
                expr = this.getParamTextValue(ACE_ADDCHILD_PARAM, 0);
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceAddChild).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesUpdated = true;
            }
            if (this.isParamPresent(ACE_DELETECHILD_PARAM)) {
                expr = this.getParamTextValue(ACE_DELETECHILD_PARAM, 0);
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceDeleteChild).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesUpdated = true;
            }
            if (this.isParamPresent(ACE_LOOKUPDIR_PARAM)) {
                expr = this.getParamTextValue(ACE_LOOKUPDIR_PARAM, 0);
                fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceLookupDir).setBoolExp(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                fileAcesUpdated = true;
            }
            if (this.isParamPresent(ACE_READDB_PARAM)) {
                expr = this.getParamTextValue(ACE_READDB_PARAM, 0);
                dbAcesBuilder.add(Common.DBStreamAceEntry.newBuilder().setAccessType(Common.DBStreamAccessType.AceReadDB).setExpr(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                dbAcesUpdated = true;
            }
            if (this.isParamPresent(ACE_WRITEDB_PARAM)) {
                expr = this.getParamTextValue(ACE_WRITEDB_PARAM, 0);
                dbAcesBuilder.add(Common.DBStreamAceEntry.newBuilder().setAccessType(Common.DBStreamAccessType.AceWriteDB).setExpr(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                dbAcesUpdated = true;
            }
            if (this.isParamPresent(ACE_TRAVERSEDB_PARAM)) {
                expr = this.getParamTextValue(ACE_TRAVERSEDB_PARAM, 0);
                dbAcesBuilder.add(Common.DBStreamAceEntry.newBuilder().setAccessType(Common.DBStreamAccessType.AceTraverse).setExpr(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)expr))).build());
                dbAcesUpdated = true;
            }
        }
        catch (IOException e) {
            LOG.error("Unable to parse security policy ace arguments");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error parsing security policy ACEs: " + e.getMessage()));
            return -1;
        }
        return 0;
    }

    CommandOutput.OutputHierarchy.OutputNode formatSecurityPolicyProperties(Common.SecurityPolicyProperties secPolProps, boolean terse, BitSet columns) throws CLIProcessingException {
        LOG.debug("formatSecurityPolicyProperties, formatting security policy " + secPolProps.getPolicyName());
        CommandOutput.OutputHierarchy.OutputNode securityPolicyProperties = new CommandOutput.OutputHierarchy.OutputNode();
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.policyName.getNumber())) {
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.policyName).getName(terse), (Object)secPolProps.getPolicyName()));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.policyId.getNumber())) {
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.policyId).getName(terse), secPolProps.getPolicyId()));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.description.getNumber()) && secPolProps.hasDescription()) {
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.description).getName(terse), (Object)secPolProps.getDescription()));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.mtime.getNumber()) && secPolProps.hasMtime()) {
            String modificationTime = "";
            modificationTime = terse ? String.valueOf(secPolProps.getMtime()) : new Date(secPolProps.getMtime()).toString();
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.mtime).getName(terse), (Object)modificationTime));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.ctime.getNumber()) && secPolProps.hasCtime()) {
            String createTime = "";
            createTime = terse ? String.valueOf(secPolProps.getCtime()) : new Date(secPolProps.getCtime()).toString();
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.ctime).getName(terse), (Object)createTime));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.wireSecurityEnabled.getNumber()) && secPolProps.hasWireSecurityEnabled()) {
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.wireSecurityEnabled).getName(terse), (Object)(secPolProps.getWireSecurityEnabled() ? 1 : 0)));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.auditDataAccess.getNumber()) && secPolProps.hasAuditDataAccess()) {
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.auditDataAccess).getName(terse), (Object)(secPolProps.getAuditDataAccess() ? 1 : 0)));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.allowTagging.getNumber()) && secPolProps.hasTaggingAllowed()) {
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.allowTagging).getName(terse), (Object)(secPolProps.getTaggingAllowed() ? 1 : 0)));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.accessControl.getNumber()) && secPolProps.hasAccessControl()) {
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.accessControl).getName(terse), (Object)secPolProps.getAccessControl()));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.auditEnableOperations.getNumber()) && secPolProps.hasFsAuditDisabledOperations()) {
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.auditEnableOperations).getName(terse), (Object)GetStringsForAuditOps.getEnabledOps((long)secPolProps.getFsAuditDisabledOperations())));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.auditDisableOperations.getNumber()) && secPolProps.hasFsAuditDisabledOperations()) {
            securityPolicyProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.auditDisableOperations).getName(terse), (Object)GetStringsForAuditOps.getDisabledOps((long)secPolProps.getFsAuditDisabledOperations())));
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.policyAcl.getNumber())) {
            CLDBProto.SecureObjectType objType = CLDBProto.SecureObjectType.OBJECT_TYPE_SECURITYPOLICY;
            if (secPolProps.hasAcl()) {
                Security.AccessControlList acl = secPolProps.getAcl();
                ArrayList<Integer> unknownUids = new ArrayList<Integer>();
                ArrayList<Integer> unknownGids = new ArrayList<Integer>();
                CommandOutput.OutputHierarchy outAcl = AclCommands.formatAcl(acl, objType, "short", this.userInfo, unknownUids, unknownGids);
                for (CommandOutput.OutputHierarchy.OutputError e : outAcl.getOutputErrors()) {
                    LOG.info("Error in output:" + e.toString());
                }
                for (CommandOutput.OutputHierarchy.OutputNode b : outAcl.getOutputNodes()) {
                    securityPolicyProperties.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.policyAcl).getName(terse), (Object)b));
                }
            }
        }
        if (columns.get(PolicyServerProto.SecurityPolicyInfoFields.policyAces.getNumber()) && (secPolProps.hasFileAces() || secPolProps.getDbStreamAcesCount() > 0 || secPolProps.hasReadAces() || secPolProps.hasWriteAces())) {
            if (this.isParamPresent(EXPAND_ACES_PARAM) && this.getParamBooleanValue(EXPAND_ACES_PARAM, 0)) {
                secPolProps = AceUtil.expandSecurityPolicyAces((Common.SecurityPolicyProperties)secPolProps);
            }
            CommandOutput.OutputHierarchy.OutputNode securityPolicyAcesNode = new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.SecurityPolicyInfoFields.policyAces).getName(terse));
            try {
                String aceParam;
                Common.FSAccessType accessType;
                if (secPolProps.hasReadAces()) {
                    securityPolicyAcesNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ACE_READ_PARAM, (Object)AceHelper.toInfix((String)secPolProps.getReadAces().toStringUtf8())));
                }
                for (Common.FileACE aceEntry : secPolProps.getFileAces().getAcesList()) {
                    accessType = aceEntry.getAccessType();
                    aceParam = "";
                    if (accessType == Common.FSAccessType.AceRead) {
                        aceParam = ACE_READFILE_PARAM;
                    } else if (accessType == Common.FSAccessType.AceWrite) {
                        aceParam = ACE_WRITEFILE_PARAM;
                    } else if (accessType == Common.FSAccessType.AceExecute) {
                        aceParam = ACE_EXECUTEFILE_PARAM;
                    } else if (accessType == Common.FSAccessType.AceReadDir) {
                        aceParam = ACE_READDIR_PARAM;
                    } else if (accessType == Common.FSAccessType.AceAddChild) {
                        aceParam = ACE_ADDCHILD_PARAM;
                    } else if (accessType == Common.FSAccessType.AceDeleteChild) {
                        aceParam = ACE_DELETECHILD_PARAM;
                    } else if (accessType == Common.FSAccessType.AceLookupDir) {
                        aceParam = ACE_LOOKUPDIR_PARAM;
                    }
                    if (aceParam.length() > 0) {
                        securityPolicyAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(aceParam, (Object)AceHelper.toInfix((String)aceEntry.getBoolExp().toStringUtf8())));
                        continue;
                    }
                    Assert.assertNotNull(null);
                }
                for (Common.FileACE aceEntry : secPolProps.getDbStreamAcesList()) {
                    accessType = aceEntry.getAccessType();
                    aceParam = "";
                    if (accessType == Common.DBStreamAccessType.AceReadDB) {
                        aceParam = ACE_READDB_PARAM;
                    } else if (accessType == Common.DBStreamAccessType.AceWriteDB) {
                        aceParam = ACE_WRITEDB_PARAM;
                    } else if (accessType == Common.DBStreamAccessType.AceTraverse) {
                        aceParam = ACE_TRAVERSEDB_PARAM;
                    }
                    if (aceParam.length() > 0) {
                        securityPolicyAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(aceParam, (Object)AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
                        continue;
                    }
                    Assert.assertNotNull(null);
                }
                if (secPolProps.hasWriteAces()) {
                    securityPolicyAcesNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ACE_WRITE_PARAM, (Object)AceHelper.toInfix((String)secPolProps.getWriteAces().toStringUtf8())));
                }
            }
            catch (IOException e) {
                LOG.error("Unable to parse data access ACEs");
                throw new CLIProcessingException("Unable to parse data access ACEs");
            }
            securityPolicyProperties.addChild(securityPolicyAcesNode);
        }
        if (securityPolicyProperties.getChildren().isEmpty()) {
            throw new CLIProcessingException("No columns found in output");
        }
        return securityPolicyProperties;
    }

    CommandOutput securityPolicyList() throws CLIProcessingException {
        try {
            String opParam;
            String sortbyStr;
            CLDBProto.ListSortKey sortKey;
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            CommandOutput output = new CommandOutput();
            output.setOutput(out);
            if (this.isParamPresent(SORTBY_PARAM) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM, 0)).toLowerCase())) == null) {
                LOG.error("failed to list sorted security policies, " + sortbyStr + " is not a valid keyword to sort security policies.");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
                return output;
            }
            if (this.isParamPresent(SORTING_ORDER_PARAM)) {
                if (!this.isParamPresent(SORTBY_PARAM)) {
                    String msg = "Invalid use of sortorder. Must be used with sortby";
                    LOG.error(msg);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
                String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM, 0);
                if (!sortOrder.equalsIgnoreCase(ASCENDING_SORTING_ORDER_PARAM) && !sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM)) {
                    String msg = "Invalid value for sortorder. Valid values are asc and desc";
                    LOG.error(msg);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
            }
            String string = opParam = this.isParamPresent(OUTPUT_PARAM) ? this.getParamTextValue(OUTPUT_PARAM, 0) : "verbose";
            if (!opParam.equals("terse") && !opParam.equals("verbose")) {
                out.addMessage(this.getCommandUsage());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The output parameter must be either verbose or terse (default verbose). "));
                return output;
            }
            this.list(out);
            return output;
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request exception", (Throwable)e);
        }
    }

    boolean isValidSecurityPolicyName(String name, StringBuilder errmsg) {
        if (name == null) {
            errmsg.append("Security Policy Name not found.");
            return false;
        }
        if (name.length() < 0 || name.length() > SECURITY_POLICY_NAME_MAX_LEN) {
            errmsg.append("Invalid security policy name length " + name.length() + ", valid range is between 0 and " + SECURITY_POLICY_NAME_MAX_LEN);
            return false;
        }
        Matcher m = validNamePattern.matcher(name);
        if (!m.matches()) {
            errmsg.append("Invalid characters in security policy name '" + name + "'. Only alphanumeric, hyphen(-) and underscore(_) are allowed.");
            return false;
        }
        return true;
    }

    private BitSet getColumns() throws CLIProcessingException {
        String columnsString;
        BitSet columns = new BitSet(fieldTable.size());
        columns.set(0, MAX_SECURITYPOLICYFIELDINFO + 1);
        String string = columnsString = this.isParamPresent(COLUMNS_PARAM) ? this.getParamTextValue(COLUMNS_PARAM, 0) : null;
        if (columnsString != null && !columnsString.equals("all")) {
            columns = FilterUtil.getColumns(fieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    boolean isValidSecurityPolicyDescription(String desc, StringBuilder errmsg) {
        if (desc == null) {
            errmsg.append("Security Policy description not found.");
            return false;
        }
        if (desc.length() < 0 || desc.length() > SECURITY_POLICY_DESCRIPTION_MAX_LEN) {
            errmsg.append("Invalid security policy description length " + desc.length() + ", valid range is between 0 and " + SECURITY_POLICY_DESCRIPTION_MAX_LEN);
            return false;
        }
        Matcher m = validDescPattern.matcher(desc);
        if (!m.matches()) {
            errmsg.append("Invalid characters in security policy description '" + desc + "'. Only alphanumeric, hyphen(-) and underscore(_) are allowed.");
            return false;
        }
        return true;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        PolicyServerProto.SecurityPolicyListResponse resp = (PolicyServerProto.SecurityPolicyListResponse)response;
        boolean terse = this.getParamTextValue(OUTPUT_PARAM, 0).equals("terse");
        BitSet columns = this.getColumns();
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            return;
        }
        for (Common.SecurityPolicyProperties s : resp.getPropertiesList()) {
            if (this.export) {
                this.exportSecPol(s);
                continue;
            }
            try {
                CommandOutput.OutputHierarchy.OutputNode securityPolicyProperties = this.formatSecurityPolicyProperties(s, terse, columns);
                out.addNode(securityPolicyProperties);
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            }
            catch (Exception e) {
                LOG.error("Exception while trying to list security policies", (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Exception while trying to list security policies"));
            }
        }
        if (resp.getPropertiesList().size() > 0) {
            LOG.info("Total number of security policies from list response is " + resp.getPropertiesList().size());
            LOG.info("Total number of security policies so far is " + (totalSecurityPolicies += resp.getPropertiesList().size()));
            out.setTotal(totalSecurityPolicies);
        }
    }

    public PolicyServerProto.SecurityPolicyListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        PolicyServerProto.SecurityPolicyListRequest req = (PolicyServerProto.SecurityPolicyListRequest)request;
        byte[] replyData = null;
        try {
            replyData = this.isParamPresent("cluster") ? PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(this.getParamTextValue("cluster", 0), PolicyServerProto.SecurityPolicyProc.SecurityPolicyListProc.getNumber(), (MessageLite)req, PolicyServerProto.SecurityPolicyListResponse.class) : PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.SecurityPolicyListProc.getNumber(), (MessageLite)req, PolicyServerProto.SecurityPolicyListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return PolicyServerProto.SecurityPolicyListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into SecurityPolicyListResponse proto object.", (Throwable)ipbe);
            }
        }
        LOG.error("RPC Request to list security policies failed. No data returned");
        return null;
    }

    private int getLimitParamValue() throws CLIProcessingException {
        return this.isParamPresent(LIMIT_PARAM) ? this.getParamIntValue(LIMIT_PARAM, 0) : Integer.MAX_VALUE;
    }

    private int getStartParamValue() throws CLIProcessingException {
        return this.isParamPresent(START_PARAM) ? this.getParamIntValue(START_PARAM, 0) : 0;
    }

    private PolicyServerProto.SecurityPolicyListRequest.Builder getSecurityPolicyListRequestBuilder() throws CLIProcessingException {
        List<CLIProto.Filter> filters = this.getFilters(fieldTable, FILTER_PARAM);
        BitSet columns = this.getColumns();
        ByteString bString = ByteString.copyFrom((byte[])BitSetBytesHelperUtils.toByteArray((BitSet)columns));
        PolicyServerProto.SecurityPolicyListRequest.Builder req = PolicyServerProto.SecurityPolicyListRequest.newBuilder();
        if (this.isParamPresent(SORTBY_PARAM)) {
            String sortbyStr = this.getParamTextValue(SORTBY_PARAM, 0);
            CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
            req.setSortKey(sortKey);
            if (this.isParamPresent(SORTING_ORDER_PARAM)) {
                String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM, 0);
                boolean order = false;
                if (sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM)) {
                    order = true;
                }
                req.setSortDescending(order);
            }
        }
        CLIProto.Limiter limiter = this.getNextLimiter(this.getStartParamValue(), 0, this.getStartParamValue(), this.getLimitParamValue(), 100);
        return req.setCreds(this.getUserCredentials()).addAllFilter(filters).setColumnsAdd(bString).setLimiter(limiter);
    }

    public PolicyServerProto.SecurityPolicyListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        PolicyServerProto.SecurityPolicyListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? PolicyServerProto.SecurityPolicyListRequest.newBuilder((PolicyServerProto.SecurityPolicyListRequest)((PolicyServerProto.SecurityPolicyListRequest)prevReq)) : this.getSecurityPolicyListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((PolicyServerProto.SecurityPolicyListResponse)prevResp).getPropertiesCount();
            int origStart = this.getStartParamValue();
            int origLimit = this.getLimitParamValue();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        } else {
            totalSecurityPolicies = 0;
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getStartParamValue(), this.getLimitParamValue(), ((PolicyServerProto.SecurityPolicyListRequest)prevReq).getLimiter().getStart(), ((PolicyServerProto.SecurityPolicyListResponse)prevResp).getPropertiesCount());
    }

    static {
        nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
        PolicyServerProto.SecurityPolicyInfoFields[] values = PolicyServerProto.SecurityPolicyInfoFields.values();
        int max = 0;
        for (PolicyServerProto.SecurityPolicyInfoFields value : values) {
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_SECURITYPOLICYFIELDINFO = max;
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.ListSortKey key : CLDBProto.ListSortKey.values()) {
            if (!key.name().startsWith("SecurityPolicy")) continue;
            nameToEnumMap.put(key.name().toLowerCase(), key);
            if (sb.length() == 0) {
                sb.append(key.name().toLowerCase());
                continue;
            }
            sb.append("|" + key.name().toLowerCase());
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        for (FieldInfo fInfo : fieldTable.values()) {
            CLDBProto.ListSortKey sKey = fInfo.getListSortKey();
            if (sKey == null) continue;
            nameToEnumMap.put(fInfo.getShortName().toLowerCase(), sKey);
            nameToEnumMap.put(fInfo.getLongName().toLowerCase(), sKey);
        }
        securityPolicyListUsage = "security policy list [ -cluster clusterName] [ -expandaces true/false ] [ -output terse|verbose (default:verbose)[ -start start. default: 0 ][ -limit limit (default:2147483647)] [ -filter filters (default:none)] [ -columns comma separated list of column names(default:all)] [ -sortby" + supportedSortKeys + "[ -sortorder asc|desc]";
        securityPolicyCreateCommand = new CLICommand("create", "usage : " + securityPolicyCreateUsage, SecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)SECURITY_POLICY_NAME_PARAM, (Object)new TextInputParameter(SECURITY_POLICY_NAME_PARAM, "securityPolicyName", true, null)).put((Object)SECURITY_EXPORT_POLICY_ID_PARAM, (Object)new IntegerInputParameter(SECURITY_EXPORT_POLICY_ID_PARAM, "securityPolicyId", false, null).setInvisible(true)).put((Object)SECURITY_EXPORT_POLICY_VERSION_PARAM, (Object)new IntegerInputParameter(SECURITY_EXPORT_POLICY_VERSION_PARAM, "securityPolicyVer", false, null).setInvisible(true)).put((Object)SECURITY_EXPORT_POLICY_CTIME_PARAM, (Object)new LongInputParameter(SECURITY_EXPORT_POLICY_CTIME_PARAM, "securityPolicyCtime", false, null).setInvisible(true)).put((Object)SECURITY_EXPORT_POLICY_MTIME_PARAM, (Object)new LongInputParameter(SECURITY_EXPORT_POLICY_MTIME_PARAM, "securityPolicyMtime", false, null).setInvisible(true)).put((Object)EXPORT_DATA_AUDIT_OPS_VAL_PARAM, (Object)new LongInputParameter(EXPORT_DATA_AUDIT_OPS_VAL_PARAM, "data audit operations", false, null).setInvisible(true)).put((Object)DESCRIPTION_PARAM, (Object)new TextInputParameter(DESCRIPTION_PARAM, DESCRIPTION_PARAM, false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster", false, null)).put((Object)ALLOW_TAGGING_PARAM, (Object)new BooleanInputParameter(ALLOW_TAGGING_PARAM, "Allow Tagging true|false, default: false", false, null)).put((Object)ACCESS_CONTROL_PARAM, (Object)new TextInputParameter(ACCESS_CONTROL_PARAM, "Access Constrols for policy Armed|Disarmed|Denied, default: Disarmed", false, null)).put((Object)AUDIT_ENABLED_PARAM, (Object)new BooleanInputParameter(AUDIT_ENABLED_PARAM, "Enable auditing, default: false", false, null)).put((Object)DATA_AUDIT_OPS_PARAM, (Object)new TextInputParameter(DATA_AUDIT_OPS_PARAM, "data audit operations", false, null)).put((Object)WIRE_SECURITY_ENABLED, (Object)new BooleanInputParameter(WIRE_SECURITY_ENABLED, "Enable wire-level encryption, default: true (secure clusters), false (insecure clusters)", false, null)).put((Object)ACE_READFILE_PARAM, (Object)new TextInputParameter(ACE_READFILE_PARAM, "ACE controlling who can read from this file", false, null)).put((Object)ACE_WRITEFILE_PARAM, (Object)new TextInputParameter(ACE_WRITEFILE_PARAM, "ACE controlling who can write to this file", false, null)).put((Object)ACE_EXECUTEFILE_PARAM, (Object)new TextInputParameter(ACE_EXECUTEFILE_PARAM, "ACE controlling who can execute this file", false, null)).put((Object)ACE_READDIR_PARAM, (Object)new TextInputParameter(ACE_READDIR_PARAM, "ACE controlling who can read the contents of files in this directory", false, null)).put((Object)ACE_ADDCHILD_PARAM, (Object)new TextInputParameter(ACE_ADDCHILD_PARAM, "ACE controlling who can create files and directories in this directory", false, null)).put((Object)ACE_DELETECHILD_PARAM, (Object)new TextInputParameter(ACE_DELETECHILD_PARAM, "ACE controlling who can delete files and directories in this directory", false, null)).put((Object)ACE_LOOKUPDIR_PARAM, (Object)new TextInputParameter(ACE_LOOKUPDIR_PARAM, "ACE controlling who can list the contents in this directory", false, null)).put((Object)ACE_READDB_PARAM, (Object)new TextInputParameter(ACE_READDB_PARAM, "ACE for DB CF reads", false, null)).put((Object)ACE_WRITEDB_PARAM, (Object)new TextInputParameter(ACE_WRITEDB_PARAM, "ACE for DB CF writes", false, null)).put((Object)ACE_TRAVERSEDB_PARAM, (Object)new TextInputParameter(ACE_TRAVERSEDB_PARAM, "ACE for DB CF travese", false, null)).put((Object)ACE_READ_PARAM, (Object)new TextInputParameter(ACE_READ_PARAM, "Convenience ACE to set permissions for readfileace, executefileace, readdirace, lookupdirace, readdbace, and traversedbace.", false, null)).put((Object)ACE_WRITE_PARAM, (Object)new TextInputParameter(ACE_WRITE_PARAM, "Convenience ACE to set write permissions for writefileace, addchildace, deletechildace, and writedbace.", false, null)).put((Object)UID_PARAM_NAME, (Object)new TextInputParameter(UID_PARAM_NAME, "space separated list of user:permissions,permissions,... to be set", false, null)).put((Object)GID_PARAM_NAME, (Object)new TextInputParameter(GID_PARAM_NAME, "space separated list of group:permissions,permissions,... to be set", false, null)).build(), null).setShortUsage(securityPolicyCreateUsage);
        securityPolicyModifyCommand = new CLICommand("modify", "usage : " + securityPolicyModifyUsage, SecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)SECURITY_POLICY_NAME_PARAM, (Object)new TextInputParameter(SECURITY_POLICY_NAME_PARAM, "securityPolicyName", true, null)).put((Object)SECURITY_EXPORT_POLICY_ID_PARAM, (Object)new IntegerInputParameter(SECURITY_EXPORT_POLICY_ID_PARAM, "securityPolicyId", false, null).setInvisible(true)).put((Object)SECURITY_EXPORT_POLICY_VERSION_PARAM, (Object)new IntegerInputParameter(SECURITY_EXPORT_POLICY_VERSION_PARAM, "securityPolicyVer", false, null).setInvisible(true)).put((Object)SECURITY_EXPORT_POLICY_CTIME_PARAM, (Object)new LongInputParameter(SECURITY_EXPORT_POLICY_CTIME_PARAM, "securityPolicyCtime", false, null).setInvisible(true)).put((Object)SECURITY_EXPORT_POLICY_MTIME_PARAM, (Object)new LongInputParameter(SECURITY_EXPORT_POLICY_MTIME_PARAM, "securityPolicyMtime", false, null).setInvisible(true)).put((Object)EXPORT_DATA_AUDIT_OPS_VAL_PARAM, (Object)new LongInputParameter(EXPORT_DATA_AUDIT_OPS_VAL_PARAM, "data audit operations", false, null).setInvisible(true)).put((Object)DESCRIPTION_PARAM, (Object)new TextInputParameter(DESCRIPTION_PARAM, DESCRIPTION_PARAM, false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster", false, null)).put((Object)ALLOW_TAGGING_PARAM, (Object)new BooleanInputParameter(ALLOW_TAGGING_PARAM, "Allow Tagging true|false, default: false", false, null)).put((Object)ACCESS_CONTROL_PARAM, (Object)new TextInputParameter(ACCESS_CONTROL_PARAM, "Access Constrols for policy Armed|Disarmed|Denied, default: Disarmed", false, null)).put((Object)AUDIT_ENABLED_PARAM, (Object)new BooleanInputParameter(AUDIT_ENABLED_PARAM, "Enable auditing", false, null)).put((Object)DATA_AUDIT_OPS_PARAM, (Object)new TextInputParameter(DATA_AUDIT_OPS_PARAM, "data audit operations", false, null)).put((Object)DISABLE_DATA_AUDIT_OPS_PARAM, (Object)new TextInputParameter(DISABLE_DATA_AUDIT_OPS_PARAM, "disable data audit operations", false, null)).put((Object)WIRE_SECURITY_ENABLED, (Object)new BooleanInputParameter(WIRE_SECURITY_ENABLED, "Enable wire-level encryption, default: true (secure clusters), false (insecure clusters)", false, null)).put((Object)ACE_READFILE_PARAM, (Object)new TextInputParameter(ACE_READFILE_PARAM, "ACE controlling who can read from this file", false, null)).put((Object)ACE_WRITEFILE_PARAM, (Object)new TextInputParameter(ACE_WRITEFILE_PARAM, "ACE controlling who can write to this file", false, null)).put((Object)ACE_EXECUTEFILE_PARAM, (Object)new TextInputParameter(ACE_EXECUTEFILE_PARAM, "ACE controlling who can execute this file", false, null)).put((Object)ACE_READDIR_PARAM, (Object)new TextInputParameter(ACE_READDIR_PARAM, "ACE controlling who can read the contents of files in this directory", false, null)).put((Object)ACE_ADDCHILD_PARAM, (Object)new TextInputParameter(ACE_ADDCHILD_PARAM, "ACE controlling who can create files and directories in this directory", false, null)).put((Object)ACE_DELETECHILD_PARAM, (Object)new TextInputParameter(ACE_DELETECHILD_PARAM, "ACE controlling who can delete files and directories in this directory", false, null)).put((Object)ACE_LOOKUPDIR_PARAM, (Object)new TextInputParameter(ACE_LOOKUPDIR_PARAM, "ACE controlling who can list the contents in this directory", false, null)).put((Object)ACE_READDB_PARAM, (Object)new TextInputParameter(ACE_READDB_PARAM, "ACE for DB CF reads", false, null)).put((Object)ACE_WRITEDB_PARAM, (Object)new TextInputParameter(ACE_WRITEDB_PARAM, "ACE for DB CF writes", false, null)).put((Object)ACE_TRAVERSEDB_PARAM, (Object)new TextInputParameter(ACE_TRAVERSEDB_PARAM, "ACE for DB CF travese", false, null)).put((Object)ACE_READ_PARAM, (Object)new TextInputParameter(ACE_READ_PARAM, "Convenience ACE for readfileace, executefileace, readdirace, lookupdirace, readdbace, and traversedbace.", false, null)).put((Object)ACE_WRITE_PARAM, (Object)new TextInputParameter(ACE_WRITE_PARAM, "Convenience ACE for writefileace, addchildace, deletechildace, and writedbace.", false, null)).put((Object)UID_PARAM_NAME, (Object)new TextInputParameter(UID_PARAM_NAME, "space separated list of user:permissions,permissions,... to be set", false, null)).put((Object)GID_PARAM_NAME, (Object)new TextInputParameter(GID_PARAM_NAME, "space separated list of group:permissions,permissions,... to be set", false, null)).build(), null).setShortUsage(securityPolicyModifyUsage);
        securityPolicyListCommand = new CLICommand("list", "usage : " + securityPolicyListUsage, SecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "clusterName", false, null)).put((Object)EXPAND_ACES_PARAM, (Object)new BooleanInputParameter(EXPAND_ACES_PARAM, "Expand read/write aces into respective fields for display, default: false", false, null)).put((Object)OUTPUT_PARAM, (Object)new TextInputParameter(OUTPUT_PARAM, "verbose", false, "verbose")).put((Object)START_PARAM, (Object)new IntegerInputParameter(START_PARAM, START_PARAM, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM, (Object)new IntegerInputParameter(LIMIT_PARAM, LIMIT_PARAM, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)FILTER_PARAM, (Object)new FilterInputParameter(FILTER_PARAM, "none", false, "none")).put((Object)COLUMNS_PARAM, (Object)new TextInputParameter(COLUMNS_PARAM, "all", false, "all")).put((Object)SORTING_ORDER_PARAM, (Object)new TextInputParameter(SORTING_ORDER_PARAM, "<asc|desc>", false, null)).put((Object)SORTBY_PARAM, (Object)new TextInputParameter(SORTBY_PARAM, supportedSortKeys + ", column names of supported fields.", false, null)).build(), null).setShortUsage(securityPolicyListUsage);
        securityPolicyImportCommand = new CLICommand("import", "", SecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)FILE_NAME_PARAM, (Object)new TextInputParameter(FILE_NAME_PARAM, "fileName", true, null)).build(), null);
        securityPolicyExportCommand = new CLICommand("export", "", SecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)FILTER_PARAM, (Object)new FilterInputParameter(FILTER_PARAM, "none", false, "none").setInvisible(true)).put((Object)OUTPUT_PARAM, (Object)new TextInputParameter(OUTPUT_PARAM, "verbose", false, "verbose").setInvisible(true)).build(), null);
        securityPolicyInfoCommand = new CLICommand("info", "usage : security policy info [ -cluster clusterName] [ -expandaces true/false ] [ -output terse|verbose. Default: verbose ] [ -columns comma separated list of column names. Default: all ] ", SecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)SECURITY_POLICY_NAME_PARAM, (Object)new TextInputParameter(SECURITY_POLICY_NAME_PARAM, "securityPolicyName", true, null)).put((Object)EXPAND_ACES_PARAM, (Object)new BooleanInputParameter(EXPAND_ACES_PARAM, "Expand read/write aces into respective fields for display, default: false", false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster", false, null)).put((Object)OUTPUT_PARAM, (Object)new TextInputParameter(OUTPUT_PARAM, "verbose", false, "verbose")).put((Object)COLUMNS_PARAM, (Object)new TextInputParameter(COLUMNS_PARAM, "comma separated list of column names", false, "all")).build(), null).setShortUsage(securityPolicyInfoUsage);
        securityPolicyCommandsArray = new CLICommand[]{securityPolicyCreateCommand, securityPolicyModifyCommand, securityPolicyListCommand, securityPolicyInfoCommand, securityPolicyImportCommand, securityPolicyExportCommand};
        securityPolicyCommands = new CLICommand("policy", "policy", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, securityPolicyCommandsArray).setShortUsage("security policy [create|modify|info|list|import|export]");
    }
}

