/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.proto.Common;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class ServiceCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(ServiceCommands.class);
    private static final String INFO_SERVICE_CMD = "info";
    private static final String LIST_SERVICE_CMD = "list";
    private static final String NODE_PARAM_NAME = "node";
    private static final String OUTPUT_PARAM_NAME = "output";
    public static Map<String, BaseInputParameter> serviceListParams = new ImmutableMap.Builder().put((Object)"node", (Object)new TextInputParameter("node", "Hostname of the node", false, "localhost")).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).put((Object)"output", (Object)new TextInputParameter("output", "terse|verbose. Default: verbose", false, "verbose")).build();
    static final CLICommand serviceListCommand = new CLICommand("list", "usage: service list -node <host name> -output <terse|verbose>", ServiceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, serviceListParams, null).setShortUsage("service list -node <host name> -output <terse|verbose>");
    static final CLICommand infoCommand = new CLICommand("info", "Displays information for a service", ServiceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).put((Object)"name", (Object)new TextInputParameter("name", "service name to perform action on", true, null)).build(), null).setShortUsage("service info -zkconnect <IP:Port> -name <service name>").setUsageInVisible(true);
    public static final CLICommand serviceCommands = new CLICommand("service", "service [list|info]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{serviceListCommand, infoCommand}).setShortUsage("service [list|info]");
    public static Map<String, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)"name", (Object)new FieldInfo(1, "n", "name", String.class)).put((Object)"state", (Object)new FieldInfo(2, "s", "state", Integer.class)).put((Object)"version", (Object)new FieldInfo(3, "v", "version", String.class)).put((Object)"logpath", (Object)new FieldInfo(4, "lp", "logpath", String.class)).put((Object)"loglevel", (Object)new FieldInfo(5, "ll", "loglevel", Integer.class)).put((Object)"displayname", (Object)new FieldInfo(6, "dn", "displayname", String.class)).put((Object)"memallocated", (Object)new FieldInfo(7, "ma", "memallocated", String.class)).build();

    public ServiceCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase(INFO_SERVICE_CMD)) {
            return this.getServiceInfo();
        }
        if (command.equalsIgnoreCase(LIST_SERVICE_CMD)) {
            return this.getServiceList();
        }
        return new TextCommandOutput(("Service command failed: unknown command " + command + " received.").getBytes());
    }

    private State getStoppedFailedState(String service, Set<String> runningServices, List<String> nodeNames, List<String> nodeIps, Map<String, Properties> serviceNodesProperties) {
        ArrayList<String> nodes = new ArrayList<String>();
        if (nodeNames != null && !nodeNames.isEmpty()) {
            nodes.addAll(nodeNames);
        }
        if (nodeIps != null && !nodeIps.isEmpty()) {
            nodes.addAll(nodeIps);
        }
        if (nodes.isEmpty()) {
            return null;
        }
        for (String node : nodes) {
            String actionPropValue;
            Properties props = serviceNodesProperties.get(node);
            if (props == null || (actionPropValue = props.getProperty("last.action")) == null || runningServices != null && !runningServices.isEmpty() && runningServices.contains(service)) continue;
            if ("failed".equalsIgnoreCase(actionPropValue)) {
                return State.FAILED;
            }
            if (!"stop".equalsIgnoreCase(actionPropValue)) continue;
            return State.STOPPED;
        }
        return null;
    }

    private String getServiceMemory(String zkConnectString, String service, List<String> nodeHostNames) {
        String clusterName = "";
        try {
            if (this.isParamPresent("cluster")) {
                clusterName = this.getParamTextValue("cluster", 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String hostName : nodeHostNames) {
            Map<String, Common.ServiceData> serviceProp = clusterName.isEmpty() ? NodesCommonUtils.getServiceNodeData(zkConnectString, service) : NodesCommonUtils.getServiceNodeData(zkConnectString, service, clusterName);
            if (!serviceProp.containsKey(hostName) && service.equalsIgnoreCase("fileserver")) {
                serviceProp = clusterName.isEmpty() ? NodesCommonUtils.getServiceNodeData(zkConnectString, "kvstore") : NodesCommonUtils.getServiceNodeData(zkConnectString, "kvstore", clusterName);
            }
            if (!serviceProp.containsKey(hostName)) continue;
            Common.ServiceData serviceMemory = serviceProp.get(hostName);
            if (serviceMemory == null) {
                return "";
            }
            LOG.info((Object)(serviceMemory.getHost() + " " + serviceMemory.getPort() + " " + serviceMemory.getMemory()));
            if (!serviceMemory.hasMemory()) continue;
            if (serviceMemory.getMemory() == 0.0) {
                return "Auto";
            }
            return "" + serviceMemory.getMemory();
        }
        return "";
    }

    private State getServiceState(String service, Set<String> runningServices, Set<String> configuredServices) {
        return runningServices.contains(service) ? State.RUNNING : (configuredServices.contains(service) ? State.STOPPED : State.NOT_CONFIGURED);
    }

    public static Set<String> getConfiguredServices(List<String> nodeHostNames, List<String> nodeIps, String zkConnectString, String clusterName) throws CLIProcessingException {
        Map<String, List<String>> nodeToConfiguredServicesMap = NodesCommonUtils.findServicesConfiguredHierarchy(zkConnectString, clusterName);
        HashSet configuredServices = Sets.newHashSet();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Configured services: " + nodeToConfiguredServicesMap.toString()));
        }
        for (String nodeHostName : nodeHostNames) {
            List<String> serviceList;
            if (nodeHostName != null && (serviceList = nodeToConfiguredServicesMap.get(nodeHostName)) != null && !serviceList.isEmpty()) {
                configuredServices.addAll(serviceList);
            }
            if (nodeIps == null || nodeIps.isEmpty()) continue;
            for (String nodeIp : nodeIps) {
                List<String> serviceListIp = nodeToConfiguredServicesMap.get(nodeIp);
                if (serviceListIp == null || serviceListIp.isEmpty()) continue;
                configuredServices.addAll(serviceListIp);
            }
        }
        return configuredServices;
    }

    public static Set<String> getRunningServices(List<String> nodeHostNames, List<String> nodeIps, String zkConnectString, String clusterName) throws CLIProcessingException {
        Map<String, List<String>> nodeToRunningServicesMap = NodesCommonUtils.findServicesRunningHierarchy(zkConnectString, clusterName);
        HashSet runningServices = Sets.newHashSet();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running services: " + nodeToRunningServicesMap.toString()));
        }
        for (String nodeHostName : nodeHostNames) {
            if (nodeToRunningServicesMap.get(nodeHostName) == null || nodeToRunningServicesMap.get(nodeHostName).isEmpty()) continue;
            runningServices.addAll((Collection)nodeToRunningServicesMap.get(nodeHostName));
        }
        for (String nodeIp : nodeIps) {
            if (nodeToRunningServicesMap.get(nodeIp) == null || nodeToRunningServicesMap.get(nodeIp).isEmpty()) continue;
            runningServices.addAll((Collection)nodeToRunningServicesMap.get(nodeIp));
        }
        return runningServices;
    }

    private String getZkConnectString() throws CLIProcessingException {
        String zkConnectString = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().getZkConnect(this.getParamTextValue("cluster", 0)) : CLDBRpcCommonUtils.getInstance().getZkConnect();
        if ((zkConnectString == null || zkConnectString.trim().isEmpty()) && this.isParamPresent("zkconnect")) {
            zkConnectString = this.getParamTextValue("zkconnect", 0);
        }
        return zkConnectString;
    }

    private CommandOutput getServiceInfo() throws CLIProcessingException {
        Map<String, Common.ServiceData> serviceNodeData;
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(oh);
        String zkConnect = this.getZkConnectString();
        int version = this.getVersion();
        if (zkConnect == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not connect to CLDB and no Zookeeper connect string provided"));
            co.setOutput(oh);
            return co;
        }
        String serviceName = this.getParamTextValue("name", 0);
        String clusterName = "";
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
        }
        if ((serviceNodeData = clusterName.isEmpty() ? NodesCommonUtils.getServiceNodeData(zkConnect, serviceName) : NodesCommonUtils.getServiceNodeData(zkConnect, serviceName, clusterName)) == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot find service " + serviceName));
            co.setOutput(oh);
            return co;
        }
        Common.ServiceData masterNodeInfo = serviceNodeData.remove("master");
        String masterHostName = null;
        if (masterNodeInfo != null && masterNodeInfo.hasHost()) {
            masterHostName = masterNodeInfo.getHost();
        }
        for (String nodeName : serviceNodeData.keySet()) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            Common.ServiceData serviceData = serviceNodeData.get(nodeName);
            if (serviceData == null) continue;
            node.addNode(new CommandOutput.OutputHierarchy.OutputNode("IsMaster", nodeName.equals(masterHostName), version, false, true));
            node.addNode(new CommandOutput.OutputHierarchy.OutputNode("Host", (Object)(serviceData.hasHost() ? serviceData.getHost() : "Not set")));
            node.addNode(new CommandOutput.OutputHierarchy.OutputNode("Port", serviceData.hasPort() ? Integer.valueOf(serviceData.getPort()) : "Not set"));
            node.addNode(new CommandOutput.OutputHierarchy.OutputNode("Memory", serviceData.hasMemory() ? Double.valueOf(serviceData.getMemory()) : "Not set"));
            node.addNode(new CommandOutput.OutputHierarchy.OutputNode("IsRunning", serviceData.hasIsRunning() ? Boolean.valueOf(serviceData.getIsRunning()) : "Not set"));
            if (serviceData.getExtinfoCount() > 0) {
                CommandOutput.OutputHierarchy.OutputNode extInfoNode = new CommandOutput.OutputHierarchy.OutputNode("ExtendedInfo");
                for (Common.ExtendedInfo extInfo : serviceData.getExtinfoList()) {
                    extInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(extInfo.getKey(), (Object)extInfo.getValue()));
                }
                node.addChild(extInfoNode);
            }
            oh.addNode(node);
        }
        co.setOutput(oh);
        return co;
    }

    private CommandOutput getServiceList() throws CLIProcessingException {
        String zkConnectString;
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(oh);
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equals("terse");
        String nodeName = this.getParamTextValue(NODE_PARAM_NAME, 0);
        if (nodeName == null || nodeName.isEmpty()) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Node's hostname provided is empty/null."));
            return co;
        }
        List<String> nodeIps = NodesCommonUtils.convertHostToIpIncludingLocal(Lists.newArrayList((Object[])new String[]{nodeName}));
        List<String> nodeNames = NodesCommonUtils.convertIpToHost(nodeIps);
        if (!nodeNames.contains(nodeName)) {
            nodeNames.add(nodeName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("node hostnames: " + nodeNames + ", IPs - " + nodeIps.toString()));
        }
        if ((zkConnectString = this.getZkConnectString()) == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not connect to CLDB and no Zookeeper connect string provided"));
            co.setOutput(oh);
            return co;
        }
        String clusterName = "";
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
        }
        Set<String> runningServices = ServiceCommands.getRunningServices(nodeNames, nodeIps, zkConnectString, clusterName);
        Set<String> configuredServices = ServiceCommands.getConfiguredServices(nodeNames, nodeIps, zkConnectString, clusterName);
        Set<String> clusterWideConfiguredServices = NodesCommonUtils.findConfiguredServicesByServiceHierarchy(zkConnectString, clusterName).keySet();
        for (String service : clusterWideConfiguredServices) {
            CommandOutput.OutputHierarchy.OutputNode node;
            block17: {
                Map<String, Properties> serviceNodesProperties = NodesCommonUtils.getServiceNodesProperties(zkConnectString, service, clusterName);
                State state = this.getStoppedFailedState(service, runningServices, nodeNames, nodeIps, serviceNodesProperties);
                String mem = "";
                if (state == null) {
                    state = this.getServiceState(service, runningServices, configuredServices);
                    if (state == State.RUNNING) {
                        mem = this.getServiceMemory(zkConnectString, service, nodeNames);
                    }
                    if (state == State.STOPPED) {
                        state = State.STANDBY;
                    }
                }
                node = new CommandOutput.OutputHierarchy.OutputNode();
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get("name").getName(terse), (Object)service));
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get("state").getName(terse), state.ordinal()));
                if (!mem.equals("")) {
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get("memallocated").getName(terse), (Object)mem));
                }
                try {
                    ServicesEnum serviceEnum = ServicesEnum.valueOf(service);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("node: " + nodeName + "service : " + service + ", state = " + state + ", logpath = " + serviceEnum.getLogPath()));
                    }
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get("logpath").getName(terse), (Object)serviceEnum.getLogPath()));
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get("displayname").getName(terse), (Object)serviceEnum.getDisplayName()));
                }
                catch (IllegalArgumentException ex) {
                    String logsLocation;
                    String nodeIp;
                    Map<String, Properties> nodesProps = NodesCommonUtils.getServiceNodesProperties(zkConnectString, service, clusterName);
                    if (nodesProps == null || nodesProps.isEmpty()) break block17;
                    ArrayList<String> nodeNameIps = new ArrayList<String>(nodeNames);
                    nodeNameIps.addAll(nodeIps);
                    Properties props = null;
                    Iterator iterator = nodeNameIps.iterator();
                    while (iterator.hasNext() && (props = nodesProps.get(nodeIp = (String)iterator.next())) == null) {
                    }
                    if (props == null) {
                        props = nodesProps.values().toArray(new Properties[0])[0];
                    }
                    if ((logsLocation = props.getProperty("service.logs.location")) != null) {
                        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get("logpath").getName(terse), (Object)logsLocation));
                    } else {
                        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get("logpath").getName(terse), (Object)"undefined"));
                    }
                    String displayName = props.getProperty("service.displayname", service);
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get("displayname").getName(terse), (Object)displayName));
                }
            }
            oh.addNode(node);
        }
        return co;
    }

    private static enum State {
        NOT_CONFIGURED,
        CONFIGURED,
        RUNNING,
        STOPPED,
        FAILED,
        STANDBY;

    }
}

