/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.PolicyServerProto;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.util.Map;
import org.apache.log4j.Logger;

public class TedCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(TedCommands.class);
    static final String TED_ID_PARAM_NAME = "id";
    static final String OBJECT_PARAM_NAME = "object";
    static final String SET_VALUE_PARAM_NAME = "setValue";
    static final String TED_SERVER_TYPE = "servertype";
    static final String TED_SERVER_CLDB = "cldb";
    static final String TED_SERVER_PBS = "policyServer";
    static final Map<String, BaseInputParameter> params = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    static final CLICommand enableCommand = new CLICommand("enable", "enable tedaction for an object", TedCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"id", (Object)new IntegerInputParameter("id", "tedaction to enable", true, null)).put((Object)"object", (Object)new TextInputParameter("object", "object on which to enable", false, null)).put((Object)"setValue", (Object)new TextInputParameter("setValue", "delta to apply", false, null)).put((Object)"servertype", (Object)new TextInputParameter("servertype", "<cldb|policyserver> Server to send request to. default: cldb", false, "cldb")).build(), null).setShortUsage("enable -id <tedaction> -object <ref> [-servertype <cldb|policyserver>");
    static final CLICommand enableOnceCommand = new CLICommand("enableonce", "enable tedaction once for an object", TedCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"id", (Object)new IntegerInputParameter("id", "tedaction to enable", true, null)).put((Object)"object", (Object)new TextInputParameter("object", "object on which to enable", false, null)).put((Object)"setValue", (Object)new TextInputParameter("setValue", "absolute value to set", false, null)).put((Object)"servertype", (Object)new TextInputParameter("servertype", "<cldb|policyserver> Server to send request to. default: cldb", false, "cldb")).build(), null).setShortUsage("enableonce -id <tedaction> -object <ref> [-servertype <cldb|policyserver>");
    static final CLICommand disableCommand = new CLICommand("disable", "disable tedaction for an object", TedCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"id", (Object)new IntegerInputParameter("id", "tedaction to disable", true, null)).put((Object)"object", (Object)new TextInputParameter("object", "object on which to disable (default:all)", false, null)).put((Object)"servertype", (Object)new TextInputParameter("servertype", "<cldb|policyserver> Server to send request to. default: cldb", false, "cldb")).build(), null).setShortUsage("disable -id <tedaction> -object <ref> [-servertype <cldb|policyserver>");
    static final CLICommand[] subCommands = new CLICommand[]{enableCommand, enableOnceCommand, disableCommand};
    static final String usageStr = "ted [enable|enableonce|disable] -id [tedaction] -object <ref>";
    public static final CLICommand commands = new CLICommand("ted", "usage: ted [enable|enableonce|disable] -id [tedaction] -object <ref>", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, subCommands).setUsageInVisible(true).setShortUsage("ted [enable|enableonce|disable] -id [tedaction] -object <ref>");
    UnixUserGroupHelper userInfo;

    public TedCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    CommandOutput enableTedAction() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CLDBProto.TedActionRequest.Builder reqB = CLDBProto.TedActionRequest.newBuilder();
        reqB.setCmd(CLDBProto.TedActionRequest.TedActionType.ENABLE);
        int id = this.getParamIntValue(TED_ID_PARAM_NAME, 0);
        reqB.setId(id);
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            reqB.setObjectRef(this.getParamTextValue(OBJECT_PARAM_NAME, 0));
        }
        if (this.isParamPresent(SET_VALUE_PARAM_NAME)) {
            reqB.setValue(this.getParamTextValue(SET_VALUE_PARAM_NAME, 0));
        }
        reqB.setCreds(this.getUserCredentials());
        byte[] data = null;
        CLDBRpcCommonUtils cldbRpc = CLDBRpcCommonUtils.getInstance();
        try {
            int procId;
            int progId;
            if (this.isParamPresent(TED_SERVER_TYPE) && this.getParamTextValue(TED_SERVER_TYPE, 0).equalsIgnoreCase(TED_SERVER_PBS)) {
                progId = Common.MapRProgramId.PolicyServerProgramId.getNumber();
                procId = PolicyServerProto.SecurityPolicyProc.SecurityPolicyTedActionProc.getNumber();
            } else {
                progId = Common.MapRProgramId.CldbProgramId.getNumber();
                procId = CLDBProto.CLDBProg.TedActionProc.getNumber();
            }
            data = this.isParamPresent("cluster") ? cldbRpc.sendRequest(this.getParamTextValue("cluster", 0), progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class) : cldbRpc.sendRequest(progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.TedActionResponse resp = CLDBProto.TedActionResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "enabling tedaction failed with error - " + resp.getErrMsg()));
                output.setOutput(out);
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to enable tedaction"));
            output.setOutput(out);
            return output;
        }
        return output;
    }

    CommandOutput enableTedActionOnce() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CLDBProto.TedActionRequest.Builder reqB = CLDBProto.TedActionRequest.newBuilder();
        reqB.setCmd(CLDBProto.TedActionRequest.TedActionType.ENABLEONCE);
        int id = this.getParamIntValue(TED_ID_PARAM_NAME, 0);
        reqB.setId(id);
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            reqB.setObjectRef(this.getParamTextValue(OBJECT_PARAM_NAME, 0));
        }
        if (this.isParamPresent(SET_VALUE_PARAM_NAME)) {
            reqB.setValue(this.getParamTextValue(SET_VALUE_PARAM_NAME, 0));
        }
        reqB.setCreds(this.getUserCredentials());
        byte[] data = null;
        CLDBRpcCommonUtils cldbRpc = CLDBRpcCommonUtils.getInstance();
        try {
            int procId;
            int progId;
            if (this.isParamPresent(TED_SERVER_TYPE) && this.getParamTextValue(TED_SERVER_TYPE, 0).equalsIgnoreCase(TED_SERVER_PBS)) {
                progId = Common.MapRProgramId.PolicyServerProgramId.getNumber();
                procId = PolicyServerProto.SecurityPolicyProc.SecurityPolicyTedActionProc.getNumber();
            } else {
                progId = Common.MapRProgramId.CldbProgramId.getNumber();
                procId = CLDBProto.CLDBProg.TedActionProc.getNumber();
            }
            data = this.isParamPresent("cluster") ? cldbRpc.sendRequest(this.getParamTextValue("cluster", 0), progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class) : cldbRpc.sendRequest(progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.TedActionResponse resp = CLDBProto.TedActionResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "enabling tedaction once failed with error - " + resp.getErrMsg()));
                output.setOutput(out);
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to enable tedaction once"));
            output.setOutput(out);
            return output;
        }
        return output;
    }

    CommandOutput disableTedAction() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CLDBProto.TedActionRequest.Builder reqB = CLDBProto.TedActionRequest.newBuilder();
        reqB.setCmd(CLDBProto.TedActionRequest.TedActionType.DISABLE);
        int id = this.getParamIntValue(TED_ID_PARAM_NAME, 0);
        reqB.setId(id);
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            reqB.setObjectRef(this.getParamTextValue(OBJECT_PARAM_NAME, 0));
        }
        reqB.setCreds(this.getUserCredentials());
        byte[] data = null;
        CLDBRpcCommonUtils cldbRpc = CLDBRpcCommonUtils.getInstance();
        try {
            int procId;
            int progId;
            if (this.isParamPresent(TED_SERVER_TYPE) && this.getParamTextValue(TED_SERVER_TYPE, 0).equalsIgnoreCase(TED_SERVER_PBS)) {
                progId = Common.MapRProgramId.PolicyServerProgramId.getNumber();
                procId = PolicyServerProto.SecurityPolicyProc.SecurityPolicyTedActionProc.getNumber();
            } else {
                progId = Common.MapRProgramId.CldbProgramId.getNumber();
                procId = CLDBProto.CLDBProg.TedActionProc.getNumber();
            }
            data = this.isParamPresent("cluster") ? cldbRpc.sendRequest(this.getParamTextValue("cluster", 0), progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class) : cldbRpc.sendRequest(progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.TedActionResponse resp = CLDBProto.TedActionResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "disabling tedaction failed with error - " + resp.getErrMsg()));
                output.setOutput(out);
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to disable tedaction"));
            output.setOutput(out);
            return output;
        }
        return output;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (!super.validateInput()) {
            CommandOutput output = new CommandOutput();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            return output;
        }
        this.userInfo = new UnixUserGroupHelper();
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase("enable")) {
            return this.enableTedAction();
        }
        if (command.equalsIgnoreCase("enableonce")) {
            return this.enableTedActionOnce();
        }
        if (command.equalsIgnoreCase("disable")) {
            return this.disableTedAction();
        }
        return new TextCommandOutput(("ted command failed: unknown command " + command + " received.").getBytes());
    }

    public String getCommandUsage() {
        return usageStr;
    }
}

