/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.marlin;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.marlin.RecentStreamsListManager;
import com.mapr.cli.marlin.RecentStreamsListManagers;
import com.mapr.cli.marlin.StreamsCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.streams.Admin;
import com.mapr.streams.Streams;
import com.mapr.streams.impl.admin.CursorInfo;
import com.mapr.streams.impl.admin.MarlinAdminImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class CursorCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(CursorCommands.class);
    private static final String LISTENER_GROUP_PARAM_NAME = "consumergroup";
    private static final String PATH_PARAM_NAME = "path";
    private static final String TOPIC_PARAM_NAME = "topic";
    private static final String PARTITION_PARAM_NAME = "partition";
    private static final CLICommand listCommand = new CLICommand("list", "usage: stream cursor list -path <path> -consumergroup <consumer group Id> -topic <topic> -partition <partitionId>", CursorCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).put((Object)"consumergroup", (Object)new TextInputParameter("consumergroup", "Consumer Group ID", false, null)).put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", false, null)).put((Object)"partition", (Object)new IntegerInputParameter("partition", "Partition ID", false, null)).build(), null).setShortUsage("stream cursor list -path <path>");
    private static final CLICommand deleteCommand = new CLICommand("delete", "usage: stream cursor delete -path <path> -consumergroup <consumer group Id> -topic <topic> -partition <partitionId>", CursorCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).put((Object)"consumergroup", (Object)new TextInputParameter("consumergroup", "Consumer Group ID", false, null)).put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", false, null)).put((Object)"partition", (Object)new IntegerInputParameter("partition", "Partition ID", false, null)).build(), null).setShortUsage("stream cursor delete -path <path>");
    public static final CLICommand cursorCommands = new CLICommand("cursor", "cursor [delete|list]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{deleteCommand, listCommand}).setShortUsage("stream cursor [delete|list]");

    public CursorCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cmdName = this.cliCommand.getCommandName();
        if (cmdName.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listCursors(out);
        } else if (cmdName.equalsIgnoreCase(deleteCommand.getCommandName())) {
            this.deleteCursor(out);
        }
        return output;
    }

    private void listCursors(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String user = this.getUserLoginId();
            final String streamName = this.getParamTextValue(PATH_PARAM_NAME, 0);
            final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            final RecentStreamsListManager manager = RecentStreamsListManagers.getRecentStreamsListManagerForUser(user);
            final Configuration conf = new Configuration();
            String listenerGIDParam = null;
            String topicNameParam = null;
            int feedIdParam = -1;
            if (this.isParamPresent(TOPIC_PARAM_NAME)) {
                topicNameParam = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
            }
            if (this.isParamPresent(LISTENER_GROUP_PARAM_NAME)) {
                listenerGIDParam = this.getParamTextValue(LISTENER_GROUP_PARAM_NAME, 0);
            }
            if (this.isParamPresent(PARTITION_PARAM_NAME)) {
                feedIdParam = this.getParamIntValue(PARTITION_PARAM_NAME, 0);
            }
            final String listenerGID = listenerGIDParam;
            final String topicName = topicNameParam;
            final int feedId = feedIdParam;
            HashMap topicMap = new HashMap();
            final ArrayList cursorList = new ArrayList();
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    try {
                        Admin admin = Streams.newAdmin((Configuration)conf);
                        MarlinAdminImpl madmin = (MarlinAdminImpl)admin;
                        List cursors = madmin.listCursors(streamName, listenerGID, topicName, feedId);
                        cursorList.addAll(cursors);
                        manager.moveToTop(streamName);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("listCursors failed : " + e));
                        manager.deleteIfNotExist(streamName, mfs);
                        throw e;
                    }
                }
            };
            for (CursorInfo ci : cursorList) {
                Marlinserver.TopicFeedStatInfo sinfo = ci.topicFeedInfo().stat();
                long producerMaxSeq = sinfo.getMaxSeq();
                long producerMaxTs = sinfo.getTimeRange().getMaxTS();
                CommandOutput.OutputHierarchy.OutputNode cursorNode = new CommandOutput.OutputHierarchy.OutputNode();
                cursorNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(LISTENER_GROUP_PARAM_NAME, (Object)ci.listenerID()));
                cursorNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(TOPIC_PARAM_NAME, (Object)ci.topic()));
                cursorNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("partitionid", (Object)Integer.toString(ci.feedId())));
                cursorNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("produceroffset", (Object)Long.toString(producerMaxSeq)));
                cursorNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("committedoffset", (Object)Long.toString(ci.cursor())));
                cursorNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("producertimestamp", (Object)StreamsCommands.millisToDate(producerMaxTs)));
                cursorNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("consumertimestamp", (Object)StreamsCommands.millisToDate(ci.timestamp())));
                cursorNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("consumerlagmillis", (Object)Long.toString(producerMaxTs - ci.timestamp())));
                out.addNode(cursorNode);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void deleteCursor(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String user = this.getUserLoginId();
            final Configuration conf = new Configuration();
            final String streamName = this.getParamTextValue(PATH_PARAM_NAME, 0);
            final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            final RecentStreamsListManager manager = RecentStreamsListManagers.getRecentStreamsListManagerForUser(user);
            String listenerGIDParam = null;
            String topicNameParam = null;
            int feedIdParam = -1;
            if (this.isParamPresent(TOPIC_PARAM_NAME)) {
                topicNameParam = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
            }
            if (this.isParamPresent(LISTENER_GROUP_PARAM_NAME)) {
                listenerGIDParam = this.getParamTextValue(LISTENER_GROUP_PARAM_NAME, 0);
            }
            if (this.isParamPresent(PARTITION_PARAM_NAME)) {
                feedIdParam = this.getParamIntValue(PARTITION_PARAM_NAME, 0);
            }
            final String listenerGID = listenerGIDParam;
            final String topicName = topicNameParam;
            final int feedId = feedIdParam;
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    try {
                        Admin admin = Streams.newAdmin((Configuration)conf);
                        MarlinAdminImpl madmin = (MarlinAdminImpl)admin;
                        madmin.deleteCursors(streamName, listenerGID, topicName, feedId);
                        manager.moveToTop(streamName);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("deleteCursor failed : " + e));
                        manager.deleteIfNotExist(streamName, mfs);
                        throw e;
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }
}

