/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class StorageLabelCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String ADD_PARAM = "add";
    private static final String MODIFY_PARAM = "modify";
    private static final String LIST_PARAM = "list";
    private static final String SERVER_MODE_PARAM = "servermode";
    private static final String LABEL_NAME_PARAM = "label";
    private static final String NUM_DISKS_PER_INSTANCE_PARAM = "numdisksperinstance";
    private static final String MAX_ACTIVE_IO_PER_DISK_PARAM = "maxactiveioperdisk";
    private static final String IS_SSD_PARAM = "isssd";
    private static final String IS_TRIM_ENABLED_PARAM = "istrimenabled";
    private static ImmutableMap.Builder<String, BaseInputParameter> addParams = new ImmutableMap.Builder().put((Object)"label", (Object)new TextInputParameter("label", "label to be registered", true, null)).put((Object)"numdisksperinstance", (Object)new IntegerInputParameter("numdisksperinstance", "num disks per mfs instance ", false, null).setInvisible(true)).put((Object)"maxactiveioperdisk", (Object)new IntegerInputParameter("maxactiveioperdisk", "max active io per disk ", false, null)).put((Object)"isssd", (Object)new BooleanInputParameter("isssd", "is solid state drive", false, null)).put((Object)"istrimenabled", (Object)new BooleanInputParameter("istrimenabled", "is trim enabled", false, null)).put((Object)"servermode", (Object)new TextInputParameter("servermode", "", false, null).setInvisible(true));
    private static ImmutableMap.Builder<String, BaseInputParameter> modifyParams = new ImmutableMap.Builder().put((Object)"label", (Object)new TextInputParameter("label", "label to be modified", true, null)).put((Object)"numdisksperinstance", (Object)new IntegerInputParameter("numdisksperinstance", "num disks per mfs instance ", false, null).setInvisible(true)).put((Object)"maxactiveioperdisk", (Object)new IntegerInputParameter("maxactiveioperdisk", "max active io per disk ", false, null)).put((Object)"isssd", (Object)new BooleanInputParameter("isssd", "is solid state drive", false, null)).put((Object)"istrimenabled", (Object)new BooleanInputParameter("istrimenabled", "is trim enabled", false, null)).put((Object)"servermode", (Object)new TextInputParameter("servermode", "", false, null).setInvisible(true));
    private static ImmutableMap.Builder<String, BaseInputParameter> listParams = new ImmutableMap.Builder().put((Object)"servermode", (Object)new TextInputParameter("servermode", "", false, null).setInvisible(true));
    private static final CLICommand addCommand = new CLICommand("add", "-label [label_name]", StorageLabelCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)addParams.build(), null).setShortUsage("-label [label_name]");
    private static final CLICommand modifyCommand = new CLICommand("modify", "-label [label_name]", StorageLabelCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)modifyParams.build(), null).setShortUsage("-label [label_name] -numDisksPerInstnace [num_disks]");
    private static final CLICommand listCommand = new CLICommand("list", "", StorageLabelCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)listParams.build(), null).setShortUsage("");
    private static CLICommand[] subCommands = new CLICommand[]{addCommand, modifyCommand, listCommand};
    public static final CLICommand commands = new CLICommand("label", "[add | modify | list]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, subCommands).setShortUsage("[add | modify | list]");

    public StorageLabelCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        this.output.setOutput(out);
        if (!super.validateInput()) {
            return this.output;
        }
        CLDBProto.StorageLabelRegistrationRequest.Builder reqBuilder = CLDBProto.StorageLabelRegistrationRequest.newBuilder();
        String command = this.cliCommand.getCommandName();
        boolean useCldbKey = false;
        if (command.equalsIgnoreCase(ADD_PARAM) || command.equalsIgnoreCase(MODIFY_PARAM)) {
            String labelName = this.getParamTextValue(LABEL_NAME_PARAM, 0);
            if (labelName == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing value for label argument"));
                return this.output;
            }
            if ((labelName = labelName.trim()).isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Empty string for label argument after trimming white spaces"));
                return this.output;
            }
            if (!this.isLetterOrDigit(labelName.charAt(0))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Label name should start with an english letter or digit"));
                return this.output;
            }
            int maxLabelLen = Common.MapRClusterDefaults.getDefaultInstance().getMaxLabelLength();
            if (labelName.length() > maxLabelLen) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Label length " + labelName.length() + " exceeded the maximum allowed length of " + maxLabelLen));
                return this.output;
            }
            if (this.isParamPresent(SERVER_MODE_PARAM) && this.getParamTextValue(SERVER_MODE_PARAM, 0).equalsIgnoreCase("true")) {
                useCldbKey = true;
            }
            if (command.equalsIgnoreCase(ADD_PARAM)) {
                int maxActiveIOPerDisk;
                int numDisksPerInstance;
                if (this.isParamPresent(NUM_DISKS_PER_INSTANCE_PARAM) && (numDisksPerInstance = this.getParamIntValue(NUM_DISKS_PER_INSTANCE_PARAM, 0)) != 0) {
                    reqBuilder.setNumDisksPerInstance(numDisksPerInstance);
                }
                if (this.isParamPresent(MAX_ACTIVE_IO_PER_DISK_PARAM) && (maxActiveIOPerDisk = this.getParamIntValue(MAX_ACTIVE_IO_PER_DISK_PARAM, 0)) > 10) {
                    reqBuilder.setMaxActiveIOPerDisk(maxActiveIOPerDisk);
                }
                if (this.isParamPresent(IS_SSD_PARAM)) {
                    reqBuilder.setIsSSD(this.getParamBooleanValue(IS_SSD_PARAM, 0));
                }
                if (this.isParamPresent(IS_TRIM_ENABLED_PARAM)) {
                    reqBuilder.setIsTrimEnabled(this.getParamBooleanValue(IS_TRIM_ENABLED_PARAM, 0));
                }
                reqBuilder.addAllNewLabels(Arrays.asList(labelName));
            } else if (command.equalsIgnoreCase(MODIFY_PARAM)) {
                this.handleModifyCommand(out, labelName, useCldbKey);
                return this.output;
            }
        } else if (command.equalsIgnoreCase(LIST_PARAM)) {
            if (this.isParamPresent(SERVER_MODE_PARAM) && this.getParamTextValue(SERVER_MODE_PARAM, 0).equalsIgnoreCase("true")) {
                useCldbKey = true;
            }
            reqBuilder.setFetchCurrentLabels(true);
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid request could not be built from input arguments"));
            return this.output;
        }
        this.processCommand(out, reqBuilder, useCldbKey);
        return this.output;
    }

    private boolean isLetterOrDigit(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private void processCommand(CommandOutput.OutputHierarchy out, CLDBProto.StorageLabelRegistrationRequest.Builder reqBuilder, boolean useCldbKey) throws CLIProcessingException {
        byte[] data;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(CLDBRpcCommonUtils.getInstance().getDefaultClusterName(), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.StorageLabelRegistrationProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.StorageLabelRegistrationResponse.class, useCldbKey ? Security.ServerKeyType.CldbKey : Security.ServerKeyType.ServerKey);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Got null response from CLDB...check CLDB logs"));
            return;
        }
        CLDBProto.StorageLabelRegistrationResponse resp = null;
        try {
            resp = CLDBProto.StorageLabelRegistrationResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unable to parse response from CLDB...check for coding or versioning errors"));
            return;
        }
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrorMsg()));
            return;
        }
        if (resp.getCurrentLabelsCount() > 0) {
            this.addLabelsInfo(resp.getCurrentLabelsList(), out);
        }
    }

    private void handleModifyCommand(CommandOutput.OutputHierarchy out, String labelName, boolean useCldbKey) throws CLIProcessingException {
        int maxActiveIOPerDisk;
        int numDisksPerInstance;
        if (!(this.isParamPresent(NUM_DISKS_PER_INSTANCE_PARAM) || this.isParamPresent(IS_SSD_PARAM) || this.isParamPresent(MAX_ACTIVE_IO_PER_DISK_PARAM) || this.isParamPresent(IS_TRIM_ENABLED_PARAM))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing arguments for label modify"));
            return;
        }
        CLDBProto.StorageLabelModifyRequest.Builder reqBuilder = CLDBProto.StorageLabelModifyRequest.newBuilder().setLabelName(labelName);
        if (this.isParamPresent(NUM_DISKS_PER_INSTANCE_PARAM) && (numDisksPerInstance = this.getParamIntValue(NUM_DISKS_PER_INSTANCE_PARAM, 0)) != 0) {
            reqBuilder.setNumDisksPerInstance(numDisksPerInstance);
        }
        if (this.isParamPresent(MAX_ACTIVE_IO_PER_DISK_PARAM) && (maxActiveIOPerDisk = this.getParamIntValue(MAX_ACTIVE_IO_PER_DISK_PARAM, 0)) > 10) {
            reqBuilder.setMaxActiveIOPerDisk(maxActiveIOPerDisk);
        }
        if (this.isParamPresent(IS_SSD_PARAM)) {
            reqBuilder.setIsSSD(this.getParamBooleanValue(IS_SSD_PARAM, 0));
        }
        if (this.isParamPresent(IS_TRIM_ENABLED_PARAM)) {
            reqBuilder.setIsTrimEnabled(this.getParamBooleanValue(IS_TRIM_ENABLED_PARAM, 0));
        }
        this.processModifyCommand(out, reqBuilder, useCldbKey);
    }

    private void processModifyCommand(CommandOutput.OutputHierarchy out, CLDBProto.StorageLabelModifyRequest.Builder reqBuilder, boolean useCldbKey) throws CLIProcessingException {
        byte[] data;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(CLDBRpcCommonUtils.getInstance().getDefaultClusterName(), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.StorageLabelModifyProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.StorageLabelModifyResponse.class, useCldbKey ? Security.ServerKeyType.CldbKey : Security.ServerKeyType.ServerKey);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Got null response from CLDB...check CLDB logs"));
            return;
        }
        CLDBProto.StorageLabelModifyResponse resp = null;
        try {
            resp = CLDBProto.StorageLabelModifyResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unable to parse response from CLDB...check for coding or versioning errors"));
            return;
        }
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrorMsg()));
            return;
        }
    }

    private void addLabelsInfo(List<Common.LabelInfo> currentLabels, CommandOutput.OutputHierarchy out) {
        for (Common.LabelInfo label : currentLabels) {
            CommandOutput.OutputHierarchy.OutputNode labelNode = new CommandOutput.OutputHierarchy.OutputNode();
            labelNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(LABEL_NAME_PARAM, (Object)label.getName()));
            labelNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", label.getId()));
            if (label.hasNumDisksPerInstance()) {
                labelNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numDisksPerInstance", label.getNumDisksPerInstance()));
            }
            if (label.hasMaxActiveIOPerDisk()) {
                labelNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MAX_ACTIVE_IO_PER_DISK_PARAM, label.getMaxActiveIOPerDisk()));
            }
            if (label.hasIsSSD()) {
                labelNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(IS_SSD_PARAM, (Object)label.getIsSSD()));
            }
            if (label.hasIsTrimEnabled()) {
                labelNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(IS_TRIM_ENABLED_PARAM, (Object)label.getIsTrimEnabled()));
            }
            out.addNode(labelNode);
        }
    }
}

