/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.AlarmCommands;
import com.mapr.cli.LicenseCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.License;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.log4j.Logger;

public class Dashboard
extends CLIBaseClass
implements CLIInterface {
    private String zkConnectString = null;
    private static final Logger LOG = Logger.getLogger(Dashboard.class);
    private static final String VERSION_PARAM = "version";
    private static final String MULTICLUSTER_PARAM = "multi_cluster_info";
    static final CLICommand infoCmd = new CLICommand("info", "get node info for dashboard", Dashboard.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).put((Object)"version", (Object)new BooleanInputParameter("version", "true|false", false, Boolean.valueOf(false))).put((Object)"multi_cluster_info", (Object)new BooleanInputParameter("multi_cluster_info", "true|false", false, Boolean.valueOf(false))).build(), null);
    public static final CLICommand dashboardCmds = new CLICommand("dashboard", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{infoCmd}).setShortUsage("dashboard [info] -[version|multi_cluster_info]");

    public Dashboard(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private void addVolumeSummary(CLDBProto.ClusterInfoResponse resp, CommandOutput.OutputHierarchy.OutputNode finalNode) {
        if (!resp.hasVolSummary()) {
            return;
        }
        CLDBProto.VolumeInfoSummary vSum = resp.getVolSummary();
        CommandOutput.OutputHierarchy.OutputNode mounted = new CommandOutput.OutputHierarchy.OutputNode("mounted");
        mounted.addChild(new CommandOutput.OutputHierarchy.OutputNode("total", vSum.getMountedCount()));
        mounted.addChild(new CommandOutput.OutputHierarchy.OutputNode("size", vSum.getMountedSizeMB()));
        CommandOutput.OutputHierarchy.OutputNode unmounted = new CommandOutput.OutputHierarchy.OutputNode("unmounted");
        unmounted.addChild(new CommandOutput.OutputHierarchy.OutputNode("total", vSum.getUnmountedCount()));
        unmounted.addChild(new CommandOutput.OutputHierarchy.OutputNode("size", vSum.getUnmountedSizeMB()));
        CommandOutput.OutputHierarchy.OutputNode vNode = new CommandOutput.OutputHierarchy.OutputNode("volumes");
        vNode.addChild(mounted);
        vNode.addChild(unmounted);
        finalNode.addChild(vNode);
    }

    private void addMirrorSummary(CLDBProto.ClusterInfoResponse resp, CommandOutput.OutputHierarchy.OutputNode finalNode) {
        if (!resp.hasMirrorSummary()) {
            return;
        }
        CLDBProto.MirrorSummary mSum = resp.getMirrorSummary();
        CommandOutput.OutputHierarchy.OutputNode vNode = new CommandOutput.OutputHierarchy.OutputNode("mirrors");
        vNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("num jobs", mSum.getMirrorJobs()));
        vNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("active containers", mSum.getNumActiveContainers()));
        vNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("resync containers", mSum.getNumResyncContainers()));
        vNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("mirrored datasize mb", mSum.getDataSizeMirroredMB()));
        vNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("remaining datasize mb", mSum.getDataSizeToMirrorMB()));
        vNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("completion pcnt", (Object)Float.valueOf(mSum.getCompletionPcnt())));
        finalNode.addChild(vNode);
    }

    private void addVolumesConsumptionInfo(CLDBProto.ClusterInfoResponse resp, CommandOutput.OutputHierarchy.OutputNode utilizationNode) {
        if (!resp.hasVolSummary()) {
            return;
        }
        CLDBProto.VolumeInfoSummary volInfoSummary = resp.getVolSummary();
        CommandOutput.OutputHierarchy.OutputNode tieringNode = new CommandOutput.OutputHierarchy.OutputNode("tiering");
        if (volInfoSummary.hasTieredTotalLogicalSizeMB()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("logicalUsed", volInfoSummary.getTieredTotalLogicalSizeMB() >> 10));
        }
        if (volInfoSummary.hasTieredReplicatedLogicalUsedMB()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicatedLogicalUsed", volInfoSummary.getTieredReplicatedLogicalUsedMB() >> 10));
        }
        if (volInfoSummary.hasTieredReplicatedTotalUsedMB()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicatedTotalUsed", volInfoSummary.getTieredReplicatedTotalUsedMB() >> 10));
        }
        if (volInfoSummary.hasMetaDBUsedMB()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("metaDBUsedMB", volInfoSummary.getMetaDBUsedMB()));
        }
        if (volInfoSummary.hasReplicatedMetaDBUsedMB()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicatedMetaDBUsedMB", volInfoSummary.getReplicatedMetaDBUsedMB()));
        }
        if (volInfoSummary.hasCloudOffloadedMBTotal()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("offloaded", volInfoSummary.getCloudOffloadedMBTotal() >> 10));
        }
        if (volInfoSummary.hasCloudRecalledMBTotal()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("recalled", volInfoSummary.getCloudRecalledMBTotal() >> 10));
        }
        if (volInfoSummary.hasCvTotalUsedMB()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("cvTotalUsed", volInfoSummary.getCvTotalUsedMB() >> 10));
        }
        if (volInfoSummary.hasReplicatedCvTotalUsedMB()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicatedCvTotalUsed", volInfoSummary.getReplicatedCvTotalUsedMB() >> 10));
        }
        if (volInfoSummary.hasEcOffloadedMBTotal()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ecOffloaded", volInfoSummary.getEcOffloadedMBTotal() >> 10));
        }
        if (volInfoSummary.hasEcRecalledMBTotal()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ecRecalled", volInfoSummary.getEcRecalledMBTotal() >> 10));
        }
        if (volInfoSummary.hasEcTotalUsedMB()) {
            tieringNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ecTotalUsed", volInfoSummary.getEcTotalUsedMB() >> 10));
        }
        utilizationNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("tiering", (Object)tieringNode));
    }

    private void addUtilization(CLDBProto.ClusterInfoResponse resp, CommandOutput.OutputHierarchy.OutputNode finalNode) {
        CommandOutput.OutputHierarchy.OutputNode cpuNode = new CommandOutput.OutputHierarchy.OutputNode("cpu");
        int numServers = resp.getClusterNumLiveFileServers();
        cpuNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("util", numServers != 0 ? resp.getClusterCpuUtilization() / (long)numServers : 0L));
        cpuNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("total", resp.getClusterCpuCount()));
        cpuNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("active", new Double(resp.getClusterCpuUsed()).longValue()));
        CommandOutput.OutputHierarchy.OutputNode memNode = new CommandOutput.OutputHierarchy.OutputNode("memory");
        memNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("total", resp.getClusterMemCapacitySizeMB()));
        memNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("active", resp.getClusterMemOccupiedSizeMB()));
        CommandOutput.OutputHierarchy.OutputNode diskNode = new CommandOutput.OutputHierarchy.OutputNode("disk_space");
        diskNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("total", resp.getClusterCapacitySizeMB() / 1024L));
        diskNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("active", resp.getClusterOccupiedSizeMB() / 1024L));
        CommandOutput.OutputHierarchy.OutputNode compressNode = new CommandOutput.OutputHierarchy.OutputNode("compression");
        compressNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("compressed", resp.getVolSummary().getTotalSizeMB() / 1024L));
        compressNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("uncompressed", resp.getVolSummary().getTotalLogicalSizeMB() / 1024L));
        CommandOutput.OutputHierarchy.OutputNode uNode = new CommandOutput.OutputHierarchy.OutputNode("utilization");
        uNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("cpu", (Object)cpuNode));
        uNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("memory", (Object)memNode));
        uNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("disk_space", (Object)diskNode));
        uNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("compression", (Object)compressNode));
        this.addVolumesConsumptionInfo(resp, uNode);
        finalNode.addChild(uNode);
    }

    private void addReplication(CLDBProto.ClusterInfoResponse resp, CommandOutput.OutputHierarchy.OutputNode finalNode) {
        CommandOutput.OutputHierarchy.OutputNode uNode = new CommandOutput.OutputHierarchy.OutputNode("clusterReplication");
        uNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bytesReceived", resp.getClusterReplicationBytesReceived()));
        uNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bytesSend", resp.getClusterReplicationBytesSent()));
        finalNode.addChild(uNode);
    }

    private void addStream(CLDBProto.ClusterInfoResponse resp, CommandOutput.OutputHierarchy.OutputNode finalNode) {
        CommandOutput.OutputHierarchy.OutputNode uNode = new CommandOutput.OutputHierarchy.OutputNode("streamThroughput");
        uNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bytesProduced", resp.getStreamBytesProduced()));
        uNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bytesConsumed", resp.getStreamBytesConsumed()));
        finalNode.addChild(uNode);
    }

    private void addVersion(CLDBProto.ClusterInfoResponse resp, CommandOutput.OutputHierarchy.OutputNode finalNode) {
        CommandOutput.OutputHierarchy.OutputNode vNode = new CommandOutput.OutputHierarchy.OutputNode(VERSION_PARAM, (Object)resp.getBuildVersion());
        finalNode.addChild(vNode);
    }

    private void addClusterInfo(CLDBProto.ClusterInfoResponse resp, CommandOutput.OutputHierarchy.OutputNode finalNode, String clusterName) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode cNode = new CommandOutput.OutputHierarchy.OutputNode("cluster");
        String curCluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        boolean flag = false;
        if (clusterName != null && !curCluster.equals(clusterName)) {
            flag = true;
            curCluster = clusterName;
        }
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("name", (Object)curCluster));
        boolean isSecureCluster = JNISecurity.IsSecurityEnabled((String)curCluster);
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("secure", (Object)isSecureCluster));
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("dare", (Object)resp.getDareEnforced()));
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("globalPolicyMaster", (Object)resp.getIsGlobalPolicyMaster()));
        Map clustersMap = CLDBRpcCommonUtils.getInstance().getClusterMap();
        if (flag) {
            try {
                for (String cldbip : ((CLDBRpcCommonUtils.IpPort)((List)clustersMap.get(curCluster)).get(0)).getAddr()) {
                    if (cldbip.isEmpty()) continue;
                    cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)cldbip));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while getting CLDB ip for cluster: " + curCluster + ", " + e.getMessage()));
            }
        } else {
            for (String cldbip : CLDBRpcCommonUtils.getInstance().getCurrentValidIpPort().getAddr()) {
                if (cldbip.isEmpty()) continue;
                cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)cldbip));
                break;
            }
        }
        License.LicenseIdResponse licId = LicenseCommands.fetchClusterID(curCluster, this.getUserCredentials());
        int licenseNodesTotal = 0;
        int licenseNodesUsed = 0;
        String clusterId = null;
        if (licId != null) {
            if (licId.getStatus() == 0) {
                clusterId = licId.getClusterid();
                licenseNodesUsed = licId.getNodesUsed();
                licenseNodesTotal = licId.getNodesTotal();
            } else if (licId.hasMessage()) {
                clusterId = licId.getMessage();
            }
        }
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", (Object)clusterId));
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("nodesUsed", licenseNodesUsed));
        cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalNodesAllowed", licenseNodesTotal));
        finalNode.addChild(cNode);
        for (String cluster : clustersMap.keySet()) {
            if (cluster.equalsIgnoreCase(curCluster)) continue;
            CommandOutput.OutputHierarchy.OutputNode mcNode = new CommandOutput.OutputHierarchy.OutputNode();
            mcNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("name", (Object)cluster));
            try {
                for (String cldbip : ((CLDBRpcCommonUtils.IpPort)((List)clustersMap.get(cluster)).get(0)).getAddr()) {
                    if (cldbip.isEmpty()) continue;
                    mcNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)cldbip));
                    break;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while getting CLDB ip for cluster: " + cluster), (Throwable)e);
            }
            finalNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(MULTICLUSTER_PARAM, (Object)mcNode));
        }
    }

    private void addYarnStats(CommandOutput.OutputHierarchy.OutputNode finalNode) {
        LOG.debug((Object)"addYarnStats start");
        try {
            this.zkConnectString = this.isParamPresent("zkconnect") ? this.getParamTextValue("zkconnect", 0) : CLDBRpcCommonUtils.getInstance().getZkConnect();
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)"Could not find Zookeeper Connect String", (Throwable)e);
            return;
        }
        final YarnClient yc = MapRCliUtil.getYarnClient(this.zkConnectString);
        if (yc == null) {
            return;
        }
        try {
            int countRunningApps = 0;
            int countQueuedApps = 0;
            int totalMemoryMB = 0;
            int totalVCores = 0;
            int usedMemoryMB = 0;
            int usedVCores = 0;
            int numNodeManagers = 0;
            double totalDisks = 0.0;
            double usedDisks = 0.0;
            Callable<YarnClusterMetrics> callableYarnClusterMetrics = new Callable<YarnClusterMetrics>(){

                @Override
                public YarnClusterMetrics call() throws Exception {
                    return yc.getYarnClusterMetrics();
                }
            };
            YarnClusterMetrics ycm = MapRCliUtil.asyncInvoke(callableYarnClusterMetrics, "Getting Yarn Cluster Metrics from ResourceManager");
            if (ycm == null) {
                return;
            }
            Callable<List<ApplicationReport>> callableAppReports = new Callable<List<ApplicationReport>>(){

                @Override
                public List<ApplicationReport> call() throws Exception {
                    return yc.getApplications();
                }
            };
            List<ApplicationReport> allAppReports = MapRCliUtil.asyncInvoke(callableAppReports, "Getting Application Reports from ResourceManager");
            if (allAppReports == null) {
                return;
            }
            Callable<List<NodeReport>> callableNodeReports = new Callable<List<NodeReport>>(){

                @Override
                public List<NodeReport> call() throws Exception {
                    return yc.getNodeReports(new NodeState[0]);
                }
            };
            List<NodeReport> allNodeReports = MapRCliUtil.asyncInvoke(callableNodeReports, "Getting Node Reports from ResourceManager");
            if (allNodeReports == null) {
                return;
            }
            numNodeManagers = ycm.getNumNodeManagers();
            for (ApplicationReport ar : allAppReports) {
                YarnApplicationState appstate = ar.getYarnApplicationState();
                switch (appstate) {
                    case RUNNING: {
                        ++countRunningApps;
                        break;
                    }
                    case NEW: 
                    case NEW_SAVING: 
                    case SUBMITTED: 
                    case ACCEPTED: {
                        ++countQueuedApps;
                        break;
                    }
                }
            }
            LOG.debug((Object)("Number of Node reports received = " + allNodeReports.size()));
            for (NodeReport nr : allNodeReports) {
                LOG.debug((Object)nr);
                if (nr.getNodeState().isUnusable()) {
                    LOG.debug((Object)("Skipping Node: " + nr.getNodeId().getHost() + ":" + nr.getNodeId().getPort() + " as Node is in " + nr.getNodeState() + " State"));
                    continue;
                }
                LOG.debug((Object)("Counting Node: " + nr.getNodeId().getHost() + ":" + nr.getNodeId().getPort() + " as Node is in " + nr.getNodeState() + " State"));
                Resource capability = nr.getCapability();
                totalMemoryMB += capability.getMemory();
                totalVCores += capability.getVirtualCores();
                totalDisks += capability.getDisks();
                Resource used = nr.getUsed();
                if (used == null) continue;
                usedMemoryMB += used.getMemory();
                usedVCores += used.getVirtualCores();
                usedDisks += used.getDisks();
            }
            CommandOutput.OutputHierarchy.OutputNode yarnNode = new CommandOutput.OutputHierarchy.OutputNode("yarn");
            yarnNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("running_applications", countRunningApps));
            yarnNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("queued_applications", countQueuedApps));
            yarnNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("num_node_managers", numNodeManagers));
            yarnNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("total_memory_mb", totalMemoryMB));
            yarnNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("total_vcores", totalVCores));
            yarnNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("total_disks", (Object)totalDisks));
            yarnNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("used_memory_mb", usedMemoryMB));
            yarnNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("used_vcores", usedVCores));
            yarnNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("used_disks", (Object)usedDisks));
            finalNode.addChild(yarnNode);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while fetching Yarn Stats: ", (Throwable)e);
        }
        LOG.debug((Object)"addYarnStats end");
    }

    private void addServices(CommandOutput.OutputHierarchy.OutputNode finalNode) {
        Map<Object, Object> runningServices = new HashMap();
        Map<Object, Object> configuredServices = new HashMap();
        String clusterName = "";
        try {
            if (this.isParamPresent("cluster")) {
                clusterName = this.getParamTextValue("cluster", 0);
            }
            runningServices = NodesCommonUtils.findServicesRunningHierarchy(this.zkConnectString, clusterName);
            configuredServices = NodesCommonUtils.findConfiguredServicesByServiceHierarchy(this.zkConnectString, clusterName);
        }
        catch (Throwable t) {
            LOG.error((Object)"Exception during services fetch operation", t);
        }
        HashMap<String, Integer> runningServiceNodes = new HashMap<String, Integer>();
        for (Map.Entry<Object, Object> nodeRunningServices : runningServices.entrySet()) {
            for (String service : (List)nodeRunningServices.getValue()) {
                Integer serviceCounter = (Integer)runningServiceNodes.get(service);
                if (serviceCounter == null) {
                    runningServiceNodes.put(service, 0);
                }
                int counter = (Integer)runningServiceNodes.get(service);
                runningServiceNodes.put(service, ++counter);
            }
        }
        CommandOutput.OutputHierarchy.OutputNode sNode = new CommandOutput.OutputHierarchy.OutputNode("services");
        for (Map.Entry<Object, Object> configuredServiceEntry : configuredServices.entrySet()) {
            String serviceName = (String)configuredServiceEntry.getKey();
            CommandOutput.OutputHierarchy.OutputNode nodeG = new CommandOutput.OutputHierarchy.OutputNode();
            Integer runningTotal = (Integer)runningServiceNodes.get(serviceName);
            Integer standby = null;
            String maxRunning = this.getMaxRunningInstancesMap(serviceName, clusterName).get(serviceName);
            Map<String, Integer> actionCountMap = this.getActionCountMap(serviceName, runningServices, clusterName);
            Integer failed = actionCountMap.get("failed");
            Integer stopped = actionCountMap.get("stop");
            List configuredNodesList = (List)configuredServiceEntry.getValue();
            if (failed == null) {
                failed = 0;
            }
            if (stopped == null) {
                stopped = 0;
            }
            if (maxRunning != null) {
                int running;
                int configured = configuredNodesList.size();
                int n = running = runningTotal == null ? 0 : runningTotal;
                if (!maxRunning.equalsIgnoreCase("all") && (standby = Integer.valueOf(configured - running - stopped - failed)) < 0) {
                    LOG.error((Object)("Number of standby nodes is negative: " + standby + ". configured - running - stopped - failed = " + configured + ", " + running + ", " + stopped + ", " + failed));
                    standby = 0;
                }
            }
            if (runningTotal != null) {
                nodeG.addChild(new CommandOutput.OutputHierarchy.OutputNode("active", (Object)runningTotal));
            } else {
                nodeG.addChild(new CommandOutput.OutputHierarchy.OutputNode("active", 0));
            }
            if (standby != null) {
                nodeG.addChild(new CommandOutput.OutputHierarchy.OutputNode("standby", standby));
            }
            if (stopped != null) {
                nodeG.addChild(new CommandOutput.OutputHierarchy.OutputNode("stopped", (Object)stopped));
            }
            nodeG.addChild(new CommandOutput.OutputHierarchy.OutputNode("failed", (Object)failed));
            if (configuredNodesList != null) {
                nodeG.addChild(new CommandOutput.OutputHierarchy.OutputNode("total", configuredNodesList.size()));
            } else {
                nodeG.addChild(new CommandOutput.OutputHierarchy.OutputNode("total", 0));
            }
            sNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(serviceName, (Object)nodeG));
        }
        finalNode.addChild(sNode);
    }

    private Map<String, String> getMaxRunningInstancesMap(String service, String clusterName) {
        Properties wardenProps;
        String servicesString;
        HashMap maxInstances = Maps.newHashMap();
        Map<String, Properties> serviceNodesProperties = NodesCommonUtils.getServiceNodesProperties(this.zkConnectString, service, clusterName);
        if (serviceNodesProperties != null && !serviceNodesProperties.isEmpty() && (servicesString = (String)(wardenProps = (Properties)Lists.newArrayList(serviceNodesProperties.values()).get(0)).get("services")) != null && !servicesString.isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(servicesString, ";");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String[] parts = token.split(":");
                maxInstances.put(parts[0], parts[1]);
            }
        }
        return maxInstances;
    }

    private Map<String, Integer> getActionCountMap(String serviceName, Map<String, List<String>> runningServices, String clusterName) {
        HashMap<String, Integer> actionCountMap = new HashMap<String, Integer>();
        Map<String, Properties> serviceNodesProperties = NodesCommonUtils.getServiceNodesProperties(this.zkConnectString, serviceName, clusterName);
        for (Map.Entry<String, Properties> nodeProps : serviceNodesProperties.entrySet()) {
            List<String> services;
            String nodeName = nodeProps.getKey();
            Properties props = nodeProps.getValue();
            String actionPropValue = props.getProperty("last.action");
            if (actionPropValue == null || !"failed".equalsIgnoreCase(actionPropValue) && !"stop".equalsIgnoreCase(actionPropValue) || (services = runningServices.get(nodeName)) != null && !services.isEmpty() && services.contains(serviceName)) continue;
            Integer count = (Integer)actionCountMap.get(actionPropValue);
            if (count == null) {
                actionCountMap.put(actionPropValue, 0);
            }
            actionCountMap.put(actionPropValue, (Integer)actionCountMap.get(actionPropValue) + 1);
        }
        return actionCountMap;
    }

    private int getNumNodesWithServiceFailedAlarm(String service) throws CLIProcessingException {
        int numFailed = 0;
        CLDBProto.AlarmLookupRequest.Builder reqBuilder = CLDBProto.AlarmLookupRequest.newBuilder().setCreds(this.getUserCredentials());
        Common.AlarmMsg.Builder msgBuilder = Common.AlarmMsg.newBuilder();
        msgBuilder.setAlarmType(Common.AlarmType.NODE_ALARM);
        msgBuilder.setAlarmId(this.getAlarmIdForService(service));
        reqBuilder.addAlarms(msgBuilder);
        AlarmCommands ac = new AlarmCommands(this.getInput(), this.cliCommand);
        try {
            CLDBProto.AlarmLookupResponse response = (CLDBProto.AlarmLookupResponse)ac.sendRequest((MessageLite)reqBuilder.build());
            if (response != null) {
                numFailed = response.getAlarmsCount();
            }
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)"Exception while fetching alarm information.", (Throwable)e);
        }
        return numFailed;
    }

    private Common.AlarmId getAlarmIdForService(String serviceName) {
        try {
            ServicesEnum service = ServicesEnum.valueOf(serviceName);
            switch (service) {
                case cldb: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_CLDB_DOWN;
                }
                case fileserver: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_FILESERVER_DOWN;
                }
                case hoststats: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_HOSTSTATS_DOWN;
                }
                case nfs: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_NFS_DOWN;
                }
                case nfs4: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_NFS4_DOWN;
                }
                case hbmaster: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_HBMASTER_DOWN;
                }
                case hbregionserver: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_HBREGION_DOWN;
                }
                case jobtracker: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_JT_DOWN;
                }
                case tasktracker: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_TT_DOWN;
                }
                case apiserver: {
                    return Common.AlarmId.NODE_ALARM_SERVICE_WEBSERVER_DOWN;
                }
            }
            String alarmKey = "NODE_ALARM_SERVICE_" + serviceName.toUpperCase() + "_DOWN";
            return Common.AlarmId.valueOf((String)alarmKey);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Unknown service: " + serviceName));
            return null;
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        CommandOutput.OutputHierarchy.OutputNode finalNode = new CommandOutput.OutputHierarchy.OutputNode();
        try {
            byte[] replyData;
            CLDBProto.ClusterInfoRequest req = CLDBProto.ClusterInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setColumns(-1L).build();
            String cluster = null;
            if (this.isParamPresent("cluster")) {
                cluster = this.getParamTextValue("cluster", 0);
                if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                    return output;
                }
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterInfoProc.getNumber(), (MessageLite)req, CLDBProto.ClusterInfoResponse.class);
            } else {
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterInfoProc.getNumber(), (MessageLite)req, CLDBProto.ClusterInfoResponse.class);
            }
            if (replyData == null) {
                LOG.error((Object)"Could not get cluster info data from CLDB");
            } else {
                CLDBProto.ClusterInfoResponse resp = CLDBProto.ClusterInfoResponse.parseFrom((byte[])replyData);
                boolean printAll = true;
                if (this.getParamBooleanValue(VERSION_PARAM, 0)) {
                    this.addVersion(resp, finalNode);
                    printAll = false;
                }
                if (this.getParamBooleanValue(MULTICLUSTER_PARAM, 0)) {
                    this.addClusterInfo(resp, finalNode, cluster);
                    printAll = false;
                }
                if (!printAll) {
                    out.addNode(finalNode);
                    return output;
                }
                this.addVersion(resp, finalNode);
                this.addClusterInfo(resp, finalNode, cluster);
                this.addVolumeSummary(resp, finalNode);
                this.addMirrorSummary(resp, finalNode);
                this.addUtilization(resp, finalNode);
                this.addReplication(resp, finalNode);
                this.addStream(resp, finalNode);
                this.addLabelStats(resp, finalNode);
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception doing RPC to CLDB " + e));
        }
        if (this.isParamPresent("cluster")) {
            out.addNode(finalNode);
            return output;
        }
        this.zkConnectString = this.isParamPresent("zkconnect") ? this.getParamTextValue("zkconnect", 0) : CLDBRpcCommonUtils.getInstance().getZkConnect();
        if (this.zkConnectString != null && !this.zkConnectString.trim().isEmpty()) {
            this.addServices(finalNode);
            this.addYarnStats(finalNode);
        }
        out.addNode(finalNode);
        return output;
    }

    private void addLabelStats(CLDBProto.ClusterInfoResponse resp, CommandOutput.OutputHierarchy.OutputNode finalNode) {
        for (CLDBProto.LabelStats labelStats : resp.getLabelStatsList()) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode("labels_stats");
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("label", (Object)labelStats.getLabel()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("label_id", labelStats.getLabelId()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("total_size", labelStats.getCapacity()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("used", labelStats.getUsedSize()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("num_sps", labelStats.getNumSps()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("num_volumes", labelStats.getNumVolumes()));
            finalNode.addChild(node);
        }
    }
}

