/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.VolumeCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.VolumeUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class VolumeTierCommands
extends CLIBaseClass
implements CLIInterface {
    public static final String VOLUME_PARAM_NAME = "name";
    public static final String TRIGGER_NOW_PARAM_NAME = "triggernow";
    public static final String IGNORE_RULE_PARAM_NAME = "ignorerule";
    public static final String FORCE_RECALL_EXPIRY_PARAM_NAME = "forcerecallexpiry";
    public static final String VERBOSE_STATUS = "verbose";
    public static final String INTERNAL_STATUS = "internal";
    private static final int GW_READY_NUM_POLLS = 10;
    private static final int GW_READY_POLL_TIME = 30;
    private static final Logger LOG = Logger.getLogger(VolumeTierCommands.class);
    public static final String offloadUsage = "volume offload -name volname [-ignorerule <true|false>] [-cluster clustername]";
    public static final String recallUsage = "volume recall -name volname [-cluster clustername]";
    public static final String compactionUsage = "volume compact -name volname [-forcerecallexpiry <true|false>] [-cluster clustername]";
    public static final String abortUsage = "volume tierjobabort -name volname [-cluster clustername]";
    public static final String tierjobstatusUsage = "volume tierjobstatus -name volname [-cluster clustername]";
    public static final String tierStatsUsage = "volume tierstats -name volname [-cluster clustername]";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static final CLICommand offloadCommand = new CLICommand("offload", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"ignorerule", (Object)new BooleanInputParameter("ignorerule", "<true|false>", false, Boolean.valueOf(false))).build(), null).setShortUsage("volume offload -name volname [-ignorerule <true|false>] [-cluster clustername]");
    public static final CLICommand recallCommand = new CLICommand("recall", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("volume recall -name volname [-cluster clustername]");
    public static final CLICommand compactionCommand = new CLICommand("compact", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"forcerecallexpiry", (Object)new BooleanInputParameter("forcerecallexpiry", "<true|false>", false, Boolean.valueOf(false))).build(), null).setShortUsage("volume compact -name volname [-forcerecallexpiry <true|false>] [-cluster clustername]");
    public static final CLICommand tierjobstatusCommand = new CLICommand("tierjobstatus", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"verbose", (Object)new BooleanInputParameter("verbose", "<true|false>", false, Boolean.valueOf(false))).put((Object)"internal", (Object)new BooleanInputParameter("internal", "<true|false>", false, Boolean.valueOf(false)).setInvisible(true)).build(), null).setShortUsage("volume tierjobstatus -name volname [-cluster clustername]");
    public static final CLICommand tierStatsCommand = new CLICommand("tierstats", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("volume tierstats -name volname [-cluster clustername]");
    public static final CLICommand abortCommand = new CLICommand("tierjobabort", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("volume tierjobabort -name volname [-cluster clustername]");

    public VolumeTierCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse resp;
        String cluster = null;
        String volumeName = null;
        Object credentials = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ExecuteRealCommand" + this.cliCommand.getCommandName()));
        }
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if (this.isParamPresent(VOLUME_PARAM_NAME)) {
            volumeName = this.getParamTextValue(VOLUME_PARAM_NAME, 0);
        }
        if ((resp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), volumeName, null, this.isServerCall)).hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume " + volumeName + " does not exist in cluster"));
            return output;
        }
        int volumeId = resp.getVolInfo().getVolumeId();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("offload")) {
            try {
                boolean ignoreRule = false;
                boolean triggerNow = true;
                if (this.isParamPresent(IGNORE_RULE_PARAM_NAME)) {
                    ignoreRule = this.getParamBooleanValue(IGNORE_RULE_PARAM_NAME, 0);
                }
                this.offloadVolume(out, cluster, volumeId, ignoreRule, triggerNow);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Offload Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("recall")) {
            try {
                this.recallVolume(out, cluster, volumeId);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Recall Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("compact")) {
            try {
                boolean forceRecallExpiry = false;
                if (this.isParamPresent(FORCE_RECALL_EXPIRY_PARAM_NAME)) {
                    forceRecallExpiry = this.getParamBooleanValue(FORCE_RECALL_EXPIRY_PARAM_NAME, 0);
                }
                this.compactVolume(out, cluster, volumeId, forceRecallExpiry);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Recall Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("tierjobabort")) {
            try {
                this.abortVolume(out, cluster, volumeId);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Abort Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("tierjobstatus")) {
            boolean verbose = false;
            if (this.isParamPresent(VERBOSE_STATUS)) {
                verbose = this.getParamBooleanValue(VERBOSE_STATUS, 0);
            }
            boolean internal = false;
            if (this.isParamPresent(INTERNAL_STATUS)) {
                internal = this.getParamBooleanValue(INTERNAL_STATUS, 0);
            }
            try {
                this.tierjobstatus(out, cluster, volumeId, resp.getVolInfo().getVolProperties(), verbose, internal);
            }
            catch (Exception e) {
                throw new CLIProcessingException("tierjobstatus Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("tierstats")) {
            try {
                this.tierStats(out, cluster, volumeId);
            }
            catch (Exception e) {
                throw new CLIProcessingException("tierStats Exception", (Throwable)e);
            }
        }
        return output;
    }

    private boolean isRetriableOffloadError(int error) {
        return VolumeUtils.isRetriableOffloadError((int)error);
    }

    private void offloadVolume(CommandOutput.OutputHierarchy out, String cluster, int volumeId, boolean ignoreRule, boolean triggerNow) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        resp = this.sendVolumeTierOp(out, cluster, volumeId, CLDBProto.VolumeTierOp.OFFLOAD, ignoreRule, false, triggerNow, false, true);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully started offload.");
        } else {
            String errMsg = this.printCommandError(out, resp);
            LOG.error((Object)("Start volume offload for " + volumeId + " Failed. " + errMsg));
        }
    }

    private void recallVolume(CommandOutput.OutputHierarchy out, String cluster, int volumeId) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        resp = this.sendVolumeTierOp(out, cluster, volumeId, CLDBProto.VolumeTierOp.RECALL, true, true, true, false, true);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully started recall.");
        } else {
            String errMsg = this.printCommandError(out, resp);
            LOG.error((Object)("Start volume recall for " + volumeId + " Failed. " + errMsg));
        }
    }

    private void compactVolume(CommandOutput.OutputHierarchy out, String cluster, int volumeId, boolean forceRecallExpiry) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        resp = this.sendVolumeTierOp(out, cluster, volumeId, CLDBProto.VolumeTierOp.COMPACTION, true, forceRecallExpiry, true, false);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully started compaction.");
        } else {
            String errMsg = this.printCommandError(out, resp);
            LOG.error((Object)("Start volume compaction for " + volumeId + " Failed. " + errMsg));
        }
    }

    private void abortVolume(CommandOutput.OutputHierarchy out, String cluster, int volumeId) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        resp = this.sendVolumeTierOp(out, cluster, volumeId, CLDBProto.VolumeTierOp.OFFLOAD, false, false, false, true, false);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully started abort.");
        } else {
            String errMsg = this.printCommandError(out, resp);
            LOG.error((Object)("Start volume abort for " + volumeId + " Failed. " + errMsg));
        }
    }

    private void addCompactionTaskStatus(CLDBProto.GetTierJobStatusResponse resp, CommandOutput.OutputHierarchy.OutputNode tierJobNode, CLDBProto.CompactionTask cTask, boolean isExternal) {
        boolean abortInternalInProgress = resp.hasAbortInternalInProgress() && resp.getAbortInternalInProgress();
        String stateStr = null;
        stateStr = cTask.getState() == CLDBProto.CompactionTaskState.COMPACTION_INIT ? "Scheduled" : (cTask.getState() == CLDBProto.CompactionTaskState.COMPACTION_START ? "Running" : (cTask.getState() == CLDBProto.CompactionTaskState.COMPACTION_END ? "Success" : (cTask.getState() == CLDBProto.CompactionTaskState.COMPACTION_FAIL ? (this.isRetriableOffloadError(cTask.getStatus()) ? "FailureRetry, RetryCount: " + cTask.getNRetry() : (cTask.getStatus() == 4 ? "AbortedInternal" : "FailureFatal")) : (cTask.getState() == CLDBProto.CompactionTaskState.COMPACTION_ABORT_START ? (abortInternalInProgress ? "AbortInternalInProgress" : "AbortInProgress") : (cTask.getState() == CLDBProto.CompactionTaskState.COMPACTION_ABORT_END ? (abortInternalInProgress || cTask.getStatus() == 4 ? "AbortedInternal" : "Aborted") : "Unknown state")))));
        tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("state", (Object)stateStr));
        if (resp.hasVolTierStats() && cTask.getState() != CLDBProto.CompactionTaskState.COMPACTION_INIT && cTask.getIpsCount() > 0) {
            if (resp.getVolTierStats().hasCompactionStats()) {
                CLDBProto.CompactionTierStats cStats = resp.getVolTierStats().getCompactionStats();
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("progress", (Object)(Long.toString(cStats.getJobProgressInPercentage()) + "%")));
            } else {
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("progress", (Object)"0%"));
            }
        }
        if (cTask.hasStartTime()) {
            String timeStr = null;
            timeStr = cTask.getState() == CLDBProto.CompactionTaskState.COMPACTION_INIT ? "scheduleTime" : "startTime";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
            dateFormat.setTimeZone(TimeZone.getDefault());
            String timeStamp = dateFormat.format(new Date(cTask.getStartTime()));
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(timeStr, (Object)timeStamp));
        }
        if (cTask.hasEndTime()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
            dateFormat.setTimeZone(TimeZone.getDefault());
            String timeStamp = dateFormat.format(new Date(cTask.getEndTime()));
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("endTime", (Object)timeStamp));
            if (isExternal && resp.hasVolTierStats()) {
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("reclaimedDataSize", (Object)(this.toMBSizeStr(resp.getVolTierStats().getCurrJobReclaimedDataSize()) + " MB")));
            }
        }
        if (cTask.getIpsCount() > 0) {
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)VolumeUtils.printIPAddresses((List)cTask.getIpsList())));
        } else {
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)"Unknown IP"));
        }
    }

    private void addOffloadTaskStatus(CLDBProto.GetTierJobStatusResponse resp, CommandOutput.OutputHierarchy.OutputNode tierJobNode, CLDBProto.OffloadTask oTask, boolean isExternal) {
        String stateStr = VolumeUtils.getTierJobStatus((CLDBProto.OffloadTaskState)oTask.getState(), (int)oTask.getStatus(), (int)oTask.getNRetry(), (resp.hasAbortInternalInProgress() && resp.getAbortInternalInProgress() ? 1 : 0) != 0);
        tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("state", (Object)stateStr));
        if (resp.hasVolTierStats() && oTask.getState() != CLDBProto.OffloadTaskState.OFFLOAD_INIT && oTask.getIpsCount() > 0) {
            if (resp.getVolTierStats().hasJobProgressInPercentage()) {
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("progress", (Object)(Long.toString(resp.getVolTierStats().getJobProgressInPercentage()) + "%")));
            } else {
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("progress", (Object)"0%"));
            }
        }
        if (oTask.hasStartTime()) {
            String timeStr = null;
            timeStr = oTask.getState() == CLDBProto.OffloadTaskState.OFFLOAD_INIT ? "scheduleTime" : "startTime";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
            dateFormat.setTimeZone(TimeZone.getDefault());
            String timeStamp = dateFormat.format(new Date(oTask.getStartTime()));
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(timeStr, (Object)timeStamp));
        }
        if (oTask.hasEndTime()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
            dateFormat.setTimeZone(TimeZone.getDefault());
            String timeStamp = dateFormat.format(new Date(oTask.getEndTime()));
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("endTime", (Object)timeStamp));
            if (resp.hasVolTierStats()) {
                if (oTask.getOp() == CLDBProto.VolumeTierOp.OFFLOAD) {
                    tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("offloadedDataSize", (Object)(this.toMBSizeStr(resp.getVolTierStats().getCurrJobOffloadedDataSize()) + " MB")));
                } else if (oTask.getOp() == CLDBProto.VolumeTierOp.RECALL) {
                    tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("recalledDataSize", (Object)(this.toMBSizeStr(resp.getVolTierStats().getCurrJobRecalledDataSize()) + " MB")));
                }
            }
        }
        if (oTask.getIpsCount() > 0) {
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)VolumeUtils.printIPAddresses((List)oTask.getIpsList())));
        } else {
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)"Unknown IP"));
        }
    }

    private void tierjobstatus(CommandOutput.OutputHierarchy out, String cluster, int volumeId, CLDBProto.VolumeProperties volProps, boolean verbose, boolean internal) throws CLIProcessingException {
        if (!volProps.hasIsTierOffloadEnable() || !volProps.getIsTierOffloadEnable()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tier offload not enabled for given volume"));
            return;
        }
        CLDBProto.GetTierJobStatusResponse resp = null;
        CLDBProto.GetTierJobStatusRequest.Builder req = CLDBProto.GetTierJobStatusRequest.newBuilder();
        req.setVolId(volumeId);
        req.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetTierJobStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.GetTierJobStatusResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetTierJobStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.GetTierJobStatusResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.GetTierJobStatusResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            if (resp.getStatus() == 2) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "No active jobs for given volume"));
                return;
            }
            String errMsg = Errno.toString((int)resp.getStatus());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Getting tier status failed. " + errMsg));
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode tierJobParent = new CommandOutput.OutputHierarchy.OutputNode();
        CommandOutput.OutputHierarchy.OutputNode tierJobNode = null;
        if (resp.hasOTask()) {
            String opType = VolumeUtils.getTierVolumeOp((CLDBProto.VolumeTierOp)resp.getOTask().getOp());
            tierJobNode = new CommandOutput.OutputHierarchy.OutputNode(opType);
            this.addOffloadTaskStatus(resp, tierJobNode, resp.getOTask(), true);
            tierJobParent.addChild(tierJobNode);
        }
        if (internal && resp.hasIntOTask()) {
            tierJobNode = new CommandOutput.OutputHierarchy.OutputNode("offloadInt");
            this.addOffloadTaskStatus(resp, tierJobNode, resp.getIntOTask(), false);
            tierJobParent.addChild(tierJobNode);
        }
        if (resp.hasCTask() && verbose) {
            tierJobNode = new CommandOutput.OutputHierarchy.OutputNode("compaction");
            this.addCompactionTaskStatus(resp, tierJobNode, resp.getCTask(), true);
            tierJobParent.addChild(tierJobNode);
        }
        if (internal && resp.hasIntCTask() && verbose) {
            tierJobNode = new CommandOutput.OutputHierarchy.OutputNode("compactionInt");
            this.addCompactionTaskStatus(resp, tierJobNode, resp.getIntCTask(), false);
            tierJobParent.addChild(tierJobNode);
        }
        out.addNode(tierJobParent);
    }

    private String toMBSizeStr(long sizeinBytes) {
        if (sizeinBytes == 0L) {
            return "0";
        }
        DecimalFormat df = new DecimalFormat(".###");
        return df.format((double)sizeinBytes / 1048576.0);
    }

    private void tierStats(CommandOutput.OutputHierarchy out, String cluster, int volumeId) throws CLIProcessingException {
        CLDBProto.GetVolumeTierStatsResponse resp = null;
        CLDBProto.GetVolumeTierStatsRequest req = CLDBProto.GetVolumeTierStatsRequest.newBuilder().setVolId(volumeId).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetVolumeTierStatsProc.getNumber(), (MessageLite)req, CLDBProto.GetVolumeTierStatsResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetVolumeTierStatsProc.getNumber(), (MessageLite)req, CLDBProto.GetVolumeTierStatsResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.GetVolumeTierStatsResponse.parseFrom((byte[])data);
            if (resp.hasStatus() && resp.getStatus() == 2) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "No stats entry for given volume"));
                return;
            }
            if (resp.hasStatus() && resp.getStatus() != 0) {
                String errMsg = Errno.toString((int)resp.getStatus());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Getting tierstats failed. " + errMsg));
                return;
            }
            CommandOutput.OutputHierarchy.OutputNode statsNode = new CommandOutput.OutputHierarchy.OutputNode();
            long totalOffloadedSize = resp.getTierStats().getTierDataSize();
            long ReclaimSize = resp.getTierStats().getGarbageTierDataSize();
            statsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalTierDataSize", (Object)(this.toMBSizeStr(totalOffloadedSize) + " MB")));
            statsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalTierReclaimableSize", (Object)(this.toMBSizeStr(ReclaimSize) + " MB")));
            if (resp.getTierStats().hasOffloadAvgThroughput()) {
                statsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("offloadThroughput", (Object)(this.toMBSizeStr(resp.getTierStats().getOffloadAvgThroughput()) + " MB/s")));
            }
            if (resp.getTierStats().hasRecallAvgThroughput()) {
                statsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("recallThroughput", (Object)(this.toMBSizeStr(resp.getTierStats().getRecallAvgThroughput()) + " MB/s")));
            }
            out.addNode(statsNode);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing tier lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    private String printCommandError(CommandOutput.OutputHierarchy out, CLDBProto.StartVolumeTierOpResponse resp) {
        String errMsg = resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)resp.getStatus());
        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        return errMsg;
    }

    private CLDBProto.StartVolumeTierOpResponse sendVolumeTierOp(CommandOutput.OutputHierarchy out, String cluster, int volumeId, CLDBProto.VolumeTierOp op, boolean ignoreRule, boolean forceRecallExpiry, boolean triggerNow, boolean isAbort, boolean retryOnGatewayPending) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        if (!retryOnGatewayPending) {
            resp = this.sendVolumeTierOp(out, cluster, volumeId, op, ignoreRule, forceRecallExpiry, triggerNow, isAbort);
        } else {
            int i = 0;
            for (i = 0; i < 10 && (resp = this.sendVolumeTierOp(out, cluster, volumeId, op, ignoreRule, forceRecallExpiry, triggerNow, isAbort)).getStatus() == 11; ++i) {
                try {
                    Thread.sleep(30000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return resp;
    }

    private CLDBProto.StartVolumeTierOpResponse sendVolumeTierOp(CommandOutput.OutputHierarchy out, String cluster, int volumeId, CLDBProto.VolumeTierOp op, boolean ignoreRule, boolean forceRecallExpiry, boolean triggerNow, boolean isAbort) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        CLDBProto.StartVolumeTierOpRequest.Builder req = CLDBProto.StartVolumeTierOpRequest.newBuilder();
        req.setVolumeId(volumeId);
        req.setCreds(this.getUserCredentials());
        if (!isAbort) {
            req.setOp(op);
            req.setIgnoreRule(ignoreRule);
            req.setIgnoreRecallExpiry(forceRecallExpiry);
            req.setTriggerNow(triggerNow);
        } else {
            req.setAbort(true);
        }
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.StartVolumeTierOpProc.getNumber(), (MessageLite)req.build(), CLDBProto.StartVolumeTierOpResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.StartVolumeTierOpProc.getNumber(), (MessageLite)req.build(), CLDBProto.StartVolumeTierOpResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.StartVolumeTierOpResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        return resp;
    }
}

