/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.fsrpcutils.FSRpcUtils;
import com.mapr.baseutils.fsrpcutils.GetMsgStatus;
import com.mapr.cli.GetVolumeAceResponseMsgStatus;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterProcessingException;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.VolumeUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class SnapshotCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(SnapshotCommands.class);
    private static final int NUM_SNAPSHOTS_PER_RPC = 100;
    public FSRpcUtils fsRpcUtils;
    public static final String SNAPSHOT_PARAM_VOL_NAME = "volume";
    public static final String SNAPSHOT_PARAM_VOL_PATH = "path";
    public static final String RW_VOLUME_PARAM_NAME = "volume";
    public static final String RW_VOLUME_PARAM_MOUNTDIR = "path";
    public static final String SNAPSHOT_PARAM_NAME = "snapshotname";
    public static final String SNAPSHOT_EXPIRY_PARAM_NAME = "retain";
    public static final String SNAPSHOTS_ID_PARAM_NAME = "snapshots";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String SORT_PARAM_NAME = "sort";
    public static final String SORT_DIRECTION_PARAM_NAME = "dir";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String SIZEUPDATE_ID_PARAM = "id";
    public static final String SIZEUPDATE_DELAY_PARAM = "delay";
    private static int MAX_SNAPFIELDINFO = 0;
    public static Pattern p = Pattern.compile("(\\d+)|(\\w+)");
    public static String snapshotListUsage = "volume snapshot list [-filter filters -cluster clustername]";
    public static final String snapshotCreateUsage = "volume snapshot -volume volName -snapshot snapshotName [-cluster clustername]";
    public static String snapshotRemoveUsage = "volume snapshot remove [-volume volumename] [-snapshotname snapshotName] [-snapshots comma separated IDs of snapshots]";
    public static String snapshotPreserveUsage = "volume snapshot preserve [-volume volumenames] [-path volumepathes] [-snapshots comma separated IDs of snapshots]";
    public static final String snapshotSizeUpdateUsage = "volume snapshot updatesize -id <snapshotId> [-delay <update_delay_in_minutes>] [-cluster clustername]";
    static final CLICommand snapshotCreateCommand = new CLICommand("create", "usage : volume snapshot -volume volName -snapshot snapshotName [-cluster clustername]", SnapshotCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"retain", (Object)new TextInputParameter("retain", "<+ve integer>mi|h|d|w|m|y", false, null)).put((Object)"snapshotname", (Object)new TextInputParameter("snapshotname", "snapshotName", true, null)).put((Object)"volume", (Object)new TextInputParameter("volume", "volume", true, null)).build(), null).setShortUsage("volume snapshot -volume volName -snapshot snapshotName [-cluster clustername]");
    static final CLICommand snapshotRemoveCommand = new CLICommand("remove", "usage : " + snapshotRemoveUsage, SnapshotCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"snapshotname", (Object)new TextInputParameter("snapshotname", "snapshotName", false, null)).put((Object)"volume", (Object)new TextInputParameter("volume", "volumeName", false, null)).put((Object)"snapshots", (Object)new TextInputParameter("snapshots", "comma separated IDs of snapshots", false, null)).build(), null).setShortUsage(snapshotRemoveUsage);
    static final CLICommand snapshotPreserveCommand = new CLICommand("preserve", "usage : " + snapshotPreserveUsage, SnapshotCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"volume", (Object)new TextInputParameter("volume", "comma separated volume names to preserve snapshots for", false, null)).put((Object)"path", (Object)new TextInputParameter("path", "comma separated volume pathes to preserve snapshots for", false, null)).put((Object)"filter", (Object)new FilterInputParameter("filter", "filter to preserve snapshots for", false, null)).put((Object)"snapshots", (Object)new TextInputParameter("snapshots", "comma separated IDs of snapshots to preserve", false, null)).build(), null).setShortUsage(snapshotPreserveUsage);
    static final CLICommand snapshotListCommand = new CLICommand("list", "usage : " + snapshotListUsage, SnapshotCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"volume", (Object)new TextInputParameter("volume", "volume", false, null)).put((Object)"path", (Object)new TextInputParameter("path", "path", false, null)).put((Object)"sort", (Object)new TextInputParameter("sort", "none", false, "none").setInvisible(true)).put((Object)"dir", (Object)new TextInputParameter("dir", "none", false, "ASC").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose", false, "verbose")).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)"filter", (Object)new FilterInputParameter("filter", "none", false, "none")).put((Object)"columns", (Object)new TextInputParameter("columns", "none", false, "none")).build(), null).setShortUsage(snapshotListUsage);
    private static final BaseInputParameter sizeUpdateIdsParamConfig = new IntegerInputParameter("id", "id of the snapshot whose size needs to be updated", true, null);
    private static final BaseInputParameter sizeUpdateDelayParamConfig = new IntegerInputParameter("delay", "No of minutes after which size needs to be updated", false, Integer.valueOf(0));
    private static final Map<String, BaseInputParameter> sizeUpdateParams = new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"id", (Object)sizeUpdateIdsParamConfig).put((Object)"delay", (Object)sizeUpdateDelayParamConfig).build();
    static final CLICommand sizeUpdateCommand = new CLICommand("updatesize", "usage : volume snapshot updatesize -id <snapshotId> [-delay <update_delay_in_minutes>] [-cluster clustername]", SnapshotCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, sizeUpdateParams, null).setShortUsage("volume snapshot updatesize -id <snapshotId> [-delay <update_delay_in_minutes>] [-cluster clustername]");
    private static Map<CLDBProto.SnapshotInfoFields, FieldInfo> snapshotFieldTable = new ImmutableMap.Builder().put((Object)CLDBProto.SnapshotInfoFields.rwVolumeId, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.rwVolumeId.getNumber(), "vid", "volumeid", Integer.class)).put((Object)CLDBProto.SnapshotInfoFields.snapshotId, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.snapshotId.getNumber(), "id", "snapshotid", Integer.class)).put((Object)CLDBProto.SnapshotInfoFields.snapshotName, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.snapshotName.getNumber(), "n", "snapshotname", String.class)).put((Object)CLDBProto.SnapshotInfoFields.rwVolumeName, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.rwVolumeName.getNumber(), "vn", "volumename", String.class)).put((Object)CLDBProto.SnapshotInfoFields.volumePath, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.volumePath.getNumber(), "vp", "volumepath", String.class)).put((Object)CLDBProto.SnapshotInfoFields.ownerName, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.ownerName.getNumber(), "on", "ownername", String.class)).put((Object)CLDBProto.SnapshotInfoFields.ownerType, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.ownerType.getNumber(), "ot", "ownertype", Integer.class)).put((Object)CLDBProto.SnapshotInfoFields.creationTime, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.creationTime.getNumber(), "ct", "creationtime", Long.class)).put((Object)CLDBProto.SnapshotInfoFields.expiryTime, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.expiryTime.getNumber(), "et", "expirytime", Long.class)).put((Object)CLDBProto.SnapshotInfoFields.cumulativeReclaimSizeMB, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.cumulativeReclaimSizeMB.getNumber(), "cs", "cumulativeReclaimSizeMB", Long.class)).put((Object)CLDBProto.SnapshotInfoFields.ownedSize, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.ownedSize.getNumber(), "owSz", "ownedsize", Long.class)).put((Object)CLDBProto.SnapshotInfoFields.sharedSize, (Object)new FieldInfo(CLDBProto.SnapshotInfoFields.sharedSize.getNumber(), "shSz", "sharedSize", Long.class)).build();
    public static CLICommand[] snapshotCommandsArray;
    public static CLICommand snapshotCommands;
    UnixUserGroupHelper uInfo = new UnixUserGroupHelper();

    public SnapshotCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        LOG.debug((Object)"Processing CLDBProcessing::executeRealCommand");
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            CommandOutput output = new CommandOutput();
            output.setOutput(out);
            String clusterName = null;
            clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
            this.fsRpcUtils = new FSRpcUtils(clusterName, this.getUserCredentials(), 1, Security.ServerKeyType.ServerKey, 0);
            this.list(out);
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.snapshotCreate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            try {
                return this.snapshotRemove();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("preserve")) {
            try {
                return this.snapshotPreserve();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if ("updatesize".equalsIgnoreCase(this.cliCommand.getCommandName())) {
            return this.processSizeUpdateRequest();
        }
        return new TextCommandOutput("Volume command failed".getBytes());
    }

    private CommandOutput processSizeUpdateRequest() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(SIZEUPDATE_ID_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, snapshotSizeUpdateUsage));
            return output;
        }
        int snapshotId = this.getParamIntValue(SIZEUPDATE_ID_PARAM, 0);
        int updateDelay = 0;
        if (this.isParamPresent(SIZEUPDATE_DELAY_PARAM)) {
            updateDelay = this.getParamIntValue(SIZEUPDATE_DELAY_PARAM, 0);
        }
        CLDBProto.SnapshotSizeUpdateRequest.Builder req = CLDBProto.SnapshotSizeUpdateRequest.newBuilder().setSnapshotId(snapshotId).setUpdateDelay(updateDelay);
        byte[] data = null;
        try {
            req.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotSizeUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.SnapshotSizeUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotSizeUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.SnapshotSizeUpdateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Received null response from CLDB"));
            } else {
                CLDBProto.SnapshotSizeUpdateResponse resp = CLDBProto.SnapshotSizeUpdateResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    out.addMessage(resp.getSuccessMessage());
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, resp.getErrorMessage()));
                }
            }
        }
        catch (MaprSecurityException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "encounterd MaprSecurityException..." + e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "encounterd exception..." + e.getMessage()));
        }
        return output;
    }

    private CommandOutput snapshotRemove() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (this.isParamPresent(SNAPSHOTS_ID_PARAM_NAME)) {
            String[] ids;
            String snapshotIds = this.getParamTextValue(SNAPSHOTS_ID_PARAM_NAME, 0);
            for (String id : ids = snapshotIds.split(",")) {
                CLDBProto.SnapshotRemoveRequest.Builder snapshotRemove = CLDBProto.SnapshotRemoveRequest.newBuilder();
                try {
                    snapshotRemove.setSnapshotId(Integer.valueOf(id).intValue());
                }
                catch (NumberFormatException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error parsing snapshot IDs"));
                    break;
                }
                int status = this.snapshotRemoveInternal(snapshotRemove);
                if (status == 0) {
                    LOG.info((Object)("Snapshot removed for " + id));
                    continue;
                }
                LOG.error((Object)("Snapshot remove failed with status " + status));
                if (status == 115) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshot Remove: Operation failed, snapshot can't be created or removed when mirroring is in progress for the volume"));
                    continue;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Snapshot Remove:  " + Errno.toString((int)status)));
            }
        }
        if (this.isParamPresent("volume") && this.isParamPresent(SNAPSHOT_PARAM_NAME)) {
            String rwVolumeName = this.getParamTextValue("volume", 0);
            String snapshotName = this.getParamTextValue(SNAPSHOT_PARAM_NAME, 0);
            CLDBProto.SnapshotRemoveRequest.Builder snapshotRemove = CLDBProto.SnapshotRemoveRequest.newBuilder();
            snapshotRemove.setRemoveNow(true).setRwVolumeName(rwVolumeName).setSnapshotName(snapshotName);
            int status = this.snapshotRemoveInternal(snapshotRemove);
            if (status == 0) {
                LOG.info((Object)("Snapshot removed for volume " + rwVolumeName + " snapshot name " + snapshotName));
            } else {
                LOG.error((Object)("Snapshot for volume " + rwVolumeName + " snapshot name " + snapshotName + " failed with status " + status));
                if (status == 115) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshot Remove: Operation failed, snapshot can't be created or removed when mirroring is in progress for the volume"));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Snapshot Remove:  " + Errno.toString((int)status)));
                }
            }
        }
        if (!(this.isParamPresent("volume") && this.isParamPresent(SNAPSHOT_PARAM_NAME) || this.isParamPresent(SNAPSHOTS_ID_PARAM_NAME))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Please specify both snapshot name and volume name, or just snapshot id.\n" + snapshotRemoveUsage));
        }
        return output;
    }

    private int snapshotRemoveInternal(CLDBProto.SnapshotRemoveRequest.Builder snapshotRemoveBuilder) throws CLIProcessingException {
        byte[] data = null;
        try {
            snapshotRemoveBuilder.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotRemoveProc.getNumber(), (MessageLite)snapshotRemoveBuilder.build(), CLDBProto.SnapshotRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotRemoveProc.getNumber(), (MessageLite)snapshotRemoveBuilder.build(), CLDBProto.SnapshotRemoveResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.SnapshotRemoveResponse resp = CLDBProto.SnapshotRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                LOG.info((Object)"Snapshot removed succeded ");
            } else {
                LOG.error((Object)("Snapshot remove failed with status " + resp.getStatus()));
            }
            return resp.getStatus();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException((Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Send request Exception", (Throwable)e);
            return 10003;
        }
    }

    CommandOutput snapshotPreserve() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        boolean isVolumeParamPresent = this.isParamPresent("volume");
        boolean isPathParamPresent = this.isParamPresent("path");
        boolean isFilterParamPresent = this.isParamPresent(FILTER_PARAM_NAME);
        boolean isSnapshotIdspParamPresent = this.isParamPresent(SNAPSHOTS_ID_PARAM_NAME);
        if (!(isVolumeParamPresent || isPathParamPresent || isFilterParamPresent || isSnapshotIdspParamPresent)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Neither of parameters is passed."));
            return output;
        }
        CLDBProto.SnapshotsPreserveRequest.Builder snapPreserveReqBuilder = CLDBProto.SnapshotsPreserveRequest.newBuilder();
        if (isVolumeParamPresent) {
            String volumeNamesStr = this.getParamTextValue("volume", 0);
            String[] volumeNames = volumeNamesStr.split(",");
            if (volumeNames == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volumes were not provided").setField("volume"));
                return output;
            }
            for (String volumeName : volumeNames) {
                CLDBProto.SnapshotInfo sInfo = CLDBProto.SnapshotInfo.newBuilder().setRwVolumeName(volumeName).build();
                snapPreserveReqBuilder.addSnapshotInfos(sInfo);
            }
        } else if (isSnapshotIdspParamPresent) {
            String snapshotStringIdsStr = this.getParamTextValue(SNAPSHOTS_ID_PARAM_NAME, 0);
            String[] snapshotStringIds = snapshotStringIdsStr.split(",");
            if (snapshotStringIds == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "SnapshotIds were not provided").setField(SNAPSHOTS_ID_PARAM_NAME));
                return output;
            }
            for (String snapshotIdStr : snapshotStringIds) {
                try {
                    Integer snapId = Integer.valueOf(snapshotIdStr);
                    CLDBProto.SnapshotInfo sInfo = CLDBProto.SnapshotInfo.newBuilder().setSnapshotId(snapId.intValue()).build();
                    snapPreserveReqBuilder.addSnapshotInfos(sInfo);
                }
                catch (NumberFormatException nfe) {
                    LOG.error((Object)("SnapshotID is not Integer: " + snapshotIdStr + ". Processing the rest"));
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "SnapshotID is not Integer: " + snapshotIdStr + ". Processing the rest"));
                }
            }
        } else if (isFilterParamPresent) {
            List filters = new ArrayList();
            String filterString = this.getParamTextValue(FILTER_PARAM_NAME, 0);
            if (filterString != null && !filterString.equals("none")) {
                try {
                    ArrayList<String> filterStrings = new ArrayList<String>();
                    filterStrings.add(filterString);
                    filters = FilterUtil.compileFilter(snapshotFieldTable, filterStrings);
                }
                catch (FilterProcessingException fpe) {
                    LOG.error((Object)("Exception while processing filter parameter: " + filterString), (Throwable)fpe);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Exception while processing filter parameter: " + filterString).setField(FILTER_PARAM_NAME));
                }
            }
            snapPreserveReqBuilder.addAllFilter(filters);
        } else if (isPathParamPresent) {
            String svolumePathesStr = this.getParamTextValue("path", 0);
            String[] volumePathes = svolumePathesStr.split(",");
            if (volumePathes == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume Paths were not provided").setField("path"));
                return output;
            }
            snapPreserveReqBuilder.addAllRwVolumePath(Arrays.asList(volumePathes));
        }
        byte[] data = null;
        try {
            snapPreserveReqBuilder.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotsPreserveProc.getNumber(), (MessageLite)snapPreserveReqBuilder.build(), CLDBProto.SnapshotsPreserveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotsPreserveProc.getNumber(), (MessageLite)snapPreserveReqBuilder.build(), CLDBProto.SnapshotsPreserveResponse.class);
            if (data == null) {
                LOG.error((Object)"SnapshotPreserve : Exception while processing RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service to do SnapshotPreserve"));
                return output;
            }
            CLDBProto.SnapshotsPreserveResponse resp = CLDBProto.SnapshotsPreserveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0 || resp.getStatus() == 9) {
                if (resp.getVolumesWithoutPermsCount() > 0) {
                    String warnMsg = "Warning: Caller does not have permissions for volumes ";
                    boolean addComma = false;
                    for (String volName : resp.getVolumesWithoutPermsList()) {
                        if (addComma) {
                            warnMsg = warnMsg + ", " + volName;
                            continue;
                        }
                        warnMsg = warnMsg + volName;
                        addComma = true;
                    }
                    out.addMessage(warnMsg);
                }
            } else if (resp.getStatus() == 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to preserve snapshots since the caller does not have privileges"));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshots Preserve Operation failed"));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while trying to preserve snapshots", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Exception while trying to preserve snapshots"));
        }
        return output;
    }

    private BitSet getColumns() throws CLIProcessingException {
        BitSet columns = new BitSet(snapshotFieldTable.size());
        columns.set(0, MAX_SNAPFIELDINFO + 1);
        String columnsString = this.getParamTextValue(COLUMNS_PARAM_NAME, 0);
        if (columnsString != null && !columnsString.equals("none")) {
            columns = FilterUtil.getColumns(snapshotFieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    private CLDBProto.SnapshotListRequest.Builder getSnapshotListRequestBuilder() throws CLIProcessingException {
        CLDBProto.SnapshotListRequest.Builder snapList = CLDBProto.SnapshotListRequest.newBuilder();
        snapList.addAllFilter(this.getFilters(snapshotFieldTable, FILTER_PARAM_NAME));
        snapList.setLimiter(this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 100));
        snapList.setCreds(this.getUserCredentials());
        if (this.isParamPresent("volume")) {
            String volumeNames = this.getParamTextValue("volume", 0);
            snapList.addAllRwVolumeNames(Arrays.asList(volumeNames.split(",")));
        } else if (this.isParamPresent("path")) {
            String volumePaths = this.getParamTextValue("path", 0);
            snapList.addAllRwVolumePaths(Arrays.asList(volumePaths.split(",")));
        }
        return snapList;
    }

    private CLDBProto.SnapshotListResponse getSnapshotListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.SnapshotListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into SnapshotListResponse proto object.", (Throwable)ipbe);
        }
    }

    public CLDBProto.SnapshotListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.SnapshotListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.SnapshotListRequest.newBuilder((CLDBProto.SnapshotListRequest)((CLDBProto.SnapshotListRequest)prevReq)) : this.getSnapshotListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.SnapshotListResponse)prevResp).getSnapshotsCount();
            int origStart = this.getParamIntValue(START_PARAM_NAME, 0);
            int origLimit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), ((CLDBProto.SnapshotListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.SnapshotListResponse)prevResp).getSnapshotsCount());
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.SnapshotListResponse resp = (CLDBProto.SnapshotListResponse)response;
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equals("terse");
        BitSet columns = this.getColumns();
        if (resp.getStatus() == 0) {
            for (CLDBProto.SnapshotInfo s : resp.getSnapshotsList()) {
                try {
                    CommandOutput.OutputHierarchy.OutputNode snapInfo = this.formatSnapshotInfo(s, terse, columns);
                    snapInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSizeUpdatesDesired", s.getNumSizeUpdatesDesired()));
                    snapInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSizeUpdates", s.getNumSizeUpdates()));
                    if (s.getUpdateSizeAt() != 0L) {
                        snapInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode("sizeUpdateRequestedAt", (Object)new Date(s.getUpdateSizeAt()).toString()));
                    }
                    if (s.getSizeUpdateTime() != 0L) {
                        snapInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode("sizeUpdatedAt", (Object)new Date(s.getSizeUpdateTime()).toString()));
                    }
                    if (s.getDeleteInProg() || s.getSnapshotInProgress()) {
                        if (s.getDeleteInProg()) {
                            snapInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapDeleteInProgress", (Object)"1"));
                        } else {
                            snapInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapCreateInProgress", (Object)"1"));
                        }
                    } else {
                        CommandOutput.OutputHierarchy.OutputNode volumeAcesNode = new CommandOutput.OutputHierarchy.OutputNode("volumeSnapshotAces");
                        Fileserver.GetVolumeAceRequest req = Fileserver.GetVolumeAceRequest.newBuilder().setCid(s.getRootContainerId()).build();
                        GetVolumeAceResponseMsgStatus msgStatus = new GetVolumeAceResponseMsgStatus();
                        int status = this.fsRpcUtils.SendRequestToCid(s.getRootContainerId(), false, Common.MapRProgramId.FileServerProgramId.getNumber(), Fileserver.FSProg.GetVolumeAceProc.getNumber(), (MessageLite)req, (GetMsgStatus)msgStatus);
                        if (status == 38 || status == 11) {
                            LOG.debug((Object)("GetVolumeAce RPC returned " + status));
                            out.addNode(snapInfo);
                            continue;
                        }
                        if (status != 0) {
                            LOG.error((Object)("Got null reply from RPC, status :" + status));
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "GetVolumeAce rpc failed"));
                            return;
                        }
                        Fileserver.GetVolumeAceResponse getvolAceResp = msgStatus.GetMsg();
                        if (getvolAceResp.getStatus() == 0) {
                            if (getvolAceResp.getVolumeAces().getAcesCount() == 0) {
                                LOG.debug((Object)"GetVolumeAce RPC returned 0 , using deafult.");
                                volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("readAce", (Object)"p"));
                                volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("writeAce", (Object)"p"));
                            } else {
                                for (Common.VolumeAceEntry volumeAceEntry : getvolAceResp.getVolumeAces().getAcesList()) {
                                    LOG.debug((Object)("GetVolumeAce: " + volumeAceEntry.getAccessType().name() + " : " + AceHelper.toInfix((String)volumeAceEntry.getExpr().toStringUtf8())));
                                    if (volumeAceEntry.getAccessType() == Common.VolumeActions.VOLUME_READ) {
                                        volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("readAce", (Object)AceHelper.toInfix((String)volumeAceEntry.getExpr().toStringUtf8())));
                                        continue;
                                    }
                                    if (volumeAceEntry.getAccessType() == Common.VolumeActions.VOLUME_WRITE) {
                                        volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("writeAce", (Object)AceHelper.toInfix((String)volumeAceEntry.getExpr().toStringUtf8())));
                                        continue;
                                    }
                                    Assert.assertNotNull(null);
                                }
                            }
                        } else if (getvolAceResp.getStatus() == 2) {
                            LOG.debug((Object)"GetVolumeAce RPC returned ENOENT , using deafult.");
                            volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("readAce", (Object)"p"));
                            volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("writeAce", (Object)"p"));
                        }
                        snapInfo.addChild(volumeAcesNode);
                    }
                    out.addNode(snapInfo);
                }
                catch (CLIProcessingException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception while trying to list snapshots", (Throwable)e);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Exception while trying to list snapshots"));
                }
            }
            if (resp.hasTotal()) {
                out.setTotal(resp.getTotal());
            }
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
        }
    }

    public CLDBProto.SnapshotListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.SnapshotListRequest req = (CLDBProto.SnapshotListRequest)request;
        byte[] replyData = null;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotListProc.getNumber(), (MessageLite)req, CLDBProto.SnapshotListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotListProc.getNumber(), (MessageLite)req, CLDBProto.SnapshotListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            return this.getSnapshotListResponse(replyData);
        }
        LOG.error((Object)"RPC Request to list Nodes failed. No data returned");
        return null;
    }

    CommandOutput snapshotCreate() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> rwVolumeNames = new ArrayList<String>();
        String name = this.getParamTextValue("volume", 0);
        if (name.contains(",")) {
            rwVolumeNames.addAll(Arrays.asList(name.split(",")));
        } else {
            rwVolumeNames.add(name);
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        for (String rwVolumeName : rwVolumeNames) {
            int status;
            String snapshotName = this.getParamTextValue(SNAPSHOT_PARAM_NAME, 0);
            CLDBProto.VolumeInfo vInfo = this.volumeLookup(rwVolumeName);
            if (vInfo == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Snapshot Create: Could not find information about Volume: '" + rwVolumeName + "'. " + Errno.toString((int)2)));
                LOG.error((Object)("SnapshotCreate: Could not find Volume Info of " + rwVolumeName));
                continue;
            }
            if (!VolumeUtils.isValidSnapshotNameLength((String)snapshotName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Snapshot Name " + snapshotName + ", Exceeds allowed length of " + VolumeUtils.validSnapshotNameLength() + " characters").setField(SNAPSHOT_PARAM_NAME));
                return output;
            }
            if (!VolumeUtils.isValidSnapshotName((String)snapshotName)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "SnapshotCreate: Invalid Snapshot Name.  Allowed characters " + VolumeUtils.getValidName()).setField(SNAPSHOT_PARAM_NAME));
                output.setOutput(out);
                continue;
            }
            CLDBProto.ContainerInfo rootCInfo = vInfo.getRootContainer();
            if (!rootCInfo.hasMServer()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(61, "Snapshot Create: Could not find master server for root of Volume: " + rwVolumeName + Errno.toString((int)61)));
                LOG.error((Object)("SnapshotCreate: Could not find master server for Volume Info of " + rwVolumeName));
                continue;
            }
            long expirationTime = 0L;
            if (this.isParamPresent(SNAPSHOT_EXPIRY_PARAM_NAME)) {
                Matcher m = p.matcher(this.getParamTextValue(SNAPSHOT_EXPIRY_PARAM_NAME, 0));
                ArrayList<String> frequencyAndTimeUnit = new ArrayList<String>();
                while (m.find()) {
                    frequencyAndTimeUnit.add(m.group().trim());
                }
                if (frequencyAndTimeUnit.size() == 2) {
                    try {
                        CLDBProto.PolicyRule.RetainPeriod.Builder retainBuilder = CLDBProto.PolicyRule.RetainPeriod.newBuilder();
                        retainBuilder.setNumberOfUnits(Integer.valueOf((String)frequencyAndTimeUnit.get(0)).intValue());
                        retainBuilder.setTimeUnitsEnum(CLDBProto.RetainTimeUnitsEnum.valueOf((String)((String)frequencyAndTimeUnit.get(1))));
                        expirationTime = SnapshotCommands.getSnapshotEndTime(retainBuilder.build());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (expirationTime == 0L) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Snapshot Create: Invalid format for -retain flag."));
                    output.setOutput(out);
                    return output;
                }
            }
            if ((status = fs.createSnapshot(cluster, rwVolumeName, vInfo.getVolProperties().getVolumeId(), vInfo.getRootContainer().getContainerId(), snapshotName, false, expirationTime, this.getUserLoginId())) == 115) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshot Create: Operation failed, snapshot can't be created or removed when mirroring is in progress for the volume"));
                continue;
            }
            if (status == 0) continue;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Snapshot Create: Operation failed, " + Errno.toString((int)status)));
        }
        return output;
    }

    CommandOutput.OutputHierarchy.OutputNode formatSnapshotInfo(CLDBProto.SnapshotInfo v, boolean terse, BitSet columns) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode snapshotInfo = new CommandOutput.OutputHierarchy.OutputNode();
        if (columns.get(CLDBProto.SnapshotInfoFields.ownerName.getNumber())) {
            int ownerId = v.getOwnerId();
            String ownerName = null;
            try {
                ownerName = this.uInfo.getUsername(ownerId);
            }
            catch (SecurityException se) {
                ownerName = "Uid " + ownerId;
            }
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.ownerName).getName(terse), (Object)ownerName));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.ownerType.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.ownerType).getName(terse), (Object)"1"));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.rwVolumeId.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.rwVolumeId).getName(terse), (Object)String.valueOf(v.getRwVolumeId())));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.rwVolumeName.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.rwVolumeName).getName(terse), (Object)v.getRwVolumeName()));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.volumePath.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.volumePath).getName(terse), (Object)v.getMountDir()));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.snapshotId.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.snapshotId).getName(terse), (Object)String.valueOf(v.getSnapshotId())));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.snapshotName.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.snapshotName).getName(terse), (Object)v.getSnapshotName()));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.creationTime.getNumber())) {
            String createTime = terse ? String.valueOf(v.getCreateTime()) : new Date(v.getCreateTime()).toString();
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.creationTime).getName(terse), (Object)createTime));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.expiryTime.getNumber())) {
            String expiryTime;
            String string = expiryTime = terse ? String.valueOf(v.getDeleteTime()) : new Date(v.getDeleteTime()).toString();
            if (terse || v.getDeleteTime() != 0L) {
                snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.expiryTime).getName(terse), (Object)expiryTime));
            }
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.cumulativeReclaimSizeMB.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.cumulativeReclaimSizeMB).getName(terse), (Object)String.valueOf(v.getSnapshotCumulativeReclaimSizeMB())));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.ownedSize.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.ownedSize).getName(terse), (Object)String.valueOf(v.getSnapshotOwnedSizeMB())));
        }
        if (columns.get(CLDBProto.SnapshotInfoFields.sharedSize.getNumber())) {
            snapshotInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(snapshotFieldTable.get(CLDBProto.SnapshotInfoFields.sharedSize).getName(terse), (Object)String.valueOf(v.getSnapshotSharedSizeMB())));
        }
        if (snapshotInfo.getChildren().isEmpty()) {
            throw new CLIProcessingException("No columns found in output");
        }
        return snapshotInfo;
    }

    private CLDBProto.VolumeInfo volumeLookup(String volumeName) throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse resp = null;
        byte[] data = null;
        CLDBProto.VolumeLookupRequest req = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                LOG.error((Object)("VolumeLookup RPC to CLDB failed for volume " + volumeName));
                return null;
            }
            resp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                return resp.getVolInfo();
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception during VolumeLookup RPC to CLDB " + e.getLocalizedMessage()));
            return null;
        }
        return null;
    }

    private static long getSnapshotEndTime(CLDBProto.PolicyRule.RetainPeriod rPeriod) {
        GregorianCalendar cl = new GregorianCalendar();
        int numberOfUnits = rPeriod.getNumberOfUnits();
        if (numberOfUnits == 0) {
            return 0L;
        }
        CLDBProto.RetainTimeUnitsEnum timeUnit = rPeriod.getTimeUnitsEnum();
        switch (timeUnit) {
            case h: {
                ((Calendar)cl).add(11, numberOfUnits);
                break;
            }
            case d: {
                ((Calendar)cl).add(5, numberOfUnits);
                break;
            }
            case w: {
                ((Calendar)cl).add(4, numberOfUnits);
                break;
            }
            case m: {
                ((Calendar)cl).add(2, numberOfUnits);
                break;
            }
            case y: {
                ((Calendar)cl).add(1, numberOfUnits);
                break;
            }
            case mi: {
                ((Calendar)cl).add(12, numberOfUnits);
                break;
            }
            default: {
                return 0L;
            }
        }
        return cl.getTimeInMillis();
    }

    static {
        CLDBProto.SnapshotInfoFields[] values = CLDBProto.SnapshotInfoFields.values();
        int max = 0;
        for (CLDBProto.SnapshotInfoFields value : values) {
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_SNAPFIELDINFO = max;
        snapshotCommandsArray = new CLICommand[]{snapshotCreateCommand, snapshotRemoveCommand, snapshotPreserveCommand, snapshotListCommand, sizeUpdateCommand};
        snapshotCommands = new CLICommand("snapshot", "snapshot", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, snapshotCommandsArray).setShortUsage("snapshot [create|list|remove|preserve]");
    }
}

