/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.fsrpcutils.FSRpcUtils;
import com.mapr.baseutils.fsrpcutils.GetMsgStatus;
import com.mapr.baseutils.utils.GetStringsForAuditOps;
import com.mapr.cli.FidCommands;
import com.mapr.cli.GetattrResponseMsgStatus;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.proto.dialhome.MetricsProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class DumpCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String CLDB_HOSTIP_PARAM = "hostip";
    public static final String CHANGE_LOG_PARAM_NAME = "loglevel";
    public static final String CHANGE_LOG_CLASSNAME_PARAM_NAME = "classname";
    private static final String DUMP_CONTAINER_ID_PARAM_NAME = "ids";
    private static final String MEMORY_TRIM_PARAM_NAME = "trim";
    private static final String MEMORY_LEAK_PARAM_NAME = "leakmemory";
    private static final String DUMP_CONTAINER_TYPE_PARAM_NAME = "type";
    private static final String DUMP_VOLUME_NAME_PARAM_NAME = "volumename";
    private static final String DUMP_REPLICATION_MANAGER_QUEUE_PARAM_NAME = "queue";
    private static final String DUMP_FILESERVER_IP_PARAM_NAME = "fileserverip";
    private static final String DUMP_FILESERVER_PORT_PARAM_NAME = "fileserverport";
    public static final String ENODES_PARAM = "enodes";
    public static final String DUMP_PARAMS = "params";
    private static final String RBALINFO_STATS_OPT = "stats";
    private static final String RBALINFO_VOLUME_OPT = "volumeinfo";
    private static final String RBALINFO_NAMECNTRS_OPT = "namecntrinfo";
    public static final String MULTI_ARG_SEP = ",";
    private static final Logger LOG = Logger.getLogger(DumpCommands.class);
    private static FSRpcUtils fsRpcUtils;
    private String clusterName = null;
    static String dumpFileServerWorkInfoUsage;
    static String dumpContainerInfoUsage;
    static String dumpContainerGroupInfoUsage;
    static String dumpReplicationManagerQueueInfoUsage;
    static String dumpVolumeInfoUsage;
    static String dumpVolumeNodesUsage;
    static String dumpReplicationManagerUsage;
    static String dumpRereplicationUsage;
    static String dumpBalancerUsage;
    static String dumpSpRefillInfoUsage;
    static String dumpRoleBalancerUsage;
    static String dumpBalancerMetricsUsage;
    static String dumpRoleBalancerMetricsUsage;
    static String dumpRereplicationMetricsUsage;
    static String cldbNodesUsage;
    static String containersType;
    static String dumpContainersUsage;
    static String dumpCLDBMemoryInfoUsage;
    static String dumpAssignVouchersUsage;
    static String dumpActiveWritersUsage;
    static String dumpCLDBMetaInfoUsage;
    static final String[] mallocFileds;
    public static Map<String, BaseInputParameter> baseParams;
    static final CLICommand cldbStateCommand;
    static final CLICommand cldbNodesCommand;
    static final CLICommand dumpContainersCommand;
    static final CLICommand dumpContainerInfo;
    static final CLICommand dumpContainerGroupInfo;
    static final CLICommand dumpReplicationManagerInfo;
    static final CLICommand dumpReplicationManagerQueueInfo;
    static final CLICommand dumpRereplicationInfo;
    static final CLICommand dumpBalancerInfo;
    static final CLICommand dumpSpRefillInfo;
    static final CLICommand dumpBalancerMetrics;
    static final CLICommand dumpRoleBalancerMetrics;
    static final CLICommand dumpRereplicationMetrics;
    static final CLICommand dumpAssignVouchers;
    static final CLICommand dumpActiveWriters;
    static final CLICommand dumpFileServerWorkInfo;
    static final CLICommand dumpVolumeInfo;
    static final CLICommand dumpVolumeNodes;
    static final CLICommand dumpZKInfo;
    static final CLICommand supportDumpTrigger;
    static final CLICommand dumpCLDBMetaInfo;
    static final CLICommand dumpCLDBMemoryInfo;
    static final CLICommand dumpRoleBalancerInfo;
    static Map<String, BaseInputParameter> dumpSnapshotSizeUpadteInfoParams;
    static String dumpSnapshotSizeUpdateUsage;
    static final CLICommand dumpSnapshotSizeUpdateInfo;
    private static String SUPPORT_DUMP_ACTION;

    public DumpCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void init() throws CLIProcessingException {
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Failed to initalize RPC");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in Rpc.initialize " + e));
            throw new CLIProcessingException("Exception in Rpc.initialize ", (Throwable)e);
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (this.cliCommand.getCommandName().equalsIgnoreCase("zkinfo")) {
            return this.dumpZKInfo();
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("supportdump")) {
            return this.supportDumpTrigger();
        }
        this.init();
        if (!super.validateInput()) {
            return this.output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("containerinfo")) {
            try {
                return this.dumpContainerInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("ecginfo")) {
            try {
                return this.dumpContainerGroupInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("containers")) {
            try {
                return this.dumpContainers();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("volumenodes")) {
            try {
                return this.dumpVolumeNodes();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(RBALINFO_VOLUME_OPT)) {
            try {
                return this.dumpVolumeInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("replicationmanagerinfo")) {
            try {
                return this.dumpReplicationManagerInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rereplicationinfo")) {
            try {
                return this.dumpRereplicationInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("replicationmanagerqueueinfo")) {
            try {
                return this.dumpReplicationManagerQueueInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("balancerinfo")) {
            try {
                return this.dumpBalancerInfo(CLDBProto.DumpInfoRequest.DumpOp.BALANCER_SP_OP);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("sprefillinfo")) {
            try {
                return this.dumpBalancerInfo(CLDBProto.DumpInfoRequest.DumpOp.SP_REFILL_INFO_OP);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Exception while requesting SP refill info", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rolebalancerinfo")) {
            try {
                return this.dumpRoleBalancerInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("balancermetrics")) {
            try {
                return this.dumpBalancerMetrics();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rolebalancermetrics")) {
            try {
                return this.dumpRoleBalancerMetrics();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("rereplicationmetrics")) {
            try {
                return this.dumpRereplicationMetrics();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("assignvouchers")) {
            try {
                return this.dumpAssignVouchers();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("activewriters")) {
            try {
                return this.dumpActiveWriters();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("fileserverworkinfo")) {
            try {
                return this.dumpFileServerWorkInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("cldbnodes")) {
            try {
                return this.dumpKvStoreCidInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("cldbmemoryinfo")) {
            try {
                return this.dumpCLDBMemoryInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("snapshotsizeupdateinfo")) {
            try {
                return this.getSnapshotSizeUpdateInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("cldbmetainfo")) {
            try {
                return this.dumpCLDBMetaInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("cldbstate")) {
            try {
                return this.dumpCldbState();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("Dump command failed".getBytes());
    }

    private CommandOutput dumpCLDBMetaInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        Common.FidMsg fid = Common.FidMsg.newBuilder().setCid(1).setCinum(16).setUniq(2).build();
        this.clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        fsRpcUtils = new FSRpcUtils(this.clusterName, this.getUserCredentials(), 5, Security.ServerKeyType.ServerKey, 0);
        this.getDumpFromFid(fid, null, out);
        output.setOutput(out);
        return output;
    }

    private CommandOutput getDumpFromFid(Common.FidMsg fid, String dirName, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Fileserver.GetattrResponse resp;
        FidCommands.KVFormatType ftype = FidCommands.KVFormatType.INVALID;
        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).build();
        try {
            GetattrResponseMsgStatus msgStatus = new GetattrResponseMsgStatus();
            int status = fsRpcUtils.SendRequestToCid(fid.getCid(), false, Common.MapRProgramId.FileServerProgramId.getNumber(), Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req, (GetMsgStatus)msgStatus);
            resp = msgStatus.GetMsg();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString((int)resp.getStatus())));
                return this.output;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing stat command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
            return this.output;
        }
        Common.FileType itype = resp.getAttr().getType();
        if (itype == Common.FileType.FTDirectory) {
            ftype = FidCommands.KVFormatType.DIR;
        }
        if (ftype == FidCommands.KVFormatType.DIR) {
            this.dumpDir(fid, out);
        } else if (itype == Common.FileType.FTKvstore) {
            CommandOutput.OutputHierarchy.OutputNode dout = this.dumpKvStoreInfo(resp, dirName, fid);
            out.addNode(dout);
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot dump files of type " + itype));
        }
        return this.output;
    }

    private String getDirName(String dirPath) {
        int l = dirPath.lastIndexOf(47);
        return dirPath.substring(l + 1);
    }

    private void dumpDir(Common.FidMsg fid, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MapRFileStatus[] dirents;
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            dirents = fs.scanDir(this.clusterName, "/.mapr::fid::" + FidCommands.printableFid(fid));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanDir failed"));
            return;
        }
        if (dirents == null) {
            return;
        }
        for (int i = 0; i < dirents.length; ++i) {
            Common.FidMsg dirFid = Common.FidMsg.newBuilder().setCid(dirents[i].getCid()).setCinum(dirents[i].getCinum()).setUniq(dirents[i].getUniq()).build();
            String dirName = this.getDirName(dirents[i].getPath().toString());
            this.getDumpFromFid(dirFid, dirName, out);
        }
    }

    CommandOutput.OutputHierarchy.OutputNode dumpKvStoreInfo(Fileserver.GetattrResponse resp, String dirName, Common.FidMsg fid) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("name", (Object)dirName));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DUMP_CONTAINER_TYPE_PARAM_NAME, (Object)resp.getAttr().getType(), this.version.intValue()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("parent fid", (Object)FidCommands.printableFid(resp.getAttr().getParent())));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)FidCommands.printableFid(fid)));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("size", resp.getAttr().getSize()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nblocks", resp.getAttr().getNblocks()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("lblocks", resp.getAttr().getLBlocks()));
        String cs = "off";
        if (resp.getAttr().getCanCompress()) {
            cs = FidCommands.getCompressionType(Common.FileCompressionType.valueOf((int)resp.getAttr().getCompressorType()));
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("compression", (Object)cs));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteFlags", (Object)resp.getAttr().getDeleteFlags()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("atime", resp.getAttr().getAtime().getSec()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mtime", resp.getAttr().getMtime().getSec()));
        int mode = resp.getAttr().getMode();
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mode", (Object)Integer.toOctalString(mode)));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("uid", resp.getAttr().getUid()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("gid", resp.getAttr().getGid()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nlink", resp.getAttr().getNlink()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("xattrInum", resp.getAttr().getXattrInum()));
        if (resp.getAttr().hasVersion()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", resp.getAttr().getVersion()));
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("networkencryption", (Object)resp.getAttr().getWireSecurityEnabled()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("diskflush", (Object)resp.getAttr().getDiskFlushEnabled()));
        if (resp.getAttr().hasXattrs()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("xattrs", (Object)FidCommands.dumpInlineXAttrs(resp.getAttr().getXattrs())));
        }
        if (resp.getAttr().hasNBtreeLevels()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nlevels", resp.getAttr().getNBtreeLevels()));
        }
        return dout;
    }

    private CommandOutput dumpFileServerWorkInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fileServerIpString = this.getParamTextValue(DUMP_FILESERVER_IP_PARAM_NAME, 0);
        if (fileServerIpString.equalsIgnoreCase("localhost") || fileServerIpString.equalsIgnoreCase("127.0.0.1")) {
            fileServerIpString = "127.0.0.1";
        } else {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(fileServerIpString));
            if (ips.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not get valid IP address out of provided name: " + fileServerIpString));
                return output;
            }
            fileServerIpString = ips.get(0);
        }
        int fileServerIp = Util.ipToInt((String)fileServerIpString);
        int fileServerPort = this.getParamIntValue(DUMP_FILESERVER_PORT_PARAM_NAME, 0);
        Common.IPAddress fileServer = Common.IPAddress.newBuilder().setHost(fileServerIp).setPort(fileServerPort).build();
        LOG.info((Object)"dumpFileServerWorkInfo : Dumping FileServerWorkInfo");
        boolean hasMore = false;
        int lastContainerId = 0;
        String lastSpId = "";
        do {
            LOG.info((Object)"dumpFileServerWorkInfo : Dumping fileServer Work Units");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.FILESERVER_WORK_QUEUE_OP).setFileServer(fileServer).setFileServerLastContainer(lastContainerId).setCreds(this.getUserCredentials()).setFileServerLastSpId(lastSpId).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump fileserverworkinfo RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump fileserverworkinfo failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.FileServerPendingWork cmd : resp.getFileServerCommandsList()) {
                    out.addNode(this.formatFileServerCommand(cmd));
                    lastContainerId = cmd.getCmd().getContainerId();
                    lastSpId = cmd.getSpId();
                }
                hasMore = resp.getFileServerHasMore();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump fileServerWorkInfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpReplicationManagerQueueInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int queueNumber = this.getParamIntValue(DUMP_REPLICATION_MANAGER_QUEUE_PARAM_NAME, 0);
        if (queueNumber < 0 || queueNumber > 5) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid queue number " + queueNumber + ". Valid values are 0 to 5"));
            output.setOutput(out);
            return output;
        }
        LOG.info((Object)"dumpReplicationManagerQueueInfo : Dumping ReplicationManagerQueueInfo");
        boolean hasMore = false;
        int lastContainerId = 0;
        do {
            LOG.info((Object)"dumpReplicationManagerQueueInfo: Request ReplicationmanagerQueue info");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.REPLICATION_MANAGER_QUEUE_OP).setReplicationQueue(queueNumber).setReplicationLastContainer(lastContainerId).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump replicationmanagerqueueinfo rpc failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump replicationmanagerqueueinfo  failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ContainerInfo id : resp.getReplicationContainersList()) {
                    out.addNode(this.formatContainerInfo(id, null));
                    lastContainerId = id.getContainerId();
                }
                hasMore = resp.getReplicationHasMore();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump replicationmanagerqueueinfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpReplicationManagerInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
        try {
            CLDBProto.VolumeInfo volInfo = this.lookupVolumeInfo(volumeName);
            if (volInfo == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName));
                output.setOutput(out);
                return output;
            }
            out.addNode(this.formatVolumeInfo(volInfo));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName + ", Error: " + e.getLocalizedMessage()));
            output.setOutput(out);
            return output;
        }
        LOG.info((Object)"dumpReplicationManagerInfo : Dumping ReplicationManagerInfo");
        boolean hasMore = false;
        int lastContainerId = 0;
        do {
            LOG.info((Object)"dumpReplicationManagerInfo: Request Replicationmanager info");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.REPLICATION_MANAGER_OP).setReplicationVolumeName(volumeName).setReplicationLastContainer(lastContainerId).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump replicationmanagerinfo rpc failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump replicationmanagerinfo volume containersmap failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ContainerInfo id : resp.getReplicationContainersList()) {
                    out.addNode(this.formatContainerInfo(id, null));
                    lastContainerId = id.getContainerId();
                }
                hasMore = resp.getReplicationHasMore();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump replicationmanager failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpRereplicationInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpRereplicationInfo : Dumping Rereplication info");
        boolean hasMore = false;
        int lastCid = 0;
        int ncontainers = 0;
        do {
            LOG.info((Object)"dumpReplicationInfo : Dumping Active Container Copy Creates");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.ACTIVE_REREPL_OP).setLastCopyingCid(lastCid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rereplicationinfo  RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rereplication failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ActiveContainerCopyCreate ac : resp.getActiveCopyCreatesList()) {
                    out.addNode(this.formatActiveCopyCreate(ac));
                    lastCid = ac.getContainerId();
                    ++ncontainers;
                }
                hasMore = resp.getMoreActiveRoleSwitches();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump rereplication failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        if (ncontainers == 0) {
            return new TextCommandOutput("No active rereplications".getBytes());
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpRereplicationMetrics() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpRereplicationMetrics : Dumping Rereplication metrics");
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.METRICS_REREPLICATION_OP).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rereplicationmetrics RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rereplicationmetrics failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            out.addNode(this.formatRereplicationMetrics(resp.getRereplicationMetrics()));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump rereplicationInfo failed"));
            output.setOutput(out);
            return output;
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpAssignVouchers() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.debug((Object)"dumpAssignVouchers : Dumping assign vouchers");
        int nvouchers = 0;
        String volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.ASSIGN_VOUCHER_DUMP_OP).setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump assignvouchers RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump assignvouchers failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            for (CLDBProto.ActiveAssignVoucher av : resp.getVouchersList()) {
                out.addNode(this.formatActiveAssignVoucher(av));
                ++nvouchers;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump assignvouchers failed"));
            output.setOutput(out);
            return output;
        }
        if (nvouchers == 0) {
            return new TextCommandOutput("No active assign vouchers".getBytes());
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpActiveWriters() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.debug((Object)"dumpActiveWriters : Dumping active writers");
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.ACTIVE_WRITERS_DUMP_OP).setCreds(this.getUserCredentials()).build();
        byte[] replyData = null;
        int numWriters = 0;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump activewriters RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump activewriters failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            for (CLDBProto.ActiveWriter w : resp.getWritersList()) {
                out.addNode(this.formatActiveWriter(w));
                ++numWriters;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump activewriters failed"));
            output.setOutput(out);
            return output;
        }
        if (numWriters == 0) {
            return new TextCommandOutput("No active writers".getBytes());
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpBalancerInfo(CLDBProto.DumpInfoRequest.DumpOp operation) throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpBalancerInfo : Dumping Balancer info");
        boolean hasMore = false;
        String lastSpid = null;
        do {
            LOG.info((Object)"dumpBalancerInfo : Dumping Active Storage Pools");
            CLDBProto.DumpInfoRequest.Builder reqBuilder = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(operation).setCreds(this.getUserCredentials());
            if (lastSpid != null) {
                reqBuilder.setLastSpId(lastSpid);
            }
            CLDBProto.DumpInfoRequest req = reqBuilder.build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump balancerinfo RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump balancerinfo failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ActiveStoragePool sp : resp.getActiveSpsList()) {
                    out.addNode(this.formatActiveSp(sp));
                    lastSpid = sp.getSpid();
                }
                hasMore = resp.getMoreActiveSps();
                if (hasMore || !resp.hasAvgBinIndex()) continue;
                CommandOutput.OutputHierarchy.OutputNode io = new CommandOutput.OutputHierarchy.OutputNode();
                io.addChild(new CommandOutput.OutputHierarchy.OutputNode("Average Bin Index", resp.getAvgBinIndex()));
                io.addChild(new CommandOutput.OutputHierarchy.OutputNode("Average Bin Bounds", (Object)resp.getAvgBinBounds()));
                out.addNode(io);
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump balancerInfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        hasMore = false;
        int lastCid = 0;
        int ncontainers = 0;
        do {
            LOG.info((Object)"dumpBalancerInfo : Dumping Active Container Moves");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.BALANCER_MOVE_OP).setLastMovingCid(lastCid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump balancerinfo RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump balancerinfo failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ActiveContainerMove am : resp.getActiveMovesList()) {
                    out.addNode(this.formatActiveMove(am));
                    lastCid = am.getContainerId();
                    ++ncontainers;
                }
                hasMore = resp.getMoreActiveMoves();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)("dump balancerInfo failed" + e + e.getStackTrace()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump balancerInfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        if (ncontainers == 0) {
            out.addMessage("No active container moves");
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpBalancerMetrics() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpBalancerMetrics : Dumping Balancer metrics");
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.METRICS_DISKBALANCER_OP).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump balancermetrics RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump balancermetrics failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            out.addNode(this.formatDiskBalancerMetrics(resp.getDiskBalancerMetrics()));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump balancerInfo failed"));
            output.setOutput(out);
            return output;
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpCLDBMemoryInfo() throws CLIProcessingException {
        CLDBProto.DumpInfoResponse resp;
        byte[] replyData;
        boolean doTrim;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.DumpInfoRequest.Builder dumpinfoReqBuilder = CLDBProto.DumpInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.NATIVE_MEMORY_INFO_OP);
        boolean bl = doTrim = this.isParamPresent(MEMORY_TRIM_PARAM_NAME) ? this.getParamBooleanValue(MEMORY_TRIM_PARAM_NAME, 0) : false;
        if (doTrim) {
            dumpinfoReqBuilder.setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.NATIVE_MEMORY_TRIM_OP);
        }
        boolean doLeak = false;
        if (this.isParamPresent(MEMORY_LEAK_PARAM_NAME)) {
            doLeak = this.getParamBooleanValue(MEMORY_LEAK_PARAM_NAME, 0);
            if (doLeak) {
                dumpinfoReqBuilder.setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.NATIVE_MEMORY_LEAK_OP);
            } else {
                CommandOutput.OutputHierarchy.OutputNode cout = new CommandOutput.OutputHierarchy.OutputNode("success");
                out.addNode(cout);
                return output;
            }
        }
        CLDBProto.DumpInfoRequest req = dumpinfoReqBuilder.build();
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump cldbmemoryinfo RPC failed"));
                return output;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "RPC Error"));
            return output;
        }
        try {
            resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump cldbmemoryinfo failed with status : " + resp.getStatus()));
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while trying to parse DumpInfoResponse MemoryInfo  ", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Error Parsing NativeMemoryInfo Response"));
            return output;
        }
        if (doLeak) {
            if (resp.getStatus() == 0) {
                CommandOutput.OutputHierarchy.OutputNode cout = new CommandOutput.OutputHierarchy.OutputNode("success");
                out.addNode(cout);
            } else {
                CommandOutput.OutputHierarchy.OutputNode cout = new CommandOutput.OutputHierarchy.OutputNode("failure");
                out.addNode(cout);
            }
            return output;
        }
        CLDBProto.NativeMemoryInfo nmi = resp.getMemoryInfo();
        CommandOutput.OutputHierarchy.OutputNode cout = new CommandOutput.OutputHierarchy.OutputNode("memoryInfo");
        out.addNode(cout);
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumContainersInCache", nmi.getNumContainers()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("CachedContainer_Bytes", nmi.getCachedConBytes()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumFSWorkStores", nmi.getNumFSWorkStores()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("FSWorkStore_Bytes", nmi.getNumFSWorkStoreBytes()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumFSCommands", nmi.getNumFSCommands()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("FSCmdHolder_Bytes", nmi.getNumFSCmdHolderBytes()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numFSCmdBytes", nmi.getNumFSCmdBytes()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumContainerWorks", nmi.getNumContainerWorks()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ContainerWork_Bytes", nmi.getConWorkBytes()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ConLocDataBytes", nmi.getConLocDataBytes()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ConSizeDataBytes", nmi.getConSizeDataBytes()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ConAllocLocDataBytes", nmi.getConAllocLocDataBytes()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ConAllocSizeDataBytes", nmi.getConAllocSizeDataBytes()));
        cout.addChild(new CommandOutput.OutputHierarchy.OutputNode("TotalAllocBytes", nmi.getTotalAllocBytes()));
        if (nmi.getMallocInfoCount() != 0) {
            int i = 0;
            CommandOutput.OutputHierarchy.OutputNode mout = new CommandOutput.OutputHierarchy.OutputNode("MallocInfo");
            cout.addNode(mout);
            for (Long val : nmi.getMallocInfoList()) {
                String name = i < mallocFileds.length ? mallocFileds[i] : new String("MallocInfo" + i);
                mout.addChild(new CommandOutput.OutputHierarchy.OutputNode(name, (Object)val));
                ++i;
            }
        }
        CommandOutput.OutputHierarchy.OutputNode rsout = new CommandOutput.OutputHierarchy.OutputNode("RpcSlabs");
        cout.addNode(rsout);
        for (Common.SlabInfo slab : nmi.getSlabsList()) {
            CommandOutput.OutputHierarchy.OutputNode sout = new CommandOutput.OutputHierarchy.OutputNode(slab.getObjName());
            rsout.addNode(sout);
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("objName", (Object)slab.getObjName()));
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("activeCount", slab.getActiveCount()));
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("availCount", slab.getAvailCount()));
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("unitSize", slab.getObjSize()));
        }
        return output;
    }

    private CommandOutput dumpRoleBalancerInfo() throws CLIProcessingException {
        if (this.isParamPresent(RBALINFO_VOLUME_OPT) || this.isParamPresent(RBALINFO_NAMECNTRS_OPT)) {
            return this.getRBalBalancingInfo();
        }
        return this.getRoleBalancerStats();
    }

    CommandOutput getRoleBalancerStats() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        LOG.info((Object)"dumpRoleBalancerInfo : Dumping RoleBalancer info");
        boolean hasMore = false;
        int lastCid = 0;
        int ncontainers = 0;
        do {
            LOG.info((Object)"dumpRoleBalancerInfo : Dumping Active Container Role switches");
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.BALANCER_ROLESWITCH_OP).setLastRoleSwitchCid(lastCid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rolebalancerinfo RPC failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rolebalancerinfo failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                for (CLDBProto.ActiveContainerRoleSwitch am : resp.getActiveRoleSwitchesList()) {
                    out.addNode(this.formatActiveRoleSwitch(am));
                    lastCid = am.getContainerId();
                    ++ncontainers;
                }
                hasMore = resp.getMoreActiveRoleSwitches();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump rolebalancerInfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        if (ncontainers == 0) {
            return new TextCommandOutput("No active role switches".getBytes());
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput getRBalBalancingInfo() throws CLIProcessingException {
        CLDBProto.DumpInfoResponse resp;
        byte[] replyData;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.DumpInfoRequest.Builder dumpinfoReqBuilder = CLDBProto.DumpInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.RBAL_BALANCING_INFO_OP);
        CLDBProto.RBalBalancingInfoRequest.Builder balancingInfoReqBuilder = CLDBProto.RBalBalancingInfoRequest.newBuilder();
        String volumeName = null;
        if (this.isParamPresent(RBALINFO_VOLUME_OPT)) {
            if (!this.isParamPresent(DUMP_VOLUME_NAME_PARAM_NAME)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Volume Name Opt. Check usage info"));
                return output;
            }
            volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
            if (volumeName == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Volume Name. Check usage info"));
                return output;
            }
            dumpinfoReqBuilder.setVolumeName(volumeName);
            balancingInfoReqBuilder.setNeedVolumeInfo(true);
        }
        if (this.isParamPresent(RBALINFO_NAMECNTRS_OPT)) {
            balancingInfoReqBuilder.setNeedNameCntrsInfo(true);
        }
        dumpinfoReqBuilder.setRbalBalancingInfoRequest(balancingInfoReqBuilder.build());
        CLDBProto.DumpInfoRequest req = dumpinfoReqBuilder.build();
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rolebalancerinfo RPC failed"));
                return output;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "RPC Error"));
            return output;
        }
        try {
            resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rolebalancerinfo failed with status : " + resp.getStatus()));
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while trying to parse container info", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Error Parsing Balacing Info Response"));
            return output;
        }
        if (!resp.hasBalancingInfo()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Missing Balancing Info in the response"));
            return output;
        }
        CLDBProto.RBalBalancingInfo balancingInfo = resp.getBalancingInfo();
        if (balancingInfo.hasVolumeBalancingInfo()) {
            CLDBProto.BalancingInfo volumeBalancingInfo = balancingInfo.getVolumeBalancingInfo();
            if (volumeBalancingInfo.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(volumeBalancingInfo.getStatus(), "Error Obtaining Volume Balancing Info"));
            } else {
                CommandOutput.OutputHierarchy.OutputNode volInfoOutputNode = new CommandOutput.OutputHierarchy.OutputNode();
                volInfoOutputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Volume", (Object)volumeName));
                volInfoOutputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Assign Cache Containers Count", volumeBalancingInfo.getAssignCacheCntrsCount()));
                volInfoOutputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Assign Cache Containers Size", volumeBalancingInfo.getAssignCacheCntrsSize()));
                volInfoOutputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Zero Size Containers Count", volumeBalancingInfo.getZeroSizeCntrsCount()));
                for (CLDBProto.RBalSpBalancingInfo spInfo : volumeBalancingInfo.getSpBalancingInfoList()) {
                    volInfoOutputNode.addChild(this.getFormattedSpInfo(spInfo));
                }
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("VolumeBalancingInfo", (Object)volInfoOutputNode));
            }
        }
        if (balancingInfo.hasNameCntrsBalancingInfo()) {
            CLDBProto.BalancingInfo nameCntrsBalancingInfo = balancingInfo.getNameCntrsBalancingInfo();
            if (nameCntrsBalancingInfo.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(nameCntrsBalancingInfo.getStatus(), "Error Obtaining NameCntrs Balancing Info"));
            } else {
                CommandOutput.OutputHierarchy.OutputNode nameCntrsInfoOutputNode = new CommandOutput.OutputHierarchy.OutputNode();
                for (CLDBProto.RBalSpBalancingInfo spInfo : nameCntrsBalancingInfo.getSpBalancingInfoList()) {
                    nameCntrsInfoOutputNode.addChild(this.getFormattedSpInfo(spInfo));
                }
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("NameCntrsBalancingInfo", (Object)nameCntrsInfoOutputNode));
            }
        }
        return output;
    }

    private CommandOutput getSnapshotSizeUpdateInfo() throws CLIProcessingException {
        CLDBProto.DumpInfoResponse resp;
        byte[] replyData;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.DumpInfoRequest dumpinfoReq = CLDBProto.DumpInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.SNAPSHOT_SIZE_UPDATE_INFO_OP).build();
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)dumpinfoReq, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)dumpinfoReq, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump snapshot size update info RPC failed"));
                return output;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "RPC Error"));
            return output;
        }
        try {
            resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump snapshotsizeupdateinfo failed with status : " + resp.getStatus()));
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while trying to parse container info", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Error Parsing Balacing Info Response"));
            return output;
        }
        if (!resp.hasSnapshotSizeUpdateInfo()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Missing Snapshot Size Update Info in the response"));
            return output;
        }
        CLDBProto.SnapshotSizeUpdateInfo sizeUpdateInfo = resp.getSnapshotSizeUpdateInfo();
        if (sizeUpdateInfo.getUnscheduledSnapshotCount() > 0) {
            CommandOutput.OutputHierarchy.OutputNode unscheduledSnapshots = new CommandOutput.OutputHierarchy.OutputNode();
            Iterator iterator = sizeUpdateInfo.getUnscheduledSnapshotList().iterator();
            while (iterator.hasNext()) {
                int snapshotId = (Integer)iterator.next();
                unscheduledSnapshots.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapshotId", snapshotId));
            }
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("unscheduled snapshots", (Object)unscheduledSnapshots));
        }
        if (sizeUpdateInfo.getSnapshotStateCount() > 0) {
            CommandOutput.OutputHierarchy.OutputNode scheduledSnapshotsNode = new CommandOutput.OutputHierarchy.OutputNode("scheduledSnapshots");
            for (final CLDBProto.SnapshotSizeUpdateState snapshotState : sizeUpdateInfo.getSnapshotStateList()) {
                CommandOutput.OutputHierarchy.OutputNode snapshotStateOutNode = new CommandOutput.OutputHierarchy.OutputNode("scheduledSnapshots"){
                    {
                        super(x0);
                        this.addNode(new CommandOutput.OutputHierarchy.OutputNode("snapshotId", snapshotState.getSnapshotId()));
                        this.addNode(new CommandOutput.OutputHierarchy.OutputNode("ownedSize", snapshotState.getOwnedSize()));
                        this.addNode(new CommandOutput.OutputHierarchy.OutputNode("sharedSize", snapshotState.getSharedSize()));
                        if (snapshotState.getPendingCidCount() > 0) {
                            CommandOutput.OutputHierarchy.OutputNode pendingCids = new CommandOutput.OutputHierarchy.OutputNode();
                            for (Integer snapCid : snapshotState.getPendingCidList()) {
                                pendingCids.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapCid", (Object)snapCid));
                            }
                            this.addNode(new CommandOutput.OutputHierarchy.OutputNode("pending cids", (Object)pendingCids));
                        }
                    }
                };
                scheduledSnapshotsNode.addNode(snapshotStateOutNode);
            }
            out.addNode(scheduledSnapshotsNode);
        }
        return output;
    }

    CommandOutput.OutputHierarchy.OutputNode getFormattedSpInfo(final CLDBProto.RBalSpBalancingInfo spInfo) {
        return new CommandOutput.OutputHierarchy.OutputNode("Storage Pools"){
            {
                super(x0);
                if (spInfo.hasSpId()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("SpId", (Object)spInfo.getSpId()));
                }
                if (spInfo.hasHostAddress()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("HostAddress", (Object)spInfo.getHostAddress()));
                }
                if (spInfo.hasNumContainers()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumContainers", (Object)new Integer(spInfo.getNumContainers())));
                }
                if (spInfo.hasNumMasters()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumMasters", (Object)new Integer(spInfo.getNumMasters())));
                }
                if (spInfo.hasDesiredNumMasters()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("DesiredNumMasters", (Object)new Integer(spInfo.getDesiredNumMasters())));
                }
                if (spInfo.hasNumTails()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumTails", (Object)new Integer(spInfo.getNumTails())));
                }
                if (spInfo.hasDesiredNumTails()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("DesiredNumTails", (Object)new Integer(spInfo.getDesiredNumTails())));
                }
                if (spInfo.hasSizeofContainers()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("SizeOfContainers", (Object)new Long(spInfo.getSizeofContainers())));
                }
                if (spInfo.hasSizeofMasters()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("SizeOfMasters", (Object)new Long(spInfo.getSizeofMasters())));
                }
                if (spInfo.hasDesiredSizeofMasters()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("DesiredSizeOfMasters", (Object)new Long(spInfo.getDesiredSizeofMasters())));
                }
                if (spInfo.hasSizeofTails()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("SizeOfTails", (Object)new Long(spInfo.getSizeofTails())));
                }
                if (spInfo.hasDesiredSizeofTails()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("DesiredSizeOfTails", (Object)new Long(spInfo.getDesiredSizeofTails())));
                }
                if (spInfo.hasAssignCacheCntrsCount()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("Assign Cache Containers Count", spInfo.getAssignCacheCntrsCount()));
                }
                if (spInfo.hasAssignCacheCntrsSize()) {
                    this.addChild(new CommandOutput.OutputHierarchy.OutputNode("Assign Cache Containers Size", spInfo.getAssignCacheCntrsSize()));
                }
            }
        };
    }

    private CommandOutput dumpRoleBalancerMetrics() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        LOG.info((Object)"dumpRoleBalancerMetrics : Dumping RoleBalancer metrics");
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.METRICS_ROLEBALANCER_OP).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump rolebalancermetrics RPC failed"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump rolebalancermetrics failed with status : " + resp.getStatus()));
                output.setOutput(out);
                return output;
            }
            out.addNode(this.formatRoleBalancerMetrics(resp.getRoleBalancerMetrics()));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump rolebalancermetrics failed"));
            output.setOutput(out);
            return output;
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpVolumeNodes() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
        try {
            CLDBProto.VolumeInfo volInfo = this.lookupVolumeInfo(volumeName);
            if (volInfo == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName));
                output.setOutput(out);
                return output;
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName + ", Error:" + e.getLocalizedMessage()));
            output.setOutput(out);
            return output;
        }
        HashMap<Long, Common.Server> nodes = new HashMap<Long, Common.Server>();
        boolean hasMore = false;
        int startId = 0;
        do {
            CLDBProto.VolumeContainersMapRequest volReq = CLDBProto.VolumeContainersMapRequest.newBuilder().setVolumeName(volumeName).setStartContainerId(startId).setNumContainers(10).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeContainersMapResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeContainersMapResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump volumenodes rpc failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.VolumeContainersMapResponse resp = CLDBProto.VolumeContainersMapResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump volumenodes volume containersmap failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                int lastId = 0;
                for (CLDBProto.ContainerInfo cInfo : resp.getContainersList()) {
                    for (Common.Server ip : cInfo.getAServersList()) {
                        if (nodes.get(ip.getServerId()) != null) continue;
                        nodes.put(ip.getServerId(), ip);
                    }
                    for (Common.Server ip : cInfo.getIServersList()) {
                        if (nodes.get(ip.getServerId()) != null) continue;
                        nodes.put(ip.getServerId(), ip);
                    }
                    for (Common.Server ip : cInfo.getUServersList()) {
                        if (nodes.get(ip.getServerId()) != null) continue;
                        nodes.put(ip.getServerId(), ip);
                    }
                    lastId = cInfo.getContainerId();
                }
                hasMore = resp.getHasMoreContainers();
                if (!hasMore) continue;
                startId = lastId + 1;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump volumenodes failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        CommandOutput.OutputHierarchy.OutputNode empty = new CommandOutput.OutputHierarchy.OutputNode();
        CommandOutput.OutputHierarchy.OutputNode s = new CommandOutput.OutputHierarchy.OutputNode("Servers");
        for (Common.Server n : nodes.values()) {
            s.addChild(new CommandOutput.OutputHierarchy.OutputNode("IP:Port", (Object)Util.printServerWithStateForCLI((Common.Server)n)));
        }
        empty.addChild(s);
        out.addNode(empty);
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpVolumeInfo() throws CLIProcessingException {
        CLDBProto.VolumeInfo volInfo = null;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String volumeName = this.getParamTextValue(DUMP_VOLUME_NAME_PARAM_NAME, 0);
        try {
            volInfo = this.lookupVolumeInfo(volumeName);
            if (volInfo == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName));
                output.setOutput(out);
                return output;
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not get info for volume: " + volumeName + ", Error: " + e.getLocalizedMessage()));
            output.setOutput(out);
            return output;
        }
        if (!volInfo.getVolProperties().hasTierProps() && volInfo.getVolProperties().hasNumECParityColumns()) {
            return this.dumpECVolumeInfo(volInfo, output, out);
        }
        out.addNode(this.formatVolumeInfo(volInfo));
        return this.dumpVolumeContainers(volumeName, output, out);
    }

    private CommandOutput dumpVolumeContainers(String volumeName, CommandOutput output, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        boolean hasMore = false;
        int startId = 0;
        do {
            LOG.info((Object)"dumpVolumeInfo : Requesting VolumeContainersMap");
            CLDBProto.VolumeContainersMapRequest volReq = CLDBProto.VolumeContainersMapRequest.newBuilder().setVolumeName(volumeName).setStartContainerId(startId).setNumContainers(64).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeContainersMapResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeContainersMapResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump volumeinfo rpc failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.VolumeContainersMapResponse resp = CLDBProto.VolumeContainersMapResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump volumeinfo volume containersmap failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                int lastId = 0;
                for (CLDBProto.ContainerInfo cInfo : resp.getContainersList()) {
                    out.addNode(this.formatContainerInfo(cInfo, null));
                    lastId = cInfo.getContainerId();
                }
                hasMore = resp.getHasMoreContainers();
                if (!hasMore) continue;
                startId = lastId + 1;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump volumeinfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        output.setOutput(out);
        return output;
    }

    private CommandOutput dumpECVolumeInfo(CLDBProto.VolumeInfo volInfo, CommandOutput output, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String volumeName = volInfo.getVolProperties().getVolumeName();
        CommandOutput.OutputHierarchy.OutputNode volumeInfoNode = this.formatVolumeInfo(volInfo);
        out.addNode(volumeInfoNode);
        boolean hasMore = false;
        int startId = 0;
        long totalCGs = 0L;
        long totalDegradedCGs = 0L;
        long totalSealedCGs = 0L;
        long totalNumStripes = 0L;
        long totalNumValidStripes = 0L;
        long totalNumStripesToRecover = 0L;
        long totalNumStripesInRebuild = 0L;
        long[] totalNumDegradedStripesList = new long[volInfo.getVolProperties().getNumECParityColumns()];
        do {
            LOG.info((Object)("dumpVolumeInfo : Requesting VolumeCGList for volume : " + volumeName));
            CLDBProto.VolumeCGListRequest volReq = CLDBProto.VolumeCGListRequest.newBuilder().setVolumeName(volumeName).setStartGroupId(startId).setNumCGroups(64).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCGListProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeCGListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCGListProc.getNumber(), (MessageLite)volReq, CLDBProto.VolumeCGListResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump volumeinfo rpc failed"));
                    output.setOutput(out);
                    return output;
                }
                CLDBProto.VolumeCGListResponse resp = CLDBProto.VolumeCGListResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump volumeinfo volume CGListProc failed with status : " + resp.getStatus()));
                    output.setOutput(out);
                    return output;
                }
                int lastId = 0;
                for (CLDBProto.ContainerGroup cg : resp.getContainerGroupsList()) {
                    out.addNode(this.formatContainerGroupInfo(cg, null));
                    ++totalCGs;
                    totalDegradedCGs += (long)(cg.getIsDegraded() ? 1 : 0);
                    totalSealedCGs += (long)(cg.getIsSealed() ? 1 : 0);
                    totalNumStripes += (long)cg.getNumStripes();
                    totalNumValidStripes += (long)cg.getNumValidStripes();
                    totalNumStripesToRecover += (long)cg.getNumStripesToRecover();
                    totalNumStripesInRebuild += (long)cg.getNumStripesInRebuild();
                    int i = 0;
                    Iterator iterator = cg.getNumDegradedStripesList().iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        int n2 = i;
                        totalNumDegradedStripesList[n2] = totalNumDegradedStripesList[n2] + (long)cg.getNumDegradedStripes(i);
                        ++i;
                    }
                    lastId = cg.getContainerGroupId();
                }
                hasMore = resp.getHasMoreCGroups();
                if (!hasMore) continue;
                startId = lastId + 1;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump volumeinfo failed"));
                output.setOutput(out);
                return output;
            }
        } while (hasMore);
        volumeInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalCGs", totalCGs));
        volumeInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalDegradedCGs", totalDegradedCGs));
        volumeInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalSealedCGs", totalSealedCGs));
        volumeInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalNumStripes", totalNumStripes));
        volumeInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalNumValidStripes", totalNumValidStripes));
        volumeInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalNumStripesToRecover", totalNumStripesToRecover));
        volumeInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalNumStripesInRebuild", totalNumStripesInRebuild));
        int i = 0;
        for (long n : totalNumDegradedStripesList) {
            volumeInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalNumDegradedStripes[" + i + "]", totalNumDegradedStripesList[i]));
            ++i;
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatContainerGroupInfo(CLDBProto.ContainerGroup cg, CLDBProto.VolumeInfo vInfo) {
        CommandOutput.OutputHierarchy.OutputNode cgOut = new CommandOutput.OutputHierarchy.OutputNode();
        cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ContainerGroupId", cg.getContainerGroupId()));
        if (cg.hasManager() && cg.getManager() != null) {
            cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Manager", (Object)Util.printServerWithStateForCLI((Common.Server)cg.getManager())));
        } else {
            cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Manager", (Object)"None"));
        }
        cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("IsDegraded", (Object)cg.getIsDegraded()));
        cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("IsSealed", (Object)cg.getIsSealed()));
        cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("numStripes", cg.getNumStripes()));
        cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("numValidStripes", cg.getNumValidStripes()));
        cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("numStripesToRecover", cg.getNumStripesToRecover()));
        cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("numStripesInRebuild", cg.getNumStripesInRebuild()));
        int i = 0;
        Iterator iterator = cg.getNumDegradedStripesList().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("numDegradedStripes[" + i + "]", cg.getNumDegradedStripes(i)));
            ++i;
        }
        cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumData", cg.getContainersInfoCount() - cg.getNumECParityColumns()));
        cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumParity", cg.getNumECParityColumns()));
        if (vInfo != null) {
            cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeName", (Object)vInfo.getVolProperties().getVolumeName()));
            cgOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeId", vInfo.getVolProperties().getVolumeId()));
        }
        CommandOutput.OutputHierarchy.OutputNode ecContainers = new CommandOutput.OutputHierarchy.OutputNode("ECGContainers");
        cgOut.addChild(ecContainers);
        i = 0;
        for (CLDBProto.ContainerInfo cInfo : cg.getContainersInfoList()) {
            CommandOutput.OutputHierarchy.OutputNode con = this.formatContainerInfo(cInfo, null, null);
            con.setName(new String("cid" + i));
            ecContainers.addChild(con);
            ++i;
        }
        return cgOut;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatContainerInfo(CLDBProto.ContainerInfo cInfo, CLDBProto.VolumeInfo vInfo) {
        return this.formatContainerInfo(cInfo, vInfo, null);
    }

    private CommandOutput.OutputHierarchy.OutputNode formatContainerInfo(CLDBProto.ContainerInfo cInfo, CLDBProto.VolumeInfo vInfo, String type) {
        return DumpCommands.formatContainerInfo(cInfo, vInfo, type, this.getVersion());
    }

    public static CommandOutput.OutputHierarchy.OutputNode formatContainerInfo(CLDBProto.ContainerInfo cInfo, CLDBProto.VolumeInfo vInfo, String type, int version) {
        CommandOutput.OutputHierarchy.OutputNode cOut = new CommandOutput.OutputHierarchy.OutputNode();
        if (type != null && (type.equalsIgnoreCase("waiting") || type.equalsIgnoreCase("unused") || type.equalsIgnoreCase("resync") || type.equalsIgnoreCase("bm"))) {
            int count = 0;
            if (type.equalsIgnoreCase("waiting")) {
                count = cInfo.getIServersCount();
            } else if (type.equalsIgnoreCase("unused")) {
                count = cInfo.getUServersCount();
            } else if (type.equalsIgnoreCase("resync")) {
                for (Common.Server s : cInfo.getAServersList()) {
                    if (s.getState() != Common.Server.ReplicaState.RESYNC) continue;
                    ++count;
                }
            } else {
                count = 1;
            }
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("InstanceCount", count));
        }
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ContainerId", cInfo.getContainerId()));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Epoch", cInfo.getLatestEpoch()));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Master", (Object)Util.printServerWithStateForCLI((Common.Server)cInfo.getMServer())));
        CommandOutput.OutputHierarchy.OutputNode activeServers = new CommandOutput.OutputHierarchy.OutputNode("ActiveServers");
        cOut.addChild(activeServers);
        for (Object ip : cInfo.getAServersList()) {
            activeServers.addChild(new CommandOutput.OutputHierarchy.OutputNode("IP", (Object)Util.printServerWithStateForCLI((Common.Server)ip)));
            if (ip.getExternalIPsList().isEmpty()) continue;
            activeServers.addChild(new CommandOutput.OutputHierarchy.OutputNode("ExtIP", (Object)Util.PrintExtIpAddressesForCli((Common.Server)ip)));
        }
        CommandOutput.OutputHierarchy.OutputNode inactiveServer = new CommandOutput.OutputHierarchy.OutputNode("InactiveServers");
        cOut.addChild(inactiveServer);
        for (Object ip : cInfo.getIServersList()) {
            inactiveServer.addChild(new CommandOutput.OutputHierarchy.OutputNode("IP", (Object)Util.printServerWithNoStateForCLI((Common.Server)ip)));
            if (ip.getExternalIPsList().isEmpty()) continue;
            inactiveServer.addChild(new CommandOutput.OutputHierarchy.OutputNode("ExtIP", (Object)Util.PrintExtIpAddressesForCli((Common.Server)ip)));
        }
        CommandOutput.OutputHierarchy.OutputNode unUsedServer = new CommandOutput.OutputHierarchy.OutputNode("UnusedServers");
        cOut.addChild(unUsedServer);
        for (Common.Server ip : cInfo.getUServersList()) {
            unUsedServer.addChild(new CommandOutput.OutputHierarchy.OutputNode("IP", (Object)Util.printServerWithNoStateForCLI((Common.Server)ip)));
            if (ip.getExternalIPsList().isEmpty()) continue;
            unUsedServer.addChild(new CommandOutput.OutputHierarchy.OutputNode("ExtIP", (Object)Util.PrintExtIpAddressesForCli((Common.Server)ip)));
        }
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("OwnedSizeMB", (Object)Util.readableSizeMB((long)cInfo.getOwnedSizeMB())));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("SharedSizeMB", (Object)Util.readableSizeMB((long)cInfo.getSharedSizeMB())));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("LogicalSizeMB", (Object)Util.readableSizeMB((long)cInfo.getLogicalSizeMB())));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("TotalSizeMB", (Object)Util.readableSizeMB((long)cInfo.getChainSizeMB())));
        if (cInfo.hasNumInumUsed()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumInodesInUse", cInfo.getNumInumUsed()));
        }
        if (cInfo.hasMtime()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Mtime", new Date(cInfo.getMtime()), version));
        }
        if (cInfo.getNameContainer()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameContainer", (Object)"true"));
        } else {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameContainer", (Object)"false"));
        }
        if (cInfo.hasRwContainerId()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("RW ContainerId", cInfo.getRwContainerId()));
        }
        if (cInfo.hasRwVolumeId()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("RW VolumeId", cInfo.getRwVolumeId()));
        }
        if (cInfo.hasEcCgId()) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ecCgId ", cInfo.getEcCgId()));
            if (cInfo.hasIsRebuildInProgress()) {
                cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("isRebuildInProgress ", (Object)cInfo.getIsRebuildInProgress()));
            }
        }
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("CreatorContainerId", cInfo.getCreatorContainerId()));
        StringBuilder creatorVolUuid = new StringBuilder();
        if (cInfo.hasCreatorVolumeUuid()) {
            creatorVolUuid.append(cInfo.getCreatorVolumeUuid().getId640());
            creatorVolUuid.append(":");
            creatorVolUuid.append(cInfo.getCreatorVolumeUuid().getId641());
        }
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("CreatorVolumeUuid", (Object)creatorVolUuid.toString()));
        cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("UseActualCreatorId", (Object)cInfo.getUseActualCreatorId()));
        if (vInfo != null) {
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeName", (Object)vInfo.getVolProperties().getVolumeName()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeId", vInfo.getVolProperties().getVolumeId()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeReplication", vInfo.getVolProperties().getReplicationPolicy().getNumReplicas()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameSpaceReplication", vInfo.getVolProperties().getNumNamespaceReplicas()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeMounted", (Object)vInfo.getVolProperties().getMounted()));
            cOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("AccessTime", vInfo.hasAtime() ? new Date(vInfo.getAtime()) : null, version));
        }
        return cOut;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatVolumeInfo(CLDBProto.VolumeInfo volInfo) {
        CommandOutput.OutputHierarchy.OutputNode vOut = new CommandOutput.OutputHierarchy.OutputNode();
        int version = this.getVersion();
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeName", (Object)volInfo.getVolProperties().getVolumeName()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeId", volInfo.getVolProperties().getVolumeId()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeTopology", (Object)volInfo.getVolProperties().getTopology().getTopologyRestricted()));
        if (volInfo.getVolProperties().hasLocalTopology()) {
            vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeLocalTopology", (Object)volInfo.getVolProperties().getLocalTopology().getTopologyRestricted()));
        }
        if (volInfo.getVolProperties().hasNumECDataColumns() && volInfo.getVolProperties().hasNumECDataColumns()) {
            vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ecScheme", (Object)new String(volInfo.getVolProperties().getNumECDataColumns() + "+" + volInfo.getVolProperties().getNumECParityColumns())));
        }
        if (volInfo.getVolProperties().hasLocalTopology()) {
            vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeLocalTopology", (Object)volInfo.getVolProperties().getLocalTopology().getTopologyRestricted()));
        }
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeUsedSizeMB", volInfo.getVolQuota().getVolumeUsedSizeMB()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeReplication", volInfo.getVolProperties().getReplicationPolicy().getNumReplicas()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeMinReplication", volInfo.getVolProperties().getReplicationPolicy().getGuaranteedMinReplicas()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameSpaceReplication", volInfo.getVolProperties().getNumNamespaceReplicas()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NameSpaceMinReplication", volInfo.getVolProperties().getGuaranteedMinNamespaceReplicas()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ReReplicationTimeOutSec", volInfo.getVolProperties().getReReplicationTimeOutSec()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("MirrorThrottle", (Object)volInfo.getVolProperties().getMirrorThrottle()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("AccessTime", volInfo.hasAtime() ? new Date(volInfo.getAtime()) : null, version));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("AuditVolume", volInfo.getVolProperties().getIsAuditVolume(), version, true));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Audited", volInfo.getVolProperties().getAudited(), version, true));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ForceAudit", volInfo.getVolProperties().getForceAudit(), version, true));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("CoalesceInterval", volInfo.getVolProperties().getCoalesceInterval()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("EnabledDataAuditOperations", (Object)GetStringsForAuditOps.getEnabledOps((long)volInfo.getVolProperties().getFsAuditDisabledOperations())));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("DisabledDataAuditOperations", (Object)GetStringsForAuditOps.getDisabledOps((long)volInfo.getVolProperties().getFsAuditDisabledOperations())));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("WireSecurityEnabled", volInfo.getVolProperties().getWireSecurityEnabled(), version, true));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("limitSpread", (Object)(volInfo.getVolProperties().hasLimitVolumeSpread() ? volInfo.getVolProperties().getLimitVolumeSpread() : true)));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("allowGrant", (Object)(volInfo.getVolProperties().hasAllowGrant() ? volInfo.getVolProperties().getAllowGrant() : false)));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("fixCreatorId", (Object)volInfo.getVolProperties().getUseActualCreatorId()));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("MetricsEnabled", volInfo.getVolProperties().getMetricsEnabled(), version, true));
        vOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("dareEnabled", volInfo.getVolProperties().getDareEnabled() ? 1 : 0));
        return vOut;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatFileServerCommand(CLDBProto.FileServerPendingWork cmd) {
        CommandOutput.OutputHierarchy.OutputNode fsOut = new CommandOutput.OutputHierarchy.OutputNode();
        fsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ContainerId", cmd.getCmd().getContainerId()));
        fsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("Command", (Object)cmd.getCmd().getWork()));
        fsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ExpectingReply", (Object)cmd.getExpectingReply()));
        fsOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("StoragePool", (Object)cmd.getSpId()));
        return fsOut;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveSp(CLDBProto.ActiveStoragePool sp) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spid", (Object)sp.getSpid()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("fsid", sp.getFsid()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip:port", (Object)Util.printIPAddressesForCLI((Common.Server)sp.getServer())));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("capacityMB", sp.getCapacityMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("usedMB", sp.getUsedMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("percentage", sp.getPercentUsed()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("fullnessLevel", (Object)sp.getFullness()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("inTransitMB", sp.getInTransitMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("outTransitMB", sp.getOutTransitMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("topology", (Object)sp.getTopology()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastHeartBeatSec", sp.getLastHeartBeat()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("inTransitContainers", sp.getInTransitContainersCount()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("outTransitContainers", sp.getOutTransitContainersCount()));
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveMove(CLDBProto.ActiveContainerMove am) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        int version = this.getVersion();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerid", am.getContainerId()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("sizeMB", am.getSizeMB()));
        if (am.hasFrom()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("From fsid", am.getFrom().getServerId()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("From IP:Port", (Object)Util.printIPAddressesForCLI((Common.Server)am.getFrom())));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("From SP", (Object)am.getFrom().getSpInfo().getSpId()));
        }
        if (am.hasTo()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("To fsid", am.getTo().getServerId()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("To IP:Port", (Object)Util.printIPAddressesForCLI((Common.Server)am.getTo())));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("To SP", (Object)am.getTo().getSpInfo().getSpId()));
        }
        if (am.hasUpdatesBlocked() && am.getUpdatesBlocked() && am.hasUpdatesBlockedSince()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Updates blocked Since", new Date(am.getUpdatesBlockedSince()), version));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveRoleSwitch(CLDBProto.ActiveContainerRoleSwitch am) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerid", am.getContainerId()));
        if (am.hasTail()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Tail IP:Port", (Object)Util.printIPAddressesForCLI((Common.Server)am.getTail())));
        }
        if (am.hasUpdatesBlockedSince() && am.getUpdatesBlockedSince() != 0L) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Updates blocked Since", new Date(am.getUpdatesBlockedSince()), this.version.intValue()));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveCopyCreate(CLDBProto.ActiveContainerCopyCreate am) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerid", am.getContainerId()));
        int version = this.getVersion();
        for (CLDBProto.ActiveContainerCopyReplica repl : am.getReplicasList()) {
            CommandOutput.OutputHierarchy.OutputNode rout = new CommandOutput.OutputHierarchy.OutputNode("replica");
            rout.addChild(new CommandOutput.OutputHierarchy.OutputNode("sizeMB", repl.getSizeMB()));
            if (repl.hasTo()) {
                rout.addChild(new CommandOutput.OutputHierarchy.OutputNode("To fsid", repl.getTo().getServerId()));
                rout.addChild(new CommandOutput.OutputHierarchy.OutputNode("To IP:Port", (Object)Util.printIPAddressesForCLI((Common.Server)repl.getTo())));
                rout.addChild(new CommandOutput.OutputHierarchy.OutputNode("To SP", (Object)repl.getTo().getSpInfo().getSpId()));
            }
            out.addChild(rout);
        }
        if (am.hasStartTime()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("startTime", new Date(am.getStartTime()), version));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatDiskBalancerMetrics(MetricsProto.DiskBalancerMetrics dm) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        int version = this.getVersion();
        if (dm.hasNumContainersMoved()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numContainersMoved", dm.getNumContainersMoved()));
        }
        if (dm.hasNumMBMoved()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numMBMoved", dm.getNumMBMoved()));
        }
        if (dm.hasTimeOfLastMove() && dm.getTimeOfLastMove() > 0L) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("timeOfLastMove", new Date(dm.getTimeOfLastMove()), version));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatRoleBalancerMetrics(MetricsProto.RoleBalancerMetrics rm) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        int version = this.getVersion();
        if (rm.hasNumNameContainerSwitches()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numNameContainerSwitches", rm.getNumNameContainerSwitches()));
        }
        if (rm.hasNumDataContainerSwitches()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numDataContainerSwitches", rm.getNumDataContainerSwitches()));
        }
        if (rm.hasTimeOfLastSwitch() && rm.getTimeOfLastSwitch() > 0L) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("timeOfLastMove", new Date(rm.getTimeOfLastSwitch()), version));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatRereplicationMetrics(MetricsProto.RereplicationMetrics rr) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (rr.hasNumContainersCopied()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numContainersCopied", rr.getNumContainersCopied()));
        }
        if (rr.hasNumMBCopied()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numMBCopied", rr.getNumMBCopied()));
        }
        if (rr.hasNumEcContainersRebuilt()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numEcContainersRebuilt", rr.getNumEcContainersRebuilt()));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveAssignVoucher(CLDBProto.ActiveAssignVoucher av) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerid", av.getContainerId()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("activeSizeMB", av.getActiveSizeMB()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("inactiveSizeMB", av.getInactiveSizeMB()));
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActiveWriter(CLDBProto.ActiveWriter w) {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostname", (Object)w.getHostname()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volume", (Object)w.getVolumeName()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numAssigns", w.getNumContainerAssignCalls()));
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numInactiveAssigns", w.getNumContainerAssignCallsInactive()));
        return out;
    }

    private CLDBProto.VolumeInfo lookupVolumeInfo(int volumeId) throws Exception {
        CLDBProto.VolumeLookupRequest req = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeId(volumeId).setCreds(this.getUserCredentials()).build();
        return this.lookupVolumeInfoInternal(req);
    }

    private CLDBProto.VolumeInfo lookupVolumeInfo(String volumeName) throws Exception {
        CLDBProto.VolumeLookupRequest req = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(volumeName).setCreds(this.getUserCredentials()).build();
        return this.lookupVolumeInfoInternal(req);
    }

    private CLDBProto.VolumeInfo lookupVolumeInfoInternal(CLDBProto.VolumeLookupRequest req) throws Exception {
        byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req, CLDBProto.VolumeLookupResponse.class);
        if (data == null) {
            throw new CLIProcessingException("Exception while processing RPC");
        }
        CLDBProto.VolumeLookupResponse resp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            throw new IOException(resp.getStatus() == 2 ? "No such volume" : Errno.toString((int)resp.getStatus()));
        }
        return resp.getVolInfo();
    }

    private CLDBProto.ContainerInfo lookupContainerInfo(int containerId) throws Exception {
        LOG.info((Object)("Lookup for container " + containerId));
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.CONTAINER_DUMP_OP).setContainerId(containerId).setCreds(this.getUserCredentials()).build();
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (data == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                throw new CLIProcessingException("Couldn't connect to the CLDB service");
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                return resp.getContainerInfo();
            }
            return null;
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    private CommandOutput dumpContainerInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String containerIds = this.getParamTextValue(DUMP_CONTAINER_ID_PARAM_NAME, 0);
        ArrayList<Integer> cIds = new ArrayList<Integer>();
        if (!containerIds.contains(MULTI_ARG_SEP)) {
            cIds.add(Integer.parseInt(containerIds));
        } else {
            String[] cs;
            for (String cId : cs = containerIds.split(MULTI_ARG_SEP)) {
                cIds.add(Integer.parseInt(cId));
            }
        }
        for (Integer cid : cIds) {
            try {
                CLDBProto.ContainerInfo cInfo = this.lookupContainerInfo(cid);
                if (cInfo == null) continue;
                int volumeId = cInfo.hasRwVolumeId() ? cInfo.getRwVolumeId() : cInfo.getVolumeId();
                CLDBProto.VolumeInfo vInfo = this.lookupVolumeInfo(volumeId);
                out.addNode(this.formatContainerInfo(cInfo, vInfo));
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump containerInfo failed"));
                output.setOutput(out);
                return output;
            }
        }
        return output;
    }

    private CLDBProto.ContainerGroup lookupContainerGroupInfo(int containerId) throws Exception {
        LOG.info((Object)("Lookup for container Group" + containerId));
        CLDBProto.CGLookupRequest req = CLDBProto.CGLookupRequest.newBuilder().setCid(containerId).setClientCreds(this.getUserCredentials()).setNeedSizeInfo(true).build();
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerGroupLookupProc.getNumber(), (MessageLite)req, CLDBProto.CGLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerGroupLookupProc.getNumber(), (MessageLite)req, CLDBProto.CGLookupResponse.class);
            if (data == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                throw new CLIProcessingException("Couldn't connect to the CLDB service");
            }
            CLDBProto.CGLookupResponse resp = CLDBProto.CGLookupResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                return resp.getContainerGroup();
            }
            return null;
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    private CommandOutput dumpContainerGroupInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String containerIds = this.getParamTextValue(DUMP_CONTAINER_ID_PARAM_NAME, 0);
        ArrayList<Integer> cIds = new ArrayList<Integer>();
        if (!containerIds.contains(MULTI_ARG_SEP)) {
            cIds.add(Integer.parseInt(containerIds));
        } else {
            String[] cs;
            for (String cId : cs = containerIds.split(MULTI_ARG_SEP)) {
                cIds.add(Integer.parseInt(cId));
            }
        }
        for (Integer cid : cIds) {
            try {
                CLDBProto.ContainerGroup cg = this.lookupContainerGroupInfo(cid);
                if (cg == null) continue;
                CLDBProto.ContainerInfo cInfo = cg.getContainersInfo(0);
                int volumeId = cInfo.hasRwVolumeId() ? cInfo.getRwVolumeId() : cInfo.getVolumeId();
                CLDBProto.VolumeInfo vInfo = this.lookupVolumeInfo(volumeId);
                out.addNode(this.formatContainerGroupInfo(cg, vInfo));
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump ecginfo failed" + e));
                output.setOutput(out);
                return output;
            }
        }
        return output;
    }

    private CommandOutput dumpContainers() throws CLIProcessingException {
        CLDBProto.DumpInfoRequest.DumpOp dumpOp;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String type = this.getParamTextValue(DUMP_CONTAINER_TYPE_PARAM_NAME, 0);
        long cookie = 0L;
        if (type.equalsIgnoreCase("offline")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_OFFLINE_CONTAINERS_OP;
        } else if (type.equalsIgnoreCase("resync")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_RESYNCING_CONTAINERS_OP;
        } else if (type.equalsIgnoreCase("bm")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_BECOME_MASTER_CONTAINERS_OP;
        } else if (type.equalsIgnoreCase("waiting")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_WAITING_FOR_ROLE_CONTAINERS_OP;
        } else if (type.equalsIgnoreCase("unused")) {
            dumpOp = CLDBProto.DumpInfoRequest.DumpOp.LIST_UNUSED_CONTAINERS_OP;
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type " + type));
            return output;
        }
        boolean hasMore = false;
        do {
            CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setCookie(cookie).setDumpOp(dumpOp).build();
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. dump containers rpc failed"));
                    return output;
                }
                CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "dump containers failed with status : " + resp.getStatus()));
                    return output;
                }
                boolean knownOp = resp.hasKnownOp();
                if (knownOp) {
                    knownOp = resp.getKnownOp();
                }
                if (!knownOp) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(38, "CLDB does not understand the dump containers command. Upgrade the CLDB and run the command again"));
                    return output;
                }
                for (CLDBProto.ContainerInfo cinfo : resp.getReplicationContainersList()) {
                    out.addNode(this.formatContainerInfo(cinfo, null, type));
                }
                hasMore = resp.getMoreCids();
                if (!hasMore) continue;
                cookie = resp.getCookie();
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump containers failed"));
                return output;
            }
        } while (hasMore);
        return output;
    }

    private CommandOutput dumpZKInfo() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        ZooKeeper s_zk = null;
        String zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
        if ((zkConnectString == null || zkConnectString.trim().isEmpty()) && this.isParamPresent("zkconnect")) {
            zkConnectString = this.getParamTextValue("zkconnect", 0);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("ZKConnectString: " + zkConnectString));
        }
        if (zkConnectString == null) {
            String errorMsg = "Unable to obtain the ZooKeeper connection string";
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, errorMsg));
            return output;
        }
        zkConnectString = this.isParamPresent("zkconnect") ? this.getParamTextValue("zkconnect", 0) : CLDBRpcCommonUtils.getInstance().getZkConnect();
        try {
            s_zk = NodesCommonUtils.connect(zkConnectString);
            CommandOutput.OutputHierarchy.OutputNode topNode = new CommandOutput.OutputHierarchy.OutputNode();
            this.getRecursiveZKInfo(s_zk, topNode, "/");
            out.addNode(topNode);
        }
        catch (KeeperException.NoAuthException e) {
            LOG.error((Object)"Pemission denied while trying to access ZooKeeper information", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(13, "Permission denied to access zookeeper information."));
        }
        catch (Throwable t) {
            LOG.error((Object)"Error while trying to dump info from ZK. Check ZK connection", t);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Error while trying to dump info from ZK. Check ZK connection: " + zkConnectString));
        }
        return output;
    }

    private CommandOutput supportDumpTrigger() throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput();
        co.setOutput(oh);
        String clusterName = "";
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
        }
        String zkConnectString = null;
        zkConnectString = !clusterName.isEmpty() ? CLDBRpcCommonUtils.getInstance().getZkConnect(clusterName) : CLDBRpcCommonUtils.getInstance().getZkConnect();
        if ((zkConnectString == null || zkConnectString.trim().isEmpty()) && this.isParamPresent("zkconnect")) {
            zkConnectString = this.getParamTextValue("zkconnect", 0);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("ZKConnectString: " + zkConnectString));
        }
        if (zkConnectString == null) {
            String errorMsg = "Unable to obtain the ZooKeeper connection string";
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, errorMsg));
            return co;
        }
        ZooKeeper s_zk = NodesCommonUtils.connect(zkConnectString, clusterName);
        List<Object> nodeHostNames = new ArrayList();
        if (this.isParamPresent("nodes")) {
            nodeHostNames = this.input.getParameterByName("nodes").getParamValues();
            HashSet<String> hostNamesSet = new HashSet<String>(NodesCommonUtils.convertIpToHost(nodeHostNames));
            nodeHostNames.clear();
            nodeHostNames.addAll((Collection<Object>)hostNamesSet);
        } else {
            nodeHostNames = NodesCommonUtils.findNodeIps(zkConnectString, clusterName);
        }
        try {
            for (String string : nodeHostNames) {
                CommandOutput.OutputHierarchy.OutputNode pNode = new CommandOutput.OutputHierarchy.OutputNode();
                oh.addNode(pNode);
                try {
                    s_zk.create("/nodes", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    // empty catch block
                }
                try {
                    s_zk.create("/nodes/" + string, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    // empty catch block
                }
                try {
                    byte[] data = String.valueOf(System.currentTimeMillis()).getBytes();
                    if (this.isParamPresent(DUMP_PARAMS)) {
                        String dumpParams = this.getParamTextValue(DUMP_PARAMS, 0);
                        data = dumpParams.getBytes();
                    }
                    s_zk.create("/nodes/" + string + "/" + SUPPORT_DUMP_ACTION, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    pNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("node", (Object)string));
                }
                catch (KeeperException.NodeExistsException e1) {
                    LOG.warn((Object)("Please wait. The previous " + SUPPORT_DUMP_ACTION + " is executing."));
                }
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)"KeeperException while trying to create ZK struct for support dump", (Throwable)e);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "KeeperException while trying to create ZK struct for support dump" + e.getLocalizedMessage()));
        }
        catch (InterruptedException e) {
            LOG.error((Object)"InterruptedException while trying to create ZK struct for support dump", (Throwable)e);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "InterruptedException while trying to create ZK struct for support dump" + e.getLocalizedMessage()));
        }
        return co;
    }

    private CommandOutput dumpKvStoreCidInfo() throws CLIProcessingException {
        CommandOutput output;
        block6: {
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output = new CommandOutput();
            output.setOutput(out);
            ZooKeeper s_zk = null;
            String zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
            if (zkConnectString == null || zkConnectString.trim().isEmpty()) {
                zkConnectString = this.getParamTextValue("zkconnect", 0);
            }
            try {
                s_zk = NodesCommonUtils.connect(zkConnectString);
                Stat stat = new Stat();
                byte[] data = s_zk.getData("/datacenter/controlnodes/cldb/epoch/1/KvStoreContainerInfo", false, stat);
                if (data != null) {
                    CLDBProto.ContainerInfo kvStoreContainerInfo = CLDBProto.ContainerInfo.parseFrom((byte[])data);
                    LOG.info((Object)("ContainerInfo : " + Util.printContainerInfoForCLI((CLDBProto.ContainerInfo)kvStoreContainerInfo)));
                    for (Common.Server s : kvStoreContainerInfo.getAServersList()) {
                        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("valid", (Object)Util.printIPAddressesForCLI((Common.Server)s)));
                    }
                    for (Common.Server s : kvStoreContainerInfo.getIServersList()) {
                        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("invalid", (Object)Util.printIPAddressesForCLI((Common.Server)s)));
                    }
                    break block6;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Error while trying to trying to read ZooKeeper Information. Please Check ZooKeeper connection: " + zkConnectString));
                return output;
            }
            catch (Throwable t) {
                LOG.error((Object)"Error while trying to dump info from ZK. Check ZK connection", t);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Error while trying to dump info from ZooKeeper. Please Check ZooKeeper connection: " + zkConnectString));
            }
        }
        return output;
    }

    public static String millisToHhMmSs(long millis) {
        return String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(millis) % TimeUnit.MINUTES.toSeconds(1L));
    }

    private CLDBRpcCommonUtils.IpPort getIpPort(String hostip) {
        String[] tokens = hostip.split(":");
        if (tokens.length > 2) {
            LOG.error((Object)("Failed to get hostip:port from " + hostip));
            return null;
        }
        String host = tokens[0];
        CLDBRpcCommonUtils.IpPort ipport = new CLDBRpcCommonUtils.IpPort();
        int port = 7222;
        if (tokens.length == 2) {
            try {
                port = Integer.valueOf(tokens[1]);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)("Port is not Integer: " + tokens[1]));
            }
        }
        ipport.addIPOrHost(host, port);
        return ipport;
    }

    private CommandOutput dumpCldbState() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<CLDBRpcCommonUtils.IpPort> cldbHosts = null;
        this.clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (this.isParamPresent(CLDB_HOSTIP_PARAM)) {
            String hostip = this.getParamTextValue(CLDB_HOSTIP_PARAM, 0);
            CLDBRpcCommonUtils.IpPort ipport = this.getIpPort(hostip);
            if (ipport == null) {
                String msg = "Invalid hostip " + hostip;
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                return output;
            }
            cldbHosts = new ArrayList<CLDBRpcCommonUtils.IpPort>(1);
            cldbHosts.add(ipport);
        } else {
            cldbHosts = (ArrayList<CLDBRpcCommonUtils.IpPort>)CLDBRpcCommonUtils.getInstance().getClusterMap().get(this.clusterName);
            if (cldbHosts == null || cldbHosts.size() == 0) {
                String msg = "No ip/port found for cldb, cluster " + this.clusterName;
                if (!this.isParamPresent("cluster")) {
                    msg = msg + " (default cluster)";
                }
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, msg));
                return output;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("found " + cldbHosts.size() + " cldb hosts in mapr-cluster.conf. " + cldbHosts));
        }
        for (CLDBRpcCommonUtils.IpPort ipport : cldbHosts) {
            StringBuilder strBuilder;
            CommandOutput.OutputHierarchy.OutputNode outNode = this.getCldbState(ipport, strBuilder = new StringBuilder());
            if (outNode == null) continue;
            out.addNode(outNode);
            if (strBuilder.length() <= 0) continue;
            outNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("error", (Object)strBuilder.toString()));
            LOG.error((Object)strBuilder.toString());
        }
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode getCldbState(CLDBRpcCommonUtils.IpPort ipport, StringBuilder strBuilder) {
        if (ipport == null) {
            return null;
        }
        CommandOutput.OutputHierarchy.OutputNode outNode = new CommandOutput.OutputHierarchy.OutputNode();
        outNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip", ipport.getAddr().get(0)));
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        int cldbPort = ipport.getPort();
        int cldbHost = Util.ipToInt((String)((String)ipport.getAddr().get(0)));
        long binding = Rpc.createBindingFor((int)cldbHost, (int)cldbPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
        try {
            data = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.CldbProgramId.getNumber(), (int)CLDBProto.CLDBProg.QueryCldbStateProc.getNumber(), (MessageLite)req);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while sending request ", (Throwable)e);
        }
        if (data == null) {
            strBuilder.append("Couldn't connect to the CLDB service");
            LOG.error((Object)"sendRequest returned null");
            return outNode;
        }
        CLDBProto.DumpInfoResponse resp = null;
        try {
            resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])data);
        }
        catch (Exception e) {
            strBuilder.append("Failed to parse DumpInfoResponse. " + e);
            return outNode;
        }
        if (resp.getStatus() != 0) {
            strBuilder.append("DumpInfo resquest failed with error " + resp.getStatus());
            return outNode;
        }
        if (!resp.hasStateInfo()) {
            strBuilder.append("CLDB state not sent by host " + ipport.toString());
            return outNode;
        }
        CLDBProto.CldbStateInfo stateInfo = resp.getStateInfo();
        outNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("state", (Object)stateInfo.getCldbState().name()));
        outNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("stateDuration", (Object)DumpCommands.millisToHhMmSs(stateInfo.getStateDuration())));
        outNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("desc", (Object)stateInfo.getDesc()));
        outNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("mode", (Object)stateInfo.getCldbMode()));
        return outNode;
    }

    private void getRecursiveZKInfo(ZooKeeper s_zk, CommandOutput.OutputHierarchy.OutputNode parentNode, String zkParentPath) throws KeeperException, InterruptedException {
        List children = s_zk.getChildren(zkParentPath, null);
        Stat stat = new Stat();
        byte[] data = s_zk.getData(zkParentPath, false, stat);
        parentNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(zkParentPath + "_Stats", (Object)DumpCommands.printStat(stat)));
        if (children.isEmpty()) {
            String dataStr = new String(data);
            if (zkParentPath.equalsIgnoreCase("/datacenter/controlnodes/cldb/epoch/1/KvStoreContainerInfo")) {
                try {
                    CLDBProto.ContainerInfo kvStoreContainerInfo = CLDBProto.ContainerInfo.parseFrom((byte[])data);
                    dataStr = Util.printContainerInfoForCLI((CLDBProto.ContainerInfo)kvStoreContainerInfo);
                }
                catch (InvalidProtocolBufferException e) {
                    LOG.error((Object)"Exception while trying to parse container info", (Throwable)e);
                }
            }
            parentNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(zkParentPath, (Object)dataStr));
        } else {
            parentNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(zkParentPath));
            for (String child : children) {
                CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode(zkParentPath);
                String newPath = zkParentPath;
                newPath = !zkParentPath.endsWith("/") ? newPath + "/" + child : newPath + child;
                this.getRecursiveZKInfo(s_zk, node, newPath);
                parentNode.addChild(node);
            }
        }
    }

    private static String printStat(Stat stat) {
        StringBuilder statB = new StringBuilder();
        statB.append("\ncZxid = " + stat.getCzxid());
        statB.append(",ctime = " + new Date(stat.getCtime()).toString());
        statB.append(",mZxid = " + stat.getMzxid());
        statB.append(",mtime = " + new Date(stat.getMtime()).toString());
        statB.append(",pZxid = " + stat.getPzxid());
        statB.append(",cversion = " + stat.getCversion());
        statB.append(",dataVersion = " + stat.getVersion());
        statB.append(",aclVersion = " + stat.getAversion());
        statB.append(",ephemeralOwner = " + stat.getEphemeralOwner());
        statB.append(",dataLength = " + stat.getDataLength());
        statB.append(",numChildren = " + stat.getNumChildren());
        return statB.toString();
    }

    static {
        dumpFileServerWorkInfoUsage = "fileserverworkinfo -cldbip cldbip -cldbport cldbport -fileserverip ip/host -fileserverport port";
        dumpContainerInfoUsage = "containerinfo -cldbip cldbip -cldbport  cldbport -ids id1,id2,id3";
        dumpContainerGroupInfoUsage = "ecginfo -cldbip cldbip -cldbport  cldbport -ids id1,id2,id3";
        dumpReplicationManagerQueueInfoUsage = "replicationmanagerqueueinfo -queue <queue>";
        dumpVolumeInfoUsage = "volumeinfo -cldbip cldbip -cldbport cldbport -volumename <volume name>";
        dumpVolumeNodesUsage = "volumenodes -cldbip cldbip -cldbport cldbport -volumename <volume name>";
        dumpReplicationManagerUsage = "replicationmanager -cldbip cldbip -cldbport cldbport";
        dumpRereplicationUsage = "rereplication -cldbip cldbip -cldbport cldbport";
        dumpBalancerUsage = "balancerinfo -cldbip cldbip -cldbport cldbport";
        dumpSpRefillInfoUsage = "sprefillinfo -cldbip cldbip -cldbport cldbport";
        dumpRoleBalancerUsage = "rolebalancerinfo [-stats] [-volumeinfo -volumename<name>]";
        dumpBalancerMetricsUsage = "balancermetrics -cldbip cldbip -cldbport cldbport";
        dumpRoleBalancerMetricsUsage = "rolebalancermetrics -cldbip cldbip -cldbport cldbport";
        dumpRereplicationMetricsUsage = "rereplicationmetrics -cldbip cldbip -cldbport cldbport";
        cldbNodesUsage = " cldbnodes -zkconnect <zkconnectstring>";
        containersType = "<offline|resync|bm|waiting|unused>";
        dumpContainersUsage = "containers -type " + containersType;
        dumpCLDBMemoryInfoUsage = "cldbmemoryinfo ";
        dumpAssignVouchersUsage = "assignvouchers -volumename volumename";
        dumpActiveWritersUsage = "activewriters";
        dumpCLDBMetaInfoUsage = "cldbmetainfo";
        mallocFileds = new String[]{"arena", "ordblks", "smblks", "hblks", "hblkhd", "usmblks", "fsmblks", "uordblks", "fordblks", "keepcost"};
        baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
        cldbStateCommand = new CLICommand("cldbstate", "usage: dump cldbstate [ -host <ip|hostname> ]", DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)CLDB_HOSTIP_PARAM, (Object)new TextInputParameter(CLDB_HOSTIP_PARAM, "host name or ip", false, null)).build(), null).setShortUsage("dump cldbstate [ -host <ip|hostname> ]");
        cldbNodesCommand = new CLICommand("cldbnodes", "usage : " + cldbNodesUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZK Connect String", true, null)).build(), null).setShortUsage(cldbNodesUsage);
        dumpContainersCommand = new CLICommand("containers", "", DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)DUMP_CONTAINER_TYPE_PARAM_NAME, (Object)new TextInputParameter(DUMP_CONTAINER_TYPE_PARAM_NAME, containersType, true, null)).build(), null).setShortUsage(dumpContainersUsage);
        dumpContainerInfo = new CLICommand("containerinfo", "usage : " + dumpContainerInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)DUMP_CONTAINER_ID_PARAM_NAME, (Object)new TextInputParameter(DUMP_CONTAINER_ID_PARAM_NAME, DUMP_CONTAINER_ID_PARAM_NAME, true, null)).build(), null).setShortUsage(dumpContainerInfoUsage);
        dumpContainerGroupInfo = new CLICommand("ecginfo", "usage : " + dumpContainerGroupInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)DUMP_CONTAINER_ID_PARAM_NAME, (Object)new TextInputParameter(DUMP_CONTAINER_ID_PARAM_NAME, DUMP_CONTAINER_ID_PARAM_NAME, true, null)).build(), null).setShortUsage(dumpContainerGroupInfoUsage);
        dumpReplicationManagerInfo = new CLICommand("replicationmanagerinfo", "usage : " + dumpContainerInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)DUMP_VOLUME_NAME_PARAM_NAME, (Object)new TextInputParameter(DUMP_VOLUME_NAME_PARAM_NAME, DUMP_VOLUME_NAME_PARAM_NAME, true, null)).build(), null).setShortUsage(dumpReplicationManagerUsage);
        dumpReplicationManagerQueueInfo = new CLICommand("replicationmanagerqueueinfo", "usage : " + dumpReplicationManagerQueueInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)DUMP_REPLICATION_MANAGER_QUEUE_PARAM_NAME, (Object)new IntegerInputParameter(DUMP_REPLICATION_MANAGER_QUEUE_PARAM_NAME, DUMP_REPLICATION_MANAGER_QUEUE_PARAM_NAME, true, null)).build(), null).setShortUsage(dumpReplicationManagerQueueInfoUsage);
        dumpRereplicationInfo = new CLICommand("rereplicationinfo", "usage : " + dumpRereplicationUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpRereplicationUsage);
        dumpBalancerInfo = new CLICommand("balancerinfo", "usage : " + dumpBalancerUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpBalancerUsage);
        dumpSpRefillInfo = new CLICommand("sprefillinfo", "usage : " + dumpSpRefillInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpSpRefillInfoUsage);
        dumpBalancerMetrics = new CLICommand("balancermetrics", "usage : " + dumpBalancerMetricsUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpBalancerMetricsUsage);
        dumpRoleBalancerMetrics = new CLICommand("rolebalancermetrics", "usage : " + dumpRoleBalancerMetricsUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpRoleBalancerMetricsUsage);
        dumpRereplicationMetrics = new CLICommand("rereplicationmetrics", "usage : " + dumpRereplicationMetricsUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpRereplicationMetricsUsage);
        dumpAssignVouchers = new CLICommand("assignvouchers", "usage : " + dumpAssignVouchersUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)DUMP_VOLUME_NAME_PARAM_NAME, (Object)new TextInputParameter(DUMP_VOLUME_NAME_PARAM_NAME, DUMP_VOLUME_NAME_PARAM_NAME, true, null)).build(), null).setShortUsage(dumpAssignVouchersUsage);
        dumpActiveWriters = new CLICommand("activewriters", "usage : " + dumpActiveWritersUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage(dumpActiveWritersUsage);
        dumpFileServerWorkInfo = new CLICommand("fileserverworkinfo", "usage : " + dumpFileServerWorkInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)DUMP_FILESERVER_IP_PARAM_NAME, (Object)new TextInputParameter(DUMP_FILESERVER_IP_PARAM_NAME, "fileserverip/host", true, "127.0.0.1")).put((Object)DUMP_FILESERVER_PORT_PARAM_NAME, (Object)new IntegerInputParameter(DUMP_FILESERVER_PORT_PARAM_NAME, DUMP_FILESERVER_PORT_PARAM_NAME, true, Integer.valueOf(5660))).build(), null).setShortUsage(dumpFileServerWorkInfoUsage);
        dumpVolumeInfo = new CLICommand(RBALINFO_VOLUME_OPT, "usage : " + dumpVolumeInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)DUMP_VOLUME_NAME_PARAM_NAME, (Object)new TextInputParameter(DUMP_VOLUME_NAME_PARAM_NAME, DUMP_VOLUME_NAME_PARAM_NAME, true, null)).build(), null).setShortUsage(dumpVolumeInfoUsage);
        dumpVolumeNodes = new CLICommand("volumenodes", "usage : " + dumpVolumeNodesUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)DUMP_VOLUME_NAME_PARAM_NAME, (Object)new TextInputParameter(DUMP_VOLUME_NAME_PARAM_NAME, DUMP_VOLUME_NAME_PARAM_NAME, true, null)).build(), null).setShortUsage(dumpVolumeNodesUsage);
        dumpZKInfo = new CLICommand("zkinfo", "Dumping whole ZK Hierarchy into output", DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZK Connect String", false, null)).build(), null).setShortUsage("Dumping ZK hierarchy info");
        supportDumpTrigger = new CLICommand("supportdump", "Triggering nodes to gather support dump", DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"nodes", (Object)new TextInputParameter("nodes", "node names for which support dump is needed. Space separated. Will be all if parameter is not given", false, null)).put((Object)DUMP_PARAMS, (Object)new TextInputParameter(DUMP_PARAMS, "parameters string to create a dump", false, null)).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZK Connect String", false, null)).build(), null).setShortUsage("Triggering nodes to gather support dump");
        dumpCLDBMetaInfo = new CLICommand("cldbmetainfo", "usage : " + dumpCLDBMetaInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, null, null).setShortUsage(dumpCLDBMetaInfoUsage);
        dumpCLDBMemoryInfo = new CLICommand("cldbmemoryinfo", "usage : " + dumpCLDBMemoryInfoUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)MEMORY_LEAK_PARAM_NAME, (Object)new BooleanInputParameter(MEMORY_LEAK_PARAM_NAME, "introduce native memory leak in cldb", false, null).setInvisible(true)).put((Object)MEMORY_TRIM_PARAM_NAME, (Object)new BooleanInputParameter(MEMORY_TRIM_PARAM_NAME, "shrink cldb native memory if possible", false, Boolean.valueOf(false))).build(), null).setShortUsage(dumpCLDBMemoryInfoUsage);
        dumpRoleBalancerInfo = new CLICommand("rolebalancerinfo", "usage : " + dumpRoleBalancerUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)RBALINFO_STATS_OPT, (Object)new NoValueInputParameter(RBALINFO_STATS_OPT, "Gets RoleBalancer AcitveSwitches Info", false, false)).put((Object)RBALINFO_VOLUME_OPT, (Object)new NoValueInputParameter(RBALINFO_VOLUME_OPT, "Gets Balancing Info for Volumes(s)", false, false)).put((Object)DUMP_VOLUME_NAME_PARAM_NAME, (Object)new TextInputParameter(DUMP_VOLUME_NAME_PARAM_NAME, "Specifies the name of the volumes", false, null)).put((Object)RBALINFO_NAMECNTRS_OPT, (Object)new NoValueInputParameter(RBALINFO_NAMECNTRS_OPT, "Get NameContainers Info", false, false)).build(), null).setShortUsage(dumpRoleBalancerUsage);
        dumpSnapshotSizeUpadteInfoParams = new ImmutableMap.Builder().putAll(baseParams).build();
        dumpSnapshotSizeUpdateUsage = "snapshotsizeupdateinfo -cldbip <cldbip> -cldbport <cldbport>";
        dumpSnapshotSizeUpdateInfo = new CLICommand("snapshotsizeupdateinfo", "usage : " + dumpSnapshotSizeUpdateUsage, DumpCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, dumpSnapshotSizeUpadteInfoParams, null).setShortUsage(dumpSnapshotSizeUpdateUsage);
        SUPPORT_DUMP_ACTION = "sdump";
    }
}

