/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.AceHelper;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OffloadRuleCommands
extends ListCommand
implements CLIInterface {
    static String[] RulePropsFieldShortName = new String[]{"id", "n", "exp"};
    static String[] RulePropsFieldName = new String[]{"ruleid", "rulename", "expression"};
    static CLDBProto.ListSortKey[] TierRuleSortKeys = new CLDBProto.ListSortKey[]{CLDBProto.ListSortKey.TierRuleId, CLDBProto.ListSortKey.TierRuleName, CLDBProto.ListSortKey.TierRuleExpression};
    static Map<String, CLDBProto.ListSortKey> nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
    static String supportedSortKeys;
    public static final String RULENAME_PARAM_NAME = "name";
    public static final String EXPR_PARAM_NAME = "expr";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String SORTBY_PARAM_NAME = "sortby";
    public static final String SORTING_ORDER_PARAM_NAME = "sortorder";
    public static final String ASCENDING_SORTING_ORDER_PARAM_NAME = "asc";
    public static final String DESCENDING_SORTING_ORDER_PARAM_NAME = "desc";
    public static final String ruleCreateUsage = "rule create -name ruleName -expr regular expression of rule [-cluster clustername]";
    public static final String ruleModifyUsage = "rule modify -name ruleName -expr regular expression of rule [-cluster clustername]";
    public static final String ruleListUsage = "rule list [-cluster clustername]";
    public static final String ruleInfoUsage = "rule info -name ruleName [-cluster clustername]";
    public static final String ruleRemoveUsage = "rule remove -name ruleName [-cluster clustername]";
    private static final Logger LOG;
    public static Map<String, BaseInputParameter> baseParams;
    public static Map<String, BaseInputParameter> ruleParams;
    static final CLICommand ruleCreateCommand;
    static final CLICommand ruleModifyCommand;
    static final CLICommand ruleListCommand;
    static final CLICommand ruleInfoCommand;
    static final CLICommand ruleRemoveCommand;
    public static CLICommand[] ruleCommandsArray;
    public static final CLICommand ruleCommands;

    public OffloadRuleCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private void verifySortSanity(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (RulePropsFieldName.length != TierRuleSortKeys.length) {
            String errmsg = "Num of display fields(" + RulePropsFieldName.length + ") mismatch num of Sortkeys(" + TierRuleSortKeys.length + "), may cause incorrect listing. Exiting.";
            LOG.error((Object)errmsg);
            System.err.println(errmsg);
            throw new CLIProcessingException(errmsg);
        }
        int i = 0;
        for (String name : RulePropsFieldName) {
            nameToEnumMap.put(name, TierRuleSortKeys[i++]);
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("list")) {
            this.verifySortSanity(out);
            try {
                String sortbyStr;
                CLDBProto.ListSortKey sortKey;
                if (this.isParamPresent(SORTBY_PARAM_NAME) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0)).toLowerCase())) == null) {
                    LOG.error((Object)("failed to list sorted volumes, " + sortbyStr + " is not a valid keyword to sort volumes."));
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
                    return output;
                }
                if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                    if (!this.isParamPresent(SORTBY_PARAM_NAME)) {
                        String msg = "Invalid use of sortorder. Must be used with sortby";
                        LOG.error((Object)msg);
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                        return output;
                    }
                    String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                    if (!sortOrder.equalsIgnoreCase(ASCENDING_SORTING_ORDER_PARAM_NAME) && !sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                        String msg = "Invalid value for sortorder. Valid values are asc and desc";
                        LOG.error((Object)msg);
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                        return output;
                    }
                }
                this.list(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("create")) {
            try {
                this.ruleCreate(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("modify")) {
            try {
                this.ruleModify(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("info")) {
            try {
                this.ruleInfo(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("remove")) {
            try {
                this.ruleRemove(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return output;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    private String getRuleName() throws CLIProcessingException {
        return this.isParamPresent(RULENAME_PARAM_NAME) ? this.getParamTextValue(RULENAME_PARAM_NAME, 0) : null;
    }

    public static CLDBProto.OffloadRuleLookupResponse ruleLookup(String cluster, Security.CredentialsMsg creds, String ruleName) throws CLIProcessingException {
        byte[] data = null;
        CLDBProto.OffloadRuleLookupRequest req = CLDBProto.OffloadRuleLookupRequest.newBuilder().setRuleName(ruleName).setCreds(creds).build();
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleLookupProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleLookupProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleLookupResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return CLDBProto.OffloadRuleLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing rule lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    void ruleCreate(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String ruleName = null;
        String cluster = null;
        Object credentials = null;
        String expr = null;
        String exprPostFix = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        ruleName = this.getRuleName();
        CLDBProto.OffloadRuleLookupResponse resp = OffloadRuleCommands.ruleLookup(cluster, this.getUserCredentials(), ruleName);
        if (resp.hasStatus() && resp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "OffloadRule " + ruleName + " already exists."));
            return;
        }
        if (this.isParamPresent(EXPR_PARAM_NAME)) {
            expr = this.getParamTextValue(EXPR_PARAM_NAME, 0);
        }
        try {
            if (expr.contains("r:")) {
                throw new IOException("OffloadRule with roles is not supported");
            }
            try {
                exprPostFix = AceHelper.toPostfix((String)expr);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Invalid expression '" + expr + "' provided. " + e.getMessage()));
                return;
            }
            CLDBProto.OffloadRuleProperties ruleProperties = CLDBProto.OffloadRuleProperties.newBuilder().setRuleName(ruleName).setExpression(exprPostFix).build();
            CLDBProto.OffloadRuleCreateRequest ruleCreate = CLDBProto.OffloadRuleCreateRequest.newBuilder().setRuleProps(ruleProperties).setCreds(this.getUserCredentials()).build();
            byte[] data = null;
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleCreateProc.getNumber(), (MessageLite)ruleCreate, CLDBProto.OffloadRuleCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleCreateProc.getNumber(), (MessageLite)ruleCreate, CLDBProto.OffloadRuleCreateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.OffloadRuleCreateResponse createResp = CLDBProto.OffloadRuleCreateResponse.parseFrom((byte[])data);
            if (createResp.getStatus() == 0) {
                out.addMessage("Successfully created rule: '" + ruleName + "'");
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(createResp.getStatus(), Errno.toString((int)createResp.getStatus())));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + (Object)((Object)e));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    void ruleModify(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String ruleName = null;
        String cluster = null;
        Object credentials = null;
        String expr = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        ruleName = this.getRuleName();
        CLDBProto.OffloadRuleLookupResponse resp = OffloadRuleCommands.ruleLookup(cluster, this.getUserCredentials(), ruleName);
        if (resp.hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "OffloadRule " + ruleName + " does not exist."));
            return;
        }
        CLDBProto.OffloadRuleModifyRequest.Builder ruleModify = CLDBProto.OffloadRuleModifyRequest.newBuilder();
        CLDBProto.OffloadRuleProperties.Builder ruleProperties = CLDBProto.OffloadRuleProperties.newBuilder();
        ruleProperties.setRuleName(ruleName);
        expr = this.getParamTextValue(EXPR_PARAM_NAME, 0);
        try {
            if (this.isParamPresent(EXPR_PARAM_NAME)) {
                ruleProperties.setExpression(AceHelper.toPostfix((String)expr));
            }
            if (expr.contains("r:")) {
                throw new IOException("OffloadRule with roles is not supported");
            }
            ruleModify.setRuleProps(ruleProperties);
            ruleModify.setCreds(this.getUserCredentials());
            byte[] data = null;
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleModifyProc.getNumber(), (MessageLite)ruleModify.build(), CLDBProto.OffloadRuleModifyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleModifyProc.getNumber(), (MessageLite)ruleModify.build(), CLDBProto.OffloadRuleModifyResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.OffloadRuleModifyResponse modifyResp = CLDBProto.OffloadRuleModifyResponse.parseFrom((byte[])data);
            if (modifyResp.getStatus() == 0) {
                out.addMessage("Successfully updated rule: '" + ruleName + "'");
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(modifyResp.getStatus(), Errno.toString((int)modifyResp.getStatus())));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + (Object)((Object)e));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    void ruleRemove(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String ruleName = null;
        String cluster = null;
        byte[] data = null;
        ruleName = this.getRuleName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        CLDBProto.OffloadRuleRemoveRequest req = CLDBProto.OffloadRuleRemoveRequest.newBuilder().setRuleName(ruleName).setCreds(this.getUserCredentials()).build();
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleRemoveProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleRemoveProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleRemoveResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.OffloadRuleRemoveResponse resp = CLDBProto.OffloadRuleRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                out.addMessage("Successfully deleted rule: '" + ruleName + "'");
            } else if (resp.getStatus() == 1000) {
                LOG.error((Object)"Cannot remove rule, as some volumes are still using it.");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Can not remove rule, as some volumes are still using it."));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing rule lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    void ruleInfo(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.OffloadRuleLookupResponse resp;
        String ruleName = null;
        String cluster = null;
        ruleName = this.getRuleName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((resp = OffloadRuleCommands.ruleLookup(cluster, this.getUserCredentials(), ruleName)).hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "OffloadRule " + ruleName + " does not exist."));
            return;
        }
        boolean terse = this.getOutputParamValue().equals("terse");
        CommandOutput.OutputHierarchy.OutputNode ruleNode = new CommandOutput.OutputHierarchy.OutputNode();
        this.addOffloadRuleProps(resp.getRuleProps(), terse, out, ruleNode);
        if (resp.hasInUse()) {
            ruleNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("inuse", (Object)Boolean.toString(resp.getInUse())));
        }
    }

    public CLDBProto.OffloadRuleListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.OffloadRuleListRequest.Builder newReqBuilder = null;
        if (prevReq != null) {
            newReqBuilder = CLDBProto.OffloadRuleListRequest.newBuilder((CLDBProto.OffloadRuleListRequest)((CLDBProto.OffloadRuleListRequest)prevReq));
        } else {
            newReqBuilder = CLDBProto.OffloadRuleListRequest.newBuilder();
            if (this.isParamPresent(SORTBY_PARAM_NAME)) {
                String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
                CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
                newReqBuilder.setSortKey(sortKey);
                if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                    String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                    boolean order = false;
                    if (sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                        order = true;
                    }
                    newReqBuilder.setSortDescending(order);
                }
            }
        }
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.OffloadRuleListResponse)prevResp).getRulePropsCount();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, 0, 1024, 25));
        }
        newReqBuilder.setCreds(this.getUserCredentials());
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(0, 1024, ((CLDBProto.OffloadRuleListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.OffloadRuleListResponse)prevResp).getRulePropsCount());
    }

    void addOffloadRuleProps(CLDBProto.OffloadRuleProperties ruleProperties, boolean terse, CommandOutput.OutputHierarchy out, CommandOutput.OutputHierarchy.OutputNode ruleNode) {
        String[] columnName;
        String[] stringArray = columnName = terse ? RulePropsFieldShortName : RulePropsFieldName;
        if (ruleProperties.hasRuleId()) {
            ruleNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[OffloadRulePropertiesField.id.ordinal()], (Object)Integer.toString(ruleProperties.getRuleId())));
        }
        if (ruleProperties.hasRuleName()) {
            ruleNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[OffloadRulePropertiesField.n.ordinal()], (Object)ruleProperties.getRuleName()));
        }
        try {
            if (ruleProperties.hasExpression()) {
                ruleNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[OffloadRulePropertiesField.exp.ordinal()], (Object)AceHelper.toInfix((String)ruleProperties.getExpression())));
            }
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            return;
        }
        out.addNode(ruleNode);
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.OffloadRuleListResponse resp = (CLDBProto.OffloadRuleListResponse)response;
        boolean terse = this.getOutputParamValue().equals("terse");
        for (CLDBProto.OffloadRuleProperties ruleProperties : resp.getRulePropsList()) {
            CommandOutput.OutputHierarchy.OutputNode ruleNode = new CommandOutput.OutputHierarchy.OutputNode();
            this.addOffloadRuleProps(ruleProperties, terse, out, ruleNode);
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
    }

    public CLDBProto.OffloadRuleListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.OffloadRuleListRequest req = (CLDBProto.OffloadRuleListRequest)request;
        byte[] replyData = null;
        if (this.isParamPresent("cluster")) {
            String cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                throw new CLIProcessingException("Invalid cluster: " + cluster);
            }
            try {
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleListProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleListResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
        }
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.OffloadRuleListProc.getNumber(), (MessageLite)req, CLDBProto.OffloadRuleListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return CLDBProto.OffloadRuleListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into OffloadRuleListResponse proto object.", (Throwable)ipbe);
            }
        }
        throw new CLIProcessingException("Failed to get list of rules for this cluster");
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (String name : RulePropsFieldName) {
            if (sb.length() == 0) {
                sb.append(name);
                continue;
            }
            sb.append("|" + name);
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        LOG = Logger.getLogger(OffloadRuleCommands.class);
        baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
        ruleParams = new ImmutableMap.Builder().put((Object)RULENAME_PARAM_NAME, (Object)new TextInputParameter(RULENAME_PARAM_NAME, "rule name", true, null)).put((Object)EXPR_PARAM_NAME, (Object)new TextInputParameter(EXPR_PARAM_NAME, "regular expression of the rule", true, null)).putAll(baseParams).build();
        ruleCreateCommand = new CLICommand("create", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(ruleParams).build(), null).setShortUsage(ruleCreateUsage);
        ruleModifyCommand = new CLICommand("modify", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(ruleParams).build(), null).setShortUsage(ruleModifyUsage);
        ruleListCommand = new CLICommand("list", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).putAll(baseParams).put((Object)SORTBY_PARAM_NAME, (Object)new TextInputParameter(SORTBY_PARAM_NAME, supportedSortKeys + ", column names of supported fields.", false, null)).put((Object)SORTING_ORDER_PARAM_NAME, (Object)new TextInputParameter(SORTING_ORDER_PARAM_NAME, "<asc|desc>", false, null)).build(), null).setShortUsage(ruleListUsage);
        ruleInfoCommand = new CLICommand("info", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)RULENAME_PARAM_NAME, (Object)new TextInputParameter(RULENAME_PARAM_NAME, "rule name", true, null)).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).putAll(baseParams).build(), null).setShortUsage(ruleInfoUsage);
        ruleRemoveCommand = new CLICommand("remove", "", OffloadRuleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)RULENAME_PARAM_NAME, (Object)new TextInputParameter(RULENAME_PARAM_NAME, "rule name", true, null)).putAll(baseParams).build(), null).setShortUsage(ruleInfoUsage);
        ruleCommandsArray = new CLICommand[]{ruleCreateCommand, ruleModifyCommand, ruleRemoveCommand, ruleListCommand, ruleInfoCommand};
        ruleCommands = new CLICommand("rule", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{ruleCreateCommand, ruleModifyCommand, ruleRemoveCommand, ruleListCommand, ruleInfoCommand}).setShortUsage("rule [create|modify|remove|info|list]");
    }

    static enum OffloadRulePropertiesField {
        id,
        n,
        exp;

    }
}

