/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeRemoveCommand
extends CLIBaseClass
implements CLIInterface {
    public static final String FILTER_PARAM = "filter";
    public static final String NODES_PARAM = "nodes";
    public static final String HOSTIDS_PARAM = "hostids";
    public static final String ZK_CONNECTSTRING = "zkconnect";
    public static final String SERVICE_PARAM = "service";
    public static final String KEEP_DISKS_PARAM = "keepDisks";
    public static final String SERVICE_NFSSERVER_ARG = "nfsserver";
    public static final String SERVICE_FILESERVER_ARG = "fileserver";
    public static final int TIMEOUT_SERVER = 30000;
    public static final String SERVER_PATH = "/servers";
    public static long TIMEOUT = 3600000L;
    public static final Log LOG = LogFactory.getLog(NodeRemoveCommand.class);
    private String zkConnectString;
    public static final CLICommand nodeRemove = new CLICommand("remove", "remove node from service ", NodeRemoveCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"filter", (Object)new FilterInputParameter("filter", "node names filter. Please put it in quotes\"\"", false, null)).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).put((Object)"nodes", (Object)new TextInputParameter("nodes", "space-separated list of node names", false, null)).put((Object)"hostids", (Object)new TextInputParameter("hostids", "space-separated list of hostids", false, null)).put((Object)"service", (Object)new TextInputParameter("service", "Service to be removed. Either fileserver or nfsserver.", false, null)).put((Object)"keepDisks", (Object)new BooleanInputParameter("keepDisks", "Retain disks (default: false)", false, null).setInvisible(true)).build(), null);

    public NodeRemoveCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String service;
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(oh);
        this.zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
        if ((this.zkConnectString == null || this.zkConnectString.trim().isEmpty()) && this.isParamPresent(ZK_CONNECTSTRING)) {
            this.zkConnectString = this.getParamTextValue(ZK_CONNECTSTRING, 0);
        }
        if (this.zkConnectString == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "ZK Connect string is null. Check if ZK Connect string was provided correctly"));
            return co;
        }
        LOG.info((Object)("NodeRemove: zkConnectString = " + this.zkConnectString));
        ArrayList<String> nodeHostNames = new ArrayList();
        ArrayList<Long> nodeHostIds = new ArrayList<Long>();
        if (this.isParamPresent(NODES_PARAM)) {
            List nodeNames = this.input.getParameterByName(NODES_PARAM).getParamValues();
            for (String node : nodeNames) {
                Collections.addAll(nodeHostNames, node.split(" "));
            }
        } else if (this.isParamPresent(HOSTIDS_PARAM)) {
            List hostIdsList = this.input.getParameterByName(HOSTIDS_PARAM).getParamValues();
            for (String hostIds : hostIdsList) {
                for (String hostId : hostIds.split(" ")) {
                    try {
                        long value = new BigInteger(hostId.trim()).longValue();
                        nodeHostIds.add(value);
                    }
                    catch (Exception e) {
                        oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to parse hostid " + hostId.trim()));
                        return co;
                    }
                }
            }
        } else if (this.isParamPresent(FILTER_PARAM)) {
            String filter = this.getParamTextValue(FILTER_PARAM, 0);
            try {
                nodeHostNames = NodesCommonUtils.findFilteredNodeIps(filter, this.zkConnectString);
            }
            catch (CLIProcessingException e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to get nodes list. Cannot do an action on service"));
                return co;
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Invalid parameters provided: neither \"filter\", nor \"nodes\" was specified"));
            return co;
        }
        if ((nodeHostNames == null || nodeHostNames.isEmpty()) && (nodeHostIds == null || nodeHostIds.isEmpty())) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "No nodes match input parameters"));
            return co;
        }
        if (this.isParamPresent(SERVICE_PARAM) && !(service = this.getParamTextValue(SERVICE_PARAM, 0)).equalsIgnoreCase(SERVICE_FILESERVER_ARG) && !service.equalsIgnoreCase(SERVICE_NFSSERVER_ARG)) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "Unknown service"));
            return co;
        }
        this.processNodes(nodeHostNames, nodeHostIds, oh);
        return co;
    }

    private void processNodes(List<String> nodeHostNames, List<Long> nodeHostIds, CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        String msg;
        CLDBProto.FileServerRemoveResponse resp;
        byte[] replyData;
        CLDBProto.FileServerRemoveRequest req;
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return;
            }
        }
        CLDBProto.Service serviceId = CLDBProto.Service.SERVICE_ALL;
        if (this.isParamPresent(SERVICE_PARAM)) {
            String service = this.getParamTextValue(SERVICE_PARAM, 0);
            if (service.equalsIgnoreCase(SERVICE_FILESERVER_ARG)) {
                serviceId = CLDBProto.Service.SERVICE_FILESERVER;
            } else if (service.equalsIgnoreCase(SERVICE_NFSSERVER_ARG)) {
                serviceId = CLDBProto.Service.SERVICE_NFSSERVER;
            }
        }
        boolean keepDisks = false;
        if (this.isParamPresent(KEEP_DISKS_PARAM)) {
            keepDisks = this.getParamBooleanValue(KEEP_DISKS_PARAM, 0);
        }
        if (nodeHostNames != null) {
            for (int i = 0; i < nodeHostNames.size(); ++i) {
                String nodeName = nodeHostNames.get(i).trim();
                if (nodeName == null || nodeName.isEmpty()) continue;
                req = CLDBProto.FileServerRemoveRequest.newBuilder().setHostname(nodeName).setCreds(this.getUserCredentials()).setService(serviceId).setKeepDisks(keepDisks).build();
                LOG.info((Object)("NodeRemove: Attempting to remove node: " + nodeName));
                replyData = null;
                try {
                    replyData = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerRemoveProc.getNumber(), (MessageLite)req, CLDBProto.FileServerRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerRemoveProc.getNumber(), (MessageLite)req, CLDBProto.FileServerRemoveResponse.class);
                }
                catch (Exception e) {
                    throw new CLIProcessingException((Throwable)e);
                }
                if (replyData == null) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    continue;
                }
                try {
                    resp = CLDBProto.FileServerRemoveResponse.parseFrom((byte[])replyData);
                    if (resp.getStatus() == 0) {
                        LOG.info((Object)("NodeRemove: Removed node: " + nodeName));
                        continue;
                    }
                    msg = "node remove failed for node " + nodeName + ", Error: ";
                    switch (resp.getStatus()) {
                        case 2: {
                            msg = msg + "No such hostname, need valid hostname";
                            break;
                        }
                        case 16: {
                            msg = msg + Errno.toString((int)resp.getStatus()) + "\n\n1. Stop services on the node: " + nodeName + "\n2. Wait for 5 minutes until NODE_ALARM_NO_HEARTBEAT is raised for node: " + nodeName + "\n3. Run this operation again";
                            break;
                        }
                        default: {
                            msg = msg + Errno.toString((int)resp.getStatus());
                        }
                    }
                    if (resp.hasErrMsg()) {
                        msg = msg + "; " + resp.getErrMsg();
                    }
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
                    LOG.error((Object)msg);
                    continue;
                }
                catch (Exception e) {
                    LOG.error((Object)("node remove: failed with Exception " + e + " for server " + nodeName));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "node remove: failed with Exception " + e + " for server " + nodeName));
                }
            }
        }
        if (nodeHostIds != null) {
            for (Long hostId : nodeHostIds) {
                req = CLDBProto.FileServerRemoveRequest.newBuilder().setFileServerId(hostId.longValue()).setService(serviceId).setCreds(this.getUserCredentials()).setKeepDisks(keepDisks).build();
                LOG.info((Object)("NodeRemove: Attempting to remove hostid: " + hostId));
                replyData = null;
                try {
                    replyData = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerRemoveProc.getNumber(), (MessageLite)req, CLDBProto.FileServerRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerRemoveProc.getNumber(), (MessageLite)req, CLDBProto.FileServerRemoveResponse.class);
                }
                catch (Exception e) {
                    throw new CLIProcessingException((Throwable)e);
                }
                if (replyData == null) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    continue;
                }
                try {
                    resp = CLDBProto.FileServerRemoveResponse.parseFrom((byte[])replyData);
                    if (resp.getStatus() == 0) {
                        LOG.info((Object)("NodeRemove: Removed hostid: " + hostId));
                        continue;
                    }
                    msg = "node remove failed for hostid: " + hostId + ", Error: ";
                    switch (resp.getStatus()) {
                        case 2: {
                            msg = msg + "No such hostid, need valid hostid";
                            break;
                        }
                        case 16: {
                            msg = msg + Errno.toString((int)resp.getStatus()) + "\n\n1. Stop services on the node with ID: " + hostId + "\n2. Wait for 5 minutes until NODE_ALARM_NO_HEARTBEAT is raised for node: " + hostId + "\n3. Run this operation again";
                            break;
                        }
                        default: {
                            msg = msg + Errno.toString((int)resp.getStatus());
                        }
                    }
                    if (resp.hasErrMsg()) {
                        msg = msg + "; " + resp.getErrMsg();
                    }
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
                    LOG.error((Object)msg);
                }
                catch (Exception e) {
                    LOG.error((Object)("node remove: failed with Exception " + e + " for hostid " + hostId));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "node remove: failed with Exception " + e + " for hostid " + hostId));
                }
            }
        }
    }
}

