/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.DumpCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.table.TabletStats;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.CompressionHelper;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbreplicator;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DebugDbCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String DEBUGDB_FID_PARAM_NAME = "fid";
    private static final String DEBUGDB_HOST_PARAM_NAME = "host";
    private static final String DEBUGDB_PORT_PARAM_NAME = "port";
    private static final String DEBUGDB_TABLE_PARAM_NAME = "path";
    private static final String DEBUGDB_CID_PARAM_NAME = "cid";
    private static final String DEBUGDB_FTYPE_PARAM_NAME = "ftype";
    private static final String DEBUGDB_FTYPE_PARAM_DESC = "table|tabletmap|tablet|segmap|spillmap|spill";
    private static final String DEBUGDB_FROMGFSCK_PARAM_NAME = "fromGfsck";
    private static final String DEBUGDB_GFSCKREPAIR_PARAM_NAME = "repair";
    private static final String DEBUGDB_SKIPRANGECHECK_PARAM_NAME = "skiprangecheck";
    private static final String DEBUGDB_STARTKEY_PARAM_NAME = "startkey";
    private static final String DEBUGDB_ENDKEY_PARAM_NAME = "endkey";
    private static final String DEBUGDB_MAXKEYS_PARAM_NAME = "maxkeys";
    private static final String DEBUGDB_INDEXOFFSET_PARAM_NAME = "idxoffset";
    private static final String DEBUGDB_INDEXSIZE_PARAM_NAME = "idxsize";
    private static final String DEBUGDB_DUMPFULLKEYS_PARAM_NAME = "dumpfullkeys";
    private static final String DEBUGDB_KEYIDXVERSION_PARAM_NAME = "keyidxversion";
    private static final String DEBUGDB_DIRFID_PARAM_NAME = "dirfid";
    private static final String DEBUGDB_TABLEFID_PARAM_NAME = "tablefid";
    private static final String DEBUGDB_TABLENM_PARAM_NAME = "tablename";
    private static final String DEBUGDB_NTABLETS_PARAM_NAME = "ntablets";
    private static final String DEBUGDB_IPLIST_PARAM_NAME = "iplist";
    private static final String DEBUGDB_IP_PARAM_NAME = "ip";
    private static final String DEBUGDB_TRACEFILE_PARAM_NAME = "tracefile";
    private static final String DEBUGDB_FROMFS_PARAM_NAME = "fromfileserverid";
    private static final String DEBUGDB_TOFS_PARAM_NAME = "tofileserverid";
    private static final String DEBUGDB_CTYPE_PARAM_NAME = "type";
    private static final String DEBUGDB_CTYPE_PARAM_DESC = "default|postsplit";
    private static final String DEBUGDB_DUMPFILE_PARAM_NAME = "dumpfile";
    private static final String DEBUGDB_KVFID_PARAM_NAME = "kvfid";
    private static final String DEBUGDB_KEYTYPE_PARAM_NAME = "keytype";
    private static final String DEBUGDB_DELKEYS_PARAM_NAME = "delkeys";
    private static final String DEBUGDB_DELFIDS_PARAM_NAME = "delfids";
    private static final String DEBUGDB_USE_ALL_CDSCAN = "allreplica";
    public static final String MULTI_ARG_SEP = ",";
    public static final String COLUMN_SEP = ":";
    private static final String TABLE_TYPE_DEF_BIN = "binary";
    private static final String TABLE_TYPE_JSON = "json";
    private static final Logger LOG = Logger.getLogger(DumpCommands.class);
    private static Pattern printableStringName = Pattern.compile("\\p{Print}+");
    static String statUsage = "stat -fid fidx";
    static String cdscanUsage = "cdscan -fid fid -allreplica <true/false>";
    static String bmapUsage = "bmap -fid fid";
    static String dumpUsage = "dump -fid fid";
    static String dumpTableUsage = "dump -path tablePath";
    static String switchMasterUsage = "switchMaster -cid cid";
    static String checkTabletUsage = "checkTablet -fid fid -startkey key1 -endkey key2 -tracefile file";
    static String statTabletUsage = "statTablet -fid fid";
    static String partitionSplitsUsage = "partitionSplits -fid fid";
    static String rawScanUsage = "rawScan -fid tabletfid -startkey key1 -maxkeys maxkeys -dumpfile file";
    static String multiOpUsage = "multiOp -kvfid kvfid -keytype <int|string> -delkeys <keyList> -delfids <fidList>";
    static String getHostNamesUsage = "getHostNames -host gatewayIP -port gatewayPort";
    private static final int DefaultGatewayPort = 7660;
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    static final CLICommand dump = new CLICommand("dump", "usage : " + dumpUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).put((Object)"ftype", (Object)new TextInputParameter("ftype", "table|tabletmap|tablet|segmap|spillmap|spill", false, null).setInvisible(true)).put((Object)"startkey", (Object)new TextInputParameter("startkey", "startkey", false, null)).put((Object)"endkey", (Object)new TextInputParameter("endkey", "endkey", false, null)).put((Object)"maxkeys", (Object)new IntegerInputParameter("maxkeys", "maxkeys", false, null)).put((Object)"idxoffset", (Object)new IntegerInputParameter("idxoffset", "idxoffset", false, null)).put((Object)"idxsize", (Object)new IntegerInputParameter("idxsize", "idxsize", false, null)).put((Object)"dumpfullkeys", (Object)new BooleanInputParameter("dumpfullkeys", "dumpfullkeys", false, null)).put((Object)"keyidxversion", (Object)new IntegerInputParameter("keyidxversion", "keyidxversion", false, null)).build(), null).setShortUsage(dumpUsage);
    static final CLICommand dumpTable = new CLICommand("dumpTable", "usage : " + dumpTableUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).build(), null).setShortUsage(dumpTableUsage).setUsageInVisible(true);
    static final CLICommand rawScan = new CLICommand("rawScan", "usage : " + rawScanUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).put((Object)"startkey", (Object)new TextInputParameter("startkey", "startkey", true, null)).put((Object)"maxkeys", (Object)new IntegerInputParameter("maxkeys", "maxkeys", false, Integer.valueOf(1))).put((Object)"dumpfile", (Object)new TextInputParameter("dumpfile", "dumpfile", true, null)).build(), null).setShortUsage(rawScanUsage);
    static final CLICommand bmap = new CLICommand("bmap", "usage : " + bmapUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(bmapUsage);
    static final CLICommand cdscan = new CLICommand("cdscan", "usage : " + cdscanUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).put((Object)"allreplica", (Object)new BooleanInputParameter("allreplica", "allreplica", false, null).setInvisible(false)).build(), null).setShortUsage(cdscanUsage);
    static final CLICommand stat = new CLICommand("stat", "usage : " + statUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(statUsage).setUsageInVisible(true);
    static final CLICommand getHostNames = new CLICommand("getHostNames", "usage : " + getHostNamesUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"host", (Object)new TextInputParameter("host", "gatewayHost/ip", true, null)).put((Object)"port", (Object)new IntegerInputParameter("port", "gatewayPort", false, Integer.valueOf(7660))).build(), null).setShortUsage(getHostNamesUsage).setUsageInVisible(true);
    static final CLICommand multiOp = new CLICommand("multiOp", "usage : " + multiOpUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"kvfid", (Object)new TextInputParameter("kvfid", "kvfid", false, null)).put((Object)"delkeys", (Object)new TextInputParameter("delkeys", "keyList", false, null)).put((Object)"keytype", (Object)new TextInputParameter("keytype", "int|string", false, "int")).put((Object)"delfids", (Object)new TextInputParameter("delfids", "fidList", false, null)).build(), null).setShortUsage(multiOpUsage);
    static final CLICommand switchMaster = new CLICommand("switchMaster", "usage : " + switchMasterUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"cid", (Object)new IntegerInputParameter("cid", "cid", true, null)).build(), null).setShortUsage(switchMasterUsage).setUsageInVisible(true);
    static final CLICommand checkTablet = new CLICommand("checkTablet", "usage : " + dumpUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).put((Object)"startkey", (Object)new TextInputParameter("startkey", "startkey", false, null)).put((Object)"endkey", (Object)new TextInputParameter("endkey", "endkey", false, null)).put((Object)"fromGfsck", (Object)new BooleanInputParameter("fromGfsck", "fromGfsck", false, null).setInvisible(true)).put((Object)"repair", (Object)new BooleanInputParameter("repair", "repair", false, null).setInvisible(true)).put((Object)"skiprangecheck", (Object)new BooleanInputParameter("skiprangecheck", "skiprangecheck", false, null)).put((Object)"tracefile", (Object)new TextInputParameter("tracefile", "tracefile", true, null)).build(), null).setShortUsage(checkTabletUsage);
    static final CLICommand statTablet = new CLICommand("statTablet", "usage : " + statTabletUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(statTabletUsage);
    static final CLICommand partitionSplits = new CLICommand("partitionSplits", "usage : " + partitionSplitsUsage, DebugDbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(partitionSplitsUsage);
    String clusterName = null;

    public DebugDbCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void init() throws CLIProcessingException {
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Failed to initalize RPC");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in Rpc.initialize " + e));
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        if (!super.validateInput()) {
            return this.output;
        }
        this.clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase("dump")) {
                return this.dump();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("dumpTable")) {
                return this.dumpTable();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("getHostNames")) {
                return this.getHostNames();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("stat")) {
                return this.stat();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("cdscan")) {
                return this.cdscan();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("bmap")) {
                return this.bmap();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("switchmaster")) {
                return this.switchMaster();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("checkTablet")) {
                return this.checkTablet();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("statTablet")) {
                return this.statTablet();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("partitionSplits")) {
                return this.partitionSplits();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("rawScan")) {
                return this.rawScan();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("multiOp")) {
                return this.multiOp();
            }
            return new TextCommandOutput("DebugDb unknown sub-command".getBytes());
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private Common.FidMsg stringToFid(String s) {
        String[] temp = s.split("\\.");
        if (temp.length != 3) {
            return null;
        }
        int cid = Integer.parseInt(temp[0]);
        int cinum = Integer.parseInt(temp[1]);
        int uniq = Integer.parseInt(temp[2]);
        return Common.FidMsg.newBuilder().setCid(cid).setCinum(cinum).setUniq(uniq).build();
    }

    private String printableFid(Common.FidMsg f) {
        String cidStr = f.getCid() == -1 ? "<parentCID>." : f.getCid() + ".";
        return cidStr + f.getCinum() + "." + f.getUniq();
    }

    private String printableSubType(Common.FileType type, Common.FileSubType subtype) {
        String stype = subtype.toString();
        if (type == Common.FileType.FTKvstore) {
            if (subtype == Common.FileSubType.FSTKvTable) {
                stype = "FSTKvTable";
            } else if (subtype == Common.FileSubType.FSTKvTabletMap) {
                stype = "FSTKvTabletMap";
            } else if (subtype == Common.FileSubType.FSTKvSchema) {
                stype = "FSTKvSchema";
            } else if (subtype == Common.FileSubType.FSTKvTablet) {
                stype = "FSTKvTablet";
            } else if (subtype == Common.FileSubType.FSTKvSegMap) {
                stype = "FSTKvSegMap";
            } else if (subtype == Common.FileSubType.FSTKvSpillMap) {
                stype = "FSTKvSpillMap";
            } else if (subtype == Common.FileSubType.FSTKvKeyMap) {
                stype = "FSTKvKeyMap";
            } else if (subtype == Common.FileSubType.FSTKvIndexTable) {
                stype = "FSTKvIndexTable";
            }
        } else if (type == Common.FileType.FTRegular) {
            if (subtype == Common.FileSubType.FSTRegBucket) {
                stype = "FSTRegBucket";
            } else if (subtype == Common.FileSubType.FSTRegSortedBucket) {
                stype = "FSTRegSortedBucket";
            } else if (subtype == Common.FileSubType.FSTRegCF) {
                stype = "FSTRegCF";
            } else if (subtype == Common.FileSubType.FSTRegSpill) {
                stype = "FSTRegSpill";
            }
        }
        return stype;
    }

    private String printableKey(byte[] bytes) {
        return BinaryString.toStringBinary((byte[])bytes);
    }

    private String bytesToString(ByteString bs) {
        return BinaryString.toStringBinary((byte[])bs.toByteArray());
    }

    private ByteString binaryKeyToByteString(String raws) {
        byte[] bArr = BinaryString.toBytesBinary((String)raws);
        return ByteString.copyFrom((byte[])bArr);
    }

    private ByteString prepareVarKey(String raws) {
        return this.binaryKeyToByteString(raws);
    }

    private CommandOutput.OutputHierarchy.OutputNode formatDirEntry(MapRFileStatus d) {
        int version = this.getVersion();
        String childFid = d.getCid() + "." + d.getCinum() + "." + d.getUniq();
        String s = d.getPath().toString();
        int l = s.lastIndexOf(47);
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("name", (Object)s.substring(l + 1)));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)childFid));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isDir", d.isDir(), version));
        return dout;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatKeyMapEntry(Dbserver.KeyMapEntry ent) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        Object bs = null;
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("shared", ent.getSharedLen()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nonshared", ent.getNonsharedLen()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", ent.getValueLen()));
        if (ent.hasBlkOff()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("childblockoffset", ent.getBlkOff()));
        }
        if (ent.hasBlkSize()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("childblocksize", ent.getBlkSize()));
        }
        if (!ent.hasBlkOff() && !ent.hasBlkSize()) {
            try {
                Dbserver.SpillKeyEntry spillVal = ent.hasKvalue() ? ent.getKvalue() : Dbserver.SpillKeyEntry.parseFrom((ByteString)ent.getValue());
                if (spillVal.hasInlineValue()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlineValue", (Object)this.printableKey(spillVal.getInlineValue().toByteArray())));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlineValueSz", spillVal.getInlineValue().size()));
                }
                int cnt = spillVal.getValuesCount();
                for (int index = 0; index < cnt; ++index) {
                    CommandOutput.OutputHierarchy.OutputNode valueout = new CommandOutput.OutputHierarchy.OutputNode("familyData");
                    boolean addFamily = false;
                    Dbserver.SpillKeyEntry.FamilyValue fv = spillVal.getValues(index);
                    if (fv.hasId()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", fv.getId()));
                        addFamily = true;
                    }
                    if (fv.hasOffset()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", fv.getOffset()));
                        addFamily = true;
                    }
                    if (fv.hasLength()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", fv.getLength()));
                        addFamily = true;
                    }
                    if (fv.hasInlined()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlined", (Object)fv.getInlined()));
                        addFamily = true;
                    }
                    if (!addFamily) continue;
                    dout.addChild(valueout);
                }
            }
            catch (Throwable e) {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("error", (Object)"PARSE ERROR"));
            }
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(ent.getKey().toByteArray())));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", (Object)this.printableKey(ent.getValue().toByteArray())));
        return dout;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatKV(KVFormatType type, Fileserver.KvMsg kv) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        String ks = null;
        switch (type) {
            case TABLE: 
            case INDEX_TABLE: 
            case SCHEMA_INFO: 
            case TABLET: 
            case SEGMENT_MAP: 
            case TABLET_MAP: 
            case DEFER_MAP: 
            case SPILL: 
            case GENERIC_KV: {
                ByteString bs = kv.getKey().getVarKey();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(bs.toByteArray())));
                ks = bs.toStringUtf8();
                break;
            }
            case SPILL_MAP: {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", kv.getKey().getIntKey()));
                break;
            }
            default: {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)"UNKNOWN"));
            }
        }
        CommandOutput.OutputHierarchy.OutputNode vout = new CommandOutput.OutputHierarchy.OutputNode();
        switch (type) {
            case TABLE: 
            case INDEX_TABLE: {
                if (ks.equals(Dbserver.DBInternalDefaults.getDefaultInstance().getTableKeyForStats())) {
                    try {
                        Dbserver.TableBasicStats stats = Dbserver.TableBasicStats.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Rows", stats.getNumRows()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Size", stats.getSize()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Tablets", stats.getNumTablets()));
                    }
                    catch (Throwable e) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Rows", (Object)"UNKNOWN"));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Size", (Object)"UNKNOWN"));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Tablets", (Object)"UNKNOWN"));
                    }
                    break;
                }
                try {
                    Common.FidMsg f = Common.FidMsg.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)this.printableFid(f)));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)"UNKNOWN"));
                }
                break;
            }
            case SCHEMA_INFO: {
                try {
                    Dbserver.DBInternalDefaults dbi = Dbserver.DBInternalDefaults.getDefaultInstance();
                    if (ks == null) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                        break;
                    }
                    if (ks.startsWith(dbi.getColFamilyIdPrefix())) {
                        Dbserver.SchemaFamily sf = Dbserver.SchemaFamily.parseFrom((ByteString)kv.getValue());
                        if (sf.hasName()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cfname", (Object)sf.getName()));
                            break;
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cfname", (Object)"NONE"));
                        break;
                    }
                    if (ks.equals(dbi.getAttr())) {
                        Dbserver.TableAttr attr = Dbserver.TableAttr.parseFrom((ByteString)kv.getValue());
                        if (attr.hasAutoSplit()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:autoSplit", (Object)attr.getAutoSplit()));
                        }
                        if (attr.hasBulkLoad()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:bulkLoad", (Object)attr.getBulkLoad()));
                        }
                        if (attr.hasDeleteTTL()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:deleteTTL", attr.getDeleteTTL()));
                        }
                        if (attr.hasSyncReplTimeoutMillis()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:syncReplTimeoutMillis", attr.getSyncReplTimeoutMillis()));
                        }
                        if (attr.hasJson()) {
                            String tblType = attr.getJson() ? TABLE_TYPE_JSON : TABLE_TYPE_DEF_BIN;
                            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:tableType", (Object)tblType));
                        }
                        if (attr.hasRegionSizeMB()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:regionSizeMB", attr.getRegionSizeMB()));
                        }
                        if (attr.hasMaxValueSzInMemIndex()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:maxValueSzInMemIndex", attr.getMaxValueSzInMemIndex()));
                        }
                        if (attr.hasReclaimThreshPcntForPack()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:reclaimThreshPcntForPack", attr.getReclaimThreshPcntForPack()));
                        }
                        if (attr.hasDropLargeRows()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:dropLargeRows", (Object)attr.getDropLargeRows()));
                        }
                        if (attr.hasTtlCompaction()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:ttlCompaction", (Object)attr.getTtlCompaction()));
                        }
                        if (attr.hasTtlCompactionHrs()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:ttlCompactionHrs", attr.getTtlCompactionHrs()));
                        }
                        if (!attr.hasMetricsInterval()) break;
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:metricsInterval", (Object)attr.getMetricsInterval()));
                        break;
                    }
                    if (ks.startsWith(dbi.getReplIdxPrefix())) {
                        Dbserver.TableReplicaDesc rd = Dbserver.TableReplicaDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)rd.getClusterName()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("table", (Object)rd.getTablePath()));
                        byte[] uuid = rd.getTableUuid().toByteArray();
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString((byte[])uuid)));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("paused", (Object)rd.getIsPaused()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("synchronous", (Object)rd.getSynchronous()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", rd.getIdx()));
                        if (rd.getQualifiersCount() <= 0) break;
                        String famList = "";
                        int idx = 0;
                        for (Dbserver.Qualifier qual : rd.getQualifiersList()) {
                            if (qual.getQualifiersCount() > 0) {
                                for (ByteString bstr : qual.getQualifiersList()) {
                                    famList = idx == 0 ? qual.getFamily() + COLUMN_SEP + bstr.toStringUtf8() : famList + MULTI_ARG_SEP + qual.getFamily() + COLUMN_SEP + bstr.toStringUtf8();
                                    ++idx;
                                }
                                continue;
                            }
                            if (idx == 0) {
                                famList = String.valueOf(qual.getFamily());
                                ++idx;
                                continue;
                            }
                            famList = famList + MULTI_ARG_SEP + qual.getFamily();
                            ++idx;
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("columnfamilies", (Object)famList));
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)this.bytesToString(kv.getValue())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case TABLET: {
                try {
                    Dbserver.DBInternalDefaults dbi = Dbserver.DBInternalDefaults.getDefaultInstance();
                    if (ks == null) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForPMap())) {
                        CommandOutput.OutputHierarchy.OutputNode buckets;
                        Dbserver.PartitionMapEntry p = Dbserver.PartitionMapEntry.parseFrom((ByteString)kv.getValue());
                        if (p.hasSegmapFid()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("segfid", (Object)this.printableFid(p.getSegmapFid())));
                        } else {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("segfid", (Object)"NONE"));
                        }
                        if (p.getBucketFidsList().size() > 0) {
                            buckets = new CommandOutput.OutputHierarchy.OutputNode("bucketfids");
                            vout.addChild(buckets);
                            for (Common.FidMsg f : p.getBucketFidsList()) {
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)this.printableFid(f)));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isFrozen", (Object)p.getIsFrozen()));
                        if (p.getCidVNEntriesList().size() > 0) {
                            CommandOutput.OutputHierarchy.OutputNode cidVNs = new CommandOutput.OutputHierarchy.OutputNode("CidVNs");
                            vout.addChild(cidVNs);
                            for (Dbserver.CidVNEntry ce : p.getCidVNEntriesList()) {
                                cidVNs.addChild(new CommandOutput.OutputHierarchy.OutputNode("cid-minVN", (Object)(ce.getCid() + "-" + ce.getMinVN())));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inSplit", (Object)p.getInSplit()));
                        if (p.hasInImportBucket()) {
                            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inImportBucket", (Object)p.getInImportBucket()));
                        }
                        if (p.getBucketDescsList().size() > 0) {
                            buckets = new CommandOutput.OutputHierarchy.OutputNode("bucketdescs");
                            vout.addChild(buckets);
                            for (Dbserver.PartitionMapEntry.BucketDesc bd : p.getBucketDescsList()) {
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)this.printableFid(bd.getFid())));
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("needsRepl", (Object)bd.getNeedsRepl()));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("useBucketDesc", (Object)p.getUseBucketDesc()));
                        if (p.hasLastFlushedBucketFid()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastFlushedBucketFid", (Object)this.printableFid(p.getLastFlushedBucketFid())));
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numLogicalBlocks", p.getUsage().getNumLogicalBlocks()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numPhysicalBlocks", p.getUsage().getNumPhysicalBlocks()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", p.getUsage().getNumRows()));
                        if (p.getUsage().hasNumRowsWithDelete()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRowsWithDelete", p.getUsage().getNumRowsWithDelete()));
                        }
                        if (p.getUsage().hasNumRemoteBlocks()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRemoteBlocks", p.getUsage().getNumRemoteBlocks()));
                        }
                        if (p.getUsage().hasNumSpills()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSpills", p.getUsage().getNumSpills()));
                        }
                        if (!p.getUsage().hasNumSegments()) break;
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSegments", p.getUsage().getNumSegments()));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForSplit())) {
                        Dbserver.SplitDesc sd = Dbserver.SplitDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)this.printableFid(sd.getDstFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("moveRightHalf", (Object)sd.getMoveRightHalf()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("endGame", (Object)sd.getEndGame()));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForStartKey()) || ks.startsWith(dbi.getTabletKeyForEndKey())) break;
                    if (ks.startsWith(dbi.getTabletKeyForMerge())) {
                        Dbserver.MergeDesc md = Dbserver.MergeDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("peerFid", (Object)this.printableFid(md.getPeerFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isDest", (Object)md.getIsDest()));
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)this.bytesToString(kv.getValue())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case TABLET_MAP: {
                try {
                    Dbserver.TabletMapEntry t = Dbserver.TabletMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)this.printableFid(t.getTabletFid())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)"UNKNOWN"));
                }
                break;
            }
            case SEGMENT_MAP: {
                try {
                    Dbserver.SegmentMapEntry s = Dbserver.SegmentMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)this.printableFid(s.getFid())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)"UNKNOWN"));
                }
                break;
            }
            case SPILL_MAP: {
                try {
                    Dbserver.SpillMapEntry s = Dbserver.SpillMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)this.printableFid(s.getFid())));
                    if (s.hasSmeSize()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("smeSize", s.getSmeSize()));
                    }
                    if (s.hasMinVN()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("minVN", s.getMinVN()));
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyIdxOffset", s.getKeyIdxOffset()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyIdxLength", s.getKeyIdxLength()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ldbIdxLength", s.getLdbIdxLength()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("bloomBitsPerKey", s.getBloomBitsPerKey()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numLogicalBlocks", s.getUsage().getNumLogicalBlocks()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numPhysicalBlocks", s.getUsage().getNumPhysicalBlocks()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", s.getUsage().getNumRows()));
                    if (s.getUsage().hasNumRowsWithDelete()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRowsWithDelete", s.getUsage().getNumRowsWithDelete()));
                    }
                    if (s.getUsage().hasNumRemoteBlocks()) {
                        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRemoteBlocks", s.getUsage().getNumRemoteBlocks()));
                    }
                    if (s.getUsage().hasNumSpills()) {
                        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSpills", s.getUsage().getNumSpills()));
                    }
                    if (s.getUsage().hasNumSegments()) {
                        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSegments", s.getUsage().getNumSegments()));
                    }
                    CommandOutput.OutputHierarchy.OutputNode families = new CommandOutput.OutputHierarchy.OutputNode("families");
                    vout.addChild(families);
                    for (Dbserver.SpillMapEntry.FamilyEntry fe : s.getFamiliesList()) {
                        families.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", fe.getId()));
                        if (fe.hasOffset()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", fe.getOffset()));
                        }
                        if (fe.hasLength()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", fe.getLength()));
                        }
                        if (!fe.hasTimeRange()) continue;
                        Dbserver.TimeRange tr = fe.getTimeRange();
                        if (tr.hasMinTS()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("minTimeStamp", tr.getMinTS()));
                        }
                        if (!tr.hasMaxTS()) continue;
                        families.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxTimeStamp", tr.getMaxTS()));
                    }
                    break;
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyfid", (Object)"UNKNOWN"));
                    break;
                }
            }
            case DEFER_MAP: {
                try {
                    Dbserver.ReplBucketDesc b = Dbserver.ReplBucketDesc.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketFid", (Object)this.printableFid(b.getBucketFid())));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("tableFid", (Object)this.printableFid(b.getTableFid())));
                    if (b.getSendAfterList().size() != 0) {
                        CommandOutput.OutputHierarchy.OutputNode sendAfter = new CommandOutput.OutputHierarchy.OutputNode("sendAfter");
                        vout.addChild(sendAfter);
                        for (Common.FidMsg f : b.getSendAfterList()) {
                            sendAfter.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)this.printableFid(f)));
                        }
                    }
                    if (b.getSendBeforeList().size() != 0) {
                        CommandOutput.OutputHierarchy.OutputNode sendBefore = new CommandOutput.OutputHierarchy.OutputNode("sendBefore");
                        vout.addChild(sendBefore);
                        for (Common.FidMsg f : b.getSendBeforeList()) {
                            sendBefore.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)this.printableFid(f)));
                        }
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("flushed", (Object)b.getFlushed()));
                    CommandOutput.OutputHierarchy.OutputNode replicas = new CommandOutput.OutputHierarchy.OutputNode("replicas");
                    vout.addChild(replicas);
                    for (Dbserver.ReplBucketDesc.ReplicaInfo rs : b.getReplList()) {
                        replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicaIdx", rs.getReplicaIdx()));
                        if (rs.hasDoneTillOffset()) {
                            replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("doneTillOffset", rs.getDoneTillOffset()));
                        }
                        if (!rs.hasDone()) continue;
                        replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("done", (Object)rs.getDone()));
                    }
                    break;
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_FID_PARAM_NAME, (Object)"UNKNOWN"));
                    break;
                }
            }
            default: {
                vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
            }
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", (Object)vout));
        return dout;
    }

    private void dumpDir(Common.FidMsg fid, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MapRFileStatus[] dirents;
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            dirents = fs.scanDir(this.clusterName, "/.mapr::fid::" + this.printableFid(fid));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanDir failed"));
            return;
        }
        if (dirents == null) {
            return;
        }
        for (int i = 0; i < dirents.length; ++i) {
            out.addNode(this.formatDirEntry(dirents[i]));
        }
    }

    private void dumpRegKeyMap(Common.FidMsg fid, Integer idxoffset, Integer idxsize, boolean dumpFullKeys, int fmtVersion, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        long dbinding = this.getBindingForContainer(fid.getCid());
        Dbserver.KeyMapCookie cookie = null;
        LOG.info((Object)("Getting regular key-map with idxsize " + idxsize + " dumpFullKeys " + dumpFullKeys + " keyIdxVersion " + fmtVersion));
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return;
        }
        while (true) {
            Dbserver.TestScanResponse resp;
            Dbserver.TestScanRequest req = cookie == null ? Dbserver.TestScanRequest.newBuilder().setCmd(Dbserver.TestScanRequest.Cmd.KeyMapTable).setFid(fid).setOffset((long)idxoffset.intValue()).setSize(idxsize.intValue()).setCreds(this.getUserCredentials()).setDumpFullKeys(dumpFullKeys).setKeyIdxFmtVersion(fmtVersion).build() : Dbserver.TestScanRequest.newBuilder().setCmd(Dbserver.TestScanRequest.Cmd.KeyMapTable).setFid(fid).setOffset((long)idxoffset.intValue()).setSize(idxsize.intValue()).setCreds(this.getUserCredentials()).setKmapCookie(cookie).setDumpFullKeys(dumpFullKeys).setKeyIdxFmtVersion(fmtVersion).build();
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBServerProgramId.getNumber(), (int)Dbserver.DBProg.TestScanProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "testscan rpc failed"));
                    return;
                }
                resp = Dbserver.TestScanResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "TestScan failed, Error : " + Errno.toString((int)resp.getStatus())));
                    return;
                }
                for (Dbserver.KeyMapEntry kment : resp.getKmapentriesList()) {
                    out.addNode(this.formatKeyMapEntry(kment));
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing testscan command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return;
            }
            if (!resp.getHasMoreKeys()) break;
            LOG.info((Object)("Setting cookie as " + resp.getKmapCookie().getOffset()));
            cookie = resp.getKmapCookie();
        }
        LOG.info((Object)"Done with scan");
    }

    private void dumpKeyValues(Common.FidMsg fid, KVFormatType type, Fileserver.KvStoreKey start, Fileserver.KvStoreKey end, int maxkeys, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        byte[] byteArr;
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            byte[] kstart = null;
            if (start != null) {
                kstart = start.toByteArray();
            }
            byte[] kend = null;
            if (end != null) {
                kend = end.toByteArray();
            }
            byteArr = fs.scanKV(this.clusterName, "/.mapr::fid::" + this.printableFid(fid), kstart, kend, maxkeys);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanKV failed"));
            return;
        }
        if (byteArr == null) {
            return;
        }
        try {
            Fileserver.KvList kvlist = Fileserver.KvList.parseFrom((byte[])byteArr);
            for (Fileserver.KvMsg kvp : kvlist.getEntriesList()) {
                out.addNode(this.formatKV(type, kvp));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "failed to parse key-value list"));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandOutput getDumpFromFid(Common.FidMsg fid, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        KVFormatType ftype = KVFormatType.INVALID;
        if (this.isParamPresent(DEBUGDB_FTYPE_PARAM_NAME)) {
            String ftypestr = this.getParamTextValue(DEBUGDB_FTYPE_PARAM_NAME, 0);
            if (ftypestr.equalsIgnoreCase("table")) {
                ftype = KVFormatType.TABLE;
            } else if (ftypestr.equalsIgnoreCase("tabletmap")) {
                ftype = KVFormatType.TABLET_MAP;
            } else if (ftypestr.equalsIgnoreCase("tablet")) {
                ftype = KVFormatType.TABLET;
            } else if (ftypestr.equalsIgnoreCase("segmap")) {
                ftype = KVFormatType.SEGMENT_MAP;
            } else if (ftypestr.equalsIgnoreCase("spillmap")) {
                ftype = KVFormatType.SPILL_MAP;
            } else if (ftypestr.equalsIgnoreCase("spill")) {
                ftype = KVFormatType.SPILL;
            } else if (ftypestr.equalsIgnoreCase("dir")) {
                ftype = KVFormatType.DIR;
            } else if (ftypestr.equalsIgnoreCase("defermap")) {
                ftype = KVFormatType.DEFER_MAP;
            }
            if (ftype == KVFormatType.INVALID) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ftype " + ftypestr));
                this.output.setOutput(out);
                return this.output;
            }
        } else {
            Fileserver.GetattrResponse resp;
            long dbinding = this.getBindingForContainer(fid.getCid());
            if (dbinding == -1L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
                return this.output;
            }
            Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                    return this.output;
                }
                resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString((int)resp.getStatus())));
                    return this.output;
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing stat command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return this.output;
            }
            Common.FileType itype = resp.getAttr().getType();
            Common.FileSubType subtype = resp.getAttr().getSubtype();
            if (itype == Common.FileType.FTDirectory) {
                ftype = KVFormatType.DIR;
            } else if (itype == Common.FileType.FTRegular) {
                if (subtype != Common.FileSubType.FSTRegSpill) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot dump files of itype " + itype + " subtype " + subtype));
                    return this.output;
                }
                ftype = KVFormatType.SPILL;
            } else {
                if (itype != Common.FileType.FTKvstore) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot dump files of itype " + itype));
                    return this.output;
                }
                ftype = subtype == Common.FileSubType.FSTKvTable ? KVFormatType.TABLE : (subtype == Common.FileSubType.FSTKvTabletMap ? KVFormatType.TABLET_MAP : (subtype == Common.FileSubType.FSTKvSchema ? KVFormatType.SCHEMA_INFO : (subtype == Common.FileSubType.FSTKvTablet ? KVFormatType.TABLET : (subtype == Common.FileSubType.FSTKvSegMap ? KVFormatType.SEGMENT_MAP : (subtype == Common.FileSubType.FSTKvSpillMap ? KVFormatType.SPILL_MAP : (subtype == Common.FileSubType.FSTKvIndexTable ? KVFormatType.INDEX_TABLE : (fid.getCinum() == 22 ? KVFormatType.DEFER_MAP : KVFormatType.GENERIC_KV)))))));
            }
        }
        Fileserver.KvStoreKey kstart = null;
        if (this.isParamPresent(DEBUGDB_STARTKEY_PARAM_NAME)) {
            String kstartstr = this.getParamTextValue(DEBUGDB_STARTKEY_PARAM_NAME, 0);
            if (ftype == KVFormatType.SPILL_MAP) {
                kstart = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.UintKey).setIntKey(Integer.parseInt(kstartstr)).build();
            } else {
                ByteString bstr = this.prepareVarKey(kstartstr);
                if (bstr == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid startkey " + kstartstr));
                    this.output.setOutput(out);
                    return this.output;
                }
                kstart = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(bstr).build();
            }
        }
        Fileserver.KvStoreKey kend = null;
        if (this.isParamPresent(DEBUGDB_ENDKEY_PARAM_NAME)) {
            String kendstr = this.getParamTextValue(DEBUGDB_ENDKEY_PARAM_NAME, 0);
            if (ftype == KVFormatType.SPILL_MAP) {
                kend = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.UintKey).setIntKey(Integer.parseInt(kendstr)).build();
            } else {
                ByteString bstr = this.prepareVarKey(kendstr);
                if (bstr == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid endkey " + kendstr));
                    this.output.setOutput(out);
                    return this.output;
                }
                kend = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(bstr).build();
            }
        }
        int maxkeys = 0;
        if (this.isParamPresent(DEBUGDB_MAXKEYS_PARAM_NAME)) {
            maxkeys = this.getParamIntValue(DEBUGDB_MAXKEYS_PARAM_NAME, 0);
        }
        int idxoffset = 0;
        if (this.isParamPresent(DEBUGDB_INDEXOFFSET_PARAM_NAME)) {
            idxoffset = this.getParamIntValue(DEBUGDB_INDEXOFFSET_PARAM_NAME, 0);
        } else if (ftype == KVFormatType.SPILL) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Dump for Spill requires param idxoffset"));
            this.output.setOutput(out);
            return this.output;
        }
        int idxsize = 0;
        if (this.isParamPresent(DEBUGDB_INDEXSIZE_PARAM_NAME)) {
            idxsize = this.getParamIntValue(DEBUGDB_INDEXSIZE_PARAM_NAME, 0);
        } else if (ftype == KVFormatType.SPILL) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Dump for Spill requires param idxsize"));
            this.output.setOutput(out);
            return this.output;
        }
        if (ftype == KVFormatType.DIR) {
            this.dumpDir(fid, out);
            return this.output;
        }
        if (ftype != KVFormatType.SPILL) {
            this.dumpKeyValues(fid, ftype, kstart, kend, maxkeys, out);
            return this.output;
        }
        boolean dumpFullKeys = false;
        int idxVersion = 1;
        if (this.isParamPresent(DEBUGDB_DUMPFULLKEYS_PARAM_NAME)) {
            dumpFullKeys = this.getParamBooleanValue(DEBUGDB_DUMPFULLKEYS_PARAM_NAME, 0);
        }
        if (this.isParamPresent(DEBUGDB_KEYIDXVERSION_PARAM_NAME)) {
            idxVersion = this.getParamIntValue(DEBUGDB_KEYIDXVERSION_PARAM_NAME, 0);
        }
        this.dumpRegKeyMap(fid, idxoffset, idxsize, dumpFullKeys, idxVersion, out);
        return this.output;
    }

    private CommandOutput dump() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fidstr = this.getParamTextValue(DEBUGDB_FID_PARAM_NAME, 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        this.getDumpFromFid(fid, out);
        return output;
    }

    private void RawScanFromFid(Common.FidMsg fid, String dumpFile, ByteString bstr, int maxkeys, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        long dbinding = this.getBindingForContainer(fid.getCid());
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return;
        }
        Dbserver.RawSpillScanRequest req = Dbserver.RawSpillScanRequest.newBuilder().setFid(fid).setDumpFile(dumpFile).setStartKey(bstr).setMaxKeys(maxkeys).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBServerProgramId.getNumber(), (int)Dbserver.DBProg.RawSpillScanProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "testspillscan rpc failed"));
                return;
            }
            Dbserver.RawSpillScanResponse resp = Dbserver.RawSpillScanResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "RawSpillScan failed, Error : " + Errno.toString((int)resp.getStatus())));
                return;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing testspillscan command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
            return;
        }
    }

    private CommandOutput rawScan() throws CLIProcessingException {
        String kstartstr;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fidstr = this.getParamTextValue(DEBUGDB_FID_PARAM_NAME, 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        String dumpFile = this.getParamTextValue(DEBUGDB_DUMPFILE_PARAM_NAME, 0);
        ByteString bstr = ByteString.EMPTY;
        if (this.isParamPresent(DEBUGDB_STARTKEY_PARAM_NAME) && (bstr = this.prepareVarKey(kstartstr = this.getParamTextValue(DEBUGDB_STARTKEY_PARAM_NAME, 0))) == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid startkey " + kstartstr));
            output.setOutput(out);
            return output;
        }
        int maxkeys = 1;
        if (this.isParamPresent(DEBUGDB_MAXKEYS_PARAM_NAME)) {
            maxkeys = this.getParamIntValue(DEBUGDB_MAXKEYS_PARAM_NAME, 0);
        }
        this.RawScanFromFid(fid, dumpFile, bstr, maxkeys, out);
        return output;
    }

    private CommandOutput dumpTable() throws CLIProcessingException {
        List<Dbserver.TabletDesc> tablets;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String path = this.getParamTextValue(DEBUGDB_TABLE_PARAM_NAME, 0);
        TabletStats tabletStats = new TabletStats(path, this.getUserLoginId());
        int i = 0;
        while ((tablets = tabletStats.getTablets(out, i, 50)) != null && !tablets.isEmpty()) {
            for (Dbserver.TabletDesc tablet : tablets) {
                this.getDumpFromFid(tablet.getFid(), out);
            }
            i += 50;
        }
        return output;
    }

    private int getBindingsForContainer(int cid, boolean allBindings, ArrayList<Long> outBindings, ArrayList<String> hostNames) throws CLIProcessingException {
        block10: {
            CLDBProto.ContainerLookupRequest creq = CLDBProto.ContainerLookupRequest.newBuilder().addContainerId(cid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)creq, CLDBProto.ContainerLookupResponse.class);
                if (replyData == null) {
                    LOG.error((Object)"Couldn't connect to the CLDB service");
                    return -1;
                }
                CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) {
                    if (allBindings) {
                        for (Common.Server s : resp.getContainers(0).getAServersList()) {
                            int dbPort;
                            int dbHost = s.getIps(0).getHost();
                            long binding = Rpc.createBindingFor((int)dbHost, (int)(dbPort = s.getIps(0).getPort()), (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                            if (binding == -1L) {
                                return -1;
                            }
                            outBindings.add(binding);
                            hostNames.add(Util.intToIp((int)dbHost));
                        }
                    } else {
                        int dbPort;
                        Common.Server server = resp.getContainers(0).getMServer();
                        int dbHost = server.getIps(0).getHost();
                        long binding = Rpc.createBindingFor((int)dbHost, (int)(dbPort = server.getIps(0).getPort()), (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                        if (binding == -1L) {
                            return -1;
                        }
                        outBindings.add(binding);
                        hostNames.add(Util.intToIp((int)dbHost));
                    }
                    break block10;
                }
                LOG.error((Object)("Container lookup failed : Error " + Errno.toString((int)resp.getStatus())));
                return -1;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Container lookup failed");
                return -1;
            }
        }
        return 0;
    }

    private long getBindingForContainer(int cid) throws CLIProcessingException {
        int dbPort;
        int dbHost;
        CLDBProto.ContainerLookupRequest creq = CLDBProto.ContainerLookupRequest.newBuilder().addContainerId(cid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)creq, CLDBProto.ContainerLookupResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                return -1L;
            }
            CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                LOG.error((Object)("Container lookup failed : Error " + Errno.toString((int)resp.getStatus())));
                return -1L;
            }
            Common.Server server = resp.getContainers(0).getMServer();
            dbHost = server.getIps(0).getHost();
            dbPort = server.getIps(0).getPort();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Container lookup failed");
            return -1L;
        }
        return Rpc.createBindingFor((int)dbHost, (int)dbPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    private long getBindingForGateway(int gIp, int gPort) throws CLIProcessingException {
        if (gPort == 0) {
            gPort = 7660;
        }
        return Rpc.createBindingFor((int)gIp, (int)gPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    private CommandOutput bmap() throws CLIProcessingException {
        return this.cdscanrpc(true);
    }

    private CommandOutput cdscan() throws CLIProcessingException {
        return this.cdscanrpc(false);
    }

    private CommandOutput cdscanrpc(boolean printBlockMapOnly) throws CLIProcessingException {
        Common.FidMsg fid;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int version = this.getVersion();
        String fidstr = this.getParamTextValue(DEBUGDB_FID_PARAM_NAME, 0);
        Boolean dumpAllReplica = false;
        if (this.isParamPresent(DEBUGDB_USE_ALL_CDSCAN)) {
            dumpAllReplica = this.getParamBooleanValue(DEBUGDB_USE_ALL_CDSCAN, 0);
        }
        if ((fid = this.stringToFid(fidstr)) == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            return output;
        }
        ArrayList<Long> allBindings = new ArrayList<Long>();
        ArrayList<String> hostNames = new ArrayList<String>();
        long err = this.getBindingsForContainer(fid.getCid(), dumpAllReplica, allBindings, hostNames);
        if (err == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        Iterator<String> iter = hostNames.iterator();
        for (Long dbinding : allBindings) {
            ArrayList<Long> blockAddrList = new ArrayList<Long>();
            boolean readCompleteClusterData = false;
            long startId = 0L;
            String hostIP = iter.next();
            while (!readCompleteClusterData) {
                Fileserver.ScanFileClustersRequest req = Fileserver.ScanFileClustersRequest.newBuilder().setFid(fid).setCreds(this.getUserCredentials()).setIdx(startId).setIncludeAllBlocks(true).build();
                try {
                    byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.FileClusterScanProc.getNumber(), (MessageLite)req);
                    if (replyData == null) {
                        LOG.error((Object)"Got null reply from RPC");
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cdscan rpc failed"));
                        return output;
                    }
                    Fileserver.ScanFileClustersResponse resp = Fileserver.ScanFileClustersResponse.parseFrom((byte[])replyData);
                    if (resp.getStatus() == 0) {
                        int nClusters = resp.getClustersCount();
                        CommandOutput.OutputHierarchy.OutputNode topMetaNode = new CommandOutput.OutputHierarchy.OutputNode();
                        topMetaNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostName", (Object)hostIP));
                        out.addNode(topMetaNode);
                        for (int pos = 0; pos < nClusters; ++pos) {
                            Fileserver.ScanFileClustersResponse.Cluster fileCluster = resp.getClusters(pos);
                            if (printBlockMapOnly) {
                                int nBlocks = fileCluster.getBlocksCount();
                                for (int blockPos = 0; blockPos < nBlocks; ++blockPos) {
                                    blockAddrList.add(fileCluster.getBlocks(blockPos));
                                }
                            } else {
                                CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
                                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", fileCluster.getIdx()));
                                if (fileCluster.hasLVcdid()) {
                                    Fileserver.LocalVcdidMsg vMsg = fileCluster.getLVcdid();
                                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("lvcdid", (Object)(vMsg.getCycleId() + "." + vMsg.getSeqnum())));
                                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isPurged", (Object)fileCluster.getPurged()));
                                }
                                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("compressiontype", (Object)fileCluster.getCtype().toString()));
                                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("packed", (Object)fileCluster.getPacked()));
                                CommandOutput.OutputHierarchy.OutputNode blockOut = new CommandOutput.OutputHierarchy.OutputNode("blocks");
                                int nBlocks = fileCluster.getBlocksCount();
                                for (int blockPos = 0; blockPos < nBlocks; ++blockPos) {
                                    CommandOutput.OutputHierarchy.OutputNode blockAddrOut = new CommandOutput.OutputHierarchy.OutputNode("blockaddr", fileCluster.getBlocks(blockPos));
                                    blockOut.addChild(blockAddrOut);
                                }
                                dout.addChild(blockOut);
                                CommandOutput.OutputHierarchy.OutputNode fileClusterBrepOut = new CommandOutput.OutputHierarchy.OutputNode("brep");
                                int nBrep = fileCluster.getBrepCount();
                                for (int brepPos = 0; brepPos < nBrep; ++brepPos) {
                                    Fileserver.ScanFileClustersResponse.Cluster.BlockRep fileClusterBlockRep = fileCluster.getBrep(brepPos);
                                    CommandOutput.OutputHierarchy.OutputNode brepOut = new CommandOutput.OutputHierarchy.OutputNode("");
                                    long crcVal = fileClusterBlockRep.getCrc();
                                    if (crcVal < 0L) {
                                        crcVal = -crcVal;
                                        crcVal += 0x80000000L;
                                    }
                                    brepOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("crc", crcVal));
                                    brepOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("compressed", (Object)fileClusterBlockRep.getCompressed()));
                                    brepOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("notCompressible", (Object)fileClusterBlockRep.getNotCompressible()));
                                    brepOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("clen", fileClusterBlockRep.getClen()));
                                    fileClusterBrepOut.addChild(brepOut);
                                }
                                dout.addChild(fileClusterBrepOut);
                                out.addNode(dout);
                            }
                            startId = fileCluster.getIdx() + 1L;
                        }
                        readCompleteClusterData = !resp.getHasMore();
                        continue;
                    }
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "CdScan failed, Error : " + Errno.toString((int)resp.getStatus())));
                    return output;
                }
                catch (MaprSecurityException e) {
                    throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception processing cdscan command");
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
                    return output;
                }
            }
            if (!printBlockMapOnly) continue;
            int nTotalAddrs = blockAddrList.size();
            long prevBlock = -99L;
            long size = 0L;
            CommandOutput.OutputHierarchy.OutputNode count = null;
            CommandOutput.OutputHierarchy.OutputNode blockOut = null;
            for (int addrPos = 0; addrPos < nTotalAddrs; ++addrPos) {
                long curBlock = (Long)blockAddrList.get(addrPos);
                if (curBlock == prevBlock + 1L) {
                    ++size;
                } else {
                    if (size > 0L) {
                        count.setValue((Object)size);
                        out.addNode(blockOut);
                    }
                    blockOut = new CommandOutput.OutputHierarchy.OutputNode("block");
                    blockOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("addr", curBlock));
                    count = new CommandOutput.OutputHierarchy.OutputNode("count");
                    blockOut.addChild(count);
                    size = 1L;
                }
                prevBlock = curBlock;
            }
            if (size <= 0L) continue;
            count.setValue((Object)size);
            out.addNode(blockOut);
        }
        return output;
    }

    private CommandOutput stat() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int version = this.getVersion();
        String fidstr = this.getParamTextValue(DEBUGDB_FID_PARAM_NAME, 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        ArrayList<Long> outBindings = new ArrayList<Long>();
        ArrayList<String> hostNames = new ArrayList<String>();
        long err = this.getBindingsForContainer(fid.getCid(), true, outBindings, hostNames);
        if (err == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        Iterator<String> iter = hostNames.iterator();
        for (Long dbinding : outBindings) {
            Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    LOG.error((Object)"Got null reply from RPC");
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                    return output;
                }
                Fileserver.GetattrResponse resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
                CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
                if (resp.getStatus() == 0) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEBUGDB_CTYPE_PARAM_NAME, (Object)resp.getAttr().getType(), version));
                    String subtype = this.printableSubType(resp.getAttr().getType(), resp.getAttr().getSubtype());
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("subtype", (Object)subtype));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("parent", (Object)this.printableFid(resp.getAttr().getParent())));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("size", resp.getAttr().getSize()));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nblocks", resp.getAttr().getNblocks()));
                    String cs = "off";
                    if (resp.getAttr().getCanCompress()) {
                        cs = CompressionHelper.getCompressionName((Common.FileCompressionType)Common.FileCompressionType.valueOf((int)resp.getAttr().getCompressorType()));
                    }
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("compression", (Object)cs));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteFlags", (Object)resp.getAttr().getDeleteFlags()));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("atime", resp.getAttr().getAtime().getSec()));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mtime", resp.getAttr().getMtime().getSec()));
                    int mode = resp.getAttr().getMode();
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mode", (Object)Integer.toOctalString(mode)));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("audit", (Object)resp.getAttr().getAudit()));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("uid", resp.getAttr().getUid()));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("gid", resp.getAttr().getGid()));
                    if (resp.getAttr().hasVersion()) {
                        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", resp.getAttr().getVersion()));
                    }
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("networkencryption", (Object)resp.getAttr().getWireSecurityEnabled()));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostname", (Object)iter.next()));
                    out.addNode(dout);
                    continue;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString((int)resp.getStatus())));
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing stat command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
            }
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput getHostNames() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String ipStr = this.getParamTextValue(DEBUGDB_HOST_PARAM_NAME, 0);
        Common.IPAddress gatewayIp = this.buildIPFromString(ipStr);
        if (gatewayIp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid gateway host " + ipStr));
            output.setOutput(out);
            return output;
        }
        int gatewayPort = this.getParamIntValue(DEBUGDB_PORT_PARAM_NAME, 0);
        long dbinding = this.getBindingForGateway(gatewayIp.getHost(), gatewayPort);
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Gateway connect failed"));
            return output;
        }
        Dbreplicator.GetHostNamesRequest req = Dbreplicator.GetHostNamesRequest.newBuilder().setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBReplicatorServerProgramId.getNumber(), (int)Dbreplicator.DBReplicatorProg.GetHostNamesProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "gethostnames rpc failed"));
                return output;
            }
            Dbreplicator.GetHostNamesResponse resp = Dbreplicator.GetHostNamesResponse.parseFrom((byte[])replyData);
            CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
            if (resp.getStatus() == 0) {
                for (String name : resp.getNamesList()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("HostNames", (Object)name));
                }
                out.addNode(dout);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetHostNames failed, Error : " + Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing getHostNames command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
        }
        output.setOutput(out);
        return output;
    }

    private Fileserver.KvMsg keyToKvMsg(String key, boolean keyIsStringType) throws CLIProcessingException {
        Fileserver.KvStoreKey toDelKey;
        if (keyIsStringType) {
            ByteString bs = this.prepareVarKey(key);
            toDelKey = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(bs).build();
        } else {
            int kval = Integer.parseInt(key);
            toDelKey = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.UintKey).setIntKey(kval).build();
        }
        return Fileserver.KvMsg.newBuilder().setKey(toDelKey).build();
    }

    private CommandOutput multiOp() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        boolean done = false;
        int cid = 0;
        Common.FidMsg kvfid = null;
        Fileserver.KvList.Builder delKeys = null;
        ArrayList<Fileserver.DeleteAsyncEntry> delFids = null;
        if (this.isParamPresent(DEBUGDB_KVFID_PARAM_NAME)) {
            String fidstr = this.getParamTextValue(DEBUGDB_KVFID_PARAM_NAME, 0);
            kvfid = this.stringToFid(fidstr);
            if (kvfid == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid kvfid " + fidstr));
                output.setOutput(out);
                return output;
            }
            cid = kvfid.getCid();
        }
        boolean keyIsStringType = false;
        if (this.isParamPresent(DEBUGDB_KEYTYPE_PARAM_NAME)) {
            String keytype = this.getParamTextValue(DEBUGDB_KEYTYPE_PARAM_NAME, 0);
            if (keytype.equalsIgnoreCase("int")) {
                keyIsStringType = false;
            } else if (keytype.equalsIgnoreCase("string") || keytype.equalsIgnoreCase("bytes")) {
                keyIsStringType = true;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid keyType " + keytype));
                output.setOutput(out);
                return output;
            }
        }
        if (this.isParamPresent(DEBUGDB_DELKEYS_PARAM_NAME)) {
            if (kvfid == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "keylist present, but no kvfid specified"));
                output.setOutput(out);
                return output;
            }
            delKeys = Fileserver.KvList.newBuilder();
            String klist = this.getParamTextValue(DEBUGDB_DELKEYS_PARAM_NAME, 0);
            if (klist.contains(MULTI_ARG_SEP)) {
                String[] ks;
                for (String kone : ks = klist.split(MULTI_ARG_SEP)) {
                    delKeys.addEntries(this.keyToKvMsg(kone, keyIsStringType));
                }
            } else {
                delKeys.addEntries(this.keyToKvMsg(klist, keyIsStringType));
            }
        }
        if (this.isParamPresent(DEBUGDB_DELFIDS_PARAM_NAME)) {
            delFids = new ArrayList<Fileserver.DeleteAsyncEntry>();
            String flist = this.getParamTextValue(DEBUGDB_DELFIDS_PARAM_NAME, 0);
            if (flist.contains(MULTI_ARG_SEP)) {
                String[] fs;
                for (String fone : fs = flist.split(MULTI_ARG_SEP)) {
                    Common.FidMsg fid = this.stringToFid(fone);
                    if (fid == null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fone));
                        output.setOutput(out);
                        return output;
                    }
                    if (cid == 0) {
                        cid = fid.getCid();
                    }
                    Fileserver.DeleteAsyncEntry del = Fileserver.DeleteAsyncEntry.newBuilder().setFid(fid).setDelay(false).build();
                    delFids.add(del);
                }
            } else {
                Common.FidMsg fid = this.stringToFid(flist);
                if (fid == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + flist));
                    output.setOutput(out);
                    return output;
                }
                if (cid == 0) {
                    cid = fid.getCid();
                }
                Fileserver.DeleteAsyncEntry del = Fileserver.DeleteAsyncEntry.newBuilder().setFid(fid).setDelay(false).build();
                delFids.add(del);
            }
        }
        if (delKeys == null && delFids == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "both delkeys and dellist are empty"));
            output.setOutput(out);
            return output;
        }
        long dbbinding = this.getBindingForContainer(cid);
        if (dbbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container " + cid + " lookup failed"));
            return output;
        }
        Fileserver.KvStoreMultiOpDBRequest.Builder req = Fileserver.KvStoreMultiOpDBRequest.newBuilder();
        if (kvfid != null) {
            req.setFid(kvfid);
        }
        if (delKeys != null) {
            req.setDelList(delKeys);
        }
        if (delFids != null) {
            for (Fileserver.DeleteAsyncEntry dae : delFids) {
                req.addDeleteAsyncs(dae);
            }
        }
        req.setCreds(this.getUserCredentials());
        try {
            byte[] replyData = Rpc.sendRequest((long)dbbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.KvStoreMultiOpDBProc.getNumber(), (MessageLite)req.build());
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "MultiOpDB failed"));
                return output;
            }
            Fileserver.KvStoreMultiOpDBResponse resp = Fileserver.KvStoreMultiOpDBResponse.parseFrom((byte[])replyData);
            CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
            if (resp.getStatus() == 0) {
                done = true;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "MultiOpDB failed, Error : " + Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing MultiOp command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "fs rpc failed"));
        }
        if (done) {
            return new TextCommandOutput("MultiOp done".getBytes());
        }
        return output;
    }

    private CommandOutput switchMaster() throws CLIProcessingException {
        String spid;
        byte[] replyData;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int cid = this.getParamIntValue(DEBUGDB_CID_PARAM_NAME, 0);
        CLDBProto.ContainerLookupRequest creq = CLDBProto.ContainerLookupRequest.newBuilder().addContainerId(cid).setCreds(this.getUserCredentials()).build();
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)creq, CLDBProto.ContainerLookupResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
                return output;
            }
            CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Container lookup failed, Error : " + Errno.toString((int)resp.getStatus())));
                return output;
            }
            spid = resp.getContainers(0).getMServer().getSpInfo().getSpId();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Container lookup failed");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
            return output;
        }
        boolean done = false;
        CLDBProto.ContainerSwitchMasterRequest req = CLDBProto.ContainerSwitchMasterRequest.newBuilder().setCid(cid).setMasterSpid(spid).setCreds(this.getUserCredentials()).build();
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerSwitchMasterProc.getNumber(), (MessageLite)req, CLDBProto.ContainerSwitchMasterResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
                return output;
            }
            CLDBProto.ContainerSwitchMasterResponse resp = CLDBProto.ContainerSwitchMasterResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() == 0) {
                done = true;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "switchMaster failed, Error : " + Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Container switchMaster failed");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "cldb rpc failed"));
            return output;
        }
        if (done) {
            return new TextCommandOutput("Switched master".getBytes());
        }
        return output;
    }

    private Common.IPAddress buildIPFromString(String ipstr) {
        if (ipstr.equalsIgnoreCase("localhost") || ipstr.equalsIgnoreCase("127.0.0.1")) {
            ipstr = "127.0.0.1";
        } else {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(ipstr));
            if (ips.isEmpty()) {
                return null;
            }
            ipstr = ips.get(0);
        }
        int host = Util.ipToInt((String)ipstr);
        Common.IPAddress server = Common.IPAddress.newBuilder().setHost(host).build();
        return server;
    }

    private Fileserver.MiniSIndexInfo extractSIndexInfoFromTableReplicaDesc(Common.FidMsg schemaFid, Fileserver.KvMsg replicaDescKvMsg, Common.FidMsg siFid, CommandOutput.OutputHierarchy out) {
        if (replicaDescKvMsg.getKey().getVarKey().toStringUtf8().startsWith(Dbserver.DBInternalDefaults.getDefaultInstance().getReplIdxPrefix())) {
            Dbserver.TableReplicaDesc tableReplicaDesc = null;
            try {
                tableReplicaDesc = Dbserver.TableReplicaDesc.parseFrom((ByteString)replicaDescKvMsg.getValue());
            }
            catch (InvalidProtocolBufferException ipbe) {
                tableReplicaDesc = null;
            }
            if (tableReplicaDesc == null) {
                LOG.error((Object)("Bad table replica descriptor in schema fid " + this.printableFid(schemaFid)));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Bad table replica descriptor in schema fid " + this.printableFid(schemaFid)));
            } else if (tableReplicaDesc.getReplicaClassName().equals(Dbserver.DBInternalDefaults.getDefaultInstance().getReplicaClassNameForSIndex())) {
                Fileserver.HashIndexInfo hashingInfo;
                Dbserver.SIndexInfo sIndexInfo = tableReplicaDesc.getSiInfo();
                Common.FidMsg replicaDescSIFid = sIndexInfo.getIndexFid();
                if (!Util.compareFidMsg((Common.FidMsg)replicaDescSIFid, (Common.FidMsg)siFid)) {
                    return null;
                }
                int hashRange = 0;
                if (sIndexInfo.hasHashingInfo() && (hashingInfo = sIndexInfo.getHashingInfo()).getHashConfigCount() > 0) {
                    hashRange = hashingInfo.getHashConfig(0).getNumPartitions();
                }
                Fileserver.MiniSIndexInfo.Builder miniSIndexInfo = Fileserver.MiniSIndexInfo.newBuilder();
                miniSIndexInfo.setHashScheme(Fileserver.HashIndexInfo.Scheme.MURMUR_v2);
                miniSIndexInfo.setHashSize(2);
                miniSIndexInfo.setHashRange(hashRange);
                miniSIndexInfo.setReleaseVersion(sIndexInfo.getVersion() == Dbserver.SIndexInfo.Version.v6dot0 ? 0 : 1);
                for (Dbserver.SIndexInfo.FieldInfo fi : tableReplicaDesc.getSiInfo().getIndexedFieldsList()) {
                    miniSIndexInfo.addDescendingOrder(fi.getSortOrder() == Dbserver.SIndexInfo.SIndexOrder.DESC);
                }
                return miniSIndexInfo.build();
            }
        }
        return null;
    }

    private Fileserver.MiniSIndexInfo processTabletParent(long dbinding, Common.FidMsg tabletParentFid, boolean fromGfsck, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        byte[] byteArr;
        Fileserver.KvStoreKey kStart;
        Fileserver.GetattrResponse resp;
        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(tabletParentFid).setCreds(this.getUserCredentials()).setFromGfsck(fromGfsck).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                return null;
            }
            resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString((int)resp.getStatus())));
                return null;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"checkTablet : Exception processing GetAttr RPC to extract table fid");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
            return null;
        }
        if (resp.getAttr().getSubtype() != Common.FileSubType.FSTKvIndexTable) {
            return null;
        }
        Common.FidMsg pr = resp.getAttr().getParent();
        Common.FidMsg primary = Common.FidMsg.newBuilder().setCid(tabletParentFid.getCid()).setCinum(pr.getCinum()).setUniq(pr.getUniq()).build();
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        Common.FidMsg schemaFid = null;
        try {
            kStart = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(Dbserver.DBInternalDefaults.getDefaultInstance().getTableKeyForSchemaBytes()).build();
            byteArr = fs.scanKV(this.clusterName, "/.mapr::fid::" + this.printableFid(primary), kStart.toByteArray(), null, 1, fromGfsck);
            Fileserver.KvList kvList = Fileserver.KvList.parseFrom((byte[])byteArr);
            Fileserver.KvMsg msg = kvList.getEntries(0);
            Common.FidMsg f = Common.FidMsg.parseFrom((ByteString)msg.getValue());
            Common.FidMsg.Builder sFid = Common.FidMsg.newBuilder();
            schemaFid = sFid.setCid(primary.getCid()).setCinum(f.getCinum()).setUniq(f.getUniq()).build();
            if (schemaFid != null) {
                LOG.info((Object)("Schema fid for table " + this.printableFid(primary) + " is " + this.printableFid(schemaFid)));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanKV failed to get schemaFid."));
            return null;
        }
        try {
            kStart = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(Dbserver.DBInternalDefaults.getDefaultInstance().getReplIdxPrefixBytes()).build();
            Fileserver.KvStoreKey kEnd = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(Dbserver.DBInternalDefaults.getDefaultInstance().getReplIdxEOSBytes()).build();
            byteArr = fs.scanKV(this.clusterName, "/.mapr::fid::" + this.printableFid(schemaFid), kStart.toByteArray(), kEnd.toByteArray(), 0, fromGfsck);
            Fileserver.MiniSIndexInfo msii = null;
            Fileserver.KvList kvList = Fileserver.KvList.parseFrom((byte[])byteArr);
            for (Fileserver.KvMsg msg : kvList.getEntriesList()) {
                msii = this.extractSIndexInfoFromTableReplicaDesc(schemaFid, msg, tabletParentFid, out);
                if (!out.getOutputErrors().isEmpty()) {
                    return null;
                }
                if (msii == null) continue;
                return msii;
            }
            if (msii == null) {
                LOG.info((Object)("Warning: no replica descritor was found for the Seconadry Index " + this.printableFid(tabletParentFid) + ". Proceeding with non secondary index checks."));
                System.out.println("Warning: no replica descritor was found for the Seconadry Index " + this.printableFid(tabletParentFid) + ". Proceeding with non secondary index checks.");
            }
            return msii;
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanKV failed to get tabletype."));
            return null;
        }
    }

    private CommandOutput checkTablet() throws CLIProcessingException {
        Fileserver.KvMsg msg;
        byte[] byteArr;
        Fileserver.GetattrResponse resp;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fidstr = this.getParamTextValue(DEBUGDB_FID_PARAM_NAME, 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        boolean fromGfsck = false;
        if (this.isParamPresent(DEBUGDB_FROMGFSCK_PARAM_NAME)) {
            fromGfsck = this.getParamBooleanValue(DEBUGDB_FROMGFSCK_PARAM_NAME, 0);
        }
        boolean isRepair = false;
        if (this.isParamPresent(DEBUGDB_GFSCKREPAIR_PARAM_NAME) && (isRepair = this.getParamBooleanValue(DEBUGDB_GFSCKREPAIR_PARAM_NAME, 0))) {
            fromGfsck = true;
        }
        boolean skipRangeCheck = false;
        if (this.isParamPresent(DEBUGDB_SKIPRANGECHECK_PARAM_NAME)) {
            skipRangeCheck = this.getParamBooleanValue(DEBUGDB_SKIPRANGECHECK_PARAM_NAME, 0);
        }
        ByteString bstart = null;
        if (this.isParamPresent(DEBUGDB_STARTKEY_PARAM_NAME)) {
            String kstartstr = this.getParamTextValue(DEBUGDB_STARTKEY_PARAM_NAME, 0);
            bstart = this.prepareVarKey(kstartstr);
            if (bstart == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid startkey " + kstartstr));
                output.setOutput(out);
                return output;
            }
        } else {
            bstart = ByteString.EMPTY;
        }
        ByteString bend = null;
        if (this.isParamPresent(DEBUGDB_ENDKEY_PARAM_NAME)) {
            String kendstr = this.getParamTextValue(DEBUGDB_ENDKEY_PARAM_NAME, 0);
            bend = this.prepareVarKey(kendstr);
            if (bend == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid endkey " + kendstr));
                output.setOutput(out);
                return output;
            }
        } else {
            bend = ByteString.EMPTY;
        }
        String traceFile = this.getParamTextValue(DEBUGDB_TRACEFILE_PARAM_NAME, 0);
        long dbinding = this.getBindingForContainer(fid.getCid());
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).setFromGfsck(fromGfsck).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                return output;
            }
            resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString((int)resp.getStatus())));
                return output;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"checkTablet : Exception processing GetAttr RPC to extract table fid");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
            return output;
        }
        Common.FidMsg parent = resp.getAttr().getParent();
        Fileserver.MiniSIndexInfo msii = this.processTabletParent(dbinding, parent, fromGfsck, out);
        if (!out.getOutputErrors().isEmpty()) {
            return output;
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        Common.FidMsg schemaFid = null;
        try {
            Fileserver.KvStoreKey kStart = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(Dbserver.DBInternalDefaults.getDefaultInstance().getTableKeyForSchemaBytes()).build();
            byteArr = fs.scanKV(this.clusterName, "/.mapr::fid::" + this.printableFid(parent), kStart.toByteArray(), null, 1, fromGfsck);
            Fileserver.KvList kvList = Fileserver.KvList.parseFrom((byte[])byteArr);
            Common.FidMsg f = null;
            msg = kvList.getEntries(0);
            f = Common.FidMsg.parseFrom((ByteString)msg.getValue());
            Common.FidMsg.Builder sFid = Common.FidMsg.newBuilder();
            schemaFid = sFid.setCid(parent.getCid()).setCinum(f.getCinum()).setUniq(f.getUniq()).build();
            if (schemaFid != null) {
                LOG.info((Object)("Schema fid for tablet " + fidstr + " is " + this.printableFid(schemaFid)));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanKV failed to get schemaFid."));
            return null;
        }
        Fileserver.MiniInodeMsg.TableType tableType = Fileserver.MiniInodeMsg.TableType.BINARY;
        try {
            Fileserver.KvStoreKey kStart = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(Dbserver.DBInternalDefaults.getDefaultInstance().getAttrBytes()).build();
            byteArr = fs.scanKV(this.clusterName, "/.mapr::fid::" + this.printableFid(schemaFid), kStart.toByteArray(), null, 1, fromGfsck);
            Fileserver.KvList kvList = Fileserver.KvList.parseFrom((byte[])byteArr);
            msg = kvList.getEntries(0);
            Dbserver.TableAttr attr = Dbserver.TableAttr.parseFrom((ByteString)msg.getValue());
            if (attr.hasJson()) {
                tableType = attr.getJson() ? Fileserver.MiniInodeMsg.TableType.JSON : Fileserver.MiniInodeMsg.TableType.BINARY;
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanKV failed to get tabletype."));
            return null;
        }
        long fsinding = this.getBindingForContainer(fid.getCid());
        if (fsinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        boolean done = false;
        Fileserver.TabletRangeCheckRequest.Builder tabletRangeCheckRequestBuilder = Fileserver.TabletRangeCheckRequest.newBuilder();
        if (msii != null) {
            tabletRangeCheckRequestBuilder.setMiniSIndexInfo(msii);
        }
        Fileserver.TabletRangeCheckRequest treq = tabletRangeCheckRequestBuilder.setTabletFid(fid).setCreds(this.getUserCredentials()).setStartKey(bstart).setEndKey(bend).setTraceFile(traceFile).setIsGfsckRepair(isRepair).setFromGfsck(fromGfsck).setTableType(tableType).setRangeIsPassed(!skipRangeCheck).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)fsinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.TabletRangeCheckProc.getNumber(), (MessageLite)treq);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "fs rpc failed"));
                return output;
            }
            Fileserver.TabletRangeCheckResponse tresp = Fileserver.TabletRangeCheckResponse.parseFrom((byte[])replyData);
            if (tresp.getStatus() == 0) {
                done = true;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(tresp.getStatus(), "TabletRangeCheck failed, Error : " + Errno.toString((int)tresp.getStatus())));
            }
            output.setOutput(out);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing RangeCheck command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "fs rpc failed"));
        }
        if (done) {
            System.out.println("TabletRangeCheck done");
        }
        return output;
    }

    private CommandOutput statTablet() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fidstr = this.getParamTextValue(DEBUGDB_FID_PARAM_NAME, 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        long dbinding = this.getBindingForContainer(fid.getCid());
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        Dbserver.TabletStatRequest treq = Dbserver.TabletStatRequest.newBuilder().setTablet(fid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBServerProgramId.getNumber(), (int)Dbserver.DBProg.TabletStatProc.getNumber(), (MessageLite)treq);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
                return output;
            }
            Dbserver.TabletStatResponse tresp = Dbserver.TabletStatResponse.parseFrom((byte[])replyData);
            if (tresp.getStatus() == 0) {
                CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
                Dbserver.SpaceUsage usage = tresp.getUsage();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numPhysicalBlocks", usage.getNumPhysicalBlocks()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numLogicalBlocks", usage.getNumLogicalBlocks()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", usage.getNumRows()));
                if (usage.hasNumRowsWithDelete()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRowsWithDelete", usage.getNumRowsWithDelete()));
                }
                if (usage.hasNumRemoteBlocks()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRemoteBlocks", usage.getNumRemoteBlocks()));
                }
                if (usage.hasNumSpills()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSpills", usage.getNumSpills()));
                }
                if (usage.hasNumSegments()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSegments", usage.getNumSegments()));
                }
                out.addNode(dout);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(tresp.getStatus(), "TabletStat failed, Error : " + Errno.toString((int)tresp.getStatus())));
            }
            output.setOutput(out);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing compact command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
        }
        return output;
    }

    private CommandOutput partitionSplits() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fidstr = this.getParamTextValue(DEBUGDB_FID_PARAM_NAME, 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        long dbinding = this.getBindingForContainer(fid.getCid());
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        Dbserver.GetPartitionSplitsRequest treq = Dbserver.GetPartitionSplitsRequest.newBuilder().setTablet(fid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBServerProgramId.getNumber(), (int)Dbserver.DBProg.GetPartitionSplitsProc.getNumber(), (MessageLite)treq);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
                return output;
            }
            Dbserver.GetPartitionSplitsResponse tresp = Dbserver.GetPartitionSplitsResponse.parseFrom((byte[])replyData);
            if (tresp.getStatus() == 0) {
                for (ByteString bs : tresp.getStartKeysList()) {
                    CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("startKey", (Object)this.printableKey(bs.toByteArray())));
                    out.addNode(dout);
                }
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(tresp.getStatus(), "GetPartitionSplitsProc failed, Error : " + Errno.toString((int)tresp.getStatus())));
            }
            output.setOutput(out);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing compact command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
        }
        return output;
    }

    public static enum KVFormatType {
        TABLE,
        INDEX_TABLE,
        TABLET_MAP,
        SCHEMA_INFO,
        TABLET,
        SEGMENT_MAP,
        SPILL_MAP,
        SPILL,
        DEFER_MAP,
        GENERIC_KV,
        DIR,
        INVALID;

    }
}

