/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.ServerCommands;
import com.mapr.cli.ServiceLinkCommand;
import com.mapr.cli.common.AuthManager;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.NodeField;
import com.mapr.cli.common.PluggableAlarmUtil;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.alarms.PluggableAlarms;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AlarmCommands
extends ListCommand
implements CLIInterface {
    private static final int NUM_ALARMS_PER_RPC = 100;
    private static final int NUM_ALARM_GROUPS_PER_RPC = 100;
    public static final String ALARM_NAME_PARAM_NAME = "alarm";
    public static final String ALARM_NEWNAME_PARAM_NAME = "newname";
    public static final String ALARM_TERSE_NAME_PARAM_NAME = "terse";
    public static final String ALARM_TYPE_PARAM_NAME = "type";
    public static final String ALARM_DISPLAY_NAME_PARAM_NAME = "displayName";
    public static final String ALARM_SERVICE_DISPLAY_NAME = "serviceName";
    public static final String ALARM_SERVICE_KEY_NAME = "service";
    public static final String ALARM_BASE_SERVICE_NAME = "baseService";
    public static final String ALARM_UI_DISPLAY_NAME = "uiDisplayName";
    public static final String ALARM_GROUP_DISPLAY_NAME = "alarmGroupName";
    public static final String ALARM_TOOLTIP_NAME = "tooltip";
    public static final String SUMMARY_PARAM_NAME = "summary";
    public static final String CLEARED_ALARMS_PARAM_NAME = "history";
    public static final String ENTITY_PARAM_NAME = "entity";
    public static final String VALUES_PARAM_NAME = "values";
    public static final String DESC_PARAM_NAME = "description";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String ALARM_GROUP_NAME_PARAM = "groupname";
    public static final String ALARM_GROUP_EMAILS_PARAM = "emails";
    public static final String ALARM_GROUP_ALARMS_PARAM = "alarms";
    public static final String ALARM_GROUP_LIST_CMD = "listGroup";
    public static final String MULTI_ARG_SEP = ",";
    public static final String SORTBY_PARAM_NAME = "sortby";
    public static final String MUTED_ALARMS_PARAM_NAME = "muted";
    public static final String ALL_ALARMS_PARAM_NAME = "all";
    public static final String MUTE_DURATION_CONFIG_PARAM_NAME = "muteminutes";
    public static final String TIME_FRAME_FROM_PARAM_NAME = "from";
    public static final String TIME_FRAME_TILL_PARAM_NAME = "till";
    public static final String SORTING_ORDER_PARAM_NAME = "sortorder";
    public static final String ASCENDING_SORTING_ORDER_PARAM_NAME = "asc";
    public static final String DESCENDING_SORTING_ORDER_PARAM_NAME = "desc";
    private static final Logger LOG = Logger.getLogger(AlarmCommands.class);
    private AuthManager authManager = AuthManager.getInstance();
    public static final Map<String, Common.AlarmType> alarmNameMap = new ImmutableMap.Builder().put((Object)"cluster", (Object)Common.AlarmType.CLUSTER_ALARM).put((Object)"node", (Object)Common.AlarmType.NODE_ALARM).put((Object)"volume", (Object)Common.AlarmType.VOLUME_ALARM).put((Object)"ae", (Object)Common.AlarmType.AE_ALARM).build();
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    static final CLICommand addCmd = new CLICommand("add", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm name", true, null)).put((Object)"terse", (Object)new TextInputParameter("terse", "alarm terse name", true, null)).put((Object)"displayName", (Object)new TextInputParameter("displayName", "alarm display name", false, null)).put((Object)"service", (Object)new TextInputParameter("service", "alarm service key", false, null)).put((Object)"serviceName", (Object)new TextInputParameter("serviceName", "alarm service name", false, null)).put((Object)"baseService", (Object)new BooleanInputParameter("baseService", "alarm base service", false, (Object)0)).put((Object)"uiDisplayName", (Object)new TextInputParameter("uiDisplayName", "alarm ui display name", false, null)).put((Object)"tooltip", (Object)new TextInputParameter("tooltip", "alarm ui tooltip content", false, null)).build(), null).setUsageInVisible(true);
    static final CLICommand editCmd = new CLICommand("edit", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm name", true, null)).put((Object)"newname", (Object)new TextInputParameter("newname", "new alarm name", false, null)).put((Object)"terse", (Object)new TextInputParameter("terse", "alarm terse name", true, null)).put((Object)"displayName", (Object)new TextInputParameter("displayName", "alarm display name", false, null)).build(), null).setShortUsage("edit");
    static final CLICommand deleteCmd = new CLICommand("delete", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm name", true, null)).build(), null).setUsageInVisible(true);
    static final CLICommand viewCmd = new CLICommand("view", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"alarm", (Object)new TextInputParameter("alarm", "alarm name", false, "")).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)"output", (Object)new TextInputParameter("output", "output", false, "verbose")).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).build(), null).setUsageInVisible(true);
    static String supportedSortKeys;
    static Map<String, CLDBProto.ListSortKey> nameToEnumMap;
    static final CLICommand listCmd;
    static final CLICommand raiseCmd;
    static final CLICommand clearCmd;
    static final CLICommand clearmultiCmd;
    static final CLICommand clearAllCmd;
    static final CLICommand configLoadCmd;
    static final CLICommand configSaveCmd;
    static final CLICommand namesCmd;
    public static final CLICommand[] configCmdsArray;
    public static CLICommand configCmds;
    static final CLICommand muteCmd;
    static final CLICommand unmuteCmd;
    public static final String addGroupEmailUsage = "addGroupEmails -groupName <alarmGroup name> -emails <comma seperated emails>";
    public static final String deleteGroupEmailUsage = "deleteGroupEmails -groupName <alarmGroup name> -emails <comma seperated emails>";
    public static final String addGroupAlarmUsage = "addGroupAlarms -groupName <alarmGroup name> -alarms <comma seperated alarmNames>";
    public static final String deleteGroupAlarmUsage = "deleteGroupAlarms -groupName <alarmGroup name> -alarms <comma seperated alarmNames>";
    static final CLICommand addEmailsCmd;
    static final CLICommand deleteEmailsCmd;
    static final CLICommand addAlarmsCmd;
    static final CLICommand deleteAlarmsCmd;
    static final CLICommand listGroupCmd;
    public static final CLICommand[] alarmGroupCmdsArray;
    public static CLICommand alarmGroupCmds;
    public static final CLICommand alarmCmds;
    public static String[] AlarmEntryFieldLongName;
    public static Map<AlarmEntryField, FieldInfo> fieldTable;

    public AlarmCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public static boolean isValidAlarmTypeName(String alarmTypeName) {
        return alarmNameMap.containsKey(alarmTypeName.toLowerCase());
    }

    private Common.AlarmType alarmNameToType(String alarmName) throws CLIProcessingException {
        if (alarmName.startsWith("CLUSTER")) {
            return Common.AlarmType.CLUSTER_ALARM;
        }
        if (alarmName.startsWith("NODE")) {
            return Common.AlarmType.NODE_ALARM;
        }
        if (alarmName.startsWith("VOLUME")) {
            return Common.AlarmType.VOLUME_ALARM;
        }
        if (alarmName.startsWith("AE")) {
            return Common.AlarmType.AE_ALARM;
        }
        throw new CLIProcessingException("Invalid Alarm name: " + alarmName);
    }

    public boolean validateInputParams(CommandOutput output) throws CLIProcessingException {
        String msg;
        String type;
        boolean result = true;
        CommandOutput.OutputHierarchy out = output.getOutput();
        if (this.isParamPresent(ALARM_TYPE_PARAM_NAME) && !AlarmCommands.isValidAlarmTypeName(type = this.getParamTextValue(ALARM_TYPE_PARAM_NAME, 0).toUpperCase())) {
            msg = "Invalid alarm type " + type;
            LOG.error((Object)msg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
            result = false;
        }
        if (this.isParamPresent("cluster")) {
            String clusterName = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(clusterName)) {
                msg = "Invalid cluster name " + clusterName;
                LOG.error((Object)msg);
                output.getOutput().addError(new CommandOutput.OutputHierarchy.OutputError(133, msg));
                result = false;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!this.validateInputParams(output)) {
            return output;
        }
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("list")) {
            String sortbyStr;
            CLDBProto.ListSortKey sortKey;
            if (this.isParamPresent(SORTBY_PARAM_NAME) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0)).toLowerCase())) == null) {
                LOG.error((Object)("failed to list sorted volumes, " + sortbyStr + " is not a valid keyword to sort volumes."));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
                return output;
            }
            if (this.isParamPresent(TIME_FRAME_FROM_PARAM_NAME) || this.isParamPresent(TIME_FRAME_TILL_PARAM_NAME)) {
                long start = 0L;
                long end = Long.MAX_VALUE;
                if (this.isParamPresent(TIME_FRAME_FROM_PARAM_NAME)) {
                    start = this.getParamLongValue(TIME_FRAME_FROM_PARAM_NAME, 0);
                }
                if (this.isParamPresent(TIME_FRAME_TILL_PARAM_NAME)) {
                    end = this.getParamLongValue(TIME_FRAME_TILL_PARAM_NAME, 0);
                }
                if (end < start) {
                    String msg = "Invalid values for -from/-till. -from[" + start + "] can not be less than -till[" + end + "]";
                    LOG.error((Object)msg);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
            }
            if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                if (!this.isParamPresent(SORTBY_PARAM_NAME)) {
                    String msg = "Invalid use of sortorder. Must be used with sortby";
                    LOG.error((Object)msg);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
                String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                if (!sortOrder.equalsIgnoreCase(ASCENDING_SORTING_ORDER_PARAM_NAME) && !sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                    String msg = "Invalid value for sortorder. Valid values are asc and desc";
                    LOG.error((Object)msg);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
            }
            this.list(out);
            return output;
        } else if (cmd.equalsIgnoreCase("add")) {
            if (!this.verifyUserPermissions(out)) return output;
            this.addAlarm(out);
            return output;
        } else if (cmd.equalsIgnoreCase("view")) {
            this.lookupAlarm(out);
            return output;
        } else if (cmd.equalsIgnoreCase("edit")) {
            if (!this.verifyUserPermissions(out)) return output;
            this.editAlarm(out);
            return output;
        } else if (cmd.equalsIgnoreCase("delete")) {
            if (!this.verifyUserPermissions(out)) return output;
            this.deleteAlarm(out);
            return output;
        } else if (cmd.equalsIgnoreCase("raise") || cmd.equalsIgnoreCase("clear") || cmd.equalsIgnoreCase("clearmulti") || cmd.equalsIgnoreCase("clearall")) {
            try {
                CLDBProto.AlarmUpdateRequest req = null;
                if (cmd.equalsIgnoreCase("clearall")) {
                    req = CLDBProto.AlarmUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setBulkState(false).build();
                } else if (cmd.equalsIgnoreCase("clearmulti")) {
                    List<Common.AlarmMsg> alarms = this.parseAlarmList(out);
                    req = CLDBProto.AlarmUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).addAllAlarms(alarms).build();
                } else {
                    Common.AlarmMsg.Builder alarmBuilder = Common.AlarmMsg.newBuilder();
                    alarmBuilder.setAlarmState(cmd.equalsIgnoreCase("raise"));
                    if (this.isParamPresent(ALARM_NAME_PARAM_NAME)) {
                        String desc;
                        String alarm = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0).toUpperCase();
                        Common.AlarmId enumAlarmId = PluggableAlarmUtil.getAlarmId(alarm);
                        if (enumAlarmId != null) {
                            alarmBuilder.setAlarmId(enumAlarmId);
                        }
                        Common.AlarmType type = this.alarmNameToType(alarm);
                        alarmBuilder.setAlarmType(type);
                        alarmBuilder.setAlarmName(alarm);
                        if (this.isParamPresent(ENTITY_PARAM_NAME)) {
                            alarmBuilder.setAlarmEntity(this.getParamTextValue(ENTITY_PARAM_NAME, 0));
                        }
                        if (this.isParamPresent(DESC_PARAM_NAME) && (desc = this.getParamTextValue(DESC_PARAM_NAME, 0)) != null && !desc.isEmpty()) {
                            alarmBuilder.setAlarmDesc(desc);
                        }
                    }
                    req = CLDBProto.AlarmUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).addAlarms(alarmBuilder).build();
                }
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmUpdateResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
                    return output;
                }
                CLDBProto.AlarmUpdateResponse resp = CLDBProto.AlarmUpdateResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) return output;
                String errMsg = resp.getStatus() == 2 ? "No such entity" : (resp.getStatus() == 22 ? "Alarm not found" : Errno.toString((int)resp.getStatus()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Operation failed. Error: " + errMsg));
                return output;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
                LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
                return output;
            }
        } else if (cmd.equalsIgnoreCase("save")) {
            try {
                String values = this.getParamTextValue(VALUES_PARAM_NAME, 0);
                if (values == null || values.length() == 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid configuration"));
                    return output;
                }
                CLDBProto.AlarmUpdateRequest.Builder req = CLDBProto.AlarmUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setConfigUpdate(true);
                String[] obj = values.split(MULTI_ARG_SEP);
                for (int i = 0; i < obj.length; i += 3) {
                    int individual;
                    if (obj[i] == null || obj[i].isEmpty()) continue;
                    Common.AlarmMsg.Builder alarmBuilder = Common.AlarmMsg.newBuilder();
                    Common.AlarmId alarmId = PluggableAlarmUtil.getAlarmId(obj[i]);
                    if (alarmId != null) {
                        alarmBuilder.setAlarmId(alarmId);
                    }
                    alarmBuilder.setAlarmName(obj[i]);
                    Common.AlarmConfigMsg.Builder cBuilder = Common.AlarmConfigMsg.newBuilder();
                    if (obj.length > i + 1 && obj[i + 1] != null && !obj[i + 1].isEmpty() && (individual = Integer.parseInt(obj[i + 1])) >= 0) {
                        cBuilder.setNeedIndividualEmail(individual > 0);
                    }
                    if (obj.length > i + 2 && obj[i + 2] != null) {
                        String email = obj[i + 2].trim();
                        if (!email.isEmpty() && !MapRCliUtil.validateEmail(email)) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Invalid Email format in configuration"));
                            return output;
                        }
                        cBuilder.setEmail(email);
                    }
                    alarmBuilder.setAlarmConfigMsg(cBuilder);
                    req.addAlarms(alarmBuilder);
                }
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.AlarmUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.AlarmUpdateResponse.class);
                if (replyData != null) return output;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
                return output;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to an exception"));
                LOG.error((Object)("Exception: " + e.getMessage()));
                return output;
            }
        } else if (cmd.equalsIgnoreCase("load")) {
            try {
                this.doConfLookup(out);
                return output;
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed " + e.getLocalizedMessage()));
                LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
            }
            return output;
        } else if (cmd.equalsIgnoreCase("names")) {
            for (Common.AlarmId alarmId : Common.AlarmId.values()) {
                System.out.println(alarmId.toString());
            }
            for (Common.PluggableAlarm pa : PluggableAlarmUtil.getAlarms(this.getUserCredentials(), 0, 50)) {
                System.out.println(pa.getName());
            }
            return output;
        } else if (cmd.equalsIgnoreCase("addEmails")) {
            this.addEmailsToGroup(out);
            return output;
        } else if (cmd.equalsIgnoreCase("deleteEmails")) {
            this.removeEmailsFromGroup(out);
            return output;
        } else if (cmd.equalsIgnoreCase("addAlarms")) {
            this.addAlarmsToGroup(out);
            return output;
        } else if (cmd.equalsIgnoreCase("deleteAlarms")) {
            this.removeAlarmsFromGroup(out);
            return output;
        } else if (cmd.equalsIgnoreCase(ALARM_GROUP_LIST_CMD)) {
            this.list(out);
            return output;
        } else {
            if (!cmd.equalsIgnoreCase("mute") && !cmd.equalsIgnoreCase("unmute")) return output;
            try {
                this.processAlarmMute(cmd, out);
                return output;
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to an exception"));
                LOG.error((Object)("Exception: " + e.getMessage()), (Throwable)e);
            }
        }
        return output;
    }

    private String deriveAlarmType(String alarmname) {
        Common.AlarmType type = PluggableAlarms.getAlarmType((String)alarmname);
        String alarmTypeStr = PluggableAlarms.getMapAlarmType((Common.AlarmType)type);
        if (alarmTypeStr == null || alarmTypeStr.isEmpty()) {
            return "NODE";
        }
        return alarmTypeStr;
    }

    private void addAlarm(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        ServerCommands.fieldTable = PluggableAlarmUtil.appendNodeMap(this.getUserCredentials(), ServerCommands.fieldTableBuilder);
        Common.PluggableAlarm.Builder builder = Common.PluggableAlarm.newBuilder();
        String alarmName = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        String alarmTerseName = this.getParamTextValue(ALARM_TERSE_NAME_PARAM_NAME, 0);
        String alarmDisplayName = this.isParamPresent(ALARM_DISPLAY_NAME_PARAM_NAME) ? this.getParamTextValue(ALARM_DISPLAY_NAME_PARAM_NAME, 0) : alarmName;
        String alarmUiDisplayName = this.isParamPresent(ALARM_UI_DISPLAY_NAME) ? this.getParamTextValue(ALARM_UI_DISPLAY_NAME, 0) : alarmName;
        if (this.verifyAlarmParams(out, ServerCommands.fieldTable, alarmName, alarmDisplayName, alarmTerseName)) {
            builder.setName(alarmName).setType(this.deriveAlarmType(alarmName)).setTerse(alarmTerseName).setDisplayName(alarmDisplayName).setUiLabel(alarmUiDisplayName);
            if (this.isParamPresent(ALARM_SERVICE_KEY_NAME)) {
                String service = this.getParamTextValue(ALARM_SERVICE_KEY_NAME, 0);
                if (this.isParamPresent(ALARM_SERVICE_DISPLAY_NAME)) {
                    builder.setServiceName(this.getParamTextValue(ALARM_SERVICE_DISPLAY_NAME, 0));
                } else {
                    builder.setServiceName(service);
                }
                builder.setService(service);
            }
            if (this.isParamPresent(ALARM_TOOLTIP_NAME)) {
                builder.setTooltip(this.getParamTextValue(ALARM_TOOLTIP_NAME, 0));
            }
            if (this.isParamPresent(ALARM_BASE_SERVICE_NAME)) {
                builder.setBaseService(this.getParamBooleanValue(ALARM_BASE_SERVICE_NAME, 0));
            }
            CLDBProto.AlarmAddRequest req = CLDBProto.AlarmAddRequest.newBuilder().setCreds(this.getUserCredentials()).setPluggableAlarm(builder.build()).build();
            try {
                byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmAddProc.getNumber(), (MessageLite)req, CLDBProto.AlarmAddResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
                } else {
                    CLDBProto.AlarmAddResponse resp = CLDBProto.AlarmAddResponse.parseFrom((byte[])replyData);
                    if (resp.getStatus() != 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                    }
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmViewResponse proto object.", (Throwable)ipbe);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
                LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
            }
        }
    }

    private void editAlarm(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String alarmName = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        Common.PluggableAlarm.Builder builder = Common.PluggableAlarm.newBuilder();
        if (this.isParamPresent(ALARM_NEWNAME_PARAM_NAME)) {
            builder.setName(this.getParamTextValue(ALARM_NEWNAME_PARAM_NAME, 0));
        } else {
            builder.setName(alarmName);
        }
        if (this.isParamPresent(ALARM_TERSE_NAME_PARAM_NAME)) {
            builder.setTerse(this.getParamTextValue(ALARM_TERSE_NAME_PARAM_NAME, 0));
        }
        if (this.isParamPresent(ALARM_DISPLAY_NAME_PARAM_NAME)) {
            builder.setDisplayName(this.getParamTextValue(ALARM_DISPLAY_NAME_PARAM_NAME, 0));
        }
        CLDBProto.AlarmEditRequest req = CLDBProto.AlarmEditRequest.newBuilder().setAlarmname(alarmName).setPluggableAlarm(builder.build()).setCreds(this.getUserCredentials()).build();
        CLDBProto.AlarmEditResponse resp = null;
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmEditProc.getNumber(), (MessageLite)req, CLDBProto.AlarmEditResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            } else {
                resp = CLDBProto.AlarmEditResponse.parseFrom((byte[])replyData);
                if (resp != null) {
                    if (resp.getStatus() != 0) {
                        String errMsg = resp.getStatus() == 22 ? "Alarm not found" : "Could not modify alarm, unknown error";
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
                    }
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Reply data did not get retrieved properly."));
                }
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmEditResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    private void deleteAlarm(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String alarmName = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        CLDBProto.AlarmDeleteRequest req = CLDBProto.AlarmDeleteRequest.newBuilder().setAlarmname(alarmName).setCreds(this.getUserCredentials()).build();
        CLDBProto.AlarmDeleteResponse resp = null;
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmRemoveProc.getNumber(), (MessageLite)req, CLDBProto.AlarmDeleteResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            } else {
                resp = CLDBProto.AlarmDeleteResponse.parseFrom((byte[])replyData);
                if (resp != null) {
                    if (resp.getStatus() != 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Could not delete alarm, alarm not found"));
                    }
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Reply data did not get retrieved properly."));
                }
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmViewResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    private void lookupAlarm(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String alarmName = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        PluggableAlarmUtil.resetCache();
        List<Common.PluggableAlarm> pluggableAlarm = PluggableAlarmUtil.getAlarms(this.getUserCredentials(), alarmName, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0));
        String clusterName = null;
        String zkConnectString = null;
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
        }
        if (this.isParamPresent("zkconnect")) {
            zkConnectString = this.getParamTextValue("zkconnect", 0);
        }
        for (Common.PluggableAlarm pa : pluggableAlarm) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_NAME_PARAM_NAME, (Object)pa.getName()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_TERSE_NAME_PARAM_NAME, (Object)pa.getTerse()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_DISPLAY_NAME_PARAM_NAME, (Object)pa.getDisplayName()));
            if (pa.hasUiLabel()) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_UI_DISPLAY_NAME, (Object)pa.getUiLabel()));
            }
            if (pa.hasTooltip()) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_TOOLTIP_NAME, (Object)pa.getTooltip()));
            }
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_TYPE_PARAM_NAME, (Object)pa.getType()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("Id", pa.getId()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_SERVICE_DISPLAY_NAME, (Object)pa.getServiceName()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_SERVICE_KEY_NAME, (Object)pa.getService()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_BASE_SERVICE_NAME, pa.getBaseService() ? 1 : 0));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(ALARM_GROUP_DISPLAY_NAME, (Object)pa.getGroupName()));
            String link = ServiceLinkCommand.getUrl(new CommandOutput.OutputHierarchy(), pa.getService(), clusterName, zkConnectString, false);
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("url", link != null ? 1 : 0));
            out.addNode(node);
        }
    }

    void doConfLookup(CommandOutput.OutputHierarchy out) throws Exception {
        String email;
        String individual;
        String alarm;
        CLDBProto.AlarmLookupRequest req = CLDBProto.AlarmLookupRequest.newBuilder().setCreds(this.getUserCredentials()).setSummary(true).build();
        byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmLookupProc.getNumber(), (MessageLite)req, CLDBProto.AlarmLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmLookupProc.getNumber(), (MessageLite)req, CLDBProto.AlarmLookupResponse.class);
        if (replyData == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            return;
        }
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase(ALARM_TERSE_NAME_PARAM_NAME);
        if (terse) {
            alarm = "an";
            individual = "ind";
            email = "em";
        } else {
            alarm = ALARM_NAME_PARAM_NAME;
            individual = "individual";
            email = "email";
        }
        CLDBProto.AlarmLookupResponse resp = CLDBProto.AlarmLookupResponse.parseFrom((byte[])replyData);
        for (Common.AlarmMsg respAlarmMsg : resp.getAlarmsList()) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(alarm, (Object)respAlarmMsg.getAlarmName()));
            Common.AlarmConfigMsg config = respAlarmMsg.getAlarmConfigMsg();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(individual, config.getNeedIndividualEmail(), this.version.intValue(), true));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(email, (Object)(config.hasEmail() ? config.getEmail() : "")));
            out.addNode(node);
        }
    }

    private CLDBProto.AlarmLookupRequest.Builder getAlarmLookupRequestBuilder() throws CLIProcessingException {
        String errMsg;
        CLDBProto.AlarmLookupRequest.Builder reqBuilder = CLDBProto.AlarmLookupRequest.newBuilder().setCreds(this.getUserCredentials()).setLimiter(this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 100));
        boolean summary = false;
        if (this.isParamPresent(SUMMARY_PARAM_NAME)) {
            summary = this.getParamBooleanValue(SUMMARY_PARAM_NAME, 0);
        }
        if (summary) {
            reqBuilder.setSummary(true);
        } else {
            Common.AlarmMsg.Builder alarmBuilder = this.getAlarmMsgBuilder();
            if (alarmBuilder != null) {
                reqBuilder.addAlarms(alarmBuilder);
            }
        }
        if (this.isParamPresent(SORTBY_PARAM_NAME)) {
            String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
            CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
            if (sortKey != null) {
                reqBuilder.setSortKey(sortKey);
            } else {
                LOG.error((Object)("failed to list sorted alarms, " + sortbyStr + " is not a valid keyword to sort alarms."));
            }
        }
        if (this.isParamPresent(CLEARED_ALARMS_PARAM_NAME)) {
            reqBuilder.setClearedAlarmsOnly(true);
        }
        if (this.isParamPresent(MUTED_ALARMS_PARAM_NAME)) {
            if (this.isParamPresent(CLEARED_ALARMS_PARAM_NAME)) {
                errMsg = "Cannot use history and muted together";
                LOG.error((Object)errMsg);
                throw new CLIProcessingException(errMsg);
            }
            reqBuilder.setMutedAlarmsOnly(true);
        }
        if (this.isParamPresent(ALL_ALARMS_PARAM_NAME)) {
            if (this.isParamPresent(MUTED_ALARMS_PARAM_NAME)) {
                errMsg = "Cannot use muted and all together";
                LOG.error((Object)errMsg);
                throw new CLIProcessingException(errMsg);
            }
            if (this.isParamPresent(CLEARED_ALARMS_PARAM_NAME)) {
                errMsg = "Cannot use history and all together";
                LOG.error((Object)errMsg);
                throw new CLIProcessingException(errMsg);
            }
            reqBuilder.setMutedAndRaisedAlarms(true);
        }
        if (this.isParamPresent(TIME_FRAME_FROM_PARAM_NAME) || this.isParamPresent(TIME_FRAME_TILL_PARAM_NAME)) {
            CLIProto.ValueRange.Builder tf = CLIProto.ValueRange.newBuilder();
            if (this.isParamPresent(TIME_FRAME_FROM_PARAM_NAME)) {
                tf.setMinValue(this.getParamLongValue(TIME_FRAME_FROM_PARAM_NAME, 0));
            }
            if (this.isParamPresent(TIME_FRAME_TILL_PARAM_NAME)) {
                tf.setMaxValue(this.getParamLongValue(TIME_FRAME_TILL_PARAM_NAME, 0));
            }
            reqBuilder.setTimeFrame(tf.build());
        }
        if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
            String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
            boolean descOrder = false;
            if (sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                descOrder = true;
            }
            reqBuilder.setSortDescending(descOrder);
        }
        return reqBuilder;
    }

    private Common.AlarmMsg.Builder getAlarmMsgBuilder() throws CLIProcessingException {
        Common.AlarmMsg.Builder alarmBuilder = Common.AlarmMsg.newBuilder();
        Common.AlarmType type = null;
        if (this.isParamPresent(ALARM_TYPE_PARAM_NAME)) {
            type = this.alarmNameToType(this.getParamTextValue(ALARM_TYPE_PARAM_NAME, 0).toUpperCase());
            alarmBuilder.setAlarmType(type);
        }
        if (this.isParamPresent(ALARM_NAME_PARAM_NAME)) {
            String alarm = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0).toUpperCase();
            Common.AlarmId enumAlarmId = PluggableAlarmUtil.getAlarmId(alarm);
            if (enumAlarmId != null) {
                alarmBuilder.setAlarmId(enumAlarmId);
            }
            alarmBuilder.setAlarmName(alarm);
            if (type == null) {
                type = this.alarmNameToType(alarm);
                alarmBuilder.setAlarmType(type);
            }
        }
        if (type != null && this.isParamPresent(ENTITY_PARAM_NAME)) {
            alarmBuilder.setAlarmEntity(this.getParamTextValue(ENTITY_PARAM_NAME, 0));
        }
        if (type != null) {
            return alarmBuilder;
        }
        return null;
    }

    private CLDBProto.AlarmLookupResponse getAlarmLookupResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.AlarmLookupResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmLookupResponse proto object.", (Throwable)ipbe);
        }
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        if (this.cliCommand.getCommandName().equalsIgnoreCase(ALARM_GROUP_LIST_CMD)) {
            return this.buildNextGroupListRequest(prevReq, prevResp);
        }
        CLDBProto.AlarmLookupRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.AlarmLookupRequest.newBuilder((CLDBProto.AlarmLookupRequest)((CLDBProto.AlarmLookupRequest)prevReq)) : this.getAlarmLookupRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            CLDBProto.AlarmLookupResponse resp = (CLDBProto.AlarmLookupResponse)prevResp;
            int prevCount = this.isParamPresent(ALL_ALARMS_PARAM_NAME) ? resp.getMutedAndRaisedAlarmsCount() : (this.isParamPresent(MUTED_ALARMS_PARAM_NAME) ? resp.getAlarmInstanceConfigCount() : resp.getAlarmsCount());
            int origStart = this.getParamIntValue(START_PARAM_NAME, 0);
            int origLimit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        if (this.cliCommand.getCommandName().equalsIgnoreCase(ALARM_GROUP_LIST_CMD)) {
            return this.hasMore(this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), ((CLDBProto.AlarmGroupListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.AlarmGroupListResponse)prevResp).getAlarmGroupsCount());
        }
        CLDBProto.AlarmLookupResponse resp = (CLDBProto.AlarmLookupResponse)prevResp;
        int numItemsReceived = this.isParamPresent(ALL_ALARMS_PARAM_NAME) ? resp.getMutedAndRaisedAlarmsCount() : (this.isParamPresent(MUTED_ALARMS_PARAM_NAME) ? resp.getAlarmInstanceConfigCount() : resp.getAlarmsCount());
        return this.hasMore(this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), ((CLDBProto.AlarmLookupRequest)prevReq).getLimiter().getStart(), numItemsReceived);
    }

    private boolean displayInstanceInfo(Common.AlarmId alarmId) {
        return alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_DEBUG_LOGGING) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_HB_PROCESSING_SLOW) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_DISK_FAILURE) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_HIGH_MFS_MEMORY) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_NO_HEARTBEAT) == 0 || alarmId.compareTo((Enum)Common.AlarmId.NODE_ALARM_TOO_MANY_CONTAINERS) == 0;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        if (this.cliCommand.getCommandName().equalsIgnoreCase(ALARM_GROUP_LIST_CMD)) {
            this.processGroupListResponse(out, response);
            return;
        }
        if (this.isParamPresent(MUTED_ALARMS_PARAM_NAME)) {
            this.processMutedAlarmListResponse(out, response);
            return;
        }
        if (this.isParamPresent(ALL_ALARMS_PARAM_NAME)) {
            this.processMutedAndRaisedAlarmListResponse(out, response);
            return;
        }
        CLDBProto.AlarmLookupResponse resp = (CLDBProto.AlarmLookupResponse)response;
        boolean clearedAlarmsOnly = false;
        if (this.isParamPresent(CLEARED_ALARMS_PARAM_NAME)) {
            clearedAlarmsOnly = true;
        }
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase(ALARM_TERSE_NAME_PARAM_NAME);
        for (Common.AlarmMsg respAlarmMsg : resp.getAlarmsList()) {
            CommandOutput.OutputHierarchy.OutputNode node = this.formatAlarmMsg(respAlarmMsg, null, terse, clearedAlarmsOnly);
            if (node == null) continue;
            out.addNode(node);
        }
    }

    private CommandOutput.OutputHierarchy.OutputNode formatAlarmMsg(Common.AlarmMsg respAlarmMsg, CommandOutput.OutputHierarchy.OutputNode node, boolean terse, boolean clearedAlarmsOnly) throws CLIProcessingException {
        if (!respAlarmMsg.getAlarmState() && !clearedAlarmsOnly) {
            return null;
        }
        if (node == null) {
            node = new CommandOutput.OutputHierarchy.OutputNode();
        }
        String alarmName = respAlarmMsg.getAlarmName();
        Common.AlarmId alarmId = respAlarmMsg.getAlarmId();
        String entityName = null;
        entityName = respAlarmMsg.getAlarmEntity();
        if (entityName != null && entityName.length() != 0) {
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.en).getName(terse), (Object)entityName));
        }
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.an).getName(terse), (Object)alarmName));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.st).getName(terse), respAlarmMsg.getAlarmState(), this.version.intValue(), true));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.sct).getName(terse), respAlarmMsg.getAlarmTimeStamp()));
        if (this.displayInstanceInfo(respAlarmMsg.getAlarmId())) {
            Iterator iterator = respAlarmMsg.getInstanceIdsList().iterator();
            while (iterator.hasNext()) {
                int port = (Integer)iterator.next();
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode("instances", port));
            }
        }
        String alarmDesc = respAlarmMsg.getAlarmDesc();
        if (alarmName.equals("VOLUME_ALARM_TABLE_REPL_ERROR") || alarmName.equals("VOLUME_ALARM_TABLE_REPL_LAG_HIGH") || alarmName.equals("VOLUME_ALARM_TABLE_REPL_ASYNC") || alarmName.equals("VOLUME_ALARM_TABLE_INDEX_ERROR") || alarmName.equals("VOLUME_ALARM_TABLE_INDEX_LAG_HIGH") || alarmName.equals("VOLUME_ALARM_TABLE_INDEX_ENCODING_ERROR")) {
            MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
            int index = alarmDesc.indexOf("Fids: ");
            if (index > 0) {
                String[] fids;
                String errPaths = "eg.";
                String desc = alarmDesc.substring(0, index);
                String fidsStr = alarmDesc.substring(index + 6);
                for (String fid : fids = fidsStr.split(" ")) {
                    String newPath = null;
                    try {
                        newPath = fs.getMountPathFid(fid);
                    }
                    catch (Exception e) {
                        newPath = null;
                    }
                    errPaths = newPath == null ? errPaths + " " + fid : errPaths + " " + newPath;
                }
                alarmDesc = desc + errPaths;
            }
        } else if (alarmName.equals("VOLUME_ALARM_TABLE_LARGE_ROW_WARNING")) {
            MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
            int index = alarmDesc.indexOf("TFID:");
            if (index > 0) {
                String fidStr = alarmDesc.substring(index + 5);
                String desc = alarmDesc.substring(0, index);
                try {
                    String tablePath = fs.getMountPathFid(fidStr);
                    alarmDesc = desc + tablePath;
                }
                catch (Exception e) {
                    alarmDesc = desc + fidStr;
                }
            }
        }
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.des).getName(terse), (Object)alarmDesc));
        if (respAlarmMsg.hasClearedTimeStamp()) {
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.ct).getName(terse), respAlarmMsg.getClearedTimeStamp()));
        }
        if (respAlarmMsg.hasGroupName()) {
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.ag).getName(terse), (Object)respAlarmMsg.getGroupName()));
        }
        return node;
    }

    @Override
    public MessageLite sendRequest(MessageLite request) throws CLIProcessingException {
        byte[] replyData;
        if (this.cliCommand.getCommandName().equalsIgnoreCase(ALARM_GROUP_LIST_CMD)) {
            return this.sendGroupListRequest(request);
        }
        CLDBProto.AlarmLookupRequest req = (CLDBProto.AlarmLookupRequest)request;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmLookupProc.getNumber(), (MessageLite)req, CLDBProto.AlarmLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmLookupProc.getNumber(), (MessageLite)req, CLDBProto.AlarmLookupResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            return this.getAlarmLookupResponse(replyData);
        }
        LOG.error((Object)"RPC Request to list alarms failed. No data returned");
        return null;
    }

    private boolean verifyUserPermissions(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        boolean isRoot;
        Security.CredentialsMsg creds = this.getUserCredentials();
        boolean bl = isRoot = creds.hasUid() && creds.getUid() == 0;
        if (isRoot) {
            return true;
        }
        return this.authManager.canPerformClusterActions(SecurityCommandHelper.CLUSTER_START_STOP_SERVICES_MASK, creds, out);
    }

    private boolean verifyAlarmParams(CommandOutput.OutputHierarchy out, Map<NodeField, FieldInfo> fieldTable, String alarmName, String alarmDisplayName, String alarmTerseName) {
        return true;
    }

    public MessageLite sendGroupListRequest(MessageLite request) throws CLIProcessingException {
        byte[] replyData;
        CLDBProto.AlarmGroupListRequest req = (CLDBProto.AlarmGroupListRequest)request;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupListProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupListProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupListResponse.class);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmGroupUpdateResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            return this.getAlarmGroupListResponse(replyData);
        }
        LOG.error((Object)"RPC Request to list alarms failed. No data returned");
        return null;
    }

    private CLDBProto.AlarmGroupListResponse getAlarmGroupListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.AlarmGroupListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmGroupListResponse proto object.", (Throwable)ipbe);
        }
    }

    public MessageLite buildNextGroupListRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.AlarmGroupListRequest.Builder newReqBuilder = null;
        if (prevReq != null) {
            newReqBuilder = CLDBProto.AlarmGroupListRequest.newBuilder((CLDBProto.AlarmGroupListRequest)((CLDBProto.AlarmGroupListRequest)prevReq));
        } else {
            newReqBuilder = CLDBProto.AlarmGroupListRequest.newBuilder().setCreds(this.getUserCredentials()).setLimiter(this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 100));
            if (this.isParamPresent(SORTBY_PARAM_NAME)) {
                String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
                CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
                if (sortKey != null) {
                    newReqBuilder.setSortKey(sortKey);
                } else {
                    LOG.error((Object)("failed to list sorted alarms, " + sortbyStr + " is not a valid keyword to sort alarms."));
                }
            }
        }
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.AlarmGroupListResponse)prevResp).getAlarmGroupsCount();
            int origStart = this.getParamIntValue(START_PARAM_NAME, 0);
            int origLimit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    public void processGroupListResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.AlarmGroupListResponse resp = (CLDBProto.AlarmGroupListResponse)response;
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase(ALARM_TERSE_NAME_PARAM_NAME);
        for (CLDBProto.AlarmGroup alarmGrp : resp.getAlarmGroupsList()) {
            CommandOutput.OutputHierarchy.OutputNode childNode;
            CLDBProto.AlarmGroup.EmailsAlarmsTuple eaTuple = alarmGrp.getEaTuple();
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.gn).getName(terse), (Object)alarmGrp.getGroupName()));
            for (String email : eaTuple.getEmailsList()) {
                childNode = new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.em).getName(terse), (Object)email);
                node.addChild(childNode);
            }
            for (String alarm : eaTuple.getAlarmsList()) {
                childNode = new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.an).getName(terse), (Object)alarm);
                node.addChild(childNode);
            }
            out.addNode(node);
        }
    }

    private void addEmailsToGroup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String groupName = this.getParamTextValue(ALARM_GROUP_NAME_PARAM, 0);
        String email = this.getParamTextValue(ALARM_GROUP_EMAILS_PARAM, 0);
        ArrayList<String> emails = new ArrayList<String>();
        if (!email.contains(MULTI_ARG_SEP)) {
            emails.add(email);
        } else {
            emails.addAll(Arrays.asList(email.split(MULTI_ARG_SEP)));
        }
        CLDBProto.AlarmGroupUpdateRequest.UpdateDelta emailDelta = CLDBProto.AlarmGroupUpdateRequest.UpdateDelta.newBuilder().addAllToAdd(emails).build();
        CLDBProto.AlarmGroupUpdateRequest req = CLDBProto.AlarmGroupUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setGroupName(groupName).setEmail(emailDelta).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupUpdateResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            } else {
                CLDBProto.AlarmGroupUpdateResponse resp = CLDBProto.AlarmGroupUpdateResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    String errMsg = "Failed to update AlarmGroup " + groupName + " " + resp.getErrMsg();
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
                }
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmGroupUpdateResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    private void removeEmailsFromGroup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String groupName = this.getParamTextValue(ALARM_GROUP_NAME_PARAM, 0);
        String email = this.getParamTextValue(ALARM_GROUP_EMAILS_PARAM, 0);
        ArrayList<String> emails = new ArrayList<String>();
        if (!email.contains(MULTI_ARG_SEP)) {
            emails.add(email);
        } else {
            emails.addAll(Arrays.asList(email.split(MULTI_ARG_SEP)));
        }
        CLDBProto.AlarmGroupUpdateRequest.UpdateDelta emailDelta = CLDBProto.AlarmGroupUpdateRequest.UpdateDelta.newBuilder().addAllToRemove(emails).build();
        CLDBProto.AlarmGroupUpdateRequest req = CLDBProto.AlarmGroupUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setGroupName(groupName).setEmail(emailDelta).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupUpdateResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            } else {
                CLDBProto.AlarmGroupUpdateResponse resp = CLDBProto.AlarmGroupUpdateResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    String errMsg = "Failed to update AlarmGroup " + groupName + " " + resp.getErrMsg();
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
                }
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmGroupUpdateResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    private void addAlarmsToGroup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String groupName = this.getParamTextValue(ALARM_GROUP_NAME_PARAM, 0);
        String alarm = this.getParamTextValue(ALARM_GROUP_ALARMS_PARAM, 0);
        ArrayList<String> alarms = new ArrayList<String>();
        if (!alarm.contains(MULTI_ARG_SEP)) {
            alarms.add(alarm);
        } else {
            alarms.addAll(Arrays.asList(alarm.split(MULTI_ARG_SEP)));
        }
        CLDBProto.AlarmGroupUpdateRequest.UpdateDelta alarmDelta = CLDBProto.AlarmGroupUpdateRequest.UpdateDelta.newBuilder().addAllToAdd(alarms).build();
        CLDBProto.AlarmGroupUpdateRequest req = CLDBProto.AlarmGroupUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setGroupName(groupName).setAlarm(alarmDelta).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupUpdateResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            } else {
                CLDBProto.AlarmGroupUpdateResponse resp = CLDBProto.AlarmGroupUpdateResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    String errMsg = "Failed to update AlarmGroup " + groupName + " " + resp.getErrMsg();
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
                }
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmGroupUpdateResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    private void removeAlarmsFromGroup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String groupName = this.getParamTextValue(ALARM_GROUP_NAME_PARAM, 0);
        String alarm = this.getParamTextValue(ALARM_GROUP_ALARMS_PARAM, 0);
        ArrayList<String> alarms = new ArrayList<String>();
        if (!alarm.contains(MULTI_ARG_SEP)) {
            alarms.add(alarm);
        } else {
            alarms.addAll(Arrays.asList(alarm.split(MULTI_ARG_SEP)));
        }
        CLDBProto.AlarmGroupUpdateRequest.UpdateDelta alarmDelta = CLDBProto.AlarmGroupUpdateRequest.UpdateDelta.newBuilder().addAllToRemove(alarms).build();
        CLDBProto.AlarmGroupUpdateRequest req = CLDBProto.AlarmGroupUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setGroupName(groupName).setAlarm(alarmDelta).build();
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmGroupUpdateResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            } else {
                CLDBProto.AlarmGroupUpdateResponse resp = CLDBProto.AlarmGroupUpdateResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    String errMsg = "Failed to update AlarmGroup " + groupName + " " + resp.getErrMsg();
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
                }
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into AlarmGroupUpdateResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception"));
            LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
        }
    }

    private void processAlarmMute(String cmd, CommandOutput.OutputHierarchy out) throws MaprSecurityException, Exception {
        if (this.verifyUserPermissions(out)) {
            if (cmd.equalsIgnoreCase("mute")) {
                this.muteAlarm(out);
            } else if (cmd.equalsIgnoreCase("unmute")) {
                this.unmuteAlarm(out);
            }
        }
    }

    public void processMutedAlarmListResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.AlarmLookupResponse resp = (CLDBProto.AlarmLookupResponse)response;
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase(ALARM_TERSE_NAME_PARAM_NAME);
        for (CLDBProto.AlarmInstanceConfig aInstCfg : resp.getAlarmInstanceConfigList()) {
            out.addNode(this.formatAlarmInstanceConfig(aInstCfg, null, terse, true));
        }
    }

    private CommandOutput.OutputHierarchy.OutputNode formatAlarmInstanceConfig(CLDBProto.AlarmInstanceConfig aInstCfg, CommandOutput.OutputHierarchy.OutputNode node, boolean terse, boolean includeAlarmInfo) throws CLIProcessingException {
        if (node == null) {
            node = new CommandOutput.OutputHierarchy.OutputNode();
        }
        CLDBProto.AlarmMuteConfig muteCfg = aInstCfg.getMutedConfig();
        if (includeAlarmInfo) {
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.an).getName(terse), (Object)aInstCfg.getAlarmname()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.en).getName(terse), (Object)aInstCfg.getEntityname()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.ag).getName(terse), (Object)aInstCfg.getAlarmGroup()));
        }
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.mt).getName(terse), muteCfg.getMuteAtMillis()));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.mup).getName(terse), muteCfg.getMuteTillMillis()));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)AlarmEntryField.md).getName(terse), (Object)(muteCfg.getMuteForMinutes() + " mins")));
        return node;
    }

    public void processMutedAndRaisedAlarmListResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.AlarmLookupResponse resp = (CLDBProto.AlarmLookupResponse)response;
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase(ALARM_TERSE_NAME_PARAM_NAME);
        boolean clearedAlarmsOnly = false;
        if (this.isParamPresent(CLEARED_ALARMS_PARAM_NAME)) {
            clearedAlarmsOnly = true;
        }
        for (CLDBProto.MutedAndRaisedAlarmsConfig aInstCfg : resp.getMutedAndRaisedAlarmsList()) {
            CommandOutput.OutputHierarchy.OutputNode node = this.formatAlarmMsg(aInstCfg.getAlarmMsg(), null, terse, clearedAlarmsOnly);
            if (node == null) continue;
            if (aInstCfg.hasInstanceConfig()) {
                node = this.formatAlarmInstanceConfig(aInstCfg.getInstanceConfig(), node, terse, false);
            }
            if (node == null) continue;
            out.addNode(node);
        }
    }

    private void muteAlarm(CommandOutput.OutputHierarchy out) throws MaprSecurityException, Exception {
        String alarmValues = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        if (alarmValues == null || alarmValues.length() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid configuration"));
            return;
        }
        CLDBProto.AlarmInstanceUpdate.Builder updater = CLDBProto.AlarmInstanceUpdate.newBuilder().setOper(CLDBProto.AlarmInstanceConfigUpdateOperation.UpdateMutePeriod);
        int muteminutes = -1;
        if (this.isParamPresent(MUTE_DURATION_CONFIG_PARAM_NAME)) {
            muteminutes = this.getParamIntValue(MUTE_DURATION_CONFIG_PARAM_NAME, 0);
        }
        String[] alarmInstances = alarmValues.split(MULTI_ARG_SEP);
        for (int i = 0; i < alarmInstances.length; ++i) {
            int optimalConfigLen;
            String[] config;
            if (alarmInstances[i] == null || alarmInstances[i].isEmpty() || (config = alarmInstances[i].split(":")).length < 1) continue;
            String alarmname = config[0];
            String entityname = "";
            String alarmdesc = alarmname;
            Common.AlarmType type = this.alarmNameToType(alarmname);
            if (type != Common.AlarmType.CLUSTER_ALARM) {
                if (config.length < 2) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "entity name missing for alarm " + alarmname));
                    return;
                }
                entityname = config[1];
                alarmdesc = alarmdesc + ":" + entityname;
                if (type == Common.AlarmType.AE_ALARM) {
                    if (config.length < 2 || config[2] == null || config[2].isEmpty()) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ae type missing for alarm " + alarmname));
                        return;
                    }
                    if (!config[2].equals("0") && !config[2].equals("1")) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid ae type " + config[2] + " for alarm " + alarmname));
                        return;
                    }
                    entityname = entityname + ":" + config[2];
                    optimalConfigLen = 4;
                } else {
                    if (type == Common.AlarmType.NODE_ALARM && entityname.contains("@")) {
                        entityname = entityname.replace('@', ':');
                    }
                    optimalConfigLen = 3;
                }
            } else {
                entityname = "CLUSTER";
                alarmdesc = alarmdesc + ":" + entityname;
                optimalConfigLen = 2;
            }
            int mutefor = muteminutes;
            if (muteminutes == -1 && config.length < optimalConfigLen) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "insuffecient parameters for alarm " + alarmdesc));
                return;
            }
            if (config.length > optimalConfigLen) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "alarm " + alarmdesc + " has invalid(too many) parameters " + Arrays.asList(config).subList(1, config.length)));
                return;
            }
            if (config.length == optimalConfigLen) {
                try {
                    mutefor = Integer.valueOf(config[optimalConfigLen - 1]);
                }
                catch (NumberFormatException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "failed to parse mute duration[" + config[optimalConfigLen - 1] + "] for alarm " + alarmdesc));
                    return;
                }
            }
            if (mutefor < 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid mute duration: " + mutefor + " for alarm " + alarmdesc));
                return;
            }
            CLDBProto.AlarmMuteConfig muteCfg = CLDBProto.AlarmMuteConfig.newBuilder().setMuteForMinutes(mutefor).build();
            CLDBProto.AlarmInstanceConfig.Builder instanceConfig = CLDBProto.AlarmInstanceConfig.newBuilder().setAlarmname(alarmname).setMutedConfig(muteCfg);
            if (entityname != null) {
                instanceConfig.setEntityname(entityname);
            }
            LOG.info((Object)("muting alarm " + alarmdesc + " for " + mutefor + " minutes."));
            updater.addInstanceConfig(instanceConfig.build());
        }
        CLDBProto.AlarmUpdateRequest req = CLDBProto.AlarmUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setConfigUpdate(false).setInstanceUpdate(updater.build()).build();
        byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmUpdateResponse.class);
        if (replyData == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            return;
        }
        CLDBProto.AlarmUpdateResponse resp = CLDBProto.AlarmUpdateResponse.parseFrom((byte[])replyData);
        if (resp.getStatus() != 0) {
            String errMsg = "Failed to mute alarm instances. " + resp.getErrMsg();
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
    }

    private void unmuteAlarm(CommandOutput.OutputHierarchy out) throws MaprSecurityException, Exception {
        String alarmValues = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        if (alarmValues == null || alarmValues.length() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid configuration"));
            return;
        }
        CLDBProto.AlarmInstanceUpdate.Builder updater = CLDBProto.AlarmInstanceUpdate.newBuilder().setOper(CLDBProto.AlarmInstanceConfigUpdateOperation.UpdateMutePeriod);
        boolean muteminutes = false;
        String[] alarmInstances = alarmValues.split(MULTI_ARG_SEP);
        for (int i = 0; i < alarmInstances.length; ++i) {
            int optimalConfigLen;
            String[] config;
            if (alarmInstances[i] == null || alarmInstances[i].isEmpty() || (config = alarmInstances[i].split(":")).length < 1) continue;
            String alarmname = config[0];
            String entityname = null;
            String alarmdesc = alarmname;
            Common.AlarmType type = this.alarmNameToType(alarmname);
            if (type != Common.AlarmType.CLUSTER_ALARM) {
                if (config.length < 2) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "entity name missing for alarm " + alarmname));
                    return;
                }
                entityname = config[1];
                alarmdesc = alarmdesc + ":" + entityname;
                if (type == Common.AlarmType.AE_ALARM) {
                    if (config.length < 2 || config[2] == null || config[2].isEmpty()) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ae type missing for alarm " + alarmname));
                        return;
                    }
                    if (!config[2].equals("0") && !config[2].equals("1")) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid ae type " + config[2] + " for alarm " + alarmname));
                        return;
                    }
                    entityname = entityname + ":" + config[2];
                    optimalConfigLen = 3;
                } else {
                    optimalConfigLen = 2;
                }
            } else {
                entityname = "CLUSTER";
                alarmdesc = alarmdesc + ":" + entityname;
                optimalConfigLen = 1;
            }
            if (config.length < optimalConfigLen) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "insuffecient parameters for alarm " + alarmdesc));
                return;
            }
            if (config.length > optimalConfigLen) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "alarm " + alarmdesc + " has invalid(too many) parameters " + Arrays.asList(config).subList(1, config.length)));
                return;
            }
            CLDBProto.AlarmMuteConfig muteCfg = CLDBProto.AlarmMuteConfig.newBuilder().setMuteForMinutes(0).build();
            CLDBProto.AlarmInstanceConfig.Builder instanceConfig = CLDBProto.AlarmInstanceConfig.newBuilder().setAlarmname(alarmname).setMutedConfig(muteCfg);
            if (entityname != null) {
                instanceConfig.setEntityname(entityname);
            }
            LOG.info((Object)("unmuting alarm " + alarmdesc));
            updater.addInstanceConfig(instanceConfig.build());
        }
        CLDBProto.AlarmUpdateRequest req = CLDBProto.AlarmUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setConfigUpdate(false).setInstanceUpdate(updater.build()).build();
        byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AlarmUpdateProc.getNumber(), (MessageLite)req, CLDBProto.AlarmUpdateResponse.class);
        if (replyData == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to connect to CLDB"));
            return;
        }
        CLDBProto.AlarmUpdateResponse resp = CLDBProto.AlarmUpdateResponse.parseFrom((byte[])replyData);
        if (resp.getStatus() != 0) {
            String errMsg = "Failed to unmute alarm instances. " + resp.getErrMsg();
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
    }

    private List<Common.AlarmMsg> parseAlarmList(CommandOutput.OutputHierarchy out) throws MaprSecurityException, Exception {
        ArrayList<Common.AlarmMsg> alarms = new ArrayList<Common.AlarmMsg>();
        String alarmValues = this.getParamTextValue(ALARM_NAME_PARAM_NAME, 0);
        if (alarmValues == null || alarmValues.length() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid configuration"));
            return null;
        }
        String[] alarmInstances = alarmValues.split(MULTI_ARG_SEP);
        for (int i = 0; i < alarmInstances.length; ++i) {
            int optimalConfigLen;
            String[] config;
            if (alarmInstances[i] == null || alarmInstances[i].isEmpty() || (config = alarmInstances[i].split(":")).length < 1) continue;
            String alarmname = config[0];
            Common.AlarmType type = this.alarmNameToType(alarmname);
            Common.AlarmMsg.Builder alarmBuilder = Common.AlarmMsg.newBuilder().setAlarmState(false).setAlarmName(alarmname).setAlarmType(type);
            Common.AlarmId enumAlarmId = PluggableAlarmUtil.getAlarmId(alarmname);
            if (enumAlarmId != null) {
                alarmBuilder.setAlarmId(enumAlarmId);
            }
            String entityname = null;
            String alarmdesc = alarmname;
            if (type != Common.AlarmType.CLUSTER_ALARM) {
                if (config.length < 2) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "entity name missing for alarm " + alarmname));
                    return null;
                }
                entityname = config[1];
                alarmdesc = alarmdesc + ":" + entityname;
                if (type == Common.AlarmType.AE_ALARM) {
                    if (config.length < 2 || config[2] == null || config[2].isEmpty()) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "ae type missing for alarm " + alarmname));
                        return null;
                    }
                    if (!config[2].equals("u") && !config[2].equals("g")) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid ae type " + config[2] + " for alarm " + alarmname));
                        return null;
                    }
                    entityname = entityname + ":" + config[2];
                    optimalConfigLen = 3;
                } else {
                    optimalConfigLen = 2;
                }
            } else {
                alarmdesc = alarmdesc + ":CLUSTER";
                optimalConfigLen = 1;
            }
            if (config.length < optimalConfigLen) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "insuffecient parameters for alarm " + alarmdesc));
                return null;
            }
            if (config.length > optimalConfigLen) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "alarm " + alarmdesc + " has invalid(too many) parameters " + Arrays.asList(config).subList(1, config.length)));
                return null;
            }
            if (entityname != null) {
                alarmBuilder.setAlarmEntity(entityname);
            }
            alarms.add(alarmBuilder.build());
            LOG.info((Object)("clearing alarm " + alarmdesc));
        }
        return alarms;
    }

    static {
        nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.ListSortKey key : CLDBProto.ListSortKey.values()) {
            if (!key.name().startsWith("Alarm")) continue;
            nameToEnumMap.put(key.name().toLowerCase(), key);
            if (sb.length() == 0) {
                sb.append(key.name().toLowerCase());
                continue;
            }
            sb.append("|" + key.name().toLowerCase());
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        listCmd = new CLICommand("list", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SUMMARY_PARAM_NAME, (Object)new BooleanInputParameter(SUMMARY_PARAM_NAME, SUMMARY_PARAM_NAME, false, (Object)0)).put((Object)ALARM_NAME_PARAM_NAME, (Object)new TextInputParameter(ALARM_NAME_PARAM_NAME, "alarm name", false, null)).put((Object)ALARM_TYPE_PARAM_NAME, (Object)new TextInputParameter(ALARM_TYPE_PARAM_NAME, "type (CLUSTER OR NODE OR VOLUME OR AE)", false, null)).put((Object)ENTITY_PARAM_NAME, (Object)new TextInputParameter(ENTITY_PARAM_NAME, "entity (hostname OR volume name OR Ae name)", false, null)).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, OUTPUT_PARAM_NAME, false, "verbose")).put((Object)SORTBY_PARAM_NAME, (Object)new TextInputParameter(SORTBY_PARAM_NAME, supportedSortKeys, false, null)).put((Object)CLEARED_ALARMS_PARAM_NAME, (Object)new NoValueInputParameter(CLEARED_ALARMS_PARAM_NAME, "list cleared up alarms only", false, false)).put((Object)TIME_FRAME_FROM_PARAM_NAME, (Object)new LongInputParameter(TIME_FRAME_FROM_PARAM_NAME, "alarms raised after time(in millis)", false, null)).put((Object)TIME_FRAME_TILL_PARAM_NAME, (Object)new LongInputParameter(TIME_FRAME_TILL_PARAM_NAME, "alarms raised before time(in millis)", false, null)).put((Object)MUTED_ALARMS_PARAM_NAME, (Object)new NoValueInputParameter(MUTED_ALARMS_PARAM_NAME, "list alarms configured to be mute", false, false)).put((Object)ALL_ALARMS_PARAM_NAME, (Object)new NoValueInputParameter(ALL_ALARMS_PARAM_NAME, "list raised and muted alarms", false, false)).put((Object)SORTING_ORDER_PARAM_NAME, (Object)new TextInputParameter(SORTING_ORDER_PARAM_NAME, "<asc|desc>", false, null)).build(), null).setShortUsage("list");
        raiseCmd = new CLICommand("raise", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALARM_NAME_PARAM_NAME, (Object)new TextInputParameter(ALARM_NAME_PARAM_NAME, ALARM_NAME_PARAM_NAME, true, null)).put((Object)ENTITY_PARAM_NAME, (Object)new TextInputParameter(ENTITY_PARAM_NAME, "entity (hostname OR volume name OR Ae name)", false, null)).put((Object)DESC_PARAM_NAME, (Object)new TextInputParameter(DESC_PARAM_NAME, "brief description", false, null)).build(), null).setShortUsage("raise");
        clearCmd = new CLICommand("clear", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALARM_NAME_PARAM_NAME, (Object)new TextInputParameter(ALARM_NAME_PARAM_NAME, ALARM_NAME_PARAM_NAME, true, null)).put((Object)ENTITY_PARAM_NAME, (Object)new TextInputParameter(ENTITY_PARAM_NAME, "entity (hostname OR volume name OR Ae name)", false, null)).build(), null).setShortUsage("clear");
        clearmultiCmd = new CLICommand("clearmulti", "clearmulti alarm[:entity][:aetype] <comma seperated alarms>", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALARM_NAME_PARAM_NAME, (Object)new TextInputParameter(ALARM_NAME_PARAM_NAME, "alarm[:entity][:aetype] <comma seperated alarms>", true, null)).build(), null).setShortUsage("clearmulti alarm[:entity][:aetype] <comma seperated alarms>");
        clearAllCmd = new CLICommand("clearall", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("clearall");
        configLoadCmd = new CLICommand("load", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, OUTPUT_PARAM_NAME, false, "verbose")).build(), null).setShortUsage("config load");
        configSaveCmd = new CLICommand("save", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)VALUES_PARAM_NAME, (Object)new TextInputParameter(VALUES_PARAM_NAME, VALUES_PARAM_NAME, true, "")).build(), null).setShortUsage("config save");
        namesCmd = new CLICommand("names", "list of alarm names", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("names");
        configCmdsArray = new CLICommand[]{configLoadCmd, configSaveCmd};
        configCmds = new CLICommand("config", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, configCmdsArray).setShortUsage("config [load|save]");
        muteCmd = new CLICommand("mute", "mute", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALARM_NAME_PARAM_NAME, (Object)new TextInputParameter(ALARM_NAME_PARAM_NAME, "alarm[:entity][:aetype][:mute_duration] <comma seperated alarms>", true, null)).put((Object)MUTE_DURATION_CONFIG_PARAM_NAME, (Object)new IntegerInputParameter(MUTE_DURATION_CONFIG_PARAM_NAME, "duration (in minutes) to mute the alarms", false, null)).build(), null);
        unmuteCmd = new CLICommand("unmute", "unmute", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALARM_NAME_PARAM_NAME, (Object)new TextInputParameter(ALARM_NAME_PARAM_NAME, "[alarm[:entity[:aetype]]]+", true, null)).build(), null);
        addEmailsCmd = new CLICommand("addEmails", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALARM_GROUP_NAME_PARAM, (Object)new TextInputParameter(ALARM_GROUP_NAME_PARAM, "group name", true, null)).put((Object)ALARM_GROUP_EMAILS_PARAM, (Object)new TextInputParameter(ALARM_GROUP_EMAILS_PARAM, "email addresses", true, null)).build(), null).setShortUsage(addGroupEmailUsage);
        deleteEmailsCmd = new CLICommand("deleteEmails", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALARM_GROUP_NAME_PARAM, (Object)new TextInputParameter(ALARM_GROUP_NAME_PARAM, "group name", true, null)).put((Object)ALARM_GROUP_EMAILS_PARAM, (Object)new TextInputParameter(ALARM_GROUP_EMAILS_PARAM, "email addresses", true, null)).build(), null).setShortUsage(deleteGroupEmailUsage);
        addAlarmsCmd = new CLICommand("addAlarms", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALARM_GROUP_NAME_PARAM, (Object)new TextInputParameter(ALARM_GROUP_NAME_PARAM, "group name", true, null)).put((Object)ALARM_GROUP_ALARMS_PARAM, (Object)new TextInputParameter(ALARM_GROUP_ALARMS_PARAM, "alarm names", true, null)).build(), null).setShortUsage(addGroupAlarmUsage);
        deleteAlarmsCmd = new CLICommand("deleteAlarms", "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ALARM_GROUP_NAME_PARAM, (Object)new TextInputParameter(ALARM_GROUP_NAME_PARAM, "group name", true, null)).put((Object)ALARM_GROUP_ALARMS_PARAM, (Object)new TextInputParameter(ALARM_GROUP_ALARMS_PARAM, "alarm names", true, null)).build(), null).setShortUsage(deleteGroupAlarmUsage);
        listGroupCmd = new CLICommand(ALARM_GROUP_LIST_CMD, "", AlarmCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, OUTPUT_PARAM_NAME, false, "verbose")).build(), null).setShortUsage(ALARM_GROUP_LIST_CMD);
        alarmGroupCmdsArray = new CLICommand[]{listGroupCmd, addEmailsCmd, deleteEmailsCmd, addAlarmsCmd, deleteAlarmsCmd};
        alarmGroupCmds = new CLICommand("group", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, alarmGroupCmdsArray).setShortUsage("group [listGroup|addEmails|deleteEmails|addAlarms|deleteAlarms]");
        alarmCmds = new CLICommand(ALARM_NAME_PARAM_NAME, "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCmd, viewCmd, deleteCmd, listCmd, raiseCmd, clearCmd, clearmultiCmd, muteCmd, unmuteCmd, clearAllCmd, configCmds, namesCmd, alarmGroupCmds}).setShortUsage("alarm [list|raise|clear|clearall|mute|unmute|config|names|group]");
        AlarmEntryFieldLongName = new String[]{"alarm name", "alarm type", "alarm state", "alarm statechange time", DESC_PARAM_NAME, ENTITY_PARAM_NAME, "group name", ALARM_GROUP_EMAILS_PARAM, "alarm cleared time", "muted time", "mute upto", "mute duration", "alarm group"};
        fieldTable = new ImmutableMap.Builder().put((Object)AlarmEntryField.an, (Object)new FieldInfo(AlarmEntryField.an.ordinal(), AlarmEntryField.an.name(), AlarmEntryFieldLongName[AlarmEntryField.an.ordinal()], String.class)).put((Object)AlarmEntryField.et, (Object)new FieldInfo(AlarmEntryField.et.ordinal(), AlarmEntryField.et.name(), AlarmEntryFieldLongName[AlarmEntryField.et.ordinal()], String.class)).put((Object)AlarmEntryField.st, (Object)new FieldInfo(AlarmEntryField.st.ordinal(), AlarmEntryField.st.name(), AlarmEntryFieldLongName[AlarmEntryField.st.ordinal()], String.class)).put((Object)AlarmEntryField.sct, (Object)new FieldInfo(AlarmEntryField.sct.ordinal(), AlarmEntryField.sct.name(), AlarmEntryFieldLongName[AlarmEntryField.sct.ordinal()], String.class)).put((Object)AlarmEntryField.des, (Object)new FieldInfo(AlarmEntryField.des.ordinal(), AlarmEntryField.des.name(), AlarmEntryFieldLongName[AlarmEntryField.des.ordinal()], String.class)).put((Object)AlarmEntryField.en, (Object)new FieldInfo(AlarmEntryField.en.ordinal(), AlarmEntryField.en.name(), AlarmEntryFieldLongName[AlarmEntryField.en.ordinal()], String.class)).put((Object)AlarmEntryField.gn, (Object)new FieldInfo(AlarmEntryField.gn.ordinal(), AlarmEntryField.gn.name(), AlarmEntryFieldLongName[AlarmEntryField.gn.ordinal()], String.class)).put((Object)AlarmEntryField.em, (Object)new FieldInfo(AlarmEntryField.em.ordinal(), AlarmEntryField.em.name(), AlarmEntryFieldLongName[AlarmEntryField.em.ordinal()], String.class)).put((Object)AlarmEntryField.ct, (Object)new FieldInfo(AlarmEntryField.ct.ordinal(), AlarmEntryField.ct.name(), AlarmEntryFieldLongName[AlarmEntryField.ct.ordinal()], String.class)).put((Object)AlarmEntryField.mt, (Object)new FieldInfo(AlarmEntryField.mt.ordinal(), AlarmEntryField.mt.name(), AlarmEntryFieldLongName[AlarmEntryField.mt.ordinal()], String.class)).put((Object)AlarmEntryField.mup, (Object)new FieldInfo(AlarmEntryField.mup.ordinal(), AlarmEntryField.mup.name(), AlarmEntryFieldLongName[AlarmEntryField.mup.ordinal()], String.class)).put((Object)AlarmEntryField.md, (Object)new FieldInfo(AlarmEntryField.md.ordinal(), AlarmEntryField.md.name(), AlarmEntryFieldLongName[AlarmEntryField.md.ordinal()], String.class)).put((Object)AlarmEntryField.ag, (Object)new FieldInfo(AlarmEntryField.ag.ordinal(), AlarmEntryField.ag.name(), AlarmEntryFieldLongName[AlarmEntryField.ag.ordinal()], String.class)).build();
    }

    public static enum AlarmEntryField {
        an,
        et,
        st,
        sct,
        des,
        en,
        gn,
        em,
        ct,
        mt,
        mup,
        md,
        ag;

    }
}

