/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.schedulepolicy.commands;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.JSONArrayInputParameter;
import com.mapr.cliframework.base.inputparams.ParamValidator;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SchedulePolicyModifyCommand
extends CLIBaseClass
implements CLIInterface {
    private static final String SCHEDULE_MODIFY_PARAM = "modify";
    private static final String SCHEDULE_ID_PARAM = "id";
    private static final String SCHEDULE_NAME_PARAM = "name";
    private static final String SCHEDULE_RULES_PARAM = "rules";
    public static final String CLDB_HOST = "cldbip";
    public static final String CLDB_PORT = "cldbport";
    public static Pattern p = Pattern.compile("(\\d+)|(\\w+)");
    public static final Log LOG = LogFactory.getLog(SchedulePolicyModifyCommand.class);
    public static final CLICommand schedulePolicyModifyCommand = new CLICommand("modify", "modify schedule ", SchedulePolicyModifyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"id", (Object)new IntegerInputParameter("id", "id of schedule policy", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "name of the schedule", false, null)).put((Object)"rules", (Object)new JSONArrayInputParameter("rules", "JSON Array of schedule rules to denote all the schedule rules properties", false)).build(), null);

    public SchedulePolicyModifyCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy ch = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(ch);
        CLDBProto.SchedulePolicyProcRequest.Builder scheduleRequestBuilder = CLDBProto.SchedulePolicyProcRequest.newBuilder();
        scheduleRequestBuilder.setPolicyOp(CLDBProto.SchedulePolicyProcRequest.SchedulePolicyOP.MODIFY);
        CLDBProto.Policy.Builder policyBuilder = CLDBProto.Policy.newBuilder();
        int scheduleId = this.getParamIntValue(SCHEDULE_ID_PARAM, 0);
        policyBuilder.setPolicyId(scheduleId);
        if (this.isParamPresent(SCHEDULE_NAME_PARAM)) {
            String scheduleName = this.getParamTextValue(SCHEDULE_NAME_PARAM, 0);
            policyBuilder.setPolicyName(scheduleName);
        }
        if (this.isParamPresent(SCHEDULE_RULES_PARAM)) {
            String jSonString = (String)this.input.getParameterByName(SCHEDULE_RULES_PARAM).getParamValues().get(0);
            if (ParamValidator.containsMalaciousChars((String)jSonString)) {
                String errMsg = "Unexpected value in rules";
                LOG.error((Object)errMsg);
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10002, errMsg));
                return co;
            }
            try {
                JSONArray jRules = new JSONArray(jSonString);
                ArrayList<CLDBProto.PolicyRule> rules = new ArrayList<CLDBProto.PolicyRule>();
                for (int i = 0; i < jRules.length(); ++i) {
                    CLDBProto.PolicyRule.Builder ruleBuilder = CLDBProto.PolicyRule.newBuilder();
                    JSONObject jRO = jRules.getJSONObject(i);
                    String jFreq = jRO.getString("frequency");
                    ruleBuilder.setFrequency(CLDBProto.PolicyFrequencyEnum.valueOf((String)jFreq));
                    String date = jRO.optString("date");
                    if (date != null && !date.isEmpty()) {
                        ruleBuilder.setDate(date);
                    }
                    if (!jRO.isNull("time")) {
                        int time = jRO.optInt("time");
                        ruleBuilder.setTime(time);
                    }
                    if (!jRO.isNull("minute")) {
                        int minutes = jRO.optInt("minute");
                        ruleBuilder.setMinutes(minutes);
                    }
                    String retain = jRO.getString("retain");
                    ArrayList<String> groups = new ArrayList<String>();
                    Matcher m = p.matcher(retain);
                    while (m.find()) {
                        groups.add(m.group().trim());
                    }
                    if (groups.size() != 2) {
                        LOG.error((Object)("retain portion of the input is invalid: " + retain));
                        ch.addError(new CommandOutput.OutputHierarchy.OutputError(22, "retain portion of the input is invalid: " + retain).setField("retain").setFieldValue(retain));
                        continue;
                    }
                    CLDBProto.PolicyRule.RetainPeriod.Builder retainBuilder = CLDBProto.PolicyRule.RetainPeriod.newBuilder();
                    retainBuilder.setNumberOfUnits(Integer.valueOf((String)groups.get(0)).intValue());
                    retainBuilder.setTimeUnitsEnum(CLDBProto.RetainTimeUnitsEnum.valueOf((String)((String)groups.get(1))));
                    ruleBuilder.setRetainTime(retainBuilder);
                    rules.add(ruleBuilder.build());
                }
                policyBuilder.addAllPolicyRules(rules);
            }
            catch (JSONException e) {
                LOG.error((Object)("Provided Input cannot be converted to JSONObject: " + jSonString));
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Provided Input can not be converted to JSONObject: " + jSonString));
                return co;
            }
            catch (InvalidParameterException e) {
                LOG.error((Object)("Provided Input is not compliant with enums: " + jSonString));
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Provided Input is not compliant with enums: " + jSonString));
                return co;
            }
        }
        scheduleRequestBuilder.setPolicy(policyBuilder.build());
        byte[] data = null;
        try {
            scheduleRequestBuilder.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class);
            if (data == null) {
                LOG.error((Object)"RPC Request to modify Schedule Policies failed. No data returned");
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return co;
            }
            CLDBProto.SchedulePolicyProcResponse resp = CLDBProto.SchedulePolicyProcResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                LOG.error((Object)("RPC Request to modify Schedule Policies failed with error: " + Errno.toString((int)resp.getStatus())));
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to modify Schedule Policies failed with error: " + Errno.toString((int)resp.getStatus())));
                return co;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"RPC Request to modify Schedule Policies failed. No data returned");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to modify Schedule Policies failed. No data returned"));
            return co;
        }
        return co;
    }
}

