/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.google.protobuf.MessageLite;
import com.mapr.cli.common.ListIterator;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterProcessingException;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.cli.proto.CLIProto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ListCommand
extends CLIBaseClass
implements ListIterator {
    private static final Logger LOG = Logger.getLogger(ListCommand.class);

    public ListCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    protected CLIProto.Limiter getNextLimiter(int prevStart, int prevCount, int origStart, int origLimit, int numRecsPerRpc) {
        int nextStart = prevStart + prevCount;
        int nextLimit = origLimit - (nextStart - origStart);
        if (nextLimit > numRecsPerRpc) {
            nextLimit = numRecsPerRpc;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getNextLimiter - origStart = " + origStart + ", origLimit = " + origLimit + ", prevCount = " + prevCount + ", numRecsPerRpc = " + numRecsPerRpc + ", nextStart = " + nextStart + ", nextLimit = " + nextLimit));
        }
        return CLIProto.Limiter.newBuilder().setStart(nextStart).setLimit(nextLimit).build();
    }

    protected <T> List<CLIProto.Filter> getFilters(Map<T, FieldInfo> table, String filterParam) throws CLIProcessingException {
        List<Object> filters;
        String filterString = this.getParamTextValue(filterParam, 0);
        if (filterString != null && !filterString.equals("none") && !filterString.equals("[id=all]")) {
            try {
                ArrayList<String> filterStrings = new ArrayList<String>();
                filterStrings.add(filterString);
                filters = FilterUtil.compileFilter(table, filterStrings);
            }
            catch (FilterProcessingException fpe) {
                throw new CLIProcessingException(fpe.getMessage(), (Throwable)fpe);
            }
        } else {
            filters = new ArrayList<CLIProto.Filter>();
        }
        return filters;
    }

    protected boolean hasMore(int origStart, int origLimit, int prevStart, int prevCount) {
        if (prevCount == 0) {
            LOG.info((Object)"in hasMore:: Last fetched record count is 0. no more records to fetch");
            return false;
        }
        int endIndex = 0;
        endIndex = origLimit == Integer.MAX_VALUE ? origLimit : origStart + origLimit;
        return endIndex > prevStart + prevCount;
    }

    @Override
    public void list(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        long time = System.currentTimeMillis();
        long start = System.currentTimeMillis();
        MessageLite req = null;
        MessageLite resp = null;
        while (req == null && resp == null || this.hasMore(req, resp)) {
            req = this.buildNextRequest(req, resp);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Perf::buildNextRequest() = " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            resp = this.sendRequest(req);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Perf::sendRequest() = " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            if (resp == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. Check if at least one CLDB is running."));
                return;
            }
            this.processResponse(out, resp);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Perf::processResponse() = " + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Perf::list() = " + (System.currentTimeMillis() - start)));
        }
    }

    @Override
    public abstract boolean hasMore(MessageLite var1, MessageLite var2) throws CLIProcessingException;

    @Override
    public abstract MessageLite buildNextRequest(MessageLite var1, MessageLite var2) throws CLIProcessingException;

    @Override
    public abstract MessageLite sendRequest(MessageLite var1) throws CLIProcessingException;

    @Override
    public abstract void processResponse(CommandOutput.OutputHierarchy var1, MessageLite var2) throws CLIProcessingException;
}

