/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.google.common.collect.Lists;
import com.mapr.baseutils.LogDirectoryFindingUtils;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.security.JNISecurity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public enum ServicesEnum {
    cldb("all", JNISecurity.IsSecurityEnabled((String)CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) ? String.valueOf(JNISecurity.GetCldbHttpsPort((String)CLDBRpcCommonUtils.getInstance().getCurrentClusterName())) : "7221", "/cldb.jsp", MapRCliUtil.getMapRInstallDir() + "/logs/cldb.log", "CLDB"),
    fileserver("all", "5660", null, MapRCliUtil.getMapRInstallDir() + "/logs/mfs.log", "FileServer"),
    jobtracker("1", "50030", "/jobtracker.jsp", ServicesEnum.fetchLogPath("classic"), "JobTracker"),
    nfs("all", "9998", null, MapRCliUtil.getMapRInstallDir() + "/logs/nfsserver.log", "NFS Gateway"),
    hbmaster("1", ServicesEnum.fetchHbasePort("16010", "60010"), "/master.jsp", ServicesEnum.fetchLogPath("hbase"), "HBase Master"),
    hbregionserver("all", ServicesEnum.fetchHbasePort("16030", "60030"), "/regionserver.jsp", ServicesEnum.fetchLogPath("hbase"), "HBase RegionServer"),
    tasktracker("all", "50060", "/tasktracker.jsp", ServicesEnum.fetchLogPath("classic"), "TaskTracker"),
    apiserver("all", "8443", "/app/mcs/", MapRCliUtil.getMapRInstallDir() + "/apiserver/logs/apiserver.log", "APIServer"),
    hoststats("all", null, null, MapRCliUtil.getMapRInstallDir() + "/logs/hoststats.log", "HostStats"),
    resourcemanager("1", JNISecurity.IsSecurityEnabled((String)CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) ? "8090" : "8088", "/cluster", ServicesEnum.fetchLogPath("yarn"), "ResourceManager"),
    nodemanager("all", JNISecurity.IsSecurityEnabled((String)CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) ? "8044" : "8042", "/", ServicesEnum.fetchLogPath("yarn"), "NodeManager"),
    historyserver("1", JNISecurity.IsSecurityEnabled((String)CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) ? "19890" : "19888", "/jobhistory", ServicesEnum.fetchLogPath("yarn"), "JobHistoryServer");

    private static final String LOG_DIR_NAME = "logs";
    private static FileFilter dirFilter;
    private String serviceTotal;
    private String port;
    private String webLink;
    private String logPath;
    private String displayName;

    private static String getVersion(String serviceDir, String file) {
        String serviceDirPath = MapRCliUtil.getMapRInstallDir() + "/" + serviceDir;
        try {
            BufferedReader fr = new BufferedReader(new FileReader(serviceDirPath + "/" + file));
            String version = fr.readLine();
            fr.close();
            if (version != null) {
                return version;
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    private static String fetchHbasePort(String newPort, String oldPort) {
        String[] hbaseSplit;
        String hbaseVersion = ServicesEnum.getVersion("hbase", "hbaseversion");
        if (!hbaseVersion.isEmpty() && (hbaseSplit = hbaseVersion.split("\\."))[0].equals("0")) {
            return oldPort;
        }
        return newPort;
    }

    private static String fetchLogPath(String serviceDir) {
        String hbaseVersion;
        JNISecurity.GetCldbHttpsPort((String)CLDBRpcCommonUtils.getInstance().getCurrentClusterName());
        String serviceDirPath = MapRCliUtil.getMapRInstallDir() + "/" + serviceDir;
        if ("hbase".equalsIgnoreCase(serviceDir) && !(hbaseVersion = ServicesEnum.getVersion(serviceDir, "hbaseversion")).isEmpty()) {
            serviceDirPath = serviceDirPath.concat("/hbase-" + hbaseVersion);
        }
        if ("classic".equalsIgnoreCase(serviceDir) || "yarn".equalsIgnoreCase(serviceDir)) {
            return LogDirectoryFindingUtils.getHadoopLogsDirectory((String)MapRCliUtil.getMapRInstallDir(), (String)serviceDir);
        }
        ArrayList dirs = Lists.newArrayList((Object[])new File[]{new File(serviceDirPath)});
        while (!dirs.isEmpty()) {
            ArrayList subDirs = Lists.newArrayList();
            for (File dir : dirs) {
                if (dir.getName().equals(LOG_DIR_NAME)) {
                    return dir.getAbsolutePath();
                }
                File[] childDirs = dir.listFiles(dirFilter);
                if (childDirs == null) continue;
                Collections.addAll(subDirs, childDirs);
            }
            dirs.clear();
            dirs.addAll(subDirs);
        }
        return serviceDirPath;
    }

    private ServicesEnum(String serviceTotalDefault, String port, String webLink, String logPath, String displayName) {
        this.serviceTotal = serviceTotalDefault;
        this.port = port;
        this.webLink = webLink;
        this.logPath = logPath;
        this.displayName = displayName;
    }

    private ServicesEnum(String serviceTotalDefault, String port) {
        this.serviceTotal = serviceTotalDefault;
        this.port = port;
    }

    private ServicesEnum(String serviceTotalDefault) {
        this.serviceTotal = serviceTotalDefault;
    }

    public String getserviceTotal() {
        return this.serviceTotal;
    }

    public String getServiceTotal() {
        return this.serviceTotal;
    }

    public String getWebLink() {
        return this.webLink;
    }

    public String getPort() {
        return this.port;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    static {
        dirFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
    }
}

