/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.ServiceCommands;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NagiosCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(NagiosCommands.class);
    static final CLICommand generateCmd = new CLICommand("generate", "generate", NagiosCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setShortUsage("generate");
    public static final CLICommand nagiosCmds = new CLICommand("nagios", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{generateCmd}).setShortUsage("nagios [generate]");

    public NagiosCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("generate")) {
            try {
                byte[] replyData;
                CLDBProto.FileServerListRequest req = CLDBProto.FileServerListRequest.newBuilder().setCreds(this.getUserCredentials()).setColumns(-1L).build();
                if (this.isParamPresent("cluster")) {
                    String cluster = this.getParamTextValue("cluster", 0);
                    if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                        return output;
                    }
                    replyData = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerListProc.getNumber(), (MessageLite)req, CLDBProto.FileServerListResponse.class);
                } else {
                    replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerListProc.getNumber(), (MessageLite)req, CLDBProto.FileServerListResponse.class);
                }
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.FileServerListResponse resp = CLDBProto.FileServerListResponse.parseFrom((byte[])replyData);
                if (resp == null || resp.getInfoCount() == 0) {
                    return output;
                }
                StringBuffer s = new StringBuffer();
                this.printCommands(s);
                for (CLDBProto.FileServerInfo fs : resp.getInfoList()) {
                    this.printHost(s, fs);
                }
                CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode("outputscript", (Object)s.toString()));
                out.addNode(node);
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed due to exception: " + e.getMessage()));
                LOG.error((Object)("Exception: " + e.getLocalizedMessage()));
            }
        }
        return output;
    }

    private void printCommands(StringBuffer s) {
        s.append("################################ Nagios Configuration File #############################\n\n################ Usage #############\n#1. Uncomment the templates in this file, if you already don't have a template.cfg in nagios directory\n#2. Copy this file to nagios directory\n#3. Edit nagios.cfg in nagios directory to include this file\n#4. Restart nagios server\n\n############# HOST TEMPLATES #############\n\n#define contact{\n#  name                            generic-contact         ; The name of this contact template\n#  service_notification_period     24x7                    ; service notifications can be sent anytime\n#  host_notification_period        24x7                    ; host notifications can be sent anytime\n#  service_notification_options    w,u,c,r,f,s             ; send notifications for all service states, flapping events, and scheduled downtime events\n#  host_notification_options       d,u,r,f,s               ; send notifications for all host states, flapping events, and scheduled downtime events\n#  service_notification_commands   notify-service-by-email ; send service notifications via email\n#  host_notification_commands      notify-host-by-email    ; send host notifications via email\n#  register                        0                       ; DONT REGISTER THIS DEFINITION - ITS NOT A REAL CONTACT, JUST A TEMPLATE!\n#}\n\n## Generic host definition template - This is NOT a real host, just a template!\n#define host {\n#        name                            generic-host    ; The name of this host template\n#        notifications_enabled           1               ; Host notifications are enabled\n#        event_handler_enabled           1               ; Host event handler is enabled\n#        flap_detection_enabled          1               ; Flap detection is enabled\n#        failure_prediction_enabled      1               ; Failure prediction is enabled\n#        process_perf_data               1               ; Process performance data\n#        retain_status_information       1               ; Retain status information across program restarts\n#        retain_nonstatus_information    1               ; Retain non-status information across program restarts\n#        notification_period             24x7            ; Send host notifications at any time\n#        register                        0               ; DONT REGISTER THIS DEFINITION - ITS NOT A REAL HOST, JUST A TEMPLATE!\n#}\n\n## Linux host definition template - This is NOT a real host, just a template!\n#define host {\n#        name                            linux-server    ; The name of this host template\n#        use                             generic-host    ; This template inherits other values from the generic-host template\n#        check_period                    24x7            ; By default, Linux hosts are checked round the clock\n#        check_interval                  5               ; Actively check the host every 5 minutes\n#        retry_interval                  1               ; Schedule host check retries at 1 minute intervals\n#        max_check_attempts              10              ; Check each Linux host 10 times (max)\n#        check_command                   check-host-alive ; Default command to check Linux hosts\n#        notification_period             workhours       ; Linux admins hate to be woken up, so we only notify during the day\n#                                                       ; Note that the notification_period variable is being overridden from\n#                                                        ; the value that is inherited from the generic-host template!\n#        notification_interval           120             ; Resend notifications every 2 hours\n#        notification_options            d,u,r           ; Only send notifications for specific host states\n#        contact_groups                  admins          ; Notifications get sent to the admins by default\n#        register                        0               ; DONT REGISTER THIS DEFINITION - ITS NOT A REAL HOST, JUST A TEMPLATE!\n#}\n\n############# SERVICE TEMPLATES #############\n\n## Generic service definition template - This is NOT a real service, just a template!\n#define service {\n#     name                            generic-service         ; The 'name' of this service template\n#     active_checks_enabled           1                       ; Active service checks are enabled\n#     passive_checks_enabled          1                       ; Passive service checks are enabled/accepted\n#     parallelize_check               1                       ; Active service checks should be parallelized (disabling this can lead to major performance problems)\n#     obsess_over_service             1                       ; We should obsess over this service (if necessary)\n#     check_freshness                 0                       ; Default is to NOT check service 'freshness'\n#     notifications_enabled           1                       ; Service notifications are enabled\n#     event_handler_enabled           1                       ; Service event handler is enabled\n#     flap_detection_enabled          1                       ; Flap detection is enabled\n#     failure_prediction_enabled      1                       ; Failure prediction is enabled\n#     process_perf_data               1                       ; Process performance data\n#     retain_status_information       1                       ; Retain status information across program restarts\n#     retain_nonstatus_information    1                       ; Retain non-status information across program restarts\n#     is_volatile                     0                       ; The service is not volatile\n#     check_period                    24x7                    ; The service can be checked at any time of the day\n#     max_check_attempts              3                       ; Re-check the service up to 3 times in order to determine its final (hard) state\n#     normal_check_interval           10                      ; Check the service every 10 minutes under normal conditions\n#     retry_check_interval            2                       ; Re-check the service every two minutes until a hard state can be determined\n#     contact_groups                  admins                  ; Notifications get sent out to everyone in the 'admins' group\n#     notification_options            w,u,c,r                 ; Send notifications about warning, unknown, critical, and recovery events\n#     notification_interval           60                      ; Re-notify about service problems every hour\n#     notification_period             24x7                    ; Notifications can be sent out at any time\n#     register                        0                       ; DONT REGISTER THIS DEFINITION - ITS NOT A REAL SERVICE, JUST A TEMPLATE!\n#}\n\n## Local service definition template - This is NOT a real service, just a template!\n#define service {\n#     name                            local-service           ; The name of this service template\n#     use                             generic-service         ; Inherit default values from the generic-service definition\n#     max_check_attempts              4                       ; Re-check the service up to 4 times in order to determine its final (hard) state\n#     normal_check_interval           5                       ; Check the service every 5 minutes under normal conditions\n#     retry_check_interval            1                       ; Re-check the service every minute until a hard state can be determined\n#     register                        0                       ; DONT REGISTER THIS DEFINITION - ITS NOT A REAL SERVICE, JUST A TEMPLATE!\n#}\n\n############# COMMANDS #############\n\ndefine command {\n  command_name    check_fileserver_proc\n  command_line    $USER1$/check_tcp  -H $HOSTADDRESS$ -p 5660\n}\n\ndefine command {\n   command_name    check_cldb_proc\n   command_line    $USER1$/check_tcp  -H $HOSTADDRESS$ -p 7222\n}\n\ndefine command {\n   command_name    check_jobtracker_proc\n   command_line    $USER1$/check_tcp  -H $HOSTADDRESS$ -p 50030\n}\n\ndefine command {\n   command_name    check_tasktracker_proc\n   command_line    $USER1$/check_tcp  -H $HOSTADDRESS$ -p 50060\n}\n\ndefine command {\n   command_name    check_nfs_proc\n   command_line    $USER1$/check_tcp  -H $HOSTADDRESS$ -p 2049\n}\n\ndefine command {\n   command_name    check_hbmaster_proc\n   command_line    $USER1$/check_tcp  -H $HOSTADDRESS$ -p 60000\n}\n\ndefine command {\n   command_name    check_hbregionserver_proc\n   command_line    $USER1$/check_tcp  -H $HOSTADDRESS$ -p 60020\n}\n\ndefine command {\n   command_name    check_webserver_proc\n   command_line    $USER1$/check_tcp  -H $HOSTADDRESS$ -p 8443\n}\n\n");
    }

    private void printHost(StringBuffer s, CLDBProto.FileServerInfo fs) {
        String hostname = MapRCliUtil.getHostname(fs);
        String ip = Util.intToIp((int)((Common.IPAddress)fs.getAddressList().get(0)).getHost());
        s.append("################# HOST: " + hostname + " ###############\n\ndefine host {\n  use linux-server\n  host_name " + hostname + "\n  address " + ip + "\n  check_command check-host-alive\n}\n\n");
        try {
            String zkConnectString = this.getZkConnectString();
            if (zkConnectString == null || zkConnectString.isEmpty()) {
                return;
            }
            Set<String> services = ServiceCommands.getConfiguredServices(Lists.newArrayList((Object[])new String[]{hostname}), null, zkConnectString);
            if (services == null || services.isEmpty() || services.size() == 0) {
                return;
            }
            for (String service : services) {
                if (!service.equalsIgnoreCase(ServicesEnum.cldb.toString()) && !service.equalsIgnoreCase(ServicesEnum.fileserver.toString()) && !service.equalsIgnoreCase(ServicesEnum.jobtracker.toString()) && !service.equalsIgnoreCase(ServicesEnum.nfs.toString()) && !service.equalsIgnoreCase(ServicesEnum.hbmaster.toString()) && !service.equalsIgnoreCase(ServicesEnum.hbregionserver.toString()) && !service.equalsIgnoreCase(ServicesEnum.tasktracker.toString()) && !service.equalsIgnoreCase(ServicesEnum.apiserver.toString())) continue;
                s.append("define service {\n  use local-service\n  host_name " + hostname + "\n  service_description " + service + "\n  check_command check_" + service + "_proc!" + hostname + "\n}\n\n");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while fetching services for host " + hostname + " " + e.getLocalizedMessage()));
        }
    }

    private String getZkConnectString() throws CLIProcessingException {
        String zkConnectString = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().getZkConnect(this.getParamTextValue("cluster", 0)) : CLDBRpcCommonUtils.getInstance().getZkConnect();
        if (zkConnectString != null) {
            zkConnectString = zkConnectString.trim();
        }
        return zkConnectString;
    }
}

