/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.DumpCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbreplicator;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Marlincommon;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FidCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String FID_COMMAND_FID_PARAM_NAME = "fid";
    private static final String FID_COMMAND_DIR_PARAM_NAME = "dirraw";
    private static final String FID_COMMAND_KVTYPE_PARAM_NAME = "kvtype";
    private static final String FID_COMMAND_HOST_PARAM_NAME = "host";
    private static final String FID_COMMAND_PORT_PARAM_NAME = "port";
    private static final String FID_COMMAND_TABLE_PARAM_NAME = "path";
    private static final String FID_COMMAND_CID_PARAM_NAME = "cid";
    private static final String FID_COMMAND_FTYPE_PARAM_NAME = "ftype";
    private static final String FID_COMMAND_DUMPFULLKEYS_PARAM_NAME = "dumpfullkeys";
    private static final String FID_COMMAND_KEYIDXVERSION_PARAM_NAME = "keyidxversion";
    private static final String FID_COMMAND_FID_PARAM_DESC = "fid";
    private static final String FID_COMMAND_DIR_PARAM_DESC = "scan directory inode as kvstore";
    private static final String FID_COMMAND_KVTYPE_PARAM_DESC = "cldb kvtype: cinfo|csize|cmap|fsprop|spprop|vprop|sinfo";
    private static final String FID_COMMAND_HOST_PARAM_DESC = "IP/hostname";
    private static final String FID_COMMAND_PORT_PARAM_DESC = "port";
    private static final String FID_COMMAND_TABLE_PARAM_DESC = "table path";
    private static final String FID_COMMAND_CID_PARAM_DESC = "container id";
    private static final String FID_COMMAND_FTYPE_PARAM_DESC = "table|tabletmap|tablet|segmap|spillmap";
    private static final String FID_COMMAND_DUMPFULLKEYS_PARAM_DESC = "dump full keys <true|false>";
    private static final String FID_COMMAND_KEYIDXVERSION_PARAM_DESC = "key index version";
    public static final String MULTI_ARG_SEP = ",";
    public static final String COLUMN_SEP = ":";
    private static final Logger LOG = Logger.getLogger(DumpCommands.class);
    private static Pattern printableStringName = Pattern.compile("\\p{Print}+");
    static String statUsage = "stat -fid fidx";
    static String dumpUsage = "dump -fid fid";
    private static final int DefaultGatewayPort = 7660;
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    static final CLICommand dump = new CLICommand("dump", "Usage : " + dumpUsage, FidCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).put((Object)"kvtype", (Object)new TextInputParameter("kvtype", "cldb kvtype: cinfo|csize|cmap|fsprop|spprop|vprop|sinfo", false, null)).put((Object)"dirraw", (Object)new BooleanInputParameter("dirraw", "scan directory inode as kvstore", false, Boolean.valueOf(false))).build(), null).setShortUsage(dumpUsage);
    static final CLICommand stat = new CLICommand("stat", "usage : " + statUsage, FidCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage(statUsage);
    String clusterName = null;

    public FidCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void init() throws CLIProcessingException {
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Failed to initalize RPC");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in Rpc.initialize " + e));
        }
    }

    public long getLong(byte[] b) {
        long number = 0L;
        for (int len = b.length; len > 0; --len) {
            number <<= 8;
            number += (long)(b[len - 1] & 0xFF);
        }
        return number;
    }

    public NameEnt getNameEnt(ByteString bs, int offset) {
        NameEnt ent = new NameEnt();
        ent.cid = this.getLong(bs.substring(offset, offset + 4).toByteArray());
        ent.cinum = this.getLong(bs.substring(offset + 4, offset + 8).toByteArray());
        ent.uniq = this.getLong(bs.substring(offset + 8, offset + 12).toByteArray());
        ent.nmlen = (int)this.getLong(bs.substring(offset + 12, offset + 14).toByteArray());
        ent.name = new String(bs.substring(offset + 16, offset + 15 + ent.nmlen).toByteArray());
        byte b = bs.byteAt(offset + 15);
        ent.ftype = b & 0x1F;
        return ent;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        if (!super.validateInput()) {
            return this.output;
        }
        this.clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase("dump")) {
                return this.dump();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("stat")) {
                return this.stat();
            }
            return new TextCommandOutput("Fid unknown sub-command".getBytes());
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private Common.FidMsg stringToFid(String s) {
        String[] temp = s.split("\\.");
        if (temp.length != 3) {
            return null;
        }
        int cid = Integer.parseInt(temp[0]);
        int cinum = Integer.parseInt(temp[1]);
        int uniq = Integer.parseInt(temp[2]);
        return Common.FidMsg.newBuilder().setCid(cid).setCinum(cinum).setUniq(uniq).build();
    }

    private CommandOutput getDumpFromFid(Common.FidMsg fid, boolean dirraw, KVFormatType kvtype, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        KVFormatType ftype = KVFormatType.INVALID;
        if (this.isParamPresent(FID_COMMAND_FTYPE_PARAM_NAME)) {
            String ftypestr = this.getParamTextValue(FID_COMMAND_FTYPE_PARAM_NAME, 0);
            if (ftypestr.equalsIgnoreCase("table")) {
                ftype = KVFormatType.TABLE;
            } else if (ftypestr.equalsIgnoreCase("tabletmap")) {
                ftype = KVFormatType.TABLET_MAP;
            } else if (ftypestr.equalsIgnoreCase("tablet")) {
                ftype = KVFormatType.TABLET;
            } else if (ftypestr.equalsIgnoreCase("segmap")) {
                ftype = KVFormatType.SEGMENT_MAP;
            } else if (ftypestr.equalsIgnoreCase("spillmap")) {
                ftype = KVFormatType.SPILL_MAP;
            } else if (ftypestr.equalsIgnoreCase("dir")) {
                ftype = KVFormatType.DIR;
            } else if (ftypestr.equalsIgnoreCase("defermap")) {
                ftype = KVFormatType.DEFER_MAP;
            }
            if (ftype == KVFormatType.INVALID) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ftype " + ftypestr));
                this.output.setOutput(out);
                return this.output;
            }
        } else {
            Fileserver.GetattrResponse resp;
            long dbinding = this.getBindingForContainer(fid.getCid());
            if (dbinding == -1L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
                return this.output;
            }
            Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).build();
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                    return this.output;
                }
                resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString((int)resp.getStatus())));
                    return this.output;
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing stat command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return this.output;
            }
            Common.FileType itype = resp.getAttr().getType();
            Common.FileSubType subtype = resp.getAttr().getSubtype();
            if (itype == Common.FileType.FTDirectory) {
                ftype = KVFormatType.DIR;
            } else if (itype == Common.FileType.FTRegular) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot dump files of itype " + itype + " subtype " + subtype));
            } else if (itype == Common.FileType.FTKvstore) {
                ftype = subtype == Common.FileSubType.FSTKvTable ? KVFormatType.TABLE : (subtype == Common.FileSubType.FSTKvTabletMap ? KVFormatType.TABLET_MAP : (subtype == Common.FileSubType.FSTKvSchema ? KVFormatType.SCHEMA_INFO : (subtype == Common.FileSubType.FSTKvTablet ? KVFormatType.TABLET : (subtype == Common.FileSubType.FSTKvSegMap ? KVFormatType.SEGMENT_MAP : (subtype == Common.FileSubType.FSTKvSpillMap ? KVFormatType.SPILL_MAP : (subtype == Common.FileSubType.FSTKvIndexTable ? KVFormatType.INDEX_TABLE : (fid.getCinum() == 22 ? KVFormatType.DEFER_MAP : (kvtype != null ? kvtype : KVFormatType.GENERIC_KV))))))));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot dump files of itype " + itype));
                return this.output;
            }
        }
        Fileserver.KvStoreKey kstart = null;
        Fileserver.KvStoreKey kend = null;
        int maxkeys = 0;
        boolean idxoffset = false;
        boolean idxsize = false;
        if (ftype == KVFormatType.DIR && !dirraw) {
            this.dumpDir(fid, out);
        } else {
            this.dumpKeyValues(fid, ftype, kstart, kend, maxkeys, out);
        }
        return this.output;
    }

    private CommandOutput dump() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String fidstr = this.getParamTextValue("fid", 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        boolean dirraw = false;
        String kvtypeStr = null;
        KVFormatType kvtype = null;
        if (this.isParamPresent(FID_COMMAND_DIR_PARAM_NAME)) {
            dirraw = this.getParamBooleanValue(FID_COMMAND_DIR_PARAM_NAME, 0);
            kvtype = KVFormatType.GENERIC_KV;
        }
        if (this.isParamPresent(FID_COMMAND_KVTYPE_PARAM_NAME)) {
            kvtypeStr = this.getParamTextValue(FID_COMMAND_KVTYPE_PARAM_NAME, 0);
            if (kvtypeStr.equals("cinfo")) {
                kvtype = KVFormatType.CLDB_CONTAINER_INFO;
            } else if (kvtypeStr.equals("csize")) {
                kvtype = KVFormatType.CLDB_CONTAINER_SIZE_INFO;
            } else if (kvtypeStr.equals("cmap")) {
                kvtype = KVFormatType.CLDB_CID_MAP;
            } else if (kvtypeStr.equals("fsprop")) {
                kvtype = KVFormatType.CLDB_FS_PROP;
            } else if (kvtypeStr.equals("spprop")) {
                kvtype = KVFormatType.CLDB_SP_PROP;
            } else if (kvtypeStr.equals("sinfo")) {
                kvtype = KVFormatType.CLDB_SNAPSHOT_INFO;
            } else if (kvtypeStr.equals("vname")) {
                kvtype = KVFormatType.CLDB_VOLUME_NAME;
            } else if (kvtypeStr.equals("vprop")) {
                kvtype = KVFormatType.CLDB_VOLUME_PROP;
            } else if (kvtypeStr.equals("vaces")) {
                kvtype = KVFormatType.CLDB_VOLUME_ACES;
            } else if (kvtypeStr.equals("vquota")) {
                kvtype = KVFormatType.CLDB_VOLUME_QUOTA;
            } else if (kvtypeStr.equals("smap")) {
                kvtype = KVFormatType.MFS_SNAP_MAP;
            }
        }
        this.getDumpFromFid(fid, dirraw, kvtype, out);
        return output;
    }

    private CommandOutput stat() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int version = this.getVersion();
        String fidstr = this.getParamTextValue("fid", 0);
        Common.FidMsg fid = this.stringToFid(fidstr);
        if (fid == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid fid " + fidstr));
            output.setOutput(out);
            return output;
        }
        long dbinding = this.getBindingForContainer(fid.getCid());
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return output;
        }
        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "getattr rpc failed"));
                return output;
            }
            Fileserver.GetattrResponse resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
            CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
            if (resp.getStatus() == 0) {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)resp.getAttr().getType(), version));
                String subtype = this.printableSubType(resp.getAttr().getType(), resp.getAttr().getSubtype());
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("subtype", (Object)subtype));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("parent", (Object)this.printableFid(resp.getAttr().getParent())));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("size", resp.getAttr().getSize()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nblocks", resp.getAttr().getNblocks()));
                String cs = "off";
                if (resp.getAttr().getCanCompress()) {
                    cs = this.getCompressionType(Common.FileCompressionType.valueOf((int)resp.getAttr().getCompressorType()));
                }
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("compression", (Object)cs));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteFlags", (Object)resp.getAttr().getDeleteFlags()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("atime", resp.getAttr().getAtime().getSec()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mtime", resp.getAttr().getMtime().getSec()));
                int mode = resp.getAttr().getMode();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("mode", (Object)Integer.toOctalString(mode)));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("uid", resp.getAttr().getUid()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("gid", resp.getAttr().getGid()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nlink", resp.getAttr().getNlink()));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("xattrInum", resp.getAttr().getXattrInum()));
                if (resp.getAttr().hasVersion()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", resp.getAttr().getVersion()));
                }
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("networkencryption", (Object)resp.getAttr().getWireSecurityEnabled()));
                out.addNode(dout);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetAttr failed, Error : " + Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing stat command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput getHostNames() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        int version = this.getVersion();
        String ipStr = this.getParamTextValue(FID_COMMAND_HOST_PARAM_NAME, 0);
        Common.IPAddress gatewayIp = this.buildIPFromString(ipStr);
        if (gatewayIp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid gateway host " + ipStr));
            output.setOutput(out);
            return output;
        }
        int gatewayPort = this.getParamIntValue("port", 0);
        long dbinding = this.getBindingForGateway(gatewayIp.getHost(), gatewayPort);
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Gateway connect failed"));
            return output;
        }
        Dbreplicator.GetHostNamesRequest req = Dbreplicator.GetHostNamesRequest.newBuilder().setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBReplicatorServerProgramId.getNumber(), (int)Dbreplicator.DBReplicatorProg.GetHostNamesProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "gethostnames rpc failed"));
                return output;
            }
            Dbreplicator.GetHostNamesResponse resp = Dbreplicator.GetHostNamesResponse.parseFrom((byte[])replyData);
            CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
            if (resp.getStatus() == 0) {
                for (String name : resp.getNamesList()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("HostNames", (Object)name));
                }
                out.addNode(dout);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetHostNames failed, Error : " + Errno.toString((int)resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception processing getHostNames command");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
        }
        output.setOutput(out);
        return output;
    }

    private long getBindingForContainer(int cid) throws CLIProcessingException {
        int dbPort;
        int dbHost;
        CLDBProto.ContainerLookupRequest creq = CLDBProto.ContainerLookupRequest.newBuilder().addContainerId(cid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)creq, CLDBProto.ContainerLookupResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                return -1L;
            }
            CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                LOG.error((Object)("Container lookup failed : Error " + Errno.toString((int)resp.getStatus())));
                return -1L;
            }
            Common.Server server = resp.getContainers(0).getMServer();
            dbHost = server.getIps(0).getHost();
            dbPort = server.getIps(0).getPort();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Container lookup failed");
            return -1L;
        }
        return Rpc.createBindingFor((int)dbHost, (int)dbPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    private ByteString binaryKeyToByteString(String raws) {
        byte[] bArr = BinaryString.toBytesBinary((String)raws);
        return ByteString.copyFrom((byte[])bArr);
    }

    private ByteString prepareVarKey(String raws) {
        return this.binaryKeyToByteString(raws);
    }

    private CommandOutput.OutputHierarchy.OutputNode formatDirEntry(MapRFileStatus d) {
        String childFid = d.getCid() + "." + d.getCinum() + "." + d.getUniq();
        String s = d.getPath().toString();
        int l = s.lastIndexOf(47);
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("name", (Object)s.substring(l + 1)));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)childFid));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isDir", (Object)d.isDir()));
        return dout;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatKeyMapEntry(Dbserver.KeyMapEntry ent) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        Object bs = null;
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("shared", ent.getSharedLen()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("nonshared", ent.getNonsharedLen()));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", ent.getValueLen()));
        if (ent.hasBlkOff()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("childblockoffset", ent.getBlkOff()));
        }
        if (ent.hasBlkSize()) {
            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("childblocksize", ent.getBlkSize()));
        }
        if (!ent.hasBlkOff() && !ent.hasBlkSize()) {
            try {
                Dbserver.SpillKeyEntry spillVal = ent.hasKvalue() ? ent.getKvalue() : Dbserver.SpillKeyEntry.parseFrom((ByteString)ent.getValue());
                if (spillVal.hasInlineValue()) {
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlineValue", (Object)this.printableKey(spillVal.getInlineValue().toByteArray())));
                    dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlineValueSz", spillVal.getInlineValue().size()));
                }
                int cnt = spillVal.getValuesCount();
                for (int index = 0; index < cnt; ++index) {
                    CommandOutput.OutputHierarchy.OutputNode valueout = new CommandOutput.OutputHierarchy.OutputNode("familyData");
                    boolean addFamily = false;
                    Dbserver.SpillKeyEntry.FamilyValue fv = spillVal.getValues(index);
                    if (fv.hasId()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", fv.getId()));
                        addFamily = true;
                    }
                    if (fv.hasOffset()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", fv.getOffset()));
                        addFamily = true;
                    }
                    if (fv.hasLength()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", fv.getLength()));
                        addFamily = true;
                    }
                    if (fv.hasInlined()) {
                        valueout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inlined", (Object)fv.getInlined()));
                        addFamily = true;
                    }
                    if (!addFamily) continue;
                    dout.addChild(valueout);
                }
            }
            catch (Throwable e) {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("error", (Object)"PARSE ERROR"));
            }
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(ent.getKey().toByteArray())));
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", (Object)this.printableKey(ent.getValue().toByteArray())));
        return dout;
    }

    private void dumpIPAddress(String val, Common.IPAddress ip, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode ipOut = new CommandOutput.OutputHierarchy.OutputNode(val);
        out.addChild(ipOut);
        if (ip.hasHost()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)(Util.intToIp((int)ip.getHost()) + COLUMN_SEP + ip.getPort())));
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode(FID_COMMAND_HOST_PARAM_NAME, ip.getHost()));
        }
        if (ip.hasPort()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("port", ip.getPort()));
        }
        if (ip.hasSyncReplica()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("syncReplica", (Object)ip.getSyncReplica()));
        }
        if (ip.hasEpoch()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("epoc", ip.getEpoch()));
        }
        if (ip.hasHostname()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostname", (Object)ip.getHostname()));
        }
        if (ip.hasState()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("state", (Object)ip.getState()));
        }
        if (ip.hasResync()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("resync", (Object)ip.getResync()));
        }
        if (ip.hasVirtualIP()) {
            ipOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("virtualip", ip.getVirtualIP()));
        }
    }

    private void dumpServer(String val, Common.Server s, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode sout = new CommandOutput.OutputHierarchy.OutputNode(val);
        out.addChild(sout);
        if (s.hasServerId()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("serverId", s.getServerId()));
        }
        if (s.hasSyncReplica()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("syncReplica", (Object)s.getSyncReplica()));
        }
        if (s.hasEpoch()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("epoch", s.getEpoch()));
        }
        if (s.hasState()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("state", (Object)s.getState()));
        }
        if (s.hasResync()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("resync", (Object)s.getResync()));
        }
        if (s.hasHostname()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostname", (Object)s.getHostname()));
        }
        if (s.hasFixedByFsck()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fixedByFsck", (Object)s.getFixedByFsck()));
        }
        if (s.hasChosenSp()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("chosensp", (Object)s.getChosenSp()));
        }
        if (s.hasTopology()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("topology", (Object)s.getTopology()));
        }
        if (s.hasDeleteAfterRepl()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteafterrepl", (Object)s.getDeleteAfterRepl()));
        }
        if (s.hasPliId()) {
            sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("pliid", s.getPliId()));
        }
        if (s.hasSpInfo()) {
            Common.StoragePoolInfo sp = s.getSpInfo();
            CommandOutput.OutputHierarchy.OutputNode si = new CommandOutput.OutputHierarchy.OutputNode("spInfo: ");
            sout.addChild(si);
            if (sp.hasSpId()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("spId", (Object)sp.getSpId()));
            }
            if (sp.hasClusterUuid()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("clusterUuid H", sp.getClusterUuid().getId640()));
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("clusterUuid L", sp.getClusterUuid().getId641()));
            }
            if (sp.hasCapacitySizeMB()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("capacitysizemb", sp.getCapacitySizeMB()));
            }
            if (sp.hasUsedSizeMB()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("usedsizemb", sp.getUsedSizeMB()));
            }
            if (sp.hasAvailableSizeMB()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("availablesizemb", sp.getAvailableSizeMB()));
            }
            if (sp.hasOnlineCount()) {
                si.addChild(new CommandOutput.OutputHierarchy.OutputNode("onlineCount", sp.getOnlineCount()));
            }
        }
        if (s.getSecondaryPortsCount() != 0) {
            int k = 0;
            Iterator iterator = s.getSecondaryPortsList().iterator();
            while (iterator.hasNext()) {
                int port = (Integer)iterator.next();
                sout.addChild(new CommandOutput.OutputHierarchy.OutputNode("secPort" + k, port));
                ++k;
            }
        }
        if (s.getIpsCount() != 0) {
            int k = 0;
            for (Common.IPAddress ip : s.getIpsList()) {
                this.dumpIPAddress("ip" + k, ip, sout);
                ++k;
            }
        }
    }

    private void dumpServers(String stypeStr, List<Common.Server> slist, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode ssOut = new CommandOutput.OutputHierarchy.OutputNode(stypeStr);
        out.addChild(ssOut);
        int i = 0;
        for (Common.Server s : slist) {
            this.dumpServer("Server" + i, s, ssOut);
        }
    }

    private void dumpContainerInfo(CLDBProto.ContainerInfo ci, CommandOutput.OutputHierarchy.OutputNode out) {
        if (ci.hasVolumeId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volid", ci.getVolumeId()));
        }
        if (ci.hasContainerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("cid ", ci.getContainerId()));
        }
        if (ci.hasVolumeId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId ", ci.getVolumeId()));
        }
        if (ci.hasSnapshotId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapId ", ci.getSnapshotId()));
        }
        if (ci.hasLatestEpoch()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("latestEpoch ", ci.getLatestEpoch()));
        }
        if (ci.hasRwContainerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("rwCid ", ci.getRwContainerId()));
        }
        if (ci.hasRwVolumeId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("rwVolId ", ci.getRwVolumeId()));
        }
        if (ci.hasNameContainer()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("isNameContainer ", (Object)ci.getNameContainer()));
        }
        if (ci.hasMirrorContainer()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("mirrorCid ", ci.getMirrorContainer()));
        }
        if (ci.hasType()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ReplType ", (Object)ci.getType()));
        }
        if (ci.hasLogicalSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("logicalSzMB ", ci.getLogicalSizeMB()));
        }
        if (ci.hasChainSeqNumber()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("chainSeqNumber ", ci.getChainSeqNumber()));
        }
        if (ci.hasOwnedSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ownedSzMB ", ci.getOwnedSizeMB()));
        }
        if (ci.hasSharedSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("sharedSzMB ", ci.getSharedSizeMB()));
        }
        if (ci.hasFixedByFsck()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("isFixedByFsck ", (Object)ci.getFixedByFsck()));
        }
        if (ci.hasMtime()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("mtime ", ci.getMtime()));
        }
        if (ci.hasChainSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("chainSzMB ", ci.getChainSizeMB()));
        }
        if (ci.hasHasForcedMaster()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("hasForcedMaster ", (Object)ci.getHasForcedMaster()));
        }
        if (ci.hasNumInumUsed()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numinumused ", ci.getNumInumUsed()));
        }
        if (ci.hasSalt()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("salt ", (Object)ci.getSalt()));
        }
        if (ci.hasCreatorContainerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("creatorCid ", ci.getCreatorContainerId()));
        }
        if (ci.hasCreatorVolumeUuid()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("creatorVolumeId H", ci.getCreatorVolumeUuid().getId640()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("creatorVolumeId L", ci.getCreatorVolumeUuid().getId641()));
        }
        if (ci.hasUseActualCreatorId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("useActualCreatorId ", (Object)ci.getUseActualCreatorId()));
        }
        if (ci.hasSnapshotsOwnedSize()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapOSize ", ci.getSnapshotsOwnedSize()));
        }
        if (ci.hasMServer()) {
            this.dumpServer("Master", ci.getMServer(), out);
        }
        if (ci.getAServersCount() != 0) {
            this.dumpServers("active: ", ci.getAServersList(), out);
        }
        if (ci.getIServersCount() != 0) {
            this.dumpServers("inactive: ", ci.getIServersList(), out);
        }
        if (ci.getUServersCount() != 0) {
            this.dumpServers("unused", ci.getUServersList(), out);
        }
        if (ci.getUnreachableServersCount() != 0) {
            this.dumpServers("unreachable", ci.getUnreachableServersList(), out);
        }
    }

    private void dumpContainerInfo(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.ContainerInfo ci = CLDBProto.ContainerInfo.parseFrom((ByteString)val);
            this.dumpContainerInfo(ci, out);
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
        }
    }

    private void dumpContainerSizeInfo(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.ContainerSizeInfo csi = CLDBProto.ContainerSizeInfo.parseFrom((ByteString)val);
            if (csi.hasContainerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("containerId", csi.getContainerId()));
            }
            if (csi.hasVolumeId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volumeId", csi.getVolumeId()));
            }
            if (csi.hasSnapshotId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapshotID", csi.getSnapshotId()));
            }
            if (csi.hasLogicalSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("logcialSizeMB", csi.getLogicalSizeMB()));
            }
            if (csi.hasOwnedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ownedSizeMB", csi.getOwnedSizeMB()));
            }
            if (csi.hasSharedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("sharedSizeMB", csi.getSharedSizeMB()));
            }
            if (csi.hasMtime()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("mtime", csi.getMtime()));
            }
            if (csi.hasChainSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("chainSizeMB", csi.getChainSizeMB()));
            }
            if (csi.hasNumInumUsed()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("numInodeSize", csi.getNumInumUsed()));
            }
            if (csi.hasSnapshotsOwnedSize()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapOwned", csi.getSnapshotsOwnedSize()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FID_COMMAND_CID_PARAM_NAME, (Object)"UNKNOWN"));
        }
    }

    private void dumpSnapshotInfo(CLDBProto.SnapshotInfo si, CommandOutput.OutputHierarchy.OutputNode out) {
        if (si.hasSnapshotId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotId", si.getSnapshotId()));
        }
        if (si.hasRwVolumeId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RwVolid", si.getRwVolumeId()));
        }
        if (si.hasCostCentreId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CostCentreId", si.getCostCentreId()));
        }
        if (si.hasCreateTime()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CreateTime", si.getCreateTime()));
        }
        if (si.hasDeleteTime()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("DeleteTime", si.getDeleteTime()));
        }
        if (si.hasSnapshotName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotName", (Object)si.getSnapshotName()));
        }
        if (si.hasRootContainerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootContainerId", si.getRootContainerId()));
        }
        if (si.hasRwVolumeName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RwVolumeName", (Object)si.getRwVolumeName()));
        }
        if (si.hasIsMirrorSnapshot()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("IsMirrorSnapshot", (Object)si.getIsMirrorSnapshot()));
        }
        if (si.hasSnapshotInProgress()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotInProgress", (Object)si.getSnapshotInProgress()));
        }
        if (si.hasSnapshotOwnedSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotOwnedSizeMB", si.getSnapshotOwnedSizeMB()));
        }
        if (si.hasSnapshotSharedSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotSharedSizeMB", si.getSnapshotSharedSizeMB()));
        }
        if (si.hasMountDir()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MountDir", (Object)si.getMountDir()));
        }
        if (si.hasOwnerId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("OwnerId", si.getOwnerId()));
        }
        if (si.hasDataSrcSnapCreateTimeMillis()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("DataSrcSnapCreateTimeMillis", si.getDataSrcSnapCreateTimeMillis()));
        }
        if (si.hasVerifier()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Verifier", si.getVerifier()));
        }
        if (si.hasSnapshotCumulativeReclaimSizeMB()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SnapshotCumulativeReclaimSizeMB", si.getSnapshotCumulativeReclaimSizeMB()));
        }
        if (si.hasDeleteInProg()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("DeleteInProg", (Object)si.getDeleteInProg()));
        }
        if (si.hasRootCidGenerationId()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootCidGenerationId", si.getRootCidGenerationId()));
        }
    }

    private void dumpSnapshotInfo(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.SnapshotInfo si = CLDBProto.SnapshotInfo.parseFrom((ByteString)val);
            this.dumpSnapshotInfo(si, out);
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapId", (Object)"UNKNOWN"));
        }
    }

    private void dumpVolumeProperties(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.VolumeProperties vp = CLDBProto.VolumeProperties.parseFrom((ByteString)val);
            if (vp.hasVolumeId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeId", vp.getVolumeId()));
            }
            if (vp.hasVolumeName()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeName", (Object)vp.getVolumeName()));
            }
            if (vp.hasRootContainerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootContainerId", vp.getRootContainerId()));
            }
            if (vp.hasMountDir()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MountDir", (Object)vp.getMountDir()));
            }
            if (vp.hasVolumeQuotaSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeQuotaSizeMB", vp.getVolumeQuotaSizeMB()));
            }
            if (vp.hasReadOnly()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ReadOnly", (Object)vp.getReadOnly()));
            }
            if (vp.hasMounted()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Mounted", (Object)vp.getMounted()));
            }
            if (vp.hasLocalVolume()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("LocalVolume", (Object)vp.getLocalVolume()));
            }
            if (vp.hasOwnerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("OwnerId", vp.getOwnerId()));
            }
            if (vp.hasIsMirrorVol()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("IsMirrorVol", (Object)vp.getIsMirrorVol()));
            }
            if (vp.hasSchedulingPolicyId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SchedulingPolicyId", vp.getSchedulingPolicyId()));
            }
            if (vp.hasVolumeQuotaAdvisorySizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeQuotaAdvisorySizeMB", vp.getVolumeQuotaAdvisorySizeMB()));
            }
            if (vp.hasSchedulingPolicyName()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("SchedulingPolicyName", (Object)vp.getSchedulingPolicyName()));
            }
            if (vp.hasNumContainers()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumContainers", vp.getNumContainers()));
            }
            if (vp.hasNumSnapshots()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumSnapshots", vp.getNumSnapshots()));
            }
            if (vp.hasParentVolumeId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ParentVolumeId", vp.getParentVolumeId()));
            }
            if (vp.hasRootDirPerms()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootDirPerms", vp.getRootDirPerms()));
            }
            if (vp.hasRootDirUser()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootDirUser", vp.getRootDirUser()));
            }
            if (vp.hasRootDirGroup()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("RootDirGroup", vp.getRootDirGroup()));
            }
            if (vp.hasReReplicationTimeOutSec()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ReReplicationTimeOutSec", vp.getReReplicationTimeOutSec()));
            }
            if (vp.hasCriticalReReplicationTimeOutSec()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CriticalReReplicationTimeOutSec", vp.getCriticalReReplicationTimeOutSec()));
            }
            if (vp.hasInGfsck()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("InGfsck", (Object)vp.getInGfsck()));
            }
            if (vp.hasShuffleVolume()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ShuffleVolume", (Object)vp.getShuffleVolume()));
            }
            if (vp.hasVolumeUUID()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeUUID", vp.getVolumeUUID()));
            }
            if (vp.hasDeleteInProg()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("DeleteInProg", (Object)vp.getDeleteInProg()));
            }
            if (vp.hasNeedsGfsck()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NeedsGfsck", (Object)vp.getNeedsGfsck()));
            }
            if (vp.hasMaxInodesAlarmThreshold()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MaxInodesAlarmThreshold", vp.getMaxInodesAlarmThreshold()));
            }
            if (vp.hasMaxSizeSeenSoFar()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MaxSizeSeenSoFar", vp.getMaxSizeSeenSoFar()));
            }
            if (vp.hasNewAclFormat()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NewAclFormat", (Object)vp.getNewAclFormat()));
            }
            if (vp.hasVolumetype()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Volumetype", (Object)vp.getVolumetype()));
            }
            if (vp.hasCreatorContainerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CreatorContainerId", vp.getCreatorContainerId()));
            }
            if (vp.hasLimitVolumeSpread()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("LimitVolumeSpread", (Object)vp.getLimitVolumeSpread()));
            }
            if (vp.hasMirrorSchedulingPolicyId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MirrorSchedulingPolicyId", vp.getMirrorSchedulingPolicyId()));
            }
            if (vp.hasMirrorThrottle()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MirrorThrottle", (Object)vp.getMirrorThrottle()));
            }
            if (vp.hasNumNamespaceReplicas()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumNamespaceReplicas", vp.getNumNamespaceReplicas()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId", (Object)"UNKNOWN"));
        }
    }

    private void dumpVolumeQuota(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.VolumeQuotaInfo vq = CLDBProto.VolumeQuotaInfo.parseFrom((ByteString)val);
            if (vq.hasCostCenterId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("CostCenterId", vq.getCostCenterId()));
            }
            if (vq.hasVolumeQuotaSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeQuotaSizeMB", vq.getVolumeQuotaSizeMB()));
            }
            if (vq.hasVolumeUsedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeUsedSizeMB", vq.getVolumeUsedSizeMB()));
            }
            if (vq.hasVolumeAdvisoryQuotaSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeAdvisoryQuotaSizeMB", vq.getVolumeAdvisoryQuotaSizeMB()));
            }
            if (vq.hasVolumeLogicalUsedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeLogicalUsedSizeMB", vq.getVolumeLogicalUsedSizeMB()));
            }
            if (vq.hasVolumeOwnedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeOwnedSizeMB", vq.getVolumeOwnedSizeMB()));
            }
            if (vq.hasVolumeSharedSizeMB()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeSharedSizeMB", vq.getVolumeSharedSizeMB()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId", (Object)"UNKNOWN"));
        }
    }

    private void dumpVolumeAces(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            Common.VolumeAces va = Common.VolumeAces.parseFrom((ByteString)val);
            if (va.getAcesCount() != 0) {
                int k = 0;
                for (Common.VolumeAceEntry vae : va.getAcesList()) {
                    CommandOutput.OutputHierarchy.OutputNode aeOut = new CommandOutput.OutputHierarchy.OutputNode("ace" + k);
                    out.addChild(aeOut);
                    if (vae.hasExpr()) {
                        aeOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("expr", (Object)vae.getExpr()));
                    }
                    if (vae.hasAccessType()) {
                        aeOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("accessType", (Object)vae.getAccessType()));
                    }
                    ++k;
                }
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId", (Object)"UNKNOWN"));
        }
    }

    private void dumpVolumeTableId(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.VolumeTableId vp = CLDBProto.VolumeTableId.parseFrom((ByteString)val);
            if (vp.hasVolumeId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("VolumeId", vp.getVolumeId()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("volId", (Object)"UNKNOWN"));
        }
    }

    private void dumpUint32(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        BigInteger bi = new BigInteger(val.toByteArray());
        out.addChild(new CommandOutput.OutputHierarchy.OutputNode("u32", Integer.reverseBytes(bi.intValue())));
    }

    private void dumpMfsNodeConfiguration(CLDBProto.MfsNodeConfiguration nc, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode ncOut = new CommandOutput.OutputHierarchy.OutputNode("MfsNodeConfig");
        out.addChild(ncOut);
        if (nc.hasNumCpus()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumCpus", nc.getNumCpus()));
        }
        if (nc.hasAvailableMemory()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("AvailableMemory", nc.getAvailableMemory()));
        }
        if (nc.hasNumSps()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumSps", nc.getNumSps()));
        }
        if (nc.hasNumInstances()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumInstances", nc.getNumInstances()));
        }
        if (nc.hasNumSSDSps()) {
            ncOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumSSDSps", nc.getNumSSDSps()));
        }
    }

    private void dumpMfsInstancesInfo(CLDBProto.MfsInstancesInfo ii, CommandOutput.OutputHierarchy.OutputNode out) {
        CommandOutput.OutputHierarchy.OutputNode iiOut = new CommandOutput.OutputHierarchy.OutputNode("MfsInstancesInfo");
        out.addChild(iiOut);
        if (ii.hasNumSpsPerInstance()) {
            iiOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumSpsPerInstance", ii.getNumSpsPerInstance()));
        }
        if (ii.hasNumInstances()) {
            iiOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumInstances", ii.getNumInstances()));
        }
        if (ii.hasNumReportedInstances()) {
            iiOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("NumReportedInstances", ii.getNumReportedInstances()));
        }
        if (ii.hasMemoryPerInstance()) {
            iiOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("MemoryPerInstance", ii.getMemoryPerInstance()));
        }
    }

    private void dumpFSProperties(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            int k;
            CLDBProto.FileServerProperties fsp = CLDBProto.FileServerProperties.parseFrom((ByteString)val);
            if (fsp.hasServerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("serverId", fsp.getServerId()));
            }
            if (fsp.hasTopology()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Topology", (Object)fsp.getTopology()));
            }
            if (fsp.hasHostname()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("Hostname", (Object)fsp.getHostname()));
            }
            if (fsp.getIpsCount() != 0) {
                k = 0;
                for (Common.IPAddress ip : fsp.getIpsList()) {
                    this.dumpIPAddress("ip" + k, ip, out);
                    ++k;
                }
            }
            if (fsp.getSpIdsCount() != 0) {
                k = 0;
                for (String spid : fsp.getSpIdsList()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spid" + k, (Object)Util.expandSpId((String)spid)));
                    ++k;
                }
            }
            if (fsp.getSecondaryPortsCount() != 0) {
                k = 0;
                Iterator iterator = fsp.getSecondaryPortsList().iterator();
                while (iterator.hasNext()) {
                    int port = (Integer)iterator.next();
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("secPort" + k, port));
                    ++k;
                }
            }
            if (fsp.hasNodeConfiguration()) {
                this.dumpMfsNodeConfiguration(fsp.getNodeConfiguration(), out);
            }
            if (fsp.hasMfsInstancesInfo()) {
                this.dumpMfsInstancesInfo(fsp.getMfsInstancesInfo(), out);
            }
            if (fsp.hasBuildVersion()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BuildVersion", (Object)fsp.getBuildVersion()));
            }
            if (fsp.hasPatchVersion()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("PatchVersion", (Object)fsp.getPatchVersion()));
            }
            if (fsp.hasMarkMaintenanceTime()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MarkMaintenanceTime", fsp.getMarkMaintenanceTime()));
            }
            if (fsp.hasMarkMaintenanceTimeOutMin()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MarkMaintenanceTimeOutMin", fsp.getMarkMaintenanceTimeOutMin()));
            }
            if (fsp.hasBadServerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BadServerId", (Object)fsp.getBadServerId()));
            }
            if (fsp.hasBlockMovesOut()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BlockMovesOut", (Object)fsp.getBlockMovesOut()));
            }
            if (fsp.hasBlockMovesIn()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("BlockMovesIn", (Object)fsp.getBlockMovesIn()));
            }
            if (fsp.hasMaxContainers()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("MaxContainers", fsp.getMaxContainers()));
            }
            if (fsp.hasTopologyIncludesInstance()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("TopologyIncludesInstance", (Object)fsp.getTopologyIncludesInstance()));
            }
            if (fsp.hasPliId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("PliId", fsp.getPliId()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("fsid", (Object)"UNKNOWN"));
        }
    }

    private void dumpSPProperties(ByteString val, CommandOutput.OutputHierarchy.OutputNode out) {
        try {
            CLDBProto.StoragePoolProperties spp = CLDBProto.StoragePoolProperties.parseFrom((ByteString)val);
            if (spp.hasSpid()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spid", (Object)Util.expandSpId((String)spp.getSpid())));
            }
            if (spp.hasServerId()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("serverId", spp.getServerId()));
            }
            if (spp.hasDeleteInProg()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteInProg", (Object)spp.getDeleteInProg()));
            }
            if (spp.hasRefillInProgress()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("refillInProgress", (Object)spp.getRefillInProgress()));
            }
        }
        catch (Throwable e) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("spid", (Object)"UNKNOWN"));
        }
    }

    private void dumpKvStoreKey(Fileserver.KvStoreKey ksk, CommandOutput.OutputHierarchy.OutputNode out) {
        if (ksk.hasIntKey()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", ksk.getIntKey()));
        } else if (ksk.hasLongKey()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", ksk.getLongKey()));
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("hexKey", (Object)Long.toHexString(ksk.getLongKey())));
        } else {
            ByteString bs = ksk.getVarKey();
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(bs.toByteArray())));
        }
    }

    private CommandOutput.OutputHierarchy.OutputNode formatKV(Common.FidMsg fid, KVFormatType type, Fileserver.KvMsg kv) {
        CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
        String ks = null;
        switch (type) {
            case TABLE: 
            case INDEX_TABLE: 
            case SCHEMA_INFO: 
            case TABLET: 
            case SEGMENT_MAP: 
            case TABLET_MAP: 
            case DEFER_MAP: {
                ByteString bs = kv.getKey().getVarKey();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)this.printableKey(bs.toByteArray())));
                ks = bs.toStringUtf8();
                break;
            }
            case GENERIC_KV: {
                this.dumpKvStoreKey(kv.getKey(), dout);
                if (kv.getKey().hasVarKey()) {
                    ks = kv.getKey().getVarKey().toStringUtf8();
                }
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", kv.getVersion()));
                break;
            }
            case SPILL_MAP: {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", kv.getKey().getIntKey()));
                break;
            }
            case DIR: {
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)Long.toHexString(kv.getKey().getLongKey())));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", kv.getVersion()));
                break;
            }
            case CLDB_CID_MAP: {
                long longKey = kv.getKey().getLongKey();
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)Long.toHexString(longKey)));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("hKey", Util.getHigherIntFromLong((long)longKey)));
                dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("lKey", Util.getLowerIntFromLong((long)longKey)));
                break;
            }
            default: {
                this.dumpKvStoreKey(kv.getKey(), dout);
            }
        }
        CommandOutput.OutputHierarchy.OutputNode vout = new CommandOutput.OutputHierarchy.OutputNode();
        switch (type) {
            case TABLE: 
            case INDEX_TABLE: {
                if (ks.equals(Dbserver.DBInternalDefaults.getDefaultInstance().getTableKeyForStats())) {
                    try {
                        Dbserver.TableBasicStats stats = Dbserver.TableBasicStats.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Rows", stats.getNumRows()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Size", stats.getSize()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Tablets", stats.getNumTablets()));
                    }
                    catch (Throwable e) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Rows", (Object)"UNKNOWN"));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Size", (Object)"UNKNOWN"));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("Total Tablets", (Object)"UNKNOWN"));
                    }
                    break;
                }
                try {
                    Common.FidMsg f = Common.FidMsg.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(f)));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
                }
                break;
            }
            case SCHEMA_INFO: {
                try {
                    Dbserver.DBInternalDefaults dbi = Dbserver.DBInternalDefaults.getDefaultInstance();
                    if (ks == null) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                        break;
                    }
                    if (ks.startsWith(dbi.getColFamilyIdPrefix())) {
                        Dbserver.SchemaFamily sf = Dbserver.SchemaFamily.parseFrom((ByteString)kv.getValue());
                        if (sf.hasName()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cfname", (Object)sf.getName()));
                            break;
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cfname", (Object)"NONE"));
                        break;
                    }
                    if (ks.equals(dbi.getAttr())) {
                        Dbserver.TableAttr attr = Dbserver.TableAttr.parseFrom((ByteString)kv.getValue());
                        if (attr.hasAutoSplit()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:autoSplit", (Object)attr.getAutoSplit()));
                        }
                        if (attr.hasBulkLoad()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:bulkLoad", (Object)attr.getBulkLoad()));
                        }
                        if (attr.hasDeleteTTL()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:deleteTTL", attr.getDeleteTTL()));
                        }
                        if (attr.hasSyncReplTimeoutMillis()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:syncReplTimeoutMillis", attr.getSyncReplTimeoutMillis()));
                        }
                        if (attr.hasRegionSizeMB()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:regionSizeMB", attr.getRegionSizeMB()));
                        }
                        if (attr.hasMaxValueSzInMemIndex()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:maxValueSzInMemIndex", attr.getMaxValueSzInMemIndex()));
                        }
                        if (attr.hasReclaimThreshPcntForPack()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:reclaimThreshPcntForPack", attr.getReclaimThreshPcntForPack()));
                        }
                        if (attr.hasIsMarlinTable()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("attr:isMarlinTable", (Object)attr.getIsMarlinTable()));
                        }
                        if (!attr.hasMarlinAttr()) break;
                        Marlincommon.MarlinTableAttr mtAttr = attr.getMarlinAttr();
                        if (mtAttr.hasAutoCreateTopics()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("marlinAttr:autoCreateTopics", (Object)mtAttr.getAutoCreateTopics()));
                        }
                        if (!mtAttr.hasDefaultNumFeedsPerTopic()) break;
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("marlinAttr:defaultNumFeedsPerTopic", mtAttr.getDefaultNumFeedsPerTopic()));
                        break;
                    }
                    if (ks.startsWith(dbi.getReplIdxPrefix())) {
                        Dbserver.TableReplicaDesc rd = Dbserver.TableReplicaDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)rd.getClusterName()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("table", (Object)rd.getTablePath()));
                        byte[] uuid = rd.getTableUuid().toByteArray();
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString((byte[])uuid)));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("paused", (Object)rd.getIsPaused()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("synchronous", (Object)rd.getSynchronous()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", rd.getIdx()));
                        if (rd.getQualifiersCount() <= 0) break;
                        String famList = "";
                        int idx = 0;
                        for (Dbserver.Qualifier qual : rd.getQualifiersList()) {
                            if (qual.getQualifiersCount() > 0) {
                                for (ByteString bstr : qual.getQualifiersList()) {
                                    famList = idx == 0 ? qual.getFamily() + COLUMN_SEP + bstr.toStringUtf8() : famList + MULTI_ARG_SEP + qual.getFamily() + COLUMN_SEP + bstr.toStringUtf8();
                                    ++idx;
                                }
                                continue;
                            }
                            if (idx == 0) {
                                famList = String.valueOf(qual.getFamily());
                                ++idx;
                                continue;
                            }
                            famList = famList + MULTI_ARG_SEP + qual.getFamily();
                            ++idx;
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("columnfamilies", (Object)famList));
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)this.bytesToString(kv.getValue())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case TABLET: {
                try {
                    Dbserver.DBInternalDefaults dbi = Dbserver.DBInternalDefaults.getDefaultInstance();
                    if (ks == null) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForPMap())) {
                        CommandOutput.OutputHierarchy.OutputNode buckets;
                        Dbserver.PartitionMapEntry p = Dbserver.PartitionMapEntry.parseFrom((ByteString)kv.getValue());
                        if (p.hasSegmapFid()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("segfid", (Object)this.printableFid(p.getSegmapFid())));
                        } else {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("segfid", (Object)"NONE"));
                        }
                        if (p.getBucketFidsList().size() > 0) {
                            buckets = new CommandOutput.OutputHierarchy.OutputNode("bucketfids");
                            vout.addChild(buckets);
                            for (Common.FidMsg f : p.getBucketFidsList()) {
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(f)));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isFrozen", (Object)p.getIsFrozen()));
                        if (p.getCidVNEntriesList().size() > 0) {
                            CommandOutput.OutputHierarchy.OutputNode cidVNs = new CommandOutput.OutputHierarchy.OutputNode("CidVNs");
                            vout.addChild(cidVNs);
                            for (Dbserver.CidVNEntry ce : p.getCidVNEntriesList()) {
                                cidVNs.addChild(new CommandOutput.OutputHierarchy.OutputNode("cid-minVN", (Object)(ce.getCid() + "-" + ce.getMinVN())));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inSplit", (Object)p.getInSplit()));
                        if (p.hasInImportBucket()) {
                            dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("inImportBucket", (Object)p.getInImportBucket()));
                        }
                        if (p.getBucketDescsList().size() > 0) {
                            buckets = new CommandOutput.OutputHierarchy.OutputNode("bucketdescs");
                            vout.addChild(buckets);
                            for (Dbserver.PartitionMapEntry.BucketDesc bd : p.getBucketDescsList()) {
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(bd.getFid())));
                                buckets.addChild(new CommandOutput.OutputHierarchy.OutputNode("needsRepl", (Object)bd.getNeedsRepl()));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("useBucketDesc", (Object)p.getUseBucketDesc()));
                        if (p.hasLastFlushedBucketFid()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastFlushedBucketFid", (Object)this.printableFid(p.getLastFlushedBucketFid())));
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numLogicalBlocks", p.getUsage().getNumLogicalBlocks()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numPhysicalBlocks", p.getUsage().getNumPhysicalBlocks()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", p.getUsage().getNumRows()));
                        if (p.getUsage().hasNumRowsWithDelete()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRowsWithDelete", p.getUsage().getNumRowsWithDelete()));
                        }
                        if (p.getUsage().hasNumRemoteBlocks()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRemoteBlocks", p.getUsage().getNumRemoteBlocks()));
                        }
                        if (p.getUsage().hasNumSpills()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSpills", p.getUsage().getNumSpills()));
                        }
                        if (p.getUsage().hasNumSegments()) {
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numSegments", p.getUsage().getNumSegments()));
                        }
                        if (p.getUsage().hasTimeRange()) {
                            Dbserver.TimeRange ts = p.getUsage().getTimeRange();
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("minTimeStamp", ts.getMinTS()));
                            vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxTimeStamp", ts.getMaxTS()));
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("marlinMaxSeq", p.getMarlinMaxSeq()));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForSplit())) {
                        Dbserver.SplitDesc sd = Dbserver.SplitDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(sd.getDstFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("moveRightHalf", (Object)sd.getMoveRightHalf()));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("endGame", (Object)sd.getEndGame()));
                        break;
                    }
                    if (ks.startsWith(dbi.getTabletKeyForStartKey()) || ks.startsWith(dbi.getTabletKeyForEndKey())) break;
                    if (ks.startsWith(dbi.getTabletKeyForMerge())) {
                        Dbserver.MergeDesc md = Dbserver.MergeDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("peerFid", (Object)this.printableFid(md.getPeerFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("isDest", (Object)md.getIsDest()));
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)this.bytesToString(kv.getValue())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case TABLET_MAP: {
                try {
                    Dbserver.TabletMapEntry t = Dbserver.TabletMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(t.getTabletFid())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
                }
                break;
            }
            case SEGMENT_MAP: {
                try {
                    Dbserver.SegmentMapEntry s = Dbserver.SegmentMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(s.getFid())));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"UNKNOWN"));
                }
                break;
            }
            case SPILL_MAP: {
                try {
                    Dbserver.SpillMapEntry s = Dbserver.SpillMapEntry.parseFrom((ByteString)kv.getValue());
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(s.getFid())));
                    if (s.hasSmeSize()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("smeSize", s.getSmeSize()));
                    }
                    if (s.hasMinVN()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("minVN", s.getMinVN()));
                    }
                    if (s.hasMaxMarlinSeq()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxMarlinSeq", s.getMaxMarlinSeq()));
                    }
                    if (s.hasBackingBucketFid()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("backingBucketFid", (Object)this.printableFid(s.getBackingBucketFid())));
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyIdxOffset", s.getKeyIdxOffset()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyIdxLength", s.getKeyIdxLength()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("ldbIdxLength", s.getLdbIdxLength()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("bloomBitsPerKey", s.getBloomBitsPerKey()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numLogicalBlocks", s.getUsage().getNumLogicalBlocks()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numPhysicalBlocks", s.getUsage().getNumPhysicalBlocks()));
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", s.getUsage().getNumRows()));
                    if (s.getUsage().hasNumRowsWithDelete()) {
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRowsWithDelete", s.getUsage().getNumRowsWithDelete()));
                    }
                    CommandOutput.OutputHierarchy.OutputNode families = new CommandOutput.OutputHierarchy.OutputNode("families");
                    vout.addChild(families);
                    for (Dbserver.SpillMapEntry.FamilyEntry fe : s.getFamiliesList()) {
                        families.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", fe.getId()));
                        if (fe.hasOffset()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("offset", fe.getOffset()));
                        }
                        if (fe.hasLength()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("length", fe.getLength()));
                        }
                        if (!fe.hasTimeRange()) continue;
                        Dbserver.TimeRange tr = fe.getTimeRange();
                        if (tr.hasMinTS()) {
                            families.addChild(new CommandOutput.OutputHierarchy.OutputNode("minTimeStamp", tr.getMinTS()));
                        }
                        if (!tr.hasMaxTS()) continue;
                        families.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxTimeStamp", tr.getMaxTS()));
                    }
                    break;
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("keyfid", (Object)"UNKNOWN"));
                    break;
                }
            }
            case DEFER_MAP: {
                try {
                    if (ks.startsWith("b")) {
                        Dbserver.ReplBucketDesc b = Dbserver.ReplBucketDesc.parseFrom((ByteString)kv.getValue());
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketFid", (Object)this.printableFid(b.getBucketFid())));
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("tableFid", (Object)this.printableFid(b.getTableFid())));
                        if (b.getSendAfterList().size() != 0) {
                            CommandOutput.OutputHierarchy.OutputNode sendAfter = new CommandOutput.OutputHierarchy.OutputNode("sendAfter");
                            vout.addChild(sendAfter);
                            for (Common.FidMsg f : b.getSendAfterList()) {
                                sendAfter.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(f)));
                            }
                        }
                        if (b.getSendBeforeList().size() != 0) {
                            CommandOutput.OutputHierarchy.OutputNode sendBefore = new CommandOutput.OutputHierarchy.OutputNode("sendBefore");
                            vout.addChild(sendBefore);
                            for (Common.FidMsg f : b.getSendBeforeList()) {
                                sendBefore.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)this.printableFid(f)));
                            }
                        }
                        vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("flushed", (Object)b.getFlushed()));
                        CommandOutput.OutputHierarchy.OutputNode replicas = new CommandOutput.OutputHierarchy.OutputNode("replicas");
                        vout.addChild(replicas);
                        for (Dbserver.ReplBucketDesc.ReplicaInfo rs : b.getReplList()) {
                            replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicaIdx", rs.getReplicaIdx()));
                            if (rs.hasDoneTillOffset()) {
                                replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("doneTillOffset", rs.getDoneTillOffset()));
                            }
                            if (!rs.hasDone()) continue;
                            replicas.addChild(new CommandOutput.OutputHierarchy.OutputNode("done", (Object)rs.getDone()));
                        }
                        break;
                    }
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                catch (Throwable e) {
                    vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
                }
                break;
            }
            case DIR: {
                ByteString bs = kv.getValue();
                for (int offset = 0; offset < bs.size(); offset += 16) {
                    NameEnt ent = this.getNameEnt(bs, offset);
                    CommandOutput.OutputHierarchy.OutputNode entOut = new CommandOutput.OutputHierarchy.OutputNode("dirEntry");
                    long cid = ent.cid;
                    if (cid < 0L) {
                        cid = fid.getCid();
                    }
                    String fidStr = Long.toString(cid) + "." + Long.toString(ent.cinum) + "." + Long.toString(ent.uniq);
                    entOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)fidStr));
                    entOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", ent.ftype));
                    entOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("name", (Object)ent.name));
                    entOut.addChild(new CommandOutput.OutputHierarchy.OutputNode("nameEnt", (Object)BinaryString.toStringHex((byte[])bs.toByteArray())));
                    vout.addChild(entOut);
                    offset += ent.nmlen;
                }
                break;
            }
            case CLDB_CONTAINER_INFO: {
                this.dumpContainerInfo(kv.getValue(), vout);
                break;
            }
            case CLDB_CONTAINER_SIZE_INFO: {
                this.dumpContainerSizeInfo(kv.getValue(), vout);
                break;
            }
            case CLDB_SP_PROP: {
                this.dumpSPProperties(kv.getValue(), vout);
                break;
            }
            case CLDB_FS_PROP: {
                this.dumpFSProperties(kv.getValue(), vout);
                break;
            }
            case CLDB_SNAPSHOT_INFO: {
                this.dumpSnapshotInfo(kv.getValue(), vout);
                break;
            }
            case CLDB_VOLUME_PROP: {
                this.dumpVolumeProperties(kv.getValue(), vout);
                break;
            }
            case CLDB_VOLUME_QUOTA: {
                this.dumpVolumeQuota(kv.getValue(), vout);
                break;
            }
            case CLDB_VOLUME_ACES: {
                this.dumpVolumeAces(kv.getValue(), vout);
                break;
            }
            case CLDB_VOLUME_NAME: {
                this.dumpVolumeTableId(kv.getValue(), vout);
                break;
            }
            case MFS_SNAP_MAP: {
                this.dumpUint32(kv.getValue(), vout);
                break;
            }
            default: {
                vout.addChild(new CommandOutput.OutputHierarchy.OutputNode("raw", (Object)"UNKNOWN"));
            }
        }
        dout.addChild(new CommandOutput.OutputHierarchy.OutputNode("value", (Object)vout));
        return dout;
    }

    private void dumpDir(Common.FidMsg fid, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MapRFileStatus[] dirents;
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            dirents = fs.scanDir(this.clusterName, "/.mapr::fid::" + this.printableFid(fid));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanDir failed"));
            return;
        }
        if (dirents == null) {
            return;
        }
        for (int i = 0; i < dirents.length; ++i) {
            out.addNode(this.formatDirEntry(dirents[i]));
        }
    }

    private void dumpRegKeyMap(Common.FidMsg fid, Integer idxoffset, Integer idxsize, boolean dumpFullKeys, int fmtVersion, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        long dbinding = this.getBindingForContainer(fid.getCid());
        Dbserver.KeyMapCookie cookie = null;
        LOG.info((Object)("Getting regular key-map with idxsize " + idxsize + " dumpFullKeys " + dumpFullKeys + " keyIdxVersion " + fmtVersion));
        if (dbinding == -1L) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "container lookup failed"));
            return;
        }
        while (true) {
            Dbserver.TestScanResponse resp;
            Dbserver.TestScanRequest req = cookie == null ? Dbserver.TestScanRequest.newBuilder().setCmd(Dbserver.TestScanRequest.Cmd.KeyMapTable).setFid(fid).setOffset((long)idxoffset.intValue()).setSize(idxsize.intValue()).setCreds(this.getUserCredentials()).setDumpFullKeys(dumpFullKeys).setKeyIdxFmtVersion(fmtVersion).build() : Dbserver.TestScanRequest.newBuilder().setCmd(Dbserver.TestScanRequest.Cmd.KeyMapTable).setFid(fid).setOffset((long)idxoffset.intValue()).setSize(idxsize.intValue()).setCreds(this.getUserCredentials()).setKmapCookie(cookie).setDumpFullKeys(dumpFullKeys).setKeyIdxFmtVersion(fmtVersion).build();
            try {
                byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.DBServerProgramId.getNumber(), (int)Dbserver.DBProg.TestScanProc.getNumber(), (MessageLite)req);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "testscan rpc failed"));
                    return;
                }
                resp = Dbserver.TestScanResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "TestScan failed, Error : " + Errno.toString((int)resp.getStatus())));
                    return;
                }
                for (Dbserver.KeyMapEntry kment : resp.getKmapentriesList()) {
                    out.addNode(this.formatKeyMapEntry(kment));
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception processing testscan command");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "mfs rpc failed"));
                return;
            }
            if (!resp.getHasMoreKeys()) break;
            LOG.info((Object)("Setting cookie as " + resp.getKmapCookie().getOffset()));
            cookie = resp.getKmapCookie();
        }
        LOG.info((Object)"Done with scan");
    }

    private void dumpKeyValues(Common.FidMsg fid, KVFormatType type, Fileserver.KvStoreKey start, Fileserver.KvStoreKey end, int maxkeys, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        byte[] byteArr;
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            byte[] kstart = null;
            if (start != null) {
                kstart = start.toByteArray();
            }
            byte[] kend = null;
            if (end != null) {
                kend = end.toByteArray();
            }
            byteArr = fs.scanKV(this.clusterName, "/.mapr::fid::" + this.printableFid(fid), kstart, kend, maxkeys);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "scanKV failed"));
            return;
        }
        if (byteArr == null) {
            return;
        }
        try {
            Fileserver.KvList kvlist = Fileserver.KvList.parseFrom((byte[])byteArr);
            for (Fileserver.KvMsg kvp : kvlist.getEntriesList()) {
                out.addNode(this.formatKV(fid, type, kvp));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "failed to parse key-value list"));
            return;
        }
    }

    private String printableFid(Common.FidMsg f) {
        String cidStr = f.getCid() == -1 ? "<parentCID>." : f.getCid() + ".";
        return cidStr + f.getCinum() + "." + f.getUniq();
    }

    private String printableSubType(Common.FileType type, Common.FileSubType subtype) {
        String stype = subtype.toString();
        if (type == Common.FileType.FTKvstore) {
            if (subtype == Common.FileSubType.FSTKvTable) {
                stype = "FSTKvTable";
            } else if (subtype == Common.FileSubType.FSTKvTabletMap) {
                stype = "FSTKvTabletMap";
            } else if (subtype == Common.FileSubType.FSTKvSchema) {
                stype = "FSTKvSchema";
            } else if (subtype == Common.FileSubType.FSTKvTablet) {
                stype = "FSTKvTablet";
            } else if (subtype == Common.FileSubType.FSTKvSegMap) {
                stype = "FSTKvSegMap";
            } else if (subtype == Common.FileSubType.FSTKvSpillMap) {
                stype = "FSTKvSpillMap";
            } else if (subtype == Common.FileSubType.FSTKvKeyMap) {
                stype = "FSTKvKeyMap";
            } else if (subtype == Common.FileSubType.FSTKvIndexTable) {
                stype = "FSTKvIndexTable";
            }
        } else if (type == Common.FileType.FTRegular) {
            if (subtype == Common.FileSubType.FSTRegBucket) {
                stype = "FSTRegBucket";
            } else if (subtype == Common.FileSubType.FSTRegSortedBucket) {
                stype = "FSTRegSortedBucket";
            } else if (subtype == Common.FileSubType.FSTRegCF) {
                stype = "FSTRegCF";
            } else if (subtype == Common.FileSubType.FSTRegSpill) {
                stype = "FSTRegSpill";
            }
        }
        return stype;
    }

    private String printableKey(byte[] bytes) {
        return BinaryString.toStringBinary((byte[])bytes);
    }

    private String bytesToString(ByteString bs) {
        return BinaryString.toStringBinary((byte[])bs.toByteArray());
    }

    private long getBindingForGateway(int gIp, int gPort) throws CLIProcessingException {
        if (gPort == 0) {
            gPort = 7660;
        }
        return Rpc.createBindingFor((int)gIp, (int)gPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    private String getCompressionType(Common.FileCompressionType ct) {
        if (ct == Common.FileCompressionType.FCT_OFF) {
            return "off";
        }
        if (ct == Common.FileCompressionType.FCT_LZ4) {
            return "lz4";
        }
        if (ct == Common.FileCompressionType.FCT_LZF) {
            return "lzf";
        }
        if (ct == Common.FileCompressionType.FCT_ZLIB) {
            return "zlib";
        }
        return "unknown";
    }

    private Common.IPAddress buildIPFromString(String ipstr) {
        if (ipstr.equalsIgnoreCase("localhost") || ipstr.equalsIgnoreCase("127.0.0.1")) {
            ipstr = "127.0.0.1";
        } else {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(ipstr));
            if (ips.isEmpty()) {
                return null;
            }
            ipstr = ips.get(0);
        }
        int host = Util.ipToInt((String)ipstr);
        Common.IPAddress server = Common.IPAddress.newBuilder().setHost(host).build();
        return server;
    }

    public class NameEnt {
        Long cid;
        Long cinum;
        Long uniq;
        int ftype;
        String name;
        int nmlen;
    }

    public static enum KVFormatType {
        TABLE,
        INDEX_TABLE,
        TABLET_MAP,
        SCHEMA_INFO,
        TABLET,
        SEGMENT_MAP,
        SPILL_MAP,
        DEFER_MAP,
        GENERIC_KV,
        DIR,
        CLDB_CONTAINER_INFO,
        CLDB_CONTAINER_SIZE_INFO,
        CLDB_CID_MAP,
        CLDB_FS_PROP,
        CLDB_SP_PROP,
        CLDB_VOLUME_NAME,
        CLDB_VOLUME_PROP,
        CLDB_VOLUME_ACES,
        CLDB_VOLUME_QUOTA,
        CLDB_SNAPSHOT_INFO,
        MFS_SNAP_MAP,
        INVALID;

    }
}

