/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.DbCommands;
import com.mapr.cli.DbUpstreamCommands;
import com.mapr.cli.ElasticsearchCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.CopyTableCallable;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.common.JobExecutor;
import com.mapr.cli.marlin.RecentStreamsListManagers;
import com.mapr.cli.marlin.StreamsCommands;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.gateway.external.GatewaySink;
import com.mapr.fs.hbase.TableUtil;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Error;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.fs.tables.MapRAdmin;
import com.mapr.fs.tables.TableProperties;
import com.mapr.streams.impl.admin.MarlinAdminImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.ojai.FieldPath;

public class DbReplicaCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbReplicaCommands.class);
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    private static final String PATH_PARAM_NAME = "path";
    private static final String REPLICA_PARAM_NAME = "replica";
    private static final String CHANGELOG_PARAM_NAME = "changelog";
    private static final String NEWREPLICA_PARAM_NAME = "newreplica";
    private static final String PAUSED_PARAM_NAME = "paused";
    private static final String THROTTLE_PARAM_NAME = "throttle";
    private static final String ENCRYPTION_PARAM_NAME = "networkencryption";
    private static final String SYNCHRONOUS_PARAM_NAME = "synchronous";
    private static final String COMPRESSION_PARAM_NAME = "networkcompression";
    private static final String MULTI_ARG_SEP = ",";
    private static final String MULTI_FIELD_SEP = ";";
    private static final String COLUMN_SEP = ":";
    private static final String JSON_PATH_SEP = ".";
    private static final String REFRESH_PARAM_NAME = "refreshnow";
    private static final String WAIT_FOR_COMPLETION_PARAM_NAME = "waitforcompletion";
    private static final String MULTI_MASTER_PARAM_NAME = "multimaster";
    private static final String USE_EXISTING_REPLICA_PARAM_NAME = "useexistingreplica";
    private static final String TICKET_PATH_PARAM_NAME = "ticketpath";
    private static final String MAPRDB_REPLICA_CLASS_NAME = "MapRDB";
    private static final String MAPRSTREAM_REPLICA_CLASS_NAME = "MapRStream";
    private static final String DIRECT_COPY_PARAM_NAME = "directcopy";
    private static final String DIRECT_COPY_FEATURE_NAME = "mfs.feature.db.streams.v6.support";
    private static final String TOPIC_PARAM_NAME = "topic";
    private static final String USE_EXISTING_TOPIC_PARAM_NAME = "useexistingtopic";
    private static final String PROPAGATE_EXISTING_DATA_PARAM_NAME = "propagateexistingdata";
    private static final String MULTIVERSION_PARAM_NAME = "multiversion";
    private static final String CHANGELOGClASSNAME = "ChangeLog";
    private static final String DEBUG_PARAM_NAME = "debug";
    private static final CLICommand listCommand = new CLICommand("list", "usage: table replica list -path <tablepath>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"refreshnow", (Object)new BooleanInputParameter("refreshnow", "refreshnow", false, Boolean.valueOf(false))).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("table replica list -path <tablepath>");
    private static final CLICommand addCommand = new CLICommand("add", "usage: table replica add -path <tablePath> -replica <replicaPath> -columns <cf1[:col1],cf2,..> -paused <true|false> -throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|on|lzf|lz4|zlib> ", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"paused", (Object)new BooleanInputParameter("paused", "is replication paused", false, Boolean.valueOf(false))).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication ops", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "is synchronous replication", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|on|lzf|lz4|zlib", false, "on")).build(), null).setShortUsage("table replica add -path <tablePath> -replica <replicaPath>");
    private static final CLICommand autoSetupCommand = new CLICommand("autosetup", "usage: table replica autosetup -path <tablePath> -replica <replicaPath> -columns <cf1[:col1],cf2,..>-multimaster <true/false>-waitforcompletion <true/false>-throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|on|lzf|lz4|zlib> -ticketpath <path> -directcopy <true|false> -useexistingreplica <true|false>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "is synchronous replication", false, Boolean.valueOf(false))).put((Object)"multimaster", (Object)new BooleanInputParameter("multimaster", "is multi master replication", false, Boolean.valueOf(false))).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication ops", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|on|lzf|lz4|zlib", false, "on")).put((Object)"waitforcompletion", (Object)new BooleanInputParameter("waitforcompletion", "wait for completion", false, Boolean.valueOf(true)).setInvisible(true)).put((Object)"ticketpath", (Object)new TextInputParameter("ticketpath", "ticket path", false, null).setInvisible(true)).put((Object)"directcopy", (Object)new BooleanInputParameter("directcopy", "enable directcopy", false, Boolean.valueOf(true))).put((Object)"useexistingreplica", (Object)new BooleanInputParameter("useexistingreplica", "use existing replica table if present", false, Boolean.valueOf(false))).build(), null).setShortUsage("table replica autosetup -path <tablePath> -replica <replicaPath>");
    private static final CLICommand editCommand = new CLICommand("edit", "usage: table replica edit -path <tablePath> -replica <replicaPath> -newreplica <newReplicaPath> -columns <cf1[:col1],cf2,..> -paused <true|false> -allowallcfs <true> -throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|on|lzf|lz4|zlib> ", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).put((Object)"newreplica", (Object)new TextInputParameter("newreplica", "renamed table path", false, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication ops", false, null)).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, null)).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "is synchronous replication", false, null)).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|on|lzf|lz4|zlib", false, null)).build(), null).setShortUsage("table replica edit -path <tablePath> -replica <replicaPath> -newreplica <newReplicaPath> -columns <cf1[:col1],cf2,..> -paused <true|false> -allowallcfs <true> -throttle <true|false>  -synchronous <true|false> -networkencryption <true|false -networkcompression <off|on|lzf|lz4|zlib>");
    private static final CLICommand pauseCommand = new CLICommand("pause", "usage: table replica pause -path <tablePath> -replica <replicaPath>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).build(), null).setShortUsage("table replica pause -path <tablePath> -replica <replicaPath>");
    private static final CLICommand resumeCommand = new CLICommand("resume", "usage: table replica resume -path <tablePath> -replica <replicaPath>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).build(), null).setShortUsage("table replica resume -path <tablePath> -replica <replicaPath>");
    private static final CLICommand removeCommand = new CLICommand("remove", "usage: table replica remove -path <tablePath> -replica <replicaPath>", DbReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"replica", (Object)new TextInputParameter("replica", "replica table path", true, null)).build(), null).setShortUsage("table replica remove -path <tablePath> -replica <replicaPath>");
    public static final CLICommand replicaCommands = new CLICommand("replica", "replica [add|edit|list|remove|pause|resume|elasticsearch]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCommand, editCommand, listCommand, removeCommand, pauseCommand, resumeCommand, autoSetupCommand, ElasticsearchCommands.esReplicaCommands}).setShortUsage("table replica [add|edit|list|remove|pause|resume|elasticsearch]");

    public DbReplicaCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cname = this.cliCommand.getCommandName();
        if (cname.equalsIgnoreCase(addCommand.getCommandName())) {
            this.addReplica(out);
        } else if (cname.equalsIgnoreCase(editCommand.getCommandName())) {
            this.editReplica(out);
        } else if (cname.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listReplica(out);
        } else if (cname.equalsIgnoreCase(removeCommand.getCommandName())) {
            this.removeReplica(out);
        } else if (cname.equalsIgnoreCase(pauseCommand.getCommandName())) {
            this.pauseOrResumeReplica(out, true);
        } else if (cname.equalsIgnoreCase(resumeCommand.getCommandName())) {
            this.pauseOrResumeReplica(out, false);
        } else if (cname.equalsIgnoreCase(autoSetupCommand.getCommandName())) {
            this.autoSetup(out);
        }
        return output;
    }

    private String bytesToString(ByteString bstr) {
        return BinaryString.toStringBinary((byte[])bstr.toByteArray());
    }

    private ByteString stringToByteString(String raws) {
        byte[] bArr = BinaryString.toBytesBinary((String)raws);
        return ByteString.copyFrom((byte[])bArr);
    }

    public static Common.FileCompressionType getCompressionType(String cs) {
        if (cs.equalsIgnoreCase("off")) {
            return Common.FileCompressionType.FCT_OFF;
        }
        if (cs.equalsIgnoreCase("lz4") || cs.equalsIgnoreCase("on")) {
            return Common.FileCompressionType.FCT_LZ4;
        }
        if (cs.equalsIgnoreCase("lzf")) {
            return Common.FileCompressionType.FCT_LZF;
        }
        if (cs.equalsIgnoreCase("zlib")) {
            return Common.FileCompressionType.FCT_ZLIB;
        }
        return null;
    }

    public static String getCompressionName(Common.FileCompressionType ct) {
        if (ct == Common.FileCompressionType.FCT_OFF) {
            return "off";
        }
        if (ct == Common.FileCompressionType.FCT_LZ4) {
            return "lz4";
        }
        if (ct == Common.FileCompressionType.FCT_ZLIB) {
            return "zlib";
        }
        if (ct == Common.FileCompressionType.FCT_LZF || ct == Common.FileCompressionType.FCT_OLDLZF) {
            return "lzf";
        }
        return "unknown";
    }

    public String entityName() {
        return "table";
    }

    private void createJSONTableForCopy(String replicaPath, String srcPath, List<String> cfList, boolean isMarlinStream, boolean isBulkload) throws Exception {
        if (!isMarlinStream) {
            AdminImpl.createTableForCopy((String)replicaPath, (String)srcPath, cfList, (boolean)isBulkload);
        } else {
            MarlinAdminImpl.createStreamForCopy((String)replicaPath, (String)srcPath);
        }
    }

    private String getStreamDefaultJsonPathsForRepl(String streamDefaultCF) {
        if (streamDefaultCF == null || streamDefaultCF.isEmpty()) {
            return null;
        }
        StringBuilder defJP = new StringBuilder();
        String[] defCFs = streamDefaultCF.split(MULTI_ARG_SEP, -1);
        int len = defCFs.length;
        for (int i = 0; i < len; ++i) {
            if (defCFs[i].equals("default")) {
                defCFs[i] = new String("");
            }
            defJP.append(defCFs[i]);
            if (i >= len - 1) continue;
            defJP.append(MULTI_ARG_SEP);
        }
        return defJP.toString();
    }

    public static boolean validateTopicName(String tname) {
        if (tname.length() <= 0) {
            return false;
        }
        int idx = tname.lastIndexOf(58);
        return idx < 0;
    }

    public static boolean parseStreamTopicName(String fullname, String[] stnames, CommandOutput.OutputHierarchy out) {
        int idx = fullname.lastIndexOf(58);
        if (idx > 0) {
            stnames[0] = fullname.substring(0, idx);
            stnames[1] = fullname.substring(idx + 1);
            if (!DbReplicaCommands.validateTopicName(stnames[1])) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, fullname + " has invalid topic name " + stnames[1]));
                return false;
            }
            if (stnames[0].length() <= 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, fullname + " has invalid changelog table path" + stnames[0]));
                return false;
            }
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, fullname + " does not have topic name"));
            return false;
        }
        return true;
    }

    public static void verifyStreamPath(String streamPath, boolean streamMissingIsOk) throws IOException, CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        DbReplicaCommands.verifyStreamPath(mfs, streamPath, streamMissingIsOk);
    }

    public static void verifyStreamPath(MapRFileSystem mfs, String streamPath, boolean streamMissingIsOk) throws IOException, CLIProcessingException {
        boolean streamexists = mfs.exists(new Path(streamPath));
        if (!streamexists) {
            if (!streamMissingIsOk) {
                throw new IOException(streamPath + " not found");
            }
        } else if (!DbReplicaCommands.isChangelogDestination(streamPath)) {
            throw new IOException(streamPath + " is not a changelog table");
        }
    }

    protected void changeLogSetup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String replicaFullPathParam = DbCommands.getTransformedPath(this.getParamTextValue(CHANGELOG_PARAM_NAME, 0), this.getUserLoginId());
        this.autoSetupInternal(out, true, true, replicaFullPathParam);
    }

    protected void autoSetupInternal(CommandOutput.OutputHierarchy out, boolean isDirectCopyParam, final boolean isChangeLog, String replicaFullPathParam) throws CLIProcessingException, UnsupportedOperationException {
        String topicName;
        boolean ret;
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String colList = this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
        final boolean isMultiMaster = this.isParamPresent(MULTI_MASTER_PARAM_NAME) ? this.getParamBooleanValue(MULTI_MASTER_PARAM_NAME, 0) : false;
        final boolean useExistingReplica = this.isParamPresent(USE_EXISTING_REPLICA_PARAM_NAME) ? this.getParamBooleanValue(USE_EXISTING_REPLICA_PARAM_NAME, 0) : false;
        final boolean waitForCompletion = this.isParamPresent(WAIT_FOR_COMPLETION_PARAM_NAME) ? this.getParamBooleanValue(WAIT_FOR_COMPLETION_PARAM_NAME, 0) : false;
        final boolean isSync = this.isParamPresent(SYNCHRONOUS_PARAM_NAME) ? this.getParamBooleanValue(SYNCHRONOUS_PARAM_NAME, 0) : false;
        final String ticketPath = this.isParamPresent(TICKET_PATH_PARAM_NAME) ? this.getParamTextValue(TICKET_PATH_PARAM_NAME, 0) : null;
        final DbReplicaCommands dbPerm = this;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final boolean isDirectCopy = isChangeLog ? true : isDirectCopyParam;
        boolean useExistingTopicParam = this.isParamPresent(USE_EXISTING_TOPIC_PARAM_NAME) ? this.getParamBooleanValue(USE_EXISTING_TOPIC_PARAM_NAME, 0) : false;
        boolean propagateexistingdataParam = this.isParamPresent(PROPAGATE_EXISTING_DATA_PARAM_NAME) ? this.getParamBooleanValue(PROPAGATE_EXISTING_DATA_PARAM_NAME, 0) : true;
        boolean multiversionParam = this.isParamPresent(MULTIVERSION_PARAM_NAME) ? this.getParamBooleanValue(MULTIVERSION_PARAM_NAME, 0) : true;
        final boolean changelogPauseParam = this.isParamPresent(PAUSED_PARAM_NAME) ? this.getParamBooleanValue(PAUSED_PARAM_NAME, 0) : false;
        String[] stnames = null;
        if (isChangeLog && !(ret = DbReplicaCommands.parseStreamTopicName(replicaFullPathParam, stnames = new String[2], out))) {
            return;
        }
        final String replicaFullPath = isChangeLog ? stnames[0] : replicaFullPathParam;
        final String replicaTopic = topicName = isChangeLog ? stnames[1] : null;
        final boolean useExistingTopic = isChangeLog ? useExistingTopicParam : false;
        final boolean propagateexistingdata = isChangeLog ? propagateexistingdataParam : true;
        final boolean multiversion = isChangeLog ? multiversionParam : true;
        try {
            new FileclientRun(this.getUserLoginId()){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    String clist;
                    Common.FileCompressionType ctype;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (isChangeLog) {
                        DbReplicaCommands.verifyStreamPath(mfs, replicaFullPath, false);
                    }
                    boolean isReplicaTypeTable = isDirectCopy || !DbReplicaCommands.isExternalDestination(mfs, replicaFullPath);
                    int maxVersions = isReplicaTypeTable ? Integer.MAX_VALUE : 1;
                    String rCName = null;
                    Path path = new Path(tablePath);
                    if (!mfs.isTable(path)) {
                        throw new CLIProcessingException("Table not found. Path: " + tablePath);
                    }
                    TableProperties props = mfs.getTableProperties(path);
                    boolean isJson = props.getAttr().getJson();
                    boolean isMarlinStream = props.getAttr().getIsMarlinTable();
                    if (isChangeLog) {
                        replBuilder.setIsPaused(changelogPauseParam);
                        replBuilder.setPropagateExistingData(propagateexistingdata);
                    } else {
                        replBuilder.setIsPaused(!isDirectCopy);
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.THROTTLE_PARAM_NAME)) {
                        replBuilder.setThrottle(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.THROTTLE_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.ENCRYPTION_PARAM_NAME)) {
                        replBuilder.setEncryptonwire(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.ENCRYPTION_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COMPRESSION_PARAM_NAME)) {
                        ctype = DbReplicaCommands.getCompressionType(DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COMPRESSION_PARAM_NAME, 0));
                        if (ctype == null) {
                            throw new CLIProcessingException("Invalid input values. The entered value for compression is not a supported type.");
                        }
                        replBuilder.setCompressonwire(ctype);
                    } else if (props.getAttr().getIsMarlinTable()) {
                        ctype = DbReplicaCommands.this.getStreamCompression(mfs, path);
                        replBuilder.setCompressonwire(ctype);
                    }
                    if (isSync) {
                        if (!isReplicaTypeTable) {
                            throw new CLIProcessingException("Can setup synchronous replication only when the replica is a MapRDB table.");
                        }
                        replBuilder.setSynchronous(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.SYNCHRONOUS_PARAM_NAME, 0));
                    }
                    if (!isReplicaTypeTable && isMultiMaster) {
                        throw new CLIProcessingException("Can setup multi-master replication only when the replica is a MapRDB table.");
                    }
                    if (useExistingReplica) {
                        if (!isDirectCopy) {
                            throw new CLIProcessingException("Param useexistingreplica is supported only when param directcopy is set to true");
                        }
                        if (isMultiMaster) {
                            throw new CLIProcessingException("cannot use multi-master option with pre-existing replica table");
                        }
                    }
                    if (useExistingTopic && !isDirectCopy) {
                        throw new CLIProcessingException("Param useexistingtopic is supported only in changelog replication where param directcopy is set to true");
                    }
                    if (isReplicaTypeTable && !isDirectCopy) {
                        if (mfs.isTable(new Path(replicaFullPath))) {
                            LOG.info((Object)("Destination table: " + replicaFullPath + " exists already. Replication cannot be setup in auto mode"));
                            throw new CLIProcessingException("Destination table: " + replicaFullPath + " exists already. Replication cannot be setup in auto mode");
                        }
                        LOG.info((Object)("Creating the destination table: " + replicaFullPath + " as user: " + DbReplicaCommands.this.getUserLoginId()));
                        boolean isBulkLoad = true;
                        if (!isJson) {
                            List cfList = TableUtil.getColumnFamiliesList((String)colList);
                            if (props.getAttr().getIsMarlinTable()) {
                                isBulkLoad = false;
                            }
                            DbCommands.createTable(replicaFullPath, false, isBulkLoad, null, false, false, null, DbReplicaCommands.this.getUserLoginId(), tablePath, dbPerm, 15, cfList, -1, isJson);
                        } else {
                            List cfList = MapRDBTableImplHelper.getColumnFamiliesList((String)colList);
                            try {
                                DbReplicaCommands.this.createJSONTableForCopy(replicaFullPath, tablePath, cfList, isMarlinStream, isBulkLoad);
                            }
                            catch (Exception e) {
                                throw new CLIProcessingException("Failed to create replica " + replicaFullPath + " due to an exception: " + e.getMessage());
                            }
                        }
                        LOG.info((Object)"Finished creating destination table");
                    } else if (!isDirectCopy) {
                        replBuilder.setExternal(true);
                        rCName = DbReplicaCommands.verifyExternalDstSanity(mfs, replicaFullPath);
                    }
                    if (isChangeLog) {
                        rCName = DbReplicaCommands.CHANGELOGClASSNAME;
                        assert (replicaTopic != null);
                        assert (isDirectCopy);
                    }
                    if ((clist = colList) == null && isMarlinStream) {
                        clist = DbReplicaCommands.getStreamDefaultCFsForRepl();
                    }
                    LOG.info((Object)("setupReplication tablePath=" + tablePath + ", replicaFullPath=" + replicaFullPath + ", replicaTopic=" + replicaTopic + ", isChangeLog=" + isChangeLog + ", rCName=" + rCName + ", useExistingTopic=" + useExistingTopic + ", propagateexistingdata=" + propagateexistingdata + ", multiversion=" + multiversion));
                    DbReplicaCommands.setupReplication(dbPerm, replBuilder, tablePath, replicaFullPath, replicaTopic, clist, null, DbReplicaCommands.this.getUserLoginId(), mfs, rCName, isDirectCopy, isDirectCopy && isMultiMaster, isDirectCopy && useExistingReplica, useExistingTopic, propagateexistingdata, multiversion);
                    if (isReplicaTypeTable && !isDirectCopy) {
                        LOG.info((Object)"Creating upstream");
                        DbUpstreamCommands.addUpStream(replicaFullPath, tablePath, DbReplicaCommands.this.getUserLoginId());
                        LOG.info((Object)"Finished creating upstream");
                    }
                    if (!isDirectCopy) {
                        DbReplicaCommands.copyTable(tablePath, replicaFullPath, maxVersions, DbReplicaCommands.this.getStreamDefaultJsonPathsForRepl(clist), DbReplicaCommands.this.getUserLoginId(), waitForCompletion, ticketPath, isMultiMaster, dbPerm, replBuilder);
                    }
                }
            };
        }
        catch (UnsupportedOperationException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(95, e.getMessage()));
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, e.getMessage()));
        }
    }

    protected void autoSetup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String replicaFullPathParam = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        boolean isDirectCopySpecified = this.isParamPresent(DIRECT_COPY_PARAM_NAME);
        boolean isDirectCopyParam = isDirectCopySpecified ? this.getParamBooleanValue(DIRECT_COPY_PARAM_NAME, 0) : true;
        try {
            this.autoSetupInternal(out, isDirectCopyParam, false, replicaFullPathParam);
        }
        catch (UnsupportedOperationException e) {
            String errMsg = "Autosetup with Directcopy is not supported as mfs.feature.db.streams.v6.support feature is not enabled.";
            if (!isDirectCopySpecified) {
                LOG.info((Object)"DirectCopy not enabled. Retrying autoSetup without DirectCopy");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(11, errMsg + " Retrying Autosetup without DirectCopy"));
                this.autoSetupInternal(out, false, false, replicaFullPathParam);
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
        }
    }

    public static String verifyExternalDstSanity(MapRFileSystem mfs, String replicaFullPathStr) throws CLIProcessingException, IOException {
        String className = null;
        try {
            className = GatewaySink.verifyDstSanity((String)replicaFullPathStr);
        }
        catch (Exception e) {
            throw new CLIProcessingException(e.getMessage());
        }
        return className;
    }

    public static void setupMultiMaster(AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder, String tablePath, String replicaFullPath, String colList, String user) throws IOException, CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        TableProperties rtableProp = mfs.getTableProperties(new Path(tablePath));
        if (rtableProp.getUuid() == null || rtableProp.getUuid().length == 0) {
            throw new IOException("replica table does not have a uuid");
        }
        replBuilder.setTableUuid(ByteString.copyFrom((byte[])rtableProp.getUuid()));
        replBuilder.setIsPaused(false);
        DbReplicaCommands.setupReplication(dbPerm, replBuilder, replicaFullPath, tablePath, null, null, user, mfs, null, false, false, false);
        LOG.info((Object)"Creating upstream for source table in multi-master replication");
        DbUpstreamCommands.addUpStream(tablePath, replicaFullPath, user);
        LOG.info((Object)"Finished creating upstream for source table in multi-master replication");
    }

    public static String verifyExternalDstSanity(String dstTable) throws CLIProcessingException, IOException {
        return DbReplicaCommands.verifyExternalDstSanity(MapRCliUtil.getMapRFileSystem(), dstTable);
    }

    public static boolean isChangelogDestination(MapRFileSystem mfs, String dstTable) throws IOException {
        Path replicaPath = new Path(dstTable);
        return mfs.isChangelog(replicaPath);
    }

    public static boolean isChangelogDestination(String dstTable) throws IOException, CLIProcessingException {
        return DbReplicaCommands.isChangelogDestination(MapRCliUtil.getMapRFileSystem(), dstTable);
    }

    public static boolean isExternalDestination(MapRFileSystem mfs, String dstTable) throws IOException {
        Path replicaPath = new Path(dstTable);
        return mfs.isFile(replicaPath) && !mfs.isTable(replicaPath);
    }

    public static boolean isExternalDestination(String dstTable) throws IOException, CLIProcessingException {
        return DbReplicaCommands.isExternalDestination(MapRCliUtil.getMapRFileSystem(), dstTable);
    }

    protected void addReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String replicaFullPath = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        final String colList = this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
        final boolean isSync = this.isParamPresent(SYNCHRONOUS_PARAM_NAME) ? this.getParamBooleanValue(SYNCHRONOUS_PARAM_NAME, 0) : false;
        boolean validatePeer = true;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final DbReplicaCommands dbPerm = this;
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    Common.FileCompressionType ctype;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    boolean isReplicaTypeTable = !DbReplicaCommands.isExternalDestination(mfs, replicaFullPath);
                    Path path = new Path(tablePath);
                    String rCName = null;
                    if (!mfs.isTable(path)) {
                        throw new CLIProcessingException("Table not found. Path: " + tablePath);
                    }
                    TableProperties props = mfs.getTableProperties(path);
                    boolean isJson = props.getAttr().getJson();
                    boolean isMarlinStream = props.getAttr().getIsMarlinTable();
                    if (isReplicaTypeTable) {
                        Path rpath = new Path(replicaFullPath);
                        if (!mfs.isTable(rpath)) {
                            throw new CLIProcessingException("Replica table does not exist. Path: " + replicaFullPath);
                        }
                        TableProperties rprops = mfs.getTableProperties(rpath);
                        if (props.getAttr().getIsMarlinTable() != rprops.getAttr().getIsMarlinTable()) {
                            String msg = tablePath + " is " + (props.getAttr().getIsMarlinTable() ? "" : " not ") + "a stream, but replica " + replicaFullPath + " is " + (rprops.getAttr().getIsMarlinTable() ? "" : "not ") + "a stream";
                            throw new CLIProcessingException(msg);
                        }
                        if (props.getAttr().getJson() != rprops.getAttr().getJson()) {
                            String msg = tablePath + " is " + (props.getAttr().getJson() ? "" : " not ") + "a json table, but replica " + replicaFullPath + " is " + (rprops.getAttr().getJson() ? "" : "not ") + "a json table";
                            throw new CLIProcessingException(msg);
                        }
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.PAUSED_PARAM_NAME)) {
                        replBuilder.setIsPaused(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.PAUSED_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.THROTTLE_PARAM_NAME)) {
                        replBuilder.setThrottle(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.THROTTLE_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.ENCRYPTION_PARAM_NAME)) {
                        replBuilder.setEncryptonwire(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.ENCRYPTION_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COMPRESSION_PARAM_NAME)) {
                        ctype = DbReplicaCommands.getCompressionType(DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COMPRESSION_PARAM_NAME, 0));
                        if (ctype == null) {
                            throw new CLIProcessingException("Invalid input values. The entered value for compression is not a supported type.");
                        }
                        replBuilder.setCompressonwire(ctype);
                    } else if (props.getAttr().getIsMarlinTable()) {
                        ctype = DbReplicaCommands.this.getStreamCompression(mfs, path);
                        replBuilder.setCompressonwire(ctype);
                    }
                    if (isSync) {
                        if (isReplicaTypeTable) {
                            replBuilder.setSynchronous(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.SYNCHRONOUS_PARAM_NAME, 0));
                        } else {
                            throw new CLIProcessingException("Can use synchronous replication only when the replica is a MapRDB table.");
                        }
                    }
                    if (!isReplicaTypeTable) {
                        rCName = DbReplicaCommands.verifyExternalDstSanity(mfs, replicaFullPath);
                        replBuilder.setExternal(true);
                    }
                    String clist = colList;
                    if (colList == null && isMarlinStream) {
                        clist = DbReplicaCommands.getStreamDefaultCFsForRepl();
                    }
                    DbReplicaCommands.setupReplication(dbPerm, replBuilder, tablePath, replicaFullPath, clist, null, DbReplicaCommands.this.getUserLoginId(), mfs, rCName, false, false, false);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static void validateIndexedFields(String indexedColList, String tablePath, String user) throws CLIProcessingException {
        List<Dbserver.ColumnFamilyAttr> familyAttrs;
        try {
            familyAttrs = DbReplicaCommands.getAllFamilies(tablePath, user);
        }
        catch (IOException e) {
            throw new CLIProcessingException(e.getMessage());
        }
        for (String indexedFields : indexedColList.split(MULTI_ARG_SEP, -1)) {
            for (String indexedField : indexedFields.split(MULTI_FIELD_SEP)) {
                int separatorIndex = indexedField.indexOf(COLUMN_SEP);
                if (separatorIndex == -1) {
                    throw new CLIProcessingException(String.format("Invalid indexed column '%s'.\n%s", indexedField, "Indexed column must be specified in <column_family>:<column_qualifier> format."));
                }
                String familyName = indexedField.substring(0, separatorIndex);
                if (DbReplicaCommands.familyNameToId(familyAttrs, familyName) != 0) continue;
                throw new CLIProcessingException(String.format("The family '%s' specified in indexed column '%s' does not exist", familyName, indexedField));
            }
        }
    }

    public static void parseColList(String colList, String tablePath, String user, boolean isJsonTable, Map<Integer, SortedSet<String>> familyMap) throws CLIProcessingException {
        List<Dbserver.ColumnFamilyAttr> familyAttrs;
        if (colList == null || familyMap == null) {
            return;
        }
        String cfColList = colList;
        try {
            familyAttrs = DbReplicaCommands.getAllFamilies(tablePath, user);
        }
        catch (IOException e) {
            throw new CLIProcessingException(e.getMessage());
        }
        if (isJsonTable) {
            String[] jsonPaths = colList.split(MULTI_ARG_SEP, -1);
            String jsonColList = null;
            for (String jsonPath : jsonPaths) {
                String cfQual = MapRDBTableImplHelper.jsonPathToCfQualifier((String)jsonPath, familyAttrs);
                if (jsonColList != null) {
                    jsonColList = jsonColList + MULTI_ARG_SEP;
                    jsonColList = jsonColList + cfQual;
                    continue;
                }
                jsonColList = cfQual;
            }
            cfColList = jsonColList;
        }
        LOG.trace((Object)("Replication Columns: " + cfColList));
        for (String entry : cfColList.split(MULTI_ARG_SEP)) {
            String[] names = entry.split(COLUMN_SEP, 2);
            int famId = DbReplicaCommands.familyNameToId(familyAttrs, names[0]);
            SortedSet<String> cols = familyMap.get(famId);
            if (famId == 0) {
                throw new CLIProcessingException("counld not get familyId for columnFamily " + names[0]);
            }
            if (cols == null) {
                cols = new TreeSet<String>();
                familyMap.put(famId, cols);
                if (names.length <= 1) continue;
                cols.add(names[1]);
                continue;
            }
            if (names.length > 1 && !cols.isEmpty()) {
                cols.add(names[1]);
                continue;
            }
            if (cols.isEmpty()) continue;
            cols.clear();
        }
    }

    public static void addCfQualifiers(Map<Integer, SortedSet<String>> familyMap, Dbserver.TableReplicaDesc.Builder replBuilder) {
        for (Map.Entry<Integer, SortedSet<String>> entry : familyMap.entrySet()) {
            Dbserver.Qualifier.Builder qualBuilder = Dbserver.Qualifier.newBuilder();
            qualBuilder.setFamily(entry.getKey().intValue());
            for (String colName : entry.getValue()) {
                qualBuilder.addQualifiers(ByteString.copyFrom((byte[])colName.getBytes()));
            }
            replBuilder.addQualifiers(qualBuilder.build());
        }
    }

    private static String getStreamDefaultCFsForRepl() {
        Marlinserver.MarlinInternalDefaults mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
        return mdef.getCfTopicMeta() + MULTI_ARG_SEP + mdef.getCfMessages() + MULTI_ARG_SEP + mdef.getCfCursors();
    }

    private Common.FileCompressionType getStreamCompression(MapRFileSystem mfs, Path stream) throws IOException {
        MapRAdmin madmin = new MapRAdmin(mfs);
        Marlinserver.MarlinInternalDefaults mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
        Dbserver.ColumnFamilyAttr cfAttr = madmin.getColumnFamily(stream, mdef.getCfMessages(), false);
        return cfAttr.getSchFamily().getCompression();
    }

    public static void setupReplication(AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder, String tablePath, String replicaFullPath, String clist, String indexedColList, String user, MapRFileSystem mfs, String replicaClassName, boolean isDirectCopy, boolean isMultimaster, boolean useExistingReplica) throws CLIProcessingException, IOException, UnsupportedOperationException {
        DbReplicaCommands.setupReplication(dbPerm, replBuilder, tablePath, replicaFullPath, null, clist, indexedColList, user, mfs, replicaClassName, isDirectCopy, isMultimaster, useExistingReplica, false, true, true);
    }

    public static void setupReplication(AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder, String tablePath, String replicaFullPath, String topic, String clist, String indexedColList, String user, MapRFileSystem mfs, String replicaClassName, boolean isDirectCopy, boolean isMultimaster, boolean useExistingReplica, boolean useExistingTopic, boolean propagateExistingData, boolean multiversion) throws CLIProcessingException, IOException {
        RecentTablesListManager manager = StreamsCommands.isStream(tablePath) ? RecentStreamsListManagers.getRecentStreamsListManagerForUser(user) : RecentTablesListManagers.getRecentTablesListManagerForUser(user);
        try {
            boolean fetchReplicaUuid;
            TableProperties tableProp = mfs.getTableProperties(new Path(tablePath));
            if (tableProp.getUuid() == null || tableProp.getUuid().length == 0) {
                throw new IOException("Table " + tablePath + " does not have a uuid. Set replperm and retry operation");
            }
            boolean isReplicaTypeTable = isDirectCopy || !DbReplicaCommands.isExternalDestination(mfs, replicaFullPath);
            boolean bl = fetchReplicaUuid = isReplicaTypeTable && !isDirectCopy;
            if (fetchReplicaUuid) {
                TableProperties replicaTableProp = mfs.getTableProperties(new Path(replicaFullPath));
                if (replicaTableProp.getUuid() == null || replicaTableProp.getUuid().length == 0) {
                    throw new IOException("Replica table " + replicaFullPath + " does not have a uuid. Set replperm and retry operation");
                }
                replBuilder.setTableUuid(ByteString.copyFrom((byte[])replicaTableProp.getUuid()));
            }
            if (tableProp.getAttr().getBulkLoad() && !isDirectCopy) {
                throw new CLIProcessingException("source cannot be in bulkload mode. Path: " + tablePath);
            }
            String colList = clist;
            if (indexedColList != null) {
                DbReplicaCommands.validateIndexedFields(indexedColList, tablePath, user);
                replBuilder.setIndexedFields(indexedColList);
                if (colList != null) {
                    colList = colList + MULTI_ARG_SEP + indexedColList.replace(MULTI_FIELD_SEP, MULTI_ARG_SEP);
                }
            }
            boolean isJson = tableProp.getAttr().getJson();
            boolean isStream = tableProp.getAttr().getIsMarlinTable();
            if (colList != null && colList.length() > 0) {
                TreeMap<Integer, SortedSet<String>> familyMap = new TreeMap<Integer, SortedSet<String>>();
                DbReplicaCommands.parseColList(colList, tablePath, user, isJson && !isStream, familyMap);
                if (familyMap.isEmpty()) {
                    throw new CLIProcessingException("empty list invalid for param columns");
                }
                DbReplicaCommands.addCfQualifiers(familyMap, replBuilder);
            }
            if (replicaClassName == null) {
                if (tableProp.getAttr().getIsMarlinTable()) {
                    replBuilder.setReplicaClassName(MAPRSTREAM_REPLICA_CLASS_NAME);
                } else {
                    replBuilder.setReplicaClassName(MAPRDB_REPLICA_CLASS_NAME);
                }
            } else {
                if (replicaClassName.equals(CHANGELOGClASSNAME) && isStream) {
                    throw new CLIProcessingException("ChangeLog is not supported for stream source table.");
                }
                replBuilder.setReplicaClassName(replicaClassName);
            }
            Path rpath = new Path(replicaFullPath);
            String clusterName = mfs.getClusterName(rpath.toUri());
            replBuilder.setClusterName(clusterName);
            String replicaPath = mfs.getNameStr(replicaFullPath);
            replBuilder.setTablePath(replicaPath);
            if (topic != null) {
                replBuilder.setTopicName(topic);
            }
            if (!(replBuilder.hasExternal() && replBuilder.getExternal() || isDirectCopy || mfs.isTable(rpath))) {
                throw new CLIProcessingException("Replica should be a table. Path: " + replicaPath);
            }
            if (clusterName.equals(mfs.getClusterNameUnchecked(tablePath)) && replicaPath.equals(mfs.getNameStr(tablePath))) {
                throw new CLIProcessingException("source and replica tables cannot be same");
            }
            if (isDirectCopy) {
                replBuilder.setRstate(Dbserver.TableReplicaState.REPLICA_STATE_WAIT_TILL_BULKLOAD);
            }
            Dbserver.TableReplicaDesc replDesc = replBuilder.build();
            Dbserver.TableReplAutoSetupInfo autoSetupInfo = null;
            if (isDirectCopy) {
                Dbserver.TableReplAutoSetupInfo.Builder asBuilder = Dbserver.TableReplAutoSetupInfo.newBuilder();
                asBuilder.setMultimaster(isMultimaster);
                asBuilder.setUseExistingReplica(useExistingReplica);
                asBuilder.setUseExistingTopic(useExistingTopic);
                asBuilder.setMultiversion(multiversion);
                autoSetupInfo = asBuilder.build();
            }
            mfs.addTableReplica(new Path(tablePath), replDesc, autoSetupInfo);
            manager.moveToTop(tablePath);
        }
        catch (UnsupportedOperationException e) {
            manager.deleteIfNotExist(tablePath, mfs);
            throw e;
        }
        catch (Exception e) {
            manager.deleteIfNotExist(tablePath, mfs);
            throw new CLIProcessingException(e.getMessage());
        }
    }

    public static void copyTable(String tablePath, String replicaFullPath, int maxVersions, String colList, String user, boolean waitForCompletion, String ticketPath, boolean isMultiMaster, AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder) throws CLIProcessingException {
        ExecutorService execService = JobExecutor.getExecutorService();
        CopyTableCallable copyTableTask = new CopyTableCallable(tablePath, replicaFullPath, user, maxVersions, colList, ticketPath, isMultiMaster, dbPerm, replBuilder);
        LOG.info((Object)("Calling copy table for tables: " + tablePath + MULTI_ARG_SEP + replicaFullPath + " by user: " + user));
        Future<Integer> status = execService.submit(copyTableTask);
        if (waitForCompletion) {
            try {
                if (status.get() == null) {
                    throw new CLIProcessingException("Copy Table failed for tables: " + tablePath + MULTI_ARG_SEP + replicaFullPath);
                }
            }
            catch (Exception e) {
                throw new CLIProcessingException(e.getMessage());
            }
        }
    }

    private boolean isExternalReplicaClass(String className) {
        return !className.equals(MAPRDB_REPLICA_CLASS_NAME) && !className.equals(MAPRSTREAM_REPLICA_CLASS_NAME) && !className.equals(CHANGELOGClASSNAME);
    }

    protected void listChangelogReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this.listReplicaInternal(out, true);
    }

    protected void listReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this.listReplicaInternal(out, false);
    }

    private void listReplicaInternal(CommandOutput.OutputHierarchy out, boolean changelogOp) throws CLIProcessingException {
        final boolean refreshNow = this.isParamPresent(REFRESH_PARAM_NAME) ? this.getParamBooleanValue(REFRESH_PARAM_NAME, 0) : false;
        boolean isDebug = this.isParamPresent(DEBUG_PARAM_NAME) ? this.getParamBooleanValue(DEBUG_PARAM_NAME, 0) : false;
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final RecentTablesListManager manager = this.getRecentListManager(this.getUserLoginId());
        final ArrayList rlist = new ArrayList();
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableReplicaListResponse resp = mfs.listTableReplicas(new Path(tablePath), true, refreshNow);
                        rlist.add(resp);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
            boolean isJson = mfs.isJsonTable(new Path(tablePath));
            Dbserver.TableReplicaListResponse listResp = (Dbserver.TableReplicaListResponse)rlist.get(0);
            List<Dbserver.ColumnFamilyAttr> familyAttrs = DbReplicaCommands.getAllFamilies(tablePath, this.getUserLoginId());
            for (Dbserver.TableReplicaDesc rd : listResp.getReplicasList()) {
                String replicaName;
                boolean isExternal = this.isExternalReplicaClass(rd.getReplicaClassName());
                CommandOutput.OutputHierarchy.OutputNode replNode = new CommandOutput.OutputHierarchy.OutputNode();
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)rd.getClusterName()));
                if (!isDebug) {
                    if (!isExternal) {
                        if (changelogOp) {
                            if (!rd.hasTopicName()) continue;
                            replicaName = rd.getTablePath() + COLUMN_SEP + rd.getTopicName();
                            replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.entityName(), (Object)replicaName));
                        } else {
                            if (rd.hasTopicName()) continue;
                            replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.entityName(), (Object)rd.getTablePath()));
                            replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)rd.getReplicaClassName()));
                        }
                    } else {
                        replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.entityName(), (Object)GatewaySink.getDestinationName((String)rd.getTablePath())));
                        replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)GatewaySink.getDestinationType((String)rd.getTablePath())));
                    }
                } else if (!isExternal) {
                    if (rd.hasTopicName()) {
                        replicaName = rd.getTablePath() + COLUMN_SEP + rd.getTopicName();
                        replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.entityName(), (Object)replicaName));
                        replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("topicUniq", rd.getTopicUniq()));
                        replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numFeeds", rd.getNumFeeds()));
                    } else {
                        replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.entityName(), (Object)rd.getTablePath()));
                    }
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)rd.getReplicaClassName()));
                } else {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.entityName(), (Object)GatewaySink.getDestinationName((String)rd.getTablePath())));
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)GatewaySink.getDestinationType((String)rd.getTablePath())));
                }
                if (changelogOp) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("changelogStream", (Object)rd.getTablePath()));
                } else {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicaPath", (Object)rd.getTablePath()));
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicaState", (Object)rd.getRstate().toString()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(PAUSED_PARAM_NAME, (Object)rd.getIsPaused()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(THROTTLE_PARAM_NAME, (Object)rd.getThrottle()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", rd.getIdx()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENCRYPTION_PARAM_NAME, (Object)rd.getEncryptonwire()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SYNCHRONOUS_PARAM_NAME, (Object)rd.getSynchronous()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(COMPRESSION_PARAM_NAME, (Object)DbReplicaCommands.getCompressionName(rd.getCompressonwire())));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("propagateExistingData", (Object)rd.getPropagateExistingData()));
                if ((this.entityName().equals("table") || this.entityName().equals(CHANGELOG_PARAM_NAME)) && rd.getQualifiersCount() > 0) {
                    String famList = "";
                    int idx = 0;
                    for (Dbserver.Qualifier qual : rd.getQualifiersList()) {
                        String famName = DbReplicaCommands.familyIdToName(familyAttrs, qual.getFamily());
                        if (famName == null) {
                            LOG.error((Object)("failed to get family name for id " + qual.getFamily()));
                        }
                        if (qual.getQualifiersCount() > 0) {
                            for (ByteString bstr : qual.getQualifiersList()) {
                                if (idx == 0) {
                                    if (isJson) {
                                        FieldPath jsonFP = MapRDBTableImplHelper.cfQualifierToJsonPath((String)famName, (String)bstr.toStringUtf8(), familyAttrs);
                                        famList = jsonFP.asPathString(false);
                                    } else {
                                        famList = famName + COLUMN_SEP + bstr.toStringUtf8();
                                    }
                                } else {
                                    famList = famList + MULTI_ARG_SEP + (isJson ? MapRDBTableImplHelper.cfQualifierToJsonPath((String)famName, (String)bstr.toStringUtf8(), familyAttrs) : famName + COLUMN_SEP + bstr.toStringUtf8());
                                }
                                ++idx;
                            }
                            continue;
                        }
                        if (idx == 0) {
                            if (isJson) {
                                FieldPath jsonFP = MapRDBTableImplHelper.cfQualifierToJsonPath((String)famName, null, familyAttrs);
                                famList = jsonFP.asPathString(false);
                            } else {
                                famList = famName;
                            }
                            ++idx;
                            continue;
                        }
                        famList = famList + MULTI_ARG_SEP + (isJson ? MapRDBTableImplHelper.cfQualifierToJsonPath((String)famName, null, familyAttrs) : famName);
                        ++idx;
                    }
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Columns", (Object)famList));
                }
                String replicaTablePath = DbReplicaCommands.getTransformedTablePath(rd.getClusterName(), rd.getTablePath());
                if (JobExecutor.getStatus(tablePath + "_" + replicaTablePath) != null) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("copytablestatus", (Object)JobExecutor.getStatus(tablePath + "_" + replicaTablePath)));
                }
                long minPendingTS = 0L;
                long maxPendingTS = 0L;
                long bytesPending = 0L;
                long putsPending = 0L;
                int bucketsPending = 0;
                int asyncBuckets = 0;
                int copyTableCompletionPct = 0;
                long lastReplicatedPutTs = 0L;
                ArrayList<Error.ExtendedError> elist = null;
                for (Dbserver.TableReplicaStatus rs : listResp.getReplicaStatusList()) {
                    if (rd.getIdx() != rs.getReplicaIdx()) continue;
                    minPendingTS = rs.getMinPendingTS();
                    maxPendingTS = rs.getMaxPendingTS();
                    bytesPending = rs.getBytesPending();
                    putsPending = rs.getPutsPending();
                    bucketsPending = rs.getBucketsPending();
                    asyncBuckets = rs.getAsyncBuckets();
                    copyTableCompletionPct = Math.min(rs.getCopyTableCompletionPct(), 99);
                    if (rs.hasLastReplicatedPutTs()) {
                        lastReplicatedPutTs = rs.getLastReplicatedPutTs();
                    }
                    for (Error.ExtendedError ee : rs.getEerrorsList()) {
                        if (elist == null) {
                            elist = new ArrayList<Error.ExtendedError>();
                        }
                        elist.add(ee);
                    }
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("isUptodate", (Object)(bucketsPending == 0 && !rd.getIsPaused() ? 1 : 0)));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("minPendingTS", minPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxPendingTS", maxPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bytesPending", bytesPending));
                if (this.entityName().equals("table") || this.entityName().equals(CHANGELOG_PARAM_NAME)) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("putsPending", putsPending));
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketsPending", bucketsPending));
                byte[] uuid = rd.getTableUuid().toByteArray();
                if (uuid.length != 0) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString((byte[])uuid)));
                }
                if (rd.getSynchronous()) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numAsyncBuckets", asyncBuckets));
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("switchedToAsync", (Object)(asyncBuckets != 0 ? 1 : 0)));
                }
                if (rd.getRstate() == Dbserver.TableReplicaState.REPLICA_STATE_REPLICATING) {
                    copyTableCompletionPct = 100;
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("copyTableCompletionPercentage", copyTableCompletionPct));
                if (isDebug) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastReplicatedPutTimestamp", lastReplicatedPutTs));
                }
                if (elist != null) {
                    for (Error.ExtendedError ee : elist) {
                        CommandOutput.OutputHierarchy.OutputNode errNodes = new CommandOutput.OutputHierarchy.OutputNode("errors");
                        replNode.addChild(errNodes);
                        if (ee.hasEcode()) {
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Code", (Object)ee.getEcode().name()));
                        }
                        if (ee.hasEhost()) {
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Host", (Object)Util.intToIp((int)ee.getEhost())));
                        }
                        if (!ee.hasEmsg()) continue;
                        errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Msg", (Object)ee.getEmsg()));
                    }
                }
                out.addNode(replNode);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static String getTransformedTablePath(String clusterName, String tableName) {
        if (!clusterName.equals(CLDBRpcCommonUtils.getInstance().getCurrentClusterName())) {
            return "/mapr/" + clusterName + tableName;
        }
        return tableName;
    }

    protected void editChangelogReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String replicaFullPathParam = DbCommands.getTransformedPath(this.getParamTextValue(CHANGELOG_PARAM_NAME, 0), this.getUserLoginId());
        this.editReplicaInternal(out, true, replicaFullPathParam);
    }

    protected void editReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String replicaFullPathParam = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        this.editReplicaInternal(out, false, replicaFullPathParam);
    }

    private void editReplicaInternal(CommandOutput.OutputHierarchy out, final boolean changelogOp, String replicaFullPathParam) throws CLIProcessingException {
        boolean ret;
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String[] stnames = null;
        if (changelogOp && !(ret = DbReplicaCommands.parseStreamTopicName(replicaFullPathParam, stnames = new String[2], out))) {
            return;
        }
        final String replicaFullPath = changelogOp ? stnames[0] : replicaFullPathParam;
        final String topicName = changelogOp ? stnames[1] : null;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final int replDescSerializedSize = replBuilder.build().getSerializedSize();
        final boolean isSync = this.isParamPresent(SYNCHRONOUS_PARAM_NAME) ? this.getParamBooleanValue(SYNCHRONOUS_PARAM_NAME, 0) : false;
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    boolean allowAllCfs;
                    boolean isReplicaTypeTable;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (changelogOp) {
                        DbReplicaCommands.verifyStreamPath(mfs, replicaFullPath, false);
                    }
                    String replicaClusterName = mfs.getClusterNameUnchecked(replicaFullPath);
                    String replicaPath = mfs.getNameStr(replicaFullPath);
                    boolean bl = isReplicaTypeTable = !DbReplicaCommands.isExternalDestination(mfs, replicaFullPath);
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.NEWREPLICA_PARAM_NAME)) {
                        if (changelogOp) {
                            throw new CLIProcessingException("Can not rename a changelog");
                        }
                        Dbserver.TableReplicaDesc rd = DbReplicaCommands.this.getReplica(tablePath, replicaClusterName, replicaPath);
                        if (rd == null) {
                            throw new IOException("Replica not found");
                        }
                        if (rd.hasExternal() && rd.getExternal()) {
                            throw new CLIProcessingException("Can not rename an external replica");
                        }
                        String newReplicaFullPath = DbCommands.getTransformedPath(DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.NEWREPLICA_PARAM_NAME, 0), DbReplicaCommands.this.getUserLoginId());
                        Path newRpath = new Path(newReplicaFullPath);
                        String newReplicaClusterName = mfs.getClusterName(newRpath.toUri());
                        replBuilder.setClusterName(newReplicaClusterName);
                        String newReplicaPath = mfs.getNameStr(newReplicaFullPath);
                        replBuilder.setTablePath(newReplicaPath);
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        if (!mfs.isTable(newRpath)) {
                            throw new CLIProcessingException("New Replica not found. Path: " + newReplicaPath);
                        }
                        if (newReplicaClusterName.equals(mfs.getClusterNameUnchecked(tablePath)) && newReplicaPath.equals(mfs.getNameStr(tablePath))) {
                            throw new CLIProcessingException("source and replica tables cannot be same");
                        }
                        TableProperties rtableProp = mfs.getTableProperties(newRpath);
                        if (rtableProp.getUuid() == null || rtableProp.getUuid().length == 0) {
                            throw new IOException("replica table does not have a uuid");
                        }
                        replBuilder.setTableUuid(ByteString.copyFrom((byte[])rtableProp.getUuid()));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COMPRESSION_PARAM_NAME)) {
                        boolean updateCompression = false;
                        String compressionStr = DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COMPRESSION_PARAM_NAME, 0);
                        if (compressionStr.equals("on")) {
                            Dbserver.TableReplicaDesc rd = DbReplicaCommands.this.getReplica(tablePath, replicaClusterName, replicaPath, topicName);
                            if (rd == null) {
                                throw new IOException("Replica not found");
                            }
                            if (!rd.hasCompressonwire() || rd.getCompressonwire() == Common.FileCompressionType.FCT_OFF) {
                                updateCompression = true;
                            }
                        } else {
                            updateCompression = true;
                        }
                        if (updateCompression) {
                            Common.FileCompressionType ctype = DbReplicaCommands.getCompressionType(compressionStr);
                            if (ctype == null) {
                                throw new CLIProcessingException("Invalid input values. The entered value for compression is not a supported type.");
                            }
                            replBuilder.setCompressonwire(ctype);
                        }
                    }
                    boolean bl2 = DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COLUMNS_PARAM_NAME) ? DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COLUMNS_PARAM_NAME, 0).trim().length() == 0 : (allowAllCfs = false);
                    if (!allowAllCfs && DbReplicaCommands.this.isParamPresent(DbReplicaCommands.COLUMNS_PARAM_NAME)) {
                        String colList = DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.COLUMNS_PARAM_NAME, 0);
                        TreeMap<Integer, SortedSet<String>> familyMap = new TreeMap<Integer, SortedSet<String>>();
                        String user = DbReplicaCommands.this.getUserLoginId();
                        String tablePath2 = DbCommands.getTransformedPath(DbReplicaCommands.this.getParamTextValue(DbReplicaCommands.PATH_PARAM_NAME, 0), user);
                        TableProperties srcTableProp = mfs.getTableProperties(new Path(tablePath2));
                        boolean isJson = srcTableProp.getAttr().getJson();
                        boolean isStream = srcTableProp.getAttr().getIsMarlinTable();
                        DbReplicaCommands.parseColList(colList, tablePath2, user, isJson && !isStream, familyMap);
                        DbReplicaCommands.addCfQualifiers(familyMap, replBuilder);
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.THROTTLE_PARAM_NAME)) {
                        replBuilder.setThrottle(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.THROTTLE_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.ENCRYPTION_PARAM_NAME)) {
                        replBuilder.setEncryptonwire(DbReplicaCommands.this.getParamBooleanValue(DbReplicaCommands.ENCRYPTION_PARAM_NAME, 0));
                    }
                    if (DbReplicaCommands.this.isParamPresent(DbReplicaCommands.SYNCHRONOUS_PARAM_NAME)) {
                        if (isSync && !isReplicaTypeTable) {
                            throw new CLIProcessingException("Can setup synchronous replication only when the replica is a MapRDB table.");
                        }
                        replBuilder.setSynchronous(isSync);
                    }
                    if (replDescSerializedSize == replBuilder.build().getSerializedSize() && !allowAllCfs) {
                        return;
                    }
                    RecentTablesListManager manager = DbReplicaCommands.this.getRecentListManager(DbReplicaCommands.this.getUserLoginId());
                    try {
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        mfs.editTableReplica(new Path(tablePath), replicaClusterName, replicaPath, topicName, allowAllCfs, replDesc);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return;
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            return;
        }
    }

    protected void removeChangelogReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String replicaFullPathParam = DbCommands.getTransformedPath(this.getParamTextValue(CHANGELOG_PARAM_NAME, 0), this.getUserLoginId());
        this.removeReplicaInternal(out, true, replicaFullPathParam);
    }

    protected void removeReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String replicaFullPathParam = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        this.removeReplicaInternal(out, false, replicaFullPathParam);
    }

    private void removeReplicaInternal(CommandOutput.OutputHierarchy out, final boolean changelogOp, String replicaFullPathParam) throws CLIProcessingException {
        boolean ret;
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String[] stnames = null;
        if (changelogOp && !(ret = DbReplicaCommands.parseStreamTopicName(replicaFullPathParam, stnames = new String[2], out))) {
            return;
        }
        final String replicaFullPath = changelogOp ? stnames[0] : replicaFullPathParam;
        final String topicName = changelogOp ? stnames[1] : null;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final RecentTablesListManager manager = this.getRecentListManager(this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (changelogOp) {
                        DbReplicaCommands.verifyStreamPath(mfs, replicaFullPath, true);
                    }
                    try {
                        Path rpath = new Path(replicaFullPath);
                        String clusterName = mfs.getClusterNameUnchecked(replicaFullPath);
                        replBuilder.setClusterName(clusterName);
                        String replicaPath = mfs.getNameStr(replicaFullPath);
                        replBuilder.setTablePath(replicaPath);
                        if (topicName != null) {
                            replBuilder.setTopicName(topicName);
                        }
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        mfs.removeTableReplica(new Path(tablePath), replDesc);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static void pauseOrResumeReplication(String tablePath, String replicaFullPath, boolean isPaused, String loginId) throws CLIProcessingException {
        DbReplicaCommands.pauseOrResumeReplication(tablePath, replicaFullPath, null, isPaused, loginId);
    }

    public static void pauseOrResumeReplication(final String tablePath, final String replicaFullPath, final String topicName, boolean isPaused, String loginId) throws CLIProcessingException {
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        replBuilder.setIsPaused(isPaused);
        try {
            final RecentTablesListManager manager = StreamsCommands.isStream(tablePath) ? RecentStreamsListManagers.getRecentStreamsListManagerForUser(loginId) : RecentTablesListManagers.getRecentTablesListManagerForUser(loginId);
            new FileclientRun(loginId){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (topicName != null) {
                        DbReplicaCommands.verifyStreamPath(mfs, replicaFullPath, false);
                    }
                    try {
                        Path rpath = new Path(replicaFullPath);
                        String replicaClusterName = mfs.getClusterNameUnchecked(replicaFullPath);
                        String replicaPath = mfs.getNameStr(replicaFullPath);
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        mfs.editTableReplica(new Path(tablePath), replicaClusterName, replicaPath, topicName, false, replDesc);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (Exception e) {
            throw new CLIProcessingException(e.getMessage());
        }
    }

    protected void pauseOrResumeChangelogReplica(CommandOutput.OutputHierarchy out, boolean isPaused) throws CLIProcessingException {
        String replicaFullPathParam = DbCommands.getTransformedPath(this.getParamTextValue(CHANGELOG_PARAM_NAME, 0), this.getUserLoginId());
        this.pauseOrResumeReplicaInternal(out, true, replicaFullPathParam, isPaused);
    }

    protected void pauseOrResumeReplica(CommandOutput.OutputHierarchy out, boolean isPaused) throws CLIProcessingException {
        String replicaFullPathParam = DbCommands.getTransformedPath(this.getParamTextValue(REPLICA_PARAM_NAME, 0), this.getUserLoginId());
        this.pauseOrResumeReplicaInternal(out, false, replicaFullPathParam, isPaused);
    }

    private void pauseOrResumeReplicaInternal(CommandOutput.OutputHierarchy out, boolean changelogOp, String replicaFullPathParam, boolean isPaused) throws CLIProcessingException {
        boolean ret;
        String[] stnames = null;
        if (changelogOp && !(ret = DbReplicaCommands.parseStreamTopicName(replicaFullPathParam, stnames = new String[2], out))) {
            return;
        }
        String replicaFullPath = changelogOp ? stnames[0] : replicaFullPathParam;
        String topicName = changelogOp ? stnames[1] : null;
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        try {
            DbReplicaCommands.pauseOrResumeReplication(tablePath, replicaFullPath, topicName, isPaused, this.getUserLoginId());
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private Dbserver.TableReplicaDesc getReplica(String tablePath, String replClusterName, String replTablePath) throws IOException, CLIProcessingException {
        return this.getReplica(tablePath, replClusterName, replTablePath, null);
    }

    private Dbserver.TableReplicaDesc getReplica(final String tablePath, String replClusterName, String replTablePath, String topicName) throws IOException, CLIProcessingException {
        final RecentTablesListManager manager = this.getRecentListManager(this.getUserLoginId());
        final ArrayList rlist = new ArrayList();
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableReplicaListResponse resp = mfs.listTableReplicas(new Path(tablePath), false, false);
                        rlist.add(resp);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
            Dbserver.TableReplicaListResponse listResp = (Dbserver.TableReplicaListResponse)rlist.get(0);
            for (Dbserver.TableReplicaDesc rd : listResp.getReplicasList()) {
                boolean topicmatch;
                boolean tablematch = replClusterName.equals(rd.getClusterName()) && replTablePath.equals(rd.getTablePath());
                boolean bl = topicmatch = topicName == null && !rd.hasTopicName() || topicName != null && topicName.equals(rd.getTopicName());
                if (!tablematch || !topicmatch) continue;
                return rd;
            }
            return null;
        }
        catch (CLIProcessingException e) {
            throw new CLIProcessingException(e.getMessage());
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static List<Dbserver.ColumnFamilyAttr> getAllFamilies(String tablePath, String user) throws IOException, CLIProcessingException {
        final String tablePathFinal = tablePath;
        final ArrayList<Dbserver.ColumnFamilyAttr> cfListFinal = new ArrayList<Dbserver.ColumnFamilyAttr>();
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                List colList = mfs.listColumnFamily(new Path(tablePathFinal), false);
                cfListFinal.addAll(colList);
            }
        };
        return cfListFinal;
    }

    private static int familyNameToId(List<Dbserver.ColumnFamilyAttr> cfAttrList, String familyName) {
        for (Dbserver.ColumnFamilyAttr cf : cfAttrList) {
            if (!cf.getSchFamily().getName().equals(familyName)) continue;
            return cf.getSchFamily().getId();
        }
        return 0;
    }

    public static String familyIdToName(List<Dbserver.ColumnFamilyAttr> cfAttrList, int familyId) {
        for (Dbserver.ColumnFamilyAttr cf : cfAttrList) {
            if (cf.getSchFamily().getId() != familyId) continue;
            return cf.getSchFamily().getName();
        }
        return null;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key)) {
                ret = this.getParamTextValue(key, 0);
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }

    protected RecentTablesListManager getRecentListManager(String user) {
        return RecentTablesListManagers.getRecentTablesListManagerForUser(user);
    }
}

