/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.cli.DbCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRFsUtil;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DbCfColCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbCfColCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String CFNAME_PARAM_NAME = "cfname";
    private static final String COLNAME_PARAM_NAME = "name";
    private static final String READ_PARAM_NAME = "readperm";
    private static final String WRITE_PARAM_NAME = "writeperm";
    private static final String APPEND_PARAM_NAME = "appendperm";
    private static final String ENCRYPT_PARAM_NAME = "encryptperm";
    private static final String TRAVERSE_PARAM_NAME = "traverseperm";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    private static final CLICommand getCommand = new CLICommand("get", "usage: table cf colperm get -path <tablepath>", DbCfColCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "Column name", false, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("table cf colperm list -path <tablepath> -cfname <cf name>");
    private static final CLICommand setCommand = new CLICommand("set", "usage: table cf colperm set -path <tablepath> -cfname <cfname> -colname <column name> -traverse <traverse permission> -read <read permission> -write <write permission> -append <append permission> -encrypt <encrypt permission> (-traverse is supported for tables with tabletype=json only.)", DbCfColCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "Column name", true, null)).put((Object)"readperm", (Object)new TextInputParameter("readperm", "Read column permission settings", false, null)).put((Object)"writeperm", (Object)new TextInputParameter("writeperm", "Write column permission settings", false, null)).put((Object)"appendperm", (Object)new TextInputParameter("appendperm", "Append column permission settings", false, null)).put((Object)"encryptperm", (Object)new TextInputParameter("encryptperm", "Encrypt column permission settings", false, null).setInvisible(true)).put((Object)"traverseperm", (Object)new TextInputParameter("traverseperm", "Traverse column permission settings", false, null)).build(), null).setShortUsage("table cf colperm create -path <tablepath> -cfname <cfname> -colname <column name> -traverse <traverse permission> -read <read permission> -write <write permission> -append <append permission> -encrypt <encrypt permission>");
    private static final CLICommand deleteCommand = new CLICommand("delete", "usage: table cf colperm delete -path <tablepath> -cfname <cfname> -colname <colname>", DbCfColCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "Column name", true, null)).build(), null).setShortUsage("table cf col delete -path <tablepath> -cfname <cfname> -colname <colname>");
    public static final CLICommand cfColCommands = new CLICommand("colperm", "colperm [get|set|delete]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{getCommand, setCommand, deleteCommand}).setShortUsage("table cf colperm [get|set|delete]");
    private static final Map<String, String> verboseToTerseMap = new ImmutableMap.Builder().put((Object)"path", (Object)"p").put((Object)"cfname", (Object)"cfn").put((Object)"name", (Object)"n").put((Object)"read", (Object)"r").put((Object)"write", (Object)"w").put((Object)"append", (Object)"a").put((Object)"encrypt", (Object)"e").put((Object)"traverse", (Object)"t").build();

    public DbCfColCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(setCommand.getCommandName())) {
            this.setCol(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(deleteCommand.getCommandName())) {
            this.deleteCol(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(getCommand.getCommandName())) {
            this.getCol(out);
        }
        return output;
    }

    private void setCol(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        Dbserver.ColumnFamilyAttr cfAttr = null;
        Dbserver.SchemaFamily schFamily = null;
        String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
        String colName = null;
        TableProperties tableProp = null;
        boolean isJson = false;
        try {
            tableProp = mfs.getTableProperties(new Path(tablePath));
            isJson = tableProp.getAttr().getJson();
            colName = isJson && !cfName.equals("default") ? MapRFsUtil.getPrefixedColName((String)this.getParamTextValue(COLNAME_PARAM_NAME, 0)) : this.getParamTextValue(COLNAME_PARAM_NAME, 0);
            ByteString colByteName = ByteString.copyFromUtf8((String)colName);
            cfAttr = DbCfColCommands.getColumnFamily(tablePath, cfName);
            if (cfAttr == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                return;
            }
            schFamily = cfAttr.getSchFamily();
            if (schFamily == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Column family " + cfName + " not found under Table " + tablePath));
                return;
            }
            int index = this.findColumnPos(colByteName, cfAttr.getColumnAttrList());
            Dbserver.ColumnAttr.Builder builder = Dbserver.ColumnAttr.newBuilder();
            ArrayList ace = AceHelper.getColumnPermission((AceHelper.DBPermission)this);
            Dbserver.ColumnFamilyAttr.Builder cfBuilder = cfAttr.toBuilder();
            if (index == -1) {
                builder.setQualifier(colByteName);
                if (ace.size() > 0) {
                    builder.addAllAces((Iterable)ace);
                }
                cfBuilder.addColumnAttr(builder.build());
            } else {
                HashMap<Dbserver.DBAccessType, Dbserver.AccessControlExpression> col = new HashMap<Dbserver.DBAccessType, Dbserver.AccessControlExpression>();
                Dbserver.ColumnAttr cAttr = cfBuilder.getColumnAttr(index);
                for (Dbserver.AccessControlExpression a : cAttr.getAcesList()) {
                    col.put(a.getAccessType(), a);
                }
                for (Dbserver.AccessControlExpression a : ace) {
                    col.put(a.getAccessType(), a);
                }
                builder = cAttr.toBuilder().clearAces().addAllAces(col.values());
                cfBuilder.setColumnAttr(index, builder.build());
            }
            cfAttr = cfBuilder.clearAces().clearSchFamily().clearJsonFamilyPath().build();
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        this.modifyColumnSettings(tablePath, cfName, cfAttr, out);
    }

    private void deleteCol(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
        TableProperties tableProp = null;
        boolean isJson = false;
        String colName = null;
        ByteString colByteName = null;
        Dbserver.ColumnAttr.Builder builder = null;
        try {
            tableProp = mfs.getTableProperties(new Path(tablePath));
            isJson = tableProp.getAttr().getJson();
            colName = isJson && !cfName.equals("default") ? MapRFsUtil.getPrefixedColName((String)this.getParamTextValue(COLNAME_PARAM_NAME, 0)) : this.getParamTextValue(COLNAME_PARAM_NAME, 0);
            colByteName = ByteString.copyFromUtf8((String)colName);
            builder = Dbserver.ColumnAttr.newBuilder();
            Dbserver.ColumnFamilyAttr cfAttr = DbCfColCommands.getColumnFamily(tablePath, cfName);
            int pos = this.findColumnPos(colByteName, cfAttr.getColumnAttrList());
            if (pos == -1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Column " + colName + " not found in " + cfName + " ColumnFamily under Table " + tablePath));
                return;
            }
            builder = cfAttr.getColumnAttr(pos).toBuilder();
            builder.clearAces();
            cfAttr = cfAttr.toBuilder().setColumnAttr(pos, builder.build()).clearAces().clearSchFamily().clearJsonFamilyPath().build();
            this.modifyColumnSettings(tablePath, cfName, cfAttr, out);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
    }

    private void getCol(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        block9: {
            final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
            TableProperties tableProp = null;
            boolean isJson = false;
            final ArrayList tablePropList = new ArrayList();
            try {
                new FileclientRun(this.getUserLoginId()){

                    @Override
                    public void runAsProxyUser() throws IOException, CLIProcessingException {
                        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(DbCfColCommands.this.getUserLoginId());
                        try {
                            TableProperties tProp = null;
                            tProp = mfs.getTableProperties(new Path(tablePath));
                            tablePropList.add(tProp);
                            manager.moveToTop(tablePath);
                        }
                        catch (IOException e) {
                            manager.deleteIfNotExist(tablePath, mfs);
                            throw e;
                        }
                    }
                };
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                return;
            }
            tableProp = (TableProperties)tablePropList.get(0);
            try {
                ByteString colName = null;
                isJson = tableProp.getAttr().getJson();
                Dbserver.ColumnFamilyAttr cfAttr = DbCfColCommands.getColumnFamily(tablePath, cfName);
                Dbserver.SchemaFamily cf = cfAttr.getSchFamily();
                if (cf != null) {
                    boolean cfPrefix;
                    boolean bl = cfPrefix = isJson && !cfName.equals("default");
                    if (this.isParamPresent(COLNAME_PARAM_NAME)) {
                        String colNameStr = this.getParamTextValue(COLNAME_PARAM_NAME, 0);
                        colName = cfPrefix ? ByteString.copyFromUtf8((String)MapRFsUtil.getPrefixedColName((String)colNameStr)) : ByteString.copyFromUtf8((String)colNameStr);
                    }
                    for (int i = 0; i < cfAttr.getColumnAttrCount(); ++i) {
                        Dbserver.ColumnAttr col = cfAttr.getColumnAttr(i);
                        if (colName != null && !colName.equals((Object)col.getQualifier())) continue;
                        CommandOutput.OutputHierarchy.OutputNode colNode = new CommandOutput.OutputHierarchy.OutputNode();
                        String postFixCF = cfPrefix ? MapRFsUtil.getUnPrefixedColName((String)col.getQualifier().toStringUtf8()) : col.getQualifier().toStringUtf8();
                        colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(COLNAME_PARAM_NAME), (Object)postFixCF));
                        for (Dbserver.AccessControlExpression ace : col.getAcesList()) {
                            colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName((String)AceHelper.colPermissionMap.get(ace.getAccessType())), (Object)AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8())));
                        }
                        out.addNode(colNode);
                    }
                    break block9;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                return;
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
        }
    }

    private void modifyColumnSettings(final String tablePath, final String cfName, final Dbserver.ColumnFamilyAttr cfAttr, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (cfAttr != null) {
            try {
                new FileclientRun(this.getUserLoginId()){

                    @Override
                    public void runAsProxyUser() throws IOException, CLIProcessingException {
                        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(DbCfColCommands.this.getUserLoginId());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Attempting to modify column settings -> Path: " + tablePath + ", CfName: " + cfName));
                        }
                        try {
                            mfs.modifyColumnFamily(new Path(tablePath), cfName, cfAttr);
                            manager.moveToTop(tablePath);
                        }
                        catch (IOException e) {
                            manager.deleteIfNotExist(tablePath, mfs);
                            throw e;
                        }
                    }
                };
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            }
        }
    }

    private int findColumnPos(ByteString colName, List<Dbserver.ColumnAttr> colPerm) {
        int i = 0;
        if (colPerm != null) {
            for (Dbserver.ColumnAttr cp : colPerm) {
                if (cp.getQualifier().equals((Object)colName)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private static Dbserver.ColumnFamilyAttr getColumnFamily(String tablePath, String cfName) throws IOException, CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for column family " + cfName));
        }
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        for (Dbserver.ColumnFamilyAttr cf : mfs.listColumnFamily(new Path(tablePath), true)) {
            if (!cf.getSchFamily().getName().equals(cfName)) continue;
            return cf;
        }
        return null;
    }

    private String getOutputFieldName(String verboseName) throws CLIProcessingException {
        return "terse".equals(this.getParamTextValue(OUTPUT_PARAM_NAME, 0)) ? verboseToTerseMap.get(verboseName) : verboseName;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key)) {
                ret = this.getParamTextValue(key, 0);
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

