/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.baseutils.URLProbingUtility;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.proto.Common;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ServiceLinkCommand
extends CLIBaseClass
implements CLIInterface {
    public static final String RUN_CHECK = "validate";
    public static final String SERVICE_NAME = "name";
    private static final Logger LOG = Logger.getLogger(ServiceLinkCommand.class);
    public static final CLICommand serviceLinkCommand = new CLICommand("urls", "getting service webserver link", ServiceLinkCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).put((Object)"name", (Object)new TextInputParameter("name", "name of the service link is required for", true, null)).put((Object)"validate", (Object)new BooleanInputParameter("validate", "Validate if URL is reachable or not", false, (Object)1)).build(), null).setShortUsage("getting service webserver link");

    public ServiceLinkCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String serviceName = this.getParamTextValue(SERVICE_NAME, 0);
        String clusterName = null;
        String zkConnectString = null;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(out);
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
        }
        if (this.isParamPresent("zkconnect")) {
            zkConnectString = this.getParamTextValue("zkconnect", 0);
        }
        boolean runcheck = this.getParamBooleanValue(RUN_CHECK, 0);
        String url = ServiceLinkCommand.getUrl(out, serviceName, clusterName, zkConnectString, runcheck);
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("url", (Object)url));
        out.addNode(node);
        return co;
    }

    public static String getUrl(CommandOutput.OutputHierarchy out, String serviceName, String clusterName, String providedZkConnectString, Boolean runCheck) throws CLIProcessingException {
        String zkConnectString = null;
        zkConnectString = clusterName != null ? CLDBRpcCommonUtils.getInstance().getZkConnect(clusterName) : CLDBRpcCommonUtils.getInstance().getZkConnect();
        if ((zkConnectString == null || zkConnectString.trim().isEmpty()) && providedZkConnectString != null) {
            zkConnectString = providedZkConnectString;
        }
        if (zkConnectString == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "ZK Connect string is null. Check if ZK Connect string was provided correctly"));
            return null;
        }
        Map<String, Properties> nodesProps = NodesCommonUtils.getServiceNodesProperties(zkConnectString, serviceName);
        if (nodesProps == null) {
            String msg = "No service found with name: " + serviceName;
            LOG.error((Object)msg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, msg));
            return null;
        }
        Common.ServiceData hostInfo = NodesCommonUtils.getServiceMasterData(zkConnectString, serviceName);
        if (hostInfo == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Service: " + serviceName + " is not running"));
            return null;
        }
        if (!hostInfo.hasHost()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Service: " + serviceName + " has invalid node information: " + hostInfo.getHost()));
            return null;
        }
        String url = null;
        url = serviceName.equals("resourcemanager") ? BaseUtilsHelper.getUrlScheme() + MapRCliUtil.getRealRMWebAddress(zkConnectString, hostInfo) : ServiceLinkCommand.createURL(hostInfo.getHost(), serviceName, nodesProps.get(hostInfo.getHost()));
        if (url == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Service: " + serviceName + " does not have URL credentials defined"));
            return null;
        }
        if (runCheck.booleanValue()) {
            try {
                if (URLProbingUtility.isURLReachable((String)url)) {
                    return url;
                }
                Map<String, List<String>> serviceToNodeMap = NodesCommonUtils.serviceToNodesMap(zkConnectString);
                List<String> nodes = serviceToNodeMap.get(serviceName);
                for (String znode : nodes) {
                    String nodeUrl = ServiceLinkCommand.createURL(znode, serviceName, nodesProps.get(znode));
                    if (nodeUrl == null || !URLProbingUtility.isURLReachable((String)nodeUrl)) continue;
                    return nodeUrl;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Service: " + serviceName + " does not have reachable URL"));
                return null;
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Service: " + serviceName + " does not have reachable URL"));
                return null;
            }
        }
        if (serviceName.equals("nodemanager")) {
            return null;
        }
        return url;
    }

    private static String createURL(String hostName, String serviceName, Properties nodeProps) {
        StringBuilder returnURL = new StringBuilder();
        String uiPortProperty = BaseUtilsHelper.getUIPortProperty();
        returnURL.append(BaseUtilsHelper.getUrlScheme());
        returnURL.append(hostName);
        returnURL.append(":");
        try {
            ServicesEnum serviceEnum = ServicesEnum.valueOf(serviceName);
            if (serviceEnum.getPort() == null || serviceEnum.getWebLink() == null) {
                return null;
            }
            returnURL.append(serviceEnum.getPort());
            returnURL.append(serviceEnum.getWebLink());
            return returnURL.toString();
        }
        catch (IllegalArgumentException ex) {
            if (nodeProps != null) {
                String uri = nodeProps.getProperty("service.uri");
                String uiPort = nodeProps.getProperty(uiPortProperty);
                if (uiPort == null) {
                    uiPort = nodeProps.getProperty(BaseUtilsHelper.getStandardUiPortProperty());
                }
                if (uri != null) {
                    if (uiPort != null) {
                        returnURL.append(uiPort);
                    }
                    if (!uri.startsWith("/")) {
                        returnURL.append("/");
                    }
                    returnURL.append(uri);
                    return returnURL.toString();
                }
            }
            return null;
        }
    }
}

