/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.ClusterAccessController;
import com.mapr.fs.cldb.ClusterAceProcessor;
import com.mapr.fs.cldb.PermissionsManager;
import com.mapr.fs.cldb.VolumeAccessController;
import com.mapr.fs.cldb.VolumeAceProcessor;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.security.ACL;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AclCommands
extends CLIBaseClass
implements CLIInterface {
    static final String OBJECT_PARAM_NAME = "name";
    static final String UID_PARAM_NAME = "user";
    static final String GID_PARAM_NAME = "group";
    static final String OUTPUT_PARAM_NAME = "output";
    static final String OBJECT_TYPE_PARAM_NAME = "type";
    static final String PERM_PARAM_NAME = "perm";
    static final String SHOW_ADMIN_PARAM_NAME = "showadmin";
    private static final Logger LOG = Logger.getLogger(AclCommands.class);
    static PermissionsManager procPermsManager = PermissionsManager.getInstance();
    static final Map<String, BaseInputParameter> params = new ImmutableMap.Builder().put((Object)"type", (Object)new TextInputParameter("type", "object type [cluster|volume]", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "name", false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    static final CLICommand showAclCommand = new CLICommand("show", "display ACL for an object", AclCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"user", (Object)new TextInputParameter("user", "userName whose ACL is queried", false, null)).put((Object)"group", (Object)new TextInputParameter("group", "groupName whose ACL is queried", false, null)).put((Object)"output", (Object)new TextInputParameter("output", "output format short|long|terse (default short)", false, "short")).put((Object)"perm", (Object)new NoValueInputParameter("perm", "list of available permissions", false, false)).put((Object)"showadmin", (Object)new BooleanInputParameter("showadmin", "show cluster admin", false, Boolean.valueOf(false)).setInvisible(true)).build(), null).setShortUsage("show -type cluster|volume -perm -name <volume name> -user <userName> -group <groupName> -output <format>");
    static final CLICommand showUserPermissionsCommand = new CLICommand("userperms", "display ACL for an object", AclCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"type", (Object)new TextInputParameter("type", "object type [cluster|volume]", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "name", false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"user", (Object)new TextInputParameter("user", "userName whose permissions are queried", true, null)).build(), null).setShortUsage("userperms -type cluster|volume -name <comma seperated volume names> -user <userName>");
    static final CLICommand setAclCommand = new CLICommand("set", "set ACL for an object", AclCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"user", (Object)new TextInputParameter("user", "space separated list of user:permissions,perimssions,.. to be set", false, null)).put((Object)"group", (Object)new TextInputParameter("group", "space separated list of group:permissions,permissions,... to be set", false, null)).build(), null).setShortUsage("set -type cluster|volume -name <volume name> -user {userName:permissions}+ -group {groupName:permissions}+");
    static final CLICommand editAclCommand = new CLICommand("edit", "edit ACL for an object", AclCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"user", (Object)new TextInputParameter("user", "space separated list of user:permissions,perimssions,.. to be changed", false, null)).put((Object)"group", (Object)new TextInputParameter("group", "space separated list of group:permissions,permissions,... to be changed", false, null)).build(), null).setShortUsage("edit -type cluster|volume -name <volume name> -user {userName:permissions}+ -group {groupName:permissions}+");
    static final CLICommand[] aclSubCommands = new CLICommand[]{showAclCommand, showUserPermissionsCommand, setAclCommand, editAclCommand};
    static final String usageStr = "acl [show|set|edit] -type [cluster|volume] -name <volume name>";
    public static final CLICommand aclCommands = new CLICommand("acl", "usage: acl [show|set|edit] -type [cluster|volume] -name <volume name>", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, aclSubCommands).setShortUsage("acl [show|set|edit] -type [cluster|volume] -name <volume name>");
    UnixUserGroupHelper userInfo;
    static String MULTI_ARG_SEP = ",";
    static String ALLOW_MASK_SEP = ":";

    public AclCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public static CommandOutput.OutputHierarchy formatAcl(Security.AccessControlList acl, CLDBProto.SecureObjectType objType, String outputFormat, UnixUserGroupHelper uInfo, List<Integer> unknownUids, List<Integer> unknownGids) {
        return AclCommands.formatAcl(acl, objType, outputFormat, uInfo, unknownUids, unknownGids, -1);
    }

    private static CommandOutput.OutputHierarchy formatAcl(Security.AccessControlList acl, CLDBProto.SecureObjectType objType, String outputFormat, UnixUserGroupHelper uInfo, List<Integer> unknownUids, List<Integer> unknownGids, int clusterOwner) {
        ArrayList<CommandOutput.OutputHierarchy.OutputNode> result = new ArrayList<CommandOutput.OutputHierarchy.OutputNode>();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        if (objType != CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER) {
            clusterOwner = -1;
        }
        for (Security.AclEntry aclEntry : acl.getAclList()) {
            String ugName;
            int princId;
            boolean isClusterOwner;
            boolean addAcl;
            CommandOutput.OutputHierarchy.OutputNode aclDesc;
            block22: {
                aclDesc = new CommandOutput.OutputHierarchy.OutputNode();
                addAcl = false;
                isClusterOwner = false;
                princId = aclEntry.getPrincipal().getPrincId();
                if (ACL.allUsers((int)princId)) {
                    ugName = "All users";
                } else {
                    if (ACL.isUid((int)princId)) {
                        if (clusterOwner != -1) {
                            isClusterOwner = princId == clusterOwner;
                        }
                        String userName = "";
                        try {
                            userName = uInfo.getUsername(princId);
                            ugName = "User " + userName;
                        }
                        catch (SecurityException se) {
                            ugName = "Uid " + princId;
                            if (unknownUids != null) {
                                unknownUids.add(princId);
                            }
                            break block22;
                        }
                    }
                    String groupName = "";
                    try {
                        groupName = uInfo.getGroupname(ACL.getGid((int)princId));
                        ugName = "Group " + groupName;
                    }
                    catch (SecurityException se) {
                        int gid = ACL.getGid((int)princId);
                        ugName = "Gid " + gid;
                        if (unknownGids == null) break block22;
                        unknownGids.add(gid);
                    }
                }
            }
            if (outputFormat.equalsIgnoreCase("terse")) {
                if (ACL.allUsers((int)princId)) {
                    ugName = "User allusers";
                }
                if (aclEntry.hasAllow()) {
                    addAcl = true;
                    aclDesc.addNode(new CommandOutput.OutputHierarchy.OutputNode(ugName, (Object)SecurityCommandHelper.formatActionMask((int)aclEntry.getAllow(), (CLDBProto.SecureObjectType)objType, (boolean)true)));
                }
            } else {
                List privs;
                int allowMask = 0;
                int denyMask = 0;
                boolean shortFormat = outputFormat.equalsIgnoreCase("short");
                if (aclEntry.hasAllow()) {
                    allowMask = aclEntry.getAllow();
                }
                if (aclEntry.hasDeny()) {
                    denyMask = aclEntry.getDeny();
                }
                if (allowMask != 0 || denyMask != 0) {
                    addAcl = true;
                    aclDesc.addNode(new CommandOutput.OutputHierarchy.OutputNode("Principal", (Object)ugName));
                }
                if (allowMask != 0) {
                    privs = SecurityCommandHelper.formatActionMask((int)allowMask, (CLDBProto.SecureObjectType)objType, (boolean)shortFormat);
                    addAcl = true;
                    aclDesc.addNode(new CommandOutput.OutputHierarchy.OutputNode("Allowed actions", (Object)privs));
                }
                if (denyMask != 0) {
                    privs = SecurityCommandHelper.formatActionMask((int)denyMask, (CLDBProto.SecureObjectType)objType, (boolean)shortFormat);
                    addAcl = true;
                    aclDesc.addNode(new CommandOutput.OutputHierarchy.OutputNode("Denied actions", (Object)privs));
                }
            }
            if (!addAcl) continue;
            if (isClusterOwner) {
                aclDesc.addNode(new CommandOutput.OutputHierarchy.OutputNode("ClusterAdmin", (Object)true));
            }
            result.add(aclDesc);
        }
        for (CommandOutput.OutputHierarchy.OutputNode a : result) {
            oh.addNode(a);
        }
        return oh;
    }

    private CommandOutput.OutputHierarchy formatResponse(CLDBProto.PermissionsQueryResponse queryResp, CommandOutput.OutputHierarchy oh) {
        List respEntities = queryResp.getPermEntityList();
        CLDBProto.ClusterConfiguration clusterConfig = queryResp.getConfig();
        CommandOutput.OutputHierarchy.OutputNode outerWrapper = new CommandOutput.OutputHierarchy.OutputNode();
        oh.addNode(outerWrapper);
        CommandOutput.OutputHierarchy.OutputNode clusterOut = new CommandOutput.OutputHierarchy.OutputNode("ClusterProperties");
        CommandOutput.OutputHierarchy.OutputNode licOut = new CommandOutput.OutputHierarchy.OutputNode("Licenses");
        this.formatLicenseInfo(queryResp.getLicense(), licOut);
        clusterOut.addNode(licOut);
        outerWrapper.addNode(clusterOut);
        CommandOutput.OutputHierarchy.OutputNode userGrpOut = new CommandOutput.OutputHierarchy.OutputNode("UserProperties");
        for (CLDBProto.UserInfo userInfo : queryResp.getUserInfoList()) {
            CommandOutput.OutputHierarchy.OutputNode userNameOut = new CommandOutput.OutputHierarchy.OutputNode(userInfo.getName());
            this.formatUserInfo(userInfo, respEntities, clusterConfig, userNameOut);
            userGrpOut.addNode(userNameOut);
        }
        outerWrapper.addNode(userGrpOut);
        return oh;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatLicenseInfo(CLDBProto.LicensesAvailable licInfo, CommandOutput.OutputHierarchy.OutputNode out) {
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("CreateMirror", (Object)licInfo.getCreateMirror()));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("DataPlacement", (Object)licInfo.getDataPlacement()));
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatUserInfo(CLDBProto.UserInfo userInfo, List<CLDBProto.PermRespEntity> respEntities, CLDBProto.ClusterConfiguration clusterConfig, CommandOutput.OutputHierarchy.OutputNode userInfoOut) {
        Security.CredentialsMsg userCreds = userInfo.getCreds();
        this.formatResponseEntities(respEntities, userCreds, userInfoOut);
        return userInfoOut;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatResponseEntities(List<CLDBProto.PermRespEntity> respEntities, Security.CredentialsMsg userCreds, CommandOutput.OutputHierarchy.OutputNode userInfoOut) {
        CommandOutput.OutputHierarchy.OutputNode entityGrp = new CommandOutput.OutputHierarchy.OutputNode("ClusterPerms");
        this.formatUserPermissions(entityGrp, userCreds, null);
        userInfoOut.addNode(entityGrp);
        entityGrp = new CommandOutput.OutputHierarchy.OutputNode("VolumePerms");
        userInfoOut.addNode(entityGrp);
        for (CLDBProto.PermRespEntity permEntity : respEntities) {
            CLDBProto.SecureObjectType entityType = permEntity.getType();
            CLDBProto.VolumeProperties volProp = permEntity.getVolProp();
            CommandOutput.OutputHierarchy.OutputNode entity = new CommandOutput.OutputHierarchy.OutputNode(volProp.getVolumeName());
            entityGrp.addNode(entity);
            this.formatUserPermissions(entity, userCreds, volProp);
        }
        return userInfoOut;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatUserPermissions(CommandOutput.OutputHierarchy.OutputNode out, Security.CredentialsMsg userCreds, CLDBProto.VolumeProperties volProp) {
        List permList = procPermsManager.getUserPermissions(userCreds, volProp);
        LOG.error((Object)" ");
        for (PermissionsManager.ActionPermission perm : permList) {
            out.addNode(this.formatActionPermission(perm));
        }
        return out;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatActionPermission(PermissionsManager.ActionPermission aPerm) {
        return new CommandOutput.OutputHierarchy.OutputNode(aPerm.action, (Object)(aPerm.allow ? "1" : "0"));
    }

    String getHostName() {
        String hostname = MapRCliUtil.getHostname();
        if (hostname != null) {
            return hostname;
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hostname;
    }

    String formatList(List<Integer> list) {
        if (list.size() == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean needsComma = false;
        for (int id : list) {
            if (needsComma) {
                result.append(", ");
                result.append(id);
                continue;
            }
            result.append(id);
            needsComma = true;
        }
        return result.toString();
    }

    CommandOutput showAcl() throws CLIProcessingException {
        CLDBProto.SecureObjectType objType;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        String objectType = this.getParamTextValue(OBJECT_TYPE_PARAM_NAME, 0);
        if (objectType.equalsIgnoreCase("cluster")) {
            objType = CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER;
        } else if (objectType.equalsIgnoreCase("volume")) {
            objType = CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME;
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl show failed with invalid object type " + objectType + ". Valid object types are cluster|volume.").setField(OBJECT_TYPE_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        if (this.isParamPresent(PERM_PARAM_NAME)) {
            CommandOutput.OutputHierarchy.OutputNode node;
            int i;
            String[] headers = new String[]{"Permissions", "Description"};
            output.setNodeOrder(headers);
            ArrayList<CommandOutput.OutputHierarchy.OutputNode> results = new ArrayList<CommandOutput.OutputHierarchy.OutputNode>();
            if (objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER) {
                for (i = 0; i < SecurityCommandHelper.clusterActionsDescription.length - 1; i += 2) {
                    node = new CommandOutput.OutputHierarchy.OutputNode();
                    if (SecurityCommandHelper.clusterActionsDescription[i] == null || SecurityCommandHelper.clusterActionsDescription[i + 1] == null) continue;
                    node.addNode(new CommandOutput.OutputHierarchy.OutputNode("Permissions", (Object)SecurityCommandHelper.clusterActionsDescription[i]));
                    node.addNode(new CommandOutput.OutputHierarchy.OutputNode("Description", (Object)SecurityCommandHelper.clusterActionsDescription[i + 1]));
                    results.add(node);
                }
            } else if (objType == CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME) {
                for (i = 0; i < SecurityCommandHelper.volumeActionsDescription.length - 1; i += 2) {
                    node = new CommandOutput.OutputHierarchy.OutputNode();
                    if (SecurityCommandHelper.volumeActionsDescription[i] == null || SecurityCommandHelper.volumeActionsDescription[i + 1] == null) continue;
                    node.addNode(new CommandOutput.OutputHierarchy.OutputNode("Permissions", (Object)SecurityCommandHelper.volumeActionsDescription[i]));
                    node.addNode(new CommandOutput.OutputHierarchy.OutputNode("Description", (Object)SecurityCommandHelper.volumeActionsDescription[i + 1]));
                    results.add(node);
                }
            }
            for (CommandOutput.OutputHierarchy.OutputNode a : results) {
                out.addNode(a);
            }
            output.setOutput(out);
            return output;
        }
        String name = null;
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            name = this.getParamTextValue(OBJECT_PARAM_NAME, 0);
        }
        if (name == null && objType == CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl show requires the name of the volume").setField(OBJECT_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        if (name != null && objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl show for a cluster does not require a name").setField(OBJECT_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        boolean isUserPresent = false;
        int princId = 0;
        if (this.isParamPresent(UID_PARAM_NAME)) {
            isUserPresent = true;
            String userName = this.getParamTextValue(UID_PARAM_NAME, 0);
            if (userName.equalsIgnoreCase("allUsers")) {
                princId = -1;
            } else {
                try {
                    princId = this.userInfo.getUserId(userName);
                }
                catch (SecurityException se) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(135, Errno.toString((int)135) + ":" + userName).setField(OBJECT_PARAM_NAME));
                    output.setOutput(out);
                    return output;
                }
            }
        }
        boolean isGroupPresent = false;
        int gid = 0;
        if (this.isParamPresent(GID_PARAM_NAME)) {
            isGroupPresent = true;
            String groupName = this.getParamTextValue(GID_PARAM_NAME, 0);
            try {
                gid = this.userInfo.getGroupId(groupName);
            }
            catch (SecurityException se) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(135, Errno.toString((int)135) + ":" + groupName).setField(OBJECT_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            princId = Integer.MIN_VALUE | gid;
        }
        if (isUserPresent && isGroupPresent) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl show does not accept both userName and groupName simultaneously").setField(UID_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        String outputFormat = "short";
        if (this.isParamPresent(OUTPUT_PARAM_NAME)) {
            outputFormat = this.getParamTextValue(OUTPUT_PARAM_NAME, 0);
        }
        if (!(outputFormat.equalsIgnoreCase("short") || outputFormat.equalsIgnoreCase("long") || outputFormat.equalsIgnoreCase("terse"))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Invalid output format " + outputFormat + " expecting short|long|terse").setField(OUTPUT_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        boolean showClusterAdmin = this.getParamBooleanValue(SHOW_ADMIN_PARAM_NAME, 0);
        Security.AccessControlList acl = null;
        int clusterAdmin = -1;
        try {
            CLDBProto.SecurityGetAclRequest.Builder getAclBuilder = CLDBProto.SecurityGetAclRequest.newBuilder();
            Security.CredentialsMsg creds = this.getUserCredentials();
            getAclBuilder.setObjectType(objType);
            if (name != null) {
                getAclBuilder.setName(name);
            }
            if (isUserPresent || isGroupPresent) {
                Security.SecurityPrincipal.Builder sb = Security.SecurityPrincipal.newBuilder();
                sb.setPrincId(princId);
                getAclBuilder.setPrincipal(sb.build());
            }
            getAclBuilder.setCreds(creds);
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SecurityGetAclProc.getNumber(), (MessageLite)getAclBuilder.build(), CLDBProto.SecurityGetAclResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SecurityGetAclProc.getNumber(), (MessageLite)getAclBuilder.build(), CLDBProto.SecurityGetAclResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.SecurityGetAclResponse aclResp = CLDBProto.SecurityGetAclResponse.parseFrom((byte[])data);
            int status = aclResp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ACL lookup Failure: " + aclResp.getErrorString()).setField(OBJECT_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            acl = aclResp.getAcl();
            if (showClusterAdmin && aclResp.hasClusterAdmin()) {
                clusterAdmin = aclResp.getClusterAdmin();
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to get ACL"));
            output.setOutput(out);
            return output;
        }
        ArrayList<Integer> unknownUids = new ArrayList<Integer>();
        ArrayList<Integer> unknownGids = new ArrayList<Integer>();
        CommandOutput.OutputHierarchy outAcl = AclCommands.formatAcl(acl, objType, outputFormat, this.userInfo, unknownUids, unknownGids, clusterAdmin);
        for (CommandOutput.OutputHierarchy.OutputError e : outAcl.getOutputErrors()) {
            LOG.info((Object)("Error in output:" + e.toString()));
            out.addError(e);
        }
        for (CommandOutput.OutputHierarchy.OutputNode a : outAcl.getOutputNodes()) {
            LOG.info((Object)("Output Node:" + a.toJSONString()));
            out.addNode(a);
        }
        if (unknownGids.size() > 0 || unknownUids.size() > 0) {
            String hostname;
            String missingUids = "";
            if (unknownUids.size() > 0) {
                missingUids = "uid(s) (" + this.formatList(unknownUids) + ")";
            }
            String missingGids = "";
            if (unknownGids.size() > 0) {
                if (unknownUids.size() > 0) {
                    missingGids = " and ";
                }
                missingGids = missingGids + "gid(s) (" + this.formatList(unknownGids) + ")";
            }
            if ((hostname = this.getHostName()) == null) {
                hostname = "localhost";
            }
            String warnMsg = "Warning: The " + missingUids + missingGids + " used on the cluster do not have an appropriate account on " + hostname + ". This indicates a possible mis-configuration on " + hostname + ". Please check with your cluster administrator";
            out.addMessage(warnMsg);
        }
        output.setOutput(out);
        return output;
    }

    CommandOutput getPermissions() throws CLIProcessingException {
        CLDBProto.SecureObjectType objType;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        String objectType = this.getParamTextValue(OBJECT_TYPE_PARAM_NAME, 0);
        if (objectType.equalsIgnoreCase("cluster")) {
            objType = CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER;
        } else if (objectType.equalsIgnoreCase("volume")) {
            objType = CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME;
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "User permission query failed with invalid object type " + objectType + ". Valid object types are cluster|volume.").setField(OBJECT_TYPE_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        String volNames = null;
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            volNames = this.getParamTextValue(OBJECT_PARAM_NAME, 0);
        }
        if (volNames == null) {
            if (objType == CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "User permission for volume requires volume name(s).").setField(OBJECT_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
        } else if (objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "User permission for a cluster does not require a name").setField(OBJECT_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        String userNames = this.getParamTextValue(UID_PARAM_NAME, 0);
        List<String> userList = new ArrayList<String>();
        if (userNames.contains(MULTI_ARG_SEP)) {
            userList = Arrays.asList(userNames.split(MULTI_ARG_SEP));
        } else {
            userList.add(userNames);
        }
        CLDBProto.PermissionsQueryResponse queryResp = null;
        try {
            Security.CredentialsMsg creds = this.getUserCredentials();
            CLDBProto.PermissionsQueryRequest.Builder reqBuilder = CLDBProto.PermissionsQueryRequest.newBuilder().setCreds(creds).addAllUserNames(userList);
            if (objType == CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME) {
                ArrayList<String> namesList = new ArrayList<String>();
                if (volNames.contains(MULTI_ARG_SEP)) {
                    namesList.addAll(Arrays.asList(volNames.split(MULTI_ARG_SEP)));
                } else {
                    namesList.add(volNames);
                }
                for (String s : namesList) {
                    CLDBProto.PermEntity qe = CLDBProto.PermEntity.newBuilder().setType(objType).setName(s).build();
                    reqBuilder.addEntities(qe);
                }
            } else {
                CLDBProto.PermEntity qe = CLDBProto.PermEntity.newBuilder().setType(objType).build();
                reqBuilder.addEntities(qe);
            }
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.UserPermissionsQueryProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.PermissionsQueryResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.UserPermissionsQueryProc.getNumber(), (MessageLite)reqBuilder.build(), CLDBProto.PermissionsQueryResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            queryResp = CLDBProto.PermissionsQueryResponse.parseFrom((byte[])data);
            int status = queryResp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "User permission lookup Failure: " + queryResp.getErrorString()).setField(OBJECT_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            CLDBProto.ClusterConfiguration clusterConfig = queryResp.getConfig();
            boolean rejectRoot = clusterConfig.getRejectRoot();
            boolean squashRoot = clusterConfig.getSquashRoot();
            int clusterOwnerUid = clusterConfig.getClusterOwnerUid();
            CLDBProto.ClusterProperties props = clusterConfig.getProps();
            procPermsManager.initializeInstance(null, clusterOwnerUid, rejectRoot, squashRoot, props);
            if (clusterConfig.getClusterAceSupported()) {
                procPermsManager.setClusterAccessController((ClusterAccessController)new ClusterAceProcessor(null));
            }
            if (clusterConfig.getVolumeAceSupported()) {
                procPermsManager.setVolumeAccessController((VolumeAccessController)new VolumeAceProcessor());
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to get volume properties"));
            output.setOutput(out);
            return output;
        }
        this.formatResponse(queryResp, out);
        output.setOutput(out);
        return output;
    }

    static List<Security.AclEntry> getAclElements(String perms, UnixUserGroupHelper uInfo, boolean isUser) {
        ArrayList<String> permList = new ArrayList<String>();
        if (perms.contains(MULTI_ARG_SEP)) {
            permList.addAll(Arrays.asList(perms.split(MULTI_ARG_SEP)));
        } else {
            permList.add(perms);
        }
        ArrayList<Security.AclEntry> result = new ArrayList<Security.AclEntry>();
        for (String s : permList) {
            if (!s.contains(ALLOW_MASK_SEP)) {
                return null;
            }
            ArrayList<String> userPerm = new ArrayList<String>();
            userPerm.addAll(Arrays.asList(s.split(ALLOW_MASK_SEP)));
            if (userPerm.size() > 2) {
                return null;
            }
            String principal = (String)userPerm.get(0);
            int principalId = 0;
            if (principal.equalsIgnoreCase("allUsers")) {
                principalId = -1;
            } else if (isUser) {
                principalId = uInfo.getUserId(principal);
            } else {
                principalId = uInfo.getGroupId(principal);
                principalId = Integer.MIN_VALUE | principalId;
            }
            String allowMaskStr = (String)userPerm.get(1);
            int allowMask = Integer.decode(allowMaskStr);
            Security.AclEntry.Builder entry = Security.AclEntry.newBuilder().setDeny(0).setAllow(allowMask);
            entry.setPrincipal(Security.SecurityPrincipal.newBuilder().setPrincId(principalId));
            result.add(entry.build());
        }
        return result;
    }

    private static int convertToId(String principal, UnixUserGroupHelper uInfo, boolean isUser) {
        int principalId = 0;
        if (principal.equalsIgnoreCase("allUsers")) {
            principalId = -1;
        } else if (isUser) {
            principalId = uInfo.getUserId(principal);
        } else {
            principalId = uInfo.getGroupId(principal);
            principalId = Integer.MIN_VALUE | principalId;
        }
        return principalId;
    }

    public static List<Security.AclEntry> actionsToAcls(List<String> perms, UnixUserGroupHelper uInfo, CLDBProto.SecureObjectType objType, boolean isUser, CommandOutput.OutputHierarchy out) {
        ArrayList<Security.AclEntry> result = new ArrayList<Security.AclEntry>();
        ArrayList permissions = new ArrayList();
        for (String perm : perms) {
            Collections.addAll(permissions, perm.split(" "));
        }
        for (String perm : permissions) {
            int allowMask;
            int principalId;
            List<String> userPerm = Arrays.asList(perm.split(ALLOW_MASK_SEP));
            String principal = userPerm.get(0);
            try {
                principalId = AclCommands.convertToId(principal, uInfo, isUser);
            }
            catch (SecurityException se) {
                try {
                    principalId = Integer.parseInt(principal);
                    if (!isUser) {
                        principalId = Integer.MIN_VALUE | principalId;
                    }
                }
                catch (NumberFormatException ne) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(135, "Error for user " + principal + ":" + Errno.toString((int)135)).setField(OBJECT_PARAM_NAME));
                    return null;
                }
            }
            if (userPerm.size() == 1) {
                allowMask = 0;
            } else {
                try {
                    String actions = userPerm.get(1);
                    allowMask = SecurityCommandHelper.convertActionsToMask((String)actions, (String)MULTI_ARG_SEP, (CLDBProto.SecureObjectType)objType);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage());
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error for user " + principal + ":" + e.getMessage()).setField(OBJECT_PARAM_NAME));
                    return null;
                }
            }
            Security.AclEntry.Builder entry = Security.AclEntry.newBuilder().setAllow(allowMask);
            entry.setPrincipal(Security.SecurityPrincipal.newBuilder().setPrincId(principalId));
            result.add(entry.build());
        }
        return result;
    }

    CommandOutput setAcl() throws CLIProcessingException {
        List<Security.AclEntry> elements;
        List values;
        ProcessedInput.Parameter param;
        CLDBProto.SecureObjectType objType;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CLDBProto.SecurityModifyAclRequest.Builder aclRequestBuilder = CLDBProto.SecurityModifyAclRequest.newBuilder();
        String objectType = this.getParamTextValue(OBJECT_TYPE_PARAM_NAME, 0);
        if (objectType.equalsIgnoreCase("cluster")) {
            objType = CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER;
        } else if (objectType.equalsIgnoreCase("volume")) {
            objType = CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME;
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl set failed with invalid object type " + objectType + ". Valid object types are cluster|volume.").setField(OBJECT_TYPE_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
        boolean principalPresent = false;
        if (this.isParamPresent(UID_PARAM_NAME)) {
            principalPresent = true;
            param = this.input.getParameterByName(UID_PARAM_NAME);
            values = param.getParamValues();
            elements = AclCommands.actionsToAcls(values, this.userInfo, objType, true, out);
            if (elements == null) {
                String validPerms = objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER ? "[login, ss, cv, a, fc]" : "[dump, restore, m, d, a, fc]";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl set failed - invalid list of user permissions, valid permissions are: " + validPerms).setField(UID_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (this.isParamPresent(GID_PARAM_NAME)) {
            principalPresent = true;
            param = this.input.getParameterByName(GID_PARAM_NAME);
            values = param.getParamValues();
            elements = AclCommands.actionsToAcls(values, this.userInfo, objType, false, out);
            if (elements == null) {
                String validPerms = objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER ? "[login, ss, cv, a, fc]" : "[dump, restore, m, d, a, fc]";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl set failed - invalid list of group permissions, valid permissions are: " + validPerms).setField(GID_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        String name = null;
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            name = this.getParamTextValue(OBJECT_PARAM_NAME, 0);
        }
        if (name == null && objType == CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl set failed - volume name missing").setField(OBJECT_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        if (name != null && objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl set for a cluster does not require a name").setField(OBJECT_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        try {
            Security.CredentialsMsg creds = this.getUserCredentials();
            aclRequestBuilder.setObjectType(objType);
            if (name != null) {
                aclRequestBuilder.setName(name);
            }
            aclRequestBuilder.setAcl(aclBuilder);
            aclRequestBuilder.setCreds(creds);
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SecurityModifyAclProc.getNumber(), (MessageLite)aclRequestBuilder.build(), CLDBProto.SecurityModifyAclResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SecurityModifyAclProc.getNumber(), (MessageLite)aclRequestBuilder.build(), CLDBProto.SecurityModifyAclResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.SecurityModifyAclResponse resp = CLDBProto.SecurityModifyAclResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ACL modification failed for " + objectType + " failed with error message. " + resp.getErrorString()).setField(OBJECT_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to modify ACL"));
            output.setOutput(out);
            return output;
        }
        output.setOutput(out);
        return output;
    }

    CommandOutput editAcl() throws CLIProcessingException {
        List values;
        ProcessedInput.Parameter param;
        CLDBProto.SecureObjectType objType;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CLDBProto.SecurityModifyAclRequest.Builder aclRequestBuilder = CLDBProto.SecurityModifyAclRequest.newBuilder();
        String objectType = this.getParamTextValue(OBJECT_TYPE_PARAM_NAME, 0);
        if (objectType.equalsIgnoreCase("cluster")) {
            objType = CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER;
        } else if (objectType.equalsIgnoreCase("volume")) {
            objType = CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME;
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl edit failed with invalid object type " + objectType + ". Valid object types are cluster|volume.").setField(OBJECT_TYPE_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
        List<Security.AclEntry> elements = null;
        boolean principalPresent = false;
        if (this.isParamPresent(UID_PARAM_NAME)) {
            principalPresent = true;
            param = this.input.getParameterByName(UID_PARAM_NAME);
            values = param.getParamValues();
            elements = AclCommands.actionsToAcls(values, this.userInfo, objType, true, out);
            if (elements == null) {
                String validPerms = objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER ? "[login, ss, cv, a, fc]" : "[dump, restore, m, d, a, fc]";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl edit failed - invalid list of user permissions, valid permissions are: " + validPerms).setField(UID_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (this.isParamPresent(GID_PARAM_NAME)) {
            principalPresent = true;
            param = this.input.getParameterByName(GID_PARAM_NAME);
            values = param.getParamValues();
            elements = AclCommands.actionsToAcls(values, this.userInfo, objType, false, out);
            if (elements == null) {
                String validPerms = objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER ? "[login, ss, cv, a, fc]" : "[dump, restore, m, d, a, fc]";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl edit failed - invalid list of group permissions, valid permissions are: " + validPerms).setField(GID_PARAM_NAME));
                output.setOutput(out);
                return output;
            }
            aclBuilder.addAllAcl(elements);
        }
        if (!principalPresent) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl edit failed - no user/group specified, use -user/-group option to specify the acls to be changed "));
            output.setOutput(out);
            return output;
        }
        String name = null;
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            name = this.getParamTextValue(OBJECT_PARAM_NAME, 0);
        }
        if (name == null && objType == CLDBProto.SecureObjectType.OBJECT_TYPE_VOLUME) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl edit failed - volume name missing").setField(OBJECT_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        if (name != null && objType == CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Acl edit for a cluster does not require a name").setField(OBJECT_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        try {
            Security.CredentialsMsg creds = this.getUserCredentials();
            aclRequestBuilder.setObjectType(objType);
            if (name != null) {
                aclRequestBuilder.setName(name);
            }
            aclRequestBuilder.setAcl(aclBuilder);
            aclRequestBuilder.setCreds(creds);
            aclRequestBuilder.setEditFlag(true);
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SecurityModifyAclProc.getNumber(), (MessageLite)aclRequestBuilder.build(), CLDBProto.SecurityModifyAclResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SecurityModifyAclProc.getNumber(), (MessageLite)aclRequestBuilder.build(), CLDBProto.SecurityModifyAclResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.SecurityModifyAclResponse resp = CLDBProto.SecurityModifyAclResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                if (resp.hasErrorString()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, resp.getErrorString()));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Unknown error while ACL modification for " + objectType).setField(OBJECT_PARAM_NAME));
                }
                output.setOutput(out);
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to modify ACL"));
            output.setOutput(out);
            return output;
        }
        output.setOutput(out);
        return output;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (!super.validateInput()) {
            CommandOutput output = new CommandOutput();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            return output;
        }
        this.userInfo = new UnixUserGroupHelper();
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase("show")) {
            return this.showAcl();
        }
        if (command.equalsIgnoreCase("userperms")) {
            return this.getPermissions();
        }
        if (command.equalsIgnoreCase("set")) {
            return this.setAcl();
        }
        if (command.equalsIgnoreCase("edit")) {
            return this.editAcl();
        }
        return new TextCommandOutput(("Acl command failed: unknown command " + command + " received.").getBytes());
    }

    public String getCommandUsage() {
        return usageStr;
    }
}

