/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mapr.fs.Nfsmon;

public class NFS4MgmtCommands
extends CLIBaseClass {
    private static final String NFSHostIp = "nfshost";
    private static final String NFSPort = "nfsport";
    private static final String NFSExportId = "exportid";
    private static final String NFSConfFile = "conffile";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"nfshost", (Object)new TextInputParameter("nfshost", "ip/hostname", false, "127.0.0.1")).put((Object)"nfsport", (Object)new IntegerInputParameter("nfsport", "port", false, Integer.valueOf(9995))).build();
    private static final CLICommand addExportsCommand = new CLICommand("add-export", "usage: nfs4mgmt add-export -exportid id -conffile path", NFS4MgmtCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"exportid", (Object)new IntegerInputParameter("exportid", "export id", true, Integer.valueOf(0))).put((Object)"conffile", (Object)new TextInputParameter("conffile", "conf file path", true, null)).build(), null).setShortUsage("nfs4mgmt add-export -exportid id -conffile path");
    private static final CLICommand removeExportsCommand = new CLICommand("remove-export", "usage: nfs4mgmt remove-export -exportid id", NFS4MgmtCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"exportid", (Object)new IntegerInputParameter("exportid", "export id", true, Integer.valueOf(0))).build(), null).setShortUsage("nfs4mgmt remove-export -exportid id");
    private static final CLICommand listExportsCommand = new CLICommand("list-exports", "usage: nfs4mgmt list-exports", NFS4MgmtCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("nfs4mgmt list-exports");
    public static final CLICommand nfs4MgmtCmds = new CLICommand("nfs4mgmt", "usage: nfs4mgmt [add-export|remove-export|list-exports]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{listExportsCommand, addExportsCommand, removeExportsCommand}).setShortUsage("nfs4mgmt [add-export|remove-export|list-exports]");
    private String clusterName = null;

    public NFS4MgmtCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        int port;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        this.clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        try {
            port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new CLIProcessingException("Error in RPC init");
            }
        }
        catch (Exception e) {
            System.out.println("Exception in Rpc.initialize " + e);
            throw new CLIProcessingException("Exception in Rpc.initialize ", (Throwable)e);
        }
        port = this.getParamIntValue(NFSPort, 0);
        String hostName = this.getParamTextValue(NFSHostIp, 0);
        if (!hostName.equalsIgnoreCase("localhost") && !hostName.equalsIgnoreCase("127.0.0.1")) {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(hostName));
            if (ips.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not get valid IP address out of provided name: " + hostName));
                return output;
            }
            hostName = ips.get(0);
        }
        int hostip = Util.ipToInt((String)hostName);
        long binding = Rpc.createBindingFor((int)hostip, (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list-exports")) {
            this.sendExportRequest(Nfsmon.NFSExportRequestType.NFSExportRequestTypeShowAll, out, binding, -1, null);
            return output;
        }
        int exportId = this.getParamIntValue(NFSExportId, 0);
        if (this.cliCommand.getCommandName().equalsIgnoreCase("add-export")) {
            String confFilePath = this.getParamTextValue(NFSConfFile, 0);
            this.sendExportRequest(Nfsmon.NFSExportRequestType.NFSExportRequestTypeAdd, out, binding, exportId, confFilePath);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("remove-export")) {
            this.sendExportRequest(Nfsmon.NFSExportRequestType.NFSExportRequestTypeRemove, out, binding, exportId, null);
        }
        return output;
    }

    private void sendExportRequest(Nfsmon.NFSExportRequestType type, CommandOutput.OutputHierarchy out, long binding, int exportId, String confFilePath) throws CLIProcessingException {
        Nfsmon.NFSExportResponse resp = null;
        Nfsmon.NFSExportRequest.Builder b = Nfsmon.NFSExportRequest.newBuilder();
        b.setReqType(type);
        if (exportId != -1) {
            b.setExportId(exportId);
        }
        if (confFilePath != null) {
            b.setConfFile(confFilePath);
        }
        try {
            byte[] data = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.NFSServerMonitorProgramId.getNumber(), (int)Nfsmon.NFSMgmtProg.NFSExportProc.getNumber(), (MessageLite)b.build());
            resp = Nfsmon.NFSExportResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        if (resp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "No response from NFS server"));
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
            return;
        }
        if (resp.hasErrMsg()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode(resp.getErrMsg()));
        }
        if (type == Nfsmon.NFSExportRequestType.NFSExportRequestTypeShowAll) {
            System.out.printf("%-10s    Path\n", "Export Id");
            List exportsList = resp.getExportsList();
            for (Nfsmon.NFSExport exp : exportsList) {
                System.out.printf("%-10d    %s\n", exp.getExportId(), exp.getExportedPath());
            }
        }
    }

    private MutableInt CreateNFSUserTicket(String clusterName) {
        MutableInt err = new MutableInt();
        Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)clusterName, (MutableInt)err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (Security.Key)ticketAndKey.getUserKey());
        String userName = ticketAndKey.getUserCreds().getUserName();
        int[] gids = new int[]{userName.length()};
        ticketAndKey = Security.GenerateTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)userName, (int)userName.length(), (int[])gids, (long)Security.MAX_EXPIRY_TIME, (long)0L, (boolean)true, (boolean)false, null, (MutableInt)err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)clusterName, (Security.TicketAndKey)ticketAndKey);
        return err;
    }
}

