/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.DbCommands;
import com.mapr.cli.DbReplicaCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.common.JobExecutor;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Error;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ElasticsearchCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(ElasticsearchCommands.class);
    private static final String NEW_LN = System.lineSeparator();
    private static final String COLUMN_SEP = ":";
    private static final String ES_HOME = File.separator + "opt" + File.separator + "external" + File.separator + "elasticsearch";
    private static final String ES_REPLICAS = ES_HOME + File.separator + "replicas";
    private static final String ES_CLUSTERS = ES_HOME + File.separator + "clusters";
    private static final String LIB_DIR = "lib";
    private static final String CONF_DIR = "config";
    private static final String PLUGIN_DIR = "plugins";
    private static final String CONF_FILE = "elasticsearch.yml";
    private static final String TRANSPORT_NODE_FILE = "transport.yml";
    private static final String REPLICA_FILE = "config.es";
    private static final String TMP_REPLICA_FILE = "tmp.es";
    private static final String REPLICA_FAMILY = "table replica elasticsearch";
    private static final String TARGET_FAMILY = "target elasticsearch";
    private static final String AUTOSETUP_CMD_NAME = "autosetup";
    private static final String ADD_CMD_NAME = "add";
    private static final String LIST_CMD_NAME = "list";
    private static final String EDIT_CMD_NAME = "edit";
    private static final String REMOVE_CMD_NAME = "remove";
    private static final String PAUSE_CMD_NAME = "pause";
    private static final String RESUME_CMD_NAME = "resume";
    private static final String CLEANUP_CMD_NAME = "cleanup";
    private static final String PATH_PARAM_NAME = "path";
    private static final String TARGET_PARAM_NAME = "target";
    private static final String ESCLUSTER_PARAM_NAME = "name";
    private static final String ESINDEX_PARAM_NAME = "index";
    private static final String ESTYPE_PARAM_NAME = "type";
    private static final String ESCONFIG_PARAM_NAME = "clusterconfig";
    private static final String ESLIB_PARAM_NAME = "lib";
    private static final String ESPLUGIN_PARAM_NAME = "plugins";
    private static final String ESTRANSPORT_PARAM_NAME = "transportnode";
    private static final String CONVCLASS_PARAM_NAME = "conversionclass";
    private static final String CONVJAR_PARAM_NAME = "conversionjar";
    private static final String COLUMNS_PARAM_NAME = "columns";
    private static final String INDEXED_COLUMNS_PARAM_NAME = "indexedcolumns";
    private static final String PAUSED_PARAM_NAME = "paused";
    private static final String THROTTLE_PARAM_NAME = "throttle";
    private static final String ENCRYPTION_PARAM_NAME = "networkencryption";
    private static final String COMPRESSION_PARAM_NAME = "networkcompression";
    private static final String REFRESH_PARAM_NAME = "refreshnow";
    private static final String TICKET_PARAM_NAME = "ticketpath";
    private static final String YAML_SINK_CLASSPATH = "sink.class.path";
    private static final String YAML_ES_TARGET = "es.target.name";
    private static final String YAML_ES_INDEX = "es.index.name";
    private static final String YAML_ES_TYPE = "es.index.type";
    private static final String YAML_CONV_CLASSPATH = "es.conversion.class.path";
    private static final String YAML_CONV_CLASS_NAME = "es.conversion.class.name";
    private static final CLICommand replicaSetupCommand = new CLICommand("autosetup", String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype> -%s <conversionClass> -%s <conversionJar> -%s <cf1[:col1],cf2,..> -%s <cf1:col1,cf2:col2,..> -%s <true|false> -%s <true|false> -%s <off|on|lzf|lz4|zlib>", "table replica elasticsearch", "autosetup", "path", "target", "index", "type", "conversionclass", "conversionjar", "columns", "indexedcolumns", "throttle", "networkencryption", "networkcompression"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "source table path", true, null)).put((Object)"target", (Object)new TextInputParameter("target", "Target cluster name", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "Elasticsearch index name", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "Elasticsearch type name", true, null)).put((Object)"conversionclass", (Object)new TextInputParameter("conversionclass", "Conversion class name", false, null)).put((Object)"conversionjar", (Object)new TextInputParameter("conversionjar", "Path to conversion class JAR file", false, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"indexedcolumns", (Object)new TextInputParameter("indexedcolumns", "comma separated list of <family>:<column> pairs which are indexed", false, null)).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication ops", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|on|lzf|lz4|zlib", false, "on")).put((Object)"ticketpath", (Object)new TextInputParameter("ticketpath", "ticket path", false, null).setInvisible(true)).build(), null).setShortUsage(String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype>", "table replica elasticsearch", "autosetup", "path", "target", "index", "type"));
    private static final CLICommand replicaAddCommand = new CLICommand("add", String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype> -%s <conversionClass> -%s <conversionJar> -%s <cf1[:col1],cf2,..> -%s <true|false> -%s <true|false> -%s <true|false> -%s <off|on|lzf|lz4|zlib>", "table replica elasticsearch", "add", "path", "target", "index", "type", "conversionclass", "conversionjar", "columns", "paused", "throttle", "networkencryption", "networkcompression"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "source table path", true, null)).put((Object)"target", (Object)new TextInputParameter("target", "Target cluster name", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "Elasticsearch index name", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "Elasticsearch type name", true, null)).put((Object)"conversionclass", (Object)new TextInputParameter("conversionclass", "Conversion class name", false, null)).put((Object)"conversionjar", (Object)new TextInputParameter("conversionjar", "Path to conversion class JAR file", false, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"paused", (Object)new BooleanInputParameter("paused", "is replication paused", false, Boolean.valueOf(false))).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication ops", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|on|lzf|lz4|zlib", false, "on")).put((Object)"ticketpath", (Object)new TextInputParameter("ticketpath", "ticket path", false, null).setInvisible(true)).build(), null).setUsageInVisible(true).setShortUsage(String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype>", "table replica elasticsearch", "add", "path", "target", "index", "type"));
    private static final CLICommand replicaEditCommand = new CLICommand("edit", String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype> -%s <conversionClass> -%s <conversionJar> -%s <cf1[:col1],cf2,..> -%s <cf1:col1,cf2:col2,..> -%s <true|false> -%s <true|false> -%s <off|on|lzf|lz4|zlib>", "table replica elasticsearch", "edit", "path", "target", "index", "type", "conversionclass", "conversionjar", "columns", "indexedcolumns", "throttle", "networkencryption", "networkcompression"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "source table path", true, null)).put((Object)"target", (Object)new TextInputParameter("target", "Elasticsearch cluster name", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "Elasticsearch index name", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "Elasticsearch type name", true, null)).put((Object)"conversionclass", (Object)new TextInputParameter("conversionclass", "Conversion class name", false, null)).put((Object)"conversionjar", (Object)new TextInputParameter("conversionjar", "Path to conversion class JAR file", false, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"indexedcolumns", (Object)new TextInputParameter("indexedcolumns", "comma separated list of <family>:<column> pairs which are indexed", false, null)).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle replication ops", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|on|lzf|lz4|zlib", false, "on")).build(), null).setShortUsage(String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype>", "table replica elasticsearch", "edit", "path", "target", "index", "type"));
    private static final CLICommand replicaListCommand = new CLICommand("list", String.format("usage: %s %s -%s <srcpath> -%s <true|false>", "table replica elasticsearch", "list", "path", "refreshnow"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "source table path", true, null)).put((Object)"refreshnow", (Object)new BooleanInputParameter("refreshnow", "refresh now", false, Boolean.valueOf(false))).build(), null).setShortUsage(String.format("usage: %s %s -%s <srcpath>", "table replica elasticsearch", "list", "path"));
    private static final CLICommand replicaPauseCommand = new CLICommand("pause", String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype>", "table replica elasticsearch", "pause", "path", "target", "index", "type"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "source table path", true, null)).put((Object)"target", (Object)new TextInputParameter("target", "Elasticsearch cluster name", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "Elasticsearch index name", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "Elasticsearch type name", true, null)).build(), null).setShortUsage(String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype>", "table replica elasticsearch", "pause", "path", "target", "index", "type"));
    private static final CLICommand replicaResumeCommand = new CLICommand("resume", String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype>", "table replica elasticsearch", "resume", "path", "target", "index", "type"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "source table path", true, null)).put((Object)"target", (Object)new TextInputParameter("target", "Elasticsearch cluster name", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "Elasticsearch index name", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "Elasticsearch type name", true, null)).build(), null).setShortUsage(String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype>", "table replica elasticsearch", "resume", "path", "target", "index", "type"));
    private static final CLICommand replicaRemoveCommand = new CLICommand("remove", String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype>", "table replica elasticsearch", "remove", "path", "target", "index", "type"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "source table path", true, null)).put((Object)"target", (Object)new TextInputParameter("target", "Elasticsearch cluster name", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "Elasticsearch index name", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "Elasticsearch type name", true, null)).build(), null).setShortUsage(String.format("usage: %s %s -%s <srcpath> -%s <escluster> -%s <esindex> -%s <estype>", "table replica elasticsearch", "remove", "path", "target", "index", "type"));
    private static final CLICommand replicaCleanupCommand = new CLICommand("cleanup", String.format("usage: %s %s", "table replica elasticsearch", "cleanup"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, null, null).setUsageInVisible(true).setShortUsage(String.format("usage: %s %s", "table replica elasticsearch", "cleanup"));
    public static final CLICommand esReplicaCommands = new CLICommand("elasticsearch", String.format("elasticsearch [%s|%s|%s|%s|%s|%s|%s]", "autosetup", "add", "edit", "list", "pause", "resume", "remove"), CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{replicaSetupCommand, replicaAddCommand, replicaEditCommand, replicaListCommand, replicaPauseCommand, replicaResumeCommand, replicaRemoveCommand, replicaCleanupCommand}).setShortUsage(String.format("%s [%s|%s|%s|%s|%s|%s|%s]", "table replica elasticsearch", "autosetup", "add", "edit", "list", "pause", "resume", "remove"));
    private static final CLICommand targetAddCommand = new CLICommand("add", String.format("usage: %s %s -%s <clusterName> -%s <clusterConfig> -%s <libDir> -%s <pluginDir> -%s <transportNode>", "target elasticsearch", "add", "name", "clusterconfig", "lib", "plugins", "transportnode"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "Elasticsearch cluster name", true, null)).put((Object)"clusterconfig", (Object)new TextInputParameter("clusterconfig", "path to Elasticsearch cluster config file", true, null)).put((Object)"lib", (Object)new TextInputParameter("lib", "path to Elasticsearch JAR files", true, null)).put((Object)"plugins", (Object)new TextInputParameter("plugins", "path to Elasticsearch plugin JAR files", false, null)).put((Object)"transportnode", (Object)new TextInputParameter("transportnode", "name[:port] of Elasticsearch transport node", false, null)).build(), null).setShortUsage(String.format("usage: %s %s -%s <es cluster name>", "target elasticsearch", "add", "name"));
    private static final CLICommand targetEditCommand = new CLICommand("edit", String.format("usage: %s %s -%s <clusterName> -%s <clusterConfig> -%s <libDir> -%s <pluginDir> -%s <transportNode>", "target elasticsearch", "edit", "name", "clusterconfig", "lib", "plugins", "transportnode"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "Elasticsearch cluster name", true, null)).put((Object)"clusterconfig", (Object)new TextInputParameter("clusterconfig", "path to Elasticsearch cluster config file", false, null)).put((Object)"lib", (Object)new TextInputParameter("lib", "path to Elasticsearch JAR files", false, null)).put((Object)"plugins", (Object)new TextInputParameter("plugins", "path to Elasticsearch plugin JAR files", false, null)).put((Object)"transportnode", (Object)new TextInputParameter("transportnode", "name[:port] of Elasticsearch transport node", false, null)).build(), null).setShortUsage(String.format("usage: %s %s -%s <es cluster name>", "target elasticsearch", "edit", "name"));
    private static final CLICommand targetListCommand = new CLICommand("list", String.format("usage: %s %s", "target elasticsearch", "list"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, null, null).setShortUsage(String.format("usage: %s %s", "target elasticsearch", "list"));
    private static final CLICommand targetRemoveCommand = new CLICommand("remove", String.format("usage: %s %s -%s <clusterName> ", "target elasticsearch", "remove", "name"), ElasticsearchCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "Elasticsearch cluster name", true, null)).build(), null).setShortUsage(String.format("usage: %s %s -%s <es cluster name>", "target elasticsearch", "remove", "name"));
    public static final CLICommand esTargetCommands = new CLICommand("elasticsearch", String.format("elasticsearch [%s|%s|%s|%s]", "add", "edit", "list", "remove"), CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{targetAddCommand, targetEditCommand, targetListCommand, targetRemoveCommand}).setShortUsage(String.format("%s [%s|%s|%s|%s]", "target elasticsearch", "add", "edit", "list", "remove"));

    public ElasticsearchCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cname = this.cliCommand.getCommandName();
        String commandFamily = this.cliCommand.getParentCommand().getParentCommandNames();
        if (commandFamily.equalsIgnoreCase(REPLICA_FAMILY)) {
            if (cname.equalsIgnoreCase(replicaSetupCommand.getCommandName())) {
                this.replicaSetup(out);
            } else if (cname.equalsIgnoreCase(replicaAddCommand.getCommandName())) {
                this.replicaAdd(out);
            } else if (cname.equalsIgnoreCase(replicaEditCommand.getCommandName())) {
                this.replicaEdit(out);
            } else if (cname.equalsIgnoreCase(replicaListCommand.getCommandName())) {
                this.replicaList(out);
            } else if (cname.equalsIgnoreCase(replicaPauseCommand.getCommandName())) {
                this.replicaPauseOrResume(out, true);
            } else if (cname.equalsIgnoreCase(replicaResumeCommand.getCommandName())) {
                this.replicaPauseOrResume(out, false);
            } else if (cname.equalsIgnoreCase(replicaRemoveCommand.getCommandName())) {
                this.replicaRemove(out);
            } else if (cname.equalsIgnoreCase(replicaCleanupCommand.getCommandName())) {
                this.replicaCleanup(out);
            }
        } else if (commandFamily.equalsIgnoreCase(TARGET_FAMILY)) {
            if (cname.equalsIgnoreCase(targetAddCommand.getCommandName())) {
                this.targetAdd(out);
            } else if (cname.equalsIgnoreCase(targetEditCommand.getCommandName())) {
                this.targetEdit(out);
            } else if (cname.equalsIgnoreCase(targetListCommand.getCommandName())) {
                this.targetList(out);
            } else if (cname.equalsIgnoreCase(targetRemoveCommand.getCommandName())) {
                this.targetRemove(out);
            }
        }
        return output;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key) && (ret = this.getParamTextValue(key, 0)) != null) {
                ret = ret.trim();
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }

    private void replicaSetup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tableName = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String targetName = this.getTextParam(TARGET_PARAM_NAME, null);
        final String indexName = this.getTextParam(ESINDEX_PARAM_NAME, null);
        final String typeName = this.getTextParam(ESTYPE_PARAM_NAME, null);
        final String colList = this.getTextParam(COLUMNS_PARAM_NAME, null);
        final String indexedColList = this.getTextParam(INDEXED_COLUMNS_PARAM_NAME, null);
        final String convClassName = this.getTextParam(CONVCLASS_PARAM_NAME, null);
        final String convJar = this.getTextParam(CONVJAR_PARAM_NAME, null);
        final String ticketPath = this.getTextParam(TICKET_PARAM_NAME, null);
        final ElasticsearchCommands dbPerm = this;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        try {
            final Path replicaPath = this.getReplicaFilePath(tableName, targetName, indexName, typeName);
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    ElasticsearchCommands.this.replicaCommonSetup(mfs, tableName, targetName, indexName, typeName, colList, indexedColList, convClassName, convJar, replicaPath, ticketPath, dbPerm, true, replBuilder);
                    DbReplicaCommands.copyTable(tableName, replicaPath.toString(), 1, colList, ElasticsearchCommands.this.getUserLoginId(), true, ticketPath, false, dbPerm, replBuilder);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, e.getMessage()));
        }
    }

    private void replicaAdd(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tableName = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String targetName = this.getTextParam(TARGET_PARAM_NAME, null);
        final String indexName = this.getTextParam(ESINDEX_PARAM_NAME, null);
        final String typeName = this.getTextParam(ESTYPE_PARAM_NAME, null);
        final String colList = this.getTextParam(COLUMNS_PARAM_NAME, null);
        final String convClassName = this.getTextParam(CONVCLASS_PARAM_NAME, null);
        final String convJar = this.getTextParam(CONVJAR_PARAM_NAME, null);
        final String ticketPath = this.getTextParam(TICKET_PARAM_NAME, null);
        final ElasticsearchCommands dbPerm = this;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        try {
            final Path replicaPath = this.getReplicaFilePath(tableName, targetName, indexName, typeName);
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    ElasticsearchCommands.this.replicaCommonSetup(mfs, tableName, targetName, indexName, typeName, colList, null, convClassName, convJar, replicaPath, ticketPath, dbPerm, false, replBuilder);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, e.getMessage()));
        }
    }

    private void checkTableType(MapRFileSystem mfs, Path tablePath) throws CLIProcessingException {
        try {
            if (!mfs.exists(tablePath)) {
                throw new CLIProcessingException("Path " + tablePath + " not found");
            }
            if (!mfs.isTable(tablePath)) {
                throw new CLIProcessingException("Elasticsearch commands are not supported for regular files");
            }
            if (mfs.isStream(tablePath)) {
                throw new CLIProcessingException("Elasticsearch commands are not yet supported for streams");
            }
            if (mfs.isJsonTable(tablePath)) {
                throw new CLIProcessingException("Elasticsearch commands are not yet supported for JSON tables");
            }
        }
        catch (IOException e) {
            throw new CLIProcessingException("Could not check type of " + tablePath);
        }
    }

    private void replicaCommonSetup(MapRFileSystem mfs, String tableName, String targetName, String indexName, String typeName, String colList, String indexedColList, String convClassName, String convJar, Path replicaPath, String ticketPath, AceHelper.DBPermission dbPerm, boolean isAuto, Dbserver.TableReplicaDesc.Builder replBuilder) throws CLIProcessingException, IOException {
        Path tablePath = new Path(tableName);
        this.checkTableType(mfs, tablePath);
        if (mfs.exists(replicaPath)) {
            throw new CLIProcessingException(String.format("Replica %s:%s/%s for table %s already exists", targetName, indexName, typeName, tableName));
        }
        mfs.mkdirs(replicaPath.getParent());
        this.replicaMakeWritable(replicaPath.getParent().getParent());
        if (convJar != null && convClassName != null) {
            this.copyConversionJar(convJar, replicaPath.getParent());
        } else if (convJar != null || convClassName != null) {
            throw new CLIProcessingException("Must specify conversionjar and conversionclass");
        }
        this.createReplicaFile(replicaPath, targetName, indexName, typeName, convJar, convClassName);
        replBuilder.setExternal(true);
        if (isAuto) {
            replBuilder.setIsPaused(true);
        } else if (this.isParamPresent(PAUSED_PARAM_NAME)) {
            replBuilder.setIsPaused(this.getParamBooleanValue(PAUSED_PARAM_NAME, 0));
        }
        if (this.isParamPresent(THROTTLE_PARAM_NAME)) {
            replBuilder.setThrottle(this.getParamBooleanValue(THROTTLE_PARAM_NAME, 0));
        }
        if (this.isParamPresent(ENCRYPTION_PARAM_NAME)) {
            replBuilder.setEncryptonwire(this.getParamBooleanValue(ENCRYPTION_PARAM_NAME, 0));
        }
        if (this.isParamPresent(COMPRESSION_PARAM_NAME)) {
            Common.FileCompressionType ctype = DbReplicaCommands.getCompressionType(this.getParamTextValue(COMPRESSION_PARAM_NAME, 0));
            if (ctype == null) {
                throw new CLIProcessingException("Invalid input values. The entered value for compression is not a supported type.");
            }
            replBuilder.setCompressonwire(ctype);
        }
        String className = DbReplicaCommands.verifyExternalDstSanity(mfs, replicaPath.toString());
        DbReplicaCommands.setupReplication(dbPerm, replBuilder, tableName, replicaPath.toString(), colList, indexedColList, this.getUserLoginId(), mfs, className, false, false, false, 0);
    }

    private void replicaEdit(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tableName = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String targetName = this.getTextParam(TARGET_PARAM_NAME, null);
        final String indexName = this.getTextParam(ESINDEX_PARAM_NAME, null);
        final String typeName = this.getTextParam(ESTYPE_PARAM_NAME, null);
        final String colList = this.getTextParam(COLUMNS_PARAM_NAME, null);
        final String indexedColList = this.getTextParam(INDEXED_COLUMNS_PARAM_NAME, null);
        final String convClassName = this.getTextParam(CONVCLASS_PARAM_NAME, null);
        final String convJar = this.getTextParam(CONVJAR_PARAM_NAME, null);
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final int replDescEmptySize = replBuilder.build().getSerializedSize();
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            final Path replicaPath = this.getReplicaFilePath(tableName, targetName, indexName, typeName);
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    Path tablePath = new Path(tableName);
                    boolean isJson = mfs.isJsonTable(tablePath);
                    String replicaClusterName = mfs.getClusterNameUnchecked(replicaPath.toString());
                    String replicaMFSName = mfs.getNameStr(replicaPath.toString());
                    ElasticsearchCommands.this.checkTableType(mfs, tablePath);
                    if (!mfs.exists(replicaPath)) {
                        throw new CLIProcessingException(String.format("Replica %s:%s/%s for table %s not found", targetName, indexName, typeName, tableName));
                    }
                    if (convClassName != null || convJar != null) {
                        if (convJar != null) {
                            ElasticsearchCommands.this.copyConversionJar(convJar, replicaPath.getParent());
                        }
                        ElasticsearchCommands.this.createReplicaFile(replicaPath, targetName, indexName, typeName, convJar, convClassName);
                    }
                    if (ElasticsearchCommands.this.isParamPresent(ElasticsearchCommands.THROTTLE_PARAM_NAME)) {
                        replBuilder.setThrottle(ElasticsearchCommands.this.getParamBooleanValue(ElasticsearchCommands.THROTTLE_PARAM_NAME, 0));
                    }
                    if (ElasticsearchCommands.this.isParamPresent(ElasticsearchCommands.ENCRYPTION_PARAM_NAME)) {
                        replBuilder.setEncryptonwire(ElasticsearchCommands.this.getParamBooleanValue(ElasticsearchCommands.ENCRYPTION_PARAM_NAME, 0));
                    }
                    if (ElasticsearchCommands.this.isParamPresent(ElasticsearchCommands.COMPRESSION_PARAM_NAME)) {
                        Common.FileCompressionType ctype = DbReplicaCommands.getCompressionType(ElasticsearchCommands.this.getParamTextValue(ElasticsearchCommands.COMPRESSION_PARAM_NAME, 0));
                        if (ctype == null) {
                            throw new CLIProcessingException("Invalid input values. The entered value for compression is not a supported type.");
                        }
                        replBuilder.setCompressonwire(ctype);
                    }
                    String user = ElasticsearchCommands.this.getUserLoginId();
                    String clist = colList;
                    if (indexedColList != null) {
                        DbReplicaCommands.validateIndexedFields(indexedColList, tableName, user);
                        replBuilder.setIndexedFields(indexedColList);
                        if (clist != null && clist.trim().length() > 0) {
                            clist = clist + "," + indexedColList.replace(';', ',');
                        }
                    }
                    boolean allCfs = false;
                    if (clist != null) {
                        boolean bl = allCfs = clist.trim().length() == 0;
                        if (!allCfs) {
                            TreeMap<Integer, SortedSet<String>> familyMap = new TreeMap<Integer, SortedSet<String>>();
                            DbReplicaCommands.parseColList(clist, tableName, user, isJson, familyMap);
                            DbReplicaCommands.addCfQualifiers(familyMap, replBuilder);
                        }
                    }
                    if (replBuilder.build().getSerializedSize() == replDescEmptySize && !allCfs) {
                        return;
                    }
                    try {
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        mfs.editTableReplica(tablePath, replicaClusterName, replicaMFSName, allCfs, replDesc);
                        manager.moveToTop(tableName);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tableName, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void replicaList(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tableName = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final boolean refreshNow = this.getBooleanParam(REFRESH_PARAM_NAME, false);
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        final LinkedList rdlist = new LinkedList();
        final ArrayList rlist = new ArrayList();
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        Path tablePath = new Path(tableName);
                        ElasticsearchCommands.this.checkTableType(mfs, tablePath);
                        Dbserver.TableReplicaListResponse resp = mfs.listTableReplicas(tablePath, true, refreshNow);
                        rlist.add(resp);
                        for (Dbserver.TableReplicaDesc rd : resp.getReplicasList()) {
                            if (!rd.hasExternal() || !rd.getExternal() || !mfs.exists(new Path(rd.getTablePath())) || !rd.getTablePath().startsWith(ES_REPLICAS)) continue;
                            ReplicaInfo ri = new ReplicaInfo(rd);
                            ri.init(mfs);
                            rdlist.add(ri);
                        }
                        manager.moveToTop(tableName);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tableName, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
            List<Dbserver.ColumnFamilyAttr> familyAttrs = DbReplicaCommands.getAllFamilies(tableName, this.getUserLoginId());
            Dbserver.TableReplicaListResponse listResp = (Dbserver.TableReplicaListResponse)rlist.get(0);
            for (ReplicaInfo ri : rdlist) {
                Dbserver.TableReplicaDesc rd = ri.getReplicaDesc();
                CommandOutput.OutputHierarchy.OutputNode replNode = new CommandOutput.OutputHierarchy.OutputNode();
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)rd.getClusterName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(TARGET_PARAM_NAME, (Object)ri.getTargetName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ESINDEX_PARAM_NAME, (Object)ri.getIndexName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ESTYPE_PARAM_NAME, (Object)ri.getTypeName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(PAUSED_PARAM_NAME, (Object)rd.getIsPaused()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(THROTTLE_PARAM_NAME, (Object)rd.getThrottle()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", rd.getIdx()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENCRYPTION_PARAM_NAME, (Object)rd.getEncryptonwire()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(COMPRESSION_PARAM_NAME, (Object)DbReplicaCommands.getCompressionName(rd.getCompressonwire())));
                if (rd.getQualifiersCount() > 0) {
                    String famList = "";
                    int idx = 0;
                    for (Dbserver.Qualifier qual : rd.getQualifiersList()) {
                        String famName = DbReplicaCommands.familyIdToName(familyAttrs, qual.getFamily());
                        if (famName == null) {
                            LOG.error((Object)("failed to get family name for id " + qual.getFamily()));
                        }
                        if (qual.getQualifiersCount() > 0) {
                            for (ByteString bstr : qual.getQualifiersList()) {
                                famList = idx == 0 ? famName + COLUMN_SEP + bstr.toStringUtf8() : famList + "," + famName + COLUMN_SEP + bstr.toStringUtf8();
                                ++idx;
                            }
                            continue;
                        }
                        if (idx == 0) {
                            famList = famName;
                            ++idx;
                            continue;
                        }
                        famList = famList + "," + famName;
                        ++idx;
                    }
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(COLUMNS_PARAM_NAME, (Object)famList));
                }
                if (rd.hasIndexedFields()) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(INDEXED_COLUMNS_PARAM_NAME, (Object)rd.getIndexedFields()));
                }
                String replicaTablePath = DbReplicaCommands.getTransformedTablePath(rd.getClusterName(), rd.getTablePath());
                if (JobExecutor.getStatus(tableName + "_" + replicaTablePath) != null) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("copytablestatus", (Object)JobExecutor.getStatus(tableName + "_" + replicaTablePath)));
                }
                long minPendingTS = 0L;
                long maxPendingTS = 0L;
                long bytesPending = 0L;
                long putsPending = 0L;
                int bucketsPending = 0;
                int asyncBuckets = 0;
                ArrayList<Error.ExtendedError> elist = null;
                for (Dbserver.TableReplicaStatus rs : listResp.getReplicaStatusList()) {
                    if (rd.getIdx() != rs.getReplicaIdx()) continue;
                    minPendingTS = rs.getMinPendingTS();
                    maxPendingTS = rs.getMaxPendingTS();
                    bytesPending = rs.getBytesPending();
                    putsPending = rs.getPutsPending();
                    bucketsPending = rs.getBucketsPending();
                    asyncBuckets = rs.getAsyncBuckets();
                    for (Error.ExtendedError ee : rs.getEerrorsList()) {
                        if (elist == null) {
                            elist = new ArrayList<Error.ExtendedError>();
                        }
                        elist.add(ee);
                    }
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("isUptodate", (Object)(bucketsPending == 0 && !rd.getIsPaused() ? 1 : 0)));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("minPendingTS", minPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxPendingTS", maxPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bytesPending", bytesPending));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("putsPending", putsPending));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketsPending", bucketsPending));
                byte[] uuid = rd.getTableUuid().toByteArray();
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString((byte[])uuid)));
                if (elist != null) {
                    for (Error.ExtendedError ee : elist) {
                        CommandOutput.OutputHierarchy.OutputNode errNodes = new CommandOutput.OutputHierarchy.OutputNode("errors");
                        replNode.addChild(errNodes);
                        if (ee.hasEcode()) {
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Code", (Object)ee.getEcode().name()));
                        }
                        if (ee.hasEhost()) {
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Host", (Object)Util.intToIp((int)ee.getEhost())));
                        }
                        if (!ee.hasEmsg()) continue;
                        errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Msg", (Object)ee.getEmsg()));
                    }
                }
                out.addNode(replNode);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void replicaPauseOrResume(CommandOutput.OutputHierarchy out, boolean isPaused) throws CLIProcessingException {
        String tableName = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String targetName = this.getTextParam(TARGET_PARAM_NAME, null);
        String indexName = this.getTextParam(ESINDEX_PARAM_NAME, null);
        String typeName = this.getTextParam(ESTYPE_PARAM_NAME, null);
        try {
            Path replicaPath = this.getReplicaFilePath(tableName, targetName, indexName, typeName);
            DbReplicaCommands.pauseOrResumeReplication(tableName, replicaPath.toString(), isPaused, this.getUserLoginId());
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void replicaRemove(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tableName = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String targetName = this.getTextParam(TARGET_PARAM_NAME, null);
        String indexName = this.getTextParam(ESINDEX_PARAM_NAME, null);
        String typeName = this.getTextParam(ESTYPE_PARAM_NAME, null);
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            final Path replicaPath = this.getReplicaFilePath(tableName, targetName, indexName, typeName);
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    Path tablePath = new Path(tableName);
                    String replicaName = replicaPath.toString();
                    ElasticsearchCommands.this.checkTableType(mfs, tablePath);
                    try {
                        String clusterName = mfs.getClusterNameUnchecked(replicaName);
                        replBuilder.setClusterName(clusterName);
                        String replicaMFSName = mfs.getNameStr(replicaName);
                        replBuilder.setTablePath(replicaMFSName);
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        mfs.removeTableReplica(tablePath, replDesc);
                        mfs.delete(replicaPath.getParent(), true);
                        ElasticsearchCommands.this.replicaRemoveTree(replicaPath.getParent().getParent());
                        manager.moveToTop(tableName);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tableName, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void replicaCleanup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileStatus[] srcs;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    String clusterName = mfs.getClusterName(new Path(ES_REPLICAS).toUri());
                    for (MapRFileStatus src : srcs = mfs.listStatus(new Path(ES_REPLICAS))) {
                        if (!src.isDirectory()) continue;
                        String fidStr = src.getPath().getName();
                        Common.FidMsg fid = ElasticsearchCommands.this.stringToFid(fidStr);
                        long dbinding = ElasticsearchCommands.this.getBindingForContainer(clusterName, fid.getCid());
                        if (dbinding == -1L) {
                            LOG.error((Object)("Container lookup failed for: " + src.getPath().getName()));
                            continue;
                        }
                        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(ElasticsearchCommands.this.getUserCredentials()).build();
                        try {
                            byte[] replyData = Rpc.sendRequest((long)dbinding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
                            if (replyData == null) {
                                LOG.error((Object)("RPC failed for: " + src.getPath().getName()));
                                continue;
                            }
                            Fileserver.GetattrResponse resp = Fileserver.GetattrResponse.parseFrom((byte[])replyData);
                            if (resp.getStatus() == 116) {
                                LOG.info((Object)("Removing entries for deleted table: " + src.getPath().getName()));
                                mfs.delete(src.getPath(), true);
                                continue;
                            }
                            if (resp.getStatus() == 0) continue;
                            LOG.error((Object)("GetAttr failed with error: " + Errno.toString((int)resp.getStatus())));
                        }
                        catch (MaprSecurityException e) {
                            throw new CLIProcessingException("Security exception for: " + src.getPath().getName());
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private Path getReplicaFilePath(final String sourceTable, final String targetName, final String indexName, final String typeName) throws IOException, CLIProcessingException {
        final LinkedList results = new LinkedList();
        new FileclientRun(this.getUserLoginId()){

            @Override
            public void runAsProxyUser() throws IOException, CLIProcessingException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                MapRHTable htable = new MapRHTable();
                htable.init(mfs.getConf(), new Path(sourceTable));
                String fid = mfs.openTable(new Path(sourceTable), htable).attrs().toString();
                Path result = new Path(ES_REPLICAS, fid);
                result = new Path(result, targetName);
                result = new Path(result, indexName);
                result = new Path(result, typeName);
                result = new Path(result, ElasticsearchCommands.REPLICA_FILE);
                results.add(result);
            }
        };
        return (Path)results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReplicaFile(Path replicaPath, String targetName, String indexName, String typeName, String convJar, String convName) throws CLIProcessingException, IOException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        Map esMap = null;
        Path tmpPath = new Path(replicaPath.getParent(), TMP_REPLICA_FILE);
        if (mfs.exists(replicaPath)) {
            FSDataInputStream is = mfs.open(replicaPath);
            Yaml yaml = new Yaml();
            esMap = (Map)yaml.load((InputStream)is);
            is.close();
        } else {
            esMap = new HashMap();
        }
        try (FSDataOutputStream os = mfs.create(tmpPath, true);){
            Path targetPath = new Path(ES_CLUSTERS, targetName);
            Path libPath = new Path(targetPath, "lib");
            Path pluginPath = new Path(targetPath, "plugins");
            os.writeBytes("sink.class.path: " + libPath.toString());
            os.writeBytes(COLUMN_SEP + pluginPath.toString());
            os.writeBytes(NEW_LN);
            if (esMap.get(YAML_ES_TARGET) != null) {
                os.writeBytes("es.target.name: " + (String)esMap.get(YAML_ES_TARGET) + NEW_LN);
            } else if (targetName != null) {
                os.writeBytes("es.target.name: " + targetName + NEW_LN);
            } else {
                throw new CLIProcessingException("No target name found");
            }
            if (esMap.get(YAML_ES_INDEX) != null) {
                os.writeBytes("es.index.name: " + (String)esMap.get(YAML_ES_INDEX) + NEW_LN);
            } else if (indexName != null) {
                os.writeBytes("es.index.name: " + indexName + NEW_LN);
            } else {
                throw new CLIProcessingException("No ES index name found");
            }
            if (esMap.get(YAML_ES_TYPE) != null) {
                os.writeBytes("es.index.type: " + (String)esMap.get(YAML_ES_TYPE) + NEW_LN);
            } else if (typeName != null) {
                os.writeBytes("es.index.type: " + typeName + NEW_LN);
            } else {
                throw new CLIProcessingException("No ES index name found");
            }
            boolean removeConv = false;
            if (convJar != null) {
                if (convJar.trim().length() > 0) {
                    File convFile = new File(convJar);
                    Path path = new Path(replicaPath.getParent(), convFile.getName());
                    os.writeBytes("es.conversion.class.path: " + path.toString() + NEW_LN);
                } else {
                    removeConv = true;
                }
            } else if (esMap.get(YAML_CONV_CLASSPATH) != null) {
                os.writeBytes("es.conversion.class.path: " + (String)esMap.get(YAML_CONV_CLASSPATH) + NEW_LN);
            }
            if (convName != null) {
                if (convName.trim().length() > 0) {
                    os.writeBytes("es.conversion.class.name: " + convName + NEW_LN);
                }
            } else if (esMap.get(YAML_CONV_CLASS_NAME) != null && !removeConv) {
                os.writeBytes("es.conversion.class.name: " + (String)esMap.get(YAML_CONV_CLASS_NAME) + NEW_LN);
            }
        }
        mfs.rename(tmpPath, replicaPath);
    }

    private void copyConversionJar(String jarFileName, Path destPath) throws IOException, CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        File jarFile = new File(jarFileName);
        if (!jarFile.isFile()) {
            throw new CLIProcessingException("Could not find file: " + jarFileName);
        }
        mfs.copyFromLocalFile(false, true, new Path(jarFileName), destPath);
    }

    private void replicaRemoveTree(Path replicaPath) throws IOException, CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        if (replicaPath.toString().compareTo(ES_REPLICAS) == 0) {
            return;
        }
        MapRFileStatus[] listing = mfs.listStatus(replicaPath);
        if (listing != null && listing.length > 0) {
            return;
        }
        mfs.delete(replicaPath, true);
        this.replicaRemoveTree(replicaPath.getParent());
    }

    private void replicaMakeWritable(Path replicaPath) throws IOException, CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        if (replicaPath.toString().compareTo(ES_REPLICAS) == 0) {
            return;
        }
        mfs.setPermission(replicaPath, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        this.replicaMakeWritable(replicaPath.getParent());
    }

    private Common.FidMsg stringToFid(String s) {
        String[] tmp = s.split("\\.");
        if (tmp.length != 3) {
            return null;
        }
        int cid = Integer.parseInt(tmp[0]);
        int cinum = Integer.parseInt(tmp[1]);
        int uniq = Integer.parseInt(tmp[2]);
        return Common.FidMsg.newBuilder().setCid(cid).setCinum(cinum).setUniq(uniq).build();
    }

    private long getBindingForContainer(String clusterName, int cid) throws CLIProcessingException {
        int dbPort;
        int dbHost;
        CLDBProto.ContainerLookupRequest creq = CLDBProto.ContainerLookupRequest.newBuilder().addContainerId(cid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)creq, CLDBProto.ContainerLookupResponse.class);
            if (replyData == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                return -1L;
            }
            CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                LOG.error((Object)("Container lookup failed : Error " + Errno.toString((int)resp.getStatus())));
                return -1L;
            }
            Common.Server server = resp.getContainers(0).getMServer();
            dbHost = server.getIps(0).getHost();
            dbPort = server.getIps(0).getPort();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Container lookup failed");
            return -1L;
        }
        return Rpc.createBindingFor((int)dbHost, (int)dbPort, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    private void targetAdd(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String targetName = this.getTextParam(ESCLUSTER_PARAM_NAME, null);
        final String configFileName = this.getTextParam(ESCONFIG_PARAM_NAME, null);
        final String libDirName = this.getTextParam("lib", null);
        final String pluginDirName = this.getTextParam("plugins", null);
        final String transportNode = this.getTextParam(ESTRANSPORT_PARAM_NAME, null);
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    Path targetPath = new Path(ES_CLUSTERS, targetName);
                    File configFile = new File(configFileName);
                    if (!configFile.isFile()) {
                        throw new CLIProcessingException("Cannot find file " + configFileName);
                    }
                    File libDir = new File(libDirName);
                    if (!libDir.isDirectory()) {
                        throw new CLIProcessingException("Cannot find directory " + libDirName);
                    }
                    File pluginDir = null;
                    if (pluginDirName != null && !(pluginDir = new File(pluginDirName)).isDirectory()) {
                        throw new CLIProcessingException("Cannot find directory " + pluginDirName);
                    }
                    if (mfs.exists(targetPath)) {
                        throw new CLIProcessingException("Target cluster " + targetName + " already exists");
                    }
                    mfs.mkdirs(targetPath);
                    ElasticsearchCommands.this.copyConfigFile(configFile, new Path(targetPath, ElasticsearchCommands.CONF_DIR));
                    ElasticsearchCommands.this.copyJarDir(libDir, new Path(targetPath, "lib"), false);
                    if (pluginDir != null) {
                        ElasticsearchCommands.this.copyJarDir(pluginDir, new Path(targetPath, "plugins"), true);
                    }
                    if (transportNode != null) {
                        ElasticsearchCommands.this.setTransportNode(transportNode, new Path(targetPath, ElasticsearchCommands.CONF_DIR));
                    }
                    if (!mfs.isDirectory(new Path(ES_REPLICAS))) {
                        mfs.mkdirs(new Path(ES_REPLICAS), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, e.getMessage()));
        }
    }

    private void targetEdit(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String targetName = this.getTextParam(ESCLUSTER_PARAM_NAME, null);
        final String configFileName = this.getTextParam(ESCONFIG_PARAM_NAME, null);
        final String libDirName = this.getTextParam("lib", null);
        final String pluginDirName = this.getTextParam("plugins", null);
        final String transportNode = this.getTextParam(ESTRANSPORT_PARAM_NAME, null);
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    Path targetPath = new Path(ES_CLUSTERS, targetName);
                    File configFile = null;
                    File libDir = null;
                    File pluginDir = null;
                    if (!mfs.isDirectory(targetPath)) {
                        throw new CLIProcessingException("Could not find registered cluster: " + targetName);
                    }
                    if (configFileName != null && !(configFile = new File(configFileName)).isFile()) {
                        throw new CLIProcessingException("Cannot find file " + configFileName);
                    }
                    if (libDirName != null && !(libDir = new File(libDirName)).isDirectory()) {
                        throw new CLIProcessingException("Cannot find directory " + libDirName);
                    }
                    if (pluginDirName != null && !(pluginDir = new File(pluginDirName)).isDirectory()) {
                        throw new CLIProcessingException("Cannot find directory " + pluginDirName);
                    }
                    if (configFile != null) {
                        ElasticsearchCommands.this.copyConfigFile(configFile, new Path(targetPath, ElasticsearchCommands.CONF_DIR));
                    }
                    if (libDir != null) {
                        ElasticsearchCommands.this.copyJarDir(libDir, new Path(targetPath, "lib"), false);
                    }
                    if (pluginDir != null) {
                        ElasticsearchCommands.this.copyJarDir(pluginDir, new Path(targetPath, "plugins"), true);
                    }
                    if (transportNode != null) {
                        ElasticsearchCommands.this.setTransportNode(transportNode, new Path(targetPath, ElasticsearchCommands.CONF_DIR));
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, e.getMessage()));
        }
    }

    private void targetList(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final ArrayList targets = new ArrayList();
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    Path clustersPath = new Path(ES_CLUSTERS);
                    for (MapRFileStatus file : mfs.listStatus(clustersPath)) {
                        if (!file.isDirectory()) continue;
                        Path clusterPath = file.getPath();
                        ESTarget target = new ESTarget();
                        target.setTargetName(clusterPath.getName());
                        Path libPath = new Path(clusterPath, "lib");
                        FileStatus[] jarFiles = mfs.listStatus(libPath, new PathFilter(){

                            public boolean accept(Path path) {
                                return path.getName().startsWith("elasticsearch-") && path.getName().endsWith(".jar");
                            }
                        });
                        if (jarFiles.length > 0) {
                            target.setESVersion(jarFiles[0].getPath());
                        }
                        Path confPath = new Path(clusterPath, ElasticsearchCommands.CONF_DIR);
                        Yaml yaml = new Yaml();
                        FSDataInputStream is = mfs.open(new Path(confPath, ElasticsearchCommands.CONF_FILE));
                        Map confMap = (Map)yaml.load((InputStream)is);
                        is.close();
                        target.setClusterName((String)confMap.get("cluster.name"));
                        Path transportPath = new Path(confPath, ElasticsearchCommands.TRANSPORT_NODE_FILE);
                        if (mfs.isFile(transportPath)) {
                            yaml = new Yaml();
                            is = mfs.open(transportPath);
                            confMap = (Map)yaml.load((InputStream)is);
                            is.close();
                            if (confMap.get("transport.client.initial_nodes") != null) {
                                ArrayList nodes = (ArrayList)confMap.get("transport.client.initial_nodes");
                                target.setTransportNode((String)nodes.get(0));
                            }
                        }
                        targets.add(target);
                    }
                }
            };
            for (ESTarget target : targets) {
                CommandOutput.OutputHierarchy.OutputNode targetNode = new CommandOutput.OutputHierarchy.OutputNode();
                targetNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(TARGET_PARAM_NAME, (Object)target.getTargetName()));
                targetNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("clusterName", (Object)target.getClusterName()));
                if (target.getESVersion() != null) {
                    targetNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("esVersion", (Object)target.getESVersion()));
                }
                if (target.getTransportNode() != null) {
                    targetNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("transportNode", (Object)target.getTransportNode()));
                }
                out.addNode(targetNode);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, e.getMessage()));
        }
    }

    private void targetRemove(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String targetName = this.getTextParam(ESCLUSTER_PARAM_NAME, null);
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    Path targetPath;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (!mfs.isDirectory(targetPath = new Path(ES_CLUSTERS, targetName))) {
                        throw new CLIProcessingException("Could not find registered cluster: " + targetName);
                    }
                    mfs.delete(targetPath, true);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, e.getMessage()));
        }
    }

    private void copyConfigFile(File localFile, Path mfsPath) throws IOException, CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        Path confPath = new Path(mfsPath, CONF_FILE);
        mfs.mkdirs(mfsPath);
        mfs.copyFromLocalFile(false, true, new Path(localFile.getPath()), confPath);
    }

    private void copyJarDir(final File localDir, Path mfsPath, final boolean recursive) throws IOException, CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        if (mfs.exists(mfsPath)) {
            mfs.delete(mfsPath, true);
        }
        final ArrayList jarPaths = new ArrayList();
        Files.walkFileTree(localDir.toPath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().getName().endsWith(".jar") && !file.toFile().getName().startsWith("marvel.")) {
                    jarPaths.add(new Path(file.toFile().getPath()));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                if (recursive || dir.toString().compareTo(localDir.getPath()) == 0) {
                    System.out.println("Visiting directory: " + dir.toString());
                    return FileVisitResult.CONTINUE;
                }
                System.out.println("Skipping directory: " + dir.toString());
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        mfs.mkdirs(mfsPath);
        mfs.copyFromLocalFile(false, true, jarPaths.toArray(new Path[0]), mfsPath);
    }

    private void setTransportNode(String transportNode, Path mfsPath) throws IOException, CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        Path transportPath = new Path(mfsPath, TRANSPORT_NODE_FILE);
        if (transportNode.trim().length() == 0) {
            mfs.delete(transportPath, false);
        } else {
            FSDataOutputStream os = mfs.create(transportPath, true);
            os.writeBytes("transport.client.initial_nodes: [ " + transportNode + " ]" + System.lineSeparator());
            os.close();
        }
    }

    private String getTextParam(String paramName, String defaultValue) throws CLIProcessingException {
        if (this.isParamPresent(paramName)) {
            return this.getParamTextValue(paramName, 0);
        }
        return defaultValue;
    }

    private boolean getBooleanParam(String paramName, boolean defaultValue) throws CLIProcessingException {
        if (this.isParamPresent(paramName)) {
            return this.getParamBooleanValue(paramName, 0);
        }
        return defaultValue;
    }

    class ReplicaInfo {
        Dbserver.TableReplicaDesc rd;
        String targetName;
        String indexName;
        String typeName;

        public ReplicaInfo(Dbserver.TableReplicaDesc rd) {
            this.rd = rd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(MapRFileSystem mfs) {
            InputStream is = null;
            try {
                Path confPath = new Path(this.rd.getTablePath());
                Yaml yaml = new Yaml();
                is = mfs.open(confPath);
                Map confMap = (Map)yaml.load(is);
                this.targetName = (String)confMap.get(ElasticsearchCommands.YAML_ES_TARGET);
                this.indexName = (String)confMap.get(ElasticsearchCommands.YAML_ES_INDEX);
                this.typeName = (String)confMap.get(ElasticsearchCommands.YAML_ES_TYPE);
            }
            catch (IOException e) {
                LOG.error((Object)("Error reading replica config file: " + e.getMessage()));
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public Dbserver.TableReplicaDesc getReplicaDesc() {
            return this.rd;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    private class ESTarget {
        String targetName;
        String clusterName;
        String esVersion;
        String transportNode;

        private ESTarget() {
        }

        void setTargetName(String name) {
            this.targetName = name;
        }

        String getTargetName() {
            return this.targetName;
        }

        void setClusterName(String name) {
            this.clusterName = name;
        }

        String getClusterName() {
            return this.clusterName;
        }

        void setESVersion(Path esJar) {
            String name = esJar.getName();
            if (name.startsWith("elasticsearch-") && name.endsWith(".jar")) {
                this.esVersion = name.substring(14, name.length() - 4);
            }
        }

        String getESVersion() {
            return this.esVersion;
        }

        void setTransportNode(String node) {
            this.transportNode = node;
        }

        String getTransportNode() {
            return this.transportNode;
        }
    }
}

