/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.BinaryString;
import com.mapr.cli.DbCommands;
import com.mapr.cli.DbReplicaCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.fs.AceHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Error;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.ojai.FieldPath;

public class DbIndexCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbReplicaCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String INDEX_PARAM_NAME = "index";
    private static final String INDEX_FIELD_PARAM_NAME = "indexedfields";
    private static final String NONINDEX_FIELD_PARAM_NAME = "includedfields";
    private static final String HASHED_INDEX_PARAM_NAME = "hashed";
    private static final String NUM_HASH_PARTITIONS_PARAM_NAME = "numhashpartitions";
    private static final String REFRESH_PARAM_NAME = "refreshnow";
    private static final String DETAILS_PARAM_NAME = "details";
    private static final int DEFAULT_NUM_HASH_PARTITIONS = 10;
    private static final String RESERVED_FIELD_FUNCTION_TIMESTAMP = "$timestamp";
    private static final CLICommand listCommand = new CLICommand("list", "usage: table index list -path <tablepath> -refreshnow <statsrefresh>", DbIndexCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"refreshnow", (Object)new BooleanInputParameter("refreshnow", "refreshnow", false, Boolean.valueOf(false))).put((Object)"details", (Object)new BooleanInputParameter("details", "refreshnow", false, Boolean.valueOf(false)).setInvisible(true)).build(), null).setShortUsage("table index list -path <tablepath>");
    private static final CLICommand addCommand = new CLICommand("add", "usage: table index add -path <tablePath> -index <indexName> -indexedfields '<fieldpath1:1, fieldpath2:-1, filedpath3>' [-includedfields 'fieldpath4, fieldpath5'] [-hashed <true | false, default = false>] [-numhashpartitions <numHashPartitions, default = 10 when 'hashed' = true>]", DbIndexCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "index name", true, null)).put((Object)"indexedfields", (Object)new TextInputParameter("indexedfields", "indexed field name", true, null)).put((Object)"includedfields", (Object)new TextInputParameter("includedfields", "included field name", false, null)).put((Object)"hashed", (Object)new BooleanInputParameter("hashed", "hashed index enabled", false, Boolean.valueOf(false))).put((Object)"numhashpartitions", (Object)new IntegerInputParameter("numhashpartitions", "number of hash index partitions when hashed index enabled", false, Integer.valueOf(10))).build(), null).setShortUsage("table index add -path <tablePath> -index <indexName>");
    private static final CLICommand removeCommand = new CLICommand("remove", "usage: table index remove -path <tablepath> -index <indexName>", DbIndexCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "index name", true, null)).build(), null).setShortUsage("table index remove -path <tablepath> -index <indexName>");
    private static final CLICommand editCommand = new CLICommand("edit", "usage: table index edit -path <tablePath> -index <indexName> -numhashpartitions <numberOfHashPartitions>", DbIndexCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "index name", true, null)).put((Object)"numhashpartitions", (Object)new TextInputParameter("numhashpartitions", "number of hash index partitions when hashed index enabled", true, null)).build(), null).setShortUsage("table index edit -path <tablePath> -index <indexName> -numhashpartitins <numHashPartitions>");
    public static final CLICommand indexCommands = new CLICommand("index", "index [add|remove|list]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCommand, removeCommand, listCommand}).setShortUsage("table index [add|remove|list]");

    public DbIndexCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cname = this.cliCommand.getCommandName();
        if (cname.equalsIgnoreCase(addCommand.getCommandName())) {
            this.addIndex(out);
        } else if (cname.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listIndex(out);
        } else if (cname.equalsIgnoreCase(removeCommand.getCommandName())) {
            this.removeIndex(out);
        }
        return output;
    }

    private String bytesToString(ByteString bstr) {
        return BinaryString.toStringBinary((byte[])bstr.toByteArray());
    }

    private ByteString stringToByteString(String raws) {
        byte[] bArr = BinaryString.toBytesBinary((String)raws);
        return ByteString.copyFrom((byte[])bArr);
    }

    public String entityName() {
        return "table";
    }

    protected void addIndex(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String indexName = this.getParamTextValue(INDEX_PARAM_NAME, 0);
        final String idxField = this.getParamTextValue(INDEX_FIELD_PARAM_NAME, 0);
        final String nonidxField = this.isParamPresent(NONINDEX_FIELD_PARAM_NAME) ? this.getParamTextValue(NONINDEX_FIELD_PARAM_NAME, 0) : null;
        final boolean isHashed = this.isParamPresent(HASHED_INDEX_PARAM_NAME) ? this.getParamBooleanValue(HASHED_INDEX_PARAM_NAME, 0) : false;
        final int numHashPartitions = this.isParamPresent(NUM_HASH_PARTITIONS_PARAM_NAME) ? this.getParamIntValue(NUM_HASH_PARTITIONS_PARAM_NAME, 0) : 10;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final DbIndexCommands dbPerm = this;
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    Path path;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (!mfs.isTable(path = new Path(tablePath))) {
                        throw new CLIProcessingException("Table not found. Path: " + tablePath);
                    }
                    TableProperties props = mfs.getTableProperties(path);
                    boolean isJson = props.getAttr().getJson();
                    DbIndexCommands.setupIndex(dbPerm, replBuilder, tablePath, indexName, idxField, nonidxField, isHashed, numHashPartitions, DbIndexCommands.this.getUserLoginId(), mfs);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    protected void removeIndex(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String indexName = this.getParamTextValue(INDEX_PARAM_NAME, 0);
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        DbIndexCommands dbPerm = this;
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        replBuilder.setReplicaClassName(Dbserver.DBInternalDefaults.getDefaultInstance().getReplicaClassNameForSIndex());
                        replBuilder.setSiInfo(Dbserver.SIndexInfo.newBuilder().setIndexName(indexName));
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Primary table not found. Path: " + tablePath);
                        }
                        mfs.removeTableReplica(new Path(tablePath), replDesc);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    protected void listIndex(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final boolean refreshNow = this.isParamPresent(REFRESH_PARAM_NAME) ? this.getParamBooleanValue(REFRESH_PARAM_NAME, 0) : false;
        boolean details = this.isParamPresent(DETAILS_PARAM_NAME) ? this.getParamBooleanValue(DETAILS_PARAM_NAME, 0) : false;
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        final ArrayList rlist = new ArrayList();
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        Dbserver.TableReplicaListResponse resp = mfs.listTableIndexes(new Path(tablePath), true, refreshNow);
                        rlist.add(resp);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
            boolean isJson = mfs.isJsonTable(new Path(tablePath));
            List<Dbserver.ColumnFamilyAttr> familyAttrs = DbReplicaCommands.getAllFamilies(tablePath, this.getUserLoginId());
            Dbserver.TableReplicaListResponse listResp = (Dbserver.TableReplicaListResponse)rlist.get(0);
            for (Dbserver.TableReplicaDesc rd : listResp.getReplicasList()) {
                CommandOutput.OutputHierarchy.OutputNode replNode = new CommandOutput.OutputHierarchy.OutputNode();
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)rd.getClusterName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)rd.getReplicaClassName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("indexFid", (Object)String.valueOf(rd.getSiInfo().getIndexFid().getCid() + "." + String.valueOf(rd.getSiInfo().getIndexFid().getCinum() + "." + String.valueOf(rd.getSiInfo().getIndexFid().getUniq())))));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("indexName", (Object)rd.getSiInfo().getIndexName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(HASHED_INDEX_PARAM_NAME, (Object)rd.getSiInfo().getHashed()));
                if (rd.getSiInfo().getHashed()) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numHashPartitions", rd.getSiInfo().getHashingInfo().getHashConfig(0).getNumPartitions()));
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("indexState", (Object)rd.getRstate().toString()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", rd.getIdx()));
                String Field2 = "";
                for (Dbserver.SIndexInfo.FieldInfo fi : rd.getSiInfo().getIndexedFieldsList()) {
                    FieldPath fp = null;
                    if (!fi.getUpdateTimestamp()) {
                        String[] cfQual = fi.getFieldPath(0).split(":", 2);
                        String famName = DbReplicaCommands.familyIdToName(familyAttrs, Integer.parseInt(cfQual[0]));
                        fp = MapRDBTableImplHelper.cfQualifierToJsonPath((String)famName, (String)cfQual[1], familyAttrs);
                    } else {
                        fp = FieldPath.parseFrom((String)fi.getFieldPath(0));
                    }
                    if (fi.getMapInfo().getType() == Dbserver.SIndexInfo.MappingType.NONE) {
                        Field2 = Field2 + (Field2.isEmpty() ? "" : ", ") + fp.asPathString(false) + (details ? "," + fi.getFieldPathIdx(0) : "") + ":" + fi.getSortOrder();
                        continue;
                    }
                    Field2 = Field2 + (Field2.isEmpty() ? "" : ", ") + "$" + fi.getMapInfo().getType() + " " + fp.asPathString(false) + " AS:" + fi.getMapInfo().getCastType() + (details ? "," + fi.getFieldPathIdx(0) : "") + ":" + fi.getSortOrder();
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("indxedFields", (Object)Field2));
                Field2 = "";
                if (rd.getSiInfo().getNonindexedFieldsCount() != 0) {
                    for (Dbserver.SIndexInfo.FieldInfo fi : rd.getSiInfo().getNonindexedFieldsList()) {
                        String[] cfQual = fi.getFieldPath(0).split(":", 2);
                        String famName = DbReplicaCommands.familyIdToName(familyAttrs, Integer.parseInt(cfQual[0]));
                        FieldPath fp = MapRDBTableImplHelper.cfQualifierToJsonPath((String)famName, (String)cfQual[1], familyAttrs);
                        Field2 = Field2 + (Field2.isEmpty() ? "" : ", ") + fp.asPathString(false) + (details ? "," + fi.getFieldPathIdx(0) : "");
                    }
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("includedFields", (Object)Field2));
                }
                long minPendingTS = 0L;
                long maxPendingTS = 0L;
                long bytesPending = 0L;
                long putsPending = 0L;
                int bucketsPending = 0;
                int asyncBuckets = 0;
                int copyTableCompletionPct = 0;
                ArrayList<Error.ExtendedError> elist = null;
                for (Dbserver.TableReplicaStatus rs : listResp.getReplicaStatusList()) {
                    if (rd.getIdx() != rs.getReplicaIdx()) continue;
                    minPendingTS = rs.getMinPendingTS();
                    maxPendingTS = rs.getMaxPendingTS();
                    bytesPending = rs.getBytesPending();
                    putsPending = rs.getPutsPending();
                    bucketsPending = rs.getBucketsPending();
                    asyncBuckets = rs.getAsyncBuckets();
                    copyTableCompletionPct = rs.getCopyTableCompletionPct();
                    for (Error.ExtendedError ee : rs.getEerrorsList()) {
                        if (elist == null) {
                            elist = new ArrayList<Error.ExtendedError>();
                        }
                        elist.add(ee);
                    }
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("isUptodate", (Object)(bucketsPending == 0 && !rd.getIsPaused() ? 1 : 0)));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("minPendingTS", minPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxPendingTS", maxPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bytesPending", bytesPending));
                if (this.entityName().equals("table")) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("putsPending", putsPending));
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketsPending", bucketsPending));
                byte[] uuid = rd.getTableUuid().toByteArray();
                if (uuid.length != 0) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString((byte[])uuid)));
                }
                if (rd.getRstate() == Dbserver.TableReplicaState.REPLICA_STATE_REPLICATING) {
                    copyTableCompletionPct = 100;
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("copyTableCompletionPercentage", copyTableCompletionPct));
                if (elist != null) {
                    for (Error.ExtendedError ee : elist) {
                        CommandOutput.OutputHierarchy.OutputNode errNodes = new CommandOutput.OutputHierarchy.OutputNode("errors");
                        replNode.addChild(errNodes);
                        if (ee.hasEcode()) {
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Code", (Object)ee.getEcode().name()));
                        }
                        if (ee.hasEhost()) {
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Host", (Object)Util.intToIp((int)ee.getEhost())));
                        }
                        if (!ee.hasEmsg()) continue;
                        errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Msg", (Object)ee.getEmsg()));
                    }
                }
                out.addNode(replNode);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static void setupIndex(AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder, String tablePath, String indexName, String idxField, String nonidxField, boolean isHashed, int numHashPartitions, String user, MapRFileSystem mfs) throws CLIProcessingException, IOException {
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(user);
        try {
            String[] fields;
            TableProperties tableProp = mfs.getTableProperties(new Path(tablePath));
            if (tableProp.getUuid() == null || tableProp.getUuid().length == 0) {
                throw new IOException("Table " + tablePath + " does not have a uuid. Set replperm and retry operation");
            }
            replBuilder.setReplicaClassName(Dbserver.DBInternalDefaults.getDefaultInstance().getReplicaClassNameForSIndex());
            Path tpath = new Path(tablePath);
            String clusterName = mfs.getClusterName(tpath.toUri());
            replBuilder.setClusterName(clusterName);
            replBuilder.setRstate(Dbserver.TableReplicaState.REPLICA_STATE_WAIT_TILL_BULKLOAD);
            Dbserver.SIndexInfo.Builder siBuilder = Dbserver.SIndexInfo.newBuilder();
            for (String field : fields = idxField.split(",")) {
                List familyAttrs;
                Dbserver.SIndexInfo.SIndexOrder od;
                String order;
                String fd = null;
                boolean indexUpdateTS = false;
                Dbserver.SIndexInfo.MappingInfo.Builder mInfo = null;
                try {
                    if (field.charAt(field.indexOf(34) + 1) != '$') {
                        fd = field.substring(field.indexOf(34) + 1, field.lastIndexOf(34));
                        mInfo = Dbserver.SIndexInfo.MappingInfo.newBuilder().setType(Dbserver.SIndexInfo.MappingType.NONE);
                    } else {
                        String systemField = field.substring(field.indexOf("$") + 1);
                        if (systemField.startsWith(RESERVED_FIELD_FUNCTION_TIMESTAMP)) {
                            fd = "$" + systemField.substring(0, systemField.indexOf(34)).trim();
                            indexUpdateTS = true;
                        } else {
                            String function;
                            switch (function = systemField.substring(0, systemField.indexOf("(")).trim()) {
                                case "CAST": {
                                    fd = field.substring(field.indexOf("(") + 1, field.indexOf("@")).trim();
                                    String castType = field.substring(field.indexOf("@") + 1, field.indexOf(")")).trim();
                                    Dbserver.SIndexInfo.CastType cType = null;
                                    switch (castType) {
                                        case "STRING": {
                                            cType = Dbserver.SIndexInfo.CastType.STRING;
                                            break;
                                        }
                                        case "INT": {
                                            cType = Dbserver.SIndexInfo.CastType.INT;
                                            break;
                                        }
                                        case "BOOLEAN": {
                                            cType = Dbserver.SIndexInfo.CastType.BOOLEAN;
                                            break;
                                        }
                                        case "DOUBLE": {
                                            cType = Dbserver.SIndexInfo.CastType.DOUBLE;
                                            break;
                                        }
                                        case "LONG": {
                                            cType = Dbserver.SIndexInfo.CastType.LONG;
                                            break;
                                        }
                                        case "FLOAT": {
                                            cType = Dbserver.SIndexInfo.CastType.FLOAT;
                                            break;
                                        }
                                        case "DATE": {
                                            cType = Dbserver.SIndexInfo.CastType.DATE;
                                            break;
                                        }
                                        case "TIME": {
                                            cType = Dbserver.SIndexInfo.CastType.TIME;
                                            break;
                                        }
                                        case "TIMESTAMP": {
                                            cType = Dbserver.SIndexInfo.CastType.TIMESTAMP;
                                            break;
                                        }
                                        case "SHORT": 
                                        case "BINARY": 
                                        case "INTERVAL": {
                                            throw new CLIProcessingException("Casting to " + castType + " is not supported");
                                        }
                                        default: {
                                            throw new CLIProcessingException("Invalid Cast type: " + castType);
                                        }
                                    }
                                    mInfo = Dbserver.SIndexInfo.MappingInfo.newBuilder().setType(Dbserver.SIndexInfo.MappingType.CAST).setCastType(cType);
                                    break;
                                }
                                default: {
                                    throw new CLIProcessingException("Index field in " + field + " is not valid");
                                }
                            }
                        }
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw new CLIProcessingException("Index Field in " + field + " not properly double quoted");
                }
                try {
                    order = field.substring(field.lastIndexOf(58) + 1).trim();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new CLIProcessingException("Index Order in" + field + "not properly given");
                }
                if (order.equals("-1")) {
                    od = Dbserver.SIndexInfo.SIndexOrder.DESC;
                } else if (order.equals("1") || order.equals(field)) {
                    od = Dbserver.SIndexInfo.SIndexOrder.ASC;
                } else {
                    throw new CLIProcessingException(field + "is not correctly formatted");
                }
                String finalPath = "";
                try {
                    familyAttrs = mfs.listColumnFamily(tpath, false);
                }
                catch (IOException e) {
                    throw new CLIProcessingException(e.getMessage());
                }
                Dbserver.Qualifier.Builder fpQualBuilder = null;
                if (!indexUpdateTS) {
                    String[] qual = MapRDBTableImplHelper.jsonPathToCfQualifier((String)fd, (List)familyAttrs).split(":", 2);
                    int cfId = 0;
                    Iterator iterator = familyAttrs.iterator();
                    while (iterator.hasNext()) {
                        Dbserver.ColumnFamilyAttr cf = (Dbserver.ColumnFamilyAttr)iterator.next();
                        if (!cf.getSchFamily().getName().equals(qual[0])) continue;
                        cfId = cf.getSchFamily().getId();
                        finalPath = Integer.toString(cfId) + ":" + qual[1];
                        break;
                    }
                    fpQualBuilder = Dbserver.Qualifier.newBuilder().setFamily(cfId).addQualifiers(ByteString.copyFromUtf8((String)qual[1]));
                } else {
                    finalPath = fd;
                }
                Dbserver.SIndexInfo.FieldInfo.Builder fieldInfo = Dbserver.SIndexInfo.FieldInfo.newBuilder();
                fieldInfo.addFieldPath(finalPath).setSortOrder(od).setUpdateTimestamp(indexUpdateTS);
                if (fpQualBuilder != null) {
                    fieldInfo.addFieldPathQualifier(fpQualBuilder);
                }
                if (mInfo != null) {
                    fieldInfo.setMapInfo(mInfo);
                }
                siBuilder.addIndexedFields(fieldInfo);
            }
            if (nonidxField != null) {
                for (String field : fields = nonidxField.split(",")) {
                    List familyAttrs;
                    String nonfield;
                    try {
                        nonfield = field.substring(field.indexOf(34) + 1, field.lastIndexOf(34));
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new CLIProcessingException("NonIndex Field in " + field + " are not properly double quoted");
                    }
                    String finalPath = "";
                    try {
                        familyAttrs = mfs.listColumnFamily(tpath, false);
                    }
                    catch (IOException e) {
                        throw new CLIProcessingException(e.getMessage());
                    }
                    String[] qual = MapRDBTableImplHelper.jsonPathToCfQualifier((String)nonfield, (List)familyAttrs).split(":", 2);
                    int cfId = 0;
                    for (Dbserver.ColumnFamilyAttr cf : familyAttrs) {
                        if (!cf.getSchFamily().getName().equals(qual[0])) continue;
                        cfId = cf.getSchFamily().getId();
                        finalPath = Integer.toString(cfId) + ":" + qual[1];
                        break;
                    }
                    Dbserver.Qualifier.Builder fpQualBuilder = Dbserver.Qualifier.newBuilder().setFamily(cfId).addQualifiers(ByteString.copyFromUtf8((String)qual[1]));
                    siBuilder.addNonindexedFields(Dbserver.SIndexInfo.FieldInfo.newBuilder().addFieldPath(finalPath).addFieldPathQualifier(fpQualBuilder));
                }
            }
            siBuilder.setHashed(isHashed);
            if (isHashed) {
                Fileserver.HashIndexInfo.HashConfig.Builder hashConfig = Fileserver.HashIndexInfo.HashConfig.newBuilder();
                hashConfig.setNumPartitions(numHashPartitions);
                Fileserver.HashIndexInfo.Builder hashInfo = Fileserver.HashIndexInfo.newBuilder();
                hashInfo.addHashConfig(hashConfig.build());
                hashInfo.setHashScheme(Fileserver.HashIndexInfo.Scheme.MURMUR_v2);
                siBuilder.setHashingInfo(hashInfo.build());
            }
            replBuilder.setSiInfo(siBuilder.setIndexName(indexName));
            Dbserver.TableReplicaDesc replDesc = replBuilder.build();
            mfs.addTableReplica(new Path(tablePath), replDesc, null);
            manager.moveToTop(tablePath);
        }
        catch (Exception e) {
            manager.deleteIfNotExist(tablePath, mfs);
            throw new CLIProcessingException(e.getMessage());
        }
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key)) {
                ret = this.getParamTextValue(key, 0);
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

