/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.DbGatewayCommands;
import com.mapr.cli.DbQueryServiceCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.util.MapRFSUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class ClusterCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String SETMODE_PARAM = "mode";
    private static final String FEATURE_NAME = "name";
    private static final String FEATURE_FORCE = "force";
    private static final String FEATURE_ENABLED = "enabled";
    private static final String FEATURE_DISABLED = "disabled";
    private static final String FEATURE_ALL = "all";
    private static final String MULTI_ARG_SEP = ",";
    private static final String GET_MINMAX_PARAM = "getminmax";
    public static final String centralConfigPath = "/var/mapr/configuration/default";
    public static final String versionFilePath = "/conf/hadoop_version";
    private static final String maprInstallPath = MapRCliUtil.getMapRInstallDir();
    private static final String hadoopVersionLocalFile = maprInstallPath + "/conf/hadoop_version";
    private static final String daemonConfFile = maprInstallPath + "/conf/daemon.conf";
    private static final String CLASSIC_VERSION_TOKEN = "classic_version";
    private static final String YARN_VERSION_TOKEN = "yarn_version";
    private static final String DEFAULT_MODE_TOKEN = "default_mode";
    private static final Logger LOG = Logger.getLogger(ClusterCommands.class);
    private static final CLICommand mapreduceGetAllVersionCommand = new CLICommand("getall", "Get MapReduce Version values", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("Shows the MapReduce version info").setUsageInVisible(true);
    private static final CLICommand mapreduceGetVersionCommand = new CLICommand("get", "Get Cluster wide MapReduce default mode", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("Shows the current cluster MapReduce default version");
    private static final CLICommand mapreduceSetVersionCommand = new CLICommand("set", "Set Cluster wide MapReduce default mode", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"mode", (Object)new TextInputParameter("mode", "Sets the default MapReduce default version <classic|yarn>", true, null)).build(), null);
    private static final CLICommand mapreduceCommands = new CLICommand("mapreduce", "Get or Set Cluster wide MapReduce defaults such as version", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{mapreduceGetAllVersionCommand, mapreduceGetVersionCommand, mapreduceSetVersionCommand});
    static final CLICommand featureEnableCommand = new CLICommand("enable", "usage: cluster feature enable [-name <feature name> | -force <true|false> | -all ]", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "feature name", false, null)).put((Object)"force", (Object)new BooleanInputParameter("force", "<true|false> true enables depedency features too", false, null)).put((Object)"all", (Object)new NoValueInputParameter("all", "all features", false, false)).build(), null).setShortUsage("Enables feature");
    static final CLICommand featureListCommand = new CLICommand("list", "usage: cluster feature list [ -name <featurename> -type <cldb|mfs> -state <enabled|disabled> -class <v2|v3> ]", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "feature name", false, null)).put((Object)"enabled", (Object)new NoValueInputParameter("enabled", "enabled features only", false, false)).put((Object)"disabled", (Object)new NoValueInputParameter("disabled", "disabled features only", false, false)).build(), null).setShortUsage("Lists features on the cluster");
    static String supportedMinMaxEntities;
    static final CLICommand infoCommand;
    public static final CLICommand featureCommand;
    public static final CLICommand clusterCommands;

    public ClusterCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(oh);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("set")) {
            String default_mode = this.getParamTextValue(SETMODE_PARAM, 0);
            if (!default_mode.equals("classic") && !default_mode.equals("yarn")) {
                LOG.error((Object)"Default MapReduce specified should be classic or yarn");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid value for Default Mapreduce Mode. It should be classic or yarn"));
                return output;
            }
            VersionFileContents newContents = this.setClusterDefaultMapReduceMode(default_mode);
            if (newContents != null) {
                this.addContentsToOutput(oh, newContents);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Unable to set Mapreduce Mode. Check maprcli/adminuiapp log for more details."));
            }
        } else if (cmd.equalsIgnoreCase("get")) {
            VersionFileContents contents = ClusterCommands.readHadoopVersionFile();
            if (contents != null) {
                this.addContentsToOutput(oh, contents);
            }
        } else if (cmd.equalsIgnoreCase("getall")) {
            VersionFileContents contents = ClusterCommands.readHadoopVersionFile();
            if (contents != null) {
                this.addAllContentsToOutput(oh, contents);
            }
        } else if (cmd.equalsIgnoreCase("enable")) {
            this.enableFeature(oh);
            LOG.error((Object)("enable: cluster feature " + cmd));
        } else if (cmd.equalsIgnoreCase("list")) {
            this.listFeatures(oh);
            LOG.error((Object)("list: cluster feature " + cmd));
        } else if (cmd.equalsIgnoreCase("info")) {
            this.processInfo(oh);
            LOG.error((Object)("info: " + cmd));
        }
        return output;
    }

    private void enableFeature(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        if (!this.isParamPresent(FEATURE_NAME) && !this.isParamPresent(FEATURE_ALL)) {
            oh.addMessage(this.getCommandUsage());
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "feature enable arguments missing. Pass either featurename or 'all'"));
            return;
        }
        if (this.isParamPresent(FEATURE_NAME) && this.isParamPresent(FEATURE_ALL)) {
            oh.addMessage(this.getCommandUsage());
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "feature enable arguments must not provide 'name' and 'all' together."));
            return;
        }
        boolean force = false;
        if (this.isParamPresent(FEATURE_FORCE)) {
            force = this.getParamBooleanValue(FEATURE_FORCE, 0);
        }
        CLDBProto.FeatureEnableRequest.Builder featureEnableReqBuilder = CLDBProto.FeatureEnableRequest.newBuilder().setCreds(this.getUserCredentials()).setForce(force);
        if (this.isParamPresent(FEATURE_NAME)) {
            String featureNames = this.getParamTextValue(FEATURE_NAME, 0);
            List<String> names = new ArrayList<String>();
            if (featureNames.contains(MULTI_ARG_SEP)) {
                names = Arrays.asList(featureNames.split(MULTI_ARG_SEP));
            } else {
                names.add(featureNames);
            }
            featureEnableReqBuilder.addAllFeatures(names);
        } else if (this.isParamPresent(FEATURE_ALL)) {
            featureEnableReqBuilder.addFeatures(FEATURE_ALL);
        }
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.FeatureEnableProc, (MessageLite)featureEnableReqBuilder.build(), oh);
        CLDBProto.FeatureEnableResponse resp = null;
        try {
            resp = CLDBProto.FeatureEnableResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing feature enable response."));
            LOG.error((Object)"Feature enable failed. Exception parsing feature enable response.", (Throwable)ipbe);
            return;
        }
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy toh = this.formatMaprFeatureInfoList(resp.getFeaturesList());
            for (CommandOutput.OutputHierarchy.OutputNode a : toh.getOutputNodes()) {
                oh.addNode(a);
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            LOG.error((Object)("Feature enable failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
        }
    }

    private void listFeatures(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.FeatureListRequest.Builder featureInfoRequestBuilder = CLDBProto.FeatureListRequest.newBuilder().setCreds(this.getUserCredentials());
        List<String> names = new ArrayList<String>();
        if (this.isParamPresent(FEATURE_NAME)) {
            String featureNames = this.getParamTextValue(FEATURE_NAME, 0);
            if (!featureNames.contains(MULTI_ARG_SEP)) {
                names.add(featureNames);
            } else {
                names = Arrays.asList(featureNames.split(MULTI_ARG_SEP));
            }
        } else {
            names.add(FEATURE_ALL);
        }
        featureInfoRequestBuilder.addAllFeatures(names);
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.FeatureListProc, (MessageLite)featureInfoRequestBuilder.build(), oh);
        CLDBProto.FeatureListResponse resp = null;
        try {
            resp = CLDBProto.FeatureListResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing feature list response."));
            LOG.error((Object)"Feature list failed. Exception parsing feature list response.", (Throwable)ipbe);
            return;
        }
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy toh = this.formatMaprFeatureInfoList(resp.getFeaturesList());
            for (CommandOutput.OutputHierarchy.OutputNode a : toh.getOutputNodes()) {
                oh.addNode(a);
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Feature list failed: " + resp.getErrMsg()));
            LOG.error((Object)("Feature list failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
        }
    }

    private CommandOutput.OutputHierarchy formatMaprFeatureInfoList(List<CLDBProto.MaprFeatureInfo> mfList) throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        for (CLDBProto.MaprFeatureInfo mf : mfList) {
            if (!(this.isParamPresent(FEATURE_ENABLED) && mf.getEnabled() || this.isParamPresent(FEATURE_DISABLED) && !mf.getEnabled()) && (this.isParamPresent(FEATURE_ENABLED) || this.isParamPresent(FEATURE_DISABLED))) continue;
            oh.addNode(this.formatMaprFeatureInfo(mf));
        }
        return oh;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatMaprFeatureInfo(CLDBProto.MaprFeatureInfo mf) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (mf.hasFeatureName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FEATURE_NAME, (Object)mf.getFeatureName()));
        }
        if (mf.hasEnabled()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FEATURE_ENABLED, (Object)mf.getEnabled()));
        }
        if (mf.hasDescription()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("description", (Object)mf.getDescription()));
        }
        if (mf.getDependenceInfoList().size() > 0) {
            CommandOutput.OutputHierarchy oh = this.formatMaprFeatureInfoList(mf.getDependenceInfoList());
            for (CommandOutput.OutputHierarchy.OutputNode a : oh.getOutputNodes()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("dependency", (Object)a));
            }
        }
        return out;
    }

    private byte[] sendRequestInternal(CLDBProto.CLDBProg procId, MessageLite req, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        byte[] data = null;
        Class<CLDBProto.FeatureEnableResponse> responseClass = null;
        switch (procId) {
            case FeatureEnableProc: {
                responseClass = CLDBProto.FeatureEnableResponse.class;
                break;
            }
            case FeatureListProc: {
                responseClass = CLDBProto.FeatureListResponse.class;
                break;
            }
            case GetMinMaxProc: {
                responseClass = CLDBProto.GetMinMaxResponse.class;
            }
        }
        if (responseClass == null) {
            LOG.error((Object)("Unknown procId for send request " + procId));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown procId for send request " + procId));
            return data;
        }
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), procId.getNumber(), req, responseClass) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), procId.getNumber(), req, responseClass);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        return data;
    }

    private Common.IPAddress buildIPFromString(String ipstr) {
        if (ipstr.equalsIgnoreCase("localhost") || ipstr.equalsIgnoreCase("127.0.0.1")) {
            ipstr = "127.0.0.1";
        } else {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(ipstr));
            if (ips.isEmpty()) {
                return null;
            }
            ipstr = ips.get(0);
        }
        int host = Util.ipToInt((String)ipstr);
        Common.IPAddress server = Common.IPAddress.newBuilder().setHost(host).build();
        return server;
    }

    private void addAllContentsToOutput(CommandOutput.OutputHierarchy oh, VersionFileContents contents) {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLASSIC_VERSION_TOKEN, (Object)contents.classic_version));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(YARN_VERSION_TOKEN, (Object)contents.yarn_version));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEFAULT_MODE_TOKEN, (Object)contents.default_mode));
        oh.addNode(node);
    }

    private void addContentsToOutput(CommandOutput.OutputHierarchy oh, VersionFileContents contents) {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEFAULT_MODE_TOKEN, (Object)contents.default_mode));
        String version = "";
        if (contents.default_mode != null) {
            version = contents.default_mode.equals("classic") ? contents.classic_version : contents.yarn_version;
        }
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("mapreduce_version", (Object)version));
        oh.addNode(node);
    }

    private VersionFileContents setClusterDefaultMapReduceMode(String defaultMode) {
        VersionFileContents contents = ClusterCommands.readHadoopVersionFile();
        if (contents == null) {
            LOG.error((Object)"Error while reading Local Hadoop Version file");
            return null;
        }
        contents.default_mode = defaultMode;
        if (this.writeHadoopVersionFile(contents)) {
            this.copyToCentralConfig();
            return contents;
        }
        return null;
    }

    private void copyToCentralConfig() {
        String mapr_group;
        String mapr_user;
        Path versionFileFSPath = new Path("/var/mapr/configuration/default/conf/hadoop_version");
        try {
            Properties userInfoProps = new Properties();
            userInfoProps.load(new BufferedInputStream(new FileInputStream(daemonConfFile)));
            mapr_user = userInfoProps.getProperty("mapr.daemon.user");
            mapr_group = userInfoProps.getProperty("mapr.daemon.group");
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while trying to open " + daemonConfFile), (Throwable)e);
            return;
        }
        try {
            boolean isPathCreated = MapRFSUtil.getMapRFileSystem().mkdirs(new Path("/var/mapr/configuration/default/conf"));
            if (isPathCreated) {
                MapRFSUtil.getMapRFileSystem().setOwner(new Path("/var/mapr/configuration/default/conf"), mapr_user, mapr_group);
                MapRFSUtil.getMapRFileSystem().delete(versionFileFSPath, false);
                MapRFSUtil.getMapRFileSystem().copyFromLocalFile(false, true, new Path(hadoopVersionLocalFile), versionFileFSPath);
                MapRFSUtil.getMapRFileSystem().setOwner(versionFileFSPath, mapr_user, mapr_group);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException while copying to Central config location /var/mapr/configuration/default", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeHadoopVersionFile(VersionFileContents contents) {
        if (contents == null || contents.classic_version == null || contents.yarn_version == null) {
            LOG.error((Object)("Malformed hadoop_version local file. Please check the contents of " + hadoopVersionLocalFile));
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(hadoopVersionLocalFile));
            bw.write("classic_version=" + contents.classic_version + "\n");
            bw.write("yarn_version=" + contents.yarn_version + "\n");
            bw.write("default_mode=" + contents.default_mode + "\n");
            bw.close();
        }
        catch (IOException e) {
            LOG.error((Object)("IOException while trying to write Hadoop version file " + hadoopVersionLocalFile), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionFileContents readHadoopVersionFile() {
        VersionFileContents contents = new VersionFileContents();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(hadoopVersionLocalFile));
            while ((line = br.readLine()) != null) {
                String[] tok = line.split("=");
                if (tok.length <= 1) continue;
                if (tok[0].equals(CLASSIC_VERSION_TOKEN)) {
                    contents.classic_version = tok[1];
                    continue;
                }
                if (tok[0].equals(YARN_VERSION_TOKEN)) {
                    contents.yarn_version = tok[1];
                    continue;
                }
                if (!tok[0].equals(DEFAULT_MODE_TOKEN)) continue;
                contents.default_mode = tok[1];
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IOException while trying to read Hadoop version file " + hadoopVersionLocalFile), (Throwable)e);
            VersionFileContents versionFileContents = null;
            return versionFileContents;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return contents;
    }

    private void processInfo(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        if (this.isParamPresent(GET_MINMAX_PARAM)) {
            this.processGetMinMax(oh);
        }
    }

    private void processGetMinMax(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.GetMinMaxRequest.Builder GetMinMaxRequestBuilder = CLDBProto.GetMinMaxRequest.newBuilder().setCreds(this.getUserCredentials());
        HashMap<String, CLDBProto.MinMaxAttributes> nameToEnumMap = new HashMap<String, CLDBProto.MinMaxAttributes>();
        for (CLDBProto.MinMaxAttributes attrib : CLDBProto.MinMaxAttributes.values()) {
            nameToEnumMap.put(attrib.name().toLowerCase(), attrib);
        }
        String entityName = this.getParamTextValue(GET_MINMAX_PARAM, 0);
        ArrayList<CLDBProto.MinMaxAttributes> attribs = new ArrayList<CLDBProto.MinMaxAttributes>();
        CLDBProto.MinMaxAttributes attrib = null;
        if (entityName.contains(MULTI_ARG_SEP)) {
            List<String> entityList = Arrays.asList(entityName.split(MULTI_ARG_SEP));
            Iterator<String> iterator = entityList.iterator();
            while (iterator.hasNext()) {
                String name;
                entityName = name = iterator.next();
                attrib = (CLDBProto.MinMaxAttributes)nameToEnumMap.get(name = name.toLowerCase());
                if (attrib != null) {
                    attribs.add(attrib);
                    continue;
                }
                break;
            }
        } else {
            String name = entityName.toLowerCase();
            attrib = (CLDBProto.MinMaxAttributes)nameToEnumMap.get(name);
            if (attrib != null) {
                attribs.add(attrib);
            }
        }
        if (attrib == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing entityName " + entityName));
            LOG.error((Object)("info getminmax failed. " + entityName + " is not a valid keyword."));
            return;
        }
        GetMinMaxRequestBuilder.addAllMinMaxAttribs(attribs);
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.GetMinMaxProc, (MessageLite)GetMinMaxRequestBuilder.build(), oh);
        CLDBProto.GetMinMaxResponse resp = null;
        try {
            resp = CLDBProto.GetMinMaxResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing info getminmax response."));
            LOG.error((Object)"info getminmax failed. Exception parsing info getminmax response.", (Throwable)ipbe);
            return;
        }
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy toh = this.formatMinMaxResponse(resp.getEntityList());
            for (CommandOutput.OutputHierarchy.OutputNode a : toh.getOutputNodes()) {
                oh.addNode(a);
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Feature list failed: " + resp.getErrMsg()));
            LOG.error((Object)("Feature list failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
        }
    }

    private CommandOutput.OutputHierarchy formatMinMaxResponse(List<CLDBProto.GetMinMaxResponse.MinMaxEntity> eList) throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        for (CLDBProto.GetMinMaxResponse.MinMaxEntity mf : eList) {
            oh.addNode(this.formatMinMaxEntity(mf));
        }
        return oh;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatMinMaxEntity(CLDBProto.GetMinMaxResponse.MinMaxEntity mf) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (mf.hasName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FEATURE_NAME, (Object)mf.getName()));
        }
        if (mf.hasMinVal()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("min", (Object)mf.getMinVal()));
        }
        if (mf.hasMaxVal()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("max", (Object)mf.getMaxVal()));
        }
        if (mf.hasUnit()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("unit", (Object)mf.getUnit()));
        }
        return out;
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.MinMaxAttributes attrib : CLDBProto.MinMaxAttributes.values()) {
            if (sb.length() == 0) {
                sb.append(attrib.name().toLowerCase());
                continue;
            }
            sb.append("|" + attrib.name().toLowerCase());
        }
        supportedMinMaxEntities = "[" + sb.toString() + "]";
        infoCommand = new CLICommand("info", "usage: cluster info getminmax <comma seperated list of entities>", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)GET_MINMAX_PARAM, (Object)new TextInputParameter(GET_MINMAX_PARAM, "list of entities to fetch min and max values from: " + supportedMinMaxEntities, true, null)).build(), null).setShortUsage("returns cluster wide min and max values for given list of comma seperated entities");
        featureCommand = new CLICommand("feature", "Enable or List features on the cluster", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{featureEnableCommand, featureListCommand});
        clusterCommands = new CLICommand("cluster", "cluster wide info such as mapreduce version", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{mapreduceCommands, DbGatewayCommands.gatewayCommands, featureCommand, infoCommand, DbQueryServiceCommands.queryServiceCommands}).setShortUsage("cluster [mapreduce [get|set] | gateway | feature [enable|list] | info getminmax]");
    }

    public static class VersionFileContents {
        String classic_version;
        String yarn_version;
        String default_mode;
    }
}

