/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLICommandFactory;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.util.zookeeper.ZKDataRetrieval;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class NodesCommonUtils {
    public static final String CLDB_SERVICE_MASTER_PATH = "/services/cldb/master";
    public static final String SERVER_PATH = "/servers";
    public static final String SERVICES_PATH = "/services";
    public static final String CONF_SERVICES_PATH = "/services_config";
    public static final String ZK_CONNECTSTRING = "zkconnect";
    public static final int TIMEOUT_SERVER = 30000;
    public static final String[] localAddresses = new String[]{"::1", "0:0:0:0:0:0:0:1", "127."};
    private static NodesCommonUtils s_instance = new NodesCommonUtils();
    private static Map<String, ZKDataRetrieval> zkMap = new ConcurrentHashMap<String, ZKDataRetrieval>();
    public static final Log LOG = LogFactory.getLog(NodesCommonUtils.class);

    private NodesCommonUtils() {
    }

    public static NodesCommonUtils getInstance() {
        return s_instance;
    }

    public static CommandOutput executeNodeListCommand(String[] args) throws CLIProcessingException {
        ProcessedInput input = new ProcessedInput(args);
        CLIInterface commandIFace = null;
        try {
            commandIFace = CLICommandFactory.getInstance().getCLI(input);
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)"Exception during search for command Interface", (Throwable)e);
            throw e;
        }
        if (commandIFace == null) {
            LOG.error((Object)("Could not find Interface for a command: " + input.getCommandName()));
            throw new CLIProcessingException("Could not find Interface for a command: " + input.getCommandName());
        }
        try {
            CommandOutput output = commandIFace.executeCommand();
            return output;
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)"Exception during command execution", (Throwable)e);
            throw e;
        }
    }

    public static String[] prepareParamsForNodeListCommand(String filter, String zkConnectString) {
        ArrayList<String> sb = new ArrayList<String>();
        sb.add("node");
        sb.add("list");
        if (zkConnectString != null) {
            sb.add("-zkconnect");
            sb.add(zkConnectString);
        }
        sb.add("-columns");
        sb.add("hn,ip");
        sb.add("-filter");
        sb.add(filter);
        return sb.toArray(new String[0]);
    }

    public static List<String> findNodeIps(String zkConnectString) {
        ZKDataRetrieval currentZK = zkMap.get(zkConnectString);
        if (currentZK == null) {
            NodesCommonUtils.connect(zkConnectString);
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            LOG.warn((Object)("Unable to get ZK based on: " + zkConnectString));
            return new ArrayList<String>();
        }
        return currentZK.getServersInfo();
    }

    @Deprecated
    public List<String> findNodeIps(ZooKeeper s_zk) {
        ArrayList<String> nodes = new ArrayList<String>();
        try {
            List znodes = s_zk.getChildren(SERVER_PATH, false);
            for (String znode : znodes) {
                byte[] znodeData = s_zk.getData("/servers/" + znode, false, null);
                String znodeName = new String(znodeData);
                nodes.add(znodeName);
            }
            return nodes;
        }
        catch (KeeperException e) {
            LOG.error((Object)("Cannot get children of /servers with error: " + e.getLocalizedMessage()));
            return null;
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Cannot get children of /servers with error: " + e.getLocalizedMessage()));
            return null;
        }
    }

    public static List<String> findFilteredNodeIps(String filter, String zkConnectString) throws CLIProcessingException {
        ArrayList<String> nodeHostNames = new ArrayList<String>();
        filter = filter.replace("*", ".*");
        String[] args = NodesCommonUtils.prepareParamsForNodeListCommand(filter, zkConnectString);
        CommandOutput coNodeList = NodesCommonUtils.executeNodeListCommand(args);
        List outNodes = coNodeList.getOutput().getOutputNodes();
        block0: for (CommandOutput.OutputHierarchy.OutputNode outNode : outNodes) {
            List children = outNode.getChildren();
            for (CommandOutput.OutputHierarchy.OutputNode childNode : children) {
                if (childNode.getValue() == null) continue;
                nodeHostNames.add((String)childNode.getValue());
                continue block0;
            }
        }
        return nodeHostNames;
    }

    public static List<String> convertHostToIp(List<String> nodeHostNames) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (String host : nodeHostNames) {
            try {
                InetAddress[] ias = InetAddress.getAllByName(host);
                if (ias == null) continue;
                for (InetAddress ia : ias) {
                    String ip = ia.getHostAddress();
                    boolean isLocalAddress = false;
                    for (String localIp : localAddresses) {
                        if (!ip.startsWith(localIp)) continue;
                        isLocalAddress = true;
                        break;
                    }
                    if (isLocalAddress) continue;
                    nodeNames.add(ip);
                }
            }
            catch (UnknownHostException e) {
                LOG.error((Object)("Can not find IP for host: " + host), (Throwable)e);
            }
        }
        return nodeNames;
    }

    public static List<String> convertHostToIpIncludingLocal(List<String> nodeHostNames) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (String host : nodeHostNames) {
            try {
                InetAddress[] ias = InetAddress.getAllByName(host);
                if (ias == null) continue;
                for (InetAddress ia : ias) {
                    String ip = ia.getHostAddress();
                    nodeNames.add(ip);
                }
            }
            catch (UnknownHostException e) {
                LOG.error((Object)("Can not find IP for host: " + host), (Throwable)e);
            }
        }
        return nodeNames;
    }

    public static List<String> convertIpToHost(List<String> nodeIpNames) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (String host : nodeIpNames) {
            try {
                InetAddress[] ias = InetAddress.getAllByName(host);
                if (ias == null) continue;
                for (InetAddress ia : ias) {
                    String ip = ia.getCanonicalHostName();
                    nodeNames.add(ip);
                }
            }
            catch (UnknownHostException e) {
                LOG.error((Object)("Can not find host for IP: " + host), (Throwable)e);
            }
        }
        return nodeNames;
    }

    public static Common.ServiceData getServiceMasterData(String zkConnectString, String serviceName) {
        ZKDataRetrieval currentZK = zkMap.get(zkConnectString);
        if (currentZK == null) {
            NodesCommonUtils.connect(zkConnectString);
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            LOG.warn((Object)("Unable to get ZK based on: " + zkConnectString));
            return null;
        }
        Common.ServiceData data = (Common.ServiceData)currentZK.getServiceToMasterMap().get(serviceName);
        if (data == null && "fileserver".equalsIgnoreCase(serviceName)) {
            return (Common.ServiceData)currentZK.getServiceToMasterMap().get("kvstore");
        }
        return data;
    }

    public static boolean isServiceAvailable(String zkConnectString, String serviceName) {
        Common.ServiceData hostInfo = NodesCommonUtils.getServiceMasterData(zkConnectString, serviceName);
        return hostInfo != null && hostInfo.hasIsRunning() && hostInfo.getIsRunning();
    }

    public static Map<String, Common.ServiceData> getServiceNodeData(String zkConnectString, String serviceName) {
        ZKDataRetrieval currentZK = zkMap.get(zkConnectString);
        if (currentZK == null) {
            NodesCommonUtils.connect(zkConnectString);
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            LOG.warn((Object)("Unable to get ZK based on: " + zkConnectString));
            return null;
        }
        Map nodesData = (Map)currentZK.getServiceToNodeMap().get(serviceName);
        if ("fileserver".equalsIgnoreCase(serviceName)) {
            if (nodesData != null) {
                nodesData.putAll((Map)currentZK.getServiceToNodeMap().get("kvstore"));
            } else {
                return (Map)currentZK.getServiceToNodeMap().get("kvstore");
            }
        }
        return nodesData;
    }

    public static Map<String, Properties> getServiceNodesProperties(String zkConnectString, String serviceName) {
        ZKDataRetrieval currentZK = zkMap.get(zkConnectString);
        if (currentZK == null) {
            NodesCommonUtils.connect(zkConnectString);
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            LOG.warn((Object)("Unable to get ZK based on: " + zkConnectString));
            return null;
        }
        Map servicePropsMap = (Map)currentZK.getServiceToPropertiesMap().get(serviceName);
        if ("fileserver".equalsIgnoreCase(serviceName)) {
            Map servicePropsMapKv = (Map)currentZK.getServiceToPropertiesMap().get("kvstore");
            if (servicePropsMap == null) {
                return servicePropsMapKv;
            }
            if (servicePropsMapKv != null) {
                servicePropsMap.putAll(servicePropsMapKv);
                return servicePropsMap;
            }
        }
        return servicePropsMap;
    }

    public static Map<String, List<String>> serviceToNodesMap(String zkConnectString) throws CLIProcessingException {
        ZKDataRetrieval currentZK;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"serviceToNodesMap start");
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            NodesCommonUtils.connect(zkConnectString);
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            LOG.warn((Object)("Unable to get ZK based on: " + zkConnectString));
            return new HashMap<String, List<String>>();
        }
        Map servicesMap = currentZK.getServicesMap();
        return servicesMap;
    }

    public static Map<String, List<String>> findServicesRunningHierarchy(String zkConnectString) throws CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findServicesRunningHierarchy start");
        }
        LOG.error((Object)"findServicesRunningHierarchy start");
        ZKDataRetrieval currentZK = zkMap.get(zkConnectString);
        if (currentZK == null) {
            NodesCommonUtils.connect(zkConnectString);
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            LOG.warn((Object)("Unable to get ZK based on: " + zkConnectString));
            return new HashMap<String, List<String>>();
        }
        Map servicesMap = currentZK.getServicesMap();
        HashMap<String, List<String>> nodeToServiceMap = new HashMap<String, List<String>>();
        for (Map.Entry entry : servicesMap.entrySet()) {
            String service = (String)entry.getKey();
            LOG.error((Object)("service " + service));
            List nodes = (List)entry.getValue();
            for (String node : nodes) {
                LOG.error((Object)("node " + node));
                if (!nodeToServiceMap.containsKey(node)) {
                    nodeToServiceMap.put(node, new ArrayList());
                }
                if ("kvstore".equalsIgnoreCase(service)) {
                    service = "fileserver";
                }
                ((List)nodeToServiceMap.get(node)).add(service);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findServicesRunningHierarchy end");
        }
        return nodeToServiceMap;
    }

    public static Map<String, List<String>> findServicesConfiguredHierarchy(String zkConnectString) throws CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findServicesConfiguredHierarchy start");
        }
        LOG.error((Object)"findServicesConfiguredHierarchy start");
        ZKDataRetrieval currentZK = zkMap.get(zkConnectString);
        if (currentZK == null) {
            NodesCommonUtils.connect(zkConnectString);
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            LOG.warn((Object)("Unable to get ZK based on: " + zkConnectString));
            return new HashMap<String, List<String>>();
        }
        Map configServicesMap = currentZK.getConfigServicesMap();
        HashMap<String, List<String>> nodeToConfigServicesMap = new HashMap<String, List<String>>();
        for (Map.Entry entry : configServicesMap.entrySet()) {
            String service = (String)entry.getKey();
            LOG.error((Object)("service " + service));
            List nodes = (List)entry.getValue();
            for (String node : nodes) {
                LOG.error((Object)("nodes " + nodes));
                if (!nodeToConfigServicesMap.containsKey(node)) {
                    nodeToConfigServicesMap.put(node, new ArrayList());
                }
                if ("kvstore".equalsIgnoreCase(service)) {
                    service = "fileserver";
                }
                ((List)nodeToConfigServicesMap.get(node)).add(service);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findServicesConfiguredHierarchy end");
        }
        return nodeToConfigServicesMap;
    }

    @Deprecated
    public static Map<String, List<String>> findServicesRunningHierarchy(ZooKeeper s_zk) throws CLIProcessingException {
        HashMap<String, List<String>> servicesMap = new HashMap<String, List<String>>();
        try {
            if (s_zk == null) {
                return servicesMap;
            }
            Stat stats = s_zk.exists(SERVICES_PATH, false);
            if (stats == null) {
                return servicesMap;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Start s_zk.getChildren: /services");
            }
            List services = s_zk.getChildren(SERVICES_PATH, false);
            for (String service : services) {
                List nodes = s_zk.getChildren("/services/" + service, false);
                for (String node : nodes) {
                    if ("master".equalsIgnoreCase(node)) continue;
                    if (!servicesMap.containsKey(node)) {
                        servicesMap.put(node, new ArrayList());
                    }
                    if ("kvstore".equalsIgnoreCase(service)) {
                        service = "fileserver";
                    }
                    ((List)servicesMap.get(node)).add(service);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"End s_zk.getChildren: /services");
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)"ZooKeeper Exception while trying to get running services", (Throwable)e);
            throw new CLIProcessingException("ZooKeeper Exception while trying to get running services", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Interrupted Exception while trying to get running services on node", (Throwable)e);
            throw new CLIProcessingException("Interrupted Exception while trying to get running services on node", (Throwable)e);
        }
        return servicesMap;
    }

    @Deprecated
    public static Map<String, List<String>> findConfiguredServicesHierarchy(ZooKeeper s_zk) throws CLIProcessingException {
        HashMap<String, List<String>> servicesMap = new HashMap<String, List<String>>();
        try {
            if (s_zk == null) {
                return servicesMap;
            }
            Stat stats = s_zk.exists(CONF_SERVICES_PATH, false);
            if (stats == null) {
                return servicesMap;
            }
            List services = s_zk.getChildren(CONF_SERVICES_PATH, false);
            for (String service : services) {
                List nodes = s_zk.getChildren("/services_config/" + service, false);
                for (String node : nodes) {
                    if (!servicesMap.containsKey(node)) {
                        servicesMap.put(node, new ArrayList());
                    }
                    if ("kvstore".equalsIgnoreCase(service)) {
                        service = "fileserver";
                    }
                    ((List)servicesMap.get(node)).add(service);
                }
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)"ZooKeeper Exception while trying to get running services", (Throwable)e);
            throw new CLIProcessingException("ZooKeeper Exception while trying to get configured services", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Interrupted Exception while trying to get running services on node", (Throwable)e);
            throw new CLIProcessingException("Interrupted Exception while trying to get configured services on node", (Throwable)e);
        }
        return servicesMap;
    }

    public static Map<String, List<String>> findConfiguredServicesByServiceHierarchy(String zkConnectString) throws CLIProcessingException {
        ZKDataRetrieval currentZK;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findConfiguredServicesByServiceHierarchy start");
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            NodesCommonUtils.connect(zkConnectString);
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            LOG.warn((Object)("Unable to get ZK based on: " + zkConnectString));
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> serviceToNode = new HashMap<String, List<String>>();
        Map configMap = currentZK.getConfigServicesMap();
        for (Map.Entry entry : configMap.entrySet()) {
            String service = (String)entry.getKey();
            ArrayList nodes = new ArrayList((Collection)entry.getValue());
            if (service.equalsIgnoreCase("kvstore")) {
                service = "fileserver";
            }
            if (serviceToNode.containsKey(service)) {
                ((List)serviceToNode.get(service)).addAll(nodes);
                continue;
            }
            serviceToNode.put(service, nodes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"findConfiguredServicesByServiceHierarchy end");
        }
        return serviceToNode;
    }

    @Deprecated
    public static Map<String, List<String>> findConfiguredServicesByServiceHierarchy(ZooKeeper s_zk) throws CLIProcessingException {
        HashMap<String, List<String>> servicesMap = new HashMap<String, List<String>>();
        try {
            if (s_zk == null) {
                return servicesMap;
            }
            Stat stats = s_zk.exists(CONF_SERVICES_PATH, false);
            if (stats == null) {
                return servicesMap;
            }
            List services = s_zk.getChildren(CONF_SERVICES_PATH, false);
            for (String service : services) {
                List nodes = s_zk.getChildren("/services_config/" + service, false);
                if ("kvstore".equalsIgnoreCase(service)) {
                    service = "fileserver";
                }
                if (servicesMap.containsKey(service)) {
                    ((List)servicesMap.get(service)).addAll(nodes);
                    continue;
                }
                servicesMap.put(service, nodes);
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)"ZooKeeper Exception while trying to get running services", (Throwable)e);
            throw new CLIProcessingException("ZooKeeper Exception while trying to get configured services", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Interrupted Exception while trying to get running services on node", (Throwable)e);
            throw new CLIProcessingException("Interrupted Exception while trying to get configured services on node", (Throwable)e);
        }
        return servicesMap;
    }

    public static synchronized ZooKeeper connect(String zkConnectString) {
        ZKDataRetrieval zkHolder;
        ZKDataRetrieval currentZK = zkMap.get(zkConnectString);
        if (currentZK != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Got cached ZK for: " + zkConnectString));
            }
            return currentZK.getZKObject();
        }
        YarnConfiguration yarnconf = new YarnConfiguration();
        if (HAUtil.isHAEnabled((Configuration)yarnconf)) {
            String zkBasePath = yarnconf.get("yarn.resourcemanager.ha.automatic-failover.zk-base-path", "/yarn-leader-election");
            String rmHAZNode = zkBasePath + "/" + YarnConfiguration.getClusterId((Configuration)yarnconf) + "/ActiveStandbyElectorLock";
            zkHolder = new ZKDataRetrieval(zkConnectString, rmHAZNode);
        } else {
            zkHolder = new ZKDataRetrieval(zkConnectString);
        }
        zkMap.put(zkConnectString, zkHolder);
        return zkHolder.getZKObject();
    }

    public static String getCurrentRMMasterID(String zkConnectString) {
        ZKDataRetrieval currentZK;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getCurrentRMMasterID start");
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            NodesCommonUtils.connect(zkConnectString);
        }
        if ((currentZK = zkMap.get(zkConnectString)) == null) {
            LOG.warn((Object)("Unable to get ZK based on: " + zkConnectString));
            return null;
        }
        byte[] data = currentZK.getActiveRMZNodeData();
        if (data != null) {
            YarnServerResourceManagerServiceProtos.ActiveRMInfoProto proto;
            try {
                proto = YarnServerResourceManagerServiceProtos.ActiveRMInfoProto.parseFrom((byte[])data);
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error((Object)("Invalid data in ZK: " + data.toString()));
                return null;
            }
            return proto.getRmId();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getCurrentRMMasterID end");
        }
        LOG.error((Object)"Unable to get Current RM Master ID from ZK");
        return null;
    }

    public static CLDBProto.FileServerInfo getFileServerInfo(Common.IPAddress server, Security.CredentialsMsg creds, String cluster) throws CLIProcessingException {
        CLDBProto.FileServerLookupRequest req = CLDBProto.FileServerLookupRequest.newBuilder().setFileServerIP(server).setCreds(creds).build();
        CLDBProto.FileServerLookupResponse resp = null;
        byte[] data = null;
        try {
            data = cluster != null && !cluster.isEmpty() ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerLookupProc.getNumber(), (MessageLite)req, CLDBProto.FileServerLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerLookupProc.getNumber(), (MessageLite)req, CLDBProto.FileServerLookupResponse.class);
            if (data == null) {
                LOG.error((Object)("FileServerLookup RPC to CLDB failed for IP " + Util.printIPAddressForCLI((Common.IPAddress)server)));
                return null;
            }
            resp = CLDBProto.FileServerLookupResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                return resp.getFileServerInfo();
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception during FileServerLookup RPC to CLDB " + e.getLocalizedMessage()));
            return null;
        }
        return null;
    }
}

