/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.VolumeCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class VolumeTierCommands
extends CLIBaseClass
implements CLIInterface {
    public static final String VOLUME_PARAM_NAME = "name";
    public static final String TRIGGER_NOW_PARAM_NAME = "triggernow";
    public static final String IGNORE_RULE_PARAM_NAME = "ignorerule";
    public static final String IGNORE_RECALL_EXPIRY_PARAM_NAME = "ignorerecallexpiry";
    public static final String VERBOSE_STATUS = "verbose";
    private static final int GW_ASSIGN_NUM_POLLS = 3;
    private static final int GW_ASSIGN_WAIT_TIME = 10;
    private static final Logger LOG = Logger.getLogger(VolumeTierCommands.class);
    public static final String offloadUsage = "volume offload -name volname [-ignorerule <true|false>] [-ignoreexpiry <true|false>] [-cluster clustername]";
    public static final String recallUsage = "volume recall -name volname [-cluster clustername]";
    public static final String compactionUsage = "volume compaction -name volname [-cluster clustername]";
    public static final String abortUsage = "volume tierjobabort -name volname [-cluster clustername]";
    public static final String tierjobstatusUsage = "volume tierjobstatus -name volname [-cluster clustername]";
    public static final String tierStatsUsage = "volume tierstats -name volname [-cluster clustername]";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static final CLICommand offloadCommand = new CLICommand("offload", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"ignorerule", (Object)new BooleanInputParameter("ignorerule", "<true|false>", false, Boolean.valueOf(false))).put((Object)"ignorerecallexpiry", (Object)new BooleanInputParameter("ignorerecallexpiry", "<true|false>", false, Boolean.valueOf(false))).build(), null).setShortUsage("volume offload -name volname [-ignorerule <true|false>] [-ignoreexpiry <true|false>] [-cluster clustername]");
    public static final CLICommand recallCommand = new CLICommand("recall", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("volume recall -name volname [-cluster clustername]");
    public static final CLICommand compactionCommand = new CLICommand("compaction", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("volume compaction -name volname [-cluster clustername]");
    public static final CLICommand tierjobstatusCommand = new CLICommand("tierjobstatus", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"verbose", (Object)new BooleanInputParameter("verbose", "<true|false>", false, Boolean.valueOf(false)).setInvisible(true)).build(), null).setShortUsage("volume tierjobstatus -name volname [-cluster clustername]");
    public static final CLICommand tierStatsCommand = new CLICommand("tierstats", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("volume tierstats -name volname [-cluster clustername]");
    public static final CLICommand abortCommand = new CLICommand("tierjobabort", "", VolumeTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("volume tierjobabort -name volname [-cluster clustername]");

    public VolumeTierCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse resp;
        String cluster = null;
        String volumeName = null;
        Object credentials = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ExecuteRealCommand" + this.cliCommand.getCommandName()));
        }
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if (this.isParamPresent(VOLUME_PARAM_NAME)) {
            volumeName = this.getParamTextValue(VOLUME_PARAM_NAME, 0);
        }
        if ((resp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), volumeName, null, this.isServerCall)).hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume " + volumeName + " does not exist in cluster"));
            return output;
        }
        int volumeId = resp.getVolInfo().getVolumeId();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("offload")) {
            try {
                boolean ignoreRule = false;
                boolean triggerNow = true;
                boolean ignoreRecallExpiry = false;
                if (this.isParamPresent(IGNORE_RULE_PARAM_NAME)) {
                    ignoreRule = this.getParamBooleanValue(IGNORE_RULE_PARAM_NAME, 0);
                }
                if (this.isParamPresent(IGNORE_RECALL_EXPIRY_PARAM_NAME)) {
                    ignoreRecallExpiry = this.getParamBooleanValue(IGNORE_RECALL_EXPIRY_PARAM_NAME, 0);
                }
                this.offloadVolume(out, cluster, volumeId, ignoreRule, ignoreRecallExpiry, triggerNow);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Offload Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("recall")) {
            try {
                this.recallVolume(out, cluster, volumeId);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Recall Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("compaction")) {
            try {
                this.compactVolume(out, cluster, volumeId);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Recall Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("tierjobabort")) {
            try {
                this.abortVolume(out, cluster, volumeId);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Abort Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("tierjobstatus")) {
            boolean verbose = false;
            if (this.isParamPresent(VERBOSE_STATUS)) {
                verbose = this.getParamBooleanValue(VERBOSE_STATUS, 0);
            }
            try {
                this.tierjobstatus(out, cluster, volumeId, resp.getVolInfo().getVolProperties(), verbose);
            }
            catch (Exception e) {
                throw new CLIProcessingException("tierjobstatus Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("tierstats")) {
            try {
                this.tierStats(out, cluster, volumeId);
            }
            catch (Exception e) {
                throw new CLIProcessingException("tierStats Exception", (Throwable)e);
            }
        }
        return output;
    }

    private boolean isRetriableOffloadError(int error) {
        return error == 11 || error == 110 || error == 101 || error == 100 || error == 104 || error == 138;
    }

    private void offloadVolume(CommandOutput.OutputHierarchy out, String cluster, int volumeId, boolean ignoreRule, boolean ignoreRecallExpiry, boolean triggerNow) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        resp = this.sendVolumeTierOp(out, cluster, volumeId, CLDBProto.VolumeTierOp.OFFLOAD, ignoreRule, ignoreRecallExpiry, triggerNow, false, true);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully started offload.");
        } else {
            String errMsg = this.printCommandError(out, resp);
            LOG.error((Object)("Start volume offload for " + volumeId + " Failed. " + errMsg));
        }
    }

    private void recallVolume(CommandOutput.OutputHierarchy out, String cluster, int volumeId) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        resp = this.sendVolumeTierOp(out, cluster, volumeId, CLDBProto.VolumeTierOp.RECALL, true, true, true, false, true);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully started recall.");
        } else {
            String errMsg = this.printCommandError(out, resp);
            LOG.error((Object)("Start volume recall for " + volumeId + " Failed. " + errMsg));
        }
    }

    private void compactVolume(CommandOutput.OutputHierarchy out, String cluster, int volumeId) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        resp = this.sendVolumeTierOp(out, cluster, volumeId, CLDBProto.VolumeTierOp.COMPACTION, true, true, true, false);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully started compaction.");
        } else {
            String errMsg = this.printCommandError(out, resp);
            LOG.error((Object)("Start volume compaction for " + volumeId + " Failed. " + errMsg));
        }
    }

    private void abortVolume(CommandOutput.OutputHierarchy out, String cluster, int volumeId) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        resp = this.sendVolumeTierOp(out, cluster, volumeId, CLDBProto.VolumeTierOp.OFFLOAD, false, false, false, true, false);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully started abort.");
        } else {
            String errMsg = this.printCommandError(out, resp);
            LOG.error((Object)("Start volume abort for " + volumeId + " Failed. " + errMsg));
        }
    }

    private static String printIPAddresses(List<Common.IPAddress> ips) {
        StringBuilder sb = new StringBuilder();
        for (Common.IPAddress ip : ips) {
            sb.append(Util.intToIp((int)ip.getHost()));
            sb.append(":");
            sb.append(ip.getPort());
            sb.append(";");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void tierjobstatus(CommandOutput.OutputHierarchy out, String cluster, int volumeId, CLDBProto.VolumeProperties volProps, boolean verbose) throws CLIProcessingException {
        String timeStamp;
        SimpleDateFormat dateFormat;
        if (!volProps.hasIsTierOffloadEnable() || !volProps.getIsTierOffloadEnable()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tier offload not enabled for given volume"));
            return;
        }
        CLDBProto.GetTierJobStatusResponse resp = null;
        CLDBProto.GetTierJobStatusRequest.Builder req = CLDBProto.GetTierJobStatusRequest.newBuilder();
        req.setVolId(volumeId);
        req.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetTierJobStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.GetTierJobStatusResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetTierJobStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.GetTierJobStatusResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.GetTierJobStatusResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            if (resp.getStatus() == 2) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "No active jobs for given volume"));
                return;
            }
            String errMsg = Errno.toString(resp.getStatus());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Getting tier status failed. " + errMsg));
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode tierJobParent = new CommandOutput.OutputHierarchy.OutputNode();
        CommandOutput.OutputHierarchy.OutputNode tierJobNode = null;
        if (resp.hasOTask()) {
            String opType = resp.getOTask().getOp() == CLDBProto.VolumeTierOp.OFFLOAD ? "offload" : (resp.getOTask().getOp() == CLDBProto.VolumeTierOp.RECALL ? "recall" : (resp.getOTask().getOp() == CLDBProto.VolumeTierOp.VOLUME_DELETE ? "volumedelete" : "unknown"));
            tierJobNode = new CommandOutput.OutputHierarchy.OutputNode(opType);
            String stateStr = null;
            stateStr = resp.getOTask().getState() == CLDBProto.OffloadTaskState.OFFLOAD_INIT ? "Scheduled" : (resp.getOTask().getState() == CLDBProto.OffloadTaskState.OFFLOAD_START ? "Running" : (resp.getOTask().getState() == CLDBProto.OffloadTaskState.OFFLOAD_END ? "Success" : (resp.getOTask().getState() == CLDBProto.OffloadTaskState.OFFLOAD_FAIL ? (this.isRetriableOffloadError(resp.getOTask().getStatus()) ? "FailureRetry, RetryCount: " + resp.getOTask().getNRetry() : "FailureFatal") : (resp.getOTask().getState() == CLDBProto.OffloadTaskState.OFFLOAD_ABORT_START ? "AbortInProgress" : (resp.getOTask().getState() == CLDBProto.OffloadTaskState.OFFLOAD_ABORT_END ? "Aborted" : "Unknown state")))));
            if (resp.getOTask().getState() == CLDBProto.OffloadTaskState.OFFLOAD_FAIL && resp.getOTask().getStatus() == 4) {
                stateStr = "AbortedInternal";
            }
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("state", (Object)stateStr));
            if (resp.hasVolTierStats() && resp.getOTask().getState() != CLDBProto.OffloadTaskState.OFFLOAD_INIT && resp.getOTask().getIpsCount() > 0) {
                if (resp.getVolTierStats().hasJobProgressInPercentage()) {
                    tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("progress", (Object)(Long.toString(resp.getVolTierStats().getJobProgressInPercentage()) + "%")));
                } else {
                    tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("progress", (Object)"0%"));
                }
            }
            if (resp.getOTask().hasStartTime()) {
                String timeStr = null;
                timeStr = resp.getOTask().getState() == CLDBProto.OffloadTaskState.OFFLOAD_INIT ? "scheduleTime" : "startTime";
                SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
                dateFormat2.setTimeZone(TimeZone.getDefault());
                String timeStamp2 = dateFormat2.format(new Date(resp.getOTask().getStartTime()));
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(timeStr, (Object)timeStamp2));
            }
            if (resp.getOTask().hasEndTime()) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
                dateFormat.setTimeZone(TimeZone.getDefault());
                timeStamp = dateFormat.format(new Date(resp.getOTask().getEndTime()));
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("endTime", (Object)timeStamp));
            }
            if (resp.getOTask().getIpsCount() > 0) {
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)VolumeTierCommands.printIPAddresses(resp.getOTask().getIpsList())));
            } else {
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)"Currently down"));
            }
            tierJobParent.addChild(tierJobNode);
        }
        if (resp.hasCTask() && verbose) {
            tierJobNode = new CommandOutput.OutputHierarchy.OutputNode("compaction");
            String stateStr = null;
            stateStr = resp.getCTask().getState() == CLDBProto.CompactionTaskState.COMPACTION_INIT ? "Scheduled" : (resp.getCTask().getState() == CLDBProto.CompactionTaskState.COMPACTION_START ? "Running" : (resp.getCTask().getState() == CLDBProto.CompactionTaskState.COMPACTION_END ? "Success" : (resp.getCTask().getState() == CLDBProto.CompactionTaskState.COMPACTION_FAIL ? (this.isRetriableOffloadError(resp.getCTask().getStatus()) ? "FailureRetry, RetryCount: " + resp.getCTask().getNRetry() : "FailureFatal") : (resp.getCTask().getState() == CLDBProto.CompactionTaskState.COMPACTION_ABORT_START ? "AbortInProgress" : (resp.getCTask().getState() == CLDBProto.CompactionTaskState.COMPACTION_ABORT_END ? "Aborted" : "Unknown state")))));
            tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("state", (Object)stateStr));
            if (resp.getCTask().hasStartTime()) {
                String timeStr = null;
                timeStr = resp.getCTask().getState() == CLDBProto.CompactionTaskState.COMPACTION_INIT ? "scheduleTime" : "startTime";
                dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS 'GMT'Z");
                dateFormat.setTimeZone(TimeZone.getDefault());
                timeStamp = dateFormat.format(new Date(resp.getCTask().getStartTime()));
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(timeStr, (Object)timeStamp));
            }
            if (resp.getCTask().hasEndTime()) {
                SimpleDateFormat dateFormat3 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS 'GMT'Z");
                dateFormat3.setTimeZone(TimeZone.getDefault());
                String timeStamp3 = dateFormat3.format(new Date(resp.getCTask().getEndTime()));
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("endTime", (Object)timeStamp3));
            }
            if (resp.getCTask().getIpsCount() > 0) {
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)VolumeTierCommands.printIPAddresses(resp.getCTask().getIpsList())));
            } else {
                tierJobNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)"Currently down"));
            }
            tierJobParent.addChild(tierJobNode);
        }
        out.addNode(tierJobParent);
    }

    private String toMBSizeStr(long sizeinBytes) {
        if (sizeinBytes == 0L) {
            return "0";
        }
        DecimalFormat df = new DecimalFormat(".###");
        return df.format((double)sizeinBytes / 1048576.0);
    }

    private void tierStats(CommandOutput.OutputHierarchy out, String cluster, int volumeId) throws CLIProcessingException {
        CLDBProto.GetVolumeTierStatsResponse resp = null;
        CLDBProto.GetVolumeTierStatsRequest req = CLDBProto.GetVolumeTierStatsRequest.newBuilder().setVolId(volumeId).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetVolumeTierStatsProc.getNumber(), (MessageLite)req, CLDBProto.GetVolumeTierStatsResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetVolumeTierStatsProc.getNumber(), (MessageLite)req, CLDBProto.GetVolumeTierStatsResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.GetVolumeTierStatsResponse.parseFrom((byte[])data);
            if (resp.hasStatus() && resp.getStatus() == 2) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "No stats entry for given volume"));
                return;
            }
            if (resp.hasStatus() && resp.getStatus() != 0) {
                String errMsg = Errno.toString(resp.getStatus());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Getting tierstats failed. " + errMsg));
                return;
            }
            CommandOutput.OutputHierarchy.OutputNode statsNode = new CommandOutput.OutputHierarchy.OutputNode();
            statsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalTierDataSize", (Object)(this.toMBSizeStr(resp.getTierStats().getTierDataSize()) + " MB")));
            if (resp.getTierStats().hasOffloadAvgThroughput()) {
                statsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("offloadThroughput", (Object)(this.toMBSizeStr(resp.getTierStats().getOffloadAvgThroughput()) + " MB/s")));
            }
            if (resp.getTierStats().hasRecallAvgThroughput()) {
                statsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("recallThroughput", (Object)(this.toMBSizeStr(resp.getTierStats().getRecallAvgThroughput()) + " MB/s")));
            }
            out.addNode(statsNode);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing tier lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    private String printCommandError(CommandOutput.OutputHierarchy out, CLDBProto.StartVolumeTierOpResponse resp) {
        String errMsg = resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString(resp.getStatus());
        out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        return errMsg;
    }

    private CLDBProto.StartVolumeTierOpResponse sendVolumeTierOp(CommandOutput.OutputHierarchy out, String cluster, int volumeId, CLDBProto.VolumeTierOp op, boolean ignoreRule, boolean ignoreRecallExpiry, boolean triggerNow, boolean isAbort, boolean retryOnGatewayPending) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        if (!retryOnGatewayPending) {
            resp = this.sendVolumeTierOp(out, cluster, volumeId, op, ignoreRule, ignoreRecallExpiry, triggerNow, isAbort);
        } else {
            int i = 0;
            for (i = 0; i < 3 && (resp = this.sendVolumeTierOp(out, cluster, volumeId, op, ignoreRule, ignoreRecallExpiry, triggerNow, isAbort)).getStatus() == 11; ++i) {
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return resp;
    }

    private CLDBProto.StartVolumeTierOpResponse sendVolumeTierOp(CommandOutput.OutputHierarchy out, String cluster, int volumeId, CLDBProto.VolumeTierOp op, boolean ignoreRule, boolean ignoreRecallExpiry, boolean triggerNow, boolean isAbort) throws CLIProcessingException {
        CLDBProto.StartVolumeTierOpResponse resp = null;
        CLDBProto.StartVolumeTierOpRequest.Builder req = CLDBProto.StartVolumeTierOpRequest.newBuilder();
        req.setVolumeId(volumeId);
        req.setCreds(this.getUserCredentials());
        if (!isAbort) {
            req.setOp(op);
            req.setIgnoreRule(ignoreRule);
            req.setIgnoreRecallExpiry(ignoreRecallExpiry);
            req.setTriggerNow(triggerNow);
        } else {
            req.setAbort(true);
        }
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.StartVolumeTierOpProc.getNumber(), (MessageLite)req.build(), CLDBProto.StartVolumeTierOpResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.StartVolumeTierOpProc.getNumber(), (MessageLite)req.build(), CLDBProto.StartVolumeTierOpResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.StartVolumeTierOpResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        return resp;
    }
}

