/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpgradeCommands
extends CLIBaseClass {
    private static final Logger LOG = Logger.getLogger(UpgradeCommands.class);
    private static final String TARGET_PARAM_NAME = "targetversion";
    private static final String NODE_PARAM_NAME = "node";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    public static final CLICommand StartCmd = new CLICommand("start", "", UpgradeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"targetversion", (Object)new TextInputParameter("targetversion", "targetversion", false, null)).put((Object)"node", (Object)new TextInputParameter("node", "node", false, null)).build(), null).setShortUsage("notifyupgrade start -targetversion <version> [-cluster <cluster_name>]");
    public static final CLICommand FinishCmd = new CLICommand("finish", "", UpgradeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"node", (Object)new TextInputParameter("node", "node", false, null)).build(), null).setShortUsage("notifyupgrade finish [-cluster <cluster_name>]");
    public static final CLICommand CheckCmd = new CLICommand("check", "", UpgradeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("notifyupgrade check [-cluster <cluster_name>]");
    public static final CLICommand UpgradeCommands = new CLICommand("notifyupgrade", "", UpgradeCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{StartCmd, FinishCmd, CheckCmd}).setShortUsage("notifyupgrade start|finish|check").setUsageInVisible(true);

    public UpgradeCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CLDBProto.ClusterUpgradeRequest req;
        CLDBProto.ClusterUpgradeResponse resp;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("start")) {
            CLDBProto.ClusterUpgradeRequest.Builder req2 = CLDBProto.ClusterUpgradeRequest.newBuilder().setCreds(this.getUserCredentials()).setUpgradeInProgress(true);
            if (this.isParamPresent(NODE_PARAM_NAME)) {
                String node = this.getParamTextValue(NODE_PARAM_NAME, 0);
                req2.setServer1(node);
            } else if (this.isParamPresent(TARGET_PARAM_NAME)) {
                String target = this.getParamTextValue(TARGET_PARAM_NAME, 0);
                req2.setTargetVersion(target);
            }
            this.sendRpc(req2.build(), out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("finish")) {
            CLDBProto.ClusterUpgradeRequest.Builder req3 = CLDBProto.ClusterUpgradeRequest.newBuilder().setCreds(this.getUserCredentials()).setUpgradeInProgress(false);
            if (this.isParamPresent(NODE_PARAM_NAME)) {
                String node = this.getParamTextValue(NODE_PARAM_NAME, 0);
                req3.setServer1(node);
            }
            this.sendRpc(req3.build(), out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("check") && (resp = this.sendRpc(req = CLDBProto.ClusterUpgradeRequest.newBuilder().setCreds(this.getUserCredentials()).setCheckProgress(false).build(), out)) != null) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("InProgress", resp.getInProgress() ? 1 : 0));
        }
        return output;
    }

    private CLDBProto.ClusterUpgradeResponse sendRpc(CLDBProto.ClusterUpgradeRequest req, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.ClusterUpgradeResponse resp;
        try {
            byte[] data;
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                    return null;
                }
                data = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterUpgradeProc.getNumber(), (MessageLite)req, CLDBProto.ClusterUpgradeResponse.class);
            } else {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterUpgradeProc.getNumber(), (MessageLite)req, CLDBProto.ClusterUpgradeResponse.class);
            }
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return null;
            }
            resp = CLDBProto.ClusterUpgradeResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "notifyupgrade: " + Errno.toString(10003)));
            LOG.error((Object)"Exception during ClusterUpgradeRequest", (Throwable)e);
            return null;
        }
        int status = resp.getStatus();
        if (status != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, Errno.toString(status)));
            return null;
        }
        return resp;
    }
}

