/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.OffloadRuleCommands;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.ojai.Document;
import org.ojai.json.Json;

public class TierCommands
extends ListCommand
implements CLIInterface {
    static String[] TierPropertiesFieldShortName = new String[]{"id", "n", "typ", "url", "thr", "enc", "bn", "reg"};
    static String[] TierPropertiesFieldName = new String[]{"tierid", "tiername", "tiertype", "url", "throttling", "bucketname", "region"};
    static String[] TierTypeName = new String[]{"cold", "ectier"};
    static String[] CompType = new String[]{"none", "lz4", "zlib"};
    private static final int NUM_TIER_PER_RPC = 25;
    private static final int LIMIT_START_PARAM = 0;
    private static final int LIMIT_MAX_PARAM = Integer.MAX_VALUE;
    public static final int MAX_OBJ_SIZE = 0x800000;
    public static final String TIERNAME_PARAM_NAME = "name";
    public static final String TYPE_PARAM_NAME = "type";
    public static final String AUTH_PARAM_NAME = "credential";
    public static final String URL_PARAM_NAME = "url";
    public static final String OBJSIZE_PARAM_NAME = "maxobjectsize";
    public static final String THROTTLING_PARAM_NAME = "throttling";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final int MAX_CREDENTIALS_FILE_SIZE = 102400;
    public static final String BUCKET_NAME = "bucketName";
    public static final String REGION = "region";
    public static final String CREDENTIALS_ACCESS_KEY = "credentials.accessKey";
    public static final String CREDENTIALS_SECRET_KEY = "credentials.secretKey";
    public static final String DEFAULT_REGION = "us-east-1";
    public static final String tierCreateUsage = "tier create -name tierName -type <cold> -url tier storage url -credential <credential-file to access tier storage> ";
    public static final String tierModifyUsage = "tier modify -name tierName [ -credential <credential-file to access tier storage> ";
    public static final String tierListUsage = "tier list";
    public static final String tierInfoUsage = "tier info -name tierName";
    public static final String tierRemoveUsage = "tier remove -name tierName";
    public static final String metaVolumePrefix = "mapr.internal.tier";
    public static final String metaVolumeParentDir = "/var/mapr/tier";
    private static final Logger LOG = Logger.getLogger(TierCommands.class);
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static Map<String, BaseInputParameter> tierCreateParams = new ImmutableMap.Builder().put((Object)"throttling", (Object)new BooleanInputParameter("throttling", "<true|false>", false, null).setInvisible(true)).put((Object)"maxobjectsize", (Object)new IntegerInputParameter("maxobjectsize", "maximum size of object allowed", false, null).setInvisible(true)).putAll(baseParams).build();
    public static Map<String, BaseInputParameter> tierModifyParams = new ImmutableMap.Builder().put((Object)"throttling", (Object)new BooleanInputParameter("throttling", "<true|false>", false, null).setInvisible(true)).put((Object)"maxobjectsize", (Object)new IntegerInputParameter("maxobjectsize", "maximum size of object allowed", false, null).setInvisible(true)).put((Object)"credential", (Object)new TextInputParameter("credential", "tier credentials", false, null)).putAll(baseParams).build();
    static final CLICommand tierCreateCommand = new CLICommand("create", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "tier name", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "cold", true, null)).put((Object)"url", (Object)new TextInputParameter("url", "tier url", false, null)).put((Object)"credential", (Object)new TextInputParameter("credential", "tier credentials", false, null)).putAll(tierCreateParams).build(), null).setShortUsage("tier create -name tierName -type <cold> -url tier storage url -credential <credential-file to access tier storage> ");
    static final CLICommand tierModifyCommand = new CLICommand("modify", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "tier name", true, null)).putAll(tierModifyParams).build(), null).setShortUsage("tier modify -name tierName [ -credential <credential-file to access tier storage> ");
    static final CLICommand tierListCommand = new CLICommand("list", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("tier list");
    static final CLICommand tierInfoCommand = new CLICommand("info", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "tier name", true, null)).putAll(baseParams).build(), null).setShortUsage("tier info -name tierName");
    static final CLICommand tierRemoveCommand = new CLICommand("remove", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "tier name", true, null)).putAll(baseParams).build(), null).setShortUsage("tier remove -name tierName");
    public static final CLICommand tierCommands = new CLICommand("tier", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{tierCreateCommand, tierModifyCommand, tierRemoveCommand, tierListCommand, tierInfoCommand, OffloadRuleCommands.ruleCommands}).setShortUsage("tier [create|modify|remove|info|list|rule]");

    public TierCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("list")) {
            try {
                this.list(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("create")) {
            try {
                this.tierCreate(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("modify")) {
            try {
                this.tierModify(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("info")) {
            try {
                this.tierInfo(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("remove")) {
            try {
                this.tierRemove(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return output;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    private String getTierName() throws CLIProcessingException {
        return this.isParamPresent(TIERNAME_PARAM_NAME) ? this.getParamTextValue(TIERNAME_PARAM_NAME, 0) : null;
    }

    private String getVolumeName() throws CLIProcessingException {
        return "mapr.internal.tier." + this.getTierName();
    }

    private String getTierMetaVolumeMountPath(String tierMetaVolumeName) throws CLIProcessingException {
        try {
            MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
            Path metaVolumePathObj = new Path(metaVolumeParentDir);
            if (!fs.exists(metaVolumePathObj)) {
                LOG.info((Object)("parent directory:/var/mapr/tier does not exists to mount meta volume: " + tierMetaVolumeName));
                fs.mkdirs(metaVolumePathObj);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Could not create parent directory:/var/mapr/tier to mount meta volume: " + tierMetaVolumeName));
            return null;
        }
        return "/var/mapr/tier/" + tierMetaVolumeName;
    }

    public static CLDBProto.TierLookupResponse tierLookup(String cluster, Security.CredentialsMsg creds, String tierName) throws CLIProcessingException {
        byte[] data = null;
        CLDBProto.TierLookupRequest req = CLDBProto.TierLookupRequest.newBuilder().setTierName(tierName).setCreds(creds).build();
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierLookupProc.getNumber(), (MessageLite)req, CLDBProto.TierLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierLookupProc.getNumber(), (MessageLite)req, CLDBProto.TierLookupResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return CLDBProto.TierLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing tier lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] handleCredentialsParam(String credsFname, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String accessKey = null;
        String secretKey = null;
        String bucketName = null;
        String region = null;
        String[] retVals = new String[4];
        retVals[3] = null;
        retVals[2] = null;
        retVals[1] = null;
        retVals[0] = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        String jsonStr = "";
        try {
            File f = new File(credsFname);
            if (!f.exists()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "File " + credsFname + " does not exist."));
                String[] stringArray = null;
                return stringArray;
            }
            if (f.isDirectory()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, credsFname + " is a directory.  Please provide a file for credentials"));
                String[] stringArray = null;
                return stringArray;
            }
            if (f.length() > 102400L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Size of Credentials file exceeds max supported size."));
                String[] stringArray = null;
                return stringArray;
            }
            fr = new FileReader(credsFname);
            br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                jsonStr = jsonStr + line;
            }
            Document doc = Json.newDocument((String)jsonStr);
            bucketName = doc.getString(BUCKET_NAME);
            accessKey = doc.getString(CREDENTIALS_ACCESS_KEY);
            secretKey = doc.getString(CREDENTIALS_SECRET_KEY);
            region = doc.getString(REGION);
            if (accessKey == null || accessKey.isEmpty() || secretKey == null || secretKey.isEmpty() || bucketName == null || bucketName.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot find valid bucket-name/access-key/secret-key in credentials"));
                String[] stringArray = null;
                return stringArray;
            }
            region = region == null ? DEFAULT_REGION : region.trim();
            if ((bucketName = bucketName.trim()).length() == 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid bucket name"));
                String[] stringArray = null;
                return stringArray;
            }
            retVals[0] = accessKey;
            retVals[1] = secretKey;
            retVals[2] = bucketName;
            retVals[3] = region;
            return retVals;
        }
        catch (Exception e) {
            String errMsg = "Error parsing S3 credentials file. Please consult documentation for credentials file template.";
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    void tierCreate(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String str;
        String tierName = null;
        CLDBProto.TierType tierType = CLDBProto.TierType.COLD_TIER;
        boolean throttling = false;
        int maxObjSize = 0x800000;
        String volumeName = null;
        String volumePath = null;
        String cluster = null;
        String credentials = null;
        String url = null;
        String accessKey = null;
        String secretKey = null;
        String bucketName = null;
        String region = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        tierName = this.getTierName();
        CLDBProto.TierLookupResponse resp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName);
        if (resp.hasStatus() && resp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "Tier " + tierName + " already exists."));
            return;
        }
        volumeName = this.getVolumeName();
        volumePath = this.getTierMetaVolumeMountPath(volumeName);
        if (volumePath == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Couldn't not create dir:/var/mapr/tier to mount meta volume for tier"));
            return;
        }
        CLDBProto.VolumeLookupResponse vlResp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), volumeName, null, this.isServerCall);
        if (vlResp.hasStatus() && vlResp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume " + volumeName + " already exists in cluster"));
            return;
        }
        if (this.isParamPresent(TYPE_PARAM_NAME)) {
            str = this.getParamTextValue(TYPE_PARAM_NAME, 0);
            if (str.equalsIgnoreCase("cold")) {
                tierType = CLDBProto.TierType.COLD_TIER;
            } else if (str.equalsIgnoreCase("ectier")) {
                tierType = CLDBProto.TierType.EC_TIER;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid tier type " + str + " specified. Please specify 'cold' as tier type"));
                return;
            }
        }
        if (this.isParamPresent(URL_PARAM_NAME)) {
            url = this.getParamTextValue(URL_PARAM_NAME, 0).trim();
        }
        if (this.isParamPresent(AUTH_PARAM_NAME)) {
            credentials = this.getParamTextValue(AUTH_PARAM_NAME, 0);
            String[] s3Creds = this.handleCredentialsParam(credentials, out);
            if (s3Creds == null) {
                return;
            }
            accessKey = s3Creds[0];
            secretKey = s3Creds[1];
            bucketName = s3Creds[2];
            region = s3Creds[3];
        }
        if (this.isParamPresent(OBJSIZE_PARAM_NAME)) {
            maxObjSize = this.getParamIntValue(OBJSIZE_PARAM_NAME, 0);
        }
        if (this.isParamPresent(TYPE_PARAM_NAME)) {
            str = this.getParamTextValue(TYPE_PARAM_NAME, 0);
            if (str.equalsIgnoreCase("cold")) {
                tierType = CLDBProto.TierType.COLD_TIER;
            } else if (str.equalsIgnoreCase("ectier")) {
                tierType = CLDBProto.TierType.EC_TIER;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type " + str + " specified. Please specify 'cold' as tier type"));
                return;
            }
        }
        if (this.isParamPresent(THROTTLING_PARAM_NAME)) {
            throttling = this.getParamBooleanValue(THROTTLING_PARAM_NAME, 0);
        }
        if (tierType == CLDBProto.TierType.COLD_TIER && (accessKey == null || accessKey.isEmpty() || secretKey == null || secretKey.isEmpty() || bucketName == null || bucketName.isEmpty() || region == null || region.isEmpty() || url == null || url.isEmpty())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot find valid url/access-key/secret-key/bucket-name/region"));
            return;
        }
        CLDBProto.TierCreateRequest.Builder tierCreate = CLDBProto.TierCreateRequest.newBuilder();
        CLDBProto.TierProperties.Builder tierProperties = CLDBProto.TierProperties.newBuilder();
        tierProperties.setTierName(tierName);
        tierProperties.setTierType(tierType);
        tierProperties.setMetaVolumeName(volumeName);
        tierProperties.setMetaVolumePath(volumePath);
        tierProperties.setThrotteling(throttling);
        tierProperties.setMaxObjSize(maxObjSize);
        if (url != null) {
            tierProperties.setUrl(url);
        }
        if (credentials != null) {
            tierProperties.setCredential(credentials);
        }
        if (accessKey != null && secretKey != null && bucketName != null && region != null) {
            Security.TierCredentials.Builder tierCredentials = Security.TierCredentials.newBuilder().setCredType(Security.CredentialsType.CredentialsTypeAws).setAccessKey(accessKey).setSecretKey(secretKey).setBucketName(bucketName).setRegion(region);
            tierProperties.setTierCreds(tierCredentials);
        }
        tierCreate.setTierProperties(tierProperties);
        tierCreate.setCreds(this.getUserCredentials());
        try {
            byte[] data = null;
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierCreateProc.getNumber(), (MessageLite)tierCreate.build(), CLDBProto.TierCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierCreateProc.getNumber(), (MessageLite)tierCreate.build(), CLDBProto.TierCreateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.TierCreateResponse createResp = CLDBProto.TierCreateResponse.parseFrom((byte[])data);
            if (createResp.getStatus() == 0) {
                out.addMessage("Successfully created tier: '" + tierName + "'");
                MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
                int status = fs.mountVolume(cluster, volumeName, volumePath, this.getUserLoginId());
                if (status != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "metadata volume failed to mount"));
                }
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(createResp.getStatus(), Errno.toString(createResp.getStatus()) + ": " + createResp.getErrMsg()));
                LOG.error((Object)("Failed to create tier. " + Errno.toString(createResp.getStatus()) + ": " + createResp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + (Object)((Object)e));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    void tierModify(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.TierLookupResponse resp;
        String tierName = null;
        boolean throttling = false;
        int maxObjSize = Integer.MAX_VALUE;
        String cluster = null;
        String accessKey = null;
        String secretKey = null;
        String bucketName = null;
        String region = null;
        tierName = this.getTierName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((resp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName)).hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier " + tierName + " does not exist."));
            return;
        }
        CLDBProto.TierModifyRequest.Builder tierModify = CLDBProto.TierModifyRequest.newBuilder();
        CLDBProto.TierProperties.Builder tierProperties = CLDBProto.TierProperties.newBuilder();
        tierProperties.setTierName(tierName);
        Security.TierCredentials.Builder tierCredentials = null;
        if (this.isParamPresent(AUTH_PARAM_NAME)) {
            tierProperties.setCredential(this.getParamTextValue(AUTH_PARAM_NAME, 0));
            String credentials = this.getParamTextValue(AUTH_PARAM_NAME, 0);
            String[] s3Creds = this.handleCredentialsParam(credentials, out);
            accessKey = s3Creds[0];
            secretKey = s3Creds[1];
            bucketName = s3Creds[2];
            region = s3Creds[3];
            tierCredentials = Security.TierCredentials.newBuilder();
            tierCredentials.setCredType(Security.CredentialsType.CredentialsTypeAws);
            tierCredentials.setAccessKey(accessKey);
            tierCredentials.setSecretKey(secretKey);
            tierCredentials.setBucketName(bucketName);
            tierCredentials.setRegion(region);
            if (resp.hasTierProperties()) {
                Security.TierCredentials oldCreds = resp.getTierProperties().getTierCreds();
                String oldBucketName = oldCreds.getBucketName();
                String oldRegion = oldCreds.getRegion();
                if (!oldBucketName.equals(bucketName)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Bucket name cannot be modified.  Existing bucket name : " + oldBucketName));
                    return;
                }
                if (!oldRegion.equals(region)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Region cannot be modified.  Existing region : " + oldRegion));
                    return;
                }
            }
            tierProperties.setTierCreds(tierCredentials);
        }
        if (this.isParamPresent(OBJSIZE_PARAM_NAME)) {
            tierProperties.setMaxObjSize(this.getParamIntValue(OBJSIZE_PARAM_NAME, 0));
        }
        if (this.isParamPresent(THROTTLING_PARAM_NAME)) {
            tierProperties.setThrotteling(this.getParamBooleanValue(THROTTLING_PARAM_NAME, 0));
        }
        tierModify.setTierProperties(tierProperties);
        tierModify.setCreds(this.getUserCredentials());
        try {
            byte[] data = null;
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierModifyProc.getNumber(), (MessageLite)tierModify.build(), CLDBProto.TierModifyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierModifyProc.getNumber(), (MessageLite)tierModify.build(), CLDBProto.TierModifyResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.TierModifyResponse modifyResp = CLDBProto.TierModifyResponse.parseFrom((byte[])data);
            if (modifyResp.getStatus() == 0) {
                out.addMessage("Successfully updated tier: '" + tierName + "'");
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(modifyResp.getStatus(), Errno.toString(modifyResp.getStatus())));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + (Object)((Object)e));
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    void tierRemove(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.TierLookupResponse lookupResp;
        String tierName = null;
        String cluster = null;
        byte[] data = null;
        tierName = this.getTierName();
        String volumeName = this.getVolumeName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((lookupResp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName)).hasStatus() && lookupResp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier " + tierName + " does not exist."));
            return;
        }
        if (lookupResp.hasNumVols() && lookupResp.getNumVols() > 0) {
            LOG.error((Object)"Cannot remove tier, as some volumes are still using it.");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Can not remove tier, as some volumes are still using it."));
            return;
        }
        CLDBProto.VolumeLookupResponse volResp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), volumeName, null, this.isServerCall);
        if (volResp.hasStatus() && volResp.getStatus() != 0) {
            LOG.info((Object)("Volume " + volumeName + " already removed"));
        } else {
            CLDBProto.VolumeProperties volProps = volResp.getVolInfo().getVolProperties();
            if (volProps.getMounted()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Volume " + volumeName + " is mounted at " + volProps.getMountDir() + ". Trying to unmount before removing"));
                }
                String volumeMountDir = volProps.getMountDir();
                Common.FidMsg parentFid = volProps.getParentFid();
                MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
                int status = fs.unmountVolume(cluster, volumeName, volumeMountDir, this.getUserLoginId(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
                if (status != 0) {
                    LOG.error((Object)("Failed to remove volume " + volumeName + " error " + status));
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Failed to unmount volume " + volumeName));
                    return;
                }
            } else {
                LOG.info((Object)("Volume " + volumeName + " not mounted"));
            }
        }
        CLDBProto.TierRemoveRequest req = CLDBProto.TierRemoveRequest.newBuilder().setTierName(tierName).setCreds(this.getUserCredentials()).build();
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierRemoveProc.getNumber(), (MessageLite)req, CLDBProto.TierRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierRemoveProc.getNumber(), (MessageLite)req, CLDBProto.TierRemoveResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.TierRemoveResponse resp = CLDBProto.TierRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                out.addMessage("Successfully deleted tier: '" + tierName + "'");
            } else if (resp.getStatus() == 1000) {
                LOG.error((Object)"Cannot remove tier, as some volumes are still using it.");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Can not remove tier, as some volumes are still using it."));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString(resp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing tier lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    void tierInfo(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.TierLookupResponse resp;
        String tierName = null;
        String cluster = null;
        tierName = this.getTierName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((resp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName)).hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier " + tierName + " does not exist."));
            return;
        }
        boolean terse = this.getOutputParamValue().equals("terse");
        this.addTierProperties(resp.getTierProperties(), terse, out);
    }

    public CLDBProto.TierListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.TierListRequest.Builder newReqBuilder = null;
        if (prevReq != null) {
            newReqBuilder = CLDBProto.TierListRequest.newBuilder((CLDBProto.TierListRequest)((CLDBProto.TierListRequest)prevReq));
        } else {
            CLIProto.Limiter limiter = this.getNextLimiter(0, 0, 0, Integer.MAX_VALUE, 25);
            newReqBuilder = CLDBProto.TierListRequest.newBuilder().setLimiter(limiter);
        }
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.TierListResponse)prevResp).getTotal();
            CLIProto.Limiter limiter = this.getNextLimiter(prevStart, prevCount, 0, Integer.MAX_VALUE, 25);
            newReqBuilder.setLimiter(limiter);
        }
        newReqBuilder.setCreds(this.getUserCredentials());
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(0, Integer.MAX_VALUE, ((CLDBProto.TierListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.TierListResponse)prevResp).getTierPropertiesCount());
    }

    void addTierProperties(CLDBProto.TierProperties tierProperties, boolean terse, CommandOutput.OutputHierarchy out) {
        String[] columnName;
        CommandOutput.OutputHierarchy.OutputNode tierNode = new CommandOutput.OutputHierarchy.OutputNode();
        String[] stringArray = columnName = terse ? TierPropertiesFieldShortName : TierPropertiesFieldName;
        if (tierProperties.hasTierId()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.id.ordinal()], (Object)Integer.toString(tierProperties.getTierId())));
        }
        if (tierProperties.hasTierName()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.n.ordinal()], (Object)tierProperties.getTierName()));
        }
        if (tierProperties.hasTierType()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.typ.ordinal()], (Object)TierTypeName[tierProperties.getTierType().ordinal()]));
        }
        if (tierProperties.hasUrl()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.url.ordinal()], (Object)tierProperties.getUrl()));
        }
        if (tierProperties.hasTierCreds() && tierProperties.getTierCreds().hasBucketName()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.bn.ordinal()], (Object)tierProperties.getTierCreds().getBucketName()));
        }
        if (tierProperties.hasTierCreds() && tierProperties.getTierCreds().hasRegion()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.reg.ordinal()], (Object)tierProperties.getTierCreds().getRegion()));
        }
        out.addNode(tierNode);
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.TierListResponse resp = (CLDBProto.TierListResponse)response;
        boolean terse = this.getOutputParamValue().equals("terse");
        for (CLDBProto.TierProperties tierProperties : resp.getTierPropertiesList()) {
            this.addTierProperties(tierProperties, terse, out);
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
    }

    public CLDBProto.TierListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.TierListRequest req = (CLDBProto.TierListRequest)request;
        byte[] replyData = null;
        if (this.isParamPresent("cluster")) {
            String cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                throw new CLIProcessingException("Invalid cluster: " + cluster);
            }
            try {
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierListProc.getNumber(), (MessageLite)req, CLDBProto.TierListResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
        }
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierListProc.getNumber(), (MessageLite)req, CLDBProto.TierListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return CLDBProto.TierListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into TierListResponse proto object.", (Throwable)ipbe);
            }
        }
        throw new CLIProcessingException("Failed to get list of tiers for this cluster");
    }

    static enum TierPropertiesField {
        id,
        n,
        typ,
        url,
        thr,
        bn,
        reg;

    }
}

