/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRedSlotUtil;

public final class TasksMemory
extends CLIBaseClass
implements CLIInterface {
    private static final Log LOG = LogFactory.getLog(TasksMemory.class);
    private final Configuration conf = new JobConf();
    private static final String TASKS_MEMORY_PARAM = "memorymb";
    static final CLICommand tasksMemCommand = new CLICommand("tasksmemory", "tasksmemory", TasksMemory.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"memorymb", (Object)new LongInputParameter("memorymb", "memorymb", true, null)).build(), null).setUsageInVisible(true);

    public TasksMemory(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        long memoryForTasks = this.getParamLongValue(TASKS_MEMORY_PARAM, 0);
        long memoryForTasksNew = MapRedSlotUtil.adjustSlots((Configuration)this.conf, (long)memoryForTasks);
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode(TASKS_MEMORY_PARAM, memoryForTasksNew));
        return output;
    }
}

