/*
 * Decompiled with CFR 0.152.
 */
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import com.mapr.util.MapRFSUtil;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class TestReadingDataFromMaprFs {
    private static final Logger LOG = Logger.getLogger(TestReadingDataFromMaprFs.class);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: <fileName>");
            System.exit(0);
        }
        String metricsFile = args[0];
        FSDataInputStream fsdis = null;
        long now = System.currentTimeMillis();
        int readMetrcisCount = 0;
        int readRequestsCount = 0;
        long readBytesCount = 0L;
        System.out.println("Start reading file: " + new Date(now));
        try {
            fsdis = MapRFSUtil.getMapRFileSystem().open(new Path(metricsFile));
            int fileLength = fsdis.readInt();
            while (true) {
                int nexRecordbytesCount = fsdis.readInt();
                LOG.info((Object)("written bytes: " + nexRecordbytesCount));
                byte[] buf = new byte[nexRecordbytesCount];
                int readBytes = fsdis.read(buf, 0, nexRecordbytesCount);
                if (readBytes < 0) {
                    if (fileLength == nexRecordbytesCount) {
                        LOG.info((Object)("End of file is reached sucessfully. Length matches. First lenght: " + fileLength + ", Last Length: " + nexRecordbytesCount));
                    } else {
                        LOG.warn((Object)("Warning while reading data file. File might be still being written into. Length does not match. First lenght: " + fileLength + ", Last Length: " + nexRecordbytesCount));
                    }
                    long after = System.currentTimeMillis();
                    System.out.println("Time took to read file: " + (after - now) + " ms. for : " + readMetrcisCount + " of metrics" + ", requestsCount: " + readRequestsCount + ", readBytes: " + readBytesCount);
                    if (fsdis != null) {
                        fsdis.close();
                    }
                    return;
                }
                if (readBytes != nexRecordbytesCount) {
                    LOG.info((Object)("Number of read bytes : " + readBytes + " != written bytes: " + nexRecordbytesCount));
                }
                readBytesCount += (long)readBytes;
                ClusterMetricsProto.CombineMessageRequest.Builder requestBuilder = ClusterMetricsProto.CombineMessageRequest.newBuilder();
                requestBuilder.mergeFrom(buf);
                ++readRequestsCount;
                int timedMetricsCount = requestBuilder.getTimedMetricCount();
                long time = requestBuilder.getTimedMetric(0).getTimestamp();
                readMetrcisCount += timedMetricsCount;
                LOG.info((Object)("MetricsCount: " + timedMetricsCount + ", at Time: " + new Date(time)));
                ClusterMetricsProto.CombineMessageRequest combineMessageRequest = requestBuilder.build();
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Metrics file not found. Path: " + metricsFile), (Throwable)e);
        }
        catch (EOFException e) {
            try {
                if (fsdis != null) {
                    fsdis.close();
                }
            }
            catch (IOException e1) {
                LOG.error((Object)"IOException", (Throwable)e1);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("I/O Exception while reading metrics file. Path: " + metricsFile), (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error((Object)"Exception", t);
        }
    }
}

