/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.util.Util;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mapr.fs.Nfsmon;

public class NFSMgmtCommands
extends CLIBaseClass {
    private static final String NFSHostIp = "nfshost";
    private static final String NFSPort = "nfsport";
    private static final String IS_USER_MODE = "isusermode";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"nfshost", (Object)new TextInputParameter("nfshost", "ip/hostname", false, "127.0.0.1")).put((Object)"nfsport", (Object)new IntegerInputParameter("nfsport", "port", false, Integer.valueOf(9998))).put((Object)"isusermode", (Object)new TextInputParameter("isusermode", "isusermode", false, null)).build();
    private static final CLICommand refreshExportsCmd = new CLICommand("refreshexports", "usage: nfsmgmt refreshexports -nfshost host -nfsport port", NFSMgmtCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("nfsmgmt refreshexports -nfshost host -nfsport port");
    private static final CLICommand refreshGidCahceCmd = new CLICommand("refreshgidcache", "usage: nfsmgmt refreshgidcache -nfshost host -nfsport port", NFSMgmtCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("nfsmgmt refreshgidcache -nfshost host -nfsport port");
    public static final CLICommand nfsMgmtCmds = new CLICommand("nfsmgmt", "nfsmgmt [refreshexports|refreshgidcache]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{refreshExportsCmd, refreshGidCahceCmd}).setShortUsage("nfsmgmt [refreshexports|refreshgidcache]");
    String clusterName = null;

    public NFSMgmtCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        MutableInt err;
        int port;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        this.clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        try {
            port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new CLIProcessingException("Error in RPC init");
            }
        }
        catch (Exception e) {
            System.out.println("Exception in Rpc.initialize " + e);
            throw new CLIProcessingException("Exception in Rpc.initialize ", (Throwable)e);
        }
        port = this.getParamIntValue(NFSPort, 0);
        String hostName = this.getParamTextValue(NFSHostIp, 0);
        if (!hostName.equalsIgnoreCase("localhost") && !hostName.equalsIgnoreCase("127.0.0.1")) {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(hostName));
            if (ips.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not get valid IP address out of provided name: " + hostName));
                return output;
            }
            hostName = ips.get(0);
        }
        int hostip = Util.ipToInt((String)hostName);
        if (this.isParamPresent(IS_USER_MODE) && this.getParamTextValue(IS_USER_MODE, 0).equalsIgnoreCase("true") && (err = this.CreateNFSUserTicket(this.clusterName)).GetValue() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Cannot create the ticket for nfs in user mode"));
            return output;
        }
        long binding = Rpc.createBindingFor((int)hostip, (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
        if (this.cliCommand.getCommandName().equalsIgnoreCase("refreshexports")) {
            this.refreshExports(out, binding);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("refreshgidcache")) {
            this.refreshGidCache(out, binding);
        }
        return output;
    }

    private MutableInt CreateNFSUserTicket(String clusterName) {
        MutableInt err = new MutableInt();
        Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, clusterName, err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetKey(Security.ServerKeyType.ServerKey, ticketAndKey.getUserKey());
        String userName = ticketAndKey.getUserCreds().getUserName();
        int[] gids = new int[]{userName.length()};
        ticketAndKey = Security.GenerateTicketAndKey(Security.ServerKeyType.ServerKey, userName, userName.length(), gids, Security.MAX_EXPIRY_TIME, 0L, true, false, err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetTicketAndKey(Security.ServerKeyType.ServerKey, clusterName, ticketAndKey);
        return err;
    }

    private void refreshExports(CommandOutput.OutputHierarchy out, long binding) throws CLIProcessingException {
        Nfsmon.NFSMgmtResponse resp = null;
        Nfsmon.NFSMgmtRequest.Builder b = Nfsmon.NFSMgmtRequest.newBuilder();
        b.setRefreshExports(true);
        try {
            byte[] data = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.NFSServerMgmtProgramId.getNumber(), (int)Nfsmon.NFSMgmtProg.NFSMgmtProc.getNumber(), (MessageLite)b.build());
            resp = Nfsmon.NFSMgmtResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        if (resp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "No response from NFS server"));
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString(status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
            return;
        }
        if (resp.hasErrMsg()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode(resp.getErrMsg()));
        }
    }

    private void refreshGidCache(CommandOutput.OutputHierarchy out, long binding) throws CLIProcessingException {
        Nfsmon.NFSMgmtResponse resp = null;
        Nfsmon.NFSMgmtRequest.Builder b = Nfsmon.NFSMgmtRequest.newBuilder();
        b.setRefreshGidCache(true);
        try {
            byte[] data = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.NFSServerMgmtProgramId.getNumber(), (int)Nfsmon.NFSMgmtProg.NFSMgmtProc.getNumber(), (MessageLite)b.build());
            resp = Nfsmon.NFSMgmtResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        if (resp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "No response from NFS server"));
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString(status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
            return;
        }
        if (resp.hasErrMsg()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode(resp.getErrMsg()));
        }
    }
}

