/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.audit;

import com.mapr.baseutils.audit.AuditFormatter;
import com.mapr.baseutils.audit.AuditRecord;
import com.mapr.baseutils.audit.KeyValue;
import java.util.List;

public class AuditJsonFormatter
implements AuditFormatter {
    private static AuditJsonFormatter formatter = new AuditJsonFormatter();

    private AuditJsonFormatter() {
    }

    public static AuditJsonFormatter getInstance() {
        return formatter;
    }

    @Override
    public String formatAuditRecord(AuditRecord auditRecord) {
        if (auditRecord == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (auditRecord.getKeyValues() != null) {
            if (auditRecord.getKeyValuesSR()) {
                this.formatMulti(sb, auditRecord.getIsoDate(), auditRecord.getOp().toString(), auditRecord.getUsername(), Integer.toString(auditRecord.getUid()), Integer.toString(auditRecord.getGid()), auditRecord.populateTargetUser(), Integer.toString(auditRecord.getTargetUid()), Integer.toString(auditRecord.getTargetGid()), auditRecord.getClientIp(), auditRecord.getResource(), auditRecord.getKeyValues(), Integer.toString(auditRecord.getStatus()));
                sb.append("\n");
            } else {
                for (KeyValue keyValue : auditRecord.getKeyValues()) {
                    this.format(sb, auditRecord.getIsoDate(), auditRecord.getOp().toString(), auditRecord.getUsername(), Integer.toString(auditRecord.getUid()), Integer.toString(auditRecord.getGid()), auditRecord.populateTargetUser(), Integer.toString(auditRecord.getTargetUid()), Integer.toString(auditRecord.getTargetGid()), auditRecord.getClientIp(), auditRecord.getResource(), keyValue, Integer.toString(auditRecord.getStatus()));
                    sb.append("\n");
                }
            }
        } else if (auditRecord.getOp() != null) {
            this.format(sb, auditRecord.getIsoDate(), auditRecord.getOp().toString(), auditRecord.getUsername(), Integer.toString(auditRecord.getUid()), Integer.toString(auditRecord.getGid()), auditRecord.populateTargetUser(), Integer.toString(auditRecord.getTargetUid()), Integer.toString(auditRecord.getTargetGid()), auditRecord.getClientIp(), auditRecord.getResource(), auditRecord.getKeyValue(), Integer.toString(auditRecord.getStatus()));
            sb.append("\n");
        } else {
            return null;
        }
        return sb.toString();
    }

    private void formatBasic(StringBuilder sb, String isoDate, String op, String username, String uid, String gid, boolean populateTargetUser, String targetUid, String targetGid, String clientIp, String resource) {
        this.addTimeStamp(sb, isoDate);
        sb.append(",");
        this.addAuditField(sb, "resource", resource, true);
        sb.append(",");
        this.addAuditField(sb, "operation", op, true);
        sb.append(",");
        if (username != null) {
            this.addAuditField(sb, "username", username, true);
            sb.append(",");
        } else {
            this.addAuditField(sb, "uid", uid, false);
            sb.append(",");
        }
        if (populateTargetUser) {
            this.addAuditField(sb, "targetUid", targetUid, false);
            sb.append(",");
            this.addAuditField(sb, "targetGid", targetGid, false);
            sb.append(",");
        }
        this.addAuditField(sb, "clientip", clientIp, true);
        sb.append(",");
    }

    private void format(StringBuilder sb, String isoDate, String op, String username, String uid, String gid, boolean populateTargetUser, String targetUid, String targetGid, String clientIp, String resource, KeyValue keyValue, String status) {
        sb.append("{");
        this.formatBasic(sb, isoDate, op, username, uid, gid, populateTargetUser, targetUid, targetGid, clientIp, resource);
        if (keyValue.hasValues()) {
            sb.append(keyValue.toJsonString());
            sb.append(",");
        }
        this.addAuditField(sb, "status", status, false);
        sb.append("}");
    }

    private void formatMulti(StringBuilder sb, String isoDate, String op, String username, String uid, String gid, boolean populateTargetUser, String targetUid, String targetGid, String clientIp, String resource, List<KeyValue> keyValues, String status) {
        sb.append("{");
        this.formatBasic(sb, isoDate, op, username, uid, gid, populateTargetUser, targetUid, targetGid, clientIp, resource);
        if (keyValues.size() > 0) {
            sb.append(KeyValue.toJsonStringSR(keyValues));
            sb.append(",");
        }
        this.addAuditField(sb, "status", status, false);
        sb.append("}");
    }

    private void addTimeStamp(StringBuilder sb, String isoDate) {
        sb.append("\"");
        sb.append("timestamp");
        sb.append("\"");
        sb.append(":");
        sb.append("{");
        sb.append("\"");
        sb.append("$");
        sb.append("date");
        sb.append("\"");
        sb.append(":");
        sb.append("\"");
        sb.append(isoDate);
        sb.append("\"");
        sb.append("}");
    }

    private void addAuditField(StringBuilder sb, String key, String value, boolean addQuotesToValue) {
        sb.append("\"");
        sb.append(key);
        sb.append("\"");
        sb.append(":");
        if (addQuotesToValue) {
            sb.append("\"");
        }
        if (value != null) {
            sb.append(value);
        }
        if (addQuotesToValue) {
            sb.append("\"");
        }
    }
}

