/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class NodesZKCleanup {
    private static ZooKeeper s_zk;

    public static void main(String[] args) {
        String zkConnectString = args[0];
        try {
            s_zk = new ZooKeeper(zkConnectString, 30000, null);
            if (s_zk.exists("/nodes", false) != null) {
                NodesZKCleanup.deleteZKHierarchyRecursive("/nodes");
            }
        }
        catch (IOException e) {
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void deleteZKHierarchyRecursive(String parentPath) throws KeeperException, InterruptedException {
        List children = s_zk.getChildren(parentPath, false);
        for (String child : children) {
            NodesZKCleanup.deleteZKHierarchyRecursive(parentPath + "/" + child);
        }
        s_zk.delete(parentPath, -1);
    }
}

