package com.mapr.cli.perf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.List;
import java.util.Map;

public class ListCommandPerformance {
  private String filePath;
  private Map<String, List<Data>> perfData = new HashMap<String, List<Data>>();

  public ListCommandPerformance(String filePath) {
    this.filePath = filePath;
  }

  public void generateReport() throws Exception {
    BufferedReader reader = new BufferedReader(new FileReader(this.filePath));
    String line = "";
    String thread = "";
    while ((line = reader.readLine()) != null) {
      if (line.contains("thread") && line.contains("[") && line.contains("]")) {
        thread = line.substring(line.indexOf('['), line.indexOf(']') + 1);
        if (line.contains("CLDBCallable: Parameters")) {
          String url = line.substring(line.indexOf("= [") + 2);

          if (url.contains("node, list") || url.contains("volume, list")) {
            List<Data> dataList = this.perfData.get(thread);
            if (dataList == null) {
              dataList = new ArrayList<Data>();
              this.perfData.put(thread, dataList);
            }
            dataList.add(new Data(thread, url));
          }

        } else if (line.contains("Perf::list()")) {
          int perf = Integer.parseInt(line.substring(line.indexOf("=") + 2));
          List<Data> dataList = this.perfData.get(thread);
          if (dataList != null && !dataList.isEmpty()) {
            boolean perfSet = false;
            for (Data d : dataList) {
              if (d.getPerf() == -1) {
                perfSet = true;
                d.setPerf(perf);
              }
            }
            if (!perfSet) {
//              System.out.println("FATAL: Data object found, but empty slot not found. Details: "
//                  + dataList.toString());
            }
          } else {
//            System.out.println("FATAL: Data object not created earlier for thread: " + thread);
          }
        }
      }
    }

    Map<String, List<Data>> urlToPerf = new TreeMap<String, List<Data>>();
    for (List<Data> dataList : this.perfData.values()) {
      for(Data data : dataList) {
        List<Data> list = urlToPerf.get(data.url);
        if (list == null || list.isEmpty()) {
          list = new ArrayList<Data>();
          urlToPerf.put(data.url, list);
        }
        list.add(data);
      }
    }
    
    System.out.println("URL\tNum Samples\tAvg. Time");
    for (String url : urlToPerf.keySet()) {
      List<Data> list = urlToPerf.get(url);
      float perf = 0;
      for (Data data : list) {
        perf += data.getPerf();
      }
      perf = perf / list.size();
      System.out.println(url + "\t" + list.size() + "\t" + perf);
    }

    reader.close();
  }

  private class Data {
    private String thread;
    private String url;
    private int perf;

    public Data(String thread, String url) {
      this.thread = thread;
      this.url = url;
      this.perf = -1;
    }

    public void setPerf(int perf) {
      this.perf = perf;
    }

    public int getPerf() {
      return this.perf;
    }

    @Override
    public int hashCode() {
      final int prime = 31;
      int result = 1;
      result = prime * result + getOuterType().hashCode();
      result = prime * result + perf;
      result = prime * result + ((thread == null) ? 0 : thread.hashCode());
      result = prime * result + ((url == null) ? 0 : url.hashCode());
      return result;
    }

    @Override
    public boolean equals(Object obj) {
      if (this == obj)
        return true;
      if (obj == null)
        return false;
      if (getClass() != obj.getClass())
        return false;
      Data other = (Data) obj;
      if (!getOuterType().equals(other.getOuterType()))
        return false;
      if (perf != other.perf)
        return false;
      if (thread == null) {
        if (other.thread != null)
          return false;
      } else if (!thread.equals(other.thread))
        return false;
      if (url == null) {
        if (other.url != null)
          return false;
      } else if (!url.equals(other.url))
        return false;
      return true;
    }

    private ListCommandPerformance getOuterType() {
      return ListCommandPerformance.this;
    }

    public String toString() {
      return "Thread : " + thread + ", URL : " + url + ", Time: " + perf;
    }
  }

  public static void main(String args[]) throws Exception {
    if (args.length != 1) {
      System.out.println("Please input the path to adminuiapp.log file");
      System.exit(1);
    }
    ListCommandPerformance perf = new ListCommandPerformance(args[0]);
    perf.generateReport();
  }

}
