package com.mapr.cli;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;

import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;

public class ZookeeperServerSetup {

    static ZooKeeperServer s_zk;
    static String s_zkdataDirName;
    static final int testZKPort = 6181;
   
	public static void setUpZKServer() throws Exception {
        // start local ZK
		File s_zkdataDir = File.createTempFile("unittest", null, new File("/tmp"));
		s_zkdataDirName = s_zkdataDir.getAbsolutePath();
		s_zkdataDir.delete();
		
		final File dataDir = new File(s_zkdataDirName);
		final File dataLogDir = new File(s_zkdataDirName);
		dataDir.mkdirs();
		dataLogDir.mkdirs();

		startSingleZkServer(2000, dataDir, dataLogDir, testZKPort);  
	}
	
	public static void tearDownZKServer() throws Exception {
        stopZkServer();
        final File dataDir = new File(s_zkdataDirName);
        Thread.sleep(500);
        delete(dataDir);
	}


   static void startSingleZkServer(final int tickTime, final File dataDir, final File dataLogDir, final int port) {
        try {
            s_zk = new ZooKeeperServer(dataDir, dataLogDir, tickTime);
            InetSocketAddress addr = new InetSocketAddress("localhost", port);
            NIOServerCnxnFactory nioFactory = (NIOServerCnxnFactory) NIOServerCnxnFactory.createFactory(addr, 200);
            nioFactory.startup(s_zk);
            Thread.sleep(500);
        } catch (final IOException e) {
           throw new RuntimeException("Unable to start single ZooKeeper server.", e);
        } catch (final InterruptedException e) {
    // ignore these
        }
        
    }

	static void stopZkServer() {
        if (s_zk != null) {
            s_zk.shutdown();
            s_zk = null;
        }
      }

    private static void delete(File dataDir) {
        if ( dataDir == null ) {
                return;
        }
        if ( dataDir.isDirectory() ) {
	        File [] subDirs = dataDir.listFiles();
	        for (File subDir : subDirs) {
	        	delete(subDir);
	        }
	        
        } 
        if ( !dataDir.delete() ) {
                System.out.println("Can not delete: " + dataDir);
        }
    }


}
