package com.mapr.cli;

import static org.junit.Assert.*;

import java.io.InputStream;

import org.junit.Test;


public class UtilityTest {
  
  @Test
  public void fileParseReplaceTest() throws Exception {
    InputStream is = UtilityTest.class.getResourceAsStream("/conf/db.conf");
    byte [] buf = new byte[10240];
    int bytesCount = is.read(buf);
    is.close();
    
    if ( bytesCount <= 0 ) {
      fail();
    }
    
    String fileContent = new String(buf, 0, bytesCount);
    fileContent = fileContent.replaceFirst("db.url=.*\n", "db.url=abc:123\n");
    fileContent = fileContent.replaceFirst("db.user=.*\n", "db.user=abc\n");
    fileContent = fileContent.replaceFirst("db.passwd=.*\n", "db.passwd=cba\n");
    
    InputStream isC = UtilityTest.class.getResourceAsStream("/conf/db1.conf");
    byte [] bufC = new byte[10240];
    int bytesCountC = isC.read(bufC);
    isC.close();

    if ( bytesCountC <= 0 ) {
      fail();
    }

    String finalString = new String(bufC, 0, bytesCountC);

    if ( !finalString.contentEquals(fileContent) ) {
      fail();
    }
    
    InputStream isx = UtilityTest.class.getResourceAsStream("/conf/hibernate.cfg.xml");
    byte [] bufx = new byte[10240];
    int bytesCountx = isx.read(bufx);
    isx.close();
    
    if ( bytesCountx <= 0 ) {
      fail();
    }

    String fileContentx = new String(bufx, 0, bytesCountx);
    fileContentx = fileContentx.replaceFirst("jdbc:mysql://.*[0-9]/", "jdbc:mysql://abc:123/");
    fileContentx = fileContentx.replaceFirst("\"connection.username\">.*<", "\"connection.username\">abc<");
    fileContentx = fileContentx.replaceFirst("\"connection.password\">.*<", "\"connection.password\">cba<");

    isC = UtilityTest.class.getResourceAsStream("/conf/hibernate1.cfg.xml");
    bytesCountC = isC.read(bufC);
    isC.close();

    if ( bytesCountC <= 0 ) {
      fail();
    }

    finalString = new String(bufC, 0, bytesCountC);

    if ( !finalString.contentEquals(fileContentx) ) {
      fail();
    }

  }

  @Test
  public void testTmpDir() throws Exception {
    String tmpDir = System.getProperty("java.io.tmpdir");
    String fileSeparator = System.getProperty("file.separator");
    System.out.println(tmpDir + ", FileSeparator: " + fileSeparator);
  }
}
