package com.mapr.cli;


import java.io.FileOutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Set;

import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Security.Key;
import com.mapr.fs.proto.Security.ServerKeyType;
import com.mapr.fs.proto.Security.TicketAndKey;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;

public class UserSubjectTest {

  @BeforeClass
  public static void setUpBeforeClass() throws Exception {
  }

  @AfterClass
  public static void tearDownAfterClass() throws Exception {
  }

  @Before
  public void setUp() throws Exception {
  }

  @After
  public void tearDown() throws Exception {
  }

  
  @Test
  public void UserSubjectTest1() throws Exception {
    UserGroupInformation oldUser = UserGroupInformation.getCurrentUser();
    oldUser.addCredentials(new Credentials());
    
    UserGroupInformation proxyUser = UserGroupInformation.createProxyUser("testuser", oldUser);
    
    Void retNothing = proxyUser.doAs(new PrivilegedExceptionAction<Void>() {

      @Override
      public Void run() throws Exception {
        UserGroupInformation newUser = UserGroupInformation.getCurrentUser();
        Credentials creds = newUser.getCredentials();
        System.out.println(creds);
        return null;
      }});
  }
  
  
  @Test
  public void generateTicketNewWay() throws Exception {
    Key k = Security.GenerateRandomKey();
    MutableInt err = new MutableInt();
    byte [] fileData = Security.EncodeDataForWritingToKeyFile(k.toByteArray(), err);
    FileOutputStream fout = new FileOutputStream("/tmp/cldb.key");
    fout.write(fileData);
    fout.write(new String("\n").getBytes("UTF-8"));
    fout.close();

    // generate ServerKey based of CLDB Key
    Key serverKey = Security.GetServerKey(k, 0);
    //Security.SetKey(ServerKeyType.CldbKey, k);

    int [] gids2 = new int[2];
    gids2[0] = 2147483632;
    gids2[1] = 42;
    
    TicketAndKey serverTicketKey = helperFunction(ServerKeyType.CldbKey, k, gids2, 2147483632, "mapr", err);

    ByteString encrMaprServerTicket = serverTicketKey.getEncryptedTicket();
    
    TicketAndKey maprTicketKey = helperFunction(ServerKeyType.ServerKey, serverKey, gids2, 2147483632, "mapr", err);

    ByteString encrMaprTicket = maprTicketKey.getEncryptedTicket();

    
    int [] gids = new int[2];
    gids[0] = 0;
    gids[1] = 42;

    //TicketAndKey rootTicketEncryptedWithServerKey = helperFunction(ServerKeyType.ServerKey, serverTicketKey.getUserKey(), gids, 0, "root", err);
    TicketAndKey rootTicketEncryptedWithServerKey = helperFunction(ServerKeyType.ServerKey, serverKey, gids, 0, "root", err);
    
    ByteString encrRootTicket = rootTicketEncryptedWithServerKey.getEncryptedTicket();
    
    
    int [] gids1 = new int[1];
    gids1[0] = 1007;
    
//    TicketAndKey testTicketEncryptedWithServerKey = helperFunction(ServerKeyType.ServerKey, serverTicketKey.getUserKey(), gids1, 1006, "test", err);
    TicketAndKey testTicketEncryptedWithServerKey = helperFunction(ServerKeyType.ServerKey, serverKey, gids1, 1006, "test", err);
    
    ByteString encrTestTicket = testTicketEncryptedWithServerKey.getEncryptedTicket();
    
    // try to decrypt tickets correctly
    
    
  }

  private static TicketAndKey helperFunction(ServerKeyType keyType, Key key, int[] gids, int uid, String userName, MutableInt err) {
    TicketAndKey ticketAndKey = 
      Security.GenerateTicketAndKeyUsingServerKey(keyType, key, userName, uid, 
          gids, System.currentTimeMillis() / 1000l + 96*60*60, 0, false, err);
    
    System.out.println(Security.TicketAndKeyToString("TicketAndKey", ticketAndKey));

    try {
      byte [] fileData = Security.EncodeDataForWritingToKeyFile(ticketAndKey.toByteArray(), err);
      System.out.println("Encoded data is " + new String(fileData, "US-ASCII"));
      String fileName = "/tmp/maprticket_" + uid;
      if ( keyType == ServerKeyType.CldbKey ) {
        fileName = "/tmp/maprserverticket";
      }
      FileOutputStream fos = new FileOutputStream(fileName);
      
      fos.write("default ".getBytes("UTF-8"));
      fos.write(fileData);
      fos.close();

      Security.SetTicketAndKeyFile("/tmp/maprticket_" + uid);
      TicketAndKey ticketAndKey1 = Security.GetTicketAndKeyForCluster(ServerKeyType.CldbKey, "default", err);
      System.out.println(Security.TicketAndKeyToString("TicketAndKey", ticketAndKey1));
      System.out.println("Ticket Expiry time (seconds since epoch) : " + ticketAndKey1.getExpiryTime() + "," + new Date(ticketAndKey1.getExpiryTime() * 1000L).toString());
      } catch (Exception e) {
        System.out.println("Exception " + e);
      }

      return ticketAndKey;
  }
  
  @Test
  public void getTicketFrommaprServerTicket() {
    MutableInt err = new MutableInt();
    Security.SetTicketAndKeyFile("/tmp/maprserverticket");
    TicketAndKey ticketKey = Security.GetTicketAndKeyForCluster(ServerKeyType.CldbKey, "default", err);
    
    Key key = ticketKey.getUserKey();
    int [] gids2 = new int[2];
    gids2[0] = 2147483632;
    gids2[1] = 42;
    

    TicketAndKey maprTicketKey = helperFunction(ServerKeyType.MfsUtilKey, key, gids2, 2147483632, "mapr", err);
    
  }
}
