package com.mapr.cli;


import java.io.IOException;
import java.util.List;

import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.ZooDefs.Ids;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.mapr.cliframework.base.CLICommandFactory;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;

public class RemoveNodeTest {

	private static ZooKeeper s_zk;
	private static String zookeeperAddresses;
	
	private static final Logger LOG = Logger.getLogger(RemoveNodeTest.class);
	
	static {
		MapRCLIRegistry.getInstance().register();
	}

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		ZookeeperServerSetup.setUpZKServer();

	     // get zk addresses, ports
	     zookeeperAddresses = "localhost:" + ZookeeperServerSetup.testZKPort;
		    try {
	    		s_zk = new ZooKeeper(zookeeperAddresses, NodeRemoveCommand.TIMEOUT_SERVER, null);
			} catch (IOException e) {
			}

	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		ZookeeperServerSetup.tearDownZKServer();
	}

	
	@Before
	public void setupBeforeTest() throws Exception {
		try {
			s_zk.create("/servers", new byte[0], Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
			s_zk.create("/servers/server_", "10.10.10.11".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "10.10.10.10".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "127.0.0.1".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "10.10.10.12".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "10.10.10.13".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
			s_zk.create("/servers/server_", "10.10.10.14".getBytes(), Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
		} catch (KeeperException.NodeExistsException e) {
			// ignore
		}

	}
	
	@After
	public void tearDownAfterTest() throws Exception {
		List<String> znodes = s_zk.getChildren("/servers", false);
		for ( String node : znodes ) {
			s_zk.delete("/servers/" + node, -1);
		}
		s_zk.delete("/servers", -1);
	}
	
	@Test
	public void removeNodeTest() throws Exception {
		String [] args = new String [] {"node", "remove", "-"+NodeRemoveCommand.ZK_CONNECTSTRING, zookeeperAddresses, "-nodes", "10.10.10.11", "-force", "true"};

		ProcessedInput input = new ProcessedInput(args);
		CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);

		if ( commandIFace == null ) {
			LOG.error("Could not find Interface for a command: " + input.getCommandName());
			// print usage
			System.out.print(CLICommandFactory.getInstance().getUsage(false));
			return;
		}
		
		if ( !commandIFace.validateInput()) {
			System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
			return;
		}
		
		CommandOutput output = commandIFace.executeCommand();

		System.out.print(output.toPrettyString());
	}
	
	@Test
	public void removeNodeFilterTest() throws Exception {
		//String localzookeeperAddresses = "localhost:5181";
		String [] args = new String [] {"node", "remove", "-"+NodeRemoveCommand.ZK_CONNECTSTRING, zookeeperAddresses, "-filter", "[ip==*.11]", "-force", "true"};

		ProcessedInput input = new ProcessedInput(args);
		CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);

		if ( commandIFace == null ) {
			LOG.error("Could not find Interface for a command: " + input.getCommandName());
			// print usage
			System.out.print(CLICommandFactory.getInstance().getUsage(false));
			return;
		}
		
		if ( !commandIFace.validateInput()) {
			System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
			return;
		}
		
		CommandOutput output = commandIFace.executeCommand();

	}
}
